header{* Hermitean matrices *}
theory HermiteanMatrices
imports UnitaryMatrices
begin

text{* Hermitean matrices *}
definition hermitean :: "complex_mat \<Rightarrow> bool" where
 "hermitean A \<longleftrightarrow> mat_adj A = A"

lemma "hermitean A \<longleftrightarrow> mat_transpose A = mat_cnj A"
unfolding hermitean_def
by (cases A) (auto simp add: mat_adj_def mat_cnj_def)

lemma hermitean_mat_cnj: "hermitean H \<longleftrightarrow> hermitean (mat_cnj H)"
by (cases H) (auto simp add:  hermitean_def mat_adj_def mat_cnj_def)

lemma hermitean_mult_real:
  assumes "hermitean H"
  shows "hermitean ((cor k) *\<^sub>s\<^sub>m H)"
using assms
unfolding hermitean_def
by simp

lemma hermitean_congruence:
  assumes "hermitean H"
  shows "hermitean (congruence M H)"
using assms
unfolding hermitean_def
by (auto simp add: mult_mm_assoc)

lemma hermitean_elems:
  assumes "hermitean (A, B, C, D)"
  shows "is_real A" "is_real D" "B = cnj C" "cnj B = C"
using assms eq_cnj_iff_real[of A] eq_cnj_iff_real[of D]
by (auto simp add: hermitean_def mat_adj_def mat_cnj_def)

lemma mat_det_hermitean_real:
  assumes "hermitean A"
  shows "is_real (mat_det A)"
using assms
unfolding hermitean_def
by (cases A, auto simp add: mat_adj_def mat_cnj_def) (metis add_0_iff eq_cnj_iff_real mult_eq_0_iff)

lemma Re_det_sgn_congruence:
  assumes "hermitean H" "mat_det M \<noteq> 0"
  shows "sgn (Re (mat_det (congruence M H))) = sgn (Re (mat_det H))"
proof-
  have *: "mat_det (mat_adj M *\<^sub>m\<^sub>m H *\<^sub>m\<^sub>m M) = 
    (cor ((cmod (mat_det M))\<^sup>2)) * mat_det H"
    using complex_mult_cnj_cmod[of "mat_det M"]
    by (auto simp add: mat_det_adj field_simps)
  have *: "Re (mat_det (mat_adj M *\<^sub>m\<^sub>m H *\<^sub>m\<^sub>m M)) = 
    (cmod (mat_det M))\<^sup>2 * Re (mat_det H)"
    by (subst *, subst Re_mult_real, rule is_real_complex_of_real) (subst Re_complex_of_real, simp)
  show ?thesis
    using assms
    by (subst *) (auto simp add: sgn_mult)
qed

lemma det_sgn_congruence:
  assumes "hermitean H" "mat_det M \<noteq> 0"
  shows "sgn (mat_det (congruence M H)) = sgn (mat_det H)"
proof-
  have *: "mat_det (mat_adj M *\<^sub>m\<^sub>m H *\<^sub>m\<^sub>m M) = 
    (cor ((cmod (mat_det M))\<^sup>2)) * mat_det H"
    using complex_mult_cnj_cmod[of "mat_det M"]
    by (auto simp add: mat_det_adj field_simps)
  thus ?thesis
    using assms
    by (subst *, auto simp add: sgn_mult power2_eq_square) (smt mult_eq_0_iff norm_divide norm_mult norm_sgn of_real_1 of_real_divide of_real_mult sgn_eq times_divide_times_eq)
qed

lemma bilinear_form_hermitean_commute:
  assumes "hermitean H"
  shows "bilinear_form v1 v2 H = cnj (bilinear_form v2 v1 H)"
proof-
  have "v2 *\<^sub>v\<^sub>m mat_cnj H *\<^sub>v\<^sub>v vec_cnj v1 = vec_cnj v1 *\<^sub>v\<^sub>v (mat_adj H *\<^sub>m\<^sub>v v2)"
    by (subst mult_vv_commute, subst mult_mv_mult_vm, simp add: mat_adj_def mat_transpose_mat_cnj)
  also
  have "\<dots> = bilinear_form v1 v2 H"
    using assms
    by (simp add: mult_vv_mv hermitean_def)
  finally
  show ?thesis
    by (simp add: cnj_mult_vv vec_cnj_mult_vm)
qed

lemma quad_form_hermitean_real:
  assumes "hermitean H"
  shows "is_real (quad_form z H)"
using assms
by (subst eq_cnj_iff_real[symmetric])  (simp del: quad_form_def add: hermitean_def)

text{* Eigenvalues, eigenvectors and diagonalization of Hermitean matrices *}
lemma hermitean_eigenval_real:
  assumes "hermitean H" "eigenval k H"
  shows "is_real k"
proof-
  from assms obtain v where "v \<noteq> vec_zero" "H *\<^sub>m\<^sub>v v = k *\<^sub>s\<^sub>v v"
    unfolding eigenval_def
    by blast
  have "k * (v *\<^sub>v\<^sub>v vec_cnj v) = (k *\<^sub>s\<^sub>v v) *\<^sub>v\<^sub>v (vec_cnj v)"
    by (simp add: mult_vv_scale_sv1)
  also have "... = (H *\<^sub>m\<^sub>v v) *\<^sub>v\<^sub>v (vec_cnj v)"
    using `H *\<^sub>m\<^sub>v v = k *\<^sub>s\<^sub>v v`
    by simp
  also have "... =  v *\<^sub>v\<^sub>v (mat_transpose H *\<^sub>m\<^sub>v (vec_cnj v))"
    by (simp add: mult_mv_vv)
  also have "... = v *\<^sub>v\<^sub>v (vec_cnj (mat_cnj (mat_transpose H) *\<^sub>m\<^sub>v v))"
    by (simp add: vec_cnj_mult_mv)
  also have "... = v *\<^sub>v\<^sub>v (vec_cnj (H *\<^sub>m\<^sub>v v))"
    using `hermitean H`
    by (simp add: hermitean_def mat_adj_def)
  also have "... = v *\<^sub>v\<^sub>v (vec_cnj (k *\<^sub>s\<^sub>v v))"
    using `H *\<^sub>m\<^sub>v v = k *\<^sub>s\<^sub>v v`
    by simp
  finally have "k * (v *\<^sub>v\<^sub>v vec_cnj v) = cnj k * (v *\<^sub>v\<^sub>v vec_cnj v)"
    by (simp add: mult_vv_scale_sv2)
  hence "k = cnj k"
    using `v \<noteq> vec_zero`
    using scalsquare_vv_zero[of v]
    by (simp add: mult_vv_commute)
  thus ?thesis
    by (metis eq_cnj_iff_real)
qed

lemma hermitean_distinct_eigenvals:
  assumes "hermitean H"
  shows "(\<exists> k\<^sub>1 k\<^sub>2. k\<^sub>1 \<noteq> k\<^sub>2 \<and> eigenval k\<^sub>1 H \<and> eigenval k\<^sub>2 H) \<or> mat_diagonal H"
proof-
  obtain A B C D where HH: "H = (A, B, C, D)"
    by (cases H) auto
  show ?thesis
  proof (cases "B = 0")
    case True
    thus ?thesis
      using `hermitean H` hermitean_elems[of A B C D] HH
      by auto
  next
    case False
    have "(mat_trace H)\<^sup>2 \<noteq> 4 * mat_det H"
    proof (rule ccontr)
      have "C = cnj B" "is_real A" "is_real D"
        using hermitean_elems HH `hermitean H`
        by auto
      assume "\<not> ?thesis"
      hence "(A + D)\<^sup>2 = 4*(A*D - B*C)"
        using HH
        by auto
      hence "(A - D)\<^sup>2 = - 4*B*cnj B"
        using `C = cnj B`
        by (auto simp add: power2_eq_square field_simps) algebra
      hence "(A - D)\<^sup>2 / cor ((cmod B)\<^sup>2) = -4"
        using `B \<noteq> 0` complex_mult_cnj_cmod[of B]
        by (auto simp add: field_simps)
      hence "(Re A - Re D)\<^sup>2 / (cmod B)\<^sup>2 = -4"
        using `is_real A` `is_real D` `B \<noteq> 0`
        using Re_divide_real[of "cor ((cmod B)\<^sup>2)" "(A - D)\<^sup>2"]
        by (auto simp add: power2_eq_square)
      thus False
        by (metis abs_neg_numeral abs_power2 neg_numeral_neq_numeral power_divide)
    qed
    show ?thesis
      apply (rule disjI1)
      apply (subst eigen_equation)+
      using complex_quadratic_two_solutions[of "-mat_trace H" "mat_det H"] `(mat_trace H)\<^sup>2 \<noteq> 4 * mat_det H`
      apply auto
      apply (rule_tac x="k\<^sub>1" in exI, rule_tac x="k\<^sub>2" in exI)
      apply (simp add: complex_diff_def)
      done
  qed
qed

lemma hermitean_ortho_eigenvecs:
  assumes "hermitean H"
  assumes "eigenpair k1 v1 H" "eigenpair k2 v2 H" "k1 \<noteq> k2"
  shows "vec_cnj v2 *\<^sub>v\<^sub>v v1 = 0" "vec_cnj v1 *\<^sub>v\<^sub>v v2 = 0"
proof-
  from assms
  have "v1 \<noteq> vec_zero" "H *\<^sub>m\<^sub>v v1 = k1 *\<^sub>s\<^sub>v v1" 
       "v2 \<noteq> vec_zero" "H *\<^sub>m\<^sub>v v2 = k2 *\<^sub>s\<^sub>v v2"
    unfolding eigenpair_def
    by auto
  have real_k: "is_real k1" "is_real k2"
    using assms
    using hermitean_eigenval_real[of H k1]
    using hermitean_eigenval_real[of H k2]
    unfolding eigenpair_def eigenval_def
    by blast+
    
  have "vec_cnj (H *\<^sub>m\<^sub>v v2) = vec_cnj (k2 *\<^sub>s\<^sub>v v2)"
    using `H *\<^sub>m\<^sub>v v2 = k2 *\<^sub>s\<^sub>v v2`
    by auto
  hence "vec_cnj v2 *\<^sub>v\<^sub>m H  = k2 *\<^sub>s\<^sub>v vec_cnj v2"
    using `hermitean H` real_k eq_cnj_iff_real[of k1] eq_cnj_iff_real[of k2]
    unfolding hermitean_def
    by (cases H, cases v2) (auto simp add: mat_adj_def mat_cnj_def vec_cnj_def complex_cnj)
  have "k2 * (vec_cnj v2 *\<^sub>v\<^sub>v v1) = k1 * (vec_cnj v2 *\<^sub>v\<^sub>v v1)"
    using `H *\<^sub>m\<^sub>v v1 = k1 *\<^sub>s\<^sub>v v1`
    using `vec_cnj v2 *\<^sub>v\<^sub>m H  = k2 *\<^sub>s\<^sub>v vec_cnj v2`
    by (cases v1, cases v2, cases H) (auto simp add: vec_cnj_def field_simps, algebra)
  thus "vec_cnj v2 *\<^sub>v\<^sub>v v1 = 0"
    using `k1 \<noteq> k2`
    by simp
  hence "cnj (vec_cnj v2 *\<^sub>v\<^sub>v v1) = 0"
    by simp
  thus "vec_cnj v1 *\<^sub>v\<^sub>v v2 = 0"
    by (simp add: cnj_mult_vv mult_vv_commute)
qed

lemma hermitean_diagonizable:
  assumes "hermitean H"
  shows "\<exists> k1 k2 M. mat_det M \<noteq> 0 \<and> unitary M \<and> congruence M H = (k1, 0, 0, k2) \<and> 
                    is_real k1 \<and> is_real k2 \<and> sgn (Re k1 * Re k2) = sgn (Re (mat_det H))"
proof-
  from assms 
  have "(\<exists>k\<^sub>1 k\<^sub>2. k\<^sub>1 \<noteq> k\<^sub>2 \<and> eigenval k\<^sub>1 H \<and> eigenval k\<^sub>2 H) \<or> mat_diagonal H"
    using hermitean_distinct_eigenvals[of H]
    by simp
  thus ?thesis
  proof
    assume "\<exists>k\<^sub>1 k\<^sub>2. k\<^sub>1 \<noteq> k\<^sub>2 \<and> eigenval k\<^sub>1 H \<and> eigenval k\<^sub>2 H"
    then  obtain k1 k2 where  "k1 \<noteq> k2" "eigenval k1 H" "eigenval k2 H"
      using hermitean_distinct_eigenvals
      by blast
    then obtain v1 v2 where "eigenpair k1 v1 H" "eigenpair k2 v2 H"
      "v1 \<noteq> vec_zero" "v2 \<noteq> vec_zero"
      unfolding eigenval_def eigenpair_def
      by blast
    hence *: "vec_cnj v2 *\<^sub>v\<^sub>v v1 = 0" "vec_cnj v1 *\<^sub>v\<^sub>v v2 = 0"
      using `k1 \<noteq> k2` hermitean_ortho_eigenvecs `hermitean H`
      by auto
    obtain v11 v12 v21 v22 where vv: "v1 = (v11, v12)" "v2 = (v21, v22)"
      by  (cases v1, cases v2) auto
    let ?nv1' = "vec_cnj v1 *\<^sub>v\<^sub>v v1" and ?nv2' = "vec_cnj v2 *\<^sub>v\<^sub>v v2"
    let ?nv1 = "cor (sqrt (Re ?nv1'))"
    let ?nv2 = "cor (sqrt (Re ?nv2'))"
    have "?nv1' \<noteq> 0"  "?nv2' \<noteq> 0"
      using `v1 \<noteq> vec_zero` `v2 \<noteq> vec_zero` vv
      by (simp add: scalsquare_vv_zero)+
    moreover
    have "is_real ?nv1'" "is_real ?nv2'"
      using vv
      by (auto simp add: vec_cnj_def)
    ultimately
    have "?nv1 \<noteq> 0"  "?nv2 \<noteq> 0"
      by - (cases "?nv1'", cases "?nv2'", auto)+
    have "Re (?nv1') \<ge> 0"  "Re (?nv2') \<ge> 0"
      using vv
      by (auto simp add: vec_cnj_def)
    obtain nv1 nv2 where "nv1 = ?nv1" "nv1 \<noteq> 0"  "nv2 = ?nv2" "nv2 \<noteq> 0"
      using `?nv1 \<noteq> 0`  `?nv2 \<noteq> 0`
      by auto
    let ?M = "(1/nv1 * v11, 1/nv2 * v21, 1/nv1 * v12, 1/nv2 * v22)"

    have "is_real k1" "is_real k2"
      using  `eigenval k1 H` `eigenval k2 H` `hermitean H`
      by (auto simp add: hermitean_eigenval_real)
    moreover
    have "mat_det ?M \<noteq> 0"
    proof (rule ccontr)
      assume "\<not> ?thesis"
      hence "v11 * v22 = v12 * v21"
        using `nv1 \<noteq> 0` `nv2 \<noteq> 0` 
        by (auto simp add: field_simps)
      hence "\<exists> k. k \<noteq> 0 \<and> v2 = k *\<^sub>s\<^sub>v v1"
        using vv `v1 \<noteq> vec_zero` `v2 \<noteq> vec_zero`
        apply auto
        apply (rule_tac x="v21/v11" in exI, force simp add: field_simps)
        apply (rule_tac x="v21/v11" in exI, force simp add: field_simps)
        apply (rule_tac x="v22/v12" in exI, force simp add: field_simps)
        apply (rule_tac x="v22/v12" in exI, force simp add: field_simps)
        done
      thus False
        using `vec_cnj v1 *\<^sub>v\<^sub>v v2 = 0` vv `?nv1' \<noteq> 0`
        by (auto simp add: vec_cnj_def field_simps) (metis comm_semiring_1_class.normalizing_semiring_rules(34) mult_eq_0_iff)
    qed
    moreover
    have "unitary ?M"
    proof-
      have **: "cnj nv1 * nv1 = ?nv1'"  "cnj nv2 * nv2 = ?nv2'"
        using `nv1 = ?nv1` `nv1 \<noteq> 0`  `nv2 = ?nv2` `nv2 \<noteq> 0` `is_real ?nv1'` `is_real ?nv2'`
        using `Re (?nv1') \<ge> 0`  `Re (?nv2') \<ge> 0`
        by (auto simp add: complex_of_real_Re)
      have ***: "cnj nv1 * nv2 \<noteq> 0"  "cnj nv2 * nv1 \<noteq> 0"
        using vv `nv1 = ?nv1` `nv1 \<noteq> 0`  `nv2 = ?nv2` `nv2 \<noteq> 0` `is_real ?nv1'` `is_real ?nv2'`
        by auto
    
      show ?thesis
        unfolding unitary_def
        using vv ** `?nv1' \<noteq> 0` `?nv2' \<noteq> 0` * ***
        apply (auto simp add: mat_adj_def mat_cnj_def vec_cnj_def complex_cnj)
        apply (metis add_divide_distrib divide_self_if)
        apply (metis add_divide_distrib divide_zero_left)
        apply (metis add_divide_distrib divide_zero_left)
        apply (metis add_divide_distrib divide_self_if)
        done
    qed
    moreover
    have "congruence ?M H = (k1, 0, 0, k2)"
    proof-
      have "mat_inv ?M *\<^sub>m\<^sub>m H *\<^sub>m\<^sub>m ?M = (k1, 0, 0, k2)"
      proof-
        have *: "H *\<^sub>m\<^sub>m ?M = ?M *\<^sub>m\<^sub>m (k1, 0, 0, k2)"
          using `eigenpair k1 v1 H` `eigenpair k2 v2 H` vv `?nv1 \<noteq> 0` `?nv2 \<noteq> 0`
          unfolding eigenpair_def
          apply (cases H)
          apply (auto simp add: vec_cnj_def)
          apply (metis add_divide_distrib mult.commute)+
          done
        show ?thesis
          using mult_mm_inv_l[of ?M "(k1, 0, 0, k2)" "H *\<^sub>m\<^sub>m ?M", OF `mat_det ?M \<noteq> 0` *[symmetric], symmetric]
          by (simp add: mult_mm_assoc)
      qed
      moreover
      have "mat_inv ?M = mat_adj ?M"
        using `mat_det ?M \<noteq> 0` `unitary ?M` mult_mm_inv_r[of ?M "mat_adj ?M" eye]
        by (simp add: unitary_def)
      ultimately
      show ?thesis
        by simp
    qed
    moreover
    have "sgn (Re k1 * Re k2) = sgn (Re (mat_det H))"
      using `congruence ?M H = (k1, 0, 0, k2)` `is_real k1` `is_real k2`
      using Re_det_sgn_congruence[of H ?M] `mat_det ?M \<noteq> 0` `hermitean H`
      by simp
    ultimately
    show ?thesis
      by (rule_tac x="k1" in exI, rule_tac x="k2" in exI, rule_tac x="?M" in exI) simp
  next
    assume "mat_diagonal H"
    then obtain A D where "H = (A, 0, 0, D)"
      by (cases H) auto
    moreover
    hence "is_real A" "is_real D"
      using `hermitean H` hermitean_elems[of A 0 0 D]
      by auto
    ultimately
    show ?thesis
      by (rule_tac x="A" in exI, rule_tac x="D" in exI, rule_tac x="eye" in exI) (simp add: unitary_def mat_adj_def mat_cnj_def)
  qed
qed

end