header{* More about complex numbers *}
theory MoreComplex
imports Complex_Main
begin 
(* -------------------------------------------------------------------------- *)
(* TODO: move somewhere *)

lemma mult_pow2_lt0:
  assumes "b \<noteq> 0"
  shows "a < 0 \<longleftrightarrow> b\<^sup>2 * a < (0::real)"
using assms
by (metis mult.commute mult_eq_0_iff mult_neg_pos mult_pos_pos not_less_iff_gr_or_eq not_real_square_gt_zero power2_eq_square)

lemma mult_pow2_gt0:
  assumes "b \<noteq> 0"
  shows "a > 0 \<longleftrightarrow> b\<^sup>2 * a > (0::real)"
using assms
by (metis mult.commute mult_eq_0_iff mult_neg_pos mult_pos_pos not_less_iff_gr_or_eq not_real_square_gt_zero power2_eq_square)

lemma square_cancel:
  assumes "a\<^sup>2 \<ge> b\<^sup>2" "a \<ge> 0" "b \<ge> (0::real)"
  shows "a \<ge> b"
using real_sqrt_le_iff[of "b\<^sup>2" "a\<^sup>2"]
using assms
by auto

(* -------------------------------------------------------------------------- *)

lemmas complex_cnj = complex_cnj_diff complex_cnj_mult complex_cnj_add complex_cnj_divide complex_cnj_minus

abbreviation "cor \<equiv> complex_of_real"

lemma [simp]: "cor -1 = -1"
by (simp add: of_real_neg_numeral)

lemma [simp]: "- cor -1 = 1"
by simp

lemma rcis_cnj: "cnj a = rcis (cmod a) (- arg a)"
by (subst rcis_cmod_arg[of a, symmetric]) (simp add: complex_cnj cis_def rcis_def)

lemma cmod_cis [simp]: 
  assumes "a \<noteq> 0"
  shows "cor (cmod a) * cis (arg a) = a"
using assms
by (metis rcis_cmod_arg rcis_def) 

lemma cis_cmod [simp]: 
  assumes "a \<noteq> 0"
  shows "cis (arg a) * cor (cmod a) = a"
using assms cmod_cis[of a]
by (simp add: field_simps)

lemma cor_squared: "(cor x)\<^sup>2 = cor (x\<^sup>2)"
by (simp add: power2_eq_square)

lemma cor_add: "cor (a + b) = cor a + cor b"
by auto

lemma cor_mult: "cor (a * b) = cor a * cor b"
by auto

lemma cor_sqrt_mult_cor_sqrt [simp]:
  shows "cor (sqrt A) * cor (sqrt A) = cor \<bar>A\<bar>"
using assms
by (metis cor_mult real_sqrt_abs2 real_sqrt_mult_distrib2)

(* -------------------------------------------------------------------------- *)
 
lemma [simp]: "(Complex a b) * 2 = Complex (2*a) (2*b)"
by (metis complex_add mult_2 mult_2_right)

lemma re_complex:
  "Complex (Re z) 0 = (z + cnj z)/2"
by (cases z) simp

lemma im_complex:
  "Complex 0 (Im z) = (z - cnj z)/2"
by (cases z) simp

lemma Complex_scale1: "Complex (a * b) (a * c) = cor a * Complex b c"
unfolding complex_of_real_def
by auto

lemma Complex_scale2: "Complex (a * c) (b * c) = Complex a b * cor c"
unfolding complex_of_real_def
by auto

lemma Complex_scale3: "Complex (a / b) (a / c) = cor a * Complex (1 / b) (1 / c)"
unfolding complex_of_real_def
by auto

lemma Complex_scale4: "c \<noteq> 0 \<Longrightarrow> Complex (a / c) (b / c) = Complex a b / cor c"
unfolding complex_of_real_def
by (auto simp add: field_simps)

(* ---------------------------- cmod ---------------------------------------- *)

lemma complex_mult_cnj_cmod:
  "z * cnj z = cor ((cmod z)\<^sup>2)"
by (cases z) (simp add: complex_of_real_def, simp add: power2_eq_square)

lemma
  cmod_square: "(cmod z)\<^sup>2 = Re (z * cnj z)"
using complex_mult_cnj_cmod[of z]
by (simp add: power2_eq_square)

lemma cnjE:
  assumes "x \<noteq> 0"
  shows "cnj x = cor ((cmod x)\<^sup>2) / x"
using complex_mult_cnj_cmod[of x] assms
by (auto simp add: field_simps)

lemma cmod_mult [simp]: "cmod (a * b) = cmod a * cmod b"
unfolding cmod_def
by (metis complex_norm_def norm_mult)

lemma cmod_divide [simp]: "cmod (a / b) = cmod a / cmod b"
unfolding cmod_def
by (metis complex_norm_def norm_divide)

lemma [simp]: "cmod (z / cor k) = cmod z / \<bar>k\<bar>"
by auto

lemma [simp]: "cmod (z*z1 - z*z2) = cmod z*cmod(z1 - z2)"
by (metis bounded_bilinear.diff_right bounded_bilinear_mult cmod_mult)

lemma cmod_eqI:
  assumes "z1 * cnj z1 = z2 * cnj z2"
  shows "cmod z1 = cmod z2"
using assms
by (subst complex_mod_sqrt_Re_mult_cnj)+ auto

lemma cmod_eqE:
  assumes "cmod z1 = cmod z2"
  shows "z1 * cnj z1 = z2 * cnj z2"
proof-
  from assms have "cor ((cmod z1)\<^sup>2) = cor ((cmod z2)\<^sup>2)"
    by auto
  thus ?thesis
    using complex_mult_cnj_cmod
    by auto
qed

lemma [simp]: "cmod a = 1 \<longleftrightarrow> a*cnj a = 1"
by (metis cmod_eqE cmod_eqI complex_cnj_one monoid_mult_class.mult.left_neutral norm_one)


(* ----------------------- is_real ------------------------------------------ *)
abbreviation is_real where
 "is_real z \<equiv> Im z = 0"

lemma complex_eq_if_Re_eq:
  assumes "is_real z1" "is_real z2"
  shows "z1 = z2 \<longleftrightarrow> Re z1 = Re z2"
using assms
by (cases z1, cases z2) auto

lemma mult_reals:
  assumes "is_real a" "is_real b"
  shows "is_real (a * b)"
using assms
by auto

lemma div_reals:
  assumes "is_real a" "is_real b"
  shows "is_real (a / b)"
using assms
by (simp add: divide_inverse complex_inverse_def)

lemma complex_of_real_Re:
  assumes "is_real k"
  shows "cor (Re k) = k"
using assms
by (cases k) (auto simp add: complex_of_real_def)

lemma is_real_complex_of_real:
  "is_real (cor x)"
by auto

lemma cor_cmod_real:
  assumes "is_real a"
  shows "cor (cmod a) = a \<or> cor (cmod a) = -a"
using assms
unfolding cmod_def
by (cases "Re a > 0") (auto, (metis complex_of_real_Re)+)

lemma eq_cnj_iff_real: 
  "z = cnj z \<longleftrightarrow> is_real z"
by (cases z) auto

lemma Re_divide_real:
  assumes "is_real b" "b \<noteq> 0"
  shows "Re (a / b) = (Re a) / (Re b)"
using assms
unfolding complex_divide_def
by (cases "a", cases "b") (auto simp add: field_simps power2_eq_square)

lemma Re_mult_real:
  assumes "is_real a"
  shows "Re (a * b) = (Re a) * (Re b)"
using assms
by auto

lemma Im_mult_real:
  assumes "is_real a"
  shows "Im (a * b) = (Re a) * (Im b)"
using assms
by auto

lemma Im_divide_real:
  assumes "is_real b" "b \<noteq> 0"
  shows "Im (a / b) = (Im a) / (Re b)"
using assms
by (cases "a", cases "b") (auto simp add: complex_divide_def field_simps power2_eq_square)

lemma [simp]: "Re (x / 2) = Re x / 2"
  using Re_divide_real[of "2" x]
  by simp

lemma [simp]: "Re (2 * x) = 2 * Re x"
  using Re_mult_real[of "2" x]
  by simp
    
lemma Re_sgn:
  assumes "is_real R"
  shows "Re (sgn R) = sgn (Re R)"
using assms
by (metis Re_sgn complex_of_real_Re norm_of_real real_sgn_eq)

(* -------------------------------- rot90 ----------------------------------- *)
abbreviation rot90 where 
  "rot90 z \<equiv> Complex (-Im z) (Re z)"

lemma rot90_ii: "rot90 z = z * ii"
by (cases z) simp

(* ---------------------cnj_mix, scalprod ----------------------------------- *)

abbreviation cnj_mix where
  "cnj_mix z1 z2 \<equiv> cnj z1 * z2 + z1 * cnj z2"
 
lemma cnj_mix_minus:
  shows "cnj z1*z2 - z1*cnj z2 = ii * cnj_mix (rot90 z1) z2"
using assms
by (cases z1, cases z2) simp 

lemma cnj_mix_minus':
  shows "cnj z1*z2 - z1*cnj z2 = rot90 (cnj_mix (rot90 z1) z2)"
using assms
by (cases z1, cases z2) simp

lemma cnj_mix_real: 
  "is_real (cnj_mix z1 z2) "
by (cases z1, cases z2) simp

abbreviation scalprod where
  "scalprod z1 z2 \<equiv> cnj_mix z1 z2 / 2"

(* ----------------------------- sin, cos ----------------------------------- *)

lemma cos_periodic_pi2:  "cos (pi + x) = - cos x"
  using cos_periodic_pi[of x]
  by (simp add: field_simps)

lemma cos_periodic_pi3: "cos (x - pi) = - cos x"
  by (smt cos_periodic_pi)

lemma cos_periodic_4 [simp]: "cos (pi - x) = - cos x"
by (metis cos_minus cos_periodic_pi2 minus_real_def)

lemma sin_periodic_pi3: "sin (x - pi) = - sin x"
  by (smt sin_periodic_pi)

lemma cos_lt_zero:
  assumes "x > pi/2" "x \<le> pi"
  shows "cos x < 0"
  using cos_gt_zero_pi[of "pi - x"] assms
  by simp

lemma sin_kpi:
  fixes k::int
  shows "sin (real k * pi) = 0"
using sin_npi[of "nat k"]
using sin_npi[of "nat (-k)"]
by (cases "k \<ge> 0") auto

lemma cos_kpi_odd:
  fixes k::int
  assumes "odd k"
  shows "cos (real k * pi) = -1"
proof (cases "k \<ge> 0")
  case True
  hence "odd (nat k)"
    using  `odd k`
    by (metis pos_int_even_equiv_nat_even)
  thus ?thesis
    using `k \<ge> 0` cos_npi[of "nat k"]
    by auto
next
  case False
  hence "-k \<ge> 0" "odd (nat (-k))"
    using `odd k`
    by (auto, smt even_neg pos_int_even_equiv_nat_even)
  thus ?thesis
    using cos_npi[of "nat (-k)"]
    by auto
qed

lemma cos_kpi_even:
  fixes k::int
  assumes "even k"
  shows "cos (real k * pi) = 1"
proof (cases "k \<ge> 0")
  case True
  hence "even (nat k)"
    using  `even k`
    by (metis pos_int_even_equiv_nat_even)
  thus ?thesis
    using `k \<ge> 0` cos_npi[of "nat k"]
    by auto
next
  case False
  hence "-k \<ge> 0" "even (nat (-k))"
    using `even k`
    by (auto, smt even_neg pos_int_even_equiv_nat_even)
  thus ?thesis
    using  cos_npi[of "nat (-k)"]
    by auto
qed

lemma sin_pi2_kpi_odd:
  fixes k::int
  assumes "odd k"
  shows "sin (pi / 2 + real k * pi) = -1"
using assms
by (simp add: sin_add cos_kpi_odd)

lemma sin_pi2_kpi_even:
  fixes k::int
  assumes "even k"
  shows "sin (pi / 2 + real k * pi) = 1"
using assms
by (simp add: sin_add cos_kpi_even)

lemma cos_zero_iff_int:
  shows "cos x = 0 \<longleftrightarrow> (\<exists>k::int. odd k \<and> x = real k * (pi / 2))"
proof
  assume "cos x = 0"
  then obtain n::nat where *: "x = real n * (pi / 2) \<or> x = - (real n * (pi / 2))" and "odd n"
    using cos_zero_iff[of x]
    by blast
  hence "(odd (int n) \<and> x = real (int n) * (pi / 2)) \<or> (odd (-int n) \<and> x = real (- int n) * pi / 2)"
    by (auto simp add: Parity.transfer_int_nat_relations)
  thus "\<exists>k::int. odd k \<and> x = real k * (pi / 2)"
    by (metis times_divide_eq_right)
next
  assume "\<exists>k::int. odd k \<and> x = real k * (pi / 2)"
  then obtain k::int where *: "odd k" "x = real k * (pi / 2)"
    by blast
  show "cos x = 0"
  proof (cases "k \<ge> 0")
    case True
    hence "\<exists>n::nat. odd n \<and> x = real n * (pi / 2)"
      using *
      by (rule_tac x="nat k" in exI) (auto simp add: pos_int_even_equiv_nat_even)
    thus ?thesis
      using cos_zero_iff[of x]
      by auto
  next
    case False
    hence "\<exists>n::nat. odd n \<and> x = - (real n * (pi / 2))"
      using *
      by (rule_tac x="nat (-k)" in exI, auto) (smt even_neg pos_int_even_equiv_nat_even)
    thus ?thesis
      using cos_zero_iff[of x]
      by auto
  qed
qed

lemma sin_zero_iff_int: 
  "sin x = 0 \<longleftrightarrow> (\<exists>k::int. even k \<and> x = real k * (pi / 2))"
proof-
  have "sin x = 0 \<longleftrightarrow> cos (x - pi/2) = 0"
    using cos_minus[of "x - pi/2"]
    by (simp add: sin_cos_eq)
  hence "sin x = 0 \<longleftrightarrow> (\<exists>k::int. odd k \<and> x - pi/2 = real k * (pi / 2))"
    using cos_zero_iff_int
    by simp
  thus ?thesis
    by auto (rule_tac x="k+1" in exI, simp add: field_simps, rule_tac x="k-(1::int)" in exI, simp add: field_simps)
qed

lemma cos0_sin1:
  assumes "cos \<phi> = 0" "sin \<phi> = 1"
  shows "\<exists> k::int. \<phi> = pi/2 + 2*k*pi"
proof-
  from `cos \<phi> = 0`
  obtain k::int where "odd k" "\<phi> = real k * (pi / 2)"
    using cos_zero_iff_int[of "\<phi>"]
    by auto
  then obtain k'::int where "k = 2*k' + 1"
    by (metis odd_equiv_def)
  hence "\<phi> = pi/2 + (real k' * pi)"
    using `\<phi> = real k * (pi / 2)`
    by (auto simp add: field_simps)
  hence "even k'"
    using `sin \<phi> = 1` sin_pi2_kpi_odd[of k']
    by auto
  thus ?thesis
    using `\<phi> = pi /2 + (real k' * pi)`
    unfolding even_def
    by auto
qed

lemma cos_0_iff_normalized:
  assumes "cos \<phi> = 0" "-pi < \<phi>" "\<phi> \<le> pi"
  shows "\<phi> = pi/2 \<or> \<phi> = -pi/2"
proof-
  obtain k::int where "odd k" "\<phi> = real k * pi/2"
    using cos_zero_iff_int[of \<phi>] assms(1)
    by auto
  thus ?thesis
  proof (cases "k > 1 \<or> k < -1")
    case True
    hence "k \<ge> 3 \<or> k \<le> -3"
      using `odd k`
      by auto (smt odd_one_int odd_plus_odd, smt odd_one_int odd_plus_even odd_plus_odd)
    hence "\<phi> \<ge> 3*pi/2 \<or> \<phi> \<le> -3*pi/2" 
      using `\<phi> = real k * pi/2`
      by auto
    thus ?thesis
      using `- pi < \<phi>` `\<phi> \<le> pi`
      by auto
  next
    case False
    hence "k = -1 \<or> k = 0 \<or> k = 1"
      by auto
    hence "k = -1 \<or> k = 1"
      using `odd k`
      by auto
    thus ?thesis
      using `\<phi> = real k * pi/2`
      by auto
  qed
qed

lemma sin_0_iff_normalized:
  assumes "sin \<phi> = 0" "-pi < \<phi>" "\<phi> \<le> pi"
  shows "\<phi> = 0 \<or> \<phi> = pi"
proof-
  obtain k::int where "even k" "\<phi> = real k * pi/2"
    using sin_zero_iff_int[of \<phi>] assms(1)
    by auto
  thus ?thesis
  proof (cases "k > 2 \<or> k < 0")
    case True
    hence "k \<ge> 4 \<or> k \<le> -2"
      using `even k`
      by auto (smt even_difference odd_one_int)+
    hence "\<phi> \<ge> 2*pi \<or> \<phi> \<le> -pi"
    proof
      assume "4 \<le> k"
      hence "4 * pi/2 \<le> \<phi>"
        by (subst `\<phi> = real k * pi/2`) auto
      thus ?thesis
        by simp
    next
      assume "k \<le> -2"
      hence "real k \<le> -2"
        by simp
      hence "-2*pi/2 \<ge> \<phi>"
        by (subst `\<phi> = real k * pi/2`, metis mult_right_mono pi_half_ge_zero times_divide_eq_right)
      thus ?thesis
        by simp
    qed
    thus ?thesis
      using `- pi < \<phi>` `\<phi> \<le> pi`
      by auto
  next
    case False
    hence "k = 0 \<or> k = 1 \<or> k = 2"
      by auto
    hence "k = 0 \<or> k = 2"
      using `even k`
      by auto
    thus ?thesis
      using `\<phi> = real k * pi/2`
      by auto
  qed
qed

lemma cos1_sin0:
  assumes "cos \<phi> = 1" "sin \<phi> = 0"
  shows "\<exists> k::int. \<phi> = 2*k*pi"
proof-
  from `sin \<phi> = 0`
  obtain k::int where "even k" "\<phi> = real k * (pi / 2)"
    using sin_zero_iff_int[of "\<phi>"]
    by auto
  then obtain k'::int where "k = 2*k'"
    by (metis even_equiv_def)
  hence "\<phi> = real k' * pi"
    using `\<phi> = real k * (pi / 2)`
    by (auto simp add: field_simps)
  hence "even k'"
    using `cos \<phi> = 1` cos_kpi_odd[of k']
    by auto
  thus ?thesis
    using `\<phi> = real k' * pi`
    unfolding even_def
    by auto
qed

(* TODO: add lemmas for cos = -1, sin = 0 and cos = 0, sin = -1 *)

lemma sin_cos_eq:
  fixes a b :: real
  assumes "cos a = cos b" "sin a = sin b" 
  shows "\<exists> k::int. a - b = 2*k*pi"
proof-
  from assms have "sin (a - b) = 0" "cos (a - b) = 1"
    using sin_diff[of a b] cos_diff[of a b]
    by auto
  thus ?thesis
    using cos1_sin0
    by auto
qed

lemma sin_monotone_2pi: assumes "- (pi / 2) \<le> y" and "y < x" and "x \<le> pi / 2" shows "sin y < sin x"
proof -
  have "0 \<le> y + pi / 2" and "y + pi / 2 < x + pi / 2" and "x + pi /2 \<le> pi"
    using pi_ge_two and assms by auto
  from cos_monotone_0_pi[OF this] show ?thesis unfolding minus_sin_cos_eq[symmetric] by auto
qed

lemma sin_inj:
  assumes "\<alpha> \<noteq> \<alpha>'" "-pi/2 \<le> \<alpha> \<and> \<alpha> \<le> pi/2" "-pi/2 \<le> \<alpha>' \<and> \<alpha>' \<le> pi/2"
  shows "sin \<alpha> \<noteq> sin \<alpha>'"
using assms
using sin_monotone_2pi[of \<alpha> \<alpha>'] sin_monotone_2pi[of \<alpha>' \<alpha>]
by (cases "\<alpha> < \<alpha>'") auto

lemma arccos_le_pi2:
  assumes "a \<ge> 0" "a \<le> 1"
  shows "arccos a \<le> pi/2"
using assms
by (smt antisym arccos_cos arccos_ubound cos_arccos cos_monotone_0_pi' cos_pi_half pi_half_ge_zero)

definition atan2 where
  "atan2 y x = 
    (if x > 0 then arctan (y/x)
     else if x < 0 then 
          if y > 0 then arctan (y/x) + pi else arctan (y/x) - pi 
     else
          if y > 0 then pi/2 else if y < 0 then -pi/2 else 0)"

lemma atan2_bounded: "-pi \<le> atan2 y x \<and> atan2 y x < pi"
  using arctan_bounded[of "y/x"] zero_le_arctan_iff[of "y/x"] arctan_le_zero_iff[of "y/x"] zero_less_arctan_iff[of "y/x"] arctan_less_zero_iff[of "y/x"]
  using divide_neg_neg[of y x] divide_neg_pos[of y x] divide_pos_pos[of y x]  divide_pos_neg[of y x]
  unfolding atan2_def
  by (simp (no_asm_simp)) auto

(* taken from /src/HOL/Decision_Procs/Approximation.thy -- should be in Transcendental.thy? *)
lemma cos_periodic_nat[simp]: fixes n :: nat shows "cos (x + n * (2 * pi)) = cos x"
proof (induct n arbitrary: x)
  case (Suc n)
  have split_pi_off: "x + (Suc n) * (2 * pi) = (x + n * (2 * pi)) + 2 * pi"
    unfolding Suc_eq_plus1 real_of_nat_add real_of_one distrib_right by auto
  show ?case unfolding split_pi_off using Suc by auto
qed auto

lemma cos_periodic_int[simp]: fixes i :: int shows "cos (x + i * (2 * pi)) = cos x"
proof (cases "0 \<le> i")
  case True hence i_nat: "real i = nat i" by auto
  show ?thesis unfolding i_nat by auto
next
  case False hence i_nat: "i = - real (nat (-i))" by auto
  have "cos x = cos (x + i * (2 * pi) - i * (2 * pi))" by auto
  also have "\<dots> = cos (x + i * (2 * pi))"
    unfolding i_nat mult_minus_left diff_minus_eq_add by (rule cos_periodic_nat)
  finally show ?thesis by auto
qed

(* end taken from *)

(* -------------- canonize any angle to (-pi, pi] -------------------------- *)

abbreviation canon_ang_P where
 "canon_ang_P \<alpha> \<alpha>' \<equiv> (-pi < \<alpha>' \<and> \<alpha>' \<le> pi) \<and> (\<exists> k::int. \<alpha> - \<alpha>' = 2*k*pi)"

definition canon_ang :: "real \<Rightarrow> real" ("\<downharpoonright>_\<downharpoonleft>") where
  "\<downharpoonright>\<alpha>\<downharpoonleft> = (THE \<alpha>'. canon_ang_P \<alpha> \<alpha>')"

lemma canon_ang_ex:  
  shows "\<exists> \<alpha>'. canon_ang_P \<alpha> \<alpha>'"
proof-
  have ***: "\<forall> \<alpha>::real. \<exists> \<alpha>'. 0 < \<alpha>' \<and> \<alpha>' \<le> 1 \<and> (\<exists> k::int. \<alpha>' = \<alpha> - k)"
  proof
    fix \<alpha>::real
    show "\<exists>\<alpha>'>0. \<alpha>' \<le> 1 \<and> (\<exists>k::int. \<alpha>' = \<alpha> - real k)"
    proof (cases "\<alpha> = floor \<alpha>")
      case True
      thus ?thesis
        by (rule_tac x="\<alpha> - floor \<alpha> + 1" in exI, auto) (rule_tac x="floor \<alpha> - 1" in exI, auto)
    next
      case False
      thus ?thesis
        using  real_of_int_floor_ge_diff_one[of "\<alpha>"]
        using real_of_int_floor_le[of "\<alpha>"]
        by (rule_tac x="\<alpha> - floor \<alpha>" in exI) (metis antisym diff_self floor_subtract le_cases le_iff_diff_le_0 less_int_code(1) not_leE zero_less_floor)
    qed
  qed

  have **: "\<forall> \<alpha>::real. \<exists> \<alpha>'. 0 < \<alpha>' \<and> \<alpha>' \<le> 2 \<and> (\<exists> k::int. \<alpha> - \<alpha>' = 2*k - 1)"
  proof
    fix \<alpha>::real
    from ***[rule_format, of "(\<alpha> + 1) /2"]
    obtain \<alpha>' and k::int where "0 < \<alpha>'" "\<alpha>' \<le> 1" "\<alpha>' = (\<alpha> + 1)/2 - k"
      by force
    hence "0 < \<alpha>'" "\<alpha>' \<le> 1" "\<alpha>' = \<alpha>/2 - k + 1/2"
      by auto
    thus "\<exists>\<alpha>'>0. \<alpha>' \<le> 2 \<and> (\<exists>k::int. \<alpha> - \<alpha>' = real (2 * k - 1))"
      by (rule_tac x="2*\<alpha>'" in exI) auto
  qed
  have *: "\<forall> \<alpha>::real. \<exists> \<alpha>'. -1 < \<alpha>' \<and> \<alpha>' \<le> 1 \<and> (\<exists> k::int. \<alpha> - \<alpha>' = 2*k)"
  proof
    fix \<alpha>::real
    from ** obtain \<alpha>' and k :: int where 
      "0 < \<alpha>' \<and> \<alpha>' \<le> 2 \<and> \<alpha> - \<alpha>' = 2*k - 1"
      by force
    thus "\<exists>\<alpha>'>-1. \<alpha>' \<le> 1 \<and> (\<exists>k. \<alpha> - \<alpha>' = real (2 * (k::int)))"
      by (rule_tac x="\<alpha>' - 1" in exI) (auto simp add: field_simps)
  qed
  show ?thesis
    using *[rule_format, of "\<alpha> / pi"]
    apply auto
    apply (rule_tac x="\<alpha>'*pi" in exI)
    by (auto simp add: field_simps) (metis mult.commute mult_minus1_right not_less pi_gt_zero real_mult_le_cancel_iff2)
qed

lemma canon_ang_unique:
  assumes "canon_ang_P \<alpha> \<alpha>'" "canon_ang_P \<alpha> \<alpha>''" 
  shows "\<alpha>' = \<alpha>''"
proof-
  obtain k1::int where "\<alpha> - \<alpha>' = 2*k1*pi"
    using assms(1)
    by auto
  obtain k2::int where "\<alpha> - \<alpha>'' = 2*k2*pi"
    using assms(2)
    by auto
  hence "-\<alpha>' + \<alpha>'' = 2*(k1 - k2)*pi"
    using `\<alpha> - \<alpha>' = 2*k1*pi`
    by (simp add:field_simps)
  moreover
  have "-\<alpha>' + \<alpha>'' < 2 * pi" "-\<alpha>' + \<alpha>'' > -2*pi"
    using assms
    by auto
  ultimately
  have "-\<alpha>' + \<alpha>'' = 0"
    by auto
  thus ?thesis
    by auto
qed

lemma canon_ang:
  (* "canon_ang_P \<downharpoonright>\<alpha>\<downharpoonleft>" *)
  "-pi < \<downharpoonright>\<alpha>\<downharpoonleft>" "\<downharpoonright>\<alpha>\<downharpoonleft> \<le> pi" "\<exists> k::int. \<alpha> - \<downharpoonright>\<alpha>\<downharpoonleft> = 2*k*pi"
proof-
  obtain \<alpha>' where "canon_ang_P \<alpha> \<alpha>'"
    using canon_ang_ex[of \<alpha>]
    by auto
  have "canon_ang_P \<alpha> \<downharpoonright>\<alpha>\<downharpoonleft>"
    unfolding canon_ang_def
  proof (rule theI[where a="\<alpha>'"])
    show "canon_ang_P \<alpha> \<alpha>'"
      by fact
  next
    fix \<alpha>''
    assume "canon_ang_P \<alpha> \<alpha>''"
    thus "\<alpha>'' = \<alpha>'"
      using `canon_ang_P \<alpha> \<alpha>'`
      using canon_ang_unique[of \<alpha>' \<alpha> \<alpha>'']
      by simp
  qed
  thus "-pi < \<downharpoonright>\<alpha>\<downharpoonleft>" "\<downharpoonright>\<alpha>\<downharpoonleft> \<le> pi" "\<exists> k::int. \<alpha> - \<downharpoonright>\<alpha>\<downharpoonleft> = 2*k*pi"
    by auto
qed

lemma canon_ang_id:
assumes  "-pi < \<alpha> \<and> \<alpha> \<le> pi"
  shows "\<downharpoonright>\<alpha>\<downharpoonleft> = \<alpha>"
  using assms
  using canon_ang_unique[of "canon_ang \<alpha>" \<alpha> \<alpha>] canon_ang[of \<alpha>]
  by auto

lemma canon_ang_eq:
  assumes "\<exists> k::int. \<alpha>' - \<alpha>'' = 2*k*pi"
  shows "\<downharpoonright>\<alpha>'\<downharpoonleft> = \<downharpoonright>\<alpha>''\<downharpoonleft>"
proof-
  obtain k'::int where *: "- pi < \<downharpoonright>\<alpha>'\<downharpoonleft>" "\<downharpoonright>\<alpha>'\<downharpoonleft> \<le> pi" "\<alpha>' - \<downharpoonright>\<alpha>'\<downharpoonleft> = 2 * real k' * pi"
    using canon_ang[of \<alpha>']
    by auto

  obtain k''::int where **: "- pi < \<downharpoonright>\<alpha>''\<downharpoonleft>" "\<downharpoonright>\<alpha>''\<downharpoonleft> \<le> pi" "\<alpha>'' - \<downharpoonright>\<alpha>''\<downharpoonleft> = 2 * real k'' * pi"
    using canon_ang[of \<alpha>'']
    by auto

  obtain k::int where ***: "\<alpha>' - \<alpha>'' = 2*k*pi"
    using assms
    by auto

  have "\<exists>m::int. \<alpha>' - \<downharpoonright>\<alpha>''\<downharpoonleft> = 2 * m * pi"
    using **(3) ***
    by (rule_tac x="k+k''" in exI) (auto simp add: field_simps)
    
  thus ?thesis
    using canon_ang_unique[of "\<downharpoonright>\<alpha>'\<downharpoonleft>" \<alpha>' "\<downharpoonright>\<alpha>''\<downharpoonleft>"] * **
    by auto
qed

lemma canon_ang_eqI: 
  assumes "\<exists>k::int. \<alpha>' - \<alpha> = 2 * k * pi" "- pi < \<alpha>' \<and> \<alpha>' \<le> pi"
  shows "\<downharpoonright>\<alpha>\<downharpoonleft> = \<alpha>'"
using assms
using canon_ang_eq[of \<alpha>' \<alpha>]
using canon_ang_id[of \<alpha>']
by auto

lemma canon_ang_arg:
  "\<downharpoonright>arg z\<downharpoonleft> = arg z"
using canon_ang_id[of "arg z"] arg_bounded
by simp

lemma canon_ang_uminus:
  assumes "\<downharpoonright>\<alpha>\<downharpoonleft> \<noteq> pi"
  shows "\<downharpoonright>-\<alpha>\<downharpoonleft> = -\<downharpoonright>\<alpha>\<downharpoonleft>"
proof (rule canon_ang_eqI)
  show "\<exists>x::int. - \<downharpoonright>\<alpha>\<downharpoonleft> - - \<alpha> = 2 * real x * pi"
    using canon_ang(3)[of \<alpha>]
    by (metis minus_diff_eq minus_diff_minus)
next
  show "- pi < - \<downharpoonright>\<alpha>\<downharpoonleft> \<and> - \<downharpoonright>\<alpha>\<downharpoonleft> \<le> pi"
    using canon_ang(1)[of \<alpha>] canon_ang(2)[of \<alpha>] assms
    by auto
qed

lemma canon_ang_uminus_pi:
  assumes "\<downharpoonright>\<alpha>\<downharpoonleft> = pi"
  shows "\<downharpoonright>-\<alpha>\<downharpoonleft> = \<downharpoonright>\<alpha>\<downharpoonleft>"
proof (rule canon_ang_eqI)
  obtain k::int where "\<alpha> - \<downharpoonright>\<alpha>\<downharpoonleft> = 2 * real k * pi"
    using canon_ang(3)[of \<alpha>]
    by auto
  thus "\<exists>x::int. \<downharpoonright>\<alpha>\<downharpoonleft> - - \<alpha> = 2 * real x * pi"
    using assms
    by (rule_tac x="k+(1::int)" in exI) (auto simp add: field_simps)
next
  show "- pi < \<downharpoonright>\<alpha>\<downharpoonleft> \<and> \<downharpoonright>\<alpha>\<downharpoonleft> \<le> pi"
    using assms
    by auto
qed

lemma canon_ang_diff:
  "\<downharpoonright>\<alpha> - \<beta>\<downharpoonleft> = \<downharpoonright>\<downharpoonright>\<alpha>\<downharpoonleft> - \<downharpoonright>\<beta>\<downharpoonleft>\<downharpoonleft>"
proof (rule canon_ang_eq)
  show "\<exists>x::int. \<alpha> - \<beta> - (\<downharpoonright>\<alpha>\<downharpoonleft> - \<downharpoonright>\<beta>\<downharpoonleft>) = 2 * real x * pi"
  proof-
    obtain k1::int where "\<alpha> - \<downharpoonright>\<alpha>\<downharpoonleft> = 2*k1*pi"
      using canon_ang(3)
      by auto
    moreover
    obtain k2::int where "\<beta> - \<downharpoonright>\<beta>\<downharpoonleft> = 2*k2*pi"
      using canon_ang(3)
      by auto
    ultimately
    show ?thesis
      by (rule_tac x="k1 - k2" in exI) (auto simp add: field_simps)
  qed
qed

lemma canon_ang_sum:
  "\<downharpoonright>\<alpha> + \<beta>\<downharpoonleft> = \<downharpoonright>\<downharpoonright>\<alpha>\<downharpoonleft> + \<downharpoonright>\<beta>\<downharpoonleft>\<downharpoonleft>"
proof (rule canon_ang_eq)
  show "\<exists>x::int. \<alpha> + \<beta> - (\<downharpoonright>\<alpha>\<downharpoonleft> + \<downharpoonright>\<beta>\<downharpoonleft>) = 2 * real x * pi"
  proof-
    obtain k1::int where "\<alpha> - \<downharpoonright>\<alpha>\<downharpoonleft> = 2*k1*pi"
      using canon_ang(3)
      by auto
    moreover
    obtain k2::int where "\<beta> - \<downharpoonright>\<beta>\<downharpoonleft> = 2*k2*pi"
      using canon_ang(3)
      by auto
    ultimately
    show ?thesis
      by (rule_tac x="k1 + k2" in exI) (auto simp add: field_simps)
  qed
qed

lemma canon_ang_plus_pi1:
  assumes "0 < \<alpha>" "\<alpha> \<le> 2*pi"
  shows "\<downharpoonright>\<alpha> + pi\<downharpoonleft> = \<alpha> - pi"
proof (rule canon_ang_eqI)
  show "\<exists> x::int. \<alpha> - pi - (\<alpha> + pi) = 2 * real x * pi"
    by (rule_tac x="-1" in exI) auto
next
  show "- pi < \<alpha> - pi \<and> \<alpha> - pi \<le> pi"
    using assms
    by auto
qed

lemma canon_ang_plus_pi2:
  assumes "-2*pi < \<alpha>" "\<alpha> \<le> 0" 
  shows "\<downharpoonright>\<alpha> + pi\<downharpoonleft> = \<alpha> + pi"
proof (rule canon_ang_id)
  show "- pi < \<alpha> + pi \<and> \<alpha> + pi \<le> pi"
    using assms
    by auto
qed

lemma canon_ang_minus_pi1:
  assumes "0 < \<alpha>" "\<alpha> \<le> 2*pi"
  shows "\<downharpoonright>\<alpha> - pi\<downharpoonleft> = \<alpha> - pi"
proof (rule canon_ang_id)
  show "- pi < \<alpha> - pi \<and> \<alpha> - pi \<le> pi"
    using assms
    by auto
qed

lemma canon_ang_minus_pi2:
  assumes  "-2*pi < \<alpha>" "\<alpha> \<le> 0"
  shows "\<downharpoonright>\<alpha> - pi\<downharpoonleft> = \<alpha> + pi"
proof (rule canon_ang_eqI)
  show "\<exists> x::int. \<alpha> + pi - (\<alpha> - pi) = 2 * real x * pi"
    by (rule_tac x="1" in exI) auto
next
  show "- pi < \<alpha> + pi \<and> \<alpha> + pi \<le> pi"
    using assms
    by auto
qed

lemma [simp]: "\<downharpoonright>0\<downharpoonleft> = 0"
  using canon_ang_eqI[of 0 0]
  by simp

lemma canon_ang_cos [simp]: "cos \<downharpoonright>\<alpha>\<downharpoonleft> = cos \<alpha>"
proof-
  obtain x::int where "\<alpha> = \<downharpoonright>\<alpha>\<downharpoonleft> + pi * (real x * 2)"
    using canon_ang(3)[of \<alpha>]
    by (auto simp add: field_simps)
  thus ?thesis
    using cos_periodic_int[of "\<downharpoonright>\<alpha>\<downharpoonleft>" x]
    by (simp add: field_simps)
qed

(* ---------------------------------- cis ----------------------------------- *)

lemma [simp]: "cis \<phi> * cis (- \<phi>) = 1"
by (metis cis_mult cis_zero right_minus)

lemma cis_eq:
  assumes "cis a = cis b"
  shows "\<exists> k::int. a - b = 2 * k * pi"
using assms sin_cos_eq[of a b]
using Re_cis[of a] Re_cis[of b] Im_cis[of a] Im_cis[of b]
by (cases "cis a", cases "cis b") auto

lemma cis_inj:
  assumes "cis \<alpha> = cis \<alpha>'" "-pi < \<alpha>" "\<alpha> \<le> pi" "-pi < \<alpha>'" "\<alpha>' \<le> pi"
  shows "\<alpha> = \<alpha>'"
using assms
by (metis arg_unique sgn_cis)

(* ---------------------------------- arg ----------------------------------- *)

lemma re_complex_zero_arg1:
  assumes "arg z = pi/2 \<or> arg z = -pi/2"
  shows "Re z = 0"
using assms
using rcis_cmod_arg[of z] Re_rcis[of "cmod z" "arg z"]
by (metis cos_minus cos_pi_half minus_divide_left mult_eq_0_iff)

lemma re_complex_zero_arg2:
  assumes "Re z = 0" "z \<noteq> 0"
  shows "arg z = pi/2 \<or> arg z = -pi/2"
proof-
  have "cos (arg z) = 0"
    using assms
    by (metis Re_rcis no_zero_divisors norm_eq_zero rcis_cmod_arg)
  thus ?thesis
    using arg_bounded[of z]
    using cos_0_iff_normalized[of "arg z"]
    by simp
qed

lemma im_complex_zero_arg1:
  assumes "arg z = 0 \<or> arg z = pi" 
  shows "Im z = 0"
using assms
using rcis_cmod_arg[of z] Im_rcis[of "cmod z" "arg z"]
by auto

lemma im_complex_zero_arg2:
  assumes "Im z = 0"
  shows "arg z = 0 \<or> arg z = pi"
proof (cases "z = 0")
  case True
  thus ?thesis
    by (auto simp add: arg_zero)
next
  case False
  hence "sin (arg z) = 0"
    using assms rcis_cmod_arg[of z] Im_rcis[of "cmod z" "arg z"]
    by auto
  thus ?thesis
    using arg_bounded[of z]
    using sin_0_iff_normalized
    by simp
qed

lemma arg_complex_of_real_positive:
  assumes "k > 0"
  shows "arg (cor k) = 0"
proof-
  have "cos (arg (Complex k 0)) > 0"
    using assms
    using rcis_cmod_arg[of "Complex k 0"] Re_rcis[of "cmod (Complex k 0)" "arg (Complex k 0)"]
    by auto
  thus ?thesis
    using assms im_complex_zero_arg2[of "cor k"]
    unfolding complex_of_real_def
    by auto
qed

lemma arg_complex_of_real_negative:
  assumes "k < 0"
  shows "arg (cor k) = pi"   
proof-
  have "cos (arg (Complex k 0)) < 0"
    using rcis_cmod_arg[of "Complex k 0"] Re_rcis[of "cmod (Complex k 0)" "arg (Complex k 0)"]
    by auto (metis assms less_asym' mult_eq_0_iff mult_pos_pos neqE zero_less_abs_iff)
  thus ?thesis
    using assms im_complex_zero_arg2[of "cor k"]
    unfolding complex_of_real_def
    by auto
qed

lemma 
  [simp]: "arg ii = pi/2"
proof-
  have "ii = cis (arg ii)"
    using rcis_cmod_arg[of ii]
    by (simp add: rcis_def)
  hence "cos (arg ii) = 0" "sin (arg ii) = 1"
    by (metis Re_cis complex_Re_i, metis Im_cis complex_Im_i)
  thus ?thesis
    using cos_0_iff_normalized[of "arg ii"] arg_bounded[of ii]
    by (auto simp add: field_simps)
qed

lemma 
  [simp]: "arg (-ii) = -pi/2"
proof-
  have "-ii = cis (arg (- ii))"
    using rcis_cmod_arg[of "-ii"]
    by (simp add: rcis_def)
  hence "cos (arg (-ii)) = 0" "sin (arg (-ii)) = -1"
    using Re_cis[of "arg (-ii)"] Im_cis[of "arg (-ii)"]
    by auto
  thus ?thesis
    using cos_0_iff_normalized[of "arg (-ii)"] arg_bounded[of "-ii"]
    by (metis one_neq_neg_numeral sin_pi_half)
qed

lemma arg_cis:
  shows "arg (cis \<phi>) = \<downharpoonright>\<phi>\<downharpoonleft>"
proof (rule canon_ang_eqI[symmetric])
  show "- pi < arg (cis \<phi>) \<and> arg (cis \<phi>) \<le> pi"
    using arg_bounded
    by simp
next
  show "\<exists> k::int. arg (cis \<phi>) - \<phi> = 2*k*pi"
  proof-
    have "cis (arg (cis \<phi>)) = cis \<phi>"
      using cis_arg[of "cis \<phi>"]
      by auto
    thus ?thesis
      using cis_eq
      by auto
  qed
qed

lemma cos_arg:
  assumes "z \<noteq> 0"
  shows "cos (arg z) = Re z / cmod z"
by (metis Complex.Re_sgn Re_cis assms cis_arg)

lemma sin_arg:
  assumes "z \<noteq> 0"
  shows "sin (arg z) = Im z / cmod z"
by (metis Complex.Im_sgn Im_cis assms cis_arg)

(* ---------------------------------------------------- *)
lemma cis_arg_mult:
  assumes "a * z \<noteq> 0"
  shows "cis (arg (a * z)) = cis (arg a + arg z)"
proof-
  have "a * z = cor (cmod a) * cor (cmod z) * cis (arg a) * cis (arg z)"
    using rcis_cmod_arg[of z, symmetric]  rcis_cmod_arg[of a, symmetric] 
    unfolding rcis_def
    by algebra
  hence "a * z = cor (cmod (a * z)) * cis (arg a + arg z)"
    using cis_mult[of "arg a" "arg z"]
    by auto 
  hence "cor (cmod (a * z)) * cis (arg a + arg z) =  cor (cmod (a * z)) * cis (arg (a * z))"
    using assms
    using rcis_cmod_arg[of "a*z"]
    unfolding rcis_def
    by auto
  thus ?thesis
    using mult_cancel_left[of "cor (cmod (a * z))" "cis (arg a + arg z)" " cis (arg (a * z))"]
    using assms
    by auto
qed

lemma arg_mult_2kpi:
  assumes "a * z \<noteq> 0"
  shows "\<exists> k::int. arg (a * z) = arg a + arg z + 2*k*pi"
proof-
  have "cis (arg (a*z)) = cis (arg a + arg z)"
    by (rule cis_arg_mult[OF assms])
  thus ?thesis
    using cis_eq[of "arg (a*z)" "arg a + arg z"]
    by (auto simp add: field_simps)
qed

lemma arg_mult:
  assumes "z1 * z2 \<noteq> 0"
  shows "arg(z1 * z2) = \<downharpoonright>arg z1 + arg z2\<downharpoonleft>"
proof-
  obtain k::int where "arg(z1 * z2) = arg z1 + arg z2 + 2*k*pi"
    using arg_mult_2kpi[of z1 z2]
    using assms
    by auto
  hence "\<downharpoonright>arg(z1 * z2)\<downharpoonleft> = \<downharpoonright>arg z1 + arg z2\<downharpoonleft>"
    using canon_ang_eq
    by(simp add:field_simps)
  thus ?thesis
    using canon_ang_arg[of "z1*z2"]
    by auto
qed

lemma arg_mult_real_positive:
  assumes "k > 0"
  shows "arg (cor k * z) = arg z"
proof (cases "z = 0")
  case True
  thus ?thesis
    by (auto simp add: arg_zero)
next
  case False
  thus ?thesis
    using assms
    using arg_mult[of "cor k" z]
    by (auto simp add: arg_complex_of_real_positive canon_ang_arg)
qed

lemma arg_mult_real_negative:
  assumes "k < 0"
  shows "arg (cor k * z) = arg (-z)"
proof (cases "z = 0")
  case True
  thus ?thesis
    by (auto simp add: arg_zero)
next
  case False
  thus ?thesis
    using assms
    using arg_mult[of "cor k" z]
    using arg_mult[of "-1" z]
    using arg_complex_of_real_negative[of k] arg_complex_of_real_negative[of "-1"]
    by auto
qed

(* --------------------------------------- *)

lemma arg_cnj1:
  assumes "arg z = pi"
  shows "arg (cnj z) = pi"
proof-
  have "cos (arg (cnj z)) = cos (arg z)"
    using rcis_cmod_arg[of z, symmetric] Re_rcis[of "cmod z" "arg z"]
    using rcis_cmod_arg[of "cnj z", symmetric] Re_rcis[of "cmod (cnj z)" "arg (cnj z)"]
    by auto
  hence "arg (cnj z) = arg z \<or> arg(cnj z) = -arg z"
    using arg_bounded[of z] arg_bounded[of "cnj z"]
    by (metis arccos_cos arccos_cos2 less_eq_real_def linorder_le_cases minus_minus)
  thus ?thesis
    using assms
    using arg_bounded[of "cnj z"]
    by auto
qed

lemma arg_cnj2:
  assumes "arg z \<noteq> pi"
  shows "arg (cnj z) = -arg z"
proof(cases "arg z = 0")
  case True
  thus ?thesis
    by (metis cnj_def complex_surj im_complex_zero_arg1 minus_zero)
next
  case False
  have "cos (arg (cnj z)) = cos (arg z)"
    using rcis_cmod_arg[of z] Re_rcis[of "cmod z" "arg z"]
    using rcis_cmod_arg[of "cnj z"] Re_rcis[of "cmod (cnj z)" "arg (cnj z)"]
    by auto
  hence "arg (cnj z) = arg z \<or> arg(cnj z) = -arg z"
    using arg_bounded[of z] arg_bounded[of "cnj z"]
    by (metis arccos_cos arccos_cos2 less_eq_real_def linorder_le_cases minus_minus)
  moreover
  have "sin (arg (cnj z)) = -sin (arg z)"
    using rcis_cmod_arg[of z] Im_rcis[of "cmod z" "arg z"]
    using rcis_cmod_arg[of "cnj z"] Im_rcis[of "cmod (cnj z)" "arg (cnj z)"]
    by auto (metis complex_Im_cnj complex_Im_zero complex_mod_cnj im_complex_zero_arg2 minus_mult_right norm_eq_zero real_mult_left_cancel sin_pi sin_zero)
  hence "arg (cnj z) \<noteq> arg z"
    using sin_0_iff_normalized[of "arg (cnj z)"] arg_bounded False assms
    by auto
  ultimately
  show ?thesis
    by auto
qed

(* -------------------------------------------------------- *)
lemma arg_div_real_positive:
  assumes "k \<noteq> 0" "k > 0"
  shows "arg (z / cor k) = arg z"
proof(cases "z = 0")
  case True
  thus ?thesis
    by auto
next
  case False
  thus ?thesis
    using assms
    using arg_mult_real_positive[of "1/k" z]
    by auto
qed

lemma arg_inv1:
  assumes "z \<noteq> 0" "arg z \<noteq> pi"
  shows "arg (1 / z) = - arg z"
proof-
  have "1/z = cnj z / cor ((cmod z)\<^sup>2 )"
    using `z \<noteq> 0` complex_mult_cnj_cmod[of z]
    by (auto simp add:field_simps)
  thus ?thesis
    using arg_div_real_positive[of "(cmod z)\<^sup>2" "cnj z"] `z \<noteq> 0`
    using arg_cnj2[of z] `arg z \<noteq> pi`
    by auto
qed

lemma arg_inv2:
  assumes "z \<noteq> 0" "arg z = pi"
  shows "arg (1 / z) = pi"
proof-
  have "1/z = cnj z / cor ((cmod z)\<^sup>2 )"
    using `z \<noteq> 0` complex_mult_cnj_cmod[of z]
    by (auto simp add:field_simps)
  thus ?thesis
    using arg_div_real_positive[of "(cmod z)\<^sup>2" "cnj z"] `z \<noteq> 0`
    using arg_cnj1[of z] `arg z = pi`
    by auto
qed

lemma arg_inv_2kpi:
  assumes "z \<noteq> 0"
  shows "\<exists> k::int. arg (1 / z) = - arg z + 2*k*pi"
using arg_inv1[OF assms]
using arg_inv2[OF assms]
by (cases "arg z = pi") (rule_tac x="1" in exI, simp, rule_tac x="0" in exI, simp)

lemma arg_inv:
  assumes "z \<noteq> 0"
  shows "arg (1 / z) = \<downharpoonright>- arg z\<downharpoonleft>"
proof-
  obtain k::int where "arg(1 / z) = - arg z + 2*k*pi"
    using arg_inv_2kpi[of z]
    using assms
    by auto
  hence "\<downharpoonright>arg(1 / z)\<downharpoonleft> = \<downharpoonright>- arg z\<downharpoonleft>"
    using canon_ang_eq
    by(simp add:field_simps)
  thus ?thesis
    using canon_ang_arg[of "1 / z"]
    by auto
qed

(* ------------------------------------------------- *)

lemma arg_div_2kpi:
  assumes "z1 \<noteq> 0" "z2 \<noteq> 0"
  shows "\<exists> k::int. arg (z1 / z2) = arg z1 - arg z2 + 2*k*pi"
using assms
unfolding complex_divide_def[of z1 z2]
using inverse_eq_divide[of z2]
using arg_mult_2kpi[of z1 "1/z2"]
using arg_inv_2kpi[of z2]
by auto (metis comm_semiring_class.distrib distrib_left_numeral real_of_int_add)

lemma arg_div: 
  assumes "z1 \<noteq> 0" "z2 \<noteq> 0"
  shows "arg(z1 / z2) = \<downharpoonright>arg z1 - arg z2\<downharpoonleft>"
proof-
  obtain k::int where "arg(z1 / z2) = arg z1 - arg z2 + 2*k*pi"
    using arg_div_2kpi[of z1 z2]
    using assms
    by auto
  hence "canon_ang(arg(z1 / z2)) = canon_ang(arg z1 - arg z2)"
    using canon_ang_eq
    by(simp add:field_simps)
  thus ?thesis
    using canon_ang_arg[of "z1/z2"]
    by auto
qed

(* ------------------------------------------------- *)

lemma arg_uminus:
  assumes "z \<noteq> 0"
  shows "arg (-z) = \<downharpoonright>arg z + pi\<downharpoonleft>"
using assms
using arg_mult[of "-1" z]
using arg_complex_of_real_negative[of "-1"]
by auto (metis comm_semiring_1_class.normalizing_semiring_rules(24))


(* -------------------------------------------------------------------------- *)

definition 
  "csqrt z = rcis (sqrt (cmod z)) (arg z / 2)"

lemma [simp]: "(csqrt x)\<^sup>2 = x"
  unfolding csqrt_def
  by (subst DeMoivre2) (simp add: rcis_cmod_arg)

lemma ex_complex_sqrt: "\<exists> s::complex. s*s = z"
  unfolding power2_eq_square[symmetric]
  by (rule_tac x="csqrt z" in exI) simp

lemma csqrt:
  assumes "s * s = z"
  shows "s = csqrt z \<or> s = -csqrt z"
proof (cases "s = 0")
  case True
  thus ?thesis
    using assms
    unfolding csqrt_def
    by simp
next
  case False
  then obtain k::int where "cmod s * cmod s = cmod z" "2 * arg s - arg z = 2*k*pi"
    using assms
    using rcis_cmod_arg[of z] rcis_cmod_arg[of s]
    using arg_mult[of s s]
    using canon_ang(3)[of "2*arg s"]
    by (auto simp add: norm_mult arg_mult)
  have *: "sqrt (cmod z) = cmod s" 
    using `cmod s * cmod s = cmod z`
    by (smt norm_not_less_zero real_sqrt_abs2)

  have **: "arg z / 2 = arg s - k*pi"
    using `2 * arg s - arg z = 2*k*pi`
    by simp

  have "cis (arg s - k*pi) = cis (arg s) \<or> cis (arg s - k*pi) = -cis (arg s)"
  proof (cases "even k")
    case True
    hence "cis (arg s - k*pi) = cis (arg s)"
      by (simp add: cis_def cos_diff sin_diff cos_kpi_even sin_kpi)
    thus ?thesis
      by simp
  next
    case False
    hence "cis (arg s - k*pi) = -cis (arg s)"
      by (simp add: cis_def cos_diff sin_diff cos_kpi_odd sin_kpi)
    thus ?thesis
      by simp
  qed
  thus ?thesis
  proof
    assume ***: "cis (arg s - real k * pi) = cis (arg s)"
    hence "s = csqrt z"
      using rcis_cmod_arg[of s]
      unfolding csqrt_def rcis_def
      by (subst *, subst **, subst ***, simp)
    thus ?thesis
      by simp
  next
    assume ***: "cis (arg s - real k * pi) = -cis (arg s)"
    hence "s = - csqrt z"
      using rcis_cmod_arg[of s]
      unfolding csqrt_def rcis_def
      by (subst *, subst **, subst ***, simp)
    thus ?thesis
      by simp
  qed
qed

lemma [simp]: "csqrt x = 0 \<longleftrightarrow> x = 0"
unfolding csqrt_def
by auto

lemma csqrt_mult: "csqrt (a * b) = csqrt a * csqrt b \<or> csqrt (a * b) = - csqrt a * csqrt b"
proof (cases "a = 0 \<or> b = 0")
  case True
  thus ?thesis
    by auto
next
  case False
  obtain k::int where *: "\<downharpoonright>arg a + arg b\<downharpoonleft> = arg a + arg b - 2 * real k * pi"
    using canon_ang(3)[of "arg a + arg b"]
    by smt
  have "cis (\<downharpoonright>arg a + arg b\<downharpoonleft> / 2) = cis (arg a / 2 + arg b / 2) \<or> cis (\<downharpoonright>arg a + arg b\<downharpoonleft> / 2) = - cis (arg a / 2 + arg b / 2)"
    using cos_kpi_even[of k] cos_kpi_odd[of k]
    by ((subst *)+, (subst diff_divide_distrib)+, (subst add_divide_distrib)+)
       (cases "even k", auto simp add: cis_def cos_diff sin_diff sin_kpi)
 thus ?thesis
    using False
    unfolding csqrt_def
    by (simp add: rcis_mult real_sqrt_mult arg_mult)
       (auto simp add: rcis_def)
qed

lemma csqrt_real:
  assumes "is_real x"
  shows "(Re x \<ge> 0 \<and> csqrt x = cor (sqrt (Re x))) \<or> 
         (Re x < 0 \<and> csqrt x = ii * cor (sqrt (- (Re x))))"
proof (cases "x = 0")
  case True
  thus ?thesis
    by auto
next
  case False
  show ?thesis
  proof (cases "Re x > 0")
    case True
    hence "arg x = 0"
      using `is_real x`
      by (metis arg_complex_of_real_positive complex_of_real_Re)
    thus ?thesis
      using `Re x > 0`
      unfolding csqrt_def
      by simp (metis Re.simps complex_of_real_def rcis_cmod_arg rcis_zero_arg)
  next
    case False
    hence "Re x < 0"
      using `x \<noteq> 0` `is_real x`
      by (cases x, auto)
    hence "arg x = pi"
      using `is_real x`
      by (metis arg_complex_of_real_negative complex_of_real_Re)
    thus ?thesis
      using `Re x < 0`
      unfolding csqrt_def
      by (simp add: rcis_def cis_def complex_of_real_def) (metis Complex_eq_0 False Re.simps assms complex_minus_def complex_of_real_def cor_cmod_real le_less_linear norm_le_zero_iff)
  qed
qed


(* ------------------------------------------------- *)

lemma is_real_rot_to_xaxis:
  assumes "z \<noteq> 0"
  shows "is_real (cis (-arg z) * z)"
proof (cases "arg z = pi")
  case True
  thus ?thesis
    using im_complex_zero_arg1[of z]
    by auto
next
  case False
  hence "\<downharpoonright>- arg z\<downharpoonleft> = - arg z"
    using canon_ang_eqI[of "- arg z" "-arg z"]
    using arg_bounded[of z]
    by (auto simp add: field_simps)
  hence "arg (cis (- (arg z)) * z) = 0"
    using arg_mult[of "cis (- (arg z))" z] `z \<noteq> 0`
    using arg_cis[of "- arg z"]
    by simp
  thus ?thesis
    using im_complex_zero_arg1[of "cis (- arg z) * z"]
    by auto
qed

(* --------------------------------------- *)

lemma cmod_1_plus_mult_le:
  "cmod (1 + z*w) \<le> sqrt((1 + (cmod z)\<^sup>2) * (1 + (cmod w)\<^sup>2))"
proof-
  have "Re ((1+z*w)*(1+cnj z*cnj w)) \<le> Re (1+z*cnj z)* Re (1+w*cnj w)"
  proof-
    have "Re ((w - cnj z)*cnj(w - cnj z)) \<ge> 0"
      by (subst complex_mult_cnj_cmod) (simp add: power2_eq_square)
    hence "Re (z*w + cnj z * cnj w) \<le> Re (w*cnj w) + Re(z*cnj z)"
      by (simp only: complex_cnj complex_cnj_cnj field_simps complex_Re_diff complex_Re_add)
    thus ?thesis
      by (simp add: field_simps)
  qed
  hence "(cmod (1 + z * w))\<^sup>2 \<le> (1 + (cmod z)\<^sup>2) * (1 + (cmod w)\<^sup>2)"
    by (subst cmod_square)+ simp
  thus ?thesis
    by (metis abs_norm_cancel real_sqrt_abs real_sqrt_le_iff)
qed

lemma cmod_diff_ge: "cmod (b - c) \<ge> sqrt (1 + (cmod b)\<^sup>2) - sqrt (1 + (cmod c)\<^sup>2)"
proof-
  have "(cmod (b - c))\<^sup>2 + (1/2*Im(b*cnj c - c*cnj b))\<^sup>2 \<ge> 0"
    by simp
  hence "(cmod (b - c))\<^sup>2 \<ge> - (1/2*Im(b*cnj c - c*cnj b))\<^sup>2"
    by simp
  hence "(cmod (b - c))\<^sup>2 \<ge> (1/2*Re(b*cnj c + c*cnj b))\<^sup>2 - Re(b*cnj b*c*cnj c) "
    by (auto simp add: power2_eq_square field_simps)
  hence "Re ((b - c)*(cnj b - cnj c)) \<ge> (1/2*Re(b*cnj c + c*cnj b))\<^sup>2 - Re(b*cnj b*c*cnj c)"
    by (subst (asm) cmod_square) (simp add: complex_cnj)
  moreover
  have "(1 + (cmod b)\<^sup>2) * (1 + (cmod c)\<^sup>2) = 1 + Re(b*cnj b) + Re(c*cnj c) + Re(b*cnj b*c*cnj c)"
    by (subst cmod_square)+ (simp add: field_simps power2_eq_square)
  moreover
  have "(1 + Re (scalprod b c))\<^sup>2 = 1 + 2*Re(scalprod b c) + ((Re (scalprod b c))\<^sup>2)"
    by (subst power2_sum) simp
  hence "(1 + Re (scalprod b c))\<^sup>2 = 1 + Re(b*cnj c + c*cnj b) + (1/2 * Re (b*cnj c + c*cnj b))\<^sup>2"
    by simp
  ultimately
  have "(1 + (cmod b)\<^sup>2) * (1 + (cmod c)\<^sup>2) \<ge> (1 + Re (scalprod b c))\<^sup>2"
    by (simp add: field_simps)
  moreover
  have "sqrt((1 + (cmod b)\<^sup>2) * (1 + (cmod c)\<^sup>2)) \<ge> 0"
    by (metis one_power2 real_sqrt_sum_squares_mult_ge_zero)
  ultimately
  have "sqrt((1 + (cmod b)\<^sup>2) * (1 + (cmod c)\<^sup>2)) \<ge> 1 + Re (scalprod b c)"
    by (metis power2_le_imp_le real_sqrt_ge_0_iff real_sqrt_pow2_iff)
  hence "Re ((b - c) * (cnj b - cnj c)) \<ge> 1 + Re (c*cnj c) + 1 + Re (b*cnj b) - 2*sqrt((1 + (cmod b)\<^sup>2) * (1 + (cmod c)\<^sup>2))"
    by (simp add: field_simps)
  hence *: "(cmod (b - c))\<^sup>2 \<ge> (sqrt (1 + (cmod b)\<^sup>2) - sqrt (1 + (cmod c)\<^sup>2))\<^sup>2"
    apply (subst cmod_square)+
    apply (subst (asm) cmod_square)+
    apply (subst power2_diff)
    apply (subst real_sqrt_pow2, simp)
    apply (subst real_sqrt_pow2, simp)
    apply (simp add: real_sqrt_mult complex_cnj)
    done
  thus ?thesis
  proof (cases "sqrt (1 + (cmod b)\<^sup>2) - sqrt (1 + (cmod c)\<^sup>2) > 0")
    case True
    thus ?thesis
      using square_cancel[OF *]
      by simp
  next
    case False
    hence "0 \<ge> sqrt (1 + (cmod b)\<^sup>2) - sqrt (1 + (cmod c)\<^sup>2)"
      by (metis less_eq_real_def linorder_neqE_linordered_idom)
    moreover
    have "cmod (b - c) \<ge> 0"
      by simp
    ultimately
    show ?thesis
      by (metis add_increasing monoid_add_class.add.right_neutral)
  qed
qed

lemma cmod_diff_le: "cmod (b - c) \<le> sqrt (1 + (cmod b)\<^sup>2) + sqrt (1 + (cmod c)\<^sup>2)"
proof-
  have "(cmod (b + c))\<^sup>2 + (1/2*Im(b*cnj c - c*cnj b))\<^sup>2 \<ge> 0"
    by simp
  hence "(cmod (b + c))\<^sup>2 \<ge> - (1/2*Im(b*cnj c - c*cnj b))\<^sup>2"
    by simp
  hence "(cmod (b + c))\<^sup>2 \<ge> (1/2*Re(b*cnj c + c*cnj b))\<^sup>2 - Re(b*cnj b*c*cnj c) "
    by (auto simp add: power2_eq_square field_simps)
  hence "Re ((b + c)*(cnj b + cnj c)) \<ge> (1/2*Re(b*cnj c + c*cnj b))\<^sup>2 - Re(b*cnj b*c*cnj c)"
    by (subst (asm) cmod_square) (simp add: complex_cnj)
  moreover
  have "(1 + (cmod b)\<^sup>2) * (1 + (cmod c)\<^sup>2) = 1 + Re(b*cnj b) + Re(c*cnj c) + Re(b*cnj b*c*cnj c)"
    by (subst cmod_square)+ (simp add: field_simps power2_eq_square)
  moreover
  have ++: "2*Re(scalprod b c) = Re(b*cnj c + c*cnj b)"
    by simp
  have "(1 - Re (scalprod b c))\<^sup>2 = 1 - 2*Re(scalprod b c) + ((Re (scalprod b c))\<^sup>2)"
    by (subst power2_diff) simp
  hence "(1 - Re (scalprod b c))\<^sup>2 = 1 - Re(b*cnj c + c*cnj b) + (1/2 * Re (b*cnj c + c*cnj b))\<^sup>2"
    by (subst ++[symmetric]) simp
  ultimately
  have "(1 + (cmod b)\<^sup>2) * (1 + (cmod c)\<^sup>2) \<ge> (1 - Re (scalprod b c))\<^sup>2"
    by (simp add: field_simps)
  moreover
  have "sqrt((1 + (cmod b)\<^sup>2) * (1 + (cmod c)\<^sup>2)) \<ge> 0"
    by (metis one_power2 real_sqrt_sum_squares_mult_ge_zero)
  ultimately
  have "sqrt((1 + (cmod b)\<^sup>2) * (1 + (cmod c)\<^sup>2)) \<ge> 1 - Re (scalprod b c)"
    by (metis power2_le_imp_le real_sqrt_ge_0_iff real_sqrt_pow2_iff)
  hence "Re ((b - c) * (cnj b - cnj c)) \<le> 1 + Re (c*cnj c) + 1 + Re (b*cnj b) + 2*sqrt((1 + (cmod b)\<^sup>2) * (1 + (cmod c)\<^sup>2))"
    by (simp add: field_simps)
  hence *: "(cmod (b - c))\<^sup>2 \<le> (sqrt (1 + (cmod b)\<^sup>2) + sqrt (1 + (cmod c)\<^sup>2))\<^sup>2"
    apply (subst cmod_square)+
    apply (subst (asm) cmod_square)+
    apply (subst power2_sum)
    apply (subst real_sqrt_pow2, simp)
    apply (subst real_sqrt_pow2, simp)
    apply (simp add: real_sqrt_mult complex_cnj)
    done
  thus ?thesis
    using square_cancel[OF *]
    by simp
qed

(* -------------------------------------------------------------------------- *)

definition cdist where
  [simp]: "cdist z1 z2 \<equiv> cmod (z2 - z1)"

(* -------------------------------------------------------------------------- *)

lemma [simp]:
  fixes z1 z2 :: complex
  assumes "z1 \<noteq> 0" "z2 \<noteq> 0"
  shows "\<exists>k. k \<noteq> 0 \<and> z2 = k * z1"
using assms
by (rule_tac x="z2/z1" in exI) simp

lemma [simp]:
  fixes z::complex
  assumes "z \<noteq> 0"
  shows "\<exists>k. k \<noteq> 0 \<and> k * z = 1"
using assms
by (rule_tac x="1/z" in exI) simp

lemma [simp]:
  fixes z::complex
  shows "\<exists>k. k \<noteq> 0 \<and> k * z = z"
by (rule_tac x="1" in exI) simp

end
