header{* Quadratic equations *}
theory Quadratic
imports Complex MoreComplex
begin

lemma real_quadratic_equation:
  fixes \<xi> :: real
  assumes "\<xi>\<^sup>2 + b * \<xi> + c = 0" "b\<^sup>2 - 4*c \<ge> 0"
  shows "\<xi> = (-b + sqrt(b\<^sup>2 - 4*c)) / 2 \<or> \<xi> = (-b - sqrt(b\<^sup>2 - 4*c)) / 2"
using assms
proof-
  from assms have "(2 * (\<xi> + b/2))\<^sup>2 = b\<^sup>2 - 4*c"
    by (simp add: power2_eq_square field_simps)
  hence "2 * (\<xi> + b/2) = sqrt (b\<^sup>2 - 4*c) \<or> 2 * (\<xi> + b/2) = - sqrt (b\<^sup>2 - 4*c)"
    by (metis abs_minus_cancel power2_abs power2_eq_iff real_sqrt_abs)
  thus ?thesis
    by (auto simp add: field_simps)
qed

lemma real_quadratic_equation':
  fixes \<xi> :: real
  assumes  "b\<^sup>2 - 4*c \<ge> 0" "\<xi> = (-b + sqrt(b\<^sup>2 - 4*c)) / 2 \<or> \<xi> = (-b - sqrt(b\<^sup>2 - 4*c)) / 2"
  shows  "\<xi>\<^sup>2 + b * \<xi> + c = 0"
using assms(2)
proof
  assume *: "\<xi> = (- b + sqrt (b\<^sup>2 - 4 * c)) / 2"
  show ?thesis
    using assms(1)
    by ((subst *)+, subst power_divide, subst power2_sum, simp add: field_simps, simp add: power2_eq_square)
next
  assume *: "\<xi> = (- b - sqrt (b\<^sup>2 - 4 * c)) / 2"
  show ?thesis
    using assms(1)
    by ((subst *)+, subst power_divide, subst power2_diff, simp add: field_simps, simp add: power2_eq_square)
qed

lemma complex_quadratic_equation:
  fixes \<xi> :: complex
  assumes "\<xi>\<^sup>2 + b * \<xi> + c = 0"
  shows "\<xi> = (-b + csqrt(b\<^sup>2 - 4*c)) / 2 \<or> \<xi> = (-b - csqrt(b\<^sup>2 - 4*c)) / 2"
using assms
proof-
  from assms have "(2 * (\<xi> + b/2))\<^sup>2 = b\<^sup>2 - 4*c"
    by (simp add: power2_eq_square field_simps)
       (metis ab_semigroup_mult_class.mult_ac(1) comm_semiring_1_class.normalizing_semiring_rules(34) comm_semiring_class.distrib mult_zero_left)
  hence "2 * (\<xi> + b/2) = csqrt (b\<^sup>2 - 4*c) \<or> 2 * (\<xi> + b/2) = - csqrt (b\<^sup>2 - 4*c)"
    using csqrt[of "(2 * (\<xi> + b / 2))" "b\<^sup>2 - 4 * c"]
    by (simp add: power2_eq_square)
  thus ?thesis
    using mult_cancel_right[of "b + \<xi> * 2" 2 "csqrt (b\<^sup>2 - 4*c)"]
    using mult_cancel_right[of "b + \<xi> * 2" 2 "-csqrt (b\<^sup>2 - 4*c)"]
    by (auto simp add: field_simps) (metis add_diff_cancel diff_minus_eq_add minus_diff_eq)
qed

lemma complex_quadratic_equation':
  fixes \<xi> :: complex
  assumes "\<xi> = (-b + csqrt(b\<^sup>2 - 4*c)) / 2 \<or> 
           \<xi> = (-b - csqrt(b\<^sup>2 - 4*c)) / 2"
  shows  "\<xi>\<^sup>2 + b * \<xi> + c = 0"
using assms
proof
  assume *: "\<xi> = (- b + csqrt (b\<^sup>2 - 4 * c)) / 2"
  show ?thesis
    by ((subst *)+) (subst power_divide, subst power2_sum, simp add: field_simps, simp add: power2_eq_square)
next
  assume *: "\<xi> = (- b - csqrt (b\<^sup>2 - 4 * c)) / 2"
  show ?thesis
    by ((subst *)+, subst power_divide, subst power2_diff, simp add: field_simps, simp add: power2_eq_square)
qed

lemma complex_quadratic_equation_full:
  fixes \<xi> :: complex
  assumes "a*\<xi>\<^sup>2 + b * \<xi> + c = 0" "a \<noteq> 0"
  shows "\<xi> = (-b + csqrt(b\<^sup>2 - 4*a*c)) / (2*a) \<or> 
         \<xi> = (-b - csqrt(b\<^sup>2 - 4*a*c)) / (2*a)"
proof-
  from assms have "\<xi>\<^sup>2 + (b/a) * \<xi> + (c/a) = 0"
    by (simp add: field_simps)
  hence "\<xi> = (-(b/a) + csqrt((b/a)\<^sup>2 - 4*(c/a))) / 2 \<or> \<xi> = (-(b/a) - csqrt((b/a)\<^sup>2 - 4*(c/a))) / 2"
    using complex_quadratic_equation[of \<xi> "b/a" "c/a"]
    by simp
  hence "\<exists> k. \<xi> = (-(b/a) + (-1)^k * csqrt((b/a)\<^sup>2 - 4*(c/a))) / 2"
    by safe (rule_tac x="2" in exI, simp, rule_tac x="1" in exI, simp)
  then obtain k1 where "\<xi> = (-(b/a) + (-1)^k1 * csqrt((b/a)\<^sup>2 - 4*(c/a))) / 2"
    by auto
  moreover
  have "(b / a)\<^sup>2 - 4 * (c / a) = (b\<^sup>2 - 4 * a * c) * (1 / a\<^sup>2)"
    by (simp add: field_simps power2_eq_square)
  hence "csqrt ((b / a)\<^sup>2 - 4 * (c / a)) = csqrt (b\<^sup>2 - 4 * a * c) * csqrt (1/a\<^sup>2) \<or> 
        csqrt ((b / a)\<^sup>2 - 4 * (c / a)) = - csqrt (b\<^sup>2 - 4 * a * c) * csqrt (1/a\<^sup>2)"
    using csqrt_mult[of "b\<^sup>2 - 4 * a * c" "1/a\<^sup>2"]
    by auto
  hence "\<exists> k.  csqrt ((b / a)\<^sup>2 - 4 * (c / a)) = (-1)^k * csqrt (b\<^sup>2 - 4 * a * c) * csqrt (1 / a\<^sup>2)"
    by safe (rule_tac x="2" in exI, simp, rule_tac x="1" in exI, simp)
  then obtain k2 where "csqrt ((b / a)\<^sup>2 - 4 * (c / a)) = (-1)^k2 * csqrt (b\<^sup>2 - 4 * a * c) * csqrt (1 / a\<^sup>2)"
    by auto
  moreover
  have "csqrt (1 / a\<^sup>2) = 1/a \<or> csqrt (1 / a\<^sup>2) = -1/a"
    using csqrt[of "1/a" "1 / a\<^sup>2"]
    by (auto simp add: power2_eq_square)
  hence "\<exists> k. csqrt (1 / a\<^sup>2) = (-1)^k * 1/a"
    by safe (rule_tac x="2" in exI, simp, rule_tac x="1" in exI, simp)
  then obtain k3 where "csqrt (1 / a\<^sup>2) = (-1)^k3 * 1/a"
    by auto
  ultimately
  have "\<xi> = (- (b / a) + ((-1) ^ k1 * (-1) ^ k2 * (-1) ^ k3) * csqrt (b\<^sup>2 - 4 * a * c) * 1/a) / 2"
    by simp
  moreover
  have "(-(1::complex)) ^ k1 * (-1) ^ k2 * (-1) ^ k3 = 1 \<or> (-(1::complex)) ^ k1 * (-1) ^ k2 * (-1) ^ k3 = -1"
    using neg_one_even_power[of "k1 + k2 + k3"]
    using neg_one_odd_power[of "k1 + k2 + k3"]
    by (simp add: comm_semiring_1_class.normalizing_semiring_rules(26))
       (cases "even (k1 + k2 + k3)", auto)
  ultimately
  have "\<xi> = (- (b / a) + csqrt (b\<^sup>2 - 4 * a * c) * 1 / a) / 2 \<or> \<xi> = (- (b / a) - csqrt (b\<^sup>2 - 4 * a * c) * 1 / a) / 2"
    by auto
  thus ?thesis
    using `a \<noteq> 0`
    by (simp add: field_simps)
qed

lemma complex_quadratic_two_solutions:
  fixes b c :: complex
  assumes "b\<^sup>2 - 4*c \<noteq> 0"
  shows "\<exists> k\<^sub>1 k\<^sub>2. k\<^sub>1 \<noteq> k\<^sub>2 \<and> k\<^sub>1\<^sup>2 + b*k\<^sub>1 + c = 0 \<and> k\<^sub>2\<^sup>2 + b*k\<^sub>2 + c = 0"
proof-
  let ?\<xi>1 = "(-b + csqrt(b\<^sup>2 - 4*c)) / 2"
  let ?\<xi>2 = "(-b - csqrt(b\<^sup>2 - 4*c)) / 2"
  show ?thesis
    apply (rule_tac x="?\<xi>1" in exI)
    apply (rule_tac x="?\<xi>2" in exI)
    using assms complex_quadratic_equation'[of ?\<xi>1 b c] complex_quadratic_equation'[of ?\<xi>2 b c]
    by simp
qed

end