theory Angles
imports MoreComplex
begin

(*-------------------Ang Between Two Vectors -----------------------------*)

(* (-pi, pi] *)
definition ang_vec ("∡") where
  [simp]: "∡ z1 z2 \<equiv> \<downharpoonright>arg z2 - arg z1\<downharpoonleft>"

(* Convex ang *)
(* [0, pi] *)
definition ang_vec_c ("∡c") where
[simp]:"∡c z1 z2 \<equiv> abs (∡ z1 z2)"

(* Acute ang *)
(* [0, pi] \<rightarrow> [0, pi/2] *)
definition acute_ang where
  [simp]: "acute_ang \<alpha> = (if \<alpha> > pi / 2 then pi - \<alpha> else \<alpha>)"

(* [0, pi/2] *)
definition ang_vec_a ("∡a") where
[simp]: "∡a z1 z2 \<equiv> acute_ang (∡c z1 z2)"

(* ------------------------------------------------------------- *)
lemma ang_vec_sym:
  assumes "∡ z1 z2 \<noteq> pi"
  shows "∡ z1 z2 = - ∡ z2 z1"
using assms
unfolding ang_vec_def
using canon_ang_uminus[of "arg z2 - arg z1"]
by simp

lemma ang_vec_sym_pi:
  assumes "∡ z1 z2 = pi"
  shows "∡ z1 z2 = ∡ z2 z1"
using assms
unfolding ang_vec_def
using canon_ang_uminus_pi[of "arg z2 - arg z1"]
by simp

lemma ang_vec_c_sym:
  shows "∡c z1 z2 = ∡c z2 z1"
unfolding ang_vec_c_def
using ang_vec_sym_pi[of z1 z2] ang_vec_sym[of z1 z2]
by (cases "∡ z1 z2 = pi") auto

lemma ang_vec_a_sym:
  "∡a z1 z2 = ∡a z2 z1"
  unfolding ang_vec_a_def
  using ang_vec_c_sym
  by auto

lemma ang_vec_c_bounded: "0 \<le> ∡c z1 z2 \<and> ∡c z1 z2 \<le> pi"
using canon_ang(1)[of "arg z2 - arg z1"] canon_ang(2)[of "arg z2 - arg z1"]
by auto


lemma ortho_c_scalprod0:
  assumes "z1 \<noteq> 0" "z2 \<noteq> 0"
  shows "∡c z1 z2 = pi/2 \<longleftrightarrow> scalprod z1 z2 = 0"
proof
  assume "∡c z1 z2 = pi / 2"
  have "\<downharpoonright>arg z2 - arg z1\<downharpoonleft> = arg (z2 / z1)"
    using arg_div[of z2 z1] assms
    by auto
  hence "arg (z2 / z1) = pi/2 \<or> arg (z2 / z1) = -pi/2"
    using `∡c z1 z2 = pi/2`
    unfolding ang_vec_c_def
    unfolding ang_vec_def
    by auto
  hence "Re (z2 / z1) = 0"
    using re_complex_zero_arg1[of "z2/z1"]
    by auto
  hence "z2 / z1 + cnj (z2 / z1) = 0"
    using re_complex[of "z2/z1"]
    by (auto simp add: complex_of_real_def[symmetric])
  thus "scalprod z1 z2 = 0"
    using assms complex_cnj_divide[of z2 z1]
    using add_frac_eq[of z1 "cnj z1" "z2" "cnj z2"]
    using divide_eq_0_iff[of "z2 * cnj z1 + cnj z2 * z1"  "z1 * cnj z1"]
    by (auto simp add:field_simps)
next
  assume "scalprod z1 z2 = 0"
  hence "z2 * cnj z1 + cnj z2 * z1 = 0"
    by (simp add:field_simps)
  hence "z2 / z1 + cnj (z2 / z1) = 0"
    using assms complex_cnj_divide[of z2 z1]
    using add_frac_eq[of z1 "cnj z1" "z2" "cnj z2"]
    using divide_eq_0_iff[of "z2 * cnj z1 + cnj z2 * z1"  "z1 * cnj z1"]
    by auto
  hence "Re (z2 / z1) = 0"
    using re_complex[of "z2/z1"]
    by (auto simp add: Complex_eq)
  have "z2 / z1 \<noteq> 0"
    using assms
    by auto
  hence "arg (z2 / z1) = pi/2 \<or> arg (z2 / z1) = -pi/2"
    using `Re (z2 / z1) = 0` re_complex_zero_arg2[of "z2/z1"]
    by auto
  have "\<downharpoonright>arg z2 - arg z1\<downharpoonleft> = arg (z2 / z1)"
    using arg_div[of z2 z1] assms
    by auto
  thus "∡c z1 z2 = pi / 2"
    using `arg (z2 / z1) = pi/2 \<or> arg (z2 / z1) = -pi/2`
    unfolding ang_vec_c_def
    unfolding ang_vec_def
    by (metis abs_minus_cancel abs_of_nonneg minus_divide_left pi_half_ge_zero)
qed

lemma ortho_a_scalprod0:
  assumes "z1 \<noteq> 0" "z2 \<noteq> 0"
  shows "∡a z1 z2 = pi/2 \<longleftrightarrow> scalprod z1 z2 = 0"
unfolding ang_vec_a_def
using assms ortho_c_scalprod0[of z1 z2]
by auto

(* Eksplicitno dokazati granice *)

lemma canon_ang_plus_pi1:
  assumes "∡ z1 z2 > 0"
  shows "\<downharpoonright>∡ z1 z2 + pi\<downharpoonleft> = ∡ z1 z2 - pi"
proof (rule canon_ang_eqI)
  show "\<exists> x::int. ∡ z1 z2 - pi - (∡ z1 z2 + pi) = 2 * real_of_int x * pi"
    by (rule_tac x="-1" in exI) auto
next
  show "- pi < ∡ z1 z2 - pi \<and> ∡ z1 z2 - pi \<le> pi"
    using assms
    unfolding ang_vec_def
    using canon_ang(1)[of "arg z2 - arg z1"] canon_ang(2)[of "arg z2 - arg z1"]
    by auto
qed

lemma canon_ang_plus_pi2:
  assumes "∡ z1 z2 \<le> 0"
  shows "\<downharpoonright>∡ z1 z2 + pi\<downharpoonleft> = ∡ z1 z2 + pi"
proof (rule canon_ang_id)
  show "- pi < ∡ z1 z2 + pi \<and> ∡ z1 z2 + pi \<le> pi"
    using assms
    unfolding ang_vec_def
    using canon_ang(1)[of "arg z2 - arg z1"] canon_ang(2)[of "arg z2 - arg z1"]
    by auto
qed

(* Todo simplify the following ugly proofs *)
lemma ang_vec_opposite1:
  assumes "z1 \<noteq> 0"
  shows "∡ (-z1) z2 = \<downharpoonright>∡ z1 z2 - pi\<downharpoonleft>"
unfolding ang_vec_def
apply (subst arg_uminus[OF assms])
apply (subst canon_ang_arg[of z2, symmetric])
apply (subst canon_ang_diff[of "arg z2" "arg z1 + pi", symmetric])
apply (subst canon_ang_id[of pi, symmetric]) back
apply simp
apply (subst canon_ang_diff[of "arg z2 - arg z1" " pi", symmetric])
apply (simp add: field_simps)
done

lemma ang_vec_opposite2:
  assumes "z2 \<noteq> 0"
  shows "∡ z1 (-z2) = \<downharpoonright>∡ z1 z2 + pi\<downharpoonleft>"
unfolding ang_vec_def
using arg_mult[of "-1" "z2"] assms
using arg_complex_of_real_negative[of "-1"]
using canon_ang_diff[of "arg (-1) + arg z2" "arg z1"]
using canon_ang_sum[of "arg z2 - arg z1" " pi"]
using canon_ang_id[of pi] canon_ang_arg[of z1]
by auto smt


lemma ang_vec_opposite_opposite:
  assumes "z1 \<noteq> 0" "z2 \<noteq> 0"
  shows "∡ (-z1) (-z2) = ∡ z1 z2"
apply (subst ang_vec_opposite1[OF assms(1)])
apply (subst ang_vec_opposite2[OF assms(2)])
apply (subst canon_ang_id[of pi, symmetric]) back
apply simp
apply (subst canon_ang_diff[symmetric])
apply (simp del: ang_vec_def)
by (metis ang_vec_def canon_ang(1) canon_ang(2) canon_ang_id)

lemma ang_vec_opposite_opposite':
  assumes "a1 \<noteq> E" "a2 \<noteq> E"
  shows "∡ (E - a1) (E - a2) = ∡ (a1 - E) (a2 - E)"
using ang_vec_opposite_opposite[of "E - a1" "E - a2"] assms
by (simp add: field_simps del: ang_vec_def)

lemma ang_vec_a_opposite2:
  "∡a z1 z2 = ∡a z1 (-z2)"
proof(cases "z2  = 0")
  case True
  thus ?thesis
    by (metis minus_zero)
next
  case False
  thus ?thesis
  proof(cases "∡ z1 z2 < -pi / 2")
    case True
    hence "∡ z1 z2 < 0"
      by auto (metis less_trans minus_pi_half_less_zero)
    have "∡a z1 z2 = pi + ∡ z1 z2"
      using True `∡ z1 z2 < 0`
      unfolding ang_vec_a_def ang_vec_c_def ang_vec_a_def abs_real_def
      by auto
    moreover
    have "∡a z1 (-z2) = pi + ∡ z1 z2"
      unfolding ang_vec_a_def ang_vec_c_def abs_real_def
      using canon_ang(1)[of "arg z2 - arg z1"] canon_ang(2)[of "arg z2 - arg z1"]
      using canon_ang_plus_pi2[of z1 z2] True `∡ z1 z2 < 0` `z2 \<noteq> 0`
      using ang_vec_opposite2[of z2 z1]
      by auto
    ultimately
    show ?thesis
      by auto
  next
    case False
    show ?thesis
    proof (cases "∡ z1 z2 \<le> 0")
      case True
      have "∡a z1 z2 = - ∡ z1 z2"
        using `\<not> ∡ z1 z2 < - pi / 2` True
        unfolding ang_vec_a_def ang_vec_c_def ang_vec_a_def abs_real_def
        by auto
      moreover
      have "∡a z1 (-z2) = - ∡ z1 z2"
        using `\<not> ∡ z1 z2 < - pi / 2` True
        unfolding ang_vec_a_def ang_vec_c_def abs_real_def
        using canon_ang_plus_pi2[of z1 z2]
        using canon_ang(1)[of "arg z2 - arg z1"] canon_ang(2)[of "arg z2 - arg z1"]
        using `z2 \<noteq> 0` ang_vec_opposite2[of z2 z1]
        by auto
      ultimately
      show ?thesis
        by simp
    next
      case False
      show ?thesis
      proof (cases "∡ z1 z2 < pi / 2")
        case True
        have "∡a z1 z2 = ∡ z1 z2"
          using `\<not> ∡ z1 z2 \<le> 0` True
          unfolding ang_vec_a_def ang_vec_c_def ang_vec_a_def abs_real_def
          by auto
        moreover
        have "∡a z1 (-z2) = ∡ z1 z2"
          using `\<not> ∡ z1 z2 \<le> 0` True
          unfolding ang_vec_a_def ang_vec_c_def abs_real_def
          using canon_ang_plus_pi1[of z1 z2]
          using canon_ang(1)[of "arg z2 - arg z1"] canon_ang(2)[of "arg z2 - arg z1"]
          using `z2 \<noteq> 0` ang_vec_opposite2[of z2 z1]
          by auto
        ultimately
        show ?thesis
          by simp
      next
        case False
        have "∡ z1 z2 > 0"
          using False
          by (metis less_linear less_trans pi_half_gt_zero)
        have "∡a z1 z2 = pi - ∡ z1 z2"
          using False `∡ z1 z2 > 0`
          unfolding ang_vec_a_def ang_vec_c_def ang_vec_a_def abs_real_def
          by auto
        moreover
        have "∡a z1 (-z2) = pi - ∡ z1 z2"
          unfolding ang_vec_a_def ang_vec_c_def abs_real_def
          using False `∡ z1 z2 > 0`
          using canon_ang_plus_pi1[of z1 z2]
          using canon_ang(1)[of "arg z2 - arg z1"] canon_ang(2)[of "arg z2 - arg z1"]
          using `z2 \<noteq> 0` ang_vec_opposite2[of z2 z1]
          by auto
        ultimately
        show ?thesis
          by auto
      qed
    qed
  qed
qed

lemma ang_vec_a_opposite1:
  "∡a z1 z2 = ∡a (-z1) z2"
using ang_vec_a_sym[of "-z1" z2] ang_vec_a_opposite2[of z2 z1] ang_vec_a_sym[of z2 z1]
by auto

lemma ang_vec_a_scale1:
  assumes "k \<noteq> 0"
  shows "∡a (complex_of_real k * z1) z2 = ∡a z1 z2"
proof (cases "k > 0")
  case True
  thus ?thesis
    unfolding ang_vec_a_def ang_vec_c_def ang_vec_def
    using arg_mult_real_positive[of k z1]
    by auto
next
  case False
  hence "k < 0"
    using assms
    by auto
  thus ?thesis
    using arg_mult_real_negative[of k z1]
    using ang_vec_a_opposite1[of z1 z2]
    unfolding ang_vec_a_def ang_vec_c_def ang_vec_def
    by simp
qed

lemma ang_vec_a_scale2:
  assumes "k \<noteq> 0"
  shows "∡a z1 (complex_of_real k * z2) = ∡a z1 z2"
using ang_vec_a_sym[of z1 "complex_of_real k * z2"]
using ang_vec_a_scale1[OF assms, of z2 z1]
using ang_vec_a_sym[of z1 z2]
by auto

lemma ang_vec_a_scale:
  assumes "k1 \<noteq> 0" "k2 \<noteq> 0"
  shows "∡a (complex_of_real k1 * z1) (complex_of_real k2 * z2) = ∡a z1 z2"
using ang_vec_a_scale1[OF assms(1)] ang_vec_a_scale2[OF assms(2)]
by auto

lemma ang_a_cnj_cnj:
  shows "∡a z1 z2 = ∡a (cnj z1) (cnj z2)"
unfolding ang_vec_a_def ang_vec_c_def ang_vec_def
proof(cases "arg z1 \<noteq> pi \<and> arg z2 \<noteq> pi")
  case True
  thus "acute_ang \<bar>\<downharpoonright>arg z2 - arg z1\<downharpoonleft>\<bar> = acute_ang \<bar>\<downharpoonright>arg (cnj z2) - arg (cnj z1)\<downharpoonleft>\<bar>"
    using arg_cnj2[of z1] arg_cnj2[of z2]
    apply (auto simp del:acute_ang_def)
    proof(cases "\<downharpoonright>arg z2 - arg z1\<downharpoonleft> = pi")
      case True
      thus "acute_ang \<bar>\<downharpoonright>arg z2 - arg z1\<downharpoonleft>\<bar> = acute_ang \<bar>\<downharpoonright>arg z1 - arg z2\<downharpoonleft>\<bar>"
        using  canon_ang_uminus_pi[of "arg z2 - arg z1"]
        by (auto simp add:field_simps)
    next
      case False
      thus "acute_ang \<bar>\<downharpoonright>arg z2 - arg z1\<downharpoonleft>\<bar> = acute_ang \<bar>\<downharpoonright>arg z1 - arg z2\<downharpoonleft>\<bar>"
        using  canon_ang_uminus[of "arg z2 - arg z1"]
        by (auto simp add:field_simps)
    qed
  next
    case False
    thus "acute_ang \<bar>\<downharpoonright>arg z2 - arg z1\<downharpoonleft>\<bar> = acute_ang \<bar>\<downharpoonright>arg (cnj z2) - arg (cnj z1)\<downharpoonleft>\<bar>"
    proof(cases "arg z1 = pi")
      case False
      hence "arg z2 = pi"
        using ` \<not> (arg z1 \<noteq> pi \<and> arg z2 \<noteq> pi)`
        by auto
      thus ?thesis
        using False
        using arg_cnj2[of z1] arg_cnj1[of z2]
        apply (auto simp del:acute_ang_def)
      proof(cases "arg z1 > 0")
          case True
          hence "-arg z1 \<le> 0"
            by auto
          thus "acute_ang \<bar>\<downharpoonright>pi - arg z1\<downharpoonleft>\<bar> = acute_ang \<bar>\<downharpoonright>pi + arg z1\<downharpoonleft>\<bar>"
            using True MoreComplex.canon_ang_plus_pi1[of "arg z1"]
            using arg_bounded[of z1] MoreComplex.canon_ang_plus_pi2[of "-arg z1"]
            by (auto simp add:field_simps)
        next
          case False
          hence "-arg z1 \<ge> 0"
             by simp
          thus "acute_ang \<bar>\<downharpoonright>pi - arg z1\<downharpoonleft>\<bar> = acute_ang \<bar>\<downharpoonright>pi + arg z1\<downharpoonleft>\<bar>"
          proof(cases "arg z1 = 0")
            case True
            thus ?thesis
              by (auto simp del:acute_ang_def)
          next
            case False
            hence "-arg z1 > 0"
              using `-arg z1 \<ge> 0`
              by auto
            thus ?thesis
            using False MoreComplex.canon_ang_plus_pi1[of "-arg z1"]
            using arg_bounded[of z1] MoreComplex.canon_ang_plus_pi2[of "arg z1"]
            by (auto simp add:field_simps)
        qed
      qed
    next
      case True
      thus ?thesis
        using arg_cnj1[of z1]
        apply (auto simp del:acute_ang_def)
      proof(cases "arg z2 = pi")
        case True
        thus "acute_ang \<bar>\<downharpoonright>arg z2 - pi\<downharpoonleft>\<bar> = acute_ang \<bar>\<downharpoonright>arg (cnj z2) - pi\<downharpoonleft>\<bar>"
          using arg_cnj1[of z2]
          by auto
      next
        case False
        thus "acute_ang \<bar>\<downharpoonright>arg z2 - pi\<downharpoonleft>\<bar> = acute_ang \<bar>\<downharpoonright>arg (cnj z2) - pi\<downharpoonleft>\<bar>"
          using arg_cnj2[of z2]
          apply (auto simp del:acute_ang_def)
        proof(cases "arg z2 > 0")
          case True
          hence "-arg z2 \<le> 0"
            by auto
          thus "acute_ang \<bar>\<downharpoonright>arg z2 - pi\<downharpoonleft>\<bar> = acute_ang \<bar>\<downharpoonright>- arg z2 - pi\<downharpoonleft>\<bar>"
            using True canon_ang_minus_pi1[of "arg z2"]
            using arg_bounded[of z2] canon_ang_minus_pi2[of "-arg z2"]
            by (auto simp add: field_simps)
        next
          case False
          hence "-arg z2 \<ge> 0"
             by simp
          thus "acute_ang \<bar>\<downharpoonright>arg z2 - pi\<downharpoonleft>\<bar> = acute_ang \<bar>\<downharpoonright>- arg z2 - pi\<downharpoonleft>\<bar>"
          proof(cases "arg z2 = 0")
            case True
            thus ?thesis
              by (auto simp del:acute_ang_def)
          next
            case False
            hence "-arg z2 > 0"
              using `-arg z2 \<ge> 0`
              by auto
            thus ?thesis
            using False canon_ang_minus_pi1[of "-arg z2"]
            using arg_bounded[of z2] canon_ang_minus_pi2[of "arg z2"]
            by (auto simp add:field_simps)
        qed
      qed
    qed
  qed
qed

abbreviation sgn_bool where
  "sgn_bool p \<equiv> if p then 1 else -1"

(* center - point on circle - orientation *)
definition circ_tang_vec :: "complex \<Rightarrow> complex \<Rightarrow> bool \<Rightarrow> complex" where
  "circ_tang_vec \<mu> E p = sgn_bool p * \<i> * (E - \<mu>)"

lemma circ_tang_vec_ortho:
  "scalprod (E - \<mu>) (circ_tang_vec \<mu> E p) = 0"
unfolding circ_tang_vec_def Let_def
  by auto

lemma circ_tang_vec_opposite_orient:
  "circ_tang_vec \<mu> E p = - circ_tang_vec \<mu> E (\<not> p)"
unfolding circ_tang_vec_def
by auto

definition ang_circ where
  "ang_circ E \<mu>1 \<mu>2 p1 p2 = ∡ (circ_tang_vec \<mu>1 E p1) (circ_tang_vec \<mu>2 E p2)"

definition ang_circ_c where
  "ang_circ_c E \<mu>1 \<mu>2 p1 p2 = ∡c (circ_tang_vec \<mu>1 E p1) (circ_tang_vec \<mu>2 E p2)"

definition ang_circ_a where
  "ang_circ_a E \<mu>1 \<mu>2 p1 p2 = ∡a (circ_tang_vec \<mu>1 E p1) (circ_tang_vec \<mu>2 E p2)"

lemma ang_circ_simp:
  assumes "E \<noteq> \<mu>1" "E \<noteq> \<mu>2"
  shows "ang_circ E \<mu>1 \<mu>2 p1 p2 = canon_ang (arg (E - \<mu>2) - arg (E - \<mu>1) + sgn_bool p1 * pi / 2 - sgn_bool p2 * pi / 2)"
unfolding ang_circ_def ang_vec_def circ_tang_vec_def
apply (rule canon_ang_eq)
using assms
using arg_mult_2kpi[of "sgn_bool p2*\<i>" "E - \<mu>2"]
using arg_mult_2kpi[of "sgn_bool p1*\<i>" "E - \<mu>1"]
apply auto
apply (rule_tac x="x-xa" in exI, auto simp add: field_simps)
apply (rule_tac x="-1+x-xa" in exI, auto simp add: field_simps)
apply (rule_tac x="1+x-xa" in exI, auto simp add: field_simps)
apply (rule_tac x="x-xa" in exI, auto simp add: field_simps)
done

lemma cos_ang_circ_simp:
  assumes "E \<noteq> \<mu>1" "E \<noteq> \<mu>2"
  shows "cos (ang_circ E \<mu>1 \<mu>2 p1 p2) = sgn_bool (p1 = p2) * cos (arg (E - \<mu>2) - arg (E - \<mu>1))"
  using assms
  using cos_periodic_pi2[of "arg (E - \<mu>2) - arg (E - \<mu>1)"]
  using cos_periodic_pi3[of "arg (E - \<mu>2) - arg (E - \<mu>1)"]
  using ang_circ_simp[OF assms, of p1 p2]
  by auto

lemma ang_circ_c_simp:
  assumes "E \<noteq> \<mu>1" "E \<noteq> \<mu>2"
  shows "ang_circ_c E \<mu>1 \<mu>2 p1 p2 = abs (canon_ang (arg(E - \<mu>2) - arg(E - \<mu>1) + (sgn_bool p1) * pi/2 - (sgn_bool p2) * pi/2))"
  unfolding ang_circ_c_def ang_vec_c_def
using ang_circ_simp[OF assms]
unfolding ang_circ_def
by auto

lemma ang_circ_a_simp:
  assumes "E \<noteq> \<mu>1" "E \<noteq> \<mu>2"
  shows "ang_circ_a E \<mu>1 \<mu>2 p1 p2 = acute_ang (abs (canon_ang (arg(E - \<mu>2) - arg(E - \<mu>1) + (sgn_bool p1) * pi/2 - (sgn_bool p2) * pi/2)))"
unfolding ang_circ_a_def ang_vec_a_def
using ang_circ_c_simp[OF assms]
unfolding ang_circ_c_def
by auto

lemma ang_circ_a_pTrue:
  assumes "E \<noteq> \<mu>1" "E \<noteq> \<mu>2"
  shows "ang_circ_a E \<mu>1 \<mu>2 p1 p2 = ang_circ_a E \<mu>1 \<mu>2 True True"
proof (cases "p1")
  case True
  show ?thesis
  proof (cases "p2")
    case True
    show ?thesis
      using `p1` `p2`
      by simp
  next
    case False
    show ?thesis
      using `p1` `\<not> p2`
      unfolding ang_circ_a_def
      using circ_tang_vec_opposite_orient[of \<mu>2 E p2]
      using ang_vec_a_opposite2
      by simp
  qed
next
  case False
  show ?thesis
  proof (cases "p2")
    case True
    show ?thesis
      using `\<not> p1` `p2`
      unfolding ang_circ_a_def
      using circ_tang_vec_opposite_orient[of \<mu>1 E p1]
      using ang_vec_a_opposite1
      by simp
  next
    case False
    show ?thesis
      using `\<not> p1` `\<not> p2`
      unfolding ang_circ_a_def
      using circ_tang_vec_opposite_orient[of \<mu>1 E p1] circ_tang_vec_opposite_orient[of \<mu>2 E p2]
      using ang_vec_a_opposite1  ang_vec_a_opposite2
      by simp
  qed
qed

lemma ang_circ_a_simp1:
  assumes "E \<noteq> \<mu>1" "E \<noteq> \<mu>2"
  shows "ang_circ_a E \<mu>1 \<mu>2 p1 p2 = ∡a (E - \<mu>1) (E - \<mu>2)"
unfolding ang_vec_a_def ang_vec_c_def ang_vec_def
by  (subst ang_circ_a_pTrue[OF assms, of p1 p2], subst ang_circ_a_simp[OF assms, of True True]) (metis add_diff_cancel)

abbreviation ang_circ_a' where
  "ang_circ_a' E \<mu>1 \<mu>2 \<equiv> ang_circ_a E \<mu>1 \<mu>2 True True"

lemma ang_circ_a'_simp:
  assumes "z \<noteq> \<mu>1" "z \<noteq> \<mu>2"
  shows "ang_circ_a' z \<mu>1 \<mu>2 = ∡a (z - \<mu>1) (z - \<mu>2)"
by (rule ang_circ_a_simp1[OF assms])

(* ------------------------------------------- *)
lemma cos_cmod_scalprod:
  shows "cmod b * cmod c * (cos (∡ b c)) = Re (scalprod b c)"
proof (cases "b = 0 \<or> c = 0")
  case True
  thus ?thesis
    by auto
next
  case False
  thus ?thesis
    by (simp add: cos_diff cos_arg sin_arg field_simps)
qed

lemma law_of_cosines:
  shows "(cdist B C)\<^sup>2 = (cdist A C)\<^sup>2 + (cdist A B)\<^sup>2 - 2*(cdist A C)*(cdist A B)*(cos (∡ (C-A) (B-A)))"
proof-
  let ?a = "C-B" and ?b = "C-A" and ?c = "B-A"
  have "?a = ?b - ?c"
    by simp
  hence "(cmod ?a)\<^sup>2 = (cmod (?b - ?c))\<^sup>2"
    by metis
  also have "... = Re (scalprod (?b-?c) (?b-?c))"
    by (simp add: cmod_square)
  also have "... = (cmod ?b)\<^sup>2 + (cmod ?c)\<^sup>2 - 2*Re (scalprod ?b ?c)"
    by (simp add: cmod_square field_simps)
  finally
  show ?thesis
    using cos_cmod_scalprod[of ?b ?c]
    by simp
qed

declare ang_vec_c_def[simp del]

lemma cos_c_: "cos (∡c z1 z2) = cos (∡ z1 z2)"
unfolding ang_vec_c_def
by (smt cos_minus)

lemma cos_a_c: "cos (∡a z1 z2) = abs (cos (∡c z1 z2))"
unfolding ang_vec_a_def
using ang_vec_c_bounded[of z1 z2] cos_lt_zero[of "∡c z1 z2"] cos_gt_zero_pi[of "∡c z1 z2"]
  by (cases "∡c z1 z2 = pi/2", auto)
     (smt cos_pi_half pi_def pi_half)

end
