section{* Elementary complex geometry *}
theory ElementaryComplexGeometry
imports MoreComplex LinearSystems
begin

(* -------------------------------------------------------------------------- *)

definition colinear :: "complex \<Rightarrow> complex \<Rightarrow> complex \<Rightarrow> bool" where
  "colinear z1 z2 z3 \<longleftrightarrow> z1 = z2 \<or> Im ((z3 - z1)/(z2 - z1)) = 0"

lemma colinear_ex_real:
  "colinear z1 z2 z3 \<longleftrightarrow> (\<exists> k::real. z1 = z2 \<or> z3 - z1 = complex_of_real k * (z2 - z1))"
unfolding colinear_def
by (auto split: if_split_asm) (metis complex_of_real_Re eq_iff_diff_eq_0 nonzero_eq_divide_eq)

lemma colinear_sym1:
  "colinear z1 z2 z3 \<longleftrightarrow> colinear z1 z3 z2"
unfolding colinear_def
using div_reals[of "1" "(z3 - z1)/(z2 - z1)"]  div_reals[of "1" "(z2 - z1)/(z3 - z1)"]
by auto

lemma colinear_sym2':
  assumes "colinear z1 z2 z3"
  shows "colinear z2 z1 z3"
proof-
  obtain k where "z1 = z2 \<or> z3 - z1 = complex_of_real k * (z2 - z1)"
    using assms
    unfolding colinear_ex_real
    by auto
  thus ?thesis
  proof
    assume "z3 - z1 = complex_of_real k * (z2 - z1)"
    thus ?thesis
      unfolding colinear_ex_real
      by (rule_tac x="1-k" in exI) (auto simp add: field_simps)
  qed (simp add: colinear_def)
qed

lemma colinear_sym2:
  "colinear z1 z2 z3 \<longleftrightarrow> colinear z2 z1 z3"
  using colinear_sym2'[of z1 z2 z3] colinear_sym2'[of z2 z1 z3]
  by auto

lemma colinear_trans1:
  assumes "colinear z0 z2 z1" "colinear z0 z3 z1" "z0 \<noteq> z1"
  shows "colinear z0 z2 z3"
using assms
unfolding colinear_ex_real
by (cases "z0 = z2", auto) (rule_tac x="k/ka" in exI, case_tac "ka = 0", auto simp add: field_simps)

lemma colinear_det:
  assumes "\<not> colinear z2 z3 z1"
  shows "det2 (z1 - z2) (cnj (z1 - z2)) (z2 - z3) (cnj (z2 - z3)) \<noteq> 0"
proof-
  from assms have "((z1 - z2) / (z3 - z2)) - cnj ((z1 - z2) / (z3 - z2)) \<noteq> 0" "z3 \<noteq> z2"
    unfolding colinear_def
    using im_complex[of "(z1 - z2) / (z3 - z2)"]
    by (auto simp add: Complex_eq)
  thus ?thesis
    by (auto simp add: field_simps)
qed

(* -------------------------------------------------------------------------- *)

definition line :: "complex \<Rightarrow> complex \<Rightarrow> complex set" where
  "line z1 z2 = {z. colinear z1 z2 z}"

lemma line_points_colinear:
  assumes "z1 \<in> line z z'" "z2 \<in> line z z'" "z3 \<in> line z z'" "z \<noteq> z'"
  shows "colinear z1 z2 z3"
using assms
unfolding line_def
by auto  (smt colinear_sym1 colinear_sym2 colinear_trans1)

lemma line_param:
  shows "z1 + complex_of_real k * (z2 - z1) \<in> line z1 z2"
  unfolding line_def
  by (auto simp add: colinear_def)

definition circle :: "complex \<Rightarrow> real \<Rightarrow> complex set" where
  "circle \<mu> r = {z. cmod (z - \<mu>) = r}"

(* -------------------------------------------------------------------------- *)

lemma line_equation:
  assumes "z1 \<noteq> z2" "\<mu> = rot90 (z2 - z1)"
  shows "line z1 z2 = {z. cnj \<mu>*z + \<mu>*cnj z - (cnj \<mu> * z1 + \<mu> * cnj z1)  = 0}"
proof-
  {
    fix z
    have "z \<in> line z1 z2 \<longleftrightarrow> Im ((z - z1)/(z2 - z1)) = 0"
      using assms
      by (simp add: line_def colinear_def)
    also have "... \<longleftrightarrow> (z - z1)/(z2 - z1) = cnj ((z - z1)/(z2 - z1))"
      using complex_diff_cnj[of "(z - z1)/(z2 - z1)"]
      by auto
    also have "... \<longleftrightarrow> (z - z1)*(cnj z2 - cnj z1) = (cnj z - cnj z1)*(z2 - z1)"
      using assms(1)
      by auto (metis (lifting) complex_cnj_cancel_iff complex_cnj_diff complex_cnj_divide frac_eq_eq right_minus_eq)+
    also have "... \<longleftrightarrow> cnj(z2 - z1)*z - (z2 - z1)*cnj z - (cnj(z2 - z1)*z1 - (z2 - z1)*cnj z1) = 0"
      by (simp add: field_simps)
    also have "... \<longleftrightarrow> cnj \<mu> * z + \<mu> * cnj z  - (cnj \<mu> * z1 + \<mu> * cnj z1) = 0"
      apply (subst assms)+
      apply (subst cnj_mix_minus)+
      by simp
    finally have "z \<in> line z1 z2 \<longleftrightarrow> cnj \<mu> * z + \<mu> * cnj z  - (cnj \<mu> * z1 + \<mu> * cnj z1) = 0"
      .
  }
  thus ?thesis
    by auto
qed

lemma circle_equation:
  assumes "r \<ge> 0"
  shows "circle \<mu> r = {z. z*cnj z - z*cnj \<mu> - cnj z*\<mu> + \<mu>*cnj \<mu> - complex_of_real (r*r) = 0}"
proof (safe)
  fix z

  assume "z \<in> circle \<mu> r"
  hence "(z - \<mu>)*cnj (z - \<mu>) = complex_of_real (r*r)"
    unfolding circle_def
    using complex_mult_cnj_cmod[of "z - \<mu>"]
    by (auto simp add: power2_eq_square)
  thus "z * cnj z - z * cnj \<mu> - cnj z * \<mu> + \<mu> * cnj \<mu> - complex_of_real (r * r) = 0"
    by (auto simp add: field_simps)
next
  fix z
  assume "z * cnj z - z * cnj \<mu> - cnj z * \<mu> + \<mu> * cnj \<mu> - complex_of_real (r * r) = 0"
  hence "(z - \<mu>)*cnj (z - \<mu>) = complex_of_real (r*r)"
    by (auto simp add: field_simps)
  thus "z \<in> circle \<mu> r"
    using assms
    using complex_mult_cnj_cmod[of "z - \<mu>"]
    using power2_eq_imp_eq[of "cmod (z - \<mu>)" r]
    unfolding circle_def power2_eq_square[symmetric] complex_of_real_def
    by auto
qed

(* --------------------------------------- *)

definition circline where
  "circline A BC D = {z. cor A*z*cnj z + cnj BC*z + BC*cnj z + cor D = 0}"

lemma circline_circle:
  assumes "A \<noteq> 0"  "A * D \<le> (cmod BC)\<^sup>2"
  "cl = circline A BC D"
  "\<mu> = -BC/complex_of_real A" "r2 = ((cmod BC)\<^sup>2 - A*D) / A\<^sup>2" "r = sqrt r2"
  shows "cl = circle \<mu> r"
proof-
  have *: "cl = {z. z * cnj z + cnj (BC / complex_of_real A) * z + (BC / complex_of_real A) * cnj z + complex_of_real (D / A) = 0}"
    using `cl = circline A BC D` `A \<noteq> 0`
    by (auto simp add: circline_def field_simps)

  have "r2 \<ge> 0"
  proof-
    have "(cmod BC)\<^sup>2 - A * D \<ge>  0"
      using `A * D \<le> (cmod BC)\<^sup>2`
      by auto
    thus ?thesis
      using `A \<noteq> 0` `r2 = ((cmod BC)\<^sup>2 - A*D) / A\<^sup>2`
      by (metis zero_le_divide_iff zero_le_power2)
  qed
  hence **: "r * r = r2" "r \<ge> 0"
    using `r = sqrt r2`
    by (auto simp add: real_sqrt_mult[symmetric])

  have ***: "- \<mu> * - cnj \<mu> - complex_of_real r2 = complex_of_real (D / A)"
    using `\<mu> = - BC / complex_of_real A` `r2 = ((cmod BC)\<^sup>2 - A * D) / A\<^sup>2`
    by (auto simp add: power2_eq_square complex_mult_cnj_cmod field_simps)
       (simp add: add_divide_eq_iff assms(1))
  thus ?thesis
    using `r2 = ((cmod BC)\<^sup>2 - A*D) / A\<^sup>2` `\<mu> = - BC / complex_of_real A`
    by (subst *, subst circle_equation[of r \<mu>, OF `r \<ge> 0`], subst **) (auto simp add: field_simps power2_eq_square)
qed

lemma circline_ex_circle:
  assumes "A \<noteq> 0"  "A * D \<le> (cmod BC)\<^sup>2"
  "cl = circline A BC D"
  shows "\<exists> \<mu> r. cl = circle \<mu> r"
using circline_circle[OF assms]
by auto

lemma circle_circline:
  assumes "cl = circle \<mu> r" "r \<ge> 0"
  shows "cl = circline 1 (-\<mu>) ((cmod \<mu>)\<^sup>2 - r\<^sup>2)"
proof-
  have "complex_of_real ((cmod \<mu>)\<^sup>2 - r\<^sup>2) = \<mu> * cnj \<mu> - complex_of_real (r\<^sup>2)"
    by (auto simp add: complex_mult_cnj_cmod)
  thus "cl = circline 1 (- \<mu>) ((cmod \<mu>)\<^sup>2 - r\<^sup>2)"
    using assms
    using circle_equation[of r \<mu>]
    unfolding circline_def power2_eq_square
    by (simp add: field_simps)
qed

lemma circle_ex_circline:
  assumes "cl = circle \<mu> r" "r \<ge> 0"
  shows "\<exists> A BC D. A \<noteq> 0 \<and> A*D \<le> (cmod BC)\<^sup>2 \<and> cl = circline A BC D"
  using circle_circline[OF assms]
  using `r \<ge> 0`
  by (rule_tac x=1 in exI, rule_tac x="-\<mu>" in exI, rule_tac x="Re (\<mu> * cnj \<mu>) - (r * r)" in exI) (simp add: complex_mult_cnj_cmod power2_eq_square)


lemma circline_line:
assumes
  "A = 0" "BC \<noteq> 0"
  "cl = circline A BC D"
  "z1 = - cor D * BC / (2 * BC * cnj BC)"
  "z2 = z1 + \<i> * sgn (if arg BC > 0 then -BC else BC)"
shows
  "cl = line z1 z2"
proof-
  have "cl = {z. cnj BC*z + BC*cnj z + complex_of_real D = 0}"
    using assms
    by (simp add: circline_def)
    have "{z. cnj BC*z + BC*cnj z + complex_of_real D = 0} =
          {z. cnj BC*z + BC*cnj z - (cnj BC*z1 + BC*cnj z1) = 0}"
      using  `BC \<noteq> 0` assms
      by simp
    moreover
    have "z1 \<noteq> z2"
      using `BC \<noteq> 0` assms
      by (auto simp add: sgn_eq)
    moreover
    have "\<exists> k. k \<noteq> 0 \<and> BC = cor k*rot90 (z2 - z1)"
      using assms
      apply auto
      apply (rule_tac x="(cmod BC)" in exI, simp add: Complex_scale4)
      apply (rule_tac x="-(cmod BC)" in exI, simp, smt Complex.Re_sgn Im_sgn cis_arg complex_minus complex_surj mult_minus_right rcis_cmod_arg rcis_def)
      done
    then obtain k where "cor k \<noteq> 0" "BC = cor k*rot90 (z2 - z1)"
      by auto
    moreover
    have *: "\<And> z. cnj_mix (BC / cor k) z - cnj_mix (BC / cor k) z1 = (1/cor k) * (cnj_mix BC z - cnj_mix BC z1)"
      using `cor k \<noteq> 0`
      by (simp add: field_simps)
    hence "{z. cnj_mix BC z - cnj_mix BC z1 = 0} = {z. cnj_mix (BC / cor k) z - cnj_mix (BC / cor k) z1 = 0}"
      using `cor k \<noteq> 0`
      by auto
    ultimately
    have "cl = line z1 z2"
      using line_equation[of z1 z2 "BC/cor k"] `cl = {z. cnj BC*z + BC*cnj z + complex_of_real D = 0}`
      by auto
    thus ?thesis
      using `z1 \<noteq> z2`
      by blast
qed


lemma circline_ex_line:
assumes
  "A = 0" "BC \<noteq> 0"
  "cl = circline A BC D"
shows "\<exists> z1 z2. z1 \<noteq> z2 \<and> cl = line z1 z2"
proof-
  let ?z1 = "- cor D * BC / (2 * BC * cnj BC)"
  let ?z2 = "?z1 + \<i> * sgn (if 0 < arg BC then - BC else BC)"
  have "?z1 \<noteq> ?z2"
    using `BC \<noteq> 0`
    by (simp add: sgn_eq)
  thus ?thesis
    using circline_line[OF assms, of ?z1 ?z2] `BC \<noteq> 0`
    by (rule_tac x="?z1" in exI, rule_tac x="?z2" in exI, simp)
qed

lemma line_ex_circline:
  assumes "cl = line z1 z2" "z1 \<noteq> z2"
  shows "\<exists> BC D. BC \<noteq> 0 \<and> cl = circline 0 BC D"
proof-
  let ?BC = "rot90 (z2 - z1)"
  let ?D = "Re (- 2 * scalprod z1 ?BC)"
  show ?thesis
  proof (rule_tac x="?BC" in exI, rule_tac x="?D" in exI, rule conjI)
    show "?BC \<noteq> 0"
      using `z1 \<noteq> z2` rot90_ii[of "z2 - z1"]
      by auto
  next
    have *: "complex_of_real (Re (- 2 * scalprod z1 (rot90 (z2 - z1)))) = - (cnj_mix z1 (rot90 (z2 - z1)))"
      using rot90_ii[of "z2 - z1"]
      by (cases z1, cases z2, simp add: Complex_eq field_simps)
    show "cl = circline 0 ?BC ?D"
      apply (subst assms, subst line_equation[of z1 z2 ?BC])
      unfolding circline_def
      by (fact, simp, subst *, simp add: field_simps)
  qed
qed

lemma circline_line':
  assumes "z1 \<noteq> z2"
  shows "circline 0 (\<i> * (z2 - z1)) (Re (- cnj_mix (\<i> * (z2 - z1)) z1)) = line z1 z2"
proof-
  let ?B = "\<i> * (z2 - z1)"
  let ?D = "Re (- cnj_mix ?B z1)"
  have "circline 0 ?B ?D = {z. cnj ?B*z + ?B*cnj z + complex_of_real ?D = 0}"
    using assms
    by (simp add: circline_def)
  moreover
  have "is_real (- cnj_mix (\<i> * (z2 - z1)) z1)"
    using cnj_mix_real[of ?B z1]
    by auto
  hence "{z. cnj ?B*z + ?B*cnj z + complex_of_real ?D = 0} =
         {z. cnj ?B*z + ?B*cnj z - (cnj ?B*z1 + ?B*cnj z1) = 0}"
    apply (subst complex_of_real_Re, simp)
    unfolding diff_conv_add_uminus
    by simp
  moreover
  have "line z1 z2 = {z. cnj_mix (\<i> * (z2 - z1)) z - cnj_mix (\<i> * (z2 - z1)) z1 = 0}"
    using line_equation[of z1 z2 ?B] assms
    unfolding rot90_ii
    by simp
  ultimately
  show ?thesis
    by simp
qed

end
