theory HyperbolicFunctions
imports HOL.Transcendental MoreComplex
begin

definition cosh :: "real \<Rightarrow> real" where
  "cosh x = (exp x + exp (-x)) / 2"
definition acosh :: "real \<Rightarrow> real" where
  "acosh x = ln (x + sqrt(x\<^sup>2 - 1))"

lemma [simp]: "cosh 0 = 1"
  unfolding cosh_def
  by simp

lemma [simp]: "acosh 1 = 0"
  unfolding acosh_def
  by simp

lemma cosh_acosh [simp]:
  assumes "x \<ge> 1"
  shows "cosh (acosh x) = x"
proof-
  from assms
  have  **: "x + sqrt(x\<^sup>2 - 1) \<ge> 1"
    by (smt one_le_power real_sqrt_ge_zero)
  hence *: "x + sqrt(x\<^sup>2 - 1) \<noteq> 0"
    by simp
  moreover
  have "sqrt (x\<^sup>2 - 1) + 1 / (x + sqrt (x\<^sup>2 - 1)) = x" (is "?lhs = x")
  proof-
    have "?lhs = (x*sqrt(x\<^sup>2 - 1) + x\<^sup>2) / (x + sqrt(x\<^sup>2 - 1))"
      using * `x \<ge> 1`
      by (subst add_divide_eq_iff, simp, simp add: field_simps)
    also have "... = x * (sqrt(x\<^sup>2 - 1) + x) / (x + sqrt(x\<^sup>2 - 1))"
      by (simp add: field_simps power2_eq_square)
    finally
    show ?thesis
      using nonzero_mult_div_cancel_right[OF *, of x]
      by (simp add: field_simps)
  qed
  thus ?thesis
    using ln_div[of 1, symmetric] **
    unfolding acosh_def
    unfolding cosh_def
    by simp
qed

lemma acosh_cosh [simp]:
  assumes "x \<ge> 0"
  shows "acosh (cosh x) = x"
proof -
  have "2*exp(x)*exp(-x) = 2"
    by (simp add: exp_minus_inverse)
  have "((exp(x) + exp(-x))/2)\<^sup>2 - 1 = (exp(x) + exp(-x))\<^sup>2/4 - 1"
    by (simp add: power_divide)
  also have "... = ((exp(x))\<^sup>2 +  (exp (-x))\<^sup>2 + 2)/4 - 1"
    using comm_semiring_1_class.power2_sum[of "exp(x)" "exp(-x)"] `2*exp(x)*exp(-x) = 2`
    by auto
  also have "... = ((exp(x))\<^sup>2 +  (exp (-x))\<^sup>2 -2)/4"
    by auto
  also have "... = ((exp(x))\<^sup>2 +  (exp (-x))\<^sup>2 -2*exp(x)*exp(-x))/4"
    using `2*exp(x)*exp(-x) = 2`
    by auto
  also have "... = (exp(x) -  exp (-x))\<^sup>2/4"
    using comm_ring_1_class.power2_diff[of "exp(x)" "exp(-x)"]
    by auto
  also have "... = ((exp(x) -  exp (-x))/2)\<^sup>2"
    by (simp add: power_divide)
  finally have  "((exp(x) + exp(-x))/2)\<^sup>2 - 1 = ((exp(x) -  exp (-x))/2)\<^sup>2"
    by simp

  have "(exp(x) -  exp (-x))/2 \<ge> 0"
    using assms
    by simp

  have "(exp(x) + exp(-x))/2 + sqrt(((exp(x) + exp(-x))/2)\<^sup>2 - 1) = (exp(x) + exp(-x))/2 + sqrt(((exp(x) -  exp (-x))/2)\<^sup>2)"
    using `((exp(x) + exp(-x))/2)\<^sup>2 - 1 = ((exp(x) -  exp (-x))/2)\<^sup>2`
    by auto
  also have "... = (exp(x) + exp(-x))/2 + ((exp(x) -  exp (-x))/2)"
    using `(exp(x) -  exp (-x))/2 \<ge> 0`
    by auto
  also have "... = exp(x)"
    by (simp add:field_simps)
  finally have "(exp(x) + exp(-x))/2 + sqrt(((exp(x) + exp(-x))/2)\<^sup>2 - 1) = exp(x)"
    by simp

  thus ?thesis
      unfolding acosh_def
      unfolding cosh_def
      by auto
qed


 
  

lemma acosh_ge_0 [simp]:
  assumes "x \<ge> 1"
  shows "acosh x \<ge> 0"
  using assms
  unfolding acosh_def
  by (smt ln_ge_zero one_le_power real_sqrt_ge_zero)

lemma acosh_eq_0_iff:
  assumes "x \<ge> 1"
  shows "acosh x = 0 \<longleftrightarrow> x = 1"
  using assms
  unfolding acosh_def
  by (smt exp_ln ln_one one_le_power one_power2 real_sqrt_ge_zero real_sqrt_zero)

lemma acosh_eq_iff:
  assumes "x \<ge> 1" "y \<ge> 1"
  shows "acosh x = acosh y \<longleftrightarrow> x = y"
  using assms
  unfolding acosh_def
  apply (subst ln_inj_iff)
  apply (smt one_le_power real_sqrt_ge_0_iff)
  apply (smt one_le_power real_sqrt_ge_0_iff)
  apply (smt power_mono real_sqrt_le_mono)
  done

lemma cosh_ge_1 [simp]:
  shows "cosh x \<ge> 1"
proof-
  have "(exp x - 1)\<^sup>2 \<ge> 0"
    by auto
  thus ?thesis
    unfolding power2_eq_square
    unfolding cosh_def
    by (auto simp add: exp_minus field_simps)
qed

lemma cosh_gt_1 [simp]:
  assumes "x > 0"
  shows "cosh x > 1"
proof-
  have "(exp x - 1)\<^sup>2 > 0"
    using assms
    by auto
  thus ?thesis
    unfolding power2_eq_square
    unfolding cosh_def
    by (auto simp add: exp_minus field_simps)
qed

lemma cosh_eq_iff:
  assumes "x \<ge> 0" "y \<ge> 0"
  shows "cosh x = cosh y \<longleftrightarrow> x = y"
proof
  assume "cosh x = cosh y"
  hence "acosh (cosh x) = acosh (cosh y)"
    by simp
  thus "x = y"
    using acosh_cosh assms
    by auto
qed auto

lemma acosh_mono:
  assumes "x \<ge> 1" "y \<ge> 1"
  shows "acosh x \<ge> acosh y \<longleftrightarrow> x \<ge> y"
  using assms
  by (smt acosh_def ln_le_cancel_iff one_le_power real_sqrt_ge_zero real_sqrt_le_iff square_cancel)

lemma acosh_add:
  assumes "x \<ge> 1" "y \<ge> 1"
  shows "acosh x + acosh y = acosh (x*y + sqrt((x\<^sup>2 - 1)*(y\<^sup>2 - 1)))"
proof-
  have "sqrt ((x\<^sup>2 - 1) * (y\<^sup>2 - 1)) \<ge> 0"
    using assms
    by simp
  moreover
  have "x * y \<ge> 1"
    using assms
    by (smt mult_le_cancel_left1)
  ultimately
  have "x * y + sqrt ((x\<^sup>2 - 1) * (y\<^sup>2 - 1)) \<ge> 1"
    by linarith
  hence 1: "0 \<le> (x * y + sqrt ((x\<^sup>2 - 1) * (y\<^sup>2 - 1)))\<^sup>2 - 1"
      by simp

  have 2: "x * sqrt (y\<^sup>2 - 1) + y * sqrt (x\<^sup>2 - 1) \<ge> 0"
    using assms
    by simp

  have "(x*sqrt(y\<^sup>2 - 1)+y*sqrt(x\<^sup>2 -1))\<^sup>2 = (sqrt((x*y+sqrt((x\<^sup>2-1)*(y\<^sup>2-1)))\<^sup>2 - 1))\<^sup>2"
    using assms
  proof (subst real_sqrt_pow2)
    show "0 \<le> (x * y + sqrt ((x\<^sup>2 - 1) * (y\<^sup>2 - 1)))\<^sup>2 - 1"
      by fact
  next
    have "(x * sqrt (y\<^sup>2 - 1))\<^sup>2 = x\<^sup>2 * (y\<^sup>2 - 1)"
      using assms
      apply (subst power_mult_distrib)
      apply (subst real_sqrt_pow2, simp_all)
      done
    moreover
    have "(y * sqrt (x\<^sup>2 - 1))\<^sup>2 = y\<^sup>2 * (x\<^sup>2 - 1)"
      using assms
      apply (subst power_mult_distrib)
      apply (subst real_sqrt_pow2, simp_all)
      done
    ultimately show "(x * sqrt (y\<^sup>2 - 1) + y * sqrt (x\<^sup>2 - 1))\<^sup>2 = (x * y + sqrt ((x\<^sup>2 - 1) * (y\<^sup>2 - 1)))\<^sup>2 - 1"
      using assms
      unfolding power2_sum
      apply (simp add: real_sqrt_mult power_mult_distrib)
      apply (simp add: field_simps)
      done
  qed
  hence "sqrt ((x * y + sqrt ((x\<^sup>2 - 1) * (y\<^sup>2 - 1)))\<^sup>2 - 1) = x * sqrt (y\<^sup>2 - 1) + y * sqrt (x\<^sup>2 - 1)"
    using power2_eq_iff_nonneg[OF 2 real_sqrt_ge_zero[OF 1]]
    by simp
  thus ?thesis
    unfolding acosh_def
    using assms
    apply (subst ln_mult[symmetric])
    apply (smt one_le_power real_sqrt_ge_0_iff)
    apply (smt one_le_power real_sqrt_ge_0_iff)
    apply (simp add: real_sqrt_mult)
    apply (simp add: field_simps)
    done
qed

lemma acosh_double:
  assumes "x \<ge> 1"
  shows "2 * acosh x = acosh (2*x\<^sup>2 - 1)"
proof-
  from assms have "x\<^sup>2 \<ge> 1"
    by auto
  thus ?thesis
    using assms acosh_add[of x x]
    by (simp add: power2_eq_square)
qed

end
