section{* Systems of linear equations *}
(* TODO: merge with matrices *)
theory LinearSystems
imports MoreComplex
begin

definition det2 where
  [simp]: "det2 a11 a12 a21 a22 \<equiv> a11*a22 - a12*a21"

lemma regular_homogenous_system:
  fixes a11::complex
  assumes "a11*a22 - a12*a21 \<noteq> 0" "a11*x1 + a12*x2 = 0" "a21*x1 + a22*x2 = 0"
  shows "x1 = 0 \<and> x2 = 0"
proof (cases "a11 = 0")
  case True
  with assms(1) have "a12 \<noteq> 0" "a21 \<noteq> 0"
    by auto
  thus ?thesis
    using `a11 = 0` assms(2) assms(3)
    by auto
next
  case False
  hence "x1 = - a12*x2 / a11"
    using assms(2)
    by (metis eq_neg_iff_add_eq_0 mult_minus_left nonzero_mult_div_cancel_left)
  hence "a21 * (- a12 * x2 / a11) + a22 * x2 = 0"
    using assms(3)
    by simp
  hence "a21 * (- a12 * x2) + a22 * x2 * a11 = 0"
    using  `a11 \<noteq> 0`
    by auto
  hence "(a11*a22 - a12*a21)*x2 = 0"
    by (simp add: field_simps)
  thus ?thesis
    using assms(1) assms(2) `a11 \<noteq> 0`
    by auto
qed

lemma regular_system:
  fixes a11::complex
  assumes "a11*a22 - a12*a21 \<noteq> 0"
  shows "\<exists>! x.
       a11*(fst x) + a12*(snd x) = b1 \<and>
       a21*(fst x) + a22*(snd x) = b2"
proof
  let ?d = "a11*a22 - a12*a21" and ?d1 = "b1*a22 - b2*a12" and ?d2 = "b2*a11 - b1*a21"
  let ?x = "(?d1 / ?d, ?d2 / ?d)"
  have "a11 * ?d1 + a12 * ?d2 = b1*?d" "a21 * ?d1 + a22 * ?d2 = b2*?d"
    by (auto simp add: field_simps)
  thus "a11 * fst ?x + a12 * snd ?x = b1 \<and> a21 * fst ?x + a22 * snd ?x = b2"
    using assms
    by (metis (hide_lams, no_types) add_divide_distrib eq_divide_imp fst_eqD snd_eqD times_divide_eq_right)

  fix x'
  assume "a11 * fst x' + a12 * snd x' = b1 \<and> a21 * fst x' + a22 * snd x' = b2"
  with `a11 * fst ?x + a12 * snd ?x = b1 \<and> a21 * fst ?x + a22 * snd ?x = b2`
  have "a11 * (fst x' - fst ?x) + a12 * (snd x' - snd ?x) = 0 \<and> a21 * (fst x' - fst ?x) + a22 * (snd x' - snd ?x) = 0"
    by (auto simp add: field_simps)
  thus "x' = ?x"
    using regular_homogenous_system[OF assms, of "fst x' - fst ?x" "snd x' - snd ?x"]
    by (cases x') auto
qed

lemma singular_system:
  fixes a11::complex
  assumes "a11*a22 - a12*a21 = 0" "a11 \<noteq> 0 \<or> a12 \<noteq> 0"
  assumes *: "a11*fst x0 + a12*snd x0 = b1" "a21*fst x0 + a22*snd x0 = b2"
  assumes **: "a11*fst x + a12*snd x = b1"
  shows "a21*fst x + a22*snd x = b2"
proof (cases "a11 = 0")
  case True
  with assms have "a21 = 0" "a12 \<noteq> 0"
    by auto
  let ?k = "a22 / a12"
  have "b2 = ?k * b1"
    using * `a11 = 0` `a21 = 0` `a12 \<noteq> 0`
    by auto
  thus ?thesis
    using `a11 = 0` `a21 = 0` `a12 \<noteq> 0` **
    by auto
next
  case False
  let ?k = "a21 / a11"
  from **
  have "?k * a11 * fst x + ?k * a12 * snd x = ?k * b1"
    using `a11 \<noteq> 0`
    by (auto simp add: field_simps)
  moreover
  have "a21 = ?k * a11" "a22 = ?k * a12" "b2 = ?k * b1"
    using assms(1) * `a11 \<noteq> 0`
    by (auto simp add: field_simps)
  ultimately
  show ?thesis
    by auto
qed

lemma cnj_equation:
  assumes "a*z1 + b*z2 = c"
  shows "cnj a * cnj z1 + cnj b * cnj z2 = cnj c"
using assms
by auto

lemma regular_cnj_system:
  assumes "det2 a1 (cnj a1) a2 (cnj a2) \<noteq> 0" "is_real b1" "is_real b2"
  shows "\<exists>! \<mu>. a1 * cnj \<mu> + cnj a1 * \<mu> = b1 \<and>
               a2 * cnj \<mu> + cnj a2 * \<mu> = b2"
proof-
  have "\<exists>! x. a1 * fst x + cnj a1 * snd x = b1 \<and>
              a2 * fst x + cnj a2 * snd x = b2"
    using regular_system assms(1)
    by simp

  then obtain x where
    *:  "a1 * fst x + cnj a1 * snd x = b1"
        "a2 * fst x + cnj a2 * snd x = b2"
    and **:
    "\<forall>x'. a1 * fst x' + cnj a1 * snd x' = b1 \<and>
          a2 * fst x' + cnj a2 * snd x' = b2 \<longrightarrow>
           x' = x"
    unfolding Ex1_def
    by blast
  have "cnj b1 = b1" "cnj b2 = b2"
    using `is_real b1` `is_real b2`
    using eq_cnj_iff_real
    by force+
  hence "a1 * cnj (snd x) + cnj a1 * cnj (fst x) = b1"
        "a2 * cnj (snd x) + cnj a2 * cnj (fst x) = b2"
    using cnj_equation[OF *(1)] cnj_equation[OF *(2)] `is_real b1` `is_real b2`
    by (auto simp add: field_simps)
  hence "(cnj (snd x), cnj (fst x)) = x"
    using **
    by auto
  hence "fst x = cnj (snd x)"
    by (cases x)  auto
  show ?thesis
    unfolding Ex1_def
  proof (rule_tac x="snd x" in exI, safe)
    fix y
    assume "b1 = a1 * cnj y + cnj a1 * y" "b2 = a2 * cnj y + cnj a2 * y"
    thus "y = snd x"
      using **[rule_format, of "(cnj y, y)"]
      by (cases x) auto
  next
    show "a1 * cnj (snd x) + cnj a1 * snd x = b1" "a2 * cnj (snd x) + cnj a2 * snd x = b2"
      using * `fst x = cnj (snd x)`
      by auto
  qed
qed

end
