theory PoincareTarski
  imports Poincare Tarski
begin

section{* Poincare satisfies Tarski axioms *}

(* ------------------------------------------------------------------ *)
subsection{* Pasch axiom *}
(* ------------------------------------------------------------------ *)

lemma Pasch_fun_mono:
  fixes r1 r2 :: real
  assumes "0 < r1" "r1 \<le> r2" "r2 < 1"
  shows "r1 + 1/r1 \<ge> r2 + 1/r2"
proof (cases "r1 = r2")
  case True
  thus ?thesis
    by simp
next
  case False
  hence "r2 - r1 > 0"
    using assms
    by simp

  have "r1 * r2 < 1"
    using assms
    by (smt mult_le_cancel_left1)
  hence "1 / (r1 * r2) > 1"
    using assms
    by simp
  hence "(r2 - r1) / (r1 * r2) > (r2 - r1)"
    using `r2 - r1 > 0`
    using mult_less_cancel_left_pos[of "r2 - r1" 1 "1 / (r1 * r2)"]
    by simp
  hence "1 / r1 - 1 / r2 > r2 - r1"
    using assms
    by (simp add: field_simps)
  thus ?thesis
    by simp
qed

lemma Pasch_nondeg:
  assumes "x \<in> unit_disc" "y \<in> unit_disc" "z \<in> unit_disc" "u \<in> unit_disc" "v \<in> unit_disc"
  assumes "distinct [x, y, z, u, v]" 
  assumes "\<not> poincare_colinear {x, y, z}" 
  assumes "poincare_between x u z" "poincare_between y v z"
  shows "\<exists> a. a \<in> unit_disc \<and> poincare_between u a y \<and> poincare_between x a v"
proof-
  have "\<forall> y z u. distinct [x, y, z, u, v] \<and> \<not> poincare_colinear {x, y, z} \<and> y \<in> unit_disc \<and> z \<in> unit_disc \<and> u \<in> unit_disc \<and>
                 poincare_between x u z \<and> poincare_between y v z \<longrightarrow> (\<exists> a. a \<in> unit_disc \<and> poincare_between u a y \<and> poincare_between x a v)" (is "?P x v")
  proof (rule wlog_positive_x_axis[where P="?P"])
    fix v
    assume v: "is_real v" "0 < Re v" "Re v < 1"
    hence "of_complex v \<in> unit_disc"
      by (auto simp add: cmod_eq_Re)
    show "?P 0\<^sub>h (of_complex v)"
    proof safe
      fix y z u
      assume distinct: "distinct [0\<^sub>h, y, z, u, of_complex v]"
      assume in_disc: "y \<in> unit_disc" "z \<in> unit_disc" "u \<in> unit_disc"
      then obtain y' z' u'
        where *: "y = of_complex y'" "z = of_complex z'" "u = of_complex u'"
        using inf_or_of_complex inf_notin_unit_disc
        by metis

      have "y' \<noteq> 0" "z' \<noteq> 0" "u' \<noteq> 0" "v \<noteq> 0" "y' \<noteq> z'" "y' \<noteq> u'" "z' \<noteq> u'" "y \<noteq> z" "y \<noteq> u" "z \<noteq> u"
        using of_complex_inj distinct *
        by auto

      note distinct = distinct this

      assume "\<not> poincare_colinear {0\<^sub>h, y, z}"

      hence nondeg_yz: "y'*cnj z' \<noteq> cnj y' * z'"
        using * poincare_colinear_zero_iff[of y' z'] in_disc distinct
        by auto

      assume "poincare_between 0\<^sub>h u z"

      hence "arg u' = arg z'" "cmod u' \<le> cmod z'"
        using * poincare_between_0uv[of u z] distinct in_disc
        by auto

      then obtain \<phi> ru rz where
        uz_polar: "u' = cor ru * cis \<phi>" "z' = cor rz * cis \<phi>" "0 < ru" "ru \<le> rz" "0 < rz" and
                  "\<phi> = arg u'" "\<phi> = arg z'"
        using * `u' \<noteq> 0` `z' \<noteq> 0`
        by (smt cmod_cis norm_le_zero_iff)

      obtain \<theta> ry where
        y_polar: "y' = cor ry * cis \<theta>" "ry > 0" and "\<theta> = arg y'"
        using `y' \<noteq> 0`
        by (smt cmod_cis norm_le_zero_iff)

      from in_disc * `u' = cor ru * cis \<phi>` `z' = cor rz * cis \<phi>` `y' = cor ry * cis \<theta>`
      have "ru < 1" "rz < 1" "ry < 1"
        by simp_all

      note polar = this y_polar uz_polar

      have nondeg: "cis \<theta> * cis (- \<phi>) \<noteq> cis (- \<theta>) * cis \<phi>"
        using nondeg_yz polar
        by simp

      let ?yz = "poincare_line y z"
      let ?v = "calc_x_axis_intersection ?yz"

      assume "poincare_between y (of_complex v) z"

      hence "of_complex v \<in> circline_set ?yz"
        using in_disc `of_complex v \<in> unit_disc`
        using distinct poincare_between_poincare_colinear[of y "of_complex v" z]
        using unique_poincare_line[of y z]
        by (auto simp add: poincare_colinear_def)
      moreover
      have "of_complex v \<in> circline_set x_axis"
        using `is_real v`
        unfolding circline_set_x_axis
        by auto
      moreover
      have "?yz \<noteq> x_axis"
      proof (rule ccontr)
        assume "\<not> ?thesis"
        hence "{0\<^sub>h, y, z} \<subseteq> circline_set (poincare_line y z)"
          unfolding circline_set_def
          using distinct poincare_line[of y z]
          by auto
        hence "poincare_colinear {0\<^sub>h, y, z}"
          unfolding poincare_colinear_def
          using distinct
          by force
        thus False
          using `\<not> poincare_colinear {0\<^sub>h, y, z}`
          by simp
      qed
      ultimately
      have "?v = of_complex v" "intersects_x_axis ?yz"
        using unique_calc_x_axis_intersection[of "poincare_line y z" "of_complex v"]
        using intersects_x_axis_iff[of ?yz]
        using distinct `of_complex v \<in> unit_disc`
        by (metis IntI is_poincare_line_poincare_line)+

      have "intersects_x_axis_positive ?yz"
        using `Re v > 0` `of_complex v \<in> unit_disc`
        using `of_complex v \<in> circline_set ?yz` `of_complex v \<in> circline_set x_axis`
        using intersects_x_axis_positive_iff[of ?yz] `y \<noteq> z` `?yz \<noteq> x_axis`
        unfolding positive_x_axis_def
        by force

      have "y \<notin> circline_set x_axis"
      proof (rule ccontr)
        assume "\<not> ?thesis"
        moreover
        hence "poincare_line y (of_complex v) = x_axis"
          using distinct `of_complex v \<in> circline_set x_axis`
          using in_disc `of_complex v \<in> unit_disc`
          using unique_poincare_line[of y "of_complex v" x_axis]
          by simp
        moreover
        have "z \<in> circline_set (poincare_line y (of_complex v))"
          using `of_complex v \<in> circline_set ?yz`
          using unique_poincare_line[of y "of_complex v" "poincare_line y z"]
          using in_disc `of_complex v \<in> unit_disc` distinct
          using poincare_line[of y z]
          unfolding circline_set_def
          by (metis distinct_length_2_or_more is_poincare_line_poincare_line mem_Collect_eq)
        ultimately
        have "y \<in> circline_set x_axis" "z \<in> circline_set x_axis"
          by auto
        hence "poincare_colinear {0\<^sub>h, y, z}"
          unfolding poincare_colinear_def
          by force
        thus False
          using `\<not> poincare_colinear {0\<^sub>h, y, z}`
          by simp
      qed

      moreover

      (* TODO: avoid copy-paste proofs *)
      have "z \<notin> circline_set x_axis"
      proof (rule ccontr)
        assume "\<not> ?thesis"
        moreover
        hence "poincare_line z (of_complex v) = x_axis"
          using distinct `of_complex v \<in> circline_set x_axis`
          using in_disc `of_complex v \<in> unit_disc`
          using unique_poincare_line[of z "of_complex v" x_axis]
          by simp
        moreover
        have "y \<in> circline_set (poincare_line z (of_complex v))"
          using `of_complex v \<in> circline_set ?yz`
          using unique_poincare_line[of z "of_complex v" "poincare_line y z"]
          using in_disc `of_complex v \<in> unit_disc` distinct
          using poincare_line[of y z]
          unfolding circline_set_def
          by (metis distinct_length_2_or_more is_poincare_line_poincare_line mem_Collect_eq)
        ultimately
        have "y \<in> circline_set x_axis" "z \<in> circline_set x_axis"
          by auto
        hence "poincare_colinear {0\<^sub>h, y, z}"
          unfolding poincare_colinear_def
          by force
        thus False
          using `\<not> poincare_colinear {0\<^sub>h, y, z}`
          by simp
      qed

      ultimately

      have "\<phi> * \<theta> < 0"
        using `poincare_between y (of_complex v) z`
        using poincare_between_x_axis_intersection[of y z "of_complex v"]
        using in_disc `of_complex v \<in> unit_disc` distinct
        using `of_complex v \<in> circline_set ?yz` `of_complex v \<in> circline_set x_axis`
        using `\<phi> = arg z'` `\<theta> = arg y'` *
        by (simp add: field_simps)

      have "\<phi> \<noteq> pi" "\<phi> \<noteq> 0"
        using `z \<notin> circline_set x_axis` * polar cis_pi
        unfolding circline_set_x_axis
        by auto

      have "\<theta> \<noteq> pi" "\<theta> \<noteq> 0"
        using `y \<notin> circline_set x_axis` * polar cis_pi
        unfolding circline_set_x_axis
        by auto

      have phi_sin: "\<phi> > 0 \<longleftrightarrow> sin \<phi> > 0" "\<phi> < 0 \<longleftrightarrow> sin \<phi> < 0"
        using `\<phi> = arg z'` `\<phi> \<noteq> 0` `\<phi> \<noteq> pi`
        using arg_bounded[of z']
        by (smt sin_gt_zero sin_le_zero sin_pi_minus sin_0_iff_normalized sin_ge_zero)+

      have theta_sin: "\<theta> > 0 \<longleftrightarrow> sin \<theta> > 0" "\<theta> < 0 \<longleftrightarrow> sin \<theta> < 0"
        using `\<theta> = arg y'` `\<theta> \<noteq> 0` `\<theta> \<noteq> pi`
        using arg_bounded[of y']
        by (smt sin_gt_zero sin_le_zero sin_pi_minus sin_0_iff_normalized sin_ge_zero)+

      have "sin \<phi> * sin \<theta> < 0"
        using `\<phi> * \<theta> < 0` phi_sin theta_sin
        by auto (smt mult_nonneg_nonneg mult_pos_neg mult_neg_pos mult_neg_neg)+

      have "sin (\<phi> - \<theta>) \<noteq> 0"
      proof (rule ccontr)
        assume "\<not> ?thesis"
        hence "sin (\<phi> - \<theta>) = 0"
          by simp
        have "- 2 * pi < \<phi> - \<theta>" "\<phi> - \<theta> < 2 * pi"
          using `\<phi> = arg z'` `\<theta> = arg y'` arg_bounded[of z'] arg_bounded[of y'] `\<phi> \<noteq> pi` `\<theta> \<noteq> pi`
          by auto
        hence "\<phi> - \<theta> = -pi \<or> \<phi> - \<theta> = 0 \<or> \<phi> - \<theta> = pi"
          using `sin (\<phi> - \<theta>) = 0`
          by (smt sin_0_iff_normalized sin_periodic_pi2)
        moreover
        {
          assume "\<phi> - \<theta> = - pi"
          hence "\<phi> = \<theta> - pi"
            by simp
          hence False
            using nondeg_yz
            using `y' = cor ry * cis \<theta>` `z' = cor rz * cis \<phi>` `rz > 0` `ry > 0`
            by auto
        }
        moreover
        {
          assume "\<phi> - \<theta> = 0"
          hence "\<phi> = \<theta>"
            by simp
          hence False
            using `y' = cor ry * cis \<theta>` `z' = cor rz * cis \<phi>` `rz > 0` `ry > 0`
            using nondeg_yz
            by auto
        }
        moreover
        {
          assume "\<phi> - \<theta> = pi"
          hence "\<phi> = \<theta> + pi"
            by simp
          hence False
            using `y' = cor ry * cis \<theta>` `z' = cor rz * cis \<phi>` `rz > 0` `ry > 0`
            using nondeg_yz
            by auto
        }
        ultimately
        show False
          by auto
      qed

      have "u \<notin> circline_set x_axis"
        using * polar `\<phi> \<noteq> 0` in_disc
        unfolding circline_set_x_axis
        by auto (smt cis.simps(2) distinct(4) is_real_complex_of_real is_real_mult_real mult_not_zero of_complex_inj phi_sin(1) phi_sin(2))

      let ?yu = "poincare_line y u"
      have nondeg_yu: "y' * cnj u' \<noteq> cnj u' * u'"
        using nondeg_yz polar `ru > 0` `rz > 0` distinct
        by auto

      {
        (* derive results simultaneously for both u and z *)
        fix r :: real
        assume "r > 0"

        have den: "cor ry * cis \<theta> * cnj 1 * cnj (cor r * cis \<phi>) * 1 - cor r * cis \<phi> * cnj 1 * cnj (cor ry * cis \<theta>) * 1 \<noteq> 0"
          using `0 < r` `0 < ry` nondeg
          by auto

        let ?A = "2 * r * ry * sin(\<phi> - \<theta>)"
        let ?B = "\<i> * (r * cis \<phi> * (1 + ry\<^sup>2) - ry * cis \<theta> * (1 + r\<^sup>2))"
        let ?ReB = "ry * (1 + r\<^sup>2) * sin \<theta> - r * (1 + ry\<^sup>2) * sin \<phi>"

        have "Re (\<i> * (r * cis (-\<phi>) * ry * cis (\<theta>) - ry * cis (-\<theta>) * r * cis (\<phi>))) = ?A"
          by (simp add: sin_diff field_simps)
        moreover
        have "cor ry * cis (- \<theta>) * (cor ry * cis \<theta>) = ry\<^sup>2"  "cor r * cis (- \<phi>) * (cor r * cis \<phi>) = r\<^sup>2"
          by (metis cis_inverse cis_neq_zero divide_complex_def cor_squared nonzero_mult_div_cancel_right power2_eq_square semiring_normalization_rules(15))+
        ultimately
        have 1: "poincare_line_cvec_cmat (of_complex_cvec (cor ry * cis \<theta>)) (of_complex_cvec (cor r * cis \<phi>)) = (?A, ?B, cnj ?B, ?A)"
          using den
          unfolding poincare_line_cvec_cmat_def of_complex_cvec_def Let_def prod.case
          by (simp add: field_simps)

        have 2: "is_real ?A"
          by simp
        let ?mix = "cis \<theta> * cis (- \<phi>) - cis (- \<theta>) * cis \<phi>"
        have "is_imag ?mix"
          using eq_minus_cnj_iff_imag[of ?mix]
          by simp
        hence "Im ?mix \<noteq> 0"
          using nondeg
          using complex.expand[of ?mix 0]
          by auto
        hence 3: "Re ?A \<noteq> 0"
          using `r > 0` `ry > 0`
          by (simp add: sin_diff field_simps)

        have "?A \<noteq> 0"
          using 2 3
          by auto
        hence 4: "cor ?A \<noteq> 0"
          using 2 3
          by (metis zero_complex.simps(1))

        have 5: "?ReB / ?A = (sin \<theta>) / (2 * sin(\<phi> - \<theta>)) * (1/r + r) - (sin \<phi>) / (2 * sin (\<phi> - \<theta>)) * (1/ry + ry)" 
          using `ry > 0` `r > 0`
          apply (subst diff_divide_distrib)             
          apply (subst add_frac_num, simp)
          apply (subst add_frac_num, simp)
          apply (simp add: power2_eq_square mult.commute)
          apply (simp add: field_simps)
          done

        have "poincare_line_cvec_cmat (of_complex_cvec (cor ry * cis \<theta>)) (of_complex_cvec (cor r * cis \<phi>)) = (?A, ?B, cnj ?B, ?A) \<and>
                is_real ?A \<and> Re ?A \<noteq> 0 \<and> ?A \<noteq> 0 \<and> cor ?A \<noteq> 0 \<and>
                Re ?B = ?ReB \<and>
                ?ReB / ?A = (sin \<theta>) / (2 * sin(\<phi> - \<theta>)) * (1/r + r) - (sin \<phi>) / (2 * sin (\<phi> - \<theta>)) * (1/ry + ry)"
          using 1 2 3 4 5
          by auto
      }
      note ** = this

      let ?Ayz = "2 * rz * ry * sin (\<phi> - \<theta>)"
      let ?Byz = "\<i> * (rz * cis \<phi> * (1 + ry\<^sup>2) - ry * cis \<theta> * (1 + rz\<^sup>2))"
      let ?ReByz = "ry * (1 + rz\<^sup>2) * sin \<theta> - rz * (1 + ry\<^sup>2) * sin \<phi>"
      let ?Kz = "(sin \<theta>) / (2 * sin(\<phi> - \<theta>)) * (1/rz + rz) - (sin \<phi>) / (2 * sin (\<phi> - \<theta>)) * (1/ry + ry)"
      have yz: "poincare_line_cvec_cmat (of_complex_cvec (cor ry * cis \<theta>)) (of_complex_cvec (cor rz * cis \<phi>)) = (?Ayz, ?Byz, cnj ?Byz, ?Ayz)"
        "is_real ?Ayz" "Re ?Ayz \<noteq> 0" "?Ayz \<noteq> 0" "cor ?Ayz \<noteq> 0" "Re ?Byz = ?ReByz" and Kz: "?ReByz / ?Ayz = ?Kz"
        using **[OF `0 < rz`]
        by auto

      let ?Ayu = "2 * ru * ry * sin (\<phi> - \<theta>)"
      let ?Byu = "\<i> * (ru * cis \<phi> * (1 + ry\<^sup>2) - ry * cis \<theta> * (1 + ru\<^sup>2))"
      let ?ReByu = "ry * (1 + ru\<^sup>2) * sin \<theta> - ru * (1 + ry\<^sup>2) * sin \<phi>"
      let ?Ku = "(sin \<theta>) / (2 * sin(\<phi> - \<theta>)) * (1/ru + ru) - (sin \<phi>) / (2 * sin (\<phi> - \<theta>)) * (1/ry + ry)"
      have yu: "poincare_line_cvec_cmat (of_complex_cvec (cor ry * cis \<theta>)) (of_complex_cvec (cor ru * cis \<phi>)) = (?Ayu, ?Byu, cnj ?Byu, ?Ayu)"
        "is_real ?Ayu" "Re ?Ayu \<noteq> 0" "?Ayu \<noteq> 0" "cor ?Ayu \<noteq> 0" "Re ?Byu = ?ReByu" and Ku: "?ReByu / ?Ayu = ?Ku"
        using **[OF `0 < ru`]
        by auto

      have "?Ayz \<noteq> 0"
        using `sin (\<phi> - \<theta>) \<noteq> 0` `ry > 0` `rz > 0`
        by auto

      have "Re ?Byz / ?Ayz < -1"
        using `intersects_x_axis_positive ?yz`
          * `y' = cor ry * cis \<theta>` `z' = cor rz * cis \<phi>` `u' = cor ru * cis \<phi>`
        apply simp
        apply (transfer fixing: ry rz ru \<theta> \<phi>)
        apply (transfer fixing: ry rz ru \<theta> \<phi>)
      proof-
        assume "intersects_x_axis_positive_cmat (poincare_line_cvec_cmat (of_complex_cvec (cor ry * cis \<theta>)) (of_complex_cvec (cor rz * cis \<phi>)))"
        thus "(ry * sin \<theta> * (1 + rz\<^sup>2) - rz * sin \<phi> * (1 + ry\<^sup>2)) / (2 * rz * ry * sin (\<phi> - \<theta>)) < - 1"
          using yz
          by simp
      qed

      have "?ReByz / ?Ayz \<ge> ?ReByu / ?Ayu"
      proof (cases "sin \<phi> > 0")
        case True
        hence "sin \<theta> < 0"
          using `sin \<phi> * sin \<theta> < 0`
          by (smt mult_nonneg_nonneg)

        have "?ReByz < 0"
        proof-
          have "ry * (1 + rz\<^sup>2) * sin \<theta> < 0"
            using `ry > 0` `rz > 0`
            using `sin \<theta> < 0`
            by (smt mult_pos_neg mult_pos_pos zero_less_power)
          moreover
          have "rz * (1 + ry\<^sup>2) * sin \<phi> > 0"
            using `ry > 0` `rz > 0`
            using `sin \<phi> > 0`
            by (smt mult_pos_neg mult_pos_pos zero_less_power)
          ultimately
          show ?thesis
            by simp
        qed
        have "?Ayz > 0"
          using `Re ?Byz / ?Ayz < -1` `Re ?Byz = ?ReByz` `?ReByz < 0`
          by (smt divide_less_0_iff)
        hence "sin (\<phi> - \<theta>) > 0"
          using `ry > 0` `rz > 0`
          by (smt mult_pos_pos zero_less_mult_pos)

        have "1 / ru + ru \<ge> 1 / rz + rz"
          using Pasch_fun_mono[of ru rz] `0 < ru` `ru \<le> rz` `rz < 1`
          by simp
        hence "sin \<theta> * (1 / ru + ru) \<le> sin \<theta> * (1 / rz + rz)"
          using `sin \<theta> < 0`
          by auto
        thus ?thesis
          using `ru > 0` `rz > 0` `ru \<le> rz` `rz < 1` `?Ayz > 0` `sin (\<phi> - \<theta>) > 0`
          using divide_right_mono[of "sin \<theta> * (1 / ru + ru)" "sin \<theta> * (1 / rz + rz)" "2 * sin (\<phi> - \<theta>)"]
          by (subst Kz, subst Ku) simp
      next
        assume "\<not> sin \<phi> > 0"
        hence "sin \<phi> < 0"
          using `sin \<phi> * sin \<theta> < 0`
          by (cases "sin \<phi> = 0", simp_all)
        hence "sin \<theta> > 0"
          using `sin \<phi> * sin \<theta> < 0`
          by (smt mult_nonpos_nonpos)
        have "?ReByz > 0"
        proof-
          have "ry * (1 + rz\<^sup>2) * sin \<theta> > 0"
            using `ry > 0` `rz > 0`
            using `sin \<theta> > 0`
            by (smt mult_pos_neg mult_pos_pos zero_less_power)
          moreover
          have "rz * (1 + ry\<^sup>2) * sin \<phi> < 0"
            using `ry > 0` `rz > 0`
            using `sin \<phi> < 0`
            by (smt mult_pos_neg mult_pos_pos zero_less_power)
          ultimately
          show ?thesis
            by simp
        qed
        have "?Ayz < 0"
          using `Re ?Byz / ?Ayz < -1` `?Ayz \<noteq> 0` `Re ?Byz = ?ReByz` `?ReByz > 0`
          by (smt divide_less_0_iff)
        hence "sin (\<phi> - \<theta>) < 0"
          using `ry > 0` `rz > 0`
          by (smt mult_nonneg_nonneg)

        have "1 / ru + ru \<ge> 1 / rz + rz"
          using Pasch_fun_mono[of ru rz] `0 < ru` `ru \<le> rz` `rz < 1`
          by simp
        hence "sin \<theta> * (1 / ru + ru) \<ge> sin \<theta> * (1 / rz + rz)"
          using `sin \<theta> > 0`
          by auto
        thus ?thesis
          using `ru > 0` `rz > 0` `ru \<le> rz` `rz < 1` `?Ayz < 0` `sin (\<phi> - \<theta>) < 0`
          using divide_right_mono_neg[of  "sin \<theta> * (1 / rz + rz)" "sin \<theta> * (1 / ru + ru)" "2 * sin (\<phi> - \<theta>)"]
          by (subst Kz, subst Ku) simp
      qed

      have "intersects_x_axis_positive ?yu"
        using * `y' = cor ry * cis \<theta>` `z' = cor rz * cis \<phi>` `u' = cor ru * cis \<phi>`
        apply simp
        apply (transfer fixing: ry rz ru \<theta> \<phi>)
        apply (transfer fixing: ry rz ru \<theta> \<phi>)
      proof-
        have "Re ?Byu / ?Ayu < -1"
          using `Re ?Byz / ?Ayz < -1` `?ReByz / ?Ayz \<ge> ?ReByu / ?Ayu`
          by (subst (asm) `Re ?Byz = ?ReByz`, subst `Re ?Byu = ?ReByu`) simp
        thus "intersects_x_axis_positive_cmat (poincare_line_cvec_cmat (of_complex_cvec (cor ry * cis \<theta>)) (of_complex_cvec (cor ru * cis \<phi>)))"
          using yu
          by simp
      qed

      let ?a = "calc_x_axis_intersection ?yu"
      have "?a \<in> positive_x_axis" "?a \<in> circline_set ?yu" "?a \<in> unit_disc"
        using `intersects_x_axis_positive ?yu`
        using intersects_x_axis_positive_iff'[of ?yu] `y \<noteq> u`
        by auto

      then obtain a' where a': "?a = of_complex a'" "is_real a'" "Re a' > 0" "Re a' < 1"
        unfolding positive_x_axis_def circline_set_x_axis
        by (auto simp add: cmod_eq_Re)

      have "intersects_x_axis ?yz" "intersects_x_axis ?yu"
        using `intersects_x_axis_positive ?yz` `intersects_x_axis_positive ?yu`
        by auto

      show "\<exists>a. a \<in> unit_disc \<and> poincare_between u a y \<and> poincare_between 0\<^sub>h a (of_complex v)"
      proof (rule_tac x="?a" in exI, safe)
        show "poincare_between u ?a y"
          using poincare_between_x_axis_intersection[of y u ?a]
          using calc_x_axis_intersection[OF is_poincare_line_poincare_line[OF `y \<noteq> u`] `intersects_x_axis ?yu`]
          using calc_x_axis_intersection_in_unit_disc[OF is_poincare_line_poincare_line[OF `y \<noteq> u`] `intersects_x_axis ?yu`]
          using in_disc `y \<noteq> u` `y \<notin> circline_set x_axis` `u \<notin> circline_set x_axis`
          using * `\<phi> = arg u'` `\<theta> = arg y'` `\<phi> * \<theta> < 0`
          by (subst poincare_between_rev, auto simp add: mult.commute)
      next
        show "poincare_between 0\<^sub>h ?a (of_complex v)"
        proof-
          have "-?ReByz / ?Ayz \<le> -?ReByu / ?Ayu"
            using `?ReByz / ?Ayz \<ge> ?ReByu / ?Ayu`
            by linarith
          have "outward ?yz ?yu"
            using * `y' = cor ry * cis \<theta>` `z' = cor rz * cis \<phi>` `u' = cor ru * cis \<phi>`
            apply simp
            apply (transfer fixing: ry rz ru \<theta> \<phi>)
            apply (transfer fixing: ry rz ru \<theta> \<phi>)
            apply (subst yz yu)+
            unfolding outward_cmat_def
            apply (simp only: Let_def prod.case)
            apply (subst yz yu)+
            using `-?ReByz / ?Ayz \<le> -?ReByu / ?Ayu`
            by simp
          hence "Re a' \<le> Re v"
            using `?v = of_complex v`
            using `?a = of_complex a'`
            using `intersects_x_axis_positive ?yz` `intersects_x_axis_positive ?yu`
            using outward[OF is_poincare_line_poincare_line[OF `y \<noteq> z`] is_poincare_line_poincare_line[OF `y \<noteq> u`]]
            by simp
          thus ?thesis
            using `?v = of_complex v`
            using poincare_between_x_axis_0uv[of "Re a'" "Re v"] a' v
            by (simp add: complex_of_real_Re)
        qed
      next
        show "?a \<in> unit_disc"
          by fact
      qed
    qed
  next
    show "x \<in> unit_disc" "v \<in> unit_disc" "x \<noteq> v"
      using assms
      by auto
  next
    fix M x v
    let ?Mx = "moebius_pt M x" and ?Mv = "moebius_pt M v"
    assume 1: "unit_disc_fix M" "x \<in> unit_disc" "v \<in> unit_disc" "x \<noteq> v"
    assume 2: "?P ?Mx ?Mv"
    show "?P x v"
    proof safe
      fix y z u
      let ?My = "moebius_pt M y" and ?Mz = "moebius_pt M z" and ?Mu = "moebius_pt M u"
      assume "distinct [x, y, z, u, v]" "\<not> poincare_colinear {x, y, z}" "y \<in> unit_disc" "z \<in> unit_disc" "u \<in> unit_disc"
             "poincare_between x u z" "poincare_between y v z"
      hence "\<exists> Ma. Ma \<in> unit_disc \<and> poincare_between ?Mu Ma ?My \<and> poincare_between ?Mx Ma ?Mv"
        using 1 2[rule_format, of ?My ?Mz ?Mu]
        by simp
      then obtain Ma where Ma: "Ma \<in> unit_disc" "poincare_between ?Mu Ma ?My \<and> poincare_between ?Mx Ma ?Mv"
        by blast
      let ?a = "moebius_pt (-M) Ma"
      let ?Ma = "moebius_pt M ?a"
      have "?Ma = Ma"
        by (metis moebius_pt_invert uminus_moebius_def)
      hence "?Ma \<in> unit_disc" "poincare_between ?Mu ?Ma ?My \<and> poincare_between ?Mx ?Ma ?Mv"
        using Ma
        by auto
      thus "\<exists>a. a \<in> unit_disc \<and> poincare_between u a y \<and> poincare_between x a v"
        using unit_disc_fix_moebius_inv[OF `unit_disc_fix M`] `unit_disc_fix M` `Ma \<in> unit_disc`
        using `u \<in> unit_disc` `v \<in> unit_disc` `x \<in> unit_disc` `y \<in> unit_disc`
        by (rule_tac x="?a" in exI, simp del: moebius_pt_comp_inv_right)
    qed
  qed
  thus ?thesis
    using assms
    by auto
qed

lemma Pasch_deg:
  assumes "x \<in> unit_disc" "y \<in> unit_disc" "z \<in> unit_disc" "u \<in> unit_disc" "v \<in> unit_disc"
  assumes "\<not> distinct [x, y, z, u, v] \<or> poincare_colinear {x, y, z}"
  assumes "poincare_between x u z" "poincare_between y v z"
  shows "\<exists> a. a \<in> unit_disc \<and> poincare_between u a y \<and> poincare_between x a v"
proof(cases "poincare_colinear {x, y, z}")
  case True
  hence "poincare_between x y z \<or> poincare_between y x z \<or> poincare_between y z x"
    using assms(1, 2, 3) colinear_between poincare_between_rev by blast
  show ?thesis
  proof(cases "poincare_between x y z")
    case True
    have "poincare_between x y v"
      using True assms poincare_between_transitivity
      by (meson poincare_between_rev)
    thus ?thesis
      using assms(2)
      by (rule_tac x="y" in exI, simp)
  next
    case False
    hence "poincare_between y x z \<or> poincare_between y z x"
      using `poincare_between x y z \<or> poincare_between y x z \<or> poincare_between y z x`
      by simp
    show ?thesis
    proof(cases "poincare_between y x z")
      case True
      hence "poincare_between u x y"
        using assms
        by (meson poincare_between_rev poincare_between_transitivity)
      thus ?thesis
        using assms
        by (rule_tac x="x" in exI, simp)
    next
      case False
      hence "poincare_between y z x"
        using `poincare_between y x z \<or> poincare_between y z x`
        by auto
      hence "poincare_between x z v"
        using assms
        by (meson poincare_between_rev poincare_between_transitivity)
      hence "poincare_between x u v"
        using assms poincare_between_transitivity poincare_between_rev
        by (smt poincare_between_sum_distances)
      thus ?thesis
        using assms
        by (rule_tac x="u" in exI, simp)
    qed
  qed
next
  case False
  hence "\<not> distinct [x, y, z, u, v]"
    using assms(6) by auto
  show ?thesis
  proof(cases "u=z")
    case True
    thus ?thesis
      using assms
      apply(rule_tac x="v" in exI)
      by(simp add:poincare_between_rev)
  next
    case False (* "u \<noteq> z" *)
    hence "x \<noteq> z"
      using assms poincare_between_sandwich by blast
    show ?thesis
    proof(cases "v=z")
      case True
      thus ?thesis
        using assms
        by (rule_tac x="u" in exI, simp)
    next
      case False (* v \<noteq> z *)
      hence "y \<noteq> z"
        using assms poincare_between_sandwich by blast
      show ?thesis
      proof(cases "u = x")
        case True
        thus ?thesis
          using assms
          by (rule_tac x="x" in exI, simp)
      next
        case False (*u \<noteq> x*)
        have "x \<noteq> y"
          using assms `\<not> poincare_colinear {x, y, z}`
          by fastforce
        have "x \<noteq> v"
          using assms `\<not> poincare_colinear {x, y, z}`
          by (metis insert_commute poincare_between_poincare_colinear)
        have "u \<noteq> y"
          using assms `\<not> poincare_colinear {x, y, z}`
          using poincare_between_poincare_colinear by blast
        have "u \<noteq> v"
        proof(rule ccontr)
          assume "\<not> u \<noteq> v"
          hence "poincare_between x v z"
            using assms by auto
          hence "x \<in> circline_set (poincare_line z v)"
            using poincare_between_rev[of x v z]
            using poincare_between_poincare_line_uvz[of z v x]
            using assms `v \<noteq> z`
            by auto
          have "y \<in> circline_set (poincare_line z v)"
            using assms `\<not> u \<noteq> v` 
            using poincare_between_rev[of y v z]
            using poincare_between_poincare_line_uvz[of z v y]
            using assms `v \<noteq> z`
            by auto
          have "z \<in> circline_set (poincare_line z v)"
            using ex_poincare_line_two_points[of z v] `v \<noteq> z`
            by auto
          have "is_poincare_line (poincare_line z v)"
            using `v \<noteq> z`
            by auto
          hence "poincare_colinear {x, y, z}"
            using `x \<in> circline_set (poincare_line z v)`
            using `y \<in> circline_set (poincare_line z v)`
            using `z \<in> circline_set (poincare_line z v)`
            unfolding poincare_colinear_def
            by (rule_tac x="poincare_line z v" in exI, simp)            
          thus False
            using `\<not> poincare_colinear {x, y, z}` by simp
        qed
        have "v = y"
          using `u \<noteq> v` `u \<noteq> y` `x \<noteq> v` `x \<noteq> y` `u \<noteq> x` `y \<noteq> z` `v \<noteq> z` `x \<noteq> z` `u \<noteq> z`
          using `\<not> distinct [x, y, z, u, v]`
          by auto
        thus ?thesis
          using assms
          by (rule_tac x="y" in exI, simp)
      qed
    qed
  qed
qed


lemma Pasch:
  assumes "x \<in> unit_disc" "y \<in> unit_disc" "z \<in> unit_disc" "u \<in> unit_disc" "v \<in> unit_disc"
  assumes "poincare_between x u z" "poincare_between y v z"
  shows "\<exists> a. a \<in> unit_disc \<and> poincare_between u a y \<and> poincare_between x a v"
proof(cases "distinct [x, y, z, u, v] \<and> \<not> poincare_colinear {x, y, z}")
  case True
  thus ?thesis
    using assms Pasch_nondeg by auto
next
  case False
  thus ?thesis
    using assms Pasch_deg by auto
qed

(* ------------------------------------------------------------------ *)
subsection{* Segment construction axiom *}
(* ------------------------------------------------------------------ *)

lemma segment_construction:
  assumes "x \<in> unit_disc" "y \<in> unit_disc"
  assumes "a \<in> unit_disc" "b \<in> unit_disc"
  shows "\<exists> z. z \<in> unit_disc \<and> poincare_between x y z \<and> poincare_distance y z = poincare_distance a b"
proof-
  obtain d where d: "d = poincare_distance a b"
    by auto
  have "d \<ge> 0"
    using assms
    by (simp add: d poincare_distance_ge0)

  have "\<exists> z. z \<in> unit_disc \<and> poincare_between x y z \<and> poincare_distance y z = d" (is "?P x y")
  proof (cases "x = y")
    case True
    have "\<exists> z. z \<in> unit_disc \<and> poincare_distance x z = d"
    proof (rule wlog_zero)
      show "\<exists> z. z \<in> unit_disc \<and> poincare_distance 0\<^sub>h z = d"
        using ex_x_axis_poincare_distance_negative[of d] `d \<ge> 0`
        by blast
    next
      show "x \<in> unit_disc"
        by fact
    next
      fix a u
      assume "u \<in> unit_disc" "cmod a < 1"
      assume "\<exists>z. z \<in> unit_disc \<and> poincare_distance (moebius_pt (blaschke a) u) z = d"
      then obtain z where *: "z \<in> unit_disc" "poincare_distance (moebius_pt (blaschke a) u) z = d"
        by auto
      obtain z' where z': "z = moebius_pt (blaschke a) z'" "z' \<in> unit_disc"
        using `z \<in> unit_disc`
        using unit_disc_fix_iff[of "blaschke a"] `cmod a < 1`
        using blaschke_unit_disc_fix[of a]
        by blast

      show "\<exists>z. z \<in> unit_disc \<and> poincare_distance u z = d"
        using * z' `u : unit_disc`
        using blaschke_unit_disc_fix[of a] `cmod a < 1`
        by (rule_tac x=z' in exI, simp)
    qed
    thus ?thesis
      using `x = y`
      unfolding poincare_between_def
      by auto
  next
    case False
    show ?thesis
    proof (rule wlog_positive_x_axis[where P="\<lambda> y x. ?P x y"])
      fix x
      assume "is_real x" "0 < Re x" "Re x < 1"

      then obtain z where z: "is_real z" "Re z \<le> 0" "- 1 < Re z" "of_complex z \<in> unit_disc"
        "of_complex z \<in> unit_disc" "of_complex z \<in> circline_set x_axis" "poincare_distance 0\<^sub>h (of_complex z) = d"
        using ex_x_axis_poincare_distance_negative[of d] `d \<ge> 0`
        by auto

      have "poincare_between (of_complex x) 0\<^sub>h (of_complex z)"
      proof (cases "z = 0")
        case True
        thus ?thesis
          unfolding poincare_between_def
          by auto
      next
        case False
        have "x \<noteq> 0"
          using `is_real x` `Re x > 0`
          by auto
        thus ?thesis
          using poincare_between_x_axis_u0v[of x z]
          using z `is_real x` `x \<noteq> 0` `Re x > 0` False
          using complex_eq_if_Re_eq mult_pos_neg
          by fastforce
    qed
    thus "?P (of_complex x) 0\<^sub>h"
      using `poincare_distance 0\<^sub>h (of_complex z) = d` `of_complex z \<in> unit_disc`
      by blast
  next
    show "x \<in> unit_disc" "y \<in> unit_disc"
      by fact+
  next
    show "y \<noteq> x" using `x \<noteq> y` by simp
  next
    fix M u v
    assume "unit_disc_fix M" "u \<in> unit_disc" "v \<in> unit_disc" "u \<noteq> v"
    assume "?P (moebius_pt M v) (moebius_pt M u)"
    then obtain z where *: "z \<in> unit_disc" "poincare_between (moebius_pt M v) (moebius_pt M u) z" "poincare_distance (moebius_pt M u) z = d"
      by auto
    obtain z' where z': "z = moebius_pt M z'" "z' \<in> unit_disc"
        using `z \<in> unit_disc`
        using unit_disc_fix_iff[of M] `unit_disc_fix M`
        by blast
      thus "?P v u"
        using * `u \<in> unit_disc` `v \<in> unit_disc` `unit_disc_fix M`
        by auto
    qed
  qed
  thus ?thesis
    using assms d
    by auto
qed

(* ------------------------------------------------------------------ *)
subsection{* Five segment axiom *}
(* ------------------------------------------------------------------ *)

lemma five_segment_axiom:
  assumes
     in_disc: "x \<in> unit_disc"  "y \<in> unit_disc" "z \<in> unit_disc" "u \<in> unit_disc" and
     in_disc': "x' \<in> unit_disc" "y' \<in> unit_disc" "z' \<in> unit_disc" "u' \<in> unit_disc" and
      "x \<noteq> y" and
      betw: "poincare_between x y z" "poincare_between x' y' z'" and
      xy: "poincare_distance x y = poincare_distance x' y'" and
      xu: "poincare_distance x u = poincare_distance x' u'" and
      yu: "poincare_distance y u = poincare_distance y' u'" and
      yz: "poincare_distance y z = poincare_distance y' z'"
    shows
     "poincare_distance z u = poincare_distance z' u'"
proof-
  from assms obtain M where
  M: "unit_disc_fix_f M" "M x = x'" "M u = u'" "M y = y'"
    using unit_disc_fix_f_congruent_triangles[of x y u]
    by blast
  have "M z = z'"
  proof (rule unique_poincare_distance_on_ray[where u=x' and v=y' and y="M z" and z=z' and d="poincare_distance x z"])
    show "0 \<le> poincare_distance x z"
      using poincare_distance_ge0 in_disc
      by simp
  next
    show "x' \<noteq> y'"
      using M `x \<noteq> y`
      using in_disc in_disc' poincare_distance_eq_0_iff xy
      by auto
  next
    show "poincare_distance x' (M z) = poincare_distance x z"
      using M in_disc
      unfolding unit_disc_fix_f_def
      by auto
  next
    show "M z \<in> unit_disc"
      using M in_disc
      unfolding unit_disc_fix_f_def
      by auto
  next
    show "poincare_distance x' z' = poincare_distance x z"
      using xy yz betw
      using poincare_between_sum_distances[of x y z]
      using poincare_between_sum_distances[of x' y' z']
      using in_disc in_disc'
      by auto
  next
    show "poincare_between x' y' (M z)"
      using M
      using in_disc betw
      unfolding unit_disc_fix_f_def
      by auto
  qed fact+
  thus ?thesis
    using `unit_disc_fix_f M`
    using in_disc in_disc'
    `M u = u'`
    unfolding unit_disc_fix_f_def
    by auto
qed

(* ------------------------------------------------------------------ *)
subsection{* Upper dimension axiom *}
(* ------------------------------------------------------------------ *)

lemma upper_dimension_axiom:
  assumes in_disc: "x \<in> unit_disc" "y \<in> unit_disc" "z \<in> unit_disc" "u \<in> unit_disc" "v \<in> unit_disc"
  assumes "poincare_distance x u = poincare_distance x v"
          "poincare_distance y u = poincare_distance y v"
          "poincare_distance z u = poincare_distance z v"
          "u \<noteq> v"
  shows "poincare_between x y z \<or> poincare_between y z x \<or> poincare_between z x y"
proof (cases "x = y \<or> y = z \<or> x = z")
  case True
  thus ?thesis
    using in_disc
    by auto
next
  case False
  hence "x \<noteq> y" "x \<noteq> z" "y \<noteq> z"
    by auto
  let ?cong = "\<lambda> a b a' b'. poincare_distance a b = poincare_distance a' b'"
  have "\<forall> z u v. z \<in> unit_disc \<and> u \<in> unit_disc \<and> v \<in> unit_disc \<and>
                 ?cong x u x v \<and> ?cong y u y v \<and> ?cong z u z v  \<and> u \<noteq> v \<longrightarrow>
                 poincare_colinear {x, y, z}" (is "?P x y")
  proof (rule wlog_positive_x_axis[where P="?P"])
    fix x
    assume x: "is_real x" "0 < Re x" "Re x < 1"
    hence "x \<noteq> 0"
      by auto
    have "0\<^sub>h \<in> circline_set x_axis"
      by simp
    show "?P 0\<^sub>h (of_complex x)"
    proof safe
      fix z u v
      assume in_disc: "z \<in> unit_disc" "u \<in> unit_disc" "v \<in> unit_disc"
      then obtain z' u' v' where zuv: "z = of_complex z'" "u = of_complex u'" "v = of_complex v'"
        using inf_or_of_complex[of z] inf_or_of_complex[of u] inf_or_of_complex[of v]
        by auto

      assume cong: "?cong 0\<^sub>h u 0\<^sub>h v" "?cong (of_complex x) u (of_complex x) v" "?cong z u z v" "u \<noteq> v"

      let ?r0 = "poincare_distance 0\<^sub>h u" and
          ?rx = "poincare_distance (of_complex x) u"

      have "?r0 > 0" "?rx > 0"
        using in_disc  cong
        using poincare_distance_eq_0_iff[of "0\<^sub>h" u] poincare_distance_ge0[of "0\<^sub>h" u]
        using poincare_distance_eq_0_iff[of "0\<^sub>h" v] poincare_distance_ge0[of "0\<^sub>h" v]
        using poincare_distance_eq_0_iff[of "of_complex x" u] poincare_distance_ge0[of "of_complex x" u]
        using poincare_distance_eq_0_iff[of "of_complex x" v] poincare_distance_ge0[of "of_complex x" v]
        using x
        by (auto simp add: cmod_eq_Re)

      let ?pc0 = "poincare_circle 0\<^sub>h ?r0" and
          ?pcx = "poincare_circle (of_complex x) ?rx"
      have "u \<in> ?pc0 \<inter> ?pcx" "v \<in> ?pc0 \<inter> ?pcx"
        using in_disc cong
        by (auto simp add: poincare_circle_def)
      hence "u = conjugate v"
        using intersect_poincare_circles_x_axis[of 0 x ?r0 ?rx u v]
        using x `x \<noteq> 0` `u \<noteq> v` `?r0 > 0` `?rx > 0`
        by simp

      let ?ru = "poincare_distance u z"
      have "?ru > 0"
        using poincare_distance_ge0[of u z] in_disc
        using cong
        using poincare_distance_eq_0_iff[of z u] poincare_distance_eq_0_iff[of z v]
        using poincare_distance_eq_0_iff
        by force

      have "z \<in> poincare_circle u ?ru \<inter> poincare_circle v ?ru"
        using cong in_disc
        unfolding poincare_circle_def
        by (simp add: poincare_distance_sym)

      hence "is_real z'"
        using intersect_poincare_circles_conjugate_centers[of u v ?ru z] `u = conjugate v` zuv
        using in_disc `u \<noteq> v` `?ru > 0`
        by simp

      thus "poincare_colinear {0\<^sub>h, of_complex x, z}"
        using poincare_line_0_real_is_x_axis[of "of_complex x"] x `x \<noteq> 0` zuv `0\<^sub>h \<in> circline_set x_axis`
        unfolding poincare_colinear_def
        by (rule_tac x=x_axis in exI, auto simp add: circline_set_x_axis)
    qed
  next
    fix M x y
    assume 1: "unit_disc_fix M" "x \<in> unit_disc" "y \<in> unit_disc" "x \<noteq> y"
    assume 2: "?P (moebius_pt M x) (moebius_pt M y)"
    show "?P x y"
    proof safe
      fix z u v
      assume "z \<in> unit_disc" "u \<in> unit_disc" "v \<in> unit_disc"
             "?cong x u x v" "?cong y u y v" "?cong z u z v" "u \<noteq> v"
      hence "poincare_colinear {moebius_pt M x, moebius_pt M y, moebius_pt M z}"
        using 1 2[rule_format, of "moebius_pt M z" "moebius_pt M u" "moebius_pt M v"]
        by simp
      then obtain p where "is_poincare_line p" "{moebius_pt M x, moebius_pt M y, moebius_pt M z} \<subseteq> circline_set p"
        unfolding poincare_colinear_def
        by auto
      thus "poincare_colinear {x, y, z}"
        using `unit_disc_fix M`
        unfolding poincare_colinear_def
        by (rule_tac x="moebius_circline (-M) p" in exI, auto)
    qed
  qed fact+

  thus ?thesis
    using assms
    using colinear_between[of x y z]
    using poincare_between_rev
    by auto
qed

(* ------------------------------------------------------------------ *)
subsection{* Lower dimension axiom *}
(* ------------------------------------------------------------------ *)

lemma lower_dimension_axiom:
"\<exists> a \<in> unit_disc. \<exists> b \<in> unit_disc. \<exists> c \<in> unit_disc. \<not> poincare_between a b c \<and> \<not> poincare_between b c a \<and> \<not> poincare_between c a b"
proof-
  let ?u = "of_complex (1/2)" and ?v = "of_complex (\<i>/2)"
  have 1: "0\<^sub>h \<in> unit_disc" and 2: "?u \<in> unit_disc" and 3: "?v \<in> unit_disc"
    by simp_all
  have *: "\<not> poincare_colinear {0\<^sub>h, ?u, ?v}"
  proof (rule ccontr)
    assume "\<not> ?thesis"
    then obtain p where "is_poincare_line p" "{0\<^sub>h, ?u, ?v} \<subseteq> circline_set p"
      unfolding poincare_colinear_def
      by auto
    hence "0\<^sub>h \<in> circline_set (poincare_line ?u ?v)"
      using unique_poincare_line[of ?u ?v p]
      by auto (metis Groups.mult_ac(2) divide_complex_def complex_i_not_one divide_eq_0_iff mult_compare_simps(14) of_complex_inj zero_neq_numeral)
    thus False
      unfolding circline_set_def
      by simp (transfer, transfer, simp add: vec_cnj_def)
  qed
  show ?thesis
    apply (rule_tac x="0\<^sub>h" in bexI, rule_tac x="?u" in bexI, rule_tac x="?v" in bexI)
    apply (rule ccontr, auto)
    using *
    using poincare_between_poincare_colinear[OF 1 2 3]
    using poincare_between_poincare_colinear[OF 2 3 1]
    using poincare_between_poincare_colinear[OF 3 1 2]
    by (metis insert_commute)+
qed

(* ------------------------------------------------------------------ *)
subsection{* Negated Euclidean axiom *}
(* ------------------------------------------------------------------ *)

lemma negated_euclidean_axiom':
  assumes "on_circline H (of_complex (1/2 + \<i>/2))" "is_poincare_line H"
          "intersects_x_axis_positive H"
  shows "\<not> intersects_y_axis_positive H"
  using assms
proof (transfer, transfer)
  fix H
  assume hh: "hermitean H \<and> H \<noteq> mat_zero" "is_poincare_line_cmat H"
  obtain A B C D where "H = (A, B, C, D)"
    by (cases H, auto)
  hence *: "is_real A" "H = (A, B, cnj B, A)" "(cmod B)\<^sup>2 > (cmod A)\<^sup>2"
    using hermitean_elems[of A B C D] hh
    by auto

  assume "intersects_x_axis_positive_cmat H"
  hence "Re A \<noteq> 0" "Re B / Re A < - 1"
    using *
    by auto

  assume "on_circline_cmat_cvec H (of_complex_cvec (1 / 2 + \<i> / 2))"
  hence "6*A + 4*Re B + 4*Im B = 0"
    using *
    unfolding cor_mult
    apply (subst re_express_cnj[of B])
    apply (subst im_express_cnj[of B])
    apply (simp add: vec_cnj_def)
    apply (simp add: field_simps)
    done
  hence "Re (6*A + 4*Re B + 4*Im B) = 0"
    by simp
  hence "3*Re A + 2*Re B + 2*Im B = 0"
    using `is_real A`
    by simp

  hence "3/2 + Re B/Re A + Im B/Re A = 0"
    using `Re A \<noteq> 0`
    by (simp add: field_simps)

  hence "-Im B/Re A - 3/2 < -1"
    using `Re B / Re A < -1`
    by simp
  hence "Im B/Re A > -1/2"
    by (simp add: field_simps)
  thus "\<not> intersects_y_axis_positive_cmat H"
    using *
    by simp
qed

lemma negated_euclidean_axiom:
     "\<exists> a b c d t.
           a \<in> unit_disc \<and> b \<in> unit_disc \<and> c \<in> unit_disc \<and> d \<in> unit_disc \<and> t \<in> unit_disc \<and>
           poincare_between a d t \<and> poincare_between b d c \<and> a \<noteq> d \<and>
                (\<forall> x y. x \<in> unit_disc \<and> y \<in> unit_disc \<and>
                        poincare_between a b x \<and> poincare_between x t y \<longrightarrow> \<not> poincare_between a c y)"
proof-
  let ?a = "0\<^sub>h"
  let ?b = "of_complex (1/2)"
  let ?c = "of_complex (\<i>/2)"
  let ?dl = "(5 - sqrt 17) / 4"
  let ?d = "of_complex (?dl + \<i>*?dl)"
  let ?t = "of_complex (1/2 + \<i>/2)"

  have "?dl \<noteq> 0"
  proof-
    have "(sqrt 17)\<^sup>2 \<noteq> 5\<^sup>2"
      by simp
    hence "sqrt 17 \<noteq> 5"
      by force
    thus ?thesis
      by simp
  qed

  have "?d \<noteq> ?a"
  proof (rule ccontr)
    assume "\<not> ?thesis"
    hence "?dl + \<i>*?dl = 0"
      by simp
    hence "Re (?dl + \<i>*?dl) = 0"
      by simp
    thus False
      using `?dl \<noteq> 0`
      by simp
  qed

  have "?dl > 0"
  proof-
    have "(sqrt 17)\<^sup>2 < 5\<^sup>2"
      by (simp add: power2_eq_square)
    hence "sqrt 17 < 5"
      by (rule power2_less_imp_less, simp)
    thus ?thesis
      by simp
  qed

  have "?a \<noteq> ?b"
    by (metis divide_eq_0_iff of_complex_zero_iff zero_neq_numeral zero_neq_one)

  have "?a \<noteq> ?c"
    by (metis complex_i_not_zero divide_eq_0_iff of_complex_zero_iff zero_neq_numeral)

  show ?thesis
  proof (rule_tac x="?a" in exI, rule_tac x="?b" in exI, rule_tac x="?c" in exI, rule_tac x="?d" in exI, rule_tac x="?t" in exI, safe)


    show "?a \<in> unit_disc" "?b \<in> unit_disc" "?c \<in> unit_disc" "?t \<in> unit_disc"
      by (auto simp add: cmod_def power2_eq_square)

    have cmod_d: "cmod (?dl + \<i>*?dl) = ?dl * sqrt 2"
      using `?dl > 0`
      unfolding cmod_def
      by (simp add: real_sqrt_mult)

    show "?d \<in> unit_disc"
    proof-
      have "?dl < 1 / sqrt 2"
      proof-
        have "17\<^sup>2 < (5 * sqrt 17)\<^sup>2"
          by (simp add: field_simps)
        hence "17 < 5 * sqrt 17"
          by (rule power2_less_imp_less, simp)
        hence "?dl\<^sup>2 < (1 / sqrt 2)\<^sup>2"
          by (simp add: power2_eq_square field_simps)
        thus "?dl < 1 / sqrt 2"
          by (rule power2_less_imp_less, simp)
      qed
      thus ?thesis
        using cmod_d
        by (simp add: field_simps)
    qed

    have cmod_d: "1 - (cmod (to_complex ?d))\<^sup>2 = (-17 + 5*sqrt 17) / 4" (is "_ = ?cmod_d")
      apply (simp only: to_complex_of_complex)
      apply (subst cmod_d)
      apply (simp add: power_mult_distrib)
      apply (simp add: power2_eq_square field_simps)
      done

    have cmod_d_c: "(cmod (to_complex ?d - to_complex ?c))\<^sup>2 = (17 - 4*sqrt 17) / 4" (is "_ = ?cmod_dc")
      unfolding cmod_square
      by (simp add: field_simps)

    have cmod_c: "1 - (cmod (to_complex ?c))\<^sup>2 = 3/4" (is "_ = ?cmod_c")
      by (simp add: power2_eq_square)

    have xx: "\<And> x::real. x + x = 2*x"
      by simp

    have "cmod ((to_complex ?b) - (to_complex ?d)) = cmod ((to_complex ?d) - (to_complex ?c))"
      by (simp add: cmod_def power2_eq_square field_simps)
    moreover
    have "cmod (to_complex ?b) = cmod (to_complex ?c)"
      by simp
    ultimately
    have *: "poincare_distance_formula' (to_complex ?b) (to_complex ?d) =
             poincare_distance_formula' (to_complex ?d) (to_complex ?c)"
      unfolding poincare_distance_formula'_def
      by simp

    have **: "poincare_distance_formula' (to_complex ?d) (to_complex ?c) = (sqrt 17) / 3"
      unfolding poincare_distance_formula'_def
    proof (subst cmod_d, subst cmod_c, subst cmod_d_c)
      have "(sqrt 17 * 15)\<^sup>2 \<noteq> 51\<^sup>2"
        by simp
      hence "sqrt 17 * 15 \<noteq> 51"
        by force
      hence "sqrt 17 * 15 - 51 \<noteq> 0"
        by simp

      have "(5 * sqrt 17)\<^sup>2 \<noteq> 17\<^sup>2"
        by simp
      hence "5 * sqrt 17 \<noteq> 17"
        by force
      hence "?cmod_d * ?cmod_c \<noteq> 0"
        by simp
      hence "1 + 2 * (?cmod_dc / (?cmod_d * ?cmod_c)) =  (?cmod_d * ?cmod_c + 2 * ?cmod_dc) / (?cmod_d * ?cmod_c)"
        using add_frac_num[of "?cmod_d * ?cmod_c" "2 * ?cmod_dc" 1]
        by (simp add: field_simps)
      also have "... = (64 * (85 - sqrt 17 * 17)) / (64 * (sqrt 17 * 15 - 51))"
        by (simp add: field_simps)
      also have "... = (85 - sqrt 17 * 17) / (sqrt 17 * 15 - 51)"
        by (rule mult_divide_mult_cancel_left, simp)
      also have "... = sqrt 17 / 3"
        by (subst frac_eq_eq, fact, simp, simp add: field_simps)
      finally
      show "1 + 2 * (?cmod_dc / (?cmod_d * ?cmod_c)) = sqrt 17 / 3"
        .
    qed

    have "sqrt 17 \<ge> 3"
    proof-
      have "(sqrt 17)\<^sup>2 \<ge> 3\<^sup>2"
        by simp
      thus ?thesis
        by (rule power2_le_imp_le, simp)
    qed
    thus "poincare_between ?b ?d ?c"
      unfolding poincare_between_sum_distances[OF `?b \<in> unit_disc` `?d \<in> unit_disc` `?c \<in> unit_disc`]
      unfolding poincare_distance_formula[OF `?b \<in> unit_disc` `?d \<in> unit_disc`]
      unfolding poincare_distance_formula[OF `?d \<in> unit_disc` `?c \<in> unit_disc`]
      unfolding poincare_distance_formula[OF `?b \<in> unit_disc` `?c \<in> unit_disc`]
      unfolding poincare_distance_formula_def
      apply (subst *, subst xx, subst **, subst acosh_double)
      apply (simp_all add: cmod_def power2_eq_square)
      done

    show "poincare_between ?a ?d ?t"
    proof (subst poincare_between_0uv[OF `?d \<in> unit_disc` `?t \<in> unit_disc` `?d \<noteq> ?a`])
      show "?t \<noteq> 0\<^sub>h"
      proof (rule ccontr)
        assume "\<not> ?thesis"
        hence "1/2 + \<i>/2 = 0"
          by simp
        hence "Re (1/2 + \<i>/2) = 0"
          by simp
        thus False
          by simp
      qed
    next
      have "19\<^sup>2 \<le> (5 * sqrt 17)\<^sup>2"
        by simp
      hence "19 \<le> 5 * sqrt 17"
        by (rule power2_le_imp_le, simp)
      hence "cmod (to_complex ?d) \<le> cmod (to_complex ?t)"
        by (simp add: Let_def cmod_def power2_eq_square field_simps)
      moreover
      have "arg (to_complex ?d) = arg (to_complex ?t)"
      proof-
        have 1: "to_complex ?d = ((5 - sqrt 17) / 4) * (1 + \<i>)"
          by (simp add: field_simps)

        have 2: "to_complex ?t = (cor (1/2)) * (1 + \<i>)"
          by (simp add: field_simps)

        have "(sqrt 17)\<^sup>2 < 5\<^sup>2"
          by simp
        hence "sqrt 17 < 5"
          by (rule power2_less_imp_less, simp)
        hence 3: "(5 - sqrt 17) / 4 > 0"
          by simp

        have 4: "(1::real) / 2 > 0"
          by simp

        show ?thesis
          apply (subst 1, subst 2)
          apply (subst arg_mult_real_positive[OF 3])
          apply (subst arg_mult_real_positive[OF 4])
          by simp
      qed
      ultimately
      show "let d' = to_complex ?d; t' = to_complex ?t in arg d' = arg t' \<and> cmod d' \<le> cmod t'"
        by simp
    qed

    show "?a = ?d \<Longrightarrow> False"
      using `?d \<noteq> ?a`
      by simp

    fix x y
    assume "x \<in> unit_disc" "y \<in> unit_disc"

    assume abx: "poincare_between ?a ?b x"
    hence "x \<in> circline_set x_axis"
      using poincare_between_poincare_line_uvz[of ?a ?b x] `x \<in> unit_disc` `?a \<noteq> ?b`
      using poincare_line_0_real_is_x_axis[of ?b]
      by (auto simp add: circline_set_x_axis)

    have "x \<noteq> 0\<^sub>h"
      using abx poincare_between_sandwich[of ?a ?b] `?a \<noteq> ?b`
      by auto

    have "x \<in> positive_x_axis"
      using `x \<in> circline_set x_axis` `x \<noteq> 0\<^sub>h` `x \<in> unit_disc`
      using abx poincare_between_x_axis_0uv[of "1/2" "Re (to_complex x)"]
      unfolding circline_set_x_axis positive_x_axis_def
      by (auto simp add: cmod_eq_Re complex_of_real_Re) (smt complex_surj zero_complex.code)

    assume acy: "poincare_between ?a ?c y"
    hence "y \<in> circline_set y_axis"
      using poincare_between_poincare_line_uvz[of ?a ?c y] `y \<in> unit_disc` `?a \<noteq> ?c`
      using poincare_line_0_imag_is_y_axis[of ?c]
      by (auto simp add: circline_set_y_axis)

    have "y \<noteq> 0\<^sub>h"
      using acy poincare_between_sandwich[of ?a ?c] `?a \<noteq> ?c`
      by auto

    have "y \<in> positive_y_axis"
      using `y \<in> circline_set y_axis` `y \<noteq> 0\<^sub>h` `y \<in> unit_disc`
      using acy poincare_between_y_axis_0uv[of "1/2" "Re (to_complex y)"]
      unfolding circline_set_y_axis positive_y_axis_def
      by (auto simp add: cmod_eq_Im)
         (smt add.left_neutral complex.expand divide_complex_def complex_eq divide_less_0_1_iff divide_less_eq_1_pos imaginary_unit.simps(1) mult.left_neutral of_real_1 of_real_add of_real_divide of_real_eq_0_iff one_add_one poincare_between_y_axis_0uv zero_complex.simps(1) zero_complex.simps(2) zero_less_divide_1_iff)

    have "x \<noteq> y"
      using `x \<in> positive_x_axis` `y \<in> positive_y_axis`
      unfolding positive_x_axis_def positive_y_axis_def circline_set_x_axis circline_set_y_axis
      by auto

    assume xty: "poincare_between x ?t y"

    let ?xy = "poincare_line x y"

    have "?t \<in> circline_set ?xy"
      using xty poincare_between_poincare_line_uzv[OF `x \<noteq> y` `x \<in> unit_disc` `y \<in> unit_disc` `?t \<in> unit_disc`]
      by simp

    moreover

    have "?xy \<noteq> x_axis"
      using poincare_line_circline_set[OF `x \<noteq> y`] `y \<in> positive_y_axis`
      by (auto simp add: circline_set_x_axis positive_y_axis_def)
    hence "intersects_x_axis_positive ?xy"
      using intersects_x_axis_positive_iff[of "?xy"] `x \<noteq> y` `x \<in> unit_disc` `x \<in> positive_x_axis`
      by auto

    moreover

    have "?xy \<noteq> y_axis"
      using poincare_line_circline_set[OF `x \<noteq> y`] `x \<in> positive_x_axis`
      by (auto simp add: circline_set_y_axis positive_x_axis_def)
    hence "intersects_y_axis_positive ?xy"
      using intersects_y_axis_positive_iff[of "?xy"] `x \<noteq> y` `y \<in> unit_disc` `y \<in> positive_y_axis`
      by auto

    ultimately

    show False
      using negated_euclidean_axiom'[of ?xy] `x \<noteq> y`
      unfolding circline_set_def
      by auto
  qed
qed

lemma negated_euclidean_axiom2:
     "\<exists> a b c.
           a \<in> unit_disc \<and> b \<in> unit_disc \<and> c \<in> unit_disc \<and> \<not>(poincare_colinear {a, b, c})  \<and>
                \<not>(\<exists> x. x \<in> unit_disc \<and> 
                  poincare_distance a x = poincare_distance b x \<and>
                  poincare_distance a x = poincare_distance c x)"
proof-
  let ?a = "of_complex (\<i>/2)"
  let ?b = "of_complex (-\<i>/2)"
  let ?c = "of_complex (1/5)"

  have "(\<i>/2) \<noteq> (-\<i>/2)"
    by simp
  hence "?a \<noteq> ?b"
    by (metis to_complex_of_complex)
  have "(\<i>/2) \<noteq> (1/5)"
    by simp
  hence "?a \<noteq> ?c"
    by (metis to_complex_of_complex)
  have "(-\<i>/2) \<noteq> (1/5)"
    by (metis add.inverse_inverse cmod_divide div_by_1 divide_divide_eq_right inverse_eq_divide minus_divide_left mult.commute norm_ii norm_minus_cancel norm_numeral norm_one numeral_One numeral_eq_iff semiring_norm(88))
  hence "?b \<noteq> ?c"
    by (metis to_complex_of_complex)

  have "?a \<in> unit_disc" "?b \<in> unit_disc" "?c \<in> unit_disc"
    by auto

  moreover

  have "\<not>(poincare_colinear {?a, ?b, ?c})"
    unfolding poincare_colinear_def
  proof(rule ccontr)
    assume " \<not> (\<nexists>p. is_poincare_line p \<and> {?a, ?b, ?c} \<subseteq> circline_set p)"
    then obtain p where "is_poincare_line p \<and> {?a, ?b, ?c} \<subseteq> circline_set p"
      by auto
    let ?ab = "poincare_line ?a ?b"
    have "p = ?ab"
      using `is_poincare_line p \<and> {?a, ?b, ?c} \<subseteq> circline_set p`
      using unique_poincare_line[of ?a ?b] `?a \<noteq> ?b` `?a \<in> unit_disc` `?b \<in> unit_disc`
      by auto
    have "?c \<notin> circline_set ?ab"
    proof(rule ccontr)
      assume "\<not> ?c \<notin> circline_set ?ab"
      have "poincare_between ?a 0\<^sub>h ?b"
        unfolding poincare_between_def
        using cross_ratio_0inf by auto
      hence "0\<^sub>h \<in> circline_set ?ab"
        using `?a \<noteq> ?b` `?a \<in> unit_disc` `?b \<in> unit_disc`
        using poincare_between_poincare_line_uzv zero_in_unit_disc 
        by blast
      hence "?ab = poincare_line 0\<^sub>h ?a"
        using unique_poincare_line[of ?a ?b] `?a \<noteq> ?b` `?a \<in> unit_disc` `?b \<in> unit_disc`
        using `is_poincare_line p \<and> {?a, ?b, ?c} \<subseteq> circline_set p` 
        using `p = ?ab` poincare_line_circline_set(1) unique_poincare_line
        by (metis add.inverse_neutral divide_minus_left of_complex_zero_iff  zero_in_unit_disc)
      hence "(\<i>/2) * cnj(1/5) = cnj(\<i>/2) * (1/5)"
        using poincare_colinear_zero_iff[of "(\<i>/2)" "(1/5)"]
        using `?a \<noteq> ?c` `\<not> ?c \<notin> circline_set ?ab` `?a \<in> unit_disc` `?c \<in> unit_disc` `p = ?ab`
        using `0\<^sub>h \<in> circline_set ?ab` `is_poincare_line p \<and> {?a, ?b, ?c} \<subseteq> circline_set p` 
        using poincare_colinear_def by auto
      thus False
        by simp
    qed 
    thus False
      using `p = ?ab` `is_poincare_line p \<and> {?a, ?b, ?c} \<subseteq> circline_set p` 
      by auto
  qed

  moreover

  have "\<not>(\<exists> x. x \<in> unit_disc \<and> 
                  poincare_distance ?a x = poincare_distance ?b x \<and>
                  poincare_distance ?a x = poincare_distance ?c x)"
  proof(rule ccontr)
    assume "\<not> ?thesis"
    then obtain x where "x \<in> unit_disc" "poincare_distance ?a x = poincare_distance ?b x"
                        "poincare_distance ?a x = poincare_distance ?c x"
      by blast
    let ?x = "to_complex x"
    have "poincare_distance_formula' (\<i>/2) ?x = poincare_distance_formula' (-\<i>/2) ?x"
      using `poincare_distance ?a x = poincare_distance ?b x`
      using `x \<in> unit_disc` `?a \<in> unit_disc` `?b \<in> unit_disc`
      by (metis cosh_dist to_complex_of_complex)
    hence "(cmod (\<i> / 2 - ?x))\<^sup>2 = (cmod (- \<i> / 2 - ?x))\<^sup>2"
      unfolding poincare_distance_formula'_def
      apply (simp add:field_simps)
      using `x \<in> unit_disc` unit_disc_cmod_square_lt_1 by fastforce
    hence "Im ?x = 0"
      unfolding cmod_def
      by (simp add: power2_eq_iff)

    have "1 - (Re ?x)\<^sup>2 \<noteq> 0"
      using `x \<in> unit_disc` unit_disc_cmod_square_lt_1
      using cmod_power2 by force
    hence "24 - 24 * (Re ?x)\<^sup>2 \<noteq> 0"
      by simp
    have "poincare_distance_formula' (\<i>/2) ?x = poincare_distance_formula' (1/5) ?x"
      using `poincare_distance ?a x = poincare_distance ?c x`
      using `x \<in> unit_disc` `?a \<in> unit_disc` `?c \<in> unit_disc`
      by (metis cosh_dist to_complex_of_complex)
    hence "(2 + 8 * (Re ?x)\<^sup>2) /(3 - 3 * (Re ?x)\<^sup>2) = 2 * (1 - Re ?x * 5)\<^sup>2 / (24 - 24 * (Re ?x)\<^sup>2)" (is "?lhs = ?rhs")
      unfolding poincare_distance_formula'_def
      apply (simp add:field_simps)
      unfolding cmod_def 
      using `Im ?x = 0` 
      by (simp add:field_simps)
    hence *: "?lhs * (24 - 24 * (Re ?x)\<^sup>2)  = ?rhs * (24 - 24 * (Re ?x)\<^sup>2) "
      using `(24 - 24 * (Re ?x)\<^sup>2) \<noteq> 0` 
      by simp
    have "?lhs * (24 - 24 * (Re ?x)\<^sup>2) = (2 + 8 * (Re ?x)\<^sup>2) * 8"
      using `(24 - 24 * (Re ?x)\<^sup>2) \<noteq> 0` `1 - (Re ?x)\<^sup>2 \<noteq> 0`
      by (simp add:field_simps)
    have "?rhs * (24 - 24 * (Re ?x)\<^sup>2) = 2 * (1 - Re ?x * 5)\<^sup>2"
      using `(24 - 24 * (Re ?x)\<^sup>2) \<noteq> 0` `1 - (Re ?x)\<^sup>2 \<noteq> 0`
      by (simp add:field_simps)
    hence "(2 + 8 * (Re ?x)\<^sup>2) * 8 = 2 * (1 - Re ?x * 5)\<^sup>2"
      using * `?lhs * (24 - 24 * (Re ?x)\<^sup>2) = (2 + 8 * (Re ?x)\<^sup>2) * 8`
      by simp      
    hence "7 * (Re ?x)\<^sup>2 + 10 * (Re ?x) + 7 = 0"
      by (simp add:field_simps comm_ring_1_class.power2_diff)
    thus False
      using real_quadratic_equation_discriminant[of 7 10 7]
      by auto
  qed

  ultimately show ?thesis
    apply (rule_tac x="?a" in exI)
    apply (rule_tac x="?b" in exI)
    apply (rule_tac x="?c" in exI)
    by auto
qed

(* continuity axiom *)
abbreviation set_order where
 "set_order A \<phi> \<psi> \<equiv> \<forall>x\<in> unit_disc. \<forall>y\<in> unit_disc.  \<phi> x \<and> \<psi> y \<longrightarrow> poincare_between A x y"
abbreviation point_between_sets where
 "point_between_sets \<phi> B \<psi> \<equiv> \<forall>x\<in> unit_disc. \<forall>y\<in> unit_disc.  \<phi> x \<and> \<psi> y \<longrightarrow> poincare_between x B y"

lemma  continuity:
  assumes "\<exists> A \<in> unit_disc. set_order A \<phi> \<psi>"
  shows   "\<exists> B \<in> unit_disc. point_between_sets \<phi> B \<psi>"
proof (cases "(\<exists> x0 \<in> unit_disc. \<phi> x0) \<and> (\<exists> y0 \<in> unit_disc. \<psi> y0)")
  case False
  thus ?thesis
    using assms by blast
next
  case True
  then obtain Y0 where "\<psi> Y0" "Y0 \<in> unit_disc"
    by auto
  obtain A where *: "A \<in> unit_disc" "set_order A \<phi> \<psi>"
    using assms
    by auto
  show ?thesis
  proof(cases "\<forall> x \<in> unit_disc. \<phi> x \<longrightarrow> x = A")
    case True
    thus ?thesis
      using `A \<in> unit_disc`
      using poincare_between_nonstrict(1) by blast
  next
    case False
    then obtain X0 where "\<phi> X0" "X0 \<noteq> A" "X0 \<in> unit_disc"
      by auto
    have "Y0 \<noteq> A"
    proof(rule ccontr)
      assume "\<not> Y0 \<noteq> A"
      hence "\<forall> x \<in> unit_disc. \<phi> x \<longrightarrow> poincare_between A x A"
        using * `\<psi> Y0`
        by (cases A) force
      hence "\<forall> x \<in> unit_disc. \<phi> x \<longrightarrow> x = A"
        using * poincare_between_sandwich by blast
      thus False
        using False by auto
    qed

    show ?thesis
    proof (cases "\<exists> B \<in> unit_disc. \<phi> B \<and> \<psi> B")
      case True
      then obtain B where "B \<in> unit_disc" "\<phi> B" "\<psi> B"
        by auto
      hence "\<forall> x \<in> unit_disc. \<phi> x \<longrightarrow> poincare_between A x B"
        using * by auto
      have "\<forall> y \<in> unit_disc. \<psi> y \<longrightarrow> poincare_between A B y"
        using * `B \<in> unit_disc` `\<phi> B`
        by auto

      show ?thesis
      proof(rule+)
        show "B \<in> unit_disc"
          by fact
      next
        fix x y
        assume "x \<in> unit_disc" "y \<in> unit_disc" "\<phi> x \<and> \<psi> y"
        hence "poincare_between A x B" "poincare_between A B y"
          using `\<forall> x \<in> unit_disc. \<phi> x \<longrightarrow> poincare_between A x B`
          using `\<forall> y \<in> unit_disc. \<psi> y \<longrightarrow> poincare_between A B y`
          by simp+
        thus "poincare_between x B y"
          using `x \<in> unit_disc` `y \<in> unit_disc` `B \<in> unit_disc` `A \<in> unit_disc`
          using poincare_between_transitivity[of A x B y]
          by simp
      qed
    next
      case False
      have "poincare_between A X0 Y0"
        using `\<phi> X0` `\<psi> Y0` * `Y0 \<in> unit_disc` `X0 \<in> unit_disc`
        by auto
      have "\<forall> \<phi>. \<forall> \<psi>. set_order A \<phi> \<psi> \<and> \<not> (\<exists> B \<in> unit_disc. \<phi> B \<and> \<psi> B) \<and> \<phi> X0 \<and> 
                      (\<exists> y \<in> unit_disc. \<psi> y) \<and> (\<exists> x \<in> unit_disc. \<phi> x)
                   \<longrightarrow> (\<exists> B \<in> unit_disc. point_between_sets \<phi> B \<psi>)"
            (is "?P A X0")
      proof (rule wlog_positive_x_axis[where P="?P"])
        show "A \<in> unit_disc"
          by fact
      next
        show "X0 \<in> unit_disc"
          by fact
      next
        show "A \<noteq> X0"
          using `X0 \<noteq> A` by simp
      next
        fix M u v
        let ?M = "\<lambda> x. moebius_pt M x"
        let ?Mu = "?M u" and ?Mv = "?M v"
        assume hip: "unit_disc_fix M" "u \<in> unit_disc" "v \<in> unit_disc" "u \<noteq> v"
               "?P ?Mu ?Mv"
        show "?P u v"
        proof safe
          fix \<phi> \<psi> x y
          assume "set_order u \<phi> \<psi>" "\<not> (\<exists>B\<in>unit_disc. \<phi> B \<and> \<psi> B)" "\<phi> v"
                  "y \<in> unit_disc" "\<psi> y" "x \<in> unit_disc" "\<phi> x"

          let ?M\<phi> = "\<lambda> X'. \<exists> X. \<phi> X \<and> ?M X = X'" 
          let ?M\<psi> = "\<lambda> X'. \<exists> X. \<psi> X \<and> ?M X = X'"

          obtain M\<phi> where "M\<phi> = ?M\<phi>" by simp
          obtain M\<psi> where "M\<psi> = ?M\<psi>" by simp

          have "M\<phi> ?Mv"
            using `\<phi> v` using `M\<phi> = ?M\<phi>` 
            by blast
          moreover
          have "\<not> (\<exists> B \<in>unit_disc. M\<phi> B \<and> M\<psi> B)"
            using `\<not> (\<exists>B\<in>unit_disc. \<phi> B \<and> \<psi> B)`
            using `M\<phi> = ?M\<phi>` `M\<psi> = ?M\<psi>`
            by (metis hip(1) moebius_pt_invert unit_disc_fix_discI unit_disc_fix_moebius_inv)
          moreover
          have "\<exists> y \<in> unit_disc. M\<psi> y"
            using `y \<in> unit_disc` `\<psi> y`  `M\<psi> = ?M\<psi>` `unit_disc_fix M`
            by auto
          moreover
          have "set_order ?Mu ?M\<phi> ?M\<psi>"
          proof ((rule ballI)+, rule impI)                                       
            fix Mx My
            assume "Mx \<in> unit_disc" "My \<in> unit_disc" "?M\<phi> Mx \<and> ?M\<psi> My"
            then obtain x y where "\<phi> x \<and> ?M x = Mx" "\<psi> y \<and> ?M y = My"
              by blast

            hence "x \<in> unit_disc" "y \<in> unit_disc"
              using `Mx \<in> unit_disc` `My \<in> unit_disc` `unit_disc_fix M`
              by (metis moebius_pt_comp_inv_left unit_disc_fix_discI unit_disc_fix_moebius_inv)+

            hence "poincare_between u x y"
              using `set_order u \<phi> \<psi>`
              using `Mx \<in> unit_disc` `My \<in> unit_disc` `\<phi> x \<and> ?M x = Mx` `\<psi> y \<and> ?M y = My`
              by blast
            then show "poincare_between ?Mu Mx My"
              using `\<phi> x \<and> ?M x = Mx` `\<psi> y \<and> ?M y = My`
              using `x \<in> unit_disc` `y \<in> unit_disc` `u \<in> unit_disc` `unit_disc_fix M` 
              using unit_disc_fix_moebius_preserve_poincare_between by blast
          qed

          hence  "set_order ?Mu M\<phi> M\<psi>"
            using `M\<phi> = ?M\<phi>` `M\<psi> = ?M\<psi>`
            by simp
          ultimately
          have "\<exists> Mb \<in> unit_disc. point_between_sets M\<phi> Mb M\<psi>"
            using hip(5)
            by blast
          then obtain Mb where bbb: 
            "Mb \<in> unit_disc" "point_between_sets ?M\<phi> Mb ?M\<psi>"
            using `M\<phi> = ?M\<phi>` `M\<psi> = ?M\<psi>`
            by auto

          let ?b = "moebius_pt (moebius_inv M) Mb"
          show "\<exists> b \<in> unit_disc. point_between_sets \<phi> b \<psi>"
          proof (rule_tac x="?b" in bexI, (rule ballI)+, rule impI)
            fix x y
            assume "x \<in> unit_disc" "y \<in> unit_disc" "\<phi> x \<and> \<psi> y"
            hence "poincare_between u x y"
              using `set_order u \<phi> \<psi>`
              by blast
            
            let ?Mx = "?M x" and ?My = "?M y"

            have "?M\<phi> ?Mx" "?M\<psi> ?My"
              using `\<phi> x \<and> \<psi> y`
              by blast+
            have "?Mx \<in> unit_disc" "?My \<in> unit_disc"
              using `x \<in> unit_disc` `unit_disc_fix M` `y \<in> unit_disc`
              by auto

            hence "poincare_between ?Mx Mb ?My"
              using `?M\<phi> ?Mx` `?M\<psi> ?My` `?Mx \<in> unit_disc` `?My \<in> unit_disc` bbb
              by auto

            then show "poincare_between x ?b y"
              using `unit_disc_fix M` 
              using `x \<in> unit_disc` `y \<in> unit_disc` `Mb \<in> unit_disc` `?Mx \<in> unit_disc` `?My \<in> unit_disc`
              using unit_disc_fix_moebius_preserve_poincare_between[of M x ?b y]
              by auto
          next
            show "?b \<in> unit_disc"
              using bbb `unit_disc_fix M`
              by auto
          qed
        qed
      next
        fix X
        assume xx: "is_real X" "0 < Re X" "Re X < 1"
        let ?X = "of_complex X"
        show "?P 0\<^sub>h ?X"
        proof ((rule allI)+, rule impI, (erule conjE)+)
          fix \<phi> \<psi>
          assume "set_order 0\<^sub>h \<phi> \<psi>" "\<not> (\<exists>B\<in>unit_disc. \<phi> B \<and> \<psi> B)" "\<phi> ?X" 
                 "\<exists>y\<in>unit_disc. \<psi> y" "\<exists>x\<in>unit_disc. \<phi> x"
          have "?X \<in> unit_disc"
            using xx
            by (simp add: cmod_eq_Re)

          have \<psi>pos: "\<forall> y \<in> unit_disc. \<psi> y \<longrightarrow> (is_real (to_complex y) \<and> Re (to_complex y) > 0)"
          proof(rule ballI, rule impI)
            fix y
            let ?y = "to_complex y"
            assume "y \<in> unit_disc" "\<psi> y"

            hence "poincare_between 0\<^sub>h ?X y"
              using `set_order 0\<^sub>h \<phi> \<psi>`
              using `?X \<in> unit_disc` `\<phi> ?X`
              by auto

            thus "is_real ?y \<and> 0 < Re ?y"
              using xx `?X \<in> unit_disc` `y \<in> unit_disc`
              by (metis (mono_tags, hide_lams) arg_0_iff of_complex_zero_iff poincare_between_0uv poincare_between_sandwich to_complex_of_complex unit_disc_to_complex_inj zero_in_unit_disc)
          qed

          have \<phi>noneg: "\<forall> x \<in> unit_disc. \<phi> x \<longrightarrow> (is_real (to_complex x) \<and> Re (to_complex x) \<ge> 0)"
          proof(rule ballI, rule impI)
            fix x
            assume "x \<in> unit_disc" "\<phi> x"

            obtain y where "y \<in> unit_disc" "\<psi> y"
              using `\<exists> y \<in> unit_disc. \<psi> y` by blast

            let ?x = "to_complex x" and ?y = "to_complex y"

            have "is_real ?y" "Re ?y > 0"
              using \<psi>pos `\<psi> y` `y \<in> unit_disc`
              by auto

            have "poincare_between 0\<^sub>h x y"
              using `set_order 0\<^sub>h \<phi> \<psi>`
              using `x \<in> unit_disc` `\<phi> x` `y\<in>unit_disc` `\<psi> y`
              by auto

            thus "is_real ?x \<and> 0 \<le> Re ?x"
              using `x \<in> unit_disc` `y \<in> unit_disc` `is_real (to_complex y)` `\<psi> y`
              using `set_order 0\<^sub>h \<phi> \<psi>`
              using `\<phi> ?X` `?X \<in> unit_disc` `Re ?y > 0`
              by (metis arg_0_iff le_less of_complex_zero poincare_between_0uv to_complex_of_complex zero_complex.simps(1) zero_complex.simps(2))
          qed

          have \<phi>less\<psi>: "\<forall>x\<in>unit_disc. \<forall>y\<in>unit_disc. \<phi> x \<and> \<psi> y \<longrightarrow> Re (to_complex x) < Re (to_complex y)"
          proof((rule ballI)+, rule impI)
            fix x y
            let ?x = "to_complex x" and ?y = "to_complex y"
            assume "x \<in> unit_disc" "y \<in> unit_disc" "\<phi> x \<and> \<psi> y"

            hence "poincare_between 0\<^sub>h x y"
              using `set_order 0\<^sub>h \<phi> \<psi>`
              by auto
            moreover
            have "is_real ?x" "Re ?x \<ge> 0"
              using \<phi>noneg
              using `x \<in> unit_disc` `\<phi> x \<and> \<psi> y` by auto
            moreover
            have "is_real ?y" "Re ?y > 0"
              using \<psi>pos
              using `y \<in> unit_disc` `\<phi> x \<and> \<psi> y` by auto
            ultimately
            have "Re ?x \<le> Re ?y"
              using `x \<in> unit_disc` `y \<in> unit_disc`
              by (metis Re_complex_of_real arg_0_iff le_less of_complex_zero poincare_between_0uv rcis_cmod_arg rcis_zero_arg to_complex_of_complex)

            have "Re ?x \<noteq> Re ?y"
              using `\<phi> x \<and> \<psi> y` `is_real ?x` `is_real ?y`
              using `\<not> (\<exists>B\<in>unit_disc. \<phi> B \<and> \<psi> B)` `x \<in> unit_disc` `y \<in> unit_disc`
              by (metis complex.expand unit_disc_to_complex_inj)

            thus "Re ?x < Re ?y"
              using `Re ?x \<le> Re ?y` by auto
          qed

          have "\<exists> b \<in> unit_disc. \<forall> x \<in> unit_disc. \<forall> y \<in> unit_disc. 
                    is_real (to_complex b) \<and> 
                    (\<phi> x \<and> \<psi> y \<longrightarrow> (Re (to_complex x) \<le> Re (to_complex b) \<and> Re (to_complex b) \<le> Re (to_complex y)))"
          proof-
            let ?Phi = "{x. (of_complex (cor x)) \<in> unit_disc \<and> \<phi> (of_complex (cor x))}"

            have "\<forall> x \<in> unit_disc. \<phi> x \<longrightarrow> Re (to_complex x) \<le> Sup ?Phi"
            proof(safe)
              fix x
              let ?x = "to_complex x"
              assume "x \<in> unit_disc" "\<phi> x"
              hence "is_real ?x" "Re ?x \<ge> 0"
                using \<phi>noneg
                by auto
              hence "cor (Re ?x) = ?x"
                 using complex_of_real_Re by blast
              hence "of_complex (cor (Re ?x)) \<in> unit_disc"
                using `x \<in> unit_disc` 
                by (metis inf_notin_unit_disc of_complex_to_complex)
              moreover
              have "\<phi> (of_complex (cor (Re ?x)))"
                using `cor (Re ?x) = ?x` `\<phi> x` `x \<in> unit_disc`
                by (metis inf_notin_unit_disc of_complex_to_complex)
              ultimately
              have "Re ?x \<in> ?Phi"
                by auto

              have "\<exists>M. \<forall>x \<in> ?Phi. x \<le> M"
                using \<phi>less\<psi>
                using `\<exists> y \<in> unit_disc. \<psi> y`
                by (metis (mono_tags, lifting) Re_complex_of_real le_less mem_Collect_eq to_complex_of_complex)

              thus "Re ?x \<le> Sup ?Phi"
                using cSup_upper[of "Re ?x" ?Phi]
                unfolding bdd_above_def
                using `Re ?x \<in> ?Phi`
                by auto                
            qed

            have "\<forall> y \<in> unit_disc. \<psi> y \<longrightarrow> Sup ?Phi \<le> Re (to_complex y)"
            proof (safe)
              fix y
              let ?y = "to_complex y"
              assume "\<psi> y" "y \<in> unit_disc"
              show "Sup ?Phi \<le> Re ?y"
              proof (rule ccontr)
                assume "\<not> ?thesis"
                hence "Re ?y < Sup ?Phi"
                  by auto

                have "\<exists> x. \<phi> (of_complex (cor x)) \<and> (of_complex (cor x)) \<in> unit_disc"
                proof -
                  obtain x' where "x' \<in> unit_disc" "\<phi> x'"
                    using `\<exists> x \<in> unit_disc. \<phi> x` by blast
                  let ?x' = "to_complex x'"
                  have "is_real ?x'"
                    using `x' \<in> unit_disc` `\<phi> x'`
                    using \<phi>noneg
                    by auto
                  hence "cor (Re ?x') = ?x'"
                    using complex_of_real_Re by blast
                  hence "x' = of_complex (cor (Re ?x'))"
                    using `x' \<in> unit_disc`
                    by (metis inf_notin_unit_disc of_complex_to_complex)
                  show ?thesis
                    apply (rule_tac x="Re ?x'" in exI)
                    using `x' \<in> unit_disc` 
                    apply (subst (asm) `x' = of_complex (cor (Re ?x'))`, simp)
                    using `\<phi> x'`
                    by (subst (asm) (2) `x' = of_complex (cor (Re ?x'))`, simp)               
                qed

                hence "?Phi \<noteq> {}"
                  by auto

                then obtain x where "\<phi> (of_complex (cor x))" "Re ?y < x"
                                    "(of_complex (cor x)) \<in> unit_disc"
                  using `Re ?y < Sup ?Phi`
                  using less_cSupE[of "Re ?y" ?Phi]
                  by auto
                moreover
                have "Re ?y < Re (to_complex (of_complex (cor x)))"
                  using `Re ?y < x` 
                  by simp
                ultimately
                show False
                  using \<phi>less\<psi>
                  using `\<psi> y` `y \<in> unit_disc`
                  by (metis less_not_sym)
              qed
            qed

            thus ?thesis
              using `\<forall> x \<in> unit_disc. \<phi> x \<longrightarrow> Re (to_complex x) \<le> Sup ?Phi`
              apply (rule_tac x="(of_complex (cor (Sup ?Phi)))" in bexI, simp)
              using `\<exists>y\<in>unit_disc. \<psi> y` `\<phi> ?X` `?X \<in> unit_disc`
              using `\<forall>y\<in>unit_disc. \<psi> y \<longrightarrow> is_real (to_complex y) \<and> 0 < Re (to_complex y)`
              by (smt complex_of_real_Re inf_notin_unit_disc norm_of_real of_complex_to_complex to_complex_of_complex unit_disc_iff_cmod_lt_1 xx(2))
          qed

          then obtain B where "B \<in> unit_disc" "is_real (to_complex B)"
            "\<forall>x\<in>unit_disc. \<forall>y\<in>unit_disc. \<phi> x \<and> \<psi> y \<longrightarrow> Re (to_complex x) \<le> Re (to_complex B) \<and>
             Re (to_complex B) \<le> Re (to_complex y)"
            by blast

          show "\<exists> b \<in> unit_disc. point_between_sets \<phi> b \<psi>"
          proof (rule_tac x="B" in bexI)
            show "B \<in> unit_disc"
              by fact
          next
            show "point_between_sets \<phi> B \<psi>"
            proof ((rule ballI)+, rule impI)
              fix x y 
              let ?x = "to_complex x" and ?y = "to_complex y" and ?B = "to_complex B"
              assume "x \<in> unit_disc" "y \<in> unit_disc" "\<phi> x \<and> \<psi> y"

              hence "Re ?x \<le> Re ?B \<and> Re ?B \<le> Re ?y"
                using `\<forall>x\<in>unit_disc. \<forall>y\<in>unit_disc. \<phi> x \<and> \<psi> y \<longrightarrow> Re (to_complex x) \<le> Re ?B \<and>
                       Re (to_complex B) \<le> Re (to_complex y)`
                by auto
              moreover
              have "is_real ?x" "Re ?x \<ge> 0"
                using \<phi>noneg
                using `x \<in> unit_disc` `\<phi> x \<and> \<psi> y`
                by auto
              moreover
              have "is_real ?y" "Re ?y > 0"
                using \<psi>pos
                using `y \<in> unit_disc` `\<phi> x \<and> \<psi> y`
                by auto
              moreover
              have "cor (Re ?x) = ?x"
                using complex_of_real_Re `is_real ?x` by blast
              hence "x = of_complex (cor (Re ?x))"
                using `x \<in> unit_disc`
                by (metis inf_notin_unit_disc of_complex_to_complex)
              moreover
              have "cor (Re ?y) = ?y"
                using complex_of_real_Re `is_real ?y` by blast
              hence "y = of_complex (cor (Re ?y))"
                using `y \<in> unit_disc`
                by (metis inf_notin_unit_disc of_complex_to_complex)
              moreover
              have "cor (Re ?B) = ?B"
                using complex_of_real_Re `is_real (to_complex  B)` by blast
              hence "B = of_complex (cor (Re ?B))"
                using `B \<in> unit_disc`
                by (metis inf_notin_unit_disc of_complex_to_complex)
              ultimately
              show "poincare_between x B y"
                using `is_real (to_complex B)` `x \<in> unit_disc` `y \<in> unit_disc` `B \<in> unit_disc`
                using poincare_between_x_axis_uvw[of "Re (to_complex x)" "Re (to_complex B)" "Re (to_complex y)"]
                by (smt Re_complex_of_real arg_0_iff poincare_between_nonstrict(1) rcis_cmod_arg rcis_zero_arg unit_disc_iff_cmod_lt_1)
            qed
          qed            
        qed
      qed 
      thus ?thesis
        using False `\<phi> X0` `\<psi> Y0` * `Y0 \<in> unit_disc` `X0 \<in> unit_disc`
        by auto
    qed      
  qed
qed

subsection{* Interpretation of locales *}

interpretation PoincareTarskiAbsolute: TarskiAbsolute p_congruent p_between
proof
  (* 1. Reflexivity of congruence *)
  fix x y
  show "p_congruent x y y x"
    unfolding p_congruent_def
    by transfer (simp add: poincare_distance_sym)
next
  (* 2. Transitivity of congruence *)
  fix x y z u v w
  show "p_congruent x y z u \<and> p_congruent x y v w \<longrightarrow> p_congruent z u v w"
    by (transfer, simp)
next
  (* 3. Identity of congruence *)
  fix x y z
  show "p_congruent x y z z \<longrightarrow> x = y"
    unfolding p_congruent_def
    by transfer (simp add: poincare_distance_eq_0_iff)
next
  (* 4. Segment construction *)
  fix x y a b
  show "\<exists> z. p_between x y z \<and> p_congruent y z a b"
    using segment_construction
    unfolding p_congruent_def
    by transfer (simp, blast)
next
  (* 5. Five segment *)
  fix x y z x' y' z' u u'
  show "x \<noteq> y \<and> p_between x y z \<and> p_between x' y' z' \<and>
      p_congruent x y x' y' \<and> p_congruent y z y' z' \<and>
      p_congruent x u x' u' \<and> p_congruent y u y' u' \<longrightarrow>
      p_congruent z u z' u'"
    unfolding p_congruent_def
    apply transfer
    using five_segment_axiom                                             
    by meson
next
  (* 6. Identity of betweeness *)
  fix x y
  show "p_between x y x \<longrightarrow> x = y"
    by transfer (simp add: poincare_between_sum_distances poincare_distance_eq_0_iff poincare_distance_sym)
next
  (* 7. Pasch *)
  fix x y z u v
  show "p_between x u z \<and> p_between y v z \<longrightarrow> (\<exists> a. p_between u a y \<and> p_between x a v)"
    apply transfer
    using Pasch
    by blast
next
  (* 8. Lower dimension *)
  show "\<exists> a. \<exists> b. \<exists> c. \<not> p_between a b c \<and> \<not> p_between b c a \<and> \<not> p_between c a b"
    apply (transfer)
    using lower_dimension_axiom
    by simp
next
  (* 9. Upper dimension *)
  fix x y z u v
  show "p_congruent x u x v \<and> p_congruent y u y v \<and> p_congruent z u z v \<and> u \<noteq> v \<longrightarrow>
        p_between x y z \<or> p_between y z x \<or> p_between z x y"
    unfolding p_congruent_def
    by (transfer, simp add: upper_dimension_axiom)
qed

interpretation PoincareTarskiHyperbolic: TarskiHyperbolic p_congruent p_between 
proof
  (* 10. Euclid negation *)
  show "\<exists> a b c d t. p_between a d t \<and> p_between b d c \<and> a \<noteq> d \<and>
                   (\<forall> x y. p_between a b x \<and> p_between a c y \<longrightarrow> \<not> p_between x t y)"
    using negated_euclidean_axiom
    by transfer (auto, blast)
qed

print_locale ElementaryTarskiHyperbolic

interpretation PoincareElementaryTarskiHyperbolic: ElementaryTarskiHyperbolic p_congruent p_between
proof
  (* 11.  Continuity *)
  fix \<phi> \<psi>
  assume "\<exists> a. \<forall> x. \<forall> y. \<phi> x \<and> \<psi> y \<longrightarrow> p_between a x y"
  thus "\<exists> b. \<forall> x. \<forall> y. \<phi> x \<and> \<psi> y \<longrightarrow> p_between x b y"
    apply transfer
    using continuity
    by auto
qed

end