theory Tarski
imports Main
begin

locale TarskiAbsolute =
  fixes cong :: "'p \<Rightarrow> 'p \<Rightarrow> 'p \<Rightarrow> 'p \<Rightarrow> bool"
  fixes betw :: "'p \<Rightarrow> 'p \<Rightarrow> 'p \<Rightarrow> bool"
  assumes cong_reflexive:  "cong x y y x"
  assumes cong_transitive: "cong x y z u \<and> cong x y v w \<longrightarrow> cong z u v w"
  assumes cong_identity:   "cong x y z z \<longrightarrow> x = y"
  assumes segment_construction: "\<exists> z. betw x y z \<and> cong y z a b"
  assumes five_segment:    "x \<noteq> y \<and> betw x y z \<and> betw x' y' z' \<and> cong x y x' y' \<and> cong y z y' z' \<and> cong x u x' u' \<and> cong y u y' u' \<longrightarrow> cong z u z' u'"
  assumes betw_identity:   "betw x y x \<longrightarrow> x = y"
  assumes Pasch:           "betw x u z \<and> betw y v z \<longrightarrow> (\<exists> a. betw u a y \<and> betw x a v)"
  assumes lower_dimension: "\<exists> a. \<exists> b. \<exists> c. \<not> betw a b c \<and> \<not> betw b c a \<and> \<not> betw c a b"
  assumes upper_dimension: "cong x u x v \<and> cong y u y v \<and> cong z u z v \<and> u \<noteq> v \<longrightarrow> betw x y z \<or> betw y z x \<or> betw z x y"

locale TarskiHyperbolic = TarskiAbsolute + 
  assumes euclid_negation: "\<exists> a b c d t. betw a d t \<and> betw b d c \<and> a \<noteq> d \<and> (\<forall> x y. betw a b x \<and> betw a c y \<longrightarrow> \<not> betw x t y)"

locale ElementaryTarskiHyperbolic = TarskiHyperbolic +
  assumes continuity:      "\<lbrakk>\<exists> a. \<forall> x. \<forall> y. \<phi> x \<and> \<psi> y \<longrightarrow> betw a x y\<rbrakk> \<Longrightarrow> \<exists> b. \<forall> x. \<forall> y. \<phi> x \<and> \<psi> y \<longrightarrow> betw x b y"

end
