section{* Unit circle preserving Moebius transformations *}

theory UnitCirclePreservingMoebius
imports Moebius OrientedCirclines
begin

subsection{* Transformations that fix the unit circle *}

lift_definition unit_circle_fix_mmat :: "moebius_mat \<Rightarrow> bool" is unitary11_gen
  done

lift_definition unit_circle_fix :: "moebius \<Rightarrow> bool" is unit_circle_fix_mmat
  apply transfer
  apply (auto simp del: mult_sm.simps)
  apply (simp del: mult_sm.simps add: unitary11_gen_mult_sm)
  apply (simp del: mult_sm.simps add: unitary11_gen_div_sm)
  done

lemma unit_circle_fix_iff:
  shows "unit_circle_fix M \<longleftrightarrow> moebius_circline M unit_circle = unit_circle" (is "?rhs = ?lhs")
proof
  assume ?lhs
  thus ?rhs
  proof (transfer, transfer)
    fix M :: complex_mat
    assume "mat_det M \<noteq> 0"
    assume "circline_eq_cmat (moebius_circline_cmat_cmat M unit_circle_cmat) unit_circle_cmat"
    then obtain k where "k \<noteq> 0" "(1, 0, 0, -1) = cor k *\<^sub>s\<^sub>m congruence (mat_inv M) (1, 0, 0, -1)"
      by auto
    hence "(1/cor k, 0, 0, -1/cor k) = congruence (mat_inv M) (1, 0, 0, -1)"
      using mult_sm_inv_l[of "cor k" "congruence (mat_inv M) (1, 0, 0, -1)" ]
      by simp
    hence "congruence M (1/cor k, 0, 0, -1/cor k) = (1, 0, 0, -1)"
      using `mat_det M \<noteq> 0` mat_det_inv[of M]
      using congruence_inv[of "mat_inv M" "(1, 0, 0, -1)" "(1/cor k, 0, 0, -1/cor k)"]
      by simp
    hence "congruence M (1, 0, 0, -1) = cor k *\<^sub>s\<^sub>m (1, 0, 0, -1)"
      using congruence_scale_m[of "M" "1/cor k" "(1, 0, 0, -1)"]
      using mult_sm_inv_l[of "1/ cor k" "congruence M (1, 0, 0, -1)"  "(1, 0, 0, -1)"] `k \<noteq> 0`
      by simp
    thus "unitary11_gen M"
      using `k \<noteq> 0`
      unfolding unitary11_gen_def
      by simp
  qed
next
  assume ?rhs
  thus ?lhs
  proof (transfer, transfer)
    fix M :: complex_mat
    assume "mat_det M \<noteq> 0"
    assume "unitary11_gen M"
    hence "unitary11_gen (mat_inv M)"
      using `mat_det M \<noteq> 0`
      using unitary11_gen_mat_inv
      by simp
    thus " circline_eq_cmat (moebius_circline_cmat_cmat M unit_circle_cmat) unit_circle_cmat"
      unfolding unitary11_gen_real
      by auto (rule_tac x="1/k" in exI, simp)
  qed
qed

lemma circline_set_fix_iff_circline_fix:
  assumes "circline_set H' \<noteq> {}"
  shows "circline_set (moebius_circline M H) = circline_set H' \<longleftrightarrow> moebius_circline M H = H'"
  using assms
  by auto (rule inj_circline_set, auto)

lemma unit_circle_fix_iff_unit_circle_set:
  shows "unit_circle_fix M \<longleftrightarrow> moebius_pt M ` unit_circle_set = unit_circle_set"
proof-
  have "circline_set unit_circle \<noteq> {}"
    using one_in_unit_circle_set
    by auto
  thus ?thesis
    using unit_circle_fix_iff[of M] circline_set_fix_iff_circline_fix[of unit_circle M unit_circle]
    by (simp add: unit_circle_set_def)
qed


text{* Unit circle preserving transformations form a group *}

lemma [simp]: "unit_circle_fix id_moebius"
  by (transfer, transfer, simp add: unitary11_gen_def mat_adj_def mat_cnj_def)

lemma unit_circle_fix_moebius_add [simp]:
  assumes "unit_circle_fix M1" "unit_circle_fix M2"
  shows "unit_circle_fix (M1 + M2)"
  using assms
  unfolding unit_circle_fix_iff
  by auto

lemma unit_circle_fix_moebius_comp [simp]:
  assumes "unit_circle_fix M1" "unit_circle_fix M2"
  shows "unit_circle_fix (moebius_comp M1 M2)"
  using unit_circle_fix_moebius_add[OF assms]
  by simp

lemma unit_circle_fix_moebius_uminus [simp]:
  assumes "unit_circle_fix M"
  shows "unit_circle_fix (-M)"
  using assms
  unfolding unit_circle_fix_iff
  by (metis moebius_circline_comp_inv_left uminus_moebius_def)

lemma unit_circle_fix_moebius_inv [simp]:
  assumes "unit_circle_fix M"
  shows "unit_circle_fix (moebius_inv M)"
  using unit_circle_fix_moebius_uminus[OF assms]
  by simp

text{* Unit circle fixing transforms preserve inverse points *}

lemma unit_circle_fix_moebius_pt_inversion [simp]:
  assumes "unit_circle_fix M"
  shows "moebius_pt M (inversion z) = inversion (moebius_pt M z)"
  using assms
  using symmetry_principle[of z "inversion z" unit_circle M]
  using unit_circle_fix_iff[of M, symmetric]
  using circline_symmetric_inv_homo_disc[of z]
  using circline_symmetric_inv_homo_disc'[of "moebius_pt M z" "moebius_pt M (inversion z)"]
  by metis

subsection{* Transformations that fix the imaginary unit circle - just for fun*}

lemma imag_unit_circle_fixed_iff_unitary_gen:
  assumes "mat_det (A, B, C, D) \<noteq> 0"
  shows "moebius_circline (mk_moebius A B C D) imag_unit_circle = imag_unit_circle \<longleftrightarrow>
         unitary_gen (A, B, C, D)" (is "?lhs = ?rhs")
proof
  assume ?lhs
  thus ?rhs
    using assms
  proof (transfer, transfer)
    fix A B C D :: complex
    let ?M = "(A, B, C, D)" and ?E = "(1, 0, 0, 1)"
    assume "circline_eq_cmat (moebius_circline_cmat_cmat (mk_moebius_cmat A B C D) imag_unit_circle_cmat) imag_unit_circle_cmat"
           "mat_det ?M \<noteq> 0"
    then obtain k where "k \<noteq> 0" "?E = cor k *\<^sub>s\<^sub>m congruence (mat_inv ?M) ?E"
      by auto
    hence "unitary_gen (mat_inv ?M)"
      using mult_sm_inv_l[of "cor k" "congruence (mat_inv ?M) ?E" "?E"]
      unfolding unitary_gen_def
      by (rule_tac x="1/cor k" in exI, simp del: mat_inv.simps, metis eye_def mat_eye_r)
    thus "unitary_gen ?M"
      using unitary_gen_inv[of "mat_inv ?M"] `mat_det ?M \<noteq> 0`
      by (simp del: mat_inv.simps)
  qed
next
  assume ?rhs
  thus ?lhs
    using assms
  proof (transfer, transfer)
    fix A B C D :: complex
    let ?M = "(A, B, C, D)" and ?E = "(1, 0, 0, 1)"
    assume "unitary_gen ?M" "mat_det ?M \<noteq> 0"
    hence "unitary_gen (mat_inv ?M)"
      using unitary_gen_inv[of ?M]
      by simp
    then obtain k where "k \<noteq> 0" "mat_adj (mat_inv ?M) *\<^sub>m\<^sub>m (mat_inv ?M) = cor k *\<^sub>s\<^sub>m eye"
      using unitary_gen_real[of "mat_inv ?M"] mat_det_inv[of ?M]
      by auto
    hence *: "?E = (1 / cor k) *\<^sub>s\<^sub>m (mat_adj (mat_inv ?M) *\<^sub>m\<^sub>m (mat_inv ?M))"
      using mult_sm_inv_l[of "cor k" eye "mat_adj (mat_inv ?M) *\<^sub>m\<^sub>m (mat_inv ?M)"]
      by simp
    show "circline_eq_cmat (moebius_circline_cmat_cmat (mk_moebius_cmat A B C D) imag_unit_circle_cmat) imag_unit_circle_cmat"
      using `mat_det ?M \<noteq> 0` `k \<noteq> 0`
      by (simp del: mat_inv.simps) (rule_tac x="1/k" in exI, subst *, simp del: mat_inv.simps, metis eye_def mat_eye_r)
  qed
qed

subsection{* Transformation that fix oriented unit circle and unit disc *}
  
definition unit_disc_fix_cmat :: "complex_mat \<Rightarrow> bool" where
 [simp]: "unit_disc_fix_cmat M \<longleftrightarrow>
          (let (A, B, C, D) = M
            in unitary11_gen (A, B, C, D) \<and> (B = 0 \<or> Re ((A*D)/(B*C)) > 1))"

lift_definition unit_disc_fix_mmat :: "moebius_mat \<Rightarrow> bool" is unit_disc_fix_cmat
  done

lift_definition unit_disc_fix :: "moebius \<Rightarrow> bool" is unit_disc_fix_mmat
proof transfer
  fix M M' :: complex_mat
  assume det: "mat_det M \<noteq> 0" "mat_det M' \<noteq> 0"
  assume "moebius_cmat_eq M M'"
  then obtain k where *: "k \<noteq> 0" "M' = k *\<^sub>s\<^sub>m M"
    by auto
  hence **: "unitary11_gen M \<longleftrightarrow> unitary11_gen M'"
    using unitary11_gen_mult_sm[of k M] unitary11_gen_div_sm[of k M]
    by auto
  obtain A B C D where MM: "(A, B, C, D) = M"
    by (cases M) auto
  obtain A' B' C' D' where MM': "(A', B', C', D') = M'"
    by (cases M') auto

  show "unit_disc_fix_cmat M = unit_disc_fix_cmat M'"
    using * ** MM MM'
    by auto
qed

lemma unit_disc_fix_unit_circle_fix [simp]:
  assumes "unit_disc_fix M"
  shows "unit_circle_fix M"
  using assms
  by (transfer, transfer, auto)

lemma unit_disc_fix_iff_ounit_circle:
  shows "unit_disc_fix M \<longleftrightarrow> moebius_ocircline M ounit_circle = ounit_circle" (is "?rhs \<longleftrightarrow> ?lhs")
proof
  assume *: ?lhs
  have "moebius_circline M unit_circle = unit_circle"
    apply (subst moebius_circline_ocircline[of M unit_circle])
    apply (subst of_circline_unit_circle)
    apply (subst *)
    by simp

  hence "unit_circle_fix M"
    by (simp add: unit_circle_fix_iff)
  thus ?rhs
    using *
  proof (transfer, transfer)
    fix M :: complex_mat
    assume "mat_det M \<noteq> 0"
    let ?H = "(1, 0, 0, -1)"
    obtain A B C D where MM: "(A, B, C, D) = M"
      by (cases M) auto
    assume "unitary11_gen M" "ocircline_eq_cmat (moebius_circline_cmat_cmat M unit_circle_cmat) unit_circle_cmat"
    then obtain k where "0 < k" "?H = cor k *\<^sub>s\<^sub>m congruence (mat_inv M) ?H"
      by auto
    hence "congruence M ?H = cor k *\<^sub>s\<^sub>m ?H"
      using congruence_inv[of "mat_inv M" "?H" "(1/cor k) *\<^sub>s\<^sub>m ?H"] `mat_det M \<noteq> 0`
      using mult_sm_inv_l[of "cor k" "congruence (mat_inv M) ?H" "?H"]
      using mult_sm_inv_l[of "1/cor k" "congruence M ?H"]
      using congruence_scale_m[of M "1/cor k" "?H"]
      by (auto simp add: mat_det_inv)
    then obtain a b k' where "k' \<noteq> 0" "M = k' *\<^sub>s\<^sub>m (a, b, cnj b, cnj a)" "sgn (Re (mat_det (a, b, cnj b, cnj a))) = 1"
      using unitary11_sgn_det_orientation'[of M k] `k > 0`
      by auto
    moreover
    have "mat_det (a, b, cnj b, cnj a) \<noteq> 0"
      using `sgn (Re (mat_det (a, b, cnj b, cnj a))) = 1`
      by (smt sgn_0 zero_complex.simps(1))
    ultimately
    show "unit_disc_fix_cmat M"
      using unitary11_sgn_det[of k' a b M A B C D]
      using MM[symmetric] `k > 0` `unitary11_gen M`
      by (simp add: sgn_1_pos split: if_split_asm)
  qed
next
  assume ?rhs
  thus ?lhs
  proof (transfer, transfer)
    fix M :: complex_mat
    assume "mat_det M \<noteq> 0"

    obtain A B C D where MM: "(A, B, C, D) = M"
      by (cases M) auto
    assume "unit_disc_fix_cmat M"
    hence "unitary11_gen M" "B = 0 \<or> 1 < Re (A * D / (B * C))"
      using MM[symmetric]
      by auto
    have "sgn (if B = 0 then 1 else sgn (Re (A * D / (B * C)) - 1)) = 1"
      using `B = 0 \<or> 1 < Re (A * D / (B * C))`
      by auto
    then obtain k' where "k' > 0" "congruence M (1, 0, 0, -1) = cor k' *\<^sub>s\<^sub>m (1, 0, 0, -1)"
      using unitary11_orientation[OF `unitary11_gen M` MM[symmetric]]
      by (auto simp add: sgn_1_pos)
    thus "ocircline_eq_cmat (moebius_circline_cmat_cmat M unit_circle_cmat) unit_circle_cmat"
      using congruence_inv[of M "(1, 0, 0, -1)" "cor k' *\<^sub>s\<^sub>m (1, 0, 0, -1)"] `mat_det M \<noteq> 0`
      using congruence_scale_m[of "mat_inv M" "cor k'" "(1, 0, 0, -1)"]
      by auto
  qed
qed

(* not used *)
lemma ocircline_set_fix_iff_ocircline_fix:
  assumes "ocircline_set H' \<noteq> {}"
  shows "ocircline_set (moebius_ocircline M H) = ocircline_set H' \<longleftrightarrow>
         moebius_ocircline M H = H' \<or> moebius_ocircline M H = opposite_ocircline H'"
  using assms
  using inj_ocircline_set[of "moebius_ocircline M H" H']
  by (auto simp del: ocircline_set_moebius_ocircline)

(* Other direction would require injectivity of disc, which seems hard to prove*)
lemma unit_disc_fix_iff [simp]:
  assumes "unit_disc_fix M"
  shows "moebius_pt M ` unit_disc = unit_disc"
  using assms
  using unit_disc_fix_iff_ounit_circle[of M]
  unfolding unit_disc_def
  by (subst disc_moebius_ocircline[symmetric], simp)

lemma unit_disc_fix_discI [simp]:
  assumes "unit_disc_fix M" "u \<in> unit_disc"
  shows "moebius_pt M u \<in> unit_disc"
  using unit_disc_fix_iff assms
  by blast

text{* Unit disc preserving transformations form a group *}

lemma [simp]: "unit_disc_fix id_moebius"
  by (transfer, transfer, simp add: unitary11_gen_def mat_adj_def mat_cnj_def)

lemma unit_disc_fix_moebius_add [simp]:
  assumes "unit_disc_fix M1" "unit_disc_fix M2"
  shows "unit_disc_fix (M1 + M2)"
  using assms
  unfolding unit_disc_fix_iff_ounit_circle
  by auto

lemma unit_disc_fix_moebius_comp [simp]:
  assumes "unit_disc_fix M1" "unit_disc_fix M2"
  shows "unit_disc_fix (moebius_comp M1 M2)"
  using unit_disc_fix_moebius_add[OF assms]
  by simp

lemma unit_disc_fix_moebius_uminus [simp]:
  assumes "unit_disc_fix M"
  shows "unit_disc_fix (-M)"
  using assms
  unfolding unit_disc_fix_iff_ounit_circle
  by (metis moebius_ocircline_comp_inv_left uminus_moebius_def)

lemma unit_disc_fix_moebius_inv [simp]:
  assumes "unit_disc_fix M"
  shows "unit_disc_fix (moebius_inv M)"
  using unit_disc_fix_moebius_uminus[OF assms]
  by simp

subsection{* Rotations are unit disc preserving transformations *}

lemma unit_disc_fix_rotation
  [simp]: "unit_disc_fix (moebius_rotation \<phi>)"      
  unfolding moebius_rotation_def moebius_similarity_def
  by (transfer, transfer, simp add: unitary11_gen_def mat_adj_def mat_cnj_def cis_mult)

lemma ex_rotation_mapping_u_to_positive_x_axis:
  assumes "u \<noteq> 0\<^sub>h" "u \<noteq> \<infinity>\<^sub>h"
  shows "\<exists> \<phi>. moebius_pt (moebius_rotation \<phi>) u \<in> positive_x_axis"
proof-
  from assms obtain c where *: "u = of_complex c"
    using inf_or_of_complex
    by blast
  have "is_real (cis (- arg c) * c)" "Re (cis (-arg c) * c) > 0"
    using "*" assms is_real_rot_to_x_axis positive_rot_to_x_axis of_complex_zero_iff
    by blast+
  thus ?thesis
    using *
    by (rule_tac x="-arg c" in exI) (simp add: positive_x_axis_def circline_set_x_axis)
qed

lemma ex_rotation_mapping_u_to_positive_y_axis:
  assumes "u \<noteq> 0\<^sub>h" "u \<noteq> \<infinity>\<^sub>h"
  shows "\<exists> \<phi>. moebius_pt (moebius_rotation \<phi>) u \<in> positive_y_axis"
proof-
  from assms obtain c where *: "u = of_complex c"
    using inf_or_of_complex
    by blast
  have "is_imag (cis (pi/2 - arg c) * c)" "Im (cis (pi/2 - arg c) * c) > 0"
    using "*" assms is_real_rot_to_x_axis positive_rot_to_x_axis of_complex_zero_iff
    by - (simp, simp, simp add: field_simps)
  thus ?thesis
    using *
    by (rule_tac x="pi/2-arg c" in exI) (simp add: positive_y_axis_def circline_set_y_axis)
qed

lemma wlog_rotation_to_positive_x_axis:
  assumes in_disc: "u \<in> unit_disc" "u \<noteq> 0\<^sub>h"
  assumes preserving: "\<And>\<phi> u. \<lbrakk>u \<in> unit_disc; u \<noteq> 0\<^sub>h; P (moebius_pt (moebius_rotation \<phi>) u)\<rbrakk> \<Longrightarrow> P u"
  assumes x_axis: "\<And>x. \<lbrakk>is_real x; 0 < Re x; Re x < 1\<rbrakk> \<Longrightarrow> P (of_complex x)"
  shows "P u"
proof-
  from in_disc obtain \<phi> where *:
    "moebius_pt (moebius_rotation \<phi>) u \<in> positive_x_axis"
    using ex_rotation_mapping_u_to_positive_x_axis[of u]
    using inf_notin_unit_disc
    by blast
  let ?Mu = "moebius_pt (moebius_rotation \<phi>) u"
  have "P ?Mu"
  proof-
    let ?x = "to_complex ?Mu"
    have "?Mu \<in> unit_disc" "?Mu \<noteq> 0\<^sub>h" "?Mu \<noteq> \<infinity>\<^sub>h"
      using `u \<in> unit_disc` `u \<noteq> 0\<^sub>h`
      by auto
    hence "is_real (to_complex ?Mu)"  "0 < Re ?x" "Re ?x < 1"
      using *
      unfolding positive_x_axis_def circline_set_x_axis
      by (auto simp add: cmod_eq_Re)
    thus ?thesis
      using x_axis[of ?x] `?Mu \<noteq> \<infinity>\<^sub>h`
      by simp
  qed
  thus ?thesis
    using preserving[OF in_disc]
    by simp
qed

lemma wlog_rotation_to_positive_y_axis:
  assumes in_disc: "u \<in> unit_disc" "u \<noteq> 0\<^sub>h"
  assumes preserving: "\<And>\<phi> u. \<lbrakk>u \<in> unit_disc; u \<noteq> 0\<^sub>h; P (moebius_pt (moebius_rotation \<phi>) u)\<rbrakk> \<Longrightarrow> P u"
  assumes y_axis: "\<And>x. \<lbrakk>is_imag x; 0 < Im x; Im x < 1\<rbrakk> \<Longrightarrow> P (of_complex x)"
  shows "P u"
proof-
  from in_disc obtain \<phi> where *:
    "moebius_pt (moebius_rotation \<phi>) u \<in> positive_y_axis"
    using ex_rotation_mapping_u_to_positive_y_axis[of u]
    using inf_notin_unit_disc
    by blast
  let ?Mu = "moebius_pt (moebius_rotation \<phi>) u"
  have "P ?Mu"
  proof-
    let ?y = "to_complex ?Mu"
    have "?Mu \<in> unit_disc" "?Mu \<noteq> 0\<^sub>h" "?Mu \<noteq> \<infinity>\<^sub>h"
      using `u \<in> unit_disc` `u \<noteq> 0\<^sub>h`
      by auto
    hence "is_imag (to_complex ?Mu)"  "0 < Im ?y" "Im ?y < 1"
      using *
      unfolding positive_y_axis_def circline_set_y_axis
      by (auto simp add: cmod_eq_Im)
    thus ?thesis
      using y_axis[of ?y] `?Mu \<noteq> \<infinity>\<^sub>h`
      by simp
  qed
  thus ?thesis
    using preserving[OF in_disc]
    by simp
qed

text{* Blaschke factor - a disc preserving transform mapping a given point to zero *}

definition blaschke_cmat :: "complex \<Rightarrow> complex_mat" where
 [simp]: "blaschke_cmat a = (if cmod a \<noteq> 1 then (1, -a, -cnj a, 1) else eye)"
lift_definition blaschke_mmat :: "complex \<Rightarrow> moebius_mat" is blaschke_cmat
  by simp
lift_definition blaschke :: "complex \<Rightarrow> moebius" is blaschke_mmat
  done

lemma blaschke_0_id [simp]: "blaschke 0 = id_moebius"
  by (transfer, transfer, simp)

lemma blaschke_a_to_zero [simp]:
  assumes "cmod a \<noteq> 1"
  shows "moebius_pt (blaschke a) (of_complex a) = 0\<^sub>h"
  using assms
  by (transfer, transfer, simp)

lemma blaschke_inv_a_inf [simp]:
  assumes "cmod a \<noteq> 1"
  shows "moebius_pt (blaschke a) (inversion (of_complex a)) = \<infinity>\<^sub>h"
  using assms
  unfolding inversion_def
  by (transfer, transfer) (simp add: vec_cnj_def, rule_tac x="1/(1 - a*cnj a)" in exI, simp)

lemma blaschke_inf [simp]:
  assumes "cmod a < 1" "a \<noteq> 0"
  shows "moebius_pt (blaschke a) \<infinity>\<^sub>h = of_complex (- 1 / cnj a)"
  using assms
  by (transfer, transfer, simp add: complex_mod_sqrt_Re_mult_cnj)

lemma blaschke_0_minus_a [simp]:
  assumes "cmod a \<noteq> 1"
  shows "moebius_pt (blaschke a) 0\<^sub>h = ~\<^sub>h (of_complex a)"
  using assms
  by (transfer, transfer, simp)
                                                
lemma blaschke_unit_circle_fix [simp]:
  assumes "cmod a \<noteq> 1"
  shows "unit_circle_fix (blaschke a)"
  using assms
  by (transfer, transfer) (simp add: unitary11_gen_def mat_adj_def mat_cnj_def)

lemma blaschke_unit_disc_fix [simp]:
  assumes "cmod a < 1"
  shows "unit_disc_fix (blaschke a)"
  using assms
proof (transfer, transfer)
  fix a
  assume *: "cmod a < 1"
  show "unit_disc_fix_cmat (blaschke_cmat a)"
  proof (cases "a = 0")
    case True
    thus ?thesis
      by (simp add: unitary11_gen_def mat_adj_def mat_cnj_def)
  next
    case False
    hence "Re (a * cnj a) < 1"
      using *
      by (metis complex_mod_sqrt_Re_mult_cnj real_sqrt_lt_1_iff)
    hence "1 / Re (a * cnj a) > 1"
      using False
      by (smt complex_div_gt_0 less_divide_eq_1_pos one_complex.simps(1) right_inverse_eq)
    hence "Re (1 / (a * cnj a)) > 1"
      by (simp add: complex_is_Real_iff)
    thus ?thesis
      by (simp add: unitary11_gen_def mat_adj_def mat_cnj_def)
  qed
qed

lemma blaschke_unit_circle_fix':
  assumes "cmod a \<noteq> 1"
  shows "moebius_circline (blaschke a) unit_circle = unit_circle"
  using assms
  using blaschke_unit_circle_fix unit_circle_fix_iff
  by simp

lemma blaschke_ounit_circle_fix':
  assumes "cmod a < 1"
  shows "moebius_ocircline (blaschke a) ounit_circle = ounit_circle"
proof-
  have "Re (a * cnj a) < 1"
    using assms
    by (metis complex_mod_sqrt_Re_mult_cnj real_sqrt_lt_1_iff)
  thus ?thesis
    using assms
    using blaschke_unit_disc_fix unit_disc_fix_iff_ounit_circle
    by simp
qed

lemma moebius_pt_blaschke [simp]:
  assumes "cmod a \<noteq> 1" "z \<noteq> 1 / cnj a"
  shows "moebius_pt (blaschke a) (of_complex z) = of_complex ((z - a) / (1 - cnj a * z))"
  using assms
proof (cases "a = 0")
  case True
  thus ?thesis
    by auto
next
  case False
  thus ?thesis
    using assms
    apply (transfer, transfer)
    apply (simp add: complex_mod_sqrt_Re_mult_cnj)
    apply (rule_tac x="1 / (1 - cnj a * z)" in exI)
    apply (simp add: field_simps)
    done
qed

(* Blaschke transform that maps a real point to zero *)

lemma blaschke_real_preserve_sgn_Im [simp]:
  assumes "is_real a" "cmod a < 1" "z \<noteq> \<infinity>\<^sub>h" "z \<noteq> inversion (of_complex a)"
  shows "sgn (Im (to_complex (moebius_pt (blaschke a) z))) = sgn (Im (to_complex z))"
proof (cases "a = 0")
  case True
  thus ?thesis
    by simp
next
  case False
  obtain z' where z': "z = of_complex z'"
    using inf_or_of_complex[of z] `z \<noteq> \<infinity>\<^sub>h`
    by auto
  have "z' \<noteq> 1 / cnj a"
    using assms z' `a \<noteq> 0`
    by (auto simp add: of_complex_inj)
  moreover
  have "a * cnj a \<noteq> 1"
    using `cmod a < 1`
    by auto (simp add: complex_mod_sqrt_Re_mult_cnj)
  moreover
  have "sgn (Im ((z' - a) / (1 - a * z'))) = sgn (Im z')"
  proof-
    have "a * z' \<noteq> 1"
      using `is_real a` `z' \<noteq> 1 / cnj a` `a \<noteq> 0` eq_cnj_iff_real[of a]
      by (simp add: field_simps)
    moreover                             
    have "Re (1 - a\<^sup>2) > 0"
      using `is_real a` `cmod a < 1`
      by (smt Re_power2 minus_complex.simps(1) norm_complex_def one_complex.simps(1) power2_less_0 real_sqrt_lt_1_iff)
    moreover
    have "Im ((z' - a) / (1 - a * z')) = Re (((1 - a\<^sup>2) * Im z') / (cmod (1 - a*z'))\<^sup>2)"
    proof-
      have "1 - a * cnj z' \<noteq> 0"
        using `z' \<noteq> 1 / cnj a`
        by (metis Im_complex_div_eq_0  complex_cnj_zero_iff diff_eq_diff_eq diff_numeral_special(9) eq_divide_imp is_real_div mult_not_zero one_complex.simps(2) zero_neq_one)
      hence "Im ((z' - a) / (1 - a * z')) = Im (((z' - a) * (1 - a * cnj z')) / ((1 - a * z') * cnj (1 - a * z')))"
        using `is_real a` eq_cnj_iff_real[of a]
        by simp
      also have "... = Im ((z' - a - a * z' * cnj z' + a\<^sup>2 * cnj z') / (cmod (1 - a*z'))\<^sup>2)"
        unfolding complex_mult_cnj_cmod
        by (simp add: power2_eq_square field_simps)
      finally show ?thesis
        using `is_real a`
        by (simp add: complex_of_real_Re field_simps) 
    qed
    ultimately
    show ?thesis
      unfolding sgn_real_def
      using `cmod a < 1` `a * z' \<noteq> 1` `is_real a`
      by (auto simp add: cmod_eq_Re)
         (smt power2_less_0 zero_less_divide_iff zero_less_mult_pos)
  qed
  ultimately
  show ?thesis
    using assms z' moebius_pt_blaschke[of a z'] `is_real a` eq_cnj_iff_real[of a]                  
    by simp
qed

lemma blaschke_real_preserve_x_axis [simp]:
  assumes "is_real a" "cmod a < 1"
  shows "moebius_pt (blaschke a) z \<in> circline_set x_axis \<longleftrightarrow> z \<in> circline_set x_axis"
proof (cases "a = 0")
  case True
  thus ?thesis
    by simp
next
  case False
  have "cmod a \<noteq> 1"
    using assms
    by linarith
  let ?a = "of_complex a"
  let ?i = "inversion ?a"
  let ?M = "moebius_pt (blaschke a)"
  have *: "?M ?a = 0\<^sub>h" "?M ?i = \<infinity>\<^sub>h" "?M 0\<^sub>h = of_complex (-a)"
    using `cmod a \<noteq> 1` blaschke_a_to_zero[of a] blaschke_inv_a_inf[of a] blaschke_0_minus_a[of a]
    by auto
  let ?Mx = "moebius_circline (blaschke a) x_axis"
  have "?a \<in> circline_set x_axis" "?i \<in> circline_set x_axis" "0\<^sub>h \<in> circline_set x_axis"
    using `is_real a` `a \<noteq> 0` eq_cnj_iff_real[of a]
    by auto
      (simp add: circline_set_x_axis image_iff, rule_tac x="1/a" in exI, simp add: is_real_div)
  hence "0\<^sub>h \<in> circline_set ?Mx" "\<infinity>\<^sub>h \<in> circline_set ?Mx" "of_complex (-a) \<in> circline_set ?Mx"
    using *
    apply -                          
    apply (force simp add: image_iff)+
    apply (simp add: image_iff, rule_tac x="0\<^sub>h" in bexI, simp_all)   
    done
  moreover
  have "0\<^sub>h \<in> circline_set x_axis" "\<infinity>\<^sub>h \<in> circline_set x_axis" "of_complex (-a) \<in> circline_set x_axis"
    using `is_real a` 
    by auto
  moreover
  have "of_complex (-a) \<noteq> 0\<^sub>h"
    using `a \<noteq> 0`
    by simp
  hence "0\<^sub>h \<noteq> of_complex (-a)"
    by metis
  hence "\<exists>!H. 0\<^sub>h \<in> circline_set H \<and> \<infinity>\<^sub>h \<in> circline_set H \<and> of_complex (- a) \<in> circline_set H"
    using unique_circline_set[of "0\<^sub>h" "\<infinity>\<^sub>h" "of_complex (-a)"] `a \<noteq> 0`
    by simp
  ultimately
  have "moebius_circline (blaschke a) x_axis = x_axis"
    by auto
  thus ?thesis
    by (metis circline_set_moebius_circline_iff)
qed

lemma blaschke_real_preserve_sgn_arg [simp]:
  assumes "is_real a" "cmod a < 1" "z \<notin> circline_set x_axis"
  shows "sgn (arg (to_complex (moebius_pt (blaschke a) z))) = sgn (arg (to_complex z))"
proof (cases "a = 0")
  case True
  thus ?thesis
    by simp
next
  case False
  let ?M = "moebius_pt (blaschke a)"
  obtain z' where z': "z = of_complex z'"
    using inf_or_of_complex[of z] assms
    by auto

  have *: "z \<noteq> \<infinity>\<^sub>h" "\<not> is_real (to_complex z)"
    using assms z'
    unfolding circline_set_x_axis
    by auto

  have "z \<noteq> inversion (of_complex a)"
    using assms * z' `a \<noteq> 0` eq_cnj_iff_real[of a]
    by auto (metis complex_cnj_divide complex_cnj_one eq_cnj_iff_real of_complex_inj)
  moreover
  have "?M z \<notin> circline_set x_axis"
    using blaschke_real_preserve_x_axis[of a z] assms
    unfolding circline_set_x_axis
    by auto
  hence "\<not> is_real (to_complex (?M z))"
    using assms inf_or_of_complex[of z]
    unfolding circline_set_x_axis
    by force
  ultimately
  show ?thesis
    using blaschke_real_preserve_sgn_Im[of a z] assms *
    using arg_Im_sgn[of "to_complex z"] arg_Im_sgn[of "to_complex (moebius_pt (blaschke a) z)"]
    by simp
qed

text{* Inverse Blaschke transform *}

definition inv_blaschke_cmat :: "complex \<Rightarrow> complex_mat" where
 [simp]: "inv_blaschke_cmat a = (if cmod a \<noteq> 1 then (1, a, cnj a, 1) else eye)"
lift_definition inv_blaschke_mmat :: "complex \<Rightarrow> moebius_mat" is inv_blaschke_cmat
  by simp
lift_definition inv_blaschke :: "complex \<Rightarrow> moebius" is inv_blaschke_mmat
  done

lemma [simp]: "inv_blaschke a = blaschke (-a)"
  by (transfer, transfer) simp

lemma inv_blaschke:
  assumes "cmod a \<noteq> 1"
  shows "blaschke a + inv_blaschke a = 0"
  apply simp
  apply (transfer, transfer)
  by auto (rule_tac x="1/(1 - a*cnj a)" in exI, simp)

lemma ex_unit_disc_fix_mapping_u_to_zero:
  assumes "u \<in> unit_disc"
  shows "\<exists> M. unit_disc_fix M \<and> moebius_pt M u = 0\<^sub>h"
proof-
  from assms obtain c where *: "u = of_complex c"
    by (metis inf_notin_unit_disc inf_or_of_complex)
  hence "cmod c < 1"
    using assms unit_disc_iff_cmod_lt_1
    by simp
  thus ?thesis
    using *
    by (rule_tac x="blaschke c" in exI)
       (smt blaschke_a_to_zero blaschke_ounit_circle_fix' unit_disc_fix_iff_ounit_circle)
qed

lemma wlog_zero:
  assumes in_disc: "u \<in> unit_disc"
  assumes preserving: "\<And> a u. \<lbrakk>u \<in> unit_disc; cmod a < 1; P (moebius_pt (blaschke a) u)\<rbrakk> \<Longrightarrow> P u"
  assumes zero: "P 0\<^sub>h"
  shows "P u"
proof-
  have *: "moebius_pt (blaschke (to_complex u)) u = 0\<^sub>h"
    by (smt blaschke_a_to_zero in_disc inf_notin_unit_disc of_complex_to_complex unit_disc_iff_cmod_lt_1)
  thus ?thesis
    using preserving[of u "to_complex u"] in_disc zero
    using inf_or_of_complex[of u]
    by auto
qed

lemma wlog_real_zero:
  assumes in_disc: "u \<in> unit_disc" "is_real (to_complex u)"
  assumes preserving: "\<And> a u. \<lbrakk>u \<in> unit_disc; is_real a; cmod a < 1; P (moebius_pt (blaschke a) u)\<rbrakk> \<Longrightarrow> P u"
  assumes zero: "P 0\<^sub>h"
  shows "P u"
proof-
  have *: "moebius_pt (blaschke (to_complex u)) u = 0\<^sub>h"
    by (smt blaschke_a_to_zero in_disc inf_notin_unit_disc of_complex_to_complex unit_disc_iff_cmod_lt_1)
  thus ?thesis
    using preserving[of u "to_complex u"] in_disc zero
    using inf_or_of_complex[of u]
    by auto
qed

lemma unit_disc_fix_transitive:
  assumes in_disc: "u \<in> unit_disc" "u' \<in> unit_disc"
  shows "\<exists> M. unit_disc_fix M \<and> moebius_pt M u = u'"
proof-
  have "\<forall> u \<in> unit_disc. \<exists> M. unit_disc_fix M \<and> moebius_pt M u = u'" (is "?P u'")
  proof (rule wlog_zero)
    show "u' \<in> unit_disc" by fact
  next
    show "?P 0\<^sub>h"
      by (simp add: ex_unit_disc_fix_mapping_u_to_zero)
  next
    fix a u
    assume "cmod a < 1" and *: "?P (moebius_pt (blaschke a) u)"
    show "?P u"
    proof
      fix u'
      assume "u' \<in> unit_disc"
      then obtain M' where "unit_disc_fix M'" "moebius_pt M' u' = moebius_pt (blaschke a) u"
        using *
        by auto
      thus "\<exists>M. unit_disc_fix M \<and> moebius_pt M u' = u"
        using `cmod a < 1` blaschke_unit_disc_fix[of a]
        using unit_disc_fix_moebius_comp[of "- blaschke a" "M'"]
        using unit_disc_fix_moebius_inv[of "blaschke a"]
        by (rule_tac x="(- (blaschke a)) + M'" in exI, simp)
    qed
  qed
  thus ?thesis
    using assms
    by auto
qed

subsection{* Decomposition of unit_disc_fix moebius transforms *}

lemma unit_disc_fix_decompose_blaschke_rotation:
  assumes "unit_disc_fix M"
  shows "\<exists> k \<phi>. cmod k < 1 \<and> M = moebius_rotation \<phi> + blaschke k"
  using assms
  unfolding moebius_rotation_def moebius_similarity_def
proof (simp, transfer, transfer)
  fix M
  assume *: "mat_det M \<noteq> 0" "unit_disc_fix_cmat M"
  then obtain k a b :: complex where
    **: "k \<noteq> 0" "mat_det (a, b, cnj b, cnj a) \<noteq> 0" "M = k *\<^sub>s\<^sub>m (a, b, cnj b, cnj a)"
    using unitary11_gen_iff[of M]
    by auto
  have "a \<noteq> 0"
    using * **
    by auto
  then obtain a' k' \<phi>
    where ***: "k' \<noteq> 0 \<and> a' * cnj a' \<noteq> 1 \<and> M = k' *\<^sub>s\<^sub>m (cis \<phi>, 0, 0, 1) *\<^sub>m\<^sub>m (1, - a', - cnj a', 1)"
    using ** unitary11_gen_cis_blaschke[of k M a b]
    by auto
  have "cmod a' < 1"
    using * *** complex_mult_cnj_cmod[of a']
    by auto (smt less_divide_eq_1 one_less_power one_power2 zero_less_numeral)
  thus "\<exists>k. cmod k < 1 \<and>
            (\<exists>\<phi>. moebius_cmat_eq M (moebius_comp_cmat (mk_moebius_cmat (cis \<phi>) 0 0 1) (blaschke_cmat k)))"
    using ***
    apply (rule_tac x=a' in exI)
    apply simp
    apply (rule_tac x=\<phi> in exI)
    apply simp
    apply (rule_tac x="1/k'" in exI)
    by auto
qed

lemma wlog_unit_disc_fix:
  assumes "unit_disc_fix M"
  assumes b: "\<And> k. cmod k < 1 \<Longrightarrow> P (blaschke k)"
  assumes r: "\<And> \<phi>. P (moebius_rotation \<phi>)"
  assumes comp: "\<And>M1 M2. \<lbrakk>unit_disc_fix M1; P M1; unit_disc_fix M2; P M2\<rbrakk> \<Longrightarrow> P (M1 + M2)"
  shows "P M"
  using assms
  using unit_disc_fix_decompose_blaschke_rotation[OF assms(1)]
  using blaschke_unit_disc_fix
  by auto


lemma ex_unit_disc_fix_to_zero_positive_x_axis:
  assumes "u \<in> unit_disc" "v \<in> unit_disc" "u \<noteq> v"
  shows "\<exists> M. unit_disc_fix M \<and>
              moebius_pt M u = 0\<^sub>h \<and> moebius_pt M v \<in> positive_x_axis"
proof-
  from assms obtain B where
    *: "unit_disc_fix B" "moebius_pt B u = 0\<^sub>h"
    using ex_unit_disc_fix_mapping_u_to_zero
    by blast

  let ?v = "moebius_pt B v"
  have "?v \<in> unit_disc"
    using `v \<in> unit_disc` *
    by auto
  hence "?v \<noteq> \<infinity>\<^sub>h"
    using inf_notin_unit_disc by auto
  have "?v \<noteq> 0\<^sub>h"
    using `u \<noteq> v` *
    by (metis moebius_pt_invert)

  obtain R where
    "unit_disc_fix R"
    "moebius_pt R 0\<^sub>h = 0\<^sub>h" "moebius_pt R ?v \<in> positive_x_axis"
    using ex_rotation_mapping_u_to_positive_x_axis[of ?v] `?v \<noteq> 0\<^sub>h` `?v \<noteq> \<infinity>\<^sub>h`
    using moebius_pt_rotation_inf_iff moebius_pt_moebius_rotation_zero unit_disc_fix_rotation
    by blast
  thus ?thesis
    using * moebius_comp[of R B, symmetric]
    using unit_disc_fix_moebius_comp
    by (rule_tac x="R + B" in exI) (simp add: comp_def)
qed

lemma wlog_x_axis:
  assumes in_disc: "u \<in> unit_disc" "v \<in> unit_disc"
  assumes preserved: "\<And> M u v. \<lbrakk>unit_disc_fix M; u \<in> unit_disc; v \<in> unit_disc; P (moebius_pt M u) (moebius_pt M v)\<rbrakk> \<Longrightarrow> P u v"
  assumes axis: "\<And> x. \<lbrakk>is_real x; 0 \<le> Re x;  Re x < 1\<rbrakk> \<Longrightarrow> P 0\<^sub>h (of_complex x)"
  shows "P u v"
proof (cases "u = v")
  case True
  have "P u u" (is "?Q u")
  proof (rule wlog_zero[where P="?Q"])
    show "u \<in> unit_disc"
      by fact
  next
    show "?Q 0\<^sub>h"
      using axis[of 0]
      by simp
  next
    fix a u
    assume "u \<in> unit_disc" "cmod a < 1" "?Q (moebius_pt (blaschke a) u)"
    thus "?Q u"
      using preserved[of "blaschke a" u u]
      using blaschke_unit_disc_fix[of a]
      by simp
  qed
  thus ?thesis
    using True
    by simp
next
  case False
  from in_disc obtain M where
    *: "unit_disc_fix M" "moebius_pt M u = 0\<^sub>h" "moebius_pt M v \<in> positive_x_axis"
    using ex_unit_disc_fix_to_zero_positive_x_axis False
    by auto
  then obtain x where **: "moebius_pt M v = of_complex x" "is_real x"
    unfolding positive_x_axis_def circline_set_x_axis
    by auto
  moreover
  have "of_complex x \<in> unit_disc"
    using `unit_disc_fix M` `v \<in> unit_disc` **
    using unit_disc_fix_discI
    by fastforce
  hence "0 < Re x" "Re x < 1"
    using `moebius_pt M v \<in> positive_x_axis` **
    by (auto simp add: positive_x_axis_def cmod_eq_Re)
  ultimately
  have "P 0\<^sub>h (of_complex x)"
    using `is_real x` axis
    by auto
  thus ?thesis
    using preserved[OF *(1) assms(1-2)] *(2) **(1)
    by simp
qed

lemma wlog_positive_x_axis:
  assumes in_disc: "u \<in> unit_disc" "v \<in> unit_disc" "u \<noteq> v"
  assumes preserved: "\<And> M u v. \<lbrakk>unit_disc_fix M; u \<in> unit_disc; v \<in> unit_disc; u \<noteq> v; P (moebius_pt M u) (moebius_pt M v)\<rbrakk> \<Longrightarrow> P u v"
  assumes axis: "\<And> x. \<lbrakk>is_real x; 0 < Re x;  Re x < 1\<rbrakk> \<Longrightarrow> P 0\<^sub>h (of_complex x)"
  shows "P u v"
proof-
  have "u \<noteq> v \<longrightarrow> P u v" (is "?Q u v")
  proof (rule wlog_x_axis)
    show "u \<in> unit_disc" "v \<in> unit_disc"
      by fact+
  next
    fix M u v
    assume "unit_disc_fix M" "u \<in> unit_disc" "v \<in> unit_disc"
           "?Q (moebius_pt M u) (moebius_pt M v)"
    thus "?Q u v"
      using preserved[of M u v]
      using moebius_pt_invert
      by blast
  next
    fix x
    assume "is_real x" "0 \<le> Re x" "Re x < 1"
    thus "?Q 0\<^sub>h (of_complex x)"
      using axis[of x] of_complex_zero_iff[of x] complex.expand[of x 0]
      by fastforce
  qed
  thus ?thesis
    using `u \<noteq> v`
    by simp
qed

subsection{* All unit disc fixing functions - could be either direct or indirect *}
(* Sum type could also be used *)

(* conjugation is not a moebius transform *)
lemma not_moebius_conjugate: 
  shows "\<not> (\<exists> M. moebius_pt M = conjugate)"
proof
  assume "\<exists> M. moebius_pt M = conjugate"
  then obtain M where *: "moebius_pt M = conjugate"
    by auto
  hence "moebius_pt M 0\<^sub>h = 0\<^sub>h" "moebius_pt M 1\<^sub>h = 1\<^sub>h" "moebius_pt M \<infinity>\<^sub>h = \<infinity>\<^sub>h"
    by auto
  hence "M = id_moebius"
    using three_fixed_points_01inf
    by auto
  hence "conjugate = id"
    using *
    by simp
  moreover
  have "conjugate ii\<^sub>h \<noteq> ii\<^sub>h"
    using of_complex_inj[of "\<i>" "-\<i>"]
    by (subst of_complex_ii[symmetric])+ (auto simp del: of_complex_ii)
  ultimately
  show False
    by simp
qed

definition unit_disc_fix_f where
  "unit_disc_fix_f f \<longleftrightarrow> (\<exists> M. unit_disc_fix M \<and> (f = moebius_pt M \<or> f = moebius_pt M \<circ> conjugate))"

lemma 
  assumes "unit_disc_fix_f f"
  shows "is_homography f \<or> is_antihomography f" 
  using assms
  unfolding unit_disc_fix_f_def is_homography_def is_antihomography_def is_moebius_def
  by auto

lemma unit_disc_fix_f_moebius_pt [simp]:
  assumes "unit_disc_fix M"
  shows "unit_disc_fix_f (moebius_pt M)"
  using assms
  unfolding unit_disc_fix_f_def
  by auto

lemma unit_disc_fix_conjugate_moebius [simp]:
  assumes "unit_disc_fix M"
  shows "unit_disc_fix (conjugate_moebius M)"
  using assms
  apply (transfer, transfer)
  apply (auto simp add: mat_cnj_def unitary11_gen_def mat_adj_def field_simps)
  apply (metis cnj.simps(1) complex_cnj_divide complex_cnj_mult)
  done

lemma [simp]:
  assumes "unit_disc_fix M"
  shows "unit_disc_fix_f (conjugate \<circ> moebius_pt M)"
  using assms
  apply (subst conjugate_moebius)
  apply (simp add: unit_disc_fix_f_def)
  apply (rule_tac x="conjugate_moebius M" in exI, simp)
  done

(* these transformations fix unit disc *)
lemma unit_disc_fix_f_unit_disc:
  assumes "unit_disc_fix_f M"
  shows "M ` unit_disc = unit_disc"
  using assms
  unfolding unit_disc_fix_f_def
  using image_comp
  by force

(* these transformations form a group *)

lemma unit_disc_fix_f_comp [simp]:
  assumes "unit_disc_fix_f f1" "unit_disc_fix_f f2"
  shows "unit_disc_fix_f (f1 \<circ> f2)"
  using assms
  apply (subst (asm) unit_disc_fix_f_def)
  apply (subst (asm) unit_disc_fix_f_def)
proof safe
  fix M M'
  assume "unit_disc_fix M" "unit_disc_fix M'"
  thus "unit_disc_fix_f (moebius_pt M \<circ> moebius_pt M')"
    unfolding unit_disc_fix_f_def
    by (rule_tac x="M + M'" in exI) auto
next
  fix M M'
  assume "unit_disc_fix M" "unit_disc_fix M'"
  thus "unit_disc_fix_f (moebius_pt M \<circ> (moebius_pt M' \<circ> conjugate))"
    unfolding unit_disc_fix_f_def
    by (subst comp_assoc[symmetric])+
       (rule_tac x="M + M'" in exI, auto)
next
  fix M M'
  assume "unit_disc_fix M" "unit_disc_fix M'"
  thus "unit_disc_fix_f ((moebius_pt M \<circ> conjugate) \<circ> moebius_pt M')"
    unfolding unit_disc_fix_f_def
    by (subst comp_assoc, subst conjugate_moebius, subst comp_assoc[symmetric])+
       (rule_tac x="M + conjugate_moebius M'" in exI, auto)
next
  fix M M'
  assume "unit_disc_fix M" "unit_disc_fix M'"
  thus "unit_disc_fix_f ((moebius_pt M \<circ> conjugate) \<circ> (moebius_pt M' \<circ> conjugate))"
    apply (subst comp_assoc[symmetric], subst comp_assoc)
    apply (subst conjugate_moebius, subst comp_assoc, subst comp_assoc)
    apply (simp add: unit_disc_fix_f_def)
    apply (rule_tac x="M + conjugate_moebius M'" in exI, auto)
    done
qed

lemma unit_disc_fix_f_inv:
  assumes "unit_disc_fix_f M"
  shows "unit_disc_fix_f (inv M)"
  using assms
  apply (subst (asm) unit_disc_fix_f_def)
proof safe
  fix M
  assume "unit_disc_fix M"
  have "inv (moebius_pt M) = moebius_pt (-M)"
    by (rule ext) (simp add: moebius_inv)
  thus "unit_disc_fix_f (inv (moebius_pt M))"
    using `unit_disc_fix M`
    unfolding unit_disc_fix_f_def
    by (rule_tac x="-M" in exI, simp)
next
  fix M
  assume "unit_disc_fix M"
  have "inv (moebius_pt M \<circ> conjugate) = conjugate \<circ> inv (moebius_pt M)"
    by (subst o_inv_distrib, simp_all)
  also have "... = conjugate \<circ> (moebius_pt (-M))"
    using moebius_inv
    by auto
  also have "... = moebius_pt (conjugate_moebius (-M)) \<circ> conjugate"
    by (simp add: conjugate_moebius)
  finally
  show "unit_disc_fix_f (inv (moebius_pt M \<circ> conjugate))"
    using `unit_disc_fix M`
    unfolding unit_disc_fix_f_def
    by (rule_tac x="conjugate_moebius (-M)" in exI, simp)
qed

(* Action on circlines *)

definition unit_disc_fix_f_circline where
  "unit_disc_fix_f_circline f H = 
      (if \<exists> M. unit_disc_fix M \<and> f = moebius_pt M then
          moebius_circline (THE M. unit_disc_fix M \<and> f = moebius_pt M) H
       else if \<exists> M. unit_disc_fix M \<and> f = moebius_pt M \<circ> conjugate then
          (moebius_circline (THE M. unit_disc_fix M \<and> f = moebius_pt M \<circ> conjugate) \<circ> conjugate_circline) H
       else
          H)"


lemma unique_moebius_pt:
  assumes "moebius_pt M1 = moebius_pt M2"
  shows "M1 = M2"
  using assms unique_moebius_three_points[of "0\<^sub>h" "1\<^sub>h" "\<infinity>\<^sub>h"]
  by auto

lemma unique_moebius_pt_conjugate:
  assumes "moebius_pt M1 \<circ> conjugate = moebius_pt M2 \<circ> conjugate"
  shows "M1 = M2"
proof-               
  from assms have "moebius_pt M1 = moebius_pt M2"
    using conjugate_conjugate_comp rewriteL_comp_comp2 by fastforce
  thus ?thesis
    using unique_moebius_pt
    by auto
qed

lemma unit_disc_fix_f_circline_direct:
  assumes "unit_disc_fix M" "f = moebius_pt M"
  shows "unit_disc_fix_f_circline f H = moebius_circline M H"
proof-
  have "M = (THE M. unit_disc_fix M \<and> f = moebius_pt M)"
    using assms
    using theI_unique[of "\<lambda> M. unit_disc_fix M \<and> f = moebius_pt M" M]
    using unique_moebius_pt[of M]
    by auto
  thus ?thesis
    using assms
    unfolding unit_disc_fix_f_circline_def
    by auto
qed

lemma unit_disc_fix_f_disjoint_sum:
  assumes "\<exists> M. f = moebius_pt M \<circ> conjugate"
  shows "\<not> (\<exists> M. f = moebius_pt M)"
proof
  assume "\<exists> M. f = moebius_pt M"
  then obtain M where "f = moebius_pt M"
    by auto
  then obtain M' where "moebius_pt M = moebius_pt M' \<circ> conjugate"
    using assms
    by auto
  hence "conjugate = moebius_pt (-M') \<circ> moebius_pt M"
    by auto
  hence "conjugate = moebius_pt (-M' + M)"
    by (simp add: moebius_comp)
  thus False
    using not_moebius_conjugate
    by metis
qed

lemma unit_disc_fix_f_circline_indirect:
  assumes "unit_disc_fix M" "f = moebius_pt M \<circ> conjugate"
  shows "unit_disc_fix_f_circline f H = ((moebius_circline M) \<circ> conjugate_circline) H"
proof-
  have "\<not> (\<exists> M. unit_disc_fix M \<and> f = moebius_pt M)"
    using assms unit_disc_fix_f_disjoint_sum
    by auto
  moreover
  have "M = (THE M. unit_disc_fix M \<and> f = moebius_pt M \<circ> conjugate)"
    using assms
    using theI_unique[of "\<lambda> M. unit_disc_fix M \<and> f = moebius_pt M \<circ> conjugate" M]
    using unique_moebius_pt_conjugate[of M] 
    by auto
  ultimately
  show ?thesis
    using assms
    unfolding unit_disc_fix_f_circline_def
    by metis
qed

text{* Disc automorphisms - not developed *}

definition is_disc_aut where "is_disc_aut f \<longleftrightarrow> bij_betw f unit_disc unit_disc"

lemma is_disc_aut_iff_unit_disc_fix:
  shows "is_disc_aut (moebius_pt M) \<longleftrightarrow> (moebius_pt M) ` unit_disc = unit_disc"
  using bij_moebius_pt[of M]
  unfolding is_disc_aut_def is_moebius_def
  unfolding bij_betw_def
  by auto (metis injD inj_onI)

end