lemma 
  assumes "transition stateA stateB F0 decisionVars"
  shows "transition (remdups_state stateA) (remdups_state stateB) (remdups (map remdups F0)) decisionVars"
proof-
  let ?stateA' = "remdups_state stateA"
  let ?stateB' = "remdups_state stateB"
  let ?F0' = "remdups (map remdups F0)"

  {
    assume "appliedDecide stateA stateB F0 decisionVars"
    hence 
      "\<not> (\<exists>uc. CNF.member uc (F0 @ getFl stateA) \<and> (\<exists>ul. isUnitClause uc ul (elements (getM stateA))))"
      unfolding appliedDecide_def
      by auto
    have "\<not> (\<exists>uc. uc el (?F0' @ getFl ?stateA') \<and> (\<exists>ul. isUnitClause uc ul (elements (getM ?stateA'))))"
    proof (rule ccontr)
      assume "\<not> ?thesis"
      then obtain uc ul where "uc el (?F0' @ getFl ?stateA')" "isUnitClause uc ul (elements (getM ?stateA'))"
	by auto
      then obtain uc' where "uc = remdups uc'" "uc' el F0 @ getFl stateA" "isUnitClause uc ul (elements (getM stateA))"
	unfolding remdups_state_def
	by auto
      hence "uc' el F0 @ getFl stateA" "isUnitClause uc' ul (elements (getM stateA))"
	unfolding isUnitClause_def
	by auto
      thus False
	using `\<not> (\<exists>uc. CNF.member uc (F0 @ getFl stateA) \<and> (\<exists>ul. isUnitClause uc ul (elements (getM stateA))))`
	by auto
    qed
    hence "appliedDecide ?stateA' ?stateB' ?F0' decisionVars"
      using `appliedDecide stateA stateB F0 decisionVars`
      unfolding appliedDecide_def
      unfolding remdups_state_def
      by auto
  }
  moreover
  {
    assume "appliedUnitPropagate stateA stateB F0 decisionVars"
      then obtain uc ul where "uc el (F0 @ getFl stateA)" 
	"isUnitClause uc ul (elements (getM stateA))" "getM stateB = getM stateA @ [(ul, False)]"
      unfolding appliedUnitPropagate_def
      by auto
    then obtain uc' where "uc' = remdups uc" "uc' el (?F0' @ getFl ?stateA')"
      "isUnitClause uc ul (elements (getM ?stateA'))" "getM ?stateB' = getM ?stateA' @ [(ul, False)]"
      unfolding remdups_state_def
      unfolding isUnitClause_def
      by auto
    hence "isUnitClause uc' ul (elements (getM ?stateA'))" "uc' el (?F0' @ getFl ?stateA')"  "getM ?stateB' = getM ?stateA' @ [(ul, False)]"
      unfolding isUnitClause_def
      by auto
    hence "appliedUnitPropagate ?stateA' ?stateB' ?F0' decisionVars"
      using `appliedUnitPropagate stateA stateB F0 decisionVars`
      unfolding appliedUnitPropagate_def
      unfolding remdups_state_def
      apply (rule_tac x="uc'" in exI)
      apply (rule_tac x="ul" in exI)
      by auto
  }
  moreover
  {
    assume "appliedConflict stateA stateB F0"
    then obtain clause 
      where "clause el (F0 @ getFl stateA)"
      "clauseFalse clause (elements (getM stateA))" "getC stateB = clause"
      unfolding appliedConflict_def
      by auto
    then obtain clause' where "clause' = remdups clause" "clause' el (?F0' @ getFl ?stateA')"
      "clauseFalse clause (elements (getM ?stateA'))" "getC ?stateB' = clause'"
      unfolding remdups_state_def
      by auto
    hence "clause' el (?F0' @ getFl ?stateA')"  "clauseFalse clause' (elements (getM ?stateA'))" "getC ?stateB' = clause'"
      unfolding clauseFalseIffAllLiteralsAreFalse
      by auto
    hence "appliedConflict ?stateA' ?stateB' ?F0'"
      using `appliedConflict stateA stateB F0`
      unfolding appliedConflict_def
      unfolding remdups_state_def
      apply (rule_tac x="clause'" in exI)
      by auto
  }
  moreover
  {
    assume "appliedExplain stateA stateB F0"
    then obtain l reason where
      "l el (getC stateA)"
      "reason el (F0 @ getFl stateA)"
      "isReason reason (opposite l) (elements (getM stateA))"
      "getC stateB = resolve (getC stateA) reason l"
      unfolding appliedExplain_def
      by auto
    then obtain reason' 
      where "l el (getC ?stateA')"
      "reason' = remdups reason"
      "reason' el (?F0' @ getFl ?stateA')"
      "isReason reason (opposite l) (elements (getM ?stateA'))"
      "getC ?stateB' = resolve (getC ?stateA') reason' l"
      unfolding remdups_state_def
      apply auto

      

    hence "appliedExplain ?stateA' ?stateB' ?F0'"
      unfolding appliedExplain_def
  }
  ultimately
  show ?thesis
    unfolding transition_def
    apply auto
qed

lemma InvariantImpliedLiteralsAfterForgetMultiple: 
  fixes F :: Formula and F' :: Formula and M :: LiteralTrail and C :: Clause
  assumes "InvariantImpliedLiterals (F0 @ F) M" and
  "F' = list_diff F Fc"
  "\<forall> C \<in> set Fc. (formulaEntailsClause F0 C)"
  shows "InvariantImpliedLiterals (F0 @ F') M"
using assms
proof (induct Fc arbitrary: F')
  case Nil
  thus ?case
    by simp
next
  case (Cons C Fc')
  show ?case
  proof-
    have "InvariantImpliedLiterals (F0 @ (list_diff F Fc')) M"
      using Cons(1)[of "list_diff F Fc'"]
      using Cons(2) Cons(3) Cons(4)
      by simp
    thus ?thesis
      using Cons(3) Cons(4)
      using InvariantImpliedLiteralsAfterForget'[of "F0 @ list_diff F Fc'" "M" "C" "F0 @ F'"]
      by simp
  qed
qed


lemma formulaEntailsClauseListDiffTail:
  assumes "\<forall>c\<in>set (C # Fc'). formulaEntailsClause (list_diff F (C # Fc')) c"
  shows "\<forall>c\<in>set Fc'. formulaEntailsClause (list_diff F Fc') c"
proof-
  {
    fix c
    assume "c \<in> set Fc'"
    hence "formulaEntailsClause (list_diff F (C # Fc')) c"
      using `\<forall>c\<in>set (C # Fc'). formulaEntailsClause (list_diff F (C # Fc')) c`
      by simp
    moreover
    have "set (list_diff (removeAll C F) Fc') \<subseteq> set (list_diff F Fc')"
    proof
      fix c
      assume "c \<in> set (list_diff (removeAll C F) Fc')"
      hence "c \<in> set (removeAll C F)" "c \<notin> set Fc'"
	using listDiffIff[of "c" "removeAll C F" "Fc'"]
	by auto
      hence "c \<in> set F" "c \<notin> set Fc'"
	by auto
      thus "c \<in> set (list_diff F Fc')"
	using listDiffIff[of "c" "F" "Fc'"]
	by simp
    qed
    ultimately
    have "formulaEntailsClause (list_diff F Fc') c"
      using formulaEntailsClauseSubset[of "list_diff (removeAll C F) Fc'" c "list_diff F Fc'"]
      by auto
  }
  thus ?thesis
    by simp
qed


lemma InvariantImpliedLiteralsAfterForgetMultiple: 
  fixes F :: Formula and F' :: Formula and M :: LiteralTrail and C :: Clause
  assumes "InvariantImpliedLiterals F M" and
  "F' = list_diff F Fc"
  "\<forall> C \<in> set Fc. (formulaEntailsClause F' C)"
  shows "InvariantImpliedLiterals F' M"
using assms
proof (induct Fc arbitrary: F')
  case Nil
  thus ?case
    by simp
next
  case (Cons C Fc')
  show ?case
  proof-
    have "\<forall>c\<in>set Fc'. formulaEntailsClause (list_diff F Fc') c"
      using `\<forall>c\<in>set (C # Fc'). formulaEntailsClause F' c`
      using `F' = list_diff F (C # Fc')`
      using formulaEntailsClauseListDiffTail[of "C" "Fc'" "F"]
      by simp
    hence "InvariantImpliedLiterals (list_diff F Fc') M"
      using Cons(1)[of "list_diff F Fc'"]
      using Cons(2) Cons(3)
      by simp
    thus ?thesis
      using Cons(4)
      using InvariantImpliedLiteralsAfterForget[of "list_diff F Fc'" "M" "C" "F'"]
      using Cons(3)
      by simp
  qed
qed


lemma InvariantEquivalentAfterForgetMultiple: 
  fixes F0 :: Formula and F :: Formula and F' :: Formula and C :: Clause
  assumes "InvariantEquivalent F0 F" and 
  "F' = list_diff F Fc"
  "\<forall> C \<in> set Fc. (formulaEntailsClause F' C)"
  shows "InvariantEquivalent F0 F'"
using assms
proof (induct Fc arbitrary: F')
  case Nil
  thus ?case
    by simp
next
  case (Cons C Fc')
  show ?case
  proof-
    have "\<forall>c\<in>set Fc'. formulaEntailsClause (list_diff F Fc') c"
      using `\<forall>c\<in>set (C # Fc'). formulaEntailsClause F' c`
      using `F' = list_diff F (C # Fc')`
      using formulaEntailsClauseListDiffTail[of "C" "Fc'" "F"]
      by simp
    hence "InvariantEquivalent F0 (list_diff F Fc')"
      using Cons(1)[of "list_diff F Fc'"]
      using Cons(2) Cons(3)
      by simp
    thus ?thesis
      using Cons(3) Cons(4)
      using InvariantEquivalentAfterForget[of "F0" "list_diff F Fc'" "C" "F'"]
      by simp
  qed
qed
  

lemma InvariantCEntailedAfterForgetMultiple:
  fixes F0 :: Formula and F :: Formula and F' :: Formula and c :: Clause 
  assumes "InvariantCEntailed conflictFlag F c" and
  "F' = list_diff F Fc"
  "\<forall> c \<in> set Fc. (formulaEntailsClause F' c)"
  shows "InvariantCEntailed conflictFlag F' c"
using assms
proof (induct Fc arbitrary: F')
  case Nil 
  thus ?case
    by simp
next
  case (Cons C Fc')
  show ?case
  proof-
    have "\<forall>c\<in>set Fc'. formulaEntailsClause (list_diff F Fc') c"
      using `\<forall>c\<in>set (C # Fc'). formulaEntailsClause F' c`
      using `F' = list_diff F (C # Fc')`
      using formulaEntailsClauseListDiffTail[of "C" "Fc'" "F"]
      by simp
    hence "InvariantCEntailed conflictFlag (list_diff F Fc') c"
      using Cons(1)[of "list_diff F Fc'"]
      using Cons(2) Cons(3)
      by simp
    thus ?thesis
      using Cons(3) Cons(4)
      using InvariantCEntailedAfterForget[of "conflictFlag" "list_diff F Fc'" "c" "C" "F'"]
      by simp
  qed
qed


lemma formulaIsDecreasedByLearn:
  fixes stateA::State and stateB::State
  assumes "appliedBackjumpAndLearn stateA stateB"
  "invariantsHoldInState stateA F0 decisionVars"
  shows 
  "getM stateA = getM stateB" and 
  "getConflictFlag stateA = getConflictFlag stateB" and 
  "getC stateA = getC stateB" and 
  "(getF stateB, getF stateA) \<in> formulaInclusionLess (decisionVars \<union> vars F0)"
proof-
  from `appliedLearn stateA stateB`
  have
      "getConflictFlag stateA = True"
      "\<not> remdups (getC stateA) el map remdups (getF stateA)"
      "getF stateB = getF stateA @ [getC stateA]"
      "getM stateB = getM stateA"
      "getConflictFlag stateB = True"
      "getC stateB = getC stateA"
    unfolding appliedLearn_def
    by auto
  moreover
  have "vars (getF stateA) \<subseteq> decisionVars \<union> vars F0"
    sorry
  hence "vars (map remdups (getF stateA)) \<subseteq> decisionVars \<union> vars F0"
    apply (induct "getF stateA")
    apply (auto simp add: varsClauseVarsSet)
  hence "vars (remdups (map remdups (getF stateA))) \<subseteq> decisionVars \<union> vars F0"
    sorry
  moreover
  have "vars (getF stateB) \<subseteq> decisionVars \<union> vars F0"
    sorry
  hence "vars (remdups (map remdups (getF stateB))) \<subseteq> decisionVars \<union> vars F0"
    sorry
  ultimately
  show
    "getM stateA = getM stateB"
    "getConflictFlag stateA = getConflictFlag stateB"
    "getC stateA = getC stateB"
    "(getF stateB, getF stateA) \<in> formulaLess (decisionVars \<union> vars F0)"
    unfolding formulaLess_def
    unfolding formulaLessRestricted_def
    by (auto simp add: uniqRemdups)
qed

lemma clausesAddedToFAreLearnt:
  assumes 
  "(stateA, stateB) \<in> transitionRelation F0 decisionVars"
  "\<not> c el (getFl stateA)" "c el (getFl stateB)"
  shows 
  "\<exists> stateC stateC'. (stateA, stateC) \<in> transitionRelation F0 decisionVars \<and> 
             (getC stateC = c) \<and>
             (appliedBackjumpAndLearn stateC stateC') \<and> 
             (stateC', stateB) \<in> transitionRelation F0 decisionVars"
using assms
unfolding transitionRelation_def
proof (induct rule: rtrancl_induct)
  case base
  thus ?case
    by simp
next
  case (step stateB' stateB)
  thus ?case
  proof (cases "appliedBackjumpAndLearn stateB' stateB \<and> getC stateB' = c")
    case True
    thus ?thesis
      using `(stateA, stateB') \<in> {(stateA, stateB). transition stateA stateB F0 decisionVars}\<^sup>*`
      by auto
  next
    case False
    have "c el (getFl stateB')"
    proof (cases "appliedBackjumpAndLearn stateB' stateB")
      case False
      thus ?thesis
	using `c el (getFl stateB)`
	using `(stateB', stateB) \<in> {(stateA, stateB). transition stateA stateB F0 decisionVars}`
	unfolding transition_def
	unfolding appliedDecide_def
	unfolding appliedUnitPropagate_def
	unfolding appliedConflict_def
	unfolding appliedExplain_def
	unfolding appliedForget_def
	unfolding appliedRestart_def
	by auto
    next
      case True
      with `\<not> (appliedBackjumpAndLearn stateB' stateB \<and> getC stateB' = c)`
      have "getC stateB' \<noteq> c"
	by simp
      thus ?thesis
	using True
	using `c el (getFl stateB)`
	unfolding appliedBackjumpAndLearn_def
	by auto
    qed
    with `\<not> c el (getFl stateA)`
    obtain stateC stateC' 
      where "(stateA, stateC) \<in> transitionRelation F0 decisionVars"
      "getC stateC = c" "appliedBackjumpAndLearn stateC stateC'" 
      "(stateC', stateB') \<in> transitionRelation F0 decisionVars"
      using step(3)
      unfolding transitionRelation_def
      by auto
    moreover
    have "(stateC', stateB) \<in> transitionRelation F0 decisionVars"
      using `(stateC', stateB') \<in> transitionRelation F0 decisionVars`
      using `(stateB', stateB) \<in> {(stateA, stateB). transition stateA stateB F0 decisionVars}`
      unfolding transitionRelation_def
      using rtrancl_into_rtrancl[of "stateC'" "stateB'" _ "stateB"]
      by auto
    ultimately
    show ?thesis
      unfolding transitionRelation_def
      by auto
  qed
qed

lemma currentLevelOfListIncreasedAppliedDecide:
  assumes 
  "l \<noteq> []" "hd l = stateA" "last l = stateB" 
  "isTransitionList l F0 decisionVars"
  "currentLevel (getM stateA) < currentLevel (getM stateB)"
  shows
  "\<exists> m < length l - 1. appliedDecide (l ! m) (l ! (m + 1)) F0 decisionVars"
using assms
proof (induct l arbitrary: stateA)
  case Nil
  thus ?case
    by simp
next
  case (Cons state l')
  hence "l' \<noteq> []"
    using `hd (state # l') = stateA` `last (state # l') = stateB`
    using `currentLevel (getM stateA) < currentLevel (getM stateB)`
    by auto

  hence "transition stateA (hd l') F0 decisionVars"
    "isTransitionList l' F0 decisionVars"
    using `isTransitionList (state # l') F0 decisionVars`
    using `hd (state # l') = stateA`
    using sublistElementRelations[of "state # l'" "[state]" "l'" "[]" "\<lambda> x y. transition x y F0 decisionVars"]
    by auto

  show ?case
  proof (cases "currentLevel (getM (hd l')) < currentLevel (getM stateB)")
    case False
    hence "currentLevel (getM stateA) < currentLevel (getM (hd l'))"
      using `currentLevel (getM (stateA)) < currentLevel (getM stateB)`
      by simp
    hence "appliedDecide stateA (hd l') F0 decisionVars"
      using `transition stateA (hd l') F0 decisionVars`
      using onlyDecideIncreasesLevel[of "stateA" "hd l'" "F0" "decisionVars"]
      by simp
    thus ?thesis
      using `hd (state # l') = stateA`
      using `l' \<noteq> []`
      by (auto simp add: hd_conv_nth)
  next
    case True
    with Cons(1)[of "hd l'"] 
      `isTransitionList l' F0 decisionVars`
    obtain m where 
      "m<length l' - 1" "appliedDecide (l' ! m) (l' ! (m + 1)) F0 decisionVars"
      using `l' \<noteq> []`
      using `last (state # l') = stateB`
      by auto
    hence "m + 1 <length (state # l') - 1" 
      "appliedDecide ((state # l') ! (m + 1)) ((state # l') ! (m + 2)) F0 decisionVars"
      using `l' \<noteq> []`
      by auto
    thus ?thesis
      by auto
  qed
qed
