theory LinearPolyMaps
imports AbstractLinearPoly
  "~~/src/HOL/Library/Mapping" 

begin

(* ************************************************************************** *)
(* Move to Mapping.thy                                                        *)
(* ************************************************************************** *)

lemma sorted_list_of_set_empty [simp]: 
  "finite x \<Longrightarrow> [] = sorted_list_of_set x \<longleftrightarrow> x = {}"
using sorted_list_of_set[of x]
using set_empty[THEN sym, of "sorted_list_of_set x"]
by auto

lemma Mapping_ordered_keys_empty:
  assumes "finite (Mapping.keys lp)" 
  shows "[] = Mapping.ordered_keys lp \<longleftrightarrow> lp = Mapping.empty"
using assms
using sorted_list_of_set_empty[of "Mapping.keys lp"]
unfolding Mapping.keys_def Mapping.ordered_keys_def
by (auto simp add: Mapping.empty_def mapping_eqI)


(* ************************************************************************** *)
(* Executable implementation                                                  *)
(* ************************************************************************** *)

definition get_var_coeff :: "(var, rat) mapping \<Rightarrow> var \<Rightarrow> rat" where
  "get_var_coeff lp v == 
      case Mapping.lookup lp v of None \<Rightarrow> 0 | Some c \<Rightarrow> c"

definition set_var_coeff :: "var \<Rightarrow> rat \<Rightarrow> (var, rat) mapping \<Rightarrow> (var, rat) mapping" where
  "set_var_coeff v c lp == 
      if c = 0 then Mapping.delete v lp else Mapping.update v c lp"

definition var_coeff_map :: "(var \<Rightarrow> rat) \<Rightarrow> (var, rat) mapping" where
  "var_coeff_map lp == 
      Mapping.Mapping (\<lambda> v. if lp v \<noteq> 0 then Some (lp v) else None)"

definition LinearPoly :: "(var, rat) mapping \<Rightarrow> linear_poly" where
 [code del]: "LinearPoly m = Abs_linear_poly (get_var_coeff m)"

definition linear_poly_map :: "linear_poly \<Rightarrow> (var, rat) mapping" where
 "linear_poly_map lp = var_coeff_map (Rep_linear_poly lp)"

lemma certificate[code abstype]: 
  "LinearPoly (linear_poly_map lp) = lp" 
unfolding linear_poly_map_def LinearPoly_def
by (cases lp) (auto simp add: Abs_linear_poly_inverse Abs_linear_poly_inject fun_eq_iff var_coeff_map_def get_var_coeff_def)


text{* Zero *}
definition zero :: "(var, rat) mapping" where "zero = Mapping.empty"

lemma [code abstract]: 
"linear_poly_map 0 = zero"
unfolding linear_poly_map_def var_coeff_map_def zero_linear_poly_def zero_def
by (simp add: Abs_linear_poly_inverse Mapping.empty_def)

text{* Addition *}

definition add_monom :: "rat \<Rightarrow> var \<Rightarrow> (var, rat) mapping \<Rightarrow> (var, rat) mapping" where
  "add_monom c v lp == set_var_coeff v (c + get_var_coeff lp v) lp"

definition add :: "(var, rat) mapping \<Rightarrow> (var, rat) mapping \<Rightarrow> (var, rat) mapping" where
  "add lp1 lp2 = foldl (\<lambda> lp v. add_monom (get_var_coeff lp1 v) v lp) lp2 (Mapping.ordered_keys lp1)"

lemma lookup_add_monom:
"get_var_coeff lp v + c \<noteq> 0 \<Longrightarrow> 
    Mapping.lookup (add_monom c v lp) v = Some (get_var_coeff lp v + c)"
"get_var_coeff lp v + c = 0 \<Longrightarrow> 
    Mapping.lookup (add_monom c v lp) v = None"
"x \<noteq> v \<Longrightarrow> Mapping.lookup (add_monom c v lp) x = Mapping.lookup lp x"
unfolding add_monom_def get_var_coeff_def set_var_coeff_def
by auto

lemma plus_lemmaSome:
  assumes
  "finite P1" 
  "l = sorted_list_of_set P1" "p1 x + p2 x \<noteq> 0"
  shows "Mapping.lookup
            (foldl
              (\<lambda>lp v. add_monom (p1 v) v lp)
              (Mapping.Mapping (\<lambda>v. if  p2 v \<noteq> 0 then Some (p2 v) else None))
              l
            )
            x = (if x \<in> set l then Some (p1 x + p2 x) else
                    if p2 x \<noteq> 0 then Some (p2 x) else None)"(is "?T l")
using assms
proof (induct l arbitrary: P1 rule: rev_induct)
  case Nil
  thus ?case
    using sorted_list_of_set[of P1]
    by simp
next
  case (snoc v l')
  have "distinct (l' @ [v])"
    using snoc(2) snoc(3)
    using sorted_list_of_set
    by auto
  hence "v \<notin> set l'"
    by simp
  let ?P1' = "P1 - {v}"
  have "l' = sorted_list_of_set ?P1'"
    using snoc(2) snoc(3)[THEN sym] `v \<notin> set l'`
    using sorted_list_of_set_remove[of P1 v]
    by (auto simp add: remove1_append)
  moreover
  have "?P1' \<subseteq> P1"
    by auto
  moreover
  have "finite ?P1'"
    using snoc(2)
    by simp
  ultimately have *: "?T l'"
    using snoc by simp

  show ?case
  proof (cases "x \<in> set (l' @ [v])")
    case True
    show ?thesis
      using `x \<in> set (l' @ [v])`
      using * `v \<notin> set l'` snoc(4)
      by (cases "x = v") (auto simp add: lookup_add_monom get_var_coeff_def)
  next
    case False
    thus ?thesis
      using *
      by (auto simp add: lookup_add_monom)
  qed
qed

lemma plus_lemmaNone:
  assumes
  "finite P1" 
  "l = sorted_list_of_set P1" "p1 x + p2 x = 0"
  shows "Mapping.lookup
            (foldl
              (\<lambda>lp v. add_monom (p1 v) v lp)
              (Mapping.Mapping (\<lambda>v. if  p2 v \<noteq> 0 then Some (p2 v) else None))
              l
            )
            x = (if x \<in> set l then None else
                    if p2 x \<noteq> 0 then Some (p2 x) else None)"(is "?T l")
using assms
proof (induct l arbitrary: P1 rule: rev_induct)
  case Nil
  thus ?case
    using sorted_list_of_set[of P1]
    by simp
next
  case (snoc v l')
  have "distinct (l' @ [v])"
    using snoc(2) snoc(3)
    using sorted_list_of_set
    by auto
  hence "v \<notin> set l'"
    by simp
  let ?P1' = "P1 - {v}"
  have "l' = sorted_list_of_set ?P1'"
    using snoc(2) snoc(3)[THEN sym] `v \<notin> set l'`
    using sorted_list_of_set_remove[of P1 v]
    by (auto simp add: remove1_append)
  moreover
  have "?P1' \<subseteq> P1"
    by auto
  moreover
  have "finite ?P1'"
    using snoc(2)
    by simp
  ultimately have *: "?T l'"
    using snoc by simp

  show ?case
  proof (cases "x \<in> set (l' @ [v])")
    case True
    show ?thesis
      using `x \<in> set (l' @ [v])`
      using * `v \<notin> set l'` snoc(4)
      by (cases "x = v") (auto simp add: lookup_add_monom get_var_coeff_def)
  next
    case False
    thus ?thesis
      using *
      by (auto simp add: lookup_add_monom)
  qed
qed

lemma [code abstract]:
  "linear_poly_map (p1 + p2) = add (linear_poly_map p1) (linear_poly_map p2)"
proof-
  have "inv (fun_plus (Rep_linear_poly p1) (Rep_linear_poly p2))"
    using Rep_linear_poly
    by - (rule inv_fun_plus, simp_all)
  thus ?thesis
    unfolding linear_poly_map_def var_coeff_map_def
    apply (auto intro!: mapping_eqI simp add: Abs_linear_poly_inverse plus_linear_poly_def fun_eq_iff add_def Mapping.ordered_keys_def Mapping.keys_def dom_def get_var_coeff_def plus_lemmaNone plus_lemmaSome)
    using Rep_linear_poly
    by simp+
qed

text{* Scaling *}
definition scale :: "rat \<Rightarrow> (var, rat) mapping \<Rightarrow> (var, rat) mapping" where
  "scale r lp = 
    foldl (\<lambda> lp' v. set_var_coeff v (r*(get_var_coeff lp v)) lp') 
          zero 
          (Mapping.ordered_keys lp)"

lemma scale_Some:
assumes "finite (Mapping.keys lp)" "l = Mapping.ordered_keys lp" "r \<noteq> 0" "get_var_coeff lp v \<noteq> 0" 
shows "Mapping.lookup
          (foldl (\<lambda>lp' v. set_var_coeff v (r * get_var_coeff lp v) lp') Mapping.empty l) v =
       Some (r * get_var_coeff lp v)" (is "?P lp l")
using assms
proof (induct l arbitrary: lp rule: rev_induct)
  case Nil
  thus ?case
    using Mapping_ordered_keys_empty[of lp]
    by (simp add: get_var_coeff_def)
next
  case (snoc v' l')
  show ?case
  proof (cases "v' = v")
    case True
    thus ?thesis
      using snoc(4) snoc(5)
      by (simp add: set_var_coeff_def)
  next
    case False
  
    have "distinct (l' @ [v'])"
      using snoc(2) snoc(3)
      using sorted_list_of_set
      by simp

    hence "v' \<notin> set l'"
      by simp

    hence "l' = Mapping.ordered_keys (Mapping.delete v' lp)"
      using snoc(2) snoc(3)[THEN sym]
      unfolding Mapping.ordered_keys_def
      using sorted_list_of_set_remove[of "Mapping.keys lp" v']
      by (simp add: remove1_append)
      
    hence "?P (Mapping.delete v' lp) l'"
      apply (subst snoc(1))
      using snoc(2) snoc(3) snoc(4) snoc(5) False
      by (simp_all add: get_var_coeff_def)
    moreover
    have "foldl (\<lambda>lp' v. set_var_coeff v (r * get_var_coeff (Mapping.delete v' lp) v) lp') Mapping.empty l' = 
          foldl (\<lambda>lp' v. set_var_coeff v (r * get_var_coeff lp v) lp') Mapping.empty l'"
      by (rule foldl_cong) (auto simp add: get_var_coeff_def `v' \<notin> set l'`)
    ultimately
    show ?thesis
      using snoc(4) snoc(5)
      by (auto simp add: set_var_coeff_def get_var_coeff_def)
  qed
qed


lemma lookupScale:
  assumes "finite (Mapping.keys lp)"
  shows "Mapping.lookup (scale r lp) v = 
            (if r = 0 \<or> get_var_coeff lp v = 0 then None else Some (r*get_var_coeff lp v))"
unfolding scale_def zero_def
apply auto
apply (rule foldl_weak_invariant, (simp add: set_var_coeff_def)+)
apply (rule foldl_weak_invariant, auto)
using assms
by (subst scale_Some, simp+)

lemma [code abstract]: 
  "linear_poly_map (r *R p) = scale r (linear_poly_map p)"
apply (auto intro!: mapping_eqI simp add: fun_eq_iff)
using  Rep_linear_poly[of p]
using Abs_linear_poly_inverse[of "\<lambda>v. r * Rep_linear_poly p v"]
by (auto simp add: lookupScale get_var_coeff_def linear_poly_map_def var_coeff_map_def scaleRat_linear_poly_def Mapping.keys_def dom_def)


text{* Coeff *}
lemma [code]:
  "coeff lp = get_var_coeff (linear_poly_map lp)"
by (simp add: fun_eq_iff coeff_def get_var_coeff_def linear_poly_map_def var_coeff_map_def)

text{* Var *}
lemma [code abstract]:
"linear_poly_map (Var x) = set_var_coeff x 1 (Mapping.empty)"
proof (auto intro!: mapping_eqI simp add: fun_eq_iff)
  fix x'
  show "Mapping.lookup (linear_poly_map (Var x)) x' =
        Mapping.lookup (set_var_coeff x 1 Mapping.empty) x'"
    unfolding linear_poly_map_def var_coeff_map_def set_var_coeff_def Var_def
    using Abs_linear_poly_inverse[of "fun_var x"]
    by simp
qed

text{* vars *}
lemma [code]: "vars lp = Mapping.keys (linear_poly_map lp)"
unfolding vars_def linear_poly_map_def var_coeff_map_def Mapping.keys_def
by auto

text{* vars list *}
lemma [code]: "vars_list lp = Mapping.ordered_keys (linear_poly_map lp)"
using Rep_linear_poly[of lp]
unfolding vars_list_def linear_poly_map_def var_coeff_map_def Mapping.ordered_keys_def Mapping.keys_def dom_def
by auto

text{* valuate *}
lemma[code]:  "valuate lp val \<equiv> 
  let lpm = linear_poly_map lp 
  in listsum (map (\<lambda> x. (the (Mapping.lookup lpm x)) *R (val x)) (vars_list lp))"
unfolding Let_def
proof (subst listsum_distinct_conv_setsum_set)
  show "distinct (vars_list lp)"
    unfolding vars_list_def
    using sorted_list_of_set
    using Rep_linear_poly
    by auto
next
  show "lp \<lbrace> val \<rbrace> \<equiv>
        \<Sum>x\<in>set (vars_list lp). the (Mapping.lookup (linear_poly_map lp) x) *R val x"
    using set_vars_list
    by (simp add: linear_poly_map_def var_coeff_map_def vars_def valuate_def)
qed


end