#!/usr/bin/python
import random
import sys

if (len(sys.argv) != 3):
    print "USAGE: generate_test.py number_of_variables number_of_constraints"
    exit()

number_of_variables = int(sys.argv[1])
number_of_constraints = int(sys.argv[2])

def generate_linear_poly():
    result1 = " ( "
    result = " ["
    for j in range(number_of_variables):
        coeff = random.randint(-100, 100)
        result += str(coeff)
        if (j != number_of_variables - 1):
            result += ", "

        result1 += ("(" + str(coeff) + "*R(" + "Var " + str(j) + "))").center(16)
        if (j != number_of_variables - 1):
            result1 += " + "
    result += "]"
    result1 += " )"
    return result, result1

constraints = []
constraints1 = []
# generation of number_of_constraints constraints
for i in range(number_of_constraints):
    poly, poly1 = generate_linear_poly()
    rat = random.randint(-100, 100)
    constraint = "j" + str(i) + "= " + "Atom (Less "
    constraint += str(rat) + " "
    constraint += poly
    constraint += ");\n"
    constraints.append(constraint)
    
    constraint1 = "GT" + poly1 + " " + str(rat)
    constraints1.append(constraint1)
        
        
# printing constraints
def nipkowf():
    nipkow = "definition \"fml_" + str(number_of_variables) + "_" + str(number_of_constraints) + " == let \n"
    for i in range(len(constraints)):
        nipkow += " " + constraints[i]

    nipkow += " f = list_conj ["
    for i in range(len(constraints)):
        nipkow += "j" + str(i)
        if (i != len(constraints)-1):
            nipkow += ", "
    nipkow += "];\n"
    nipkow += " f' = foldl (\<lambda> f a. (ExQ f)) f [1..<" + str(number_of_variables+1) + "] in\n      f'\"\n"
    return nipkow

def simplex():
    res = "definition \"fml_" + str(number_of_variables) + "_" + str(number_of_constraints) + " == [ \n"
    for i in range(len(constraints1)):
        res += " " + constraints1[i]
        if (i == len(constraints1) - 1):
            res += "\n"
            break
        res += ", \n"
    res += "]\"\n\n"
    return res

print simplex()
print >> sys.stderr, nipkowf()
