section \<open>Applying permutations to define equivalent objects and canonical objects\<close>

theory Canon_Least_Perm
  imports Main "HOL-Library.Permutation" 
          Combinatorics More_Relation
begin

locale EquivExPerm = 
  fixes invar :: "nat \<Rightarrow> 'a \<Rightarrow> bool"
  fixes permute :: "nat \<Rightarrow> nat list \<Rightarrow> 'a \<Rightarrow> 'a"
  assumes permute_invar: "\<And> a p n. \<lbrakk>invar n a; p <~~> [0..<n]\<rbrakk> \<Longrightarrow> invar n (permute n p a)"
  assumes permute_comp: "\<And> a p1 p2 n. \<lbrakk>invar n a; p1 <~~> [0..<n]; p2 <~~> [0..<n]\<rbrakk> \<Longrightarrow> 
      (\<exists> p. p <~~> [0..<n] \<and> permute n p a = permute n p1 (permute n p2 a))"
  assumes permute_inv: "\<And> a p n. \<lbrakk>invar n a; p <~~> [0..<n]\<rbrakk> \<Longrightarrow> 
      (\<exists> p'. p' <~~> [0..<n] \<and> permute n p' (permute n p a) = a)"
  assumes permute_id: "\<And> a n. invar n a \<Longrightarrow>
      permute n (perm_id n) a = a"

locale EquivExPerm1 = 
  fixes invar :: "nat \<Rightarrow> 'a \<Rightarrow> bool"
  fixes permute :: "nat \<Rightarrow> nat list \<Rightarrow> 'a \<Rightarrow> 'a"
  assumes permute_invar: "\<And> a p n. \<lbrakk>invar n a; p <~~> [0..<n]\<rbrakk> \<Longrightarrow> invar n (permute n p a)"
  assumes permute_comp: "\<And> a p1 p2 n. \<lbrakk>invar n a; p1 <~~> [0..<n]; p2 <~~> [0..<n]\<rbrakk> \<Longrightarrow> 
      permute n (perm_comp p1 p2) a = permute n p1 (permute n p2 a)"
  assumes permute_inv: "\<And> a p n. \<lbrakk>invar n a; p <~~> [0..<n]\<rbrakk> \<Longrightarrow> 
      permute n (perm_inv p) (permute n p a) = a"
  assumes permute_id: "\<And> a n. invar n a \<Longrightarrow>
      permute n (perm_id n) a = a"

sublocale EquivExPerm1 \<subseteq> EquivExPerm
  apply unfold_locales
     apply (simp add: permute_invar)
    apply (meson isPermutation_permute perm_comp_permute permute_comp permute_isPermutation)
   apply (meson mset_eq_perm perm_inv_mset permute_inv permute_isPermutation)
  apply (simp add: permute_id)
  done

locale EquivExPerm2 = 
  fixes invar :: "nat \<Rightarrow> 'a \<Rightarrow> bool"
  fixes permute :: "nat \<Rightarrow> nat list \<Rightarrow> 'a \<Rightarrow> 'a"
  assumes permute_invar: "\<And> a p n. \<lbrakk>invar n a; p <~~> [0..<n]\<rbrakk> \<Longrightarrow> invar n (permute n p a)"
  assumes permute_comp: "\<And> a p1 p2 n. \<lbrakk>invar n a; p1 <~~> [0..<n]; p2 <~~> [0..<n]\<rbrakk> \<Longrightarrow> 
      permute n (perm_comp p1 p2) a = permute n p2 (permute n p1 a)"
  assumes permute_inv: "\<And> a n. \<lbrakk>invar n a; p <~~> [0..<n]\<rbrakk> \<Longrightarrow> 
      permute n (perm_inv p) (permute n p a) = a"
  assumes permute_id: "\<And> a n. invar n a \<Longrightarrow>
      permute n (perm_id n) a = a"

sublocale EquivExPerm2 \<subseteq> EquivExPerm
  apply unfold_locales
     apply (simp add: permute_invar)
    apply (meson isPermutation_permute perm_comp_permute permute_comp permute_isPermutation)
   apply (meson mset_eq_perm perm_inv_mset permute_inv permute_isPermutation)
  apply (simp add: permute_id)
  done

context EquivExPerm
begin

definition equiv :: "nat \<Rightarrow> 'a \<Rightarrow> 'a \<Rightarrow> bool" where
  "equiv n a1 a2 \<longleftrightarrow> (\<exists> p. p <~~> [0..<n] \<and> permute n p a1 = a2)"

declare perm_finite [simp]

lemma perm_not_empty [simp]:
  shows "{p. p <~~> [0..<n]} \<noteq> {}"
  by auto

lemma equivp_equiv:
  shows "equivp_on {a. invar n a} (equiv n)"
  unfolding equivp_on_def
proof safe
  show "reflp_on {a. invar n a} (equiv n)"
    unfolding inv_def reflp_on_def equiv_def
    using permute_id perm_id_def
    by auto
next
  show "symp_on {a. invar n a} (equiv n)"
    unfolding symp_on_def equiv_def
    using permute_inv[of n]
    by (metis mem_Collect_eq)
next
  show "transp_on {a. invar n a} (equiv n)"
    unfolding transp_on_def equiv_def
    using permute_comp[of n]
    by (metis mem_Collect_eq)
qed

lemma equiv_invar:
  assumes "invar n a" "equiv n a a'"
  shows "invar n a'"
  using assms 
  unfolding equiv_def
  using permute_invar
  by blast

end

locale CanonLeastPerm = EquivExPerm invar for invar :: "nat \<Rightarrow> ('a::linorder) \<Rightarrow> bool"
begin

definition is_canon :: "nat \<Rightarrow> 'a \<Rightarrow> bool" where
  "is_canon n a \<longleftrightarrow> (\<forall> p. p <~~> [0..<n] \<longrightarrow> a \<le> permute n p a)"

definition canon :: "nat \<Rightarrow> 'a \<Rightarrow> 'a" where
  "canon n a = Min ((\<lambda> p. permute n p a) ` {p. p <~~> [0..<n]})"

lemma is_canon_code:
 "is_canon n a \<longleftrightarrow> list_all (\<lambda> p. a \<le> permute n p a) (Combinatorics.permute [0..<n])"
  unfolding is_canon_def
  by (auto simp add: list_all_iff permute_isPermutation isPermutation_permute)

lemma canon_code:
  "canon n a = min_list (map (\<lambda> p. permute n p a) (Combinatorics.permute [0..<n]))"
proof-
  have "{p. p <~~> [0..<n]} = set (Combinatorics.permute [0..<n])"
    by (auto simp add: permute_isPermutation isPermutation_permute)
  thus ?thesis
    unfolding canon_def
    by (subst min_list_Min, auto)
qed


lemma equiv_canon:
  "equiv n a (canon n a)"
proof-
  have "(MIN p\<in>{p. p <~~> [0..<n]}. permute n p a)
        \<in> (\<lambda>p. permute n p a) ` {p. p <~~> [0..<n]}"
  proof (rule Min_in)
    show "finite ((\<lambda>p. permute n p a) ` {p. p <~~> [0..<n]})"
      by simp
  next
    show "(\<lambda>p. permute n p a) ` {p. p <~~> [0..<n]} \<noteq> {}"
      by auto
  qed
  then obtain p' where "p' <~~> [0..<n]" "canon n a = permute n p' a"
    unfolding canon_def
    by auto
  thus ?thesis
    unfolding equiv_def
    by auto
qed

lemma canon_invar:
  assumes "invar n a"
  shows "invar n (canon n a)"
  using assms
  using equiv_canon equiv_invar
  by blast

lemma is_canon_canon:
  assumes "invar n s"
  shows "is_canon n (canon n s)"
  unfolding is_canon_def
proof safe
  fix p
  assume "p <~~> [0..<n]"
  have "permute n p (canon n s) \<in> (\<lambda>p. permute n p s) ` {p. p <~~> [0..<n]}"
    using equiv_canon[of n s]
    using `p <~~> [0..<n]`
    using permute_comp[OF assms]
    unfolding equiv_def
    by force
  thus "canon n s \<le> permute n p (canon n s)"
    using `p <~~> [0..<n]`
    unfolding canon_def
    by simp
qed

lemma canon_le:
  assumes "invar n s"
  shows "canon n s \<le> s"
  by (smt equiv_def is_canon_def permute_inv CanonLeastPerm_axioms assms equiv_canon is_canon_canon)

lemma is_canon_iff_canon_eq:
  assumes "invar n s"
  shows "is_canon n s \<longleftrightarrow> canon n s = s"
proof
  let ?P = "(\<lambda>p. permute n p s) ` {p. p <~~> [0..<n]}"
  assume "is_canon n s"
  show "canon n s = s"
    unfolding canon_def
  proof (subst Min_eq_iff)
    show "finite ?P"
      by simp
  next
    show "?P \<noteq> {}"
      by auto
  next
    show "s \<in> ?P \<and> (\<forall> s' \<in> ?P. s \<le> s')"
      using `is_canon n s`
      using permute_id[OF assms] perm_id_def
      unfolding is_canon_def
      by force
  qed
next
  let ?P = "(\<lambda>p. permute n p s) ` {p. p <~~> [0..<n]}"
  assume "canon n s = s"
  thus "is_canon n s"
    unfolding is_canon_def canon_def
    using Min_le[of ?P]
    by auto
qed

lemma equiv_canon_eq:
  assumes "invar n a1" "invar n a2"
  assumes "equiv n a1 a2"
  shows "canon n a1 = canon n a2"
proof-
  obtain p where p: "p <~~> [0..<n]" "permute n p a1 = a2"
    using assms
    using equiv_def
    by blast
  have "(\<lambda> p'. permute n p' a1) ` {p. p <~~> [0..<n]}  =
        (\<lambda> p'. permute n p' a2) ` {p. p <~~> [0..<n]}"
  proof safe
    fix p'
    assume p': "p' <~~> [0..<n]"
    obtain ip where ip: "ip <~~> [0..<n]" "a1 = permute n ip (permute n p a1)"
      using permute_inv[of n a1 p]
      using assms p
      by fastforce
    thus "permute n p' a1 \<in> (\<lambda>p'. permute n p' a2) ` {p. p <~~> [0..<n]}"
      using `invar n a2` p p'
      using permute_comp[of n a2 p' ip]
      by force
  next
    fix p'
    assume "p' <~~> [0..<n]"
    thus "permute n p' a2 \<in> (\<lambda>p'. permute n p' a1) ` {p. p <~~> [0..<n]}"
      using p permute_comp[of n a1 p' p] assms
      by force
  qed
  thus ?thesis
    unfolding canon_def equiv_def
    by simp
qed


lemma is_canon_unique:
  assumes "invar n a"
  shows "\<exists>! c. equiv n a c \<and> is_canon n c"
proof (rule_tac a="canon n a" in ex1I)
  show "equiv n a (canon n a) \<and> is_canon n (canon n a)"
    using equivp_equiv[of n]
    using assms equiv_canon is_canon_canon
    unfolding equivp_on_def symp_on_def
    by blast  
next
  fix a'
  assume "equiv n a a' \<and> is_canon n a'"
  thus "a' = canon n a"
    using assms equiv_canon_eq equiv_invar is_canon_iff_canon_eq 
    by auto
qed

end


end