subsection \<open> Interpretation of locales \<close>

theory Faradzev_Read_Graph
  imports Main "HOL-Library.Code_Target_Nat" "HOL-Library.Product_Lexorder" "HOL-Library.Multiset"
    Combinatorics Faradzev_Read Graph Partitions
begin

definition N :: nat where
  "N = 6"

global_interpretation FR'_dig: FaradzevRead'
  where S = "S_part (N*(N-1)) 2" and
        equiv = "equiv_dig N" and
        is_canon = "is_canon_dig N" and
        is_canon_test = "is_canon_dig_opt N" and
        augment = "augment_part 2"
      defines step_dig = "FR'_dig.step"
proof
  fix q
  show "equivp_on (S_part (N * (N - 1)) 2 q) (equiv_dig N)"
    using CanonDig.equivp_equiv[of N] equivp_on_subset[of "{a. 0 < N \<and> length a = N * (N - 1)}" "equiv_dig N" "S_part (N * (N - 1)) 2 q" ]
    unfolding S_part_def N_def
    by auto
next
  fix s s' q
  assume "equiv_dig N s s'" "s \<in> S_part (N * (N - 1)) 2 q"
  thus "s' \<in> S_part (N * (N - 1)) 2 q"
    unfolding CanonDig.equiv_def S_part_def
    by (auto simp add: permute_isPermutation subset_iff)
next
  fix q s s'
  assume "is_canon_dig N s" "s' \<in> set (augment_part 2 s)"
  thus "(s \<in> S_part (N * (N - 1)) 2 q) \<longleftrightarrow> (s' \<in> S_part (N * (N - 1)) 2 (q + 1))"
    using augment_part_length[of 2 s] augment_part_k[of 2 s] augment_part_sum[of 2 s]
    unfolding S_part_def
    by (smt One_nat_def augment_part_k' lessI mem_Collect_eq nat_add_right_cancel numeral_2_eq_2)
next
  fix s s' q
  assume s: "s \<in> S_part (N*(N-1)) 2 q" "s' \<in> set (augment_part 2 s)"
  thus "is_canon_dig_opt N s' \<longleftrightarrow> is_canon_dig N s'"
    using is_canon_dig_opt[of s' N] 
    using augment_part_length[of 2 s] augment_part_k[of 2 s]
    unfolding S_part_def N_def
    by force
next
  fix q s
  assume "s \<in> S_part (N * (N - 1)) 2 q"
  thus "\<exists>! sc. equiv_dig N s sc \<and> is_canon_dig N sc"
    using CanonDig.is_canon_unique[of N s]
    unfolding S_part_def N_def
    by auto
next
  fix q1 q2 :: nat
  assume "q1 \<noteq> q2"
  thus "S_part (N * (N - 1)) 2 q1 \<inter> S_part (N * (N - 1)) 2 q2 = {}"
    unfolding S_part_def
    by auto
qed

lemma decrement_canon:      
  fixes ws :: "nat list"                                               
  assumes "length ws = n * (n - 1)" "n > 0" "is_canon_dig n ws"
  assumes "decrement_last_nonzero ws fws"
  shows "is_canon_dig n fws"
proof-
  let ?V = "canon_dig n ` {v. (\<exists> i < length ws. decrement_nonzero ws v i)}"
  have "finite ?V"
  proof-
    let ?f = "\<lambda> v. THE i. i < length ws \<and> decrement_nonzero ws v i"
    let ?V' = "{v. \<exists>i<length ws. decrement_nonzero ws v i}"
    have "?f ` ?V' \<subseteq> {0..<length ws}"
      by auto (smt theI unique_decrement_nonzero_i)
    hence "finite (?f ` ?V')"
      using finite_subset
      by blast
    moreover
    have "inj_on ?f ?V'"
      unfolding inj_on_def
      by auto (metis (mono_tags, lifting) the_equality unique_decrement_nonzero unique_decrement_nonzero_i)
    ultimately
    have "finite ?V'"
      using finite_imageD[of ?f ?V']
      by blast
    thus ?thesis
      by simp
  qed
  have "canon_dig n fws \<in> ?V"
    using decrement_last_nonzero_decrement_nonzero[OF `decrement_last_nonzero ws fws`]
    by auto
  hence "?V \<noteq> {}"
    by auto               
  let ?vs = "Min ?V"
  obtain vs where vs: "vs = ?vs" by auto

  have "vs \<in> ?V"
    using vs Min_in[OF `finite ?V` `?V \<noteq> {}`]
    by simp

  then obtain v where "vs = canon_dig n v" "\<exists> p. decrement_nonzero ws v p"           
    by auto

  have "length v = n * (n - 1)"
    using `\<exists> p. decrement_nonzero ws v p` `length ws = n * (n - 1)`
    unfolding decrement_nonzero_def increment_def
    by simp

  have "ws < vs"
  proof-
    obtain perm_nodes where perm_nodes: "vs = permute_dig perm_nodes n v \<and> perm_nodes \<in> set (permute [0..<n])"
      using `vs = canon_dig n v`
      by (metis CanonDig.equiv_canon CanonDig.equiv_def permute_isPermutation)
    let ?w = "permute_dig perm_nodes n ws"

    have "ws \<le> ?w"
      using `is_canon_dig n ws` perm_nodes
      unfolding CanonDig.is_canon_def
      by (simp add: isPermutation_permute)

    moreover

    obtain p where "decrement_nonzero ws v p"
      using `\<exists> p. decrement_nonzero ws v p`
      by auto

    have "\<exists> p. decrement_nonzero ?w vs p"
    proof-
      let ?perm = "permute_dig perm_nodes n [0..<n*(n-1)]"        
      have "vs = permute_list ?perm v" "?perm \<in> set (permute [0..<n*(n-1)])"
        using permute_dig_permute_list[of v n perm_nodes] permute_dig_permute_list_set[of perm_nodes n]
        using perm_nodes `length v = n * (n - 1)` `n > 0`
        unfolding np2dp_def
        by auto
      moreover
      have "?w = permute_list ?perm ws"
        using permute_dig_permute_list[of ws n perm_nodes]
        using perm_nodes `length ws = n * (n - 1)` `n > 0`
        unfolding np2dp_def
        by simp
      ultimately
      show ?thesis
        using `\<exists> p. decrement_nonzero ws v p` `length ws = n*(n-1)`
        using decrement_nonzero_permute_list[of ws v]
        by auto
    qed

    hence "vs > ?w"
      using decrement_nonzero_gt
      by blast

    ultimately
    show ?thesis
      by simp
  qed

  have "length vs = length ws"
    using `vs = canon_dig n v` length_canon_dig[of v n] `length v = n * (n - 1)` `length ws = n * (n - 1)` `n > 0`
    by simp

  let ?I = "{i. i < length ws \<and> vs ! i < ws ! i}"

  have "?I \<noteq> {}"
    using `vs > ws` `length vs = length ws`
    unfolding list_less_def
    using lexord_take_index_conv[of vs ws "{(x, y). x < y}"]
    by auto

  have "finite ?I"
    by simp

  let ?i = "Min ?I"

  have "?i \<in> ?I"
    using Min_in[OF `finite ?I` `?I \<noteq> {}`]
    by simp

  obtain i where i: "i = ?i" by auto

  hence "i < length ws" "vs ! i < ws ! i"
    using i `?i \<in> ?I`
    by auto

  have "\<forall> i' < i. vs ! i' = ws ! i'"
  proof-
    let ?I' = "{i'. i' < i \<and> vs ! i' > ws ! i'}"
    show ?thesis
    proof  (cases "?I' = {}")
      case True
      show  ?thesis
      proof safe
        fix i'
        assume "i' < i"
        hence  "i' \<notin> ?I"
          using i Min_le[OF `finite ?I`, of i']
          using not_less
          by fastforce
        hence "vs ! i' \<ge> ws ! i'"
          using `i' < i` `i < length ws`
          by auto
        thus "vs ! i' = ws ! i'"
          using `?I' = {}` `i' < i`
          by auto
      qed
    next
      case False
      let ?i' = "Min ?I'"
      obtain i' where i': "i' =  ?i'" by auto
      have "i' < i" "vs ! i' > ws ! i'"
        using i' Min_in[of ?I'] False
        by auto
      moreover
      have "\<forall> j < i'. vs ! j = ws ! j"
      proof safe
        fix j
        assume "j < i'"
        hence "j < i"
          using `i' < i`
          by simp
        hence  "j \<notin> ?I"
          using i Min_le[OF `finite ?I`, of j]
          using not_less
          by fastforce
        hence "vs ! j \<ge> ws ! j"
          using `j < i` `i < length ws`
          by auto
        moreover
        have "j \<notin> ?I'"
          using `j < i'` Min_le[of ?I' j] i'
          by fastforce
        hence "ws ! j \<ge> vs ! j"
          using `j < i`
          by auto
        ultimately
        show "vs ! j = ws ! j"
          by auto
      qed
      hence "vs < ws"
        using list_lex_pos[of i' vs ws] `ws ! i' < vs ! i'` `i' < i` `i < length ws` `length vs = length ws`
        by simp
      hence False
        using `ws < vs`
        by simp
      thus ?thesis
        by simp
    qed
  qed                               

  show ?thesis
  proof (cases "ws ! i > vs ! i + 1")
    case True
    let ?x = "ws [i := ws ! i - 1]"
    let ?xs = "canon_dig n ?x"

    have "decrement_nonzero ws ?x i"
      using `ws ! i > vs ! i + 1`
      using `i < length ws`
      unfolding decrement_nonzero_def increment_def
      by simp
    hence "?xs \<in> ?V"                                        
      using `i < length ws`
      by auto

    have "vs > ?x"
      using list_lex_pos[of i ?x vs]
      using `ws ! i > vs ! i + 1` `\<forall> i' < i. vs ! i' = ws ! i'` `i < length ws` `length vs = length ws`
      by (auto simp add: Suc_diff_Suc min_def nth_append)

    have "?xs \<le> ?x"
      using `i < length ws` `length ws = n * (n - 1)`
      using CanonDig.canon_le[of n ?x]
      by (simp add: min_def)

    hence "vs > ?xs"
      using `vs > ?x`
      by simp

    hence False
      using `?xs \<in> ?V` vs Min_le[OF `finite ?V`, of ?xs]
      by simp

    thus ?thesis
      by simp
  next
    case False
    hence "vs ! i + 1 = ws ! i"
      using `vs ! i < ws ! i`
      by simp

    let ?j = "Max ?I"
    have "?j \<in> ?I"
      using Max_in[OF `finite ?I` `?I \<noteq> {}`]
      by simp

    obtain j where j: "j = ?j" by auto

    show ?thesis
    proof (cases "i < j")
      case True

      have "j < length ws" "vs ! j < ws ! j"
        using `?j \<in> ?I` j
        by auto

      let ?x = "ws [j := ws ! j - 1]"
      let ?xs = "canon_dig n ?x"

      have "decrement_nonzero ws ?x j"
        using `ws ! j > vs ! j`
        using `j < length ws` unfolding decrement_nonzero_def increment_def
        by simp
      hence "?xs \<in> ?V"
        using `j < length ws`
        by auto

      have "vs > ?x"
        using `vs ! i + 1 = ws ! i` `\<forall> i' < i. vs ! i' = ws ! i'` `i < length ws` `length vs = length ws`
        using list_lex_pos[of i ?x vs] `j < length ws` `i < j`
        by (simp add: Suc_diff_Suc min_def nth_append)

      have "?xs \<le> ?x"
        using `j < length ws` `length ws = n * (n - 1)`
        using CanonDig.canon_le[of n ?x]
        by (simp add: min_def)

      hence "vs > ?xs"
        using `vs > ?x`
        by simp

      hence False
        using `?xs \<in> ?V` vs Min_le[OF `finite ?V`, of ?xs]
        by simp

      thus ?thesis
        by simp
    next
      case False
      hence "i = j"
        using i j
        using Min_le `?j \<in> ?I` `finite ?I` le_neq_trans
        by blast

      have "decrement_nonzero ws vs i"
      proof-
        have "\<forall> i'. i < i' \<and> i' < length ws \<longrightarrow> vs ! i' \<ge> ws ! i'"
          using `i = j` j `finite ?I` `?I \<noteq> {}`
          by (metis (no_types, lifting) Max_eq_iff leD leI mem_Collect_eq)


        have "\<forall> i'. i < i' \<and> i' < length ws \<longrightarrow> vs ! i' = ws ! i'"
        proof safe
          fix i'
          assume i': "i < i'" "i' < length ws"

          have "sum_list ws = sum_list vs  + 1"
          proof-
            have "sum_list ws = sum_list v + 1"
              using `\<exists> p. decrement_nonzero ws v p`
              using decrement_nonzero_def increment_sum_list
              by blast

            moreover

            have  "sum_list vs = sum_list v"
              using `vs = canon_dig n v` sum_list_canon_dig[of v n] `length v = n * (n - 1)` `n > 0`
              by simp

            ultimately

            show ?thesis
              by simp
          qed

          have "vs = take i vs @ [vs ! i] @ drop (i + 1) vs"
               "ws = take i ws @ [ws ! i] @ drop (i + 1) ws"
            using `i < length ws` `length vs = length ws`
            by (metis One_nat_def add.right_neutral add_Suc_right append.assoc append_take_drop_id hd_drop_conv_nth take_hd_drop)+

          hence "sum_list (drop (i + 1) vs) = sum_list (drop (i + 1) ws)"
            using `sum_list ws = sum_list vs + 1`  `i < length ws` `length vs = length ws`
            using `\<forall> i' < i. vs ! i' = ws ! i'`
            using `vs ! i + 1 = ws ! i`
            by auto (metis add.assoc add_Suc_right add_diff_cancel_left' less_imp_le_nat nth_take_lemma plus_1_eq_Suc sum_list.Cons sum_list.append)

          hence "\<forall>ia<length (drop (i + 1) vs). drop (i + 1) vs ! ia = drop (i + 1) ws ! ia"
            using `\<forall> i'. i < i' \<and> i' < length ws \<longrightarrow> vs ! i' \<ge> ws ! i'` i'
            using sum_list_ge_eq[of "drop (i+1) vs" "drop (i+1) ws"] `length vs = length ws`
            by auto
          thus "vs ! i' = ws ! i'"
            using i' `i < length ws` `length vs = length ws`
            by auto (metis (no_types, lifting) \<open>i < length ws\<close> add_diff_cancel_left' add_less_cancel_left diff_Suc_Suc less_imp_Suc_add plus_1_eq_Suc)
        qed
        with `\<forall> i' < i. vs ! i' = ws ! i'`
        show ?thesis
          using `length vs = length ws` `vs ! i + 1 = ws ! i` `i < length ws` less_linear
          unfolding decrement_nonzero_def increment_def is_last_nonzero_def
          by metis
      qed

      show ?thesis
      proof (cases "is_last_nonzero ws i")
        case False
        then obtain i' where "i' > i" "is_last_nonzero ws i'"
          using `i < length ws` `vs ! i + 1 = ws ! i` ex_last_nonzero[of i ws]
          using le_neq_trans
          by auto

        hence "i' < length ws"
          unfolding is_last_nonzero_def
          by simp

        let ?x = "ws[i' := ws ! i' - 1]"
        let ?xs = "canon_dig n ?x"

        have "decrement_nonzero ws ?x i'"
          using `i < length ws` `is_last_nonzero ws i'`
          unfolding decrement_nonzero_def is_last_nonzero_def increment_def
          by simp
          
        hence "?xs \<in> ?V"                                        
          using `i' < length ws`
          by auto

        have "vs > ?x"
          using list_lex_pos[of i ?x vs]
          using `i < i'` `vs ! i + 1 = ws ! i` `\<forall> i' < i. vs ! i' = ws ! i'` `i < length ws` `length vs = length ws`
          by (auto simp add: Suc_diff_Suc min_def nth_append)

        have "?xs \<le> ?x"
          using `i < length ws` `length ws = n * (n - 1)`
          using CanonDig.canon_le[of n ?x]
          by (simp add: min_def)

        hence "vs > ?xs"
          using `vs > ?x`
          by simp

        hence False
          using `?xs \<in> ?V` vs Min_le[OF `finite ?V`, of ?xs]
          by simp
        thus ?thesis
          by simp
      next
        case True
        hence "decrement_last_nonzero ws vs"
          using `decrement_nonzero ws vs i`
          unfolding decrement_last_nonzero_def decrement_nonzero_def is_last_nonzero_def
          by  auto
 
        hence "vs = fws"
          using `decrement_last_nonzero ws fws` unique_decrement
          by simp
        thus ?thesis
          using `vs = canon_dig n v` CanonDig.is_canon_canon[of n v] `length v = n * (n - 1)` `n > 0`
          by simp
      qed
    qed
  qed
qed                        

lemma min_parent_iff_decrement_last_nonzero:
  assumes  "set xs \<subseteq> {0..<2}" "is_canon_dig N ys"
  shows "FR'_dig.min_parent ys xs \<longleftrightarrow> decrement_last_nonzero xs ys"
proof
  assume "FR'_dig.min_parent ys xs"
  thus "decrement_last_nonzero xs ys"
    using assms
    unfolding FR'_dig.min_parent_def FR'_dig.parent_def
    using set_augment_part[of 2 xs ys] decrement_increment[OF `set xs \<subseteq> {0..<2}`, of ys]
    by auto
next
  assume "decrement_last_nonzero xs ys"
  show "FR'_dig.min_parent ys xs"
    unfolding FR'_dig.min_parent_def FR'_dig.parent_def
  proof safe
    show "xs \<in> set (augment_part 2 ys)"
      using set_augment_part[of 2 xs ys] decrement_increment[OF `set xs \<subseteq> {0..<2}`, of ys] `decrement_last_nonzero xs ys`
      by simp
  next
    fix Y'
    assume "xs \<in> set (augment_part 2 Y')"
    hence "increment_after_last_nonzero Y' xs 2"
      using set_augment_part[of 2 xs Y']
      by simp
    hence "decrement_last_nonzero xs Y'"  
      using decrement_increment[OF `set xs \<subseteq> {0..<2}`, of Y']
      by simp
    with `decrement_last_nonzero xs ys`
    have "ys = Y'"
      using unique_decrement
      by simp
    thus "Y' \<ge> ys"
      by simp
  next
    show "is_canon_dig N ys"
      using assms
      by simp
  qed
qed

lemma parent_iff_decrement_last_nonzero:
  assumes  "set xs \<subseteq> {0..<2}" "is_canon_dig N ys"
  shows "FR'_dig.parent ys xs \<longleftrightarrow> decrement_last_nonzero xs ys"
proof
  assume "FR'_dig.parent ys xs"
  thus "decrement_last_nonzero xs ys"
    using assms
    unfolding FR'_dig.parent_def
    using set_augment_part[of 2 xs ys] decrement_increment[OF `set xs \<subseteq> {0..<2}`, of ys]
    by auto
next
  assume "decrement_last_nonzero xs ys"
  thus "FR'_dig.parent ys xs"
    using min_parent_iff_decrement_last_nonzero[OF assms]
    unfolding FR'_dig.min_parent_def
    by simp
qed

global_interpretation FR_dig: FaradzevReadStrict
  where S = "S_part (N*(N-1)) 2" and 
        equiv = "equiv_dig N" and
        is_canon = "is_canon_dig N" and
        is_canon_test = "is_canon_dig_opt N" and
        augment = "augment_part 2"
      defines
        fold_dig = "FR_dig.fold_dfs" and
        count_dig = "FR_dig.count_dfs" and
        generate_dig = "FR_dig.generate_dfs"
proof
  fix q s
  assume "s \<in> S_part (N * (N - 1)) 2 (q + 1)" "is_canon_dig N s"
  hence s: "set s \<subseteq> {0..<2}" "length s = N*(N-1)" "sum_list s = q + 1" "is_canon_dig N s"
    using is_canon_dig_opt[of s N]
    unfolding S_part_def
    by (auto simp add: atLeast0_lessThan_Suc insert_commute numeral_2_eq_2)
  hence "s \<noteq> []"
    by auto
  have "set s \<noteq> {0}"
    using `sum_list s = q + 1`
    by (metis Suc_eq_plus1 Suc_neq_Zero singletonD sum_list_eq_0_iff)
  then obtain ss where ss: "decrement_last_nonzero s ss"
    using `s \<noteq> []` decrement_last_nonzero_ex[of s]
    by auto
  have "ss \<in> S_part (N*(N-1)) 2 q" 
    using s `s \<noteq> []` ss decrement_last_nonzero_set[of s 2 ss] decrement_last_nonzero_sum[of s ss]
    unfolding S_part_def
    by (auto simp add: decrement_last_nonzero_def decrement_nonzero_def is_last_nonzero_def increment_def)
  moreover
  have "is_canon_dig N ss"
    using decrement_canon[of s N ss] ss `is_canon_dig N s` `length s = N * (N - 1)` `set s \<subseteq> {0..<2}`
    by (simp add: N_def)
  moreover
  have "s \<in> set (augment_part 2 ss)"
    using set_augment_part[of 2 s ss] decrement_increment[of s 2 ss] ss `set s \<subseteq> {0..<2}`
    by auto
  ultimately
  show "\<exists>p\<in>S_part (N * (N - 1)) 2 q. FR'_dig.parent p s"
    unfolding FR'_dig.parent_def
    by auto
next
  fix q s s' p p'
  assume *: "p \<in> S_part (N * (N - 1)) 2 q" "p' \<in> S_part (N * (N - 1)) 2 q"
    "FR'_dig.parent p s" "FR'_dig.parent p' s'" "p < p'"
  hence **: "s \<in> S_part (N * (N - 1)) 2 (q + 1)" "s' \<in> S_part (N * (N - 1)) 2 (q + 1)"
    using FR'_dig.augment_dim
    unfolding FR'_dig.parent_def 
    by blast+
  hence "set s \<subseteq> {0..<2}" "set s' \<subseteq> {0..<2}"
    unfolding S_part_def FR'_dig.parent_def
    by auto
  hence ***: "decrement_last_nonzero s p" "decrement_last_nonzero s' p'"
    using *
    using parent_iff_decrement_last_nonzero[of s p]
    using parent_iff_decrement_last_nonzero[of s' p']
    unfolding FR'_dig.parent_def
    by auto
  show "s < s'"
  proof (rule ccontr)
    assume "\<not> ?thesis"
    hence "s = s' \<or> s > s'"
      by auto
    thus False
    proof
      assume "s = s'"
      hence "p = p'"
        using ***
        by (simp add: unique_decrement)
      thus ?thesis
        using `p < p'`
        by simp
    next
      assume "s' < s"
      thus False
        using `p < p'` decrement_last_nonzero_weak_mono[of s' s p' p]
        using ** ***
        unfolding S_part_def
        by auto
    qed
  qed
next
  fix q s
  assume "s \<in> S_part (N * (N - 1)) 2 q" "is_canon_dig N s"
  show "sorted (filter (is_canon_dig N) (augment_part 2 s)) \<and>
        distinct (filter (is_canon_dig N) (augment_part 2 s))"
    using More_List.sorted_filter distinct_augment distinct_filter sorted_augment 
    by blast
qed

definition xxx where 
  "xxx = 
    fold (\<lambda> i g. step_dig g) [0..<2]
    [[0, 0, 0, 0, 0,  
      0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0, 
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0,
      0, 0, 0, 0, 0::nat]]"

value "xxx"

end
