text\<open> Based on List\_Lexorder.thy \<close>

subsection \<open>Lexicographic order on lists but with reverse element comparison\<close>

theory List_Lexorder_gt
imports Main
begin

instantiation list :: (ord) ord
begin

definition
  list_less_def: "xs < ys \<longleftrightarrow> (ys, xs) \<in> lexord {(u, v). u < v}"

definition
  list_le_def: "(xs :: _ list) \<le> ys \<longleftrightarrow> xs < ys \<or> xs = ys"

instance ..

end

instance list :: (order) order
proof
  fix xs :: "'a list"
  show "xs \<le> xs" by (simp add: list_le_def)
next
  fix xs ys zs :: "'a list"
  assume "xs \<le> ys" and "ys \<le> zs"
  then show "xs \<le> zs"
    apply (auto simp add: list_le_def list_less_def)
    apply (rule lexord_trans)
    apply (auto intro: transI)
    done
next
  fix xs ys :: "'a list"
  assume "xs \<le> ys" and "ys \<le> xs"
  then show "xs = ys"
    apply (auto simp add: list_le_def list_less_def)
    apply (rule lexord_irreflexive [THEN notE])
    defer
    apply (rule lexord_trans)
    apply (auto intro: transI)
    done
next
  fix xs ys :: "'a list"
  show "xs < ys \<longleftrightarrow> xs \<le> ys \<and> \<not> ys \<le> xs"
    apply (auto simp add: list_less_def list_le_def)
    defer
    apply (rule lexord_irreflexive [THEN notE])
    apply auto
    apply (rule lexord_irreflexive [THEN notE])
    defer
    apply (rule lexord_trans)
    apply (auto intro: transI)
    done
qed

instance list :: (linorder) linorder
proof
  fix xs ys :: "'a list"
  have "(xs, ys) \<in> lexord {(u, v). u < v} \<or> xs = ys \<or> (ys, xs) \<in> lexord {(u, v). u < v}"
    by (rule lexord_linear) auto
  then show "xs \<le> ys \<or> ys \<le> xs"
    by (auto simp add: list_le_def list_less_def)
qed

instantiation list :: (linorder) distrib_lattice
begin

definition "(inf :: 'a list \<Rightarrow> _) = min"

definition "(sup :: 'a list \<Rightarrow> _) = max"

instance
  by standard (auto simp add: inf_list_def sup_list_def max_min_distrib2)

end

lemma not_gt_Nil [simp]: "\<not> x > []"
  by (simp add: list_less_def)

lemma Nil_gt_Cons [simp]: "[] > a # x"
  by (simp add: list_less_def)

lemma Cons_less_Cons [simp]: "a # x < b # y \<longleftrightarrow> a > b \<or> a = b \<and> x < y"
  by (auto simp add: list_less_def)

lemma le_Nil [simp]: "x \<ge> [] \<longleftrightarrow> x = []"
  unfolding list_le_def by (cases x) auto

lemma Nil_ge_Cons [simp]: "[] \<ge> x"
  unfolding list_le_def by (cases x) auto

lemma Cons_le_Cons [simp]: "a # x \<le> b # y \<longleftrightarrow> a > b \<or> a = b \<and> x \<le> y"
  unfolding list_le_def by auto

instantiation list :: (order) order_top
begin

definition "top = []"

instance
  by standard (simp add: top_list_def)

end

lemma less_list_code [code]:
  "xs > ([]::'a::{equal, order} list) \<longleftrightarrow> False"
  "[] > (x::'a::{equal, order}) # xs \<longleftrightarrow> True"
  "(x::'a::{equal, order}) # xs < y # ys \<longleftrightarrow> x > y \<or> x = y \<and> xs < ys"
  by simp_all

lemma less_eq_list_code [code]:
  "x # xs \<ge> ([]::'a::{equal, order} list) \<longleftrightarrow> False"
  "[] \<ge> (xs::'a::{equal, order} list) \<longleftrightarrow> True"
  "(x::'a::{equal, order}) # xs \<le> y # ys \<longleftrightarrow> x > y \<or> x = y \<and> xs \<le> ys"
  by simp_all

lemma list_lex_pos:
  assumes "p < length xs" "p < length ys" "\<forall> i < p. xs ! i = ys ! i" "xs ! p > ys ! p"
  shows "xs < ys"
proof-
  have "take p xs = take p ys"
    using assms
    by (simp add: nth_take_lemma)
  moreover
  have "xs = take p xs @ xs ! p # drop (p + 1) xs"
    using `p < length xs`
    by (simp add: id_take_nth_drop)
  moreover
  have "ys = take p ys @ ys ! p # drop (p + 1) ys"
    using `p < length ys`
    by (simp add: id_take_nth_drop)
  ultimately                                                      
  show ?thesis
    using lexord_append_left_rightI `xs ! p > ys ! p`     
    unfolding list_less_def
    by (metis mem_Collect_eq split_conv)
qed

lemma list_lex_prepend:
  assumes "ys \<le> zs"  
  shows "xs @ ys \<le> xs @ zs"
  using assms
  by (induction xs) auto

lemma earlier_zero_less:
  fixes M1 M2 :: "nat list"
  assumes "n \<le> length M1" "length M1 = length M2" "set M2 \<subseteq> {0, 1}"
  assumes "take n M1 = replicate n 1" "take n M2 \<noteq> replicate n 1"
  shows "M1 < M2"
proof-
  have "\<exists> p. p < n \<and> take p M2 = replicate p 1 \<and> M2 ! p = 0"
  proof-
    let ?P = "{p. p < n \<and> M2 ! p = 0}"
    have "?P \<noteq> {}"
    proof (rule ccontr)
      assume "\<not> ?thesis"
      have "\<forall> p < n. M2 ! p = 1"    
      proof safe
        fix p
        assume "p < n"
        hence "M2 ! p \<in> {0, 1}"
          using `set M2 \<subseteq> {0, 1}` `n \<le> length M1` `length M1 = length M2`
          using nth_mem[of p M2]
          by (metis less_le_trans subsetD)
        thus "M2 ! p = 1"
          using `\<not> ?P \<noteq> {}` `p < n`
          by auto
      qed
      hence "take n M2 = replicate n 1"
        using assms
        by (auto intro!: nth_equalityI)
      thus False 
        using assms
        by simp
    qed
    let ?p = "Min ?P"
    have "?p \<in> ?P"
      using Min_in[of ?P] `?P \<noteq> {}`
      by auto
    hence "?p < n" "M2 ! ?p = 0"
      by auto
    have "take ?p M2 = replicate ?p 1"
    proof (rule nth_equalityI)
      show "length (take ?p M2) = length (replicate ?p 1)"
        using `?p < n` `n \<le> length M1` `length M1 = length M2`
        by auto
    next
      fix i
      assume "i < length (take ?p M2)"
      hence "i < ?p" "i < length M2"
        by auto
      have "i \<notin> ?P"
      proof (rule ccontr)
        assume "\<not> ?thesis"
        hence "i \<ge> ?p"
          using Min_le[of ?P i]
          by simp
        thus False
          using `i < ?p`
          by  simp
      qed
      hence "M2 ! i \<noteq> 0"
        using `?p < n` `i < ?p`
        by simp
      hence "M2 ! i = 1"
        using nth_mem[of i M2] `set M2 \<subseteq> {0, 1}` `i < length M2`
        by (metis in_set_replicate insertE set_replicate subsetD)
      thus "take ?p M2 ! i = replicate ?p 1 ! i"
        using `i < ?p`
        by auto
    qed
    thus ?thesis
      using `?p < n` `M2 ! ?p = 0`
      by blast
  qed
  then obtain p where "p < n" "take p M2 = replicate p 1" "M2 ! p = 0"
    by auto
  show ?thesis
  proof (rule list_lex_pos)
    show "p < length M1" "p < length M2"
      using `p < n` assms
      by simp_all
  next
    show "M2 ! p < M1 ! p"
      using `M2 ! p = 0` `p < n` assms
      by (metis nth_replicate nth_take zero_less_iff_neq_zero zero_neq_one)
  next
    show "\<forall> i < p. M1 ! i = M2 ! i"
      using `take p M2 = replicate p 1` `take n M1 = replicate n 1` `p < n`
      by (metis Suc_less_eq less_Suc_eq less_trans_Suc nth_replicate nth_take)
  qed
qed

end
