subsection \<open>Additions to the Multiset library\<close>

theory More_Multiset
imports Main "HOL-Library.Multiset"
begin

lemma mset_take_drop:
  assumes "i < length xs"
  shows "mset (take i xs) + mset (drop (i+1) xs) = mset xs - {#xs ! i#}"
  using id_take_nth_drop[OF assms]
  by (metis Multiset.mset_append add.commute add_mset_remove_trivial mset.simps(2) plus_1_eq_Suc union_mset_add_mset_right)

lemma mset_take_drop_id:
  assumes "i \<le> length xs"
  shows "mset (take i xs) + mset (drop i xs) = mset xs"
  using assms
  by (simp add: union_code)

lemma mset_eq_sum_list_eq:
  fixes xs ys :: "'a::comm_monoid_add list"
  assumes "mset xs = mset ys"
  shows "sum_list xs = sum_list ys"
  using assms sum_mset_sum_list[symmetric]
  by metis

lemma mset_concat[simp]:
 "mset (concat xs) = sum_list (map mset xs)"
  by (induction xs, auto)

end