subsection \<open>Additions to the Relation library\<close>

theory More_Relation
imports Main
begin

definition reflp_on where 
  "reflp_on A P \<longleftrightarrow> (\<forall> x \<in> A. P x x)"
definition symp_on where
  "symp_on A P \<longleftrightarrow> (\<forall> x \<in> A. \<forall> y \<in> A. P x y \<longrightarrow> P y x)"
definition transp_on where
  "transp_on A P \<longleftrightarrow> (\<forall> x \<in> A. \<forall> y \<in> A. \<forall> z \<in> A. P x y \<and> P y z \<longrightarrow> P x z)"
definition equivp_on where
  "equivp_on A P \<longleftrightarrow> reflp_on A P \<and> symp_on A P \<and> transp_on A P"

lemma equivp_on_subset:
  assumes "equivp_on A P" "B \<subseteq> A"
  shows "equivp_on B P"
  unfolding equivp_on_def
proof safe
  show "reflp_on B P"
    using assms
    by (metis equivp_on_def reflp_on_def subsetD)
next
  show "symp_on B P"
    using assms
    by (simp add: equivp_on_def subset_eq symp_on_def)
next
  show "transp_on B P"
    using assms
    by (smt equivp_on_def subsetD transp_on_def)
qed

end