subsection\<open>Abstract specification of augmentation\<close>

theory Partitions
  imports Main More_List List_Lexorder_gt Combinatorics
begin

definition S_part :: "nat \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> nat list set" where 
  "S_part n k q = {l. length l = n \<and> set l \<subseteq> {0..<k} \<and> sum_list l = q}"

definition is_last_nonzero :: "nat list \<Rightarrow> nat \<Rightarrow> bool" where
  "is_last_nonzero xs i \<longleftrightarrow>
      i < length xs \<and> xs ! i \<noteq> 0 \<and> (\<forall> i'. i < i' \<and> i' < length xs \<longrightarrow> xs ! i' =  0)" 

lemma is_last_nonzero_append:
  shows "is_last_nonzero xs i \<longleftrightarrow> i < length xs \<and> xs ! i \<noteq> 0 \<and> xs = take i xs @ [xs ! i] @ replicate (length xs - i - 1) 0"
proof safe
  assume "is_last_nonzero xs i"
  thus "i < length xs" "0 < xs ! i"
    unfolding is_last_nonzero_def
    by auto

  show "xs = take i xs @ [xs ! i] @ replicate (length xs - i - 1) 0" (is "xs = ?xs")
  proof (rule nth_equalityI)
    show "length xs = length ?xs"
      using `i < length xs`
      by simp
  next
    fix p
    assume "p < length xs"
    thus "xs ! p = ?xs ! p"
      using `is_last_nonzero xs i`
      unfolding is_last_nonzero_def
      by (auto simp add: nth_append min_def nth_Cons split: nat.split)
  qed
next
  assume "i < length xs" "xs ! i > 0" "xs = take i xs @ [xs ! i] @ replicate (length xs - i - 1) 0" (is "xs = ?xs")
  show "is_last_nonzero xs i"
    using `i < length xs` `xs ! i > 0`
    by (subst `xs = ?xs`) (auto simp add: is_last_nonzero_def nth_append)
qed
  
lemma ex_last_nonzero:
  assumes "i < length xs" "xs ! i \<noteq> 0"
  shows "\<exists> i' \<ge> i. is_last_nonzero xs i'"
  using assms
proof-
  let ?I  = "{i. i < length xs \<and> xs ! i \<noteq> 0}"
  have "i \<in> ?I"
    using assms
    by auto
  let ?i = "Max ?I"   
  have "?i < length xs" "xs ! ?i \<noteq> 0"
    using Max_in[of ?I] `i \<in> ?I` assms
    by (metis (mono_tags, lifting) Collect_empty_eq Max_in finite_nat_set_iff_bounded mem_Collect_eq)+
  moreover
  have "\<forall> i'. ?i < i' \<and> i' < length xs \<longrightarrow> xs ! i' = 0"
  proof safe
    fix i'
    assume "?i < i'" "i' < length xs" 
    show "xs ! i' = 0"
    proof (rule ccontr)
      assume "\<not> ?thesis"
      hence "i' \<in> ?I"
        using `i' < length xs`
        by auto
      hence  "i' \<le> ?i"
        using Max_ge[of ?I i'] 
        by simp
      thus False
        using `?i < i'`
        by simp
    qed
  qed
  moreover
  have "?i \<ge> i"
    using Max_ge[of ?I i] `i \<in> ?I`
    by simp
  ultimately
  show ?thesis
    unfolding is_last_nonzero_def
    by (rule_tac x="?i" in exI) blast
qed

definition increment :: "nat list \<Rightarrow> nat list \<Rightarrow> nat \<Rightarrow> bool" where
  "increment xs ys i  \<longleftrightarrow> 
     length xs = length ys \<and>
     i < length xs \<and>
     ys ! i = xs ! i + 1 \<and> 
     (\<forall> i'. i' \<noteq> i \<and> i' < length xs \<longrightarrow> ys ! i' = xs ! i')"

lemma increment_append:
  shows "increment xs ys i \<longleftrightarrow> 
           length xs = length ys \<and> i < length xs \<and> 
           ys = take i xs @ [xs ! i + 1] @ drop (i + 1) xs"
  apply (auto intro!: nth_equalityI simp add: increment_def nth_append nth_Cons min_def split: nat.split)
  using add_diff_inverse_nat apply fastforce
  using add_diff_inverse_nat apply fastforce
  done

definition increment_last_nonzero :: "nat list \<Rightarrow> nat list \<Rightarrow> nat \<Rightarrow> bool" where
  "increment_last_nonzero xs ys k \<longleftrightarrow> 
    (\<exists> i. is_last_nonzero xs i \<and> 
          increment xs ys i \<and> ys ! i < k)" 

definition increment_trailing_zero :: "nat list \<Rightarrow> nat list \<Rightarrow> bool" where
  "increment_trailing_zero xs ys \<longleftrightarrow> 
     (\<exists> i. is_last_nonzero xs i \<and> 
           (\<exists> j. i < j \<and> increment xs ys j))"

definition increment_any_zero :: "nat list \<Rightarrow> nat list \<Rightarrow> bool" where
  "increment_any_zero xs ys  \<longleftrightarrow> 
     (\<forall> i. i < length xs \<longrightarrow> xs ! i = 0) \<and> 
     (\<exists> j. increment xs ys j)"

definition increment_after_last_nonzero :: "nat list \<Rightarrow> nat list \<Rightarrow> nat \<Rightarrow> bool" where
  "increment_after_last_nonzero xs ys k \<longleftrightarrow> length xs = length ys \<and>
    (\<exists> i j. i \<le> j \<and> j < length xs \<and> 
          (i = 0 \<or> xs ! i \<noteq> 0) \<and>
          (\<forall> i'. i < i' \<and> i' < length xs \<longrightarrow> xs ! i' = 0) \<and>
          ys ! j = xs ! j + 1 \<and>
          ys ! j < k \<and> 
          (\<forall> i'. i' \<noteq> j \<and> i' < length xs \<longrightarrow> ys ! i' = xs ! i'))"

lemma increment_after_last_nonzero:
  assumes "k > 1"
  shows "increment_after_last_nonzero l l' k \<longleftrightarrow> 
         increment_last_nonzero l l' k \<or> increment_trailing_zero l l' \<or> increment_any_zero l l'" (is "?lhs \<longleftrightarrow>?rhs")
proof
  assume ?lhs
  then obtain i j where *: "length l = length l'"
    "i \<le> j" "j < length l" "i = 0 \<or> l ! i \<noteq> 0"
    "\<forall> i'. i < i' \<and> i' < length l \<longrightarrow> l ! i' = 0"
    "l' ! j = l ! j + 1"
    "l ! j + 1 < k"
    "\<forall> i'. i' \<noteq> j \<and> i' < length l \<longrightarrow> l' ! i' = l ! i'"
    unfolding increment_after_last_nonzero_def
    by auto blast

  from `i = 0 \<or> l ! i \<noteq> 0`
  show ?rhs                
  proof
    assume "l ! i \<noteq> 0"
    show ?thesis
    proof (cases "i = j")
      case True
      hence "increment_last_nonzero l l' k"
        using * `l ! i \<noteq> 0`
        unfolding increment_last_nonzero_def is_last_nonzero_def increment_def
        by (simp, rule_tac x="i" in exI, simp)
      thus ?thesis
        by auto
    next
      case False
      hence "increment_trailing_zero l l'"
        using * `l ! i \<noteq> 0`                                       
        unfolding increment_trailing_zero_def is_last_nonzero_def increment_def
        by simp (rule_tac x=i in exI, simp, rule_tac x=j in exI, simp)
      thus ?thesis
        by auto
    qed
  next                                                                         
    assume "i = 0"
    show ?thesis
    proof (cases "l ! 0 \<noteq> 0 \<and> j = 0")
      case True
      hence "increment_last_nonzero l l' k"
        using * `k > 1`
        unfolding increment_last_nonzero_def is_last_nonzero_def increment_def
        by simp (rule_tac x=0 in exI, simp)
      thus ?thesis
        by auto
    next
      case False
      hence "l ! 0 = 0 \<or> j > 0"
        by simp
      show  ?thesis
      proof (cases "l ! 0 = 0")
        case True
        hence "\<forall>i'<length l. l ! i' = 0"
          using *(5) `i = 0`
          using neq0_conv
          by blast
        hence "increment_any_zero l l'"
          using `i = 0` *
          unfolding increment_any_zero_def increment_def
          by simp (rule_tac x=j in exI, simp)
        thus ?thesis
          by auto
      next
        case False
        hence "j > 0"
          using `l ! 0 = 0 \<or> j > 0`
          by simp
        have "l' \<noteq> []"
          using `j < length l` `length l = length l'`
          by auto 
        hence "increment_trailing_zero l l'"
          using `i = 0` `l ! 0 \<noteq> 0` * `k > 1` `j > 0`
          unfolding increment_trailing_zero_def is_last_nonzero_def increment_def
          by simp (rule_tac x=0 in exI, simp, rule_tac x=j in exI, simp)
        thus ?thesis
          by auto
      qed
    qed
  qed
next
  assume ?rhs
  thus ?lhs
  proof
    assume "increment_last_nonzero l l' k"
    then obtain i where *: "length l = length l'"
      "i < length l" "l ! i \<noteq> 0" "\<forall>i'. i < i' \<and> i' < length l \<longrightarrow> l ! i' = 0"
      "l' ! i = l ! i + 1" "l' ! i < k" "\<forall>i'. i' \<noteq> i \<and> i' < length l \<longrightarrow> l' ! i' = l ! i'"
      unfolding increment_last_nonzero_def is_last_nonzero_def increment_def
      by auto
    thus "increment_after_last_nonzero l l' k"
      unfolding increment_after_last_nonzero_def
      by (simp, rule_tac x=i in exI, rule_tac x=i in exI, simp)
  next
    assume "increment_trailing_zero l l' \<or> increment_any_zero l l'"
    thus ?thesis
    proof
      assume "increment_trailing_zero l l'"
      then obtain i j where "length l = length l'"
        "i < j" "j < length l" "\<forall>i'. i < i' \<and> i' < length l \<longrightarrow> l ! i' = 0"
        "l ! i \<noteq> 0" "l' ! j = 1" "\<forall>i'. i' \<noteq> j \<and> i' < length l \<longrightarrow> l' ! i' = l ! i'"
        unfolding increment_trailing_zero_def is_last_nonzero_def increment_def
        by auto
      thus "increment_after_last_nonzero l l' k"
        using `k > 1`
        unfolding increment_after_last_nonzero_def
        by (simp, rule_tac x=i in exI, rule_tac x=j in exI, simp)
    next
      assume "increment_any_zero l l'"
      then obtain j where "length l = length l'" "\<forall>i'<length l. l ! i' = 0" "j<length l" "l' ! j = 1" 
        "\<forall>i'. i' \<noteq> j \<and> i' < length l \<longrightarrow> l' ! i' = 0"
        unfolding increment_any_zero_def increment_def
        by auto
      thus "increment_after_last_nonzero l l' k"
        using `k > 1`
        unfolding increment_after_last_nonzero_def
        by simp (rule_tac x=0 in exI, rule_tac x=j in exI, simp)
    qed
  qed        
qed

lemma increment_after_last_nonzero_increment:
  assumes "increment_after_last_nonzero l s k"
  shows  "\<exists> i. increment l s i"
  using assms
  unfolding increment_after_last_nonzero_def increment_def
  by auto

lemma increment_sum_list:
  assumes "increment l s i"
  shows "sum_list s = sum_list l + 1"
proof-
  from assms have "s = l[i := l ! i + 1]" "i < length l"
    unfolding increment_def               
    by (auto intro!: nth_equalityI simp add: nth_list_update)
  thus ?thesis
    by (simp add: sum_list_update)
qed    

lemma increment_after_last_nonzero_sum:
  assumes "increment_after_last_nonzero l s k"
  shows "sum_list s = sum_list l + 1"
  using assms increment_after_last_nonzero_increment increment_sum_list
  by blast

subsubsection\<open>Implementation of augmentation procedure\<close>

definition augment_part :: "nat \<Rightarrow> nat list \<Rightarrow> nat list list" where
  "augment_part k l = (
     let suf = dropWhile (\<lambda> x. x = 0) (rev l);
         pref_len = length l - length suf
      in (if suf \<noteq> [] \<and> hd suf < k - 1 then 
            [rev ((replicate pref_len 0) @ ((hd suf + 1) # tl suf))]
         else
            []) @ (map (\<lambda> pref. rev (pref @ suf)) (map (\<lambda> i. replicate i 0 @ (1 # replicate (pref_len - i - 1) 0)) (rev [0..<pref_len]))))"

value "augment_part 3 [1, 0, 1, 0, 0::nat]"

lemma is_last_nonzero:
  assumes "xs \<noteq> []" "set xs \<noteq> {0}"
  shows "is_last_nonzero xs (length (dropWhile (\<lambda> x. x = 0) (rev xs)) - 1)"
  using assms 
  unfolding is_last_nonzero_def
  using length_takeWhile'[of "\<lambda> x. x = 0" "rev xs" "length (takeWhile (\<lambda> x. x = 0) (rev xs))"]
  apply (auto simp add: dropWhile_eq_drop rev_nth)
  using length_takeWhile'[of "\<lambda> x. x = 0" "rev xs" "length (takeWhile (\<lambda> x. x = 0) (rev xs))"]
  apply (smt Suc_diff_Suc Suc_mono diff_diff_cancel diff_less_mono2 less_imp_le less_trans_Suc)
  using length_takeWhile'[of "\<lambda> x. x = 0" "rev xs" "length (takeWhile (\<lambda> x. x = 0) (rev xs))"]
  apply (metis in_set_conv_nth length_rev nat_neq_iff set_rev)
  using length_takeWhile'[of "\<lambda> x. x = 0" "rev xs" "length (takeWhile (\<lambda> x. x = 0) (rev xs))"]
  apply (metis in_set_conv_nth length_rev set_rev)
  using length_takeWhile'[of "\<lambda> x. x = 0" "rev xs" "length (takeWhile (\<lambda> x. x = 0) (rev xs))"]
  apply (metis Nil_is_rev_conv Suc_diff_Suc diff_zero length_greater_0_conv list.size(3) not_less_eq nth_mem set_rev)
  apply (metis gr0I length_greater_0_conv nth_mem)
  using length_takeWhile'[of "\<lambda> x. x = 0" "rev xs" "length (takeWhile (\<lambda> x. x = 0) (rev xs))"] nth_mem
  by force

lemma is_last_nonzero':
  assumes "is_last_nonzero xs i" 
  shows "i = length (dropWhile (\<lambda> x. x = 0) (rev xs)) - 1"
proof-
  have "xs \<noteq> []"
    using `is_last_nonzero xs i`
    unfolding is_last_nonzero_def
    by auto
  thus  ?thesis
    using assms length_takeWhile[of "length xs - i - 1" "rev xs" "\<lambda> x. x = 0"]
    unfolding is_last_nonzero_def
    by (simp add: dropWhile_eq_drop rev_nth)
qed
                                                      
lemma increment_last_nonzero:
  "increment_last_nonzero l l' k \<longleftrightarrow> 
      (let suf = dropWhile (\<lambda>x. x = 0) (rev l);       
           pref_len = length l - length suf
        in suf \<noteq> [] \<and> hd suf + 1 < k \<and> l' = rev (replicate pref_len 0 @ (hd suf + 1) # tl suf))" (is "?lhs \<longleftrightarrow> ?rhs")
proof-
  let ?suf = "dropWhile (\<lambda>x. x = 0) (rev l)"
  let ?pref_len = "length l - length ?suf"

  show ?thesis
  proof
    assume ?lhs
    then obtain i where
    i: "is_last_nonzero l i" "increment l l' i" "l' ! i < k"
      unfolding increment_last_nonzero_def is_last_nonzero_def increment_def
      by metis

    have l: "i < length l" "l ! i \<noteq> 0" "l = take i l @ [l ! i] @ replicate (length l - i - 1) 0"
      using `is_last_nonzero l i`
      unfolding is_last_nonzero_append
      by auto

    have "drop (i + 1) l = replicate (length l - i - 1) 0"
      using l(1) l(2)
      by (subst l(3))(simp add: min_def)

    have l': "length l' = length l" "i < length l" "l' = take i l @ [l ! i + 1] @ (drop (i + 1) l)"
      using `increment l l' i`
      unfolding increment_append
      by metis+


    have "i = length ?suf - 1"
      using `is_last_nonzero l i` is_last_nonzero'[of l i]
      by simp
    hence "?suf \<noteq> []"
      using `is_last_nonzero l i`
      unfolding is_last_nonzero_def
      by auto
    hence "length ?suf = i + 1"
      using `i = length ?suf - 1`
      by simp
    hence "?pref_len = length l - i - 1"
      by simp

    have "rev ?suf = take i l @ [l ! i]"
      using l(1) l(2)
      by (subst l(3)) (simp add: dropWhile_append3)
    hence "?suf = l ! i # rev (take i l)"
      by (metis rev_eq_Cons_iff rev_rev_ident)
    hence "hd ?suf + 1 < k"
      using `l' ! i < k` l'
      by (simp add: nth_append)

    have "rev l' = replicate ?pref_len 0 @ [l ! i + 1] @ rev (take i l)"
      using `drop (i + 1) l = replicate (length l - i - 1) 0` `?pref_len = length l - i - 1`
      by (subst l'(3)) simp
    hence "rev l' = replicate ?pref_len 0 @ [hd ?suf + 1] @ tl ?suf"
      using `?suf = l ! i # rev (take i l)`
      by simp
    hence  "rev (rev l') = rev (replicate ?pref_len 0 @ [hd ?suf + 1] @ tl ?suf)"
      by simp
    thus ?rhs                   
      using `?suf \<noteq> []` `hd ?suf + 1 < k`
      unfolding Let_def
      by simp
  next
    assume "?rhs"
    hence l': "?suf \<noteq> []" "hd ?suf + 1 < k" "l' = rev (replicate ?pref_len 0 @ (hd ?suf + 1) # tl ?suf)"
      unfolding Let_def
      by auto

    let ?i = "length ?suf - 1"

    have l'': "l' = rev (tl ?suf) @ [hd ?suf + 1] @ replicate ?pref_len 0"
      using l'
      by  simp

    show ?lhs
      unfolding increment_last_nonzero_def
    proof (rule_tac x="?i" in exI, safe)
      show "is_last_nonzero l ?i"
      proof (rule is_last_nonzero)
        show "l \<noteq> []"
          using `?suf \<noteq> []`
          by auto
      next
        show "set l \<noteq> {0}"
          using `?suf \<noteq> []`
          using singletonD by auto
      qed

      hence l: "?i < length l" "l ! ?i \<noteq> 0" "l = take ?i l @ [l ! ?i] @ replicate (length l - ?i - 1) 0"
        using is_last_nonzero_append
        by simp_all

      have  "drop (?i + 1) l = replicate (length l - ?i - 1) 0"
        using l(1) l(2)
        by (subst l(3))
           (smt One_nat_def add.right_neutral add_Suc_right append.assoc append_take_drop_id hd_drop_conv_nth l(3) same_append_eq take_hd_drop)
      hence *: "replicate ?pref_len 0 = drop (?i + 1) l"
        using `?suf \<noteq> []`
        by simp
        
      have "rev ?suf = take ?i l @ [l ! ?i]"
        using l(1) l(2)
        by (subst l(3)) (simp add: dropWhile_append3)
      hence "?suf = l ! ?i # rev (take ?i l)"
        by (metis rev_eq_Cons_iff rev_rev_ident)
      hence **: "hd ?suf + 1 = l ! ?i + 1" "rev (tl ?suf) = take ?i l"
        using `?suf \<noteq> []`
        by (metis list.sel(1), metis list.sel(3) rev_rev_ident)

      show "increment l l' ?i"
        unfolding increment_append
      proof safe
        show "l' = take ?i l @ [l ! ?i + 1] @ drop (?i + 1) l"
          using l'' * **
          by simp
      next
        show "length l = length l'"
          using `?suf \<noteq> []` l''
          by (auto simp add: min_def dropWhile_eq_drop)
      next
        show "?i < length l"
          by fact
      qed
    next
      show "l' ! ?i < k"
        using l'' `hd ?suf + 1 < k`
        by  (simp add: nth_append)
    qed
  qed
qed

lemma increment_trailing_zero:
  "increment_trailing_zero l l' \<longleftrightarrow> 
      (let suf = dropWhile (\<lambda>x. x = 0) (rev l);
           pref_len = length l - length suf
        in suf \<noteq> [] \<and> (\<exists> i < pref_len. l' = rev (replicate i 0 @ 1 # replicate (pref_len - i - 1) 0 @ suf)))" (is "?lhs \<longleftrightarrow> ?rhs")
proof-
  let ?suf = "dropWhile (\<lambda>x. x = 0) (rev l)"
  let ?pref_len = "length l - length ?suf"

  show ?thesis
  proof
    assume "?lhs"
    then obtain i j where "is_last_nonzero l i" "j > i" "increment l l' j"
      unfolding increment_trailing_zero_def
      by auto

    have l: "i < length l" "l ! i \<noteq> 0" "l = take i l @ [l ! i] @ replicate (length l - i - 1) 0"
      using `is_last_nonzero l i`
      unfolding is_last_nonzero_append
      by simp_all

    have "drop (i + 1) l = replicate (length l - i - 1) 0"
      using l(1) l(2)
      by (subst l(3))(simp add: min_def)

    have l': "length l = length l'" "j < length l" "l' = take j l @ [l ! j + 1] @ drop (j + 1) l"
      using `increment l l' j`
      unfolding increment_append
      by blast+

    have "take j l = take (i + 1) l @ replicate (j - i - 1) 0"
    proof-
      have "take j l = take (i + 1) l @ take (j - i - 1) (drop (i + 1) l)"
        using `i < j` `j < length l` append_take_drop_id[of "i+1" "take j l"]
        by (auto simp add: min_def drop_take)
      moreover
      have "take (j - i - 1) (drop (i + 1) l) = replicate (j - i - 1) 0"
        using `drop (i + 1) l =  replicate (length l - i - 1) 0` `i < j` `j < length l`
        by (auto  simp add: min_def)
      ultimately
      show ?thesis
        by simp
    qed

    moreover

    have "drop (j + 1) l = replicate (length l - j - 1) 0"
    proof-
      have "drop (j + 1) l = drop (j - i) (drop (i + 1) l)"
        using drop_drop[of "j - i"  "i + 1" l] `i < j`
        by simp
      also have "... = replicate (length l - j - 1) 0"
        using `drop (i + 1) l = replicate (length l - i - 1) 0`  `i < j`
        by simp
      finally
      show ?thesis
        by simp            
    qed

    moreover

    have "l ! j + 1 = 1"
      using `i < j`
      using \<open>is_last_nonzero l i\<close> is_last_nonzero_def l'(2) by auto

    ultimately

    have l'': "l' = take (i + 1) l @ replicate (j - i - 1) 0 @ [1] @ replicate (length l - j - 1) 0"
      using l'
      by (metis append_assoc)

    have "i = length ?suf - 1"
      using `is_last_nonzero l i` is_last_nonzero'[of l i]
      by simp
    hence "?suf \<noteq> []"
      using `is_last_nonzero l i`
      unfolding is_last_nonzero_def
      by auto
    hence "length ?suf = i + 1"
      using `i = length ?suf - 1`
      by simp
    hence "?pref_len = length l - i - 1"
      by simp

    have "rev ?suf = take i l @ [l ! i]"
      using l(1) l(2)
      by (subst l(3)) (simp add: dropWhile_append3)
    hence "rev ?suf = take (i + 1) l"
      using `i < length l`
      using hd_drop_conv_nth take_hd_drop by fastforce
    hence "?suf = rev (take (i + 1) l)"
      by (metis rev_rev_ident)

    let ?j = "length l - j - 1"

    have "?j < ?pref_len"
      using `?pref_len = length l - i - 1` `i < j` `j < length l`
      by simp

    have "rev l' = replicate ?j 0 @ 1 # replicate (?pref_len - ?j - 1) 0 @ ?suf"
      using l'' `?suf = rev (take (i + 1) l)` `?pref_len = length l - i - 1` `i < j` `j < length  l`
      by simp
    hence "l' = rev (replicate ?j 0 @ 1 # replicate (?pref_len - ?j - 1) 0 @ ?suf)"
      by (metis rev_rev_ident)

    thus ?rhs
      using `?suf \<noteq> []` `?j < ?pref_len`
      by metis
  next
    assume ?rhs
    then obtain j where
      l': "?suf \<noteq> []" "j < ?pref_len" "l' = rev (replicate j 0 @ 1 # replicate (?pref_len - j - 1) 0 @ ?suf)"
      unfolding Let_def
      by blast
    hence l'': "l' = rev ?suf @ replicate (?pref_len - j - 1) 0 @ 1 # replicate j 0"
      by simp

    let ?i = "length ?suf - 1"

    show ?lhs
      unfolding increment_trailing_zero_def
    proof (rule_tac x="?i" in exI, safe)
      show  "is_last_nonzero l ?i"
      proof (rule is_last_nonzero)
        show "l \<noteq> []"
          using `?suf \<noteq> []`
          by auto
      next
        show "set l \<noteq> {0}"
          using `?suf \<noteq> []`
          using singletonD by auto
      qed

      hence l: "?i < length l" "l ! ?i \<noteq> 0" "l = take ?i l @ [l ! ?i] @ replicate (length l - ?i - 1) 0"
        using is_last_nonzero_append
        by simp_all

      have "drop (?i + 1) l = replicate (length l - ?i - 1) 0"
        using l(1) l(2)
        by (subst l(3))(simp add: min_def)

      have "rev ?suf = take ?i l @ [l ! ?i]"
        using l(1) l(2)
        by (subst l(3)) (simp add: dropWhile_append3)
      hence "rev ?suf = take (?i + 1) l"
        by (metis One_nat_def add.right_neutral add_Suc_right hd_drop_conv_nth l(1) take_hd_drop)
      hence "?suf = rev (take (?i + 1) l)"
        by (metis rev_rev_ident)

      have "?pref_len = length l - ?i - 1"
        using `?i < length l` `?suf \<noteq> []`
        by auto

      let ?j = "length l - j - 1" 

      show "\<exists>j>length (dropWhile (\<lambda>x. x = 0) (rev l)) - 1. increment l l' j"
      proof (rule_tac x="?j" in exI, safe)
        show  "?i < ?j"
          using `?suf \<noteq> []` `j < ?pref_len` `?pref_len = length l - ?i - 1`
          by (metis cancel_ab_semigroup_add_class.diff_right_commute zero_less_diff)

        show "increment l l' ?j"
          unfolding increment_append
        proof safe
          show "l' = take ?j l @ [l ! ?j + 1] @ drop (?j + 1) l"
          proof-
            have "take ?j l = take (?i + 1) l @ replicate (?j - ?i - 1) 0"
            proof-
              have "take ?j l = take (?i + 1) l @ take (?j - ?i - 1) (drop (?i + 1) l)"
                using `?i < ?j` `j < ?pref_len` append_take_drop_id[of "?i+1" "take ?j l"]
                by (auto simp add: min_def drop_take)
              moreover
              have "take (?j - ?i - 1) (drop (?i + 1) l) = replicate (?j - ?i - 1) 0"
                using `drop (?i + 1) l =  replicate (length l - ?i - 1) 0` `?i < ?j` `j < ?pref_len`
                by (auto  simp add: min_def)
              ultimately
              show ?thesis
                by simp
            qed
            moreover
            have "l ! ?j + 1 = 1"
              using `is_last_nonzero l ?i` `?i < ?j`
              by (simp add: is_last_nonzero_def)
            moreover

            have "drop (?j + 1) l = replicate (length l - ?j - 1) 0"
            proof-
              have "drop (?j + 1) l = drop (?j - ?i) (drop (?i + 1) l)"
                using drop_drop[of "?j - i"  "?i + 1" l] `?i < ?j`
                by simp
              also have "... = replicate (length l - ?j - 1) 0"
                using `drop (?i + 1) l = replicate (length l - ?i - 1) 0`  `?i < ?j`
                by simp
              finally
              show ?thesis
                by simp 
            qed
            hence "drop (?j + 1) l = replicate j 0"
              using `?i < ?j`
              by simp
            moreover
            have "?pref_len - j - 1 = ?j - ?i - 1"
              by (smt Nitpick.size_list_simp(2) cancel_ab_semigroup_add_class.diff_right_commute diff_diff_add l'(1) length_tl plus_1_eq_Suc)
            ultimately
            show ?thesis
              using l'' `rev ?suf = take (?i + 1) l`
              by simp
          qed
        next
          show "length l = length l'"
            using `?suf \<noteq> []` l'' `j < ?pref_len`
            by (auto simp add: min_def dropWhile_eq_drop)
        next
          show "?j < length l"
            using `j < ?pref_len` `?suf \<noteq> []`
            by simp
        qed
      qed
    qed
  qed
qed

lemma increment_any_zero:                         
  "increment_any_zero l l' \<longleftrightarrow> 
      (let suf = dropWhile (\<lambda>x. x = 0) (rev l);
           pref_len = length l - length suf
        in suf = [] \<and> (\<exists> i < pref_len. l' = rev (replicate i 0 @ 1 # replicate (pref_len - i - 1) 0 @ suf)))" (is "?lhs \<longleftrightarrow> ?rhs")
proof-
  let ?suf = "dropWhile (\<lambda>x. x = 0) (rev l)"
  let ?pref_len = "length l - length ?suf"

  show ?thesis
  proof
    assume "?lhs"
    then obtain i where "\<forall>i<length l. l ! i = 0" "increment l l' i"
      unfolding increment_any_zero_def
      by auto

    have l': "length l' = length  l" "i < length l" "l' = take i l @ [l ! i + 1] @ drop (i + 1) l"
      using `increment l l' i`
      unfolding increment_append
      by metis+

    have "?suf = []"
      using `\<forall> i < length l. l ! i = 0` index_of_in_set
      by force

    moreover

    have "l' = rev (replicate (?pref_len - i - 1) 0 @ 1 # replicate i 0 @ ?suf)"
    proof-
      have "take i l = replicate i 0"
        using `\<forall>i<length l. l ! i = 0` `i < length l`
        by (auto intro!: nth_equalityI)
      moreover
      have "drop (i + 1) l = replicate (length l - i - 1) 0"           
        using `\<forall>i<length l. l ! i = 0` `i < length l`
        by (auto intro!: nth_equalityI)
      ultimately
      show ?thesis
        using l' `\<forall>i<length l. l ! i = 0` `i < length l`
        by (simp add: `?suf = []`)
    qed

    moreover

    have "?pref_len - i - 1 < ?pref_len"
      using `i < length l`
      by (simp add: `?suf = []`)

    ultimately

    show ?rhs
      unfolding Let_def
      by (smt Suc_diff_Suc Suc_eq_plus1 add_diff_cancel_right' diff_diff_cancel diff_zero l'(2) less_imp_le_nat list.size(3))

  next

    assume ?rhs
    then obtain i where l': "?suf = []" "i < ?pref_len" "l' = rev (replicate i 0 @ 1 # replicate (?pref_len - i - 1) 0 @ ?suf)"
      unfolding Let_def
      by blast

    have "\<forall> i < length l. l ! i = 0"
      using `?suf  = []`
      by simp

    have "l' = replicate (?pref_len - i - 1) 0 @ 1 # replicate i 0"
      using l'
      by simp
    hence "increment l l' (?pref_len - i - 1)"
      using `i < ?pref_len` `\<forall> i < length l. l ! i = 0`
      unfolding increment_append
      by (auto simp add: `?suf = []` Suc_diff_Suc intro!: nth_equalityI)
    thus ?lhs                   
      using `\<forall> i < length l. l ! i = 0`
      unfolding increment_any_zero_def
      by auto
  qed
qed

lemma set_augment_part:
  assumes "k > 1"
  shows "l' \<in> set (augment_part k l) \<longleftrightarrow> increment_after_last_nonzero l l' k"
proof-
  have "l' \<in> set (augment_part k l) \<longleftrightarrow> increment_last_nonzero l l' k \<or> increment_trailing_zero l l' \<or> increment_any_zero l l'"
    apply (subst increment_last_nonzero[of l l' k])
    apply (subst increment_trailing_zero[of l l'])
    apply (subst increment_any_zero[of l l'])        
    unfolding augment_part_def Let_def
    by auto
    
  thus ?thesis
    using increment_after_last_nonzero[OF assms]
    by simp
qed

subsubsection \<open>Properties of the augmentation procedure\<close>
                                              
lemma augment_part_k:
  assumes "k > 1" "set l \<subseteq> {0..<k}"
  shows "\<forall> s \<in> set (augment_part k l). set s \<subseteq> {0..<k}" 
proof
  fix s
  assume "s \<in> set (augment_part k l)"
  hence "increment_after_last_nonzero l s k"
    using set_augment_part[OF `k > 1`, of s l]
    by simp
  thus "set s \<subseteq> {0..<k}"
    using assms
    unfolding increment_after_last_nonzero_def
    apply (auto simp add: in_set_conv_nth)
    apply (metis atLeast0LessThan lessThan_iff nth_mem subsetCE)+
    done
qed

lemma augment_part_k':
  assumes "k > 1" "\<exists> s \<in> set (augment_part k l). set s \<subseteq> {0..<k}"
  shows "set l \<subseteq> {0..<k}" 
proof-
  from assms obtain s where s: "s \<in> set (augment_part k l)" "set s \<subseteq> {0..<k}"
    by auto
  hence "increment_after_last_nonzero l s k"
    using set_augment_part[OF `k > 1`, of s l]
    by simp
  thus "set l \<subseteq> {0..<k}"
    using `set s \<subseteq> {0..<k}`
    unfolding increment_after_last_nonzero_def
    apply (auto simp add: in_set_conv_nth)
    apply (metis atLeast0LessThan lessThan_iff less_SucI not_less_eq nth_mem subsetCE)+
    done
qed
    
lemma augment_part_length:
  assumes "k > 1"
  shows "\<forall> s \<in> set (augment_part k l). length  s = length l"
  using set_augment_part[OF assms]
  by (simp add: increment_after_last_nonzero_def)


lemma augment_part_sum:
  assumes  "k > 1"
  shows "\<forall> s \<in> set (augment_part k l). sum_list s = sum_list l + 1"
proof
  fix s
  assume "s \<in> set (augment_part k l)"
  hence "increment_after_last_nonzero l s k"
    using set_augment_part[OF assms]
    by auto
  thus "sum_list s = sum_list l + 1"
    using increment_after_last_nonzero_sum by blast
qed

lemma sorted_augment: 
  "sorted (augment_part k s)"
proof-
  let ?suf = "dropWhile (\<lambda>x. x = 0) (rev s)"
  let ?pref_len = "length s - length ?suf"
  let ?is = "rev [0..<?pref_len]"
  let ?f = "\<lambda>i. replicate i 0 @ 1 # replicate (?pref_len - i - 1) 0"
  let ?fis = "map ?f ?is"
  let ?l = "map (\<lambda> pref. rev (pref @ ?suf)) ?fis"
  have *: "sorted ?l"
  proof-
    {
      fix i j
      assume "i \<le> j" "j < length ?l"
      hence "?l ! i \<le> ?l ! j"
      proof (cases "i = j")
        case True
        thus ?thesis
          by simp
      next
        case False
        hence "i < j"
          using `i \<le> j`
          by simp
        let ?li = "replicate i 0 @ Suc 0 # replicate (?pref_len - i - 1) 0"
        let ?lj = "replicate j 0 @ Suc 0 # replicate (?pref_len - j - 1) 0"
        have "?li < ?lj"
        proof (rule list_lex_pos)
          show "i < length ?li"
            by auto
        next
          show "i < length ?lj"
            using `i < j`
            by auto
        next
          show "?li ! i > ?lj ! i"
            using `i < j` `j < length ?l` 
            by (simp add: nth_append)
        next
          show "\<forall> p < i. ?li ! p = ?lj ! p"
            using `i < j` `j < length ?l` 
            by (simp add: nth_append)
        qed
        hence "?li \<le> ?lj"
          by simp
        thus ?thesis
          using list_lex_prepend `i < j` `j < length ?l`
          by (auto simp add: rev_nth)
      qed
    }
    thus ?thesis
      unfolding sorted_iff_nth_mono
      by auto
  qed

  show ?thesis
  proof (cases "?suf \<noteq> [] \<and> hd ?suf < k")
    case False
    thus ?thesis
      using *
      unfolding augment_part_def
      by (auto simp add: Let_def)
  next
    case True
    let ?hd = "rev (replicate ?pref_len 0 @ (hd ?suf + 1) # tl ?suf)"
    have "\<forall> i \<in> set (rev [0..<?pref_len]). ?hd \<le>rev (?f i @ ?suf)"
    proof
      fix i
      assume "i \<in> set (rev [0..<?pref_len])"
      hence "i < ?pref_len"
        by auto
      let ?p = "length (tl (dropWhile (\<lambda>x. x = 0) (rev s)))"
      have "?hd < rev (?f i @ ?suf)"
      proof (rule list_lex_pos)
        show "?p < length ?hd"
          by simp
      next
        show "?p < length (rev (?f i @ ?suf))"
          by simp
      next
        show "?hd ! ?p > rev (?f i @ ?suf) ! ?p"
          using True
          by (auto simp add: nth_append rev_nth)
             (metis True hd_conv_nth lessI)
      next
        show "\<forall> p < ?p. ?hd ! p = rev (?f i @ ?suf) ! p"
          using True
          apply (auto simp add: nth_append rev_nth)
          using True hd_dropWhile
          by (smt Nitpick.size_list_simp(2) One_nat_def Suc_diff_Suc Suc_less_eq diff_Suc_less diff_diff_left length_greater_0_conv nth_tl plus_1_eq_Suc)
      qed
      thus "?hd \<le> rev (?f i @ ?suf)"
        by simp
    qed
    thus ?thesis
      using * True
      unfolding augment_part_def
      by (auto simp add: Let_def  sorted_append)
  qed
qed

lemma distinct_augment: 
  "distinct (augment_part k s)"
proof-
  let ?suf = "dropWhile (\<lambda>x. x = 0) (rev s)"
  let ?pref_len = "length s - length ?suf"
  let ?is = "rev [0..<?pref_len]"
  let ?f = "\<lambda>i. replicate i 0 @ (1::nat) # replicate (?pref_len - i - 1) 0"
  let ?fis = "map ?f ?is"
  let ?l = "map (\<lambda> pref. rev (pref @ ?suf)) ?fis"

  let ?h = "rev (replicate ?pref_len 0 @ (hd ?suf + 1) # tl ?suf)"

  have "distinct ?l"
  proof-
    have "inj_on ((\<lambda>pref. rev ?suf @ rev pref) \<circ> (\<lambda>i. ?f i)) {0..<?pref_len}"
      unfolding inj_on_def comp_def
    proof safe
      fix x y
      assume *: "x \<in> {0..<?pref_len}" "?f x = ?f y"
      show "x = y"
      proof (rule ccontr)
        assume "x \<noteq> y"
        hence "?f x ! x = 1" "?f y ! x = 0"
          using *(1)
          by (auto simp add: nth_append)
        hence "(?f x ! x) \<noteq> (?f y ! x)"
          by simp
        moreover           
        have "x < length (?f x)"
          using *
          by auto
        ultimately
        show False
          using * list_eq_iff_nth_eq[of "?f x" "?f y"]
          by auto
      qed
    qed
    thus ?thesis
      by (simp add: distinct_map)
  qed
  moreover
  have "?suf \<noteq> [] \<and> hd ?suf < k - 1 \<longrightarrow> ?h \<notin> set ?l"
  proof (rule impI, erule conjE)
    assume *: "?suf \<noteq> []" "hd ?suf < k - 1"
    have "take ?pref_len (rev ?h) = replicate ?pref_len 0"
      by simp
    moreover
    have "\<forall> x \<in> set ?l. take ?pref_len (rev x) \<noteq> replicate ?pref_len 0"
    proof (rule ccontr)
      assume "\<not> ?thesis"
      then obtain x where "x \<in> set ?l" "take ?pref_len (rev x) = replicate ?pref_len 0"
        by blast
      obtain i where "x = rev (?f i @ ?suf)" "i \<in> set ?is"
        using `x \<in> set ?l`
        by auto
      moreover
      have "length (?f i) = ?pref_len"
        using *
        using `i \<in> set ?is` plus_1_eq_Suc
        by auto
      ultimately
      have "take ?pref_len (rev x) = ?f i"
        using take_append[of ?pref_len "?f i" ?suf]
        by simp
      thus False
        using `take ?pref_len (rev x) = replicate ?pref_len 0`
        using `i \<in> set ?is`
        by (smt Cons_replicate_eq add_diff_cancel_left' append_eq_append_conv append_take_drop_id drop_replicate length_append length_replicate zero_neq_one)
    qed
    ultimately
    show "?h \<notin> set ?l"
      by blast
  qed
  ultimately
  show ?thesis
    unfolding augment_part_def Let_def
    by auto
qed

subsubsection\<open>Inverse of augmentation\<close>
         
definition decrement_nonzero where
  "decrement_nonzero xs ys i \<longleftrightarrow> increment ys xs i"

lemma decrement_nonzero_append:
  shows "decrement_nonzero xs ys i \<longleftrightarrow> 
           length xs = length ys \<and> i < length xs \<and> xs ! i > 0 \<and>
           ys = take i xs @ [xs ! i - 1] @ drop (i + 1) xs"
  apply (auto intro!: nth_equalityI simp add:  decrement_nonzero_def increment_def nth_append nth_Cons min_def split: nat.split)
  using add_diff_inverse_nat apply fastforce
  using add_diff_inverse_nat apply fastforce
  done

lemma decrement_nonzero_gt:
  fixes xs ys :: "nat list"
  assumes "decrement_nonzero xs ys i"
  shows "ys > xs"
  using list_lex_pos[of i xs ys]
  using assms
  unfolding decrement_nonzero_def increment_def
  by auto
             
lemma unique_decrement_nonzero:
  fixes xs ys :: "nat list"             
  assumes "decrement_nonzero xs ys i" "decrement_nonzero xs ys' i"
  shows  "ys = ys'"
proof (rule nth_equalityI)
  show "length ys = length ys'"
    using assms
    unfolding decrement_nonzero_def increment_def
    by auto
next    
  fix i
  assume "i < length ys"
  thus "ys ! i = ys' ! i"
    using assms
    unfolding decrement_nonzero_def increment_def
    by auto metis
qed

lemma unique_decrement_nonzero_i:
  fixes xs ys :: "nat list"             
  assumes "decrement_nonzero xs ys i" "decrement_nonzero xs ys i'"
  shows  "i = i'"
  using assms
  unfolding decrement_nonzero_def increment_def
  by auto


lemma decrement_nonzero_permute_list:                                           
  assumes "decrement_nonzero xs ys p" "pm \<in> set (permute [0..<length xs])"
  shows "\<exists> p. decrement_nonzero (permute_list pm xs) (permute_list pm ys) p"
proof (rule_tac x="perm_inv pm ! p" in exI)
  show  "decrement_nonzero (permute_list pm xs) (permute_list pm ys) (perm_inv pm ! p)"
    unfolding decrement_nonzero_def increment_def
  proof safe
    show "length (permute_list pm ys) = length (permute_list pm xs)"
      using `decrement_nonzero xs ys p`
      unfolding decrement_nonzero_def
      by simp
  next
    show "perm_inv pm ! p < length (permute_list pm ys)"
      using assms perm_inv_set
      using `decrement_nonzero xs ys p`
      unfolding decrement_nonzero_def increment_def
      by auto
  next
    show "permute_list pm xs ! (perm_inv pm ! p) = permute_list pm ys ! (perm_inv pm ! p) + 1"
      using assms perm_inv_set[of pm "length xs"]
      unfolding decrement_nonzero_def increment_def
      by (metis add.commute perm_inv_nth_length perm_perm_inv permute_list_nth)
  next
    fix i'
    assume "i' < length (permute_list pm ys)" "i' \<noteq> perm_inv pm ! p"
    hence "i' < length xs"
      using assms permute_member_length[of pm "[0..<length xs]"]
      by  auto
    moreover
    have "pm ! i' \<noteq> p"
      using `i' \<noteq> perm_inv pm ! p` assms `i' < length xs` perm_inv_perm[of pm xs i']
      by auto
    moreover
    have "pm ! i' < length xs"
      using assms `i' < length xs`
      using permute_member_length[of pm "[0..<length xs]"]
      using permute_member_set
      by fastforce
    ultimately
    show "permute_list pm xs ! i' = permute_list pm ys ! i'"
      using assms `i' < length xs` permute_member_length[of pm "[0..<length xs]"]
      unfolding decrement_nonzero_def increment_def
      by auto
  qed
qed


definition decrement_last_nonzero :: "nat list \<Rightarrow> nat list \<Rightarrow> bool" where
 "decrement_last_nonzero xs ys \<longleftrightarrow> 
    (\<exists> i. is_last_nonzero xs i \<and> decrement_nonzero xs ys i)"
  
lemma decrement_last_nonzero_decrement_nonzero:
  assumes "decrement_last_nonzero xs ys"
  shows "\<exists> i < length xs. decrement_nonzero xs ys i"
  using assms                                         
  unfolding decrement_nonzero_def decrement_last_nonzero_def increment_def
  by  auto

lemma decrement_increment:
  assumes "set xs \<subseteq> {0..<k}" "k > 1"
  shows "decrement_last_nonzero xs ys \<longleftrightarrow> increment_after_last_nonzero ys xs k"
proof
  assume "increment_after_last_nonzero ys xs k"
  then obtain i j where *: "length ys = length xs"
    "i \<le> j \<and>
         j < length ys \<and>
         (i = 0 \<or> ys ! i \<noteq> 0) \<and>
         (\<forall>i'. i < i' \<and> i' < length ys \<longrightarrow> ys ! i' = 0) \<and>
         xs ! j = ys ! j + 1 \<and> ys ! j + 1 < k \<and> (\<forall>i'. i' \<noteq> j \<and> i' < length ys \<longrightarrow> xs ! i' = ys ! i')"
    unfolding increment_after_last_nonzero_def increment_def
    by auto blast+
  thus "decrement_last_nonzero xs ys"
    unfolding decrement_last_nonzero_def is_last_nonzero_def decrement_nonzero_def increment_def
    by (simp, rule_tac x=j in exI, simp)
next
  assume "decrement_last_nonzero xs ys"
  then obtain i where *:  "length xs = length ys"
    "i<length xs \<and>
      (\<forall>i'. i < i' \<and> i' < length xs \<longrightarrow> xs ! i' = 0) \<and>
      (\<forall>i'. i' < length xs \<and> i \<noteq> i' \<longrightarrow> xs ! i' = ys ! i') \<and> xs ! i = ys ! i + 1"
    unfolding decrement_last_nonzero_def is_last_nonzero_def decrement_nonzero_def increment_def
    by metis
  hence "ys \<noteq> []"
    by auto

  show "increment_after_last_nonzero ys xs k"
  proof (cases "set ys = {0}")
    case True
    thus ?thesis
      using * `set xs \<subseteq> {0..<k}` `k > 1` nth_mem
      unfolding increment_after_last_nonzero_def
      by (simp, rule_tac x=0 in exI, rule_tac x=i in exI, force)
  next
    case False
    let ?i = "length (dropWhile (\<lambda> x. x = 0) (rev ys)) - 1"
    have "is_last_nonzero ys ?i"
      using  is_last_nonzero[of ys] `ys \<noteq> []` `set ys \<noteq> {0}`
      by simp

    have "?i \<le> i" 
      using * `is_last_nonzero ys ?i` `ys \<noteq> []` `set ys \<noteq> {0}`
      unfolding is_last_nonzero_def
      by auto
    moreover 

    have "Suc (ys ! i) < k"
      using `set xs \<subseteq> {0..<k}` *
      by auto (metis atLeast0LessThan lessThan_iff nth_mem subsetCE)
    ultimately

    show ?thesis
      using * `set xs \<subseteq> {0..<k}` `is_last_nonzero ys ?i`
      unfolding increment_after_last_nonzero_def is_last_nonzero_def
      by simp (rule_tac x="?i" in exI, rule_tac x=i in exI, simp)
  qed
qed

lemma decrement_last_nonzero_set:
  assumes "set xs \<subseteq> {0..<k}" "xs \<noteq> []" "decrement_last_nonzero xs ys"
  shows "set ys \<subseteq> {0..<k}"
  using assms
  unfolding decrement_last_nonzero_def is_last_nonzero_def decrement_nonzero_def increment_def
  by auto (metis Suc_lessD atLeast0LessThan in_set_conv_nth lessThan_iff subset_eq)

lemma decrement_last_nonzero_sum:
  assumes "xs \<noteq> []" "set xs \<subseteq> {0..<2}" "decrement_last_nonzero xs ys"
  shows "sum_list xs = sum_list ys + 1"
  using assms decrement_increment[of xs 2 ys] increment_after_last_nonzero_sum[of ys xs 2] 
  by simp

lemma decrement_last_nonzero_ex:
  assumes "xs \<noteq> []" "set xs \<noteq> {0}"
  shows "\<exists> ys. decrement_last_nonzero xs ys"
proof-
  from assms obtain i where "xs ! i \<noteq> 0" "i < length xs"
    using is_last_nonzero is_last_nonzero_def
    by blast
  then obtain i' where "is_last_nonzero xs i'"
    using ex_last_nonzero[of i xs]
    by blast
  hence "decrement_last_nonzero xs (xs[i' := xs ! i' - 1])"
    unfolding decrement_last_nonzero_def decrement_nonzero_def is_last_nonzero_def increment_def
    by (rule_tac x=i' in exI) auto
  thus ?thesis
    by  blast
qed

lemma unique_decrement:
  assumes "decrement_last_nonzero xs ys1" "decrement_last_nonzero xs ys2"
  shows "ys1 = ys2"
proof (rule nth_equalityI)
  show "length ys1 = length ys2"
    using assms
    by (auto simp add: decrement_last_nonzero_def decrement_nonzero_def increment_def)
next
  fix i
  assume "i < length ys1"
  from assms obtain i1 i2
    where *: "i1<length xs" "\<forall>i'. i1 < i' \<and> i' < length xs \<longrightarrow> xs ! i' = 0"
          "\<forall>i'. i' < length xs \<and> i1 \<noteq> i' \<longrightarrow> xs ! i' = ys1 ! i'" "xs ! i1 = ys1 ! i1 + 1"
          "i2<length xs" "\<forall>i'. i2 < i' \<and> i' < length xs \<longrightarrow> xs ! i' = 0"
          "\<forall>i'. i' < length xs \<and> i2 \<noteq> i' \<longrightarrow> xs ! i' = ys1 ! i'" "xs ! i2 = ys1 ! i2 + 1"
    unfolding decrement_last_nonzero_def is_last_nonzero_def decrement_nonzero_def increment_def
    by auto

  hence "i1 = i2"
    by auto

  thus "ys1 ! i = ys2 ! i"
    using  * assms `i < length ys1`
    unfolding decrement_last_nonzero_def is_last_nonzero_def decrement_nonzero_def increment_def
    by (metis add_diff_cancel_right' linorder_neqE_nat)
qed


lemma decrement_last_nonzero_weak_mono:
  assumes "sum_list X = sum_list X'" "length X = length X'" 
          "decrement_last_nonzero X Y" "decrement_last_nonzero X' Y'" "X < X'"
  shows "Y \<le> Y'"
proof-
  have "(\<exists> i < min (length X') (length X). take i X' = take i X \<and> X' ! i < X ! i)"
    using assms lexord_take_index_conv[of X' X "{(x, y). x < y}"]
    unfolding list_less_def
    by auto

  then obtain i where "i < length X'" "i < length X" "take i X' = take i X" "X' ! i < X ! i"
    by auto

  obtain j  where "is_last_nonzero X j" "decrement_nonzero X Y j"
    using `decrement_last_nonzero X Y`
    unfolding decrement_last_nonzero_def
    by auto

  obtain j'  where "is_last_nonzero X' j'" "decrement_nonzero X' Y' j'"
    using `decrement_last_nonzero X' Y'`
    unfolding decrement_last_nonzero_def
    by auto

  have "j \<ge> i"
    using `X' ! i < X ! i`
    using `is_last_nonzero X j`
    using \<open>i < length X\<close> is_last_nonzero_def leI
    by force

  have Y:  "X ! j > 0" "Y = take j X @ [X ! j - 1] @ drop (j + 1) X" "j < length X"
    using `decrement_nonzero X Y j`
    unfolding decrement_nonzero_append
    by blast+

  have Y': "X' ! j' > 0" "Y' = take j' X' @ [X' ! j' - 1] @ drop (j' + 1) X'" "j' < length X'"
    using `decrement_nonzero X' Y' j'`
    unfolding decrement_nonzero_append
    by blast+


  have *: "X = take i X @ [X ! i] @ drop (i + 1) X"
    by (metis One_nat_def \<open>i < length X\<close> add.right_neutral add_Suc_right append.assoc append_take_drop_id hd_drop_conv_nth take_hd_drop)
  hence sX: "sum_list X = sum_list (take i X) + X ! i + sum_list (drop (i+1) X)"
    by (metis add.assoc add.right_neutral sum_list.Cons sum_list.Nil sum_list.append)      
  moreover
  have *: "X' = take i X' @ [X' ! i] @ drop (i + 1) X'"
    by (metis One_nat_def \<open>i < length X'\<close> add.right_neutral add_Suc_right append.assoc append_take_drop_id hd_drop_conv_nth take_hd_drop)
  hence sX': "sum_list X' = sum_list (take i X') + X' ! i + sum_list (drop (i+1) X')"
    by (metis add.assoc add.right_neutral sum_list.Cons sum_list.Nil sum_list.append)      
  ultimately
  have "sum_list (drop (i+1) X) < sum_list (drop (i + 1) X')"
    using `take i X' = take i X` `X' ! i < X ! i` `sum_list X = sum_list X'`
    by auto
  hence "sum_list (drop (i + 1) X') > 0"
    by simp
  have "j' > i"
  proof (rule ccontr)                                   
    assume "\<not> ?thesis"
    hence "\<forall> i'. i < i' \<and> i' < length X' \<longrightarrow> X' ! i' = 0"
      using `is_last_nonzero X' j'` `j' < length X'`
      unfolding is_last_nonzero_def
      by auto
    hence  "drop (i+1) X' = replicate (length X' - i - 1) 0"
      by (auto intro!:nth_equalityI)
    hence "sum_list (drop (i+1) X') = 0"
      by simp
    thus False
      using `sum_list (drop (i+1) X') > 0`
      by linarith
  qed
  show ?thesis
  proof (cases "j = i")
    case True
    show ?thesis
    proof (cases "X ! i = X' ! i + 1")
      case True
      show ?thesis
      proof-
        have "sum_list (drop (i+1) X') = sum_list (drop (i+1) X) + 1"
          using sX sX' True `sum_list X = sum_list X'` `take i X' =  take i X`
          by auto
        moreover
        have "\<forall> i'. i < i' \<and> i' < length X \<longrightarrow> X ! i' = 0"
          using `is_last_nonzero X j` `j < length X` `j = i`
          unfolding is_last_nonzero_def
          by auto                              
        hence "drop (i+1) X = replicate (length X - i - 1) 0"
          by (auto intro!:nth_equalityI)
        hence "sum_list (drop (i+1) X) = 0"
          by simp
        ultimately
        have "sum_list (drop (i+1) X') = 1"
          by simp


        have "X' ! j' \<in> set (drop j' X')"
          using `j' < length X'`
          using in_set_conv_nth by fastforce                     
        hence "X' ! j' \<in> set (drop (i + 1) X')"
          using `i < j'` `j' < length X'` set_drop_subset_set_drop[of "i + 1" j' X']
          by auto

        have "X' ! j' = 1 \<and> (\<forall> i'. i' \<noteq> j' \<and> i < i' \<and> i' < length X' \<longrightarrow> X' ! i' = 0)"
        proof safe
          show "X' ! j' = 1"
          proof (rule ccontr)
            assume "\<not> ?thesis"
            hence "X' ! j' > 1"
              using `X' ! j' > 0` 
              by simp
            hence "sum_list (drop (i + 1) X') > 1"
              using `X' ! j' > 1` `X' ! j' \<in> set (drop (i + 1) X')`
              using member_le_sum_list
              by force            
            thus False
              using `sum_list (drop (i + 1) X') = 1`
              by simp
          qed                                                                           
        next
          fix i'
          assume "i' \<noteq> j'" "i < i'" "i' < length X'"
          show "X' ! i' = 0"
          proof (rule ccontr)
            assume "\<not> ?thesis"

            have *: "drop (i+1) X' = map ((!) X') [i+1..<length X']"
              using `i <  length X'`
              by (auto intro!: nth_equalityI)

            show False
            proof (cases "i' < j'")
              case True
              hence "[i+1..<length X'] = [i+1..<i'] @ [i'] @ [i'+1..<j'] @ [j'] @ [j'+1..<length X']"
                using `j' < length X'` `i < length X'` `i < i'`
                using upt_add_eq_append[of "i+1" i' "length X' - i'"] 
                using upt_conv_Cons[of i' "length X'"]
                using upt_add_eq_append[of "i' + 1" j' "length X' - j'"]
                using upt_conv_Cons[of j' "length X'"]
                by simp
              hence "sum_list (map ((!) X') [i+1..<length X']) \<ge> X' ! i' + X' ! j'"
                using sum_list_sum_nth[of "drop (i + 1) X'"]
                by auto
              thus False
                using * `\<not> X' ! i' = 0` `X' ! j' > 0` `sum_list (drop (i+1) X') = 1`
                by simp
            next
              case False
              hence "i' > j'"
                using `i' \<noteq> j'`
                by simp
              hence "[i+1..<length X'] = [i+1..<j'] @ [j'] @ [j'+1..<i'] @ [i'] @ [i'+1..<length X']"
                using `j' < length X'` `i' < length X'` `i < j'` `i < i'`
                using upt_add_eq_append[of "i+1" j' "length X' - j'"] 
                using upt_conv_Cons[of j' "length X'"]
                using upt_add_eq_append[of "j' + 1" i' "length X' - i'"]
                using upt_conv_Cons[of i' "length X'"]
                by simp
              hence "sum_list (map ((!) X') [i+1..<length X']) \<ge> X' ! i' + X' ! j'"
                using sum_list_sum_nth[of "drop (i + 1) X'"]
                by auto
              thus False
                using * `\<not> X' ! i' = 0` `X' ! j' > 0` `sum_list (drop (i+1) X') = 1`
                by simp
            qed
          qed
        qed
        hence "Y' = take i X' @ [X' ! i] @ replicate (length X' - i - 1) 0"
          using `i < j'` `j' < length  X'`
          by (subst Y')
             (auto intro!: nth_equalityI simp add: min_def nth_append nth_Cons split: nat.split)
        moreover
        have "Y = take i X @ [X ! i - 1] @ replicate (length X - i - 1) 0" 
          using `j = i` Y `drop (i + 1) X = replicate (length X - i - 1) 0`
          by blast
        ultimately
        have "Y = Y'"
          using `X ! i = X' ! i + 1` `take i X' = take i X` `i < length X` `i < length  X'` `length X = length X'`
          by  simp
        thus ?thesis
          by simp
      qed
    next
      case False
      show ?thesis
      proof-
        have "take i Y = take i Y'"
          using Y Y' `j' > i` `take i X' = take i X`
          by (smt \<open>i \<le> j\<close> append_take_drop_id diff_is_0_eq' length_take less_imp_le_nat min.absorb2 take_append take_eq_Nil)
        moreover
        have "Y' ! i < Y ! i"
        proof-
          have "Y' ! i = X' ! i"
            using Y' `j' > i`
            by (auto simp add: nth_append)
          moreover
          have "Y ! i = X ! i - 1"
            using Y `j = i`
            by (auto simp add: nth_append)
          ultimately
          show ?thesis
            using `X' ! i < X ! i` `X ! i \<noteq> X' ! i + 1`
            by simp
        qed
        ultimately
        have "Y < Y'"
          using list_lex_pos[of i Y Y']
          by (metis (no_types, hide_lams) True \<open>decrement_nonzero X Y j\<close> \<open>decrement_nonzero X' Y' j'\<close> \<open>i < j'\<close> decrement_nonzero_def increment_def less_trans nth_take)
        thus ?thesis
          by simp
      qed
    qed
  next
    case False
    hence "i < j"
      using `i \<le> j`
      by simp
    show ?thesis
    proof-
      have "take i Y = take i Y'"
        using Y Y' `j' > i` `take i X' = take i X`
        by (smt \<open>i \<le> j\<close> append_take_drop_id diff_is_0_eq' length_take less_imp_le_nat min.absorb2 take_append take_eq_Nil)
      moreover
      have "Y ! i = X ! i"
        using Y `i < j`
        by (auto simp add: nth_append)
      moreover
      have  "Y' ! i = X' ! i"
        using Y' `i < j'`
        by (auto simp add: nth_append)
      ultimately
      have "Y < Y'"
        using list_lex_pos[of i Y Y'] `X' ! i < X ! i`
        by (metis \<open>decrement_nonzero X Y j\<close> \<open>decrement_nonzero X' Y' j'\<close> \<open>i < length X'\<close> \<open>i < length X\<close> decrement_nonzero_append nth_take)
      thus "Y \<le> Y'"
        by simp
    qed
  qed
qed


end