header{* Combinatorics *}

theory Combinatorics
imports Main
  "~~/src/HOL/Library/Permutation"
  "~~/src/HOL/Library/List_lexord"
begin

(* ************************************************************************** *)
subsection{* Generating all permutations *}
(* ************************************************************************** *)

primrec interleave :: "'a \<Rightarrow> 'a list \<Rightarrow> 'a list list" where
  "interleave x [] = [[x]]"
| "interleave x (h # t) = (x # (h # t)) # (map (\<lambda> l. h # l) (interleave x t))"

text{* For example, @{lemma "interleave (1::nat) [2, 3, 4] = [[1, 2, 3, 4], [2, 1, 3, 4], [2, 3, 1, 4], [2, 3, 4, 1]]" by simp}. *}

primrec permute :: "'a list \<Rightarrow> 'a list list" where
  "permute [] = [[]]"
| "permute (h # t) = concat (map (\<lambda> l. interleave h l) (permute t))"

text{* For example, @{lemma "permute [1::nat, 2, 3] = [[1, 2, 3], [2, 1, 3], [2, 3, 1], [1, 3, 2], [3, 1, 2], [3, 2, 1]]" by simp}. *}

lemma multiset_interleave: 
  "p \<in> set (interleave h a) \<Longrightarrow> multiset_of p = multiset_of a + {#h#}"
proof (induct a arbitrary: p) 
  case Nil
  thus ?case
    by simp
next
  case (Cons h' t')
  thus ?case
    using add_commute[of "{#h#}" "{#h'#}"]
    using add_assoc [of "multiset_of t'" "{#h#}" "{#h'#}"]
    using add_assoc [of "multiset_of t'" "{#h'#}" "{#h#}"]
    by auto
qed

lemma isPermutation_permute: 
  "p \<in> set (permute l) \<Longrightarrow> p <~~> l"
proof (induct l arbitrary: p)
  case Nil
  thus ?case
    by (simp add: multiset_of_eq_perm)
next
  case (Cons h t)
  thus ?case
    unfolding multiset_of_eq_perm[THEN sym]
    by (auto simp add: multiset_interleave)
qed

lemma permute_bij:
assumes "p \<in> set (permute l)"
  shows "\<exists> f. bij_betw f {..<length p} {..<length l} \<and>
       (\<forall> i<length p. p ! i = l ! (f i))"
  using assms
  using isPermutation_permute[of p l]
  using permutation_Ex_bij[of p l]
  by auto

(* ************************************************************************** *)
subsection{* Generating all combinations *}
(* ************************************************************************** *)

fun combine_aux :: "'a list \<Rightarrow> nat \<Rightarrow> nat \<Rightarrow> 'a list list" where
 "combine_aux l n k = 
     (if k = 0 then [[]] else 
      if k = n then [l] else
      (case l of 
          [] \<Rightarrow> []
      | (h # t) \<Rightarrow> 
             (map (\<lambda> l'. h # l') (combine_aux t (n-(1::nat)) (k-(1::nat)))) @ 
                   combine_aux t (n-(1::nat)) k))"

definition combine :: "'a list \<Rightarrow> nat \<Rightarrow> 'a list list" where 
  "combine l k = combine_aux l (length l) k"

text{* For example, @{lemma "combine [1::nat, 2, 3] 2 = [[1, 2], [1, 3], [2, 3]]" by (simp add: combine_def)}. *}

lemma combine_aux_combines:
  assumes "sorted l" "distinct l" "n = length l"
  shows "A \<in> set (combine_aux l n k) \<longleftrightarrow> sorted A \<and> distinct A \<and> length A = k \<and> set A \<subseteq> set l"
using assms 
proof (induct l n k  arbitrary: A rule: combine_aux.induct)
  case (1 l n k)
  show ?case
  proof (cases "k = 0")
    case True
    thus ?thesis
      by auto
  next
    case False
    show ?thesis
    proof (cases "k = n")
      case True
      thus ?thesis
        using `k \<noteq> 0` `sorted l` `distinct l` `n = length l`
        using distinct_card[of l] distinct_card[of A]
        using card_seteq[of "set l" "set A"]
        using sorted_distinct_set_unique[of A l]
        by auto
    next
      case False
      show ?thesis
      proof (cases "l = []")
        case True
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n`
          by auto
      next
        case False
        then obtain h t where "l = h # t" by (auto simp add: neq_Nil_conv)
        let ?l1 = "combine_aux t (n-(1::nat)) (k-(1::nat))"
        let ?l2 = "combine_aux t (n-(1::nat)) k"
        have "sorted t"
          using 1(3) `l = h # t`
          by (auto simp add: sorted_Cons)

        have "A \<in> set (combine_aux l n k) = (A \<in> set (map (\<lambda> l'. h # l') ?l1) \<or> A \<in> set ?l2)"
          using `k \<noteq> 0` `k \<noteq> n` `l = h # t`
          by simp
        moreover
        have "A \<in> set ?l2 = (sorted A \<and> distinct A \<and> length A = k \<and> set A \<subseteq> set t)"
          using 1(2)[of h t A]   `k \<noteq> 0` `k \<noteq> n` `l = h # t` `sorted t` 1(4) 1(5)
          by (simp del: combine_aux.simps)
        moreover
        have "A \<in> set (map (\<lambda> l'. h # l') ?l1) = (sorted A \<and> distinct A \<and> length A = k \<and> \<not> set A \<subseteq> set t \<and> set A \<subseteq> set l)"
        proof-
          have "(tl A \<in> set ?l1) =
                (sorted (tl A) \<and> distinct (tl A) \<and> length (tl A) = k - 1 \<and> set (tl A) \<subseteq> set t)"
            using 1(1)[of h t "tl A"] `l = h # t` `sorted t` 1(4) 1(5) `k \<noteq> 0` `k \<noteq> n`
            by simp
          moreover
          have "A \<in> set (map (\<lambda> l'. h # l') ?l1) = (A = h # (tl A) \<and> (tl A \<in> set ?l1))"
            by (auto simp del: combine_aux.simps)
          moreover
          have "\<forall> x \<in> set t. h \<le> x" "h \<notin> set t"
            using `sorted l` `distinct l` `l = h # t`
            by (auto simp add: sorted_Cons)

          have "(A = h # tl A \<and> sorted (tl A) \<and> distinct (tl A) \<and> length A - 1 = k - 1 \<and> set (tl A) \<subseteq> set t) =
                (sorted A \<and> distinct A \<and> length A = k \<and> \<not> set A \<subseteq> set t \<and> set A \<subseteq> insert h (set t))" (is "?lhs = ?rhs")
          proof (rule iffI, (erule_tac[!] conjE)+)
            assume "A = h # tl A" "sorted (tl A)" "distinct (tl A)" "length A - 1 = k - 1" "set (tl A) \<subseteq> set t"
            show ?rhs
            proof (safe)
              show "length A = k"
              proof-
                have "length A \<noteq> 0"
                  using `A = h # tl A`
                  by auto
                show ?thesis
                  using `length A - 1 = k - 1` `k \<noteq> 0` `length A \<noteq> 0`
                  by arith
              qed
            next
              show "sorted A"
                apply (subst `A = h # tl A`, subst sorted_Cons)
                using `sorted (tl A)` `set (tl A) \<subseteq> set t` `\<forall> x \<in> set t. h \<le> x`
                by auto
            next
              show "distinct A"
                apply (subst `A = h # tl A`)
                using `distinct (tl A)` `h \<notin> set t` `set (tl A) \<subseteq> set t`
                by auto
            next
              assume "set A \<subseteq> set t"
              thus "False"
                apply (subst (asm) `A = h # tl A`) 
                using `h \<notin> set t`
                by auto
            next
              fix x
              assume "x \<in> set A" "x \<notin> set t"
              thus "x = h"
                apply (subst (asm) `A = h # tl A`)
                using `set (tl A) \<subseteq> (set t)`
                by auto
            qed
          next
            assume "sorted A" "distinct A" "length A = k" "\<not> set A \<subseteq> set t" "set A \<subseteq> insert h (set t)"
            show "?lhs"
            proof (safe)
              show "sorted (tl A)"
                using `sorted A`
                by (rule sorted_tl)
            next
              show "distinct (tl A)"
                using `distinct A`
                by (rule distinct_tl)
            next
              show "A = h # tl A"
              proof-
                have "h \<in> set A" "A \<noteq> []"
                  using `\<not> set A \<subseteq> set t` `set A \<subseteq> insert h (set t)`
                  by auto
                have "A = hd A # tl A"
                  using `A \<noteq> []`
                  by simp
                show ?thesis
                proof (cases "hd A = h")
                  case True
                  thus ?thesis
                    using `A \<noteq> []`
                    by auto
                next
                  case False
                  from `h \<in> set A` have "h = hd A \<or> h \<in> set (tl A)"
                    by (subst (asm) `A = hd A # tl A`) auto
                  hence "h \<in> set (tl A)"
                    using `hd A \<noteq> h`
                    by auto
                  have "hd A < h"
                    using `sorted A`
                    apply (subst (asm) `A = hd A # tl A`)
                    using `h \<in> set (tl A)` `hd A \<noteq> h`
                    by (auto simp add: sorted_Cons)
                  moreover
                  have "hd A \<in> set t"
                    using `set A \<subseteq> insert h (set t)` 
                    apply (subst (asm) `A = hd A # tl A`)
                    using `hd A \<noteq> h`
                    by simp
                  hence "h \<le> hd A"
                    using `\<forall> x \<in> set t. h \<le> x`
                    by simp
                  ultimately
                  show ?thesis
                    by simp
                qed
              qed

              fix x
              assume "x \<in> set (tl A)"
              show "x \<in> set t"
              proof-
                have "x \<in> set A"
                  using `x \<in> set (tl A)`
                  by (subst `A = h # tl A`) simp
                hence "x \<in> insert h (set t)"
                  using `set A \<subseteq> insert h (set t)`
                  by auto
                have "x \<noteq> h"
                  using `distinct A`
                  apply (subst (asm) `A = h # tl A`) 
                  using  `x \<in> set (tl A)`
                  by auto
                show "x \<in> set t"
                  using `x \<in> insert h (set t)` `x \<noteq> h`
                  by auto
              qed
            next
              show "length A - 1 = k - 1"
                using `length A = k`
                by simp
            qed
          qed
          ultimately
          show ?thesis
            using `l = h # t`
            by (simp del: combine_aux.simps)
        qed
        ultimately
        show ?thesis
          using `l = h # t`
          by (auto simp del: combine_aux.simps)
      qed
    qed
  qed
qed

lemma combine_combines:
  assumes 
  "sorted l" and "distinct l"
  shows
  "A \<in> set (combine l k)  \<longleftrightarrow> (sorted A \<and> distinct A \<and> length A = k \<and> set A \<subseteq> set l)"
using assms
unfolding combine_def
using combine_aux_combines[of l "length l" A k]
by simp

lemma combine_aux_subset:
  assumes "A \<in> set (combine_aux l n k)"
  shows "set A \<subseteq> set l"
using assms
proof (induct l n k arbitrary: A rule: combine_aux.induct)
  case (1 l n k)
  show ?case
  proof (cases "k = 0")
    case True
    thus ?thesis
      using 1(3)
      by auto
  next
    case False
    show ?thesis
    proof (cases "k = n")
      case True
      thus ?thesis
        using `k \<noteq> 0` 1(3)
        by simp
    next
      case False
      show ?thesis
      proof (cases l)
        case Nil
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n` 1(3)
          by simp
      next
        case (Cons h t)
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n` 1(3)
          using combine_aux.simps[of l n k]
          using 1(1)[of h t "tl A"] 1(2)[of h t A]
          by (auto simp del: combine_aux.simps)
      qed
    qed
  qed
qed

lemma combine_aux_length:
  assumes "A \<in> set (combine_aux l n k)" and "length l = n"
  shows "length A = k"
using assms
proof (induct l n k arbitrary: A rule: combine_aux.induct)
  case (1 l n k)
  show ?case
  proof (cases "k = 0")
    case True
    thus ?thesis
      using 1(3)
      by simp
  next
    case False
    show ?thesis
    proof (cases "k = n")
      case True
      thus ?thesis
        using `k \<noteq> 0` 1(3) 1(4)
        by simp
    next
      case False
      show ?thesis
      proof (cases l)
        case Nil
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n` 1(3)
          by simp
      next
        case (Cons h t)
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n` 1(3) 1(4)
          using combine_aux.simps[of l n k]
          using 1(1)[of h t "tl A"] 1(2)[of h t A]
          by (auto simp del: combine_aux.simps)
      qed
    qed
  qed
qed

  
lemma distinct_combine_aux: 
  assumes "n = length l" and "distinct l"
  shows "distinct (combine_aux l n k)"
using assms
proof (induct l n k rule: combine_aux.induct)
  case (1 l n k)
  show ?case
  proof (cases "k = 0")
    case True
    thus ?thesis
      by auto
  next
    case False
    show ?thesis
    proof (cases "k = n")
      case True
      thus ?thesis
        by simp
    next
      case False
      show ?thesis
      proof (cases l)
        case Nil
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n`
          by simp
      next
        case (Cons h t)
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n`
          using combine_aux.simps[of l n k]
          using 1(1)[of h t] 1(2)[of h t] 1(3) 1(4)
          apply (auto simp del: combine_aux.simps simp add: distinct_map inj_on_def)
          using combine_aux_subset[of _ t "length t" k]
          by (force simp del: combine_aux.simps)
      qed
    qed
  qed   
qed

lemma distinct_combine:
  assumes "distinct l"
  shows "distinct (combine l k)"
using assms
using distinct_combine_aux[of "length l" l k]
unfolding combine_def
by simp

lemma sorted_prepend: "sorted l = sorted (map (op # h) l)"
by (induct l) (auto simp add: sorted_Cons)

lemma sorted_combine_aux_lemma:
  fixes h :: "'a::linorder"
  assumes "\<forall>x\<in>set t. h \<le> x" and "h \<notin> set t" and "set l' \<subseteq> set t" and "l' \<noteq> []"
  shows "h # l \<le> l'"
proof-
  have "hd l' \<in> set t"
    using `l' \<noteq> []` `set l' \<subseteq> set t`
    by auto
  hence "h < hd l'"
    using `\<forall>x\<in>set t. h \<le> x` `h \<notin> set t`
    by (cases "h = hd l'") auto
  thus ?thesis
    using `l' \<noteq> []` Cons_le_Cons[of h l "hd l'" "tl l'"]
    by simp
qed

lemma sorted_combine_aux: 
  assumes "n = length l" and "sorted l" and "distinct l"
  shows "sorted (combine_aux l n k)"
using assms
proof (induct l n k rule: combine_aux.induct)
  case (1 l n k)
  show ?case
  proof (cases "k = 0")
    case True
    thus ?thesis
      by auto
  next
    case False
    show ?thesis
    proof (cases "k = n")
      case True
      thus ?thesis
        by simp
    next
      case False
      show ?thesis
      proof (cases l)
        case Nil
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n`
          by simp
      next
        case (Cons h t)
        thus ?thesis
          using `k \<noteq> 0` `k \<noteq> n`
          using combine_aux.simps[of l n k]
          using 1(1)[of h t] 1(2)[of h t] 1(3) 1(4) 1(5)
          apply (auto simp del: combine_aux.simps simp add: distinct_map inj_on_def sorted_Cons sorted_append)
          apply (subst sorted_prepend[THEN sym], simp)
          apply (rule sorted_combine_aux_lemma[of t])
          apply (simp del: combine_aux.simps add: combine_aux_subset)+
          apply (subst length_0_conv[THEN sym])
          using combine_aux_length
          by (force simp del: combine_aux.simps)
      qed
    qed
  qed   
qed

lemma sorted_combine:
  assumes "sorted l" "distinct l"
  shows "sorted (combine l k)"
using assms
using sorted_combine_aux[of "length l" l k]
unfolding combine_def
by simp

end
