header{* FCFamilies *}

theory FCFamilies
imports MoreFun
        Frankl NonEquivalentFamilies SomeShareNegativeImpl
begin

theorem FC_family_non_equivalent_families:
  assumes "set F \<subseteq> set (families n k m)" "set P \<subseteq> set (permute [0..<n])"
  assumes "\<forall> l \<in> set (non_equivalent_families F P). FC_family (f_toSet l)"
  shows "\<forall> l \<in> set F. FC_family (f_toSet l)"
proof (safe)
  fix l
  let ?nef = "non_equivalent_families F P"
  assume "l \<in> set F"
  hence "(\<exists>l'\<in>set ?nef. inj_embed l l')"
    using assms(1) assms(2) non_equivalent_families
    by auto
  then obtain l' where "l' \<in> set ?nef" "inj_embed l l'"
    by auto
  hence "FC_family (f_toSet l')"
    using assms
    by simp
  moreover
  obtain f where "bij_betw f (\<Union> (f_toSet l)) (\<Union> (f_toSet l'))"
    "f_toSet l' = (op ` f) ` f_toSet l"
    using inj_embed_bij_betw[of l l'] `inj_embed l l'`
    by auto
  moreover
  hence "f_toSet l' = op ` f ` f_toSet l"
    unfolding f_toSet_def
    by simp
  ultimately
  show "FC_family (f_toSet l)"
    using FC_family_iso[of f "f_toSet l"]
    unfolding bij_betw_def
    by auto
qed

lemma NKMFamily_nat:
  assumes "k > 0" and "m > 0"
  assumes "card F = m" and "\<forall> A \<in> F. card A = k" and "card (\<Union> F) \<le> n"
  shows "\<exists> f. inj_on f (\<Union> F) \<and> card (op ` f ` F) = m \<and> (\<forall> A \<in> op ` f ` F. card A = k) \<and> \<Union> (op ` f ` F) \<subseteq> {0..<n::nat}"
proof-
  have "finite (\<Union> F)"
    using `k > 0` `m > 0`
    using `card F = m` `\<forall> A \<in> F. card A = k`
    by (auto simp add: finiteUn_iff card_ge_0_finite)
  then obtain f where "bij_betw f (\<Union> F) {0..<card (\<Union> F)}"
    using `card (\<Union> F) \<le> n`
    using ex_bij_betw_finite_nat[of "\<Union> F"]
    by auto
  hence inj: "inj_on f (\<Union> F)"
    unfolding bij_betw_def
    by simp

  let ?F = "op ` f ` F"
  have "\<Union> ?F = f ` (\<Union> F)"
    by auto
  hence "\<Union> ?F \<subseteq> {0..<n}"
    using `bij_betw f (\<Union> F) {0..<card (\<Union> F)::nat}` `card (\<Union> F) \<le> n`
    unfolding bij_betw_def
    by auto
  moreover
  have "card ?F = m" 
    using  `card F = m` inj
    by (simp add: card_iso)
  moreover
  have "\<forall> A \<in> ?F. card A = k"
  proof
    fix A
    assume "A \<in> ?F"
    then obtain A' where "A' \<in> F" "A = f ` A'"
      by auto
    moreover
    hence "inj_on f A'"
      using `inj_on f (\<Union> F)`
      unfolding inj_on_def
      by auto
    ultimately
    show "card A = k"
      using `\<forall> A \<in> F. card A = k` card_image[of f A']
      by simp
  qed
  ultimately
  show ?thesis
    using inj
    by auto
qed

lemma FCFamily_nat:
  assumes "m > 0" and "k > 0"
  assumes "\<And> l. \<lbrakk>card l = m; \<forall> A \<in> l. card A = k; \<Union> l \<subseteq> {0::nat..<n}\<rbrakk> \<Longrightarrow> FC_family l"
  shows "\<And> l. \<lbrakk>card l = m; \<forall> A \<in> l. card A = k; card (\<Union> l) \<le> n\<rbrakk> \<Longrightarrow> FC_family l"
proof-
  fix l
  assume "card l = m" "\<forall>A\<in>l. card A = k" "card (\<Union>l) \<le> n"
  then obtain f where "inj_on f (\<Union>l)"
    "card (op ` f ` l) = m \<and> (\<forall>A\<in>op ` f ` l. card A = k) \<and> \<Union>op ` f ` l \<subseteq> {0..<n}"
    using `k > 0` `m > 0` NKMFamily_nat[of k m l n]
    by auto
  thus "FC_family l"
    using assms(3)
    using FC_family_iso[of f l]
    by auto
qed

(* ************************************************************************** *)
subsection{* Case: 1 *}
(* ************************************************************************** *)

text{* For this simple claim, a direct proof is given. *}
lemma card_1_frankl:
  assumes "{a} \<in> F" and "finite_union_closed F"
  shows "frankl F"
proof-
  let ?Sa = "{S. S \<in> F \<and> a \<in> S}"
  let ?Snoa = "{S. S \<in> F \<and> a \<notin> S}"
  have "\<forall> K \<in> ?Snoa. K \<union> {a} \<in> ?Sa"
    using assms(1) assms(2)
    unfolding Frankl.union_closed_def
    by blast
  moreover
  have "inj_on (\<lambda> K. K \<union> {a}) ?Snoa"
    unfolding inj_on_def
    by auto
  moreover have "finite ?Sa" "finite ?Snoa"
    using assms
    by (auto simp add: finiteUn_iff)
  ultimately
  have "card ?Sa \<ge> card ?Snoa"
    by (subst card_inj_on_le[of "\<lambda> K. K \<union> {a}"]) (simp_all, blast)

  moreover 

  have "?Sa \<inter> ?Snoa = {}" "?Sa \<union> ?Snoa = F"
    by auto
  hence "card F = card ?Sa + card ?Snoa"
    using `finite ?Sa` `finite ?Snoa`
    using card_Un_disjoint[of ?Sa ?Snoa]
    by auto

  ultimately 

  show ?thesis
    using assms
    unfolding frankl_def count_def
    by auto
qed

lemma card_1_frankl':
  assumes "S \<in> F" and "card S = 1" and "finite_union_closed F"
  shows "frankl F"
using assms
using card_1_frankl card_1_iff_singleton[of S]
by force

theorem card_1_FC_family:
  shows "FC_family {{a}}"
unfolding FC_family_def
using card_1_frankl'[of "{a}"]
by auto


(* ************************************************************************** *)
subsection{* Case: 2 *}
(* ************************************************************************** *)

lemma card2_FC_family_nats:
  shows "FC_family {{0::nat, 1}}"
proof (rule FC_family_uce_shares_nonneg)
  let ?w = "(\<lambda> x. 0)(0::nat := 1::nat, 1 := 1)"
  let ?A = "{{0::nat, 1}}"
  show "weight_fun ?w (\<Union> ?A)"
    unfolding weight_fun_def
    by auto
  show "uce_shares_nonneg ?A ?w"
  proof (rule SomeShareNegativeSound_nats)
    let ?A' = "sorted_list_of_set (sorted_list_of_set ` ?A)"
    let ?w' = "Mapping.tabulate (sorted_list_of_set (\<Union> ?A)) ?w"
    have *: "?A' = [[0, 1]]"
            "?w' = tabulate [(0, 1), (1, 1)]"
      unfolding tabulate_def Mapping.tabulate_def Mapping.update_def
      by (auto simp add: fun_upd_twist)
    show "SomeShareNegativeImpl.SomeShareNegative ?A' ?w' = False"
      by (subst *)+ eval
  qed simp_all
qed

theorem card2_FC_family:
  assumes "a \<noteq> b"
  shows "FC_family {{a, b}}"
proof-
  let ?f = "\<lambda> x. if x = a then 0::nat else if x = b then 1 else 2"
  have "inj_on ?f (\<Union> {{a, b}})"
    by auto
  moreover
  have "op ` ?f ` {{a, b}} = {{0, 1}}"
    using `a \<noteq> b`
    by auto
  ultimately
  show ?thesis
    using card2_FC_family_nats
    using FC_family_iso[of ?f "{{a, b}}"]
    by simp
qed

lemma card_2_frankl:
  assumes "a \<noteq> b" and "{a, b} \<in> F" 
  assumes "finite_union_closed F"
  shows "frankl F"
using assms
using card2_FC_family[of a b]
unfolding FC_family_def
by auto

lemma card_2_frankl':
  assumes "S \<in> F" and "card S = 2" and "finite_union_closed F"
  shows "frankl F"
proof-
  from `card S = 2` obtain a b where "a \<noteq> b" "S = {a, b}"
    using card_2_iff_dubleton[of S]
    by auto
  thus ?thesis
    using card_2_frankl[of a b F] `finite_union_closed F` `S \<in> F`
    by auto
qed

(* ************************************************************************** *)
subsection{* Case: 5 3 3 *}
(* ************************************************************************** *)
lemma card_5_3_3_FC_family_case1: 
  shows "FC_family {{0::nat, 1, 2}, {0, 1, 3}, {2, 3, 4}}"
proof (rule FC_family_uce_shares_nonneg)
  let ?w = "(\<lambda> x. 0)(0::nat := 2::nat, 1 := 2, 2 := 2, 3 := 2, 4 := 1)"
  let ?wl = "[(0::nat, 2::nat), (1, 2), (2, 2), (3, 2), (4, 1)]"
  let ?A = "{{0::nat, 1, 2}, {0, 1, 3}, {2, 3, 4}}"
  let ?Al = "[[0::nat, 1, 2], [0, 1, 3], [2, 3, 4]]"

  show "weight_fun ?w (\<Union> ?A)"
    unfolding weight_fun_def
    by auto
  show "uce_shares_nonneg ?A ?w"
  proof (rule SomeShareNegativeSound_nats)
    let ?A' = "sorted_list_of_set (sorted_list_of_set ` ?A)"
    let ?w' = "Mapping.tabulate (sorted_list_of_set (\<Union> ?A)) ?w"
    have *: "?A' = ?Al \<and> ?w' = tabulate ?wl"
    proof-
      have "\<Union>?A = {0..<5}"
        by auto
      hence "sorted_list_of_set (\<Union>?A) = [0..<5]"
        by auto
      hence "map (\<lambda>k. (k, ?w k)) (sorted_list_of_set (\<Union>?A)) = ?wl"
        apply (subst list_eq_iff_nth_eq)
        by auto (subgoal_tac "i = 0", auto)
      thus ?thesis
        unfolding tabulate_def Mapping.tabulate_def Mapping.update_def
        by (auto simp add: fun_upd_twist)
    qed
    show "SomeShareNegativeImpl.SomeShareNegative ?A' ?w' = False"
      by (subst *)+ eval
  qed simp_all
qed

lemma card_5_3_3_frankl_case1: 
  assumes "{{0::nat, 1, 2}, {0, 1, 3}, {2, 3, 4}} \<subseteq> F"
  assumes "finite_union_closed F"
  shows "frankl F"
using assms
using card_5_3_3_FC_family_case1
unfolding FC_family_def
by auto

lemma card_5_3_3_FC_family_case2:
  shows "FC_family {{0::nat, 1, 2}, {0, 1, 3}, {0, 2, 4}}"
proof (rule FC_family_uce_shares_nonneg)
  let ?w = "(\<lambda> x. 0)(0::nat := 6::nat, 1 := 5, 2 := 5, 3 := 3, 4 := 3)"
  let ?wl = "[(0::nat, 6::nat), (1, 5), (2, 5), (3, 3), (4, 3)]"
  let ?A = "{{0::nat, 1, 2}, {0, 1, 3}, {0, 2, 4}}"
  let ?Al = "[[0::nat, 1, 2], [0, 1, 3], [0, 2, 4]]"

  show "weight_fun ?w (\<Union> ?A)"
    unfolding weight_fun_def
    by simp
  show "uce_shares_nonneg ?A ?w"
  proof (rule SomeShareNegativeSound_nats)
    let ?A' = "sorted_list_of_set (sorted_list_of_set ` ?A)"
    let ?w' = "Mapping.tabulate (sorted_list_of_set (\<Union> ?A)) ?w"
    have *: "?A' = ?Al \<and> ?w' = tabulate ?wl"
    proof-
      have "\<Union>?A = {0..<5}"
        by auto
      hence "sorted_list_of_set (\<Union>?A) = [0..<5]"
        by auto
      hence "map (\<lambda>k. (k, ?w k)) (sorted_list_of_set (\<Union>?A)) = ?wl"
        apply (subst list_eq_iff_nth_eq)
        by auto (subgoal_tac "i = 0", auto)
      thus ?thesis
        unfolding tabulate_def Mapping.tabulate_def Mapping.update_def
        by (auto simp add: fun_upd_twist)
    qed
    show "SomeShareNegative ?A' ?w' = False"
      by ((subst *)+) eval
  qed simp_all
qed

lemma card_5_3_3_frankl_case2:
  assumes "{{0::nat, 1, 2}, {0, 1, 3}, {0, 2, 4}} \<subseteq> F"
  assumes "finite_union_closed F"
  shows "frankl F"
using assms
using card_5_3_3_FC_family_case2
unfolding FC_family_def
by simp

lemma card_5_3_3_FC_family_case3:
  shows "FC_family {{0::nat, 1, 2}, {0, 1, 3}, {0, 2, 3}}"
proof (rule FC_family_uce_shares_nonneg)
  let ?w = "(\<lambda> x. 0)(0::nat := 1::nat, 1 := 1, 2 := 1, 3 := 1)"
  let ?wl = "[(0::nat, 1::nat), (1, 1), (2, 1), (3, 1)]"
  let ?A = "{{0::nat, 1, 2}, {0, 1, 3}, {0, 2, 3}}"
  let ?Al = "[[0::nat, 1, 2], [0, 1, 3], [0, 2, 3]]"
  show "weight_fun ?w (\<Union> ?A)"
    by (simp add: weight_fun_def)
  show "uce_shares_nonneg ?A ?w"
  proof (rule SomeShareNegativeSound_nats)
    let ?A' = "sorted_list_of_set (sorted_list_of_set ` ?A)"
    let ?w' = "Mapping.tabulate (sorted_list_of_set (\<Union> ?A)) ?w"
    have *: "?A' = ?Al \<and> ?w' = tabulate ?wl"
    proof-
      have "\<Union>?A = {0..<4}"
        by auto
      hence "sorted_list_of_set (\<Union>?A) = [0..<4]"
        by auto
      hence "map (\<lambda>k. (k, ?w k)) (sorted_list_of_set (\<Union>?A)) = ?wl"
        apply (subst list_eq_iff_nth_eq)
        by auto (subgoal_tac "i = 0", auto)
      thus ?thesis
        unfolding tabulate_def Mapping.tabulate_def Mapping.update_def
        by (auto simp add: fun_upd_twist)
    qed
    show "SomeShareNegative ?A' ?w' = False"
      by ((subst *)+) eval
  qed simp_all
qed

lemma card_5_3_3_frankl_case3:
  assumes "{{0::nat, 1, 2}, {0, 1, 3}, {0, 2, 3}} \<subseteq> F"
  assumes "finite_union_closed F"
  shows "frankl F"
using assms
using card_5_3_3_FC_family_case3
by (simp add: FC_family_def)

lemma card_5_3_3_FC_family_case4:
  shows "FC_family {{0::nat, 1, 2}, {0, 1, 3}, {0, 1, 4}}"
proof (rule FC_family_uce_shares_nonneg)
  let ?w = "(\<lambda> x. 0)(0::nat := 3::nat, 1 := 3, 2 := 2, 3 := 2, 4 := 2)"
  let ?wl = "[(0::nat, 3::nat), (1, 3), (2, 2), (3, 2), (4, 2)]"
  let ?A = "{{0::nat, 1, 2}, {0, 1, 3}, {0, 1, 4}}"
  let ?Al = "[[0::nat, 1, 2], [0, 1, 3], [0, 1, 4]]"
  show "weight_fun ?w (\<Union> ?A)"
    by (simp add: weight_fun_def)
  show "uce_shares_nonneg ?A ?w"
  proof (rule SomeShareNegativeSound_nats)
    let ?A' = "sorted_list_of_set (sorted_list_of_set ` ?A)"
    let ?w' = "Mapping.tabulate (sorted_list_of_set (\<Union> ?A)) ?w"
    have *: "?A' = ?Al \<and> ?w' = tabulate ?wl"
    proof-
      have "\<Union>?A = {0..<5}"
        by auto
      hence "sorted_list_of_set (\<Union>?A) = [0..<5]"
        by auto
      hence "map (\<lambda>k. (k, ?w k)) (sorted_list_of_set (\<Union>?A)) = ?wl"
        apply (subst list_eq_iff_nth_eq)
        by auto (subgoal_tac "i = 0", auto)
      thus ?thesis
        unfolding tabulate_def Mapping.tabulate_def Mapping.update_def
        by (auto simp add: fun_upd_twist)
    qed
    show "SomeShareNegative ?A' ?w' = False"
      by ((subst *)+) eval
  qed simp_all
qed

lemma card_5_3_3_frankl_case4:
  assumes "{{0::nat, 1, 2}, {0, 1, 3}, {0, 1, 4}} \<subseteq> F"
  assumes "finite_union_closed F"
  shows "frankl F"
using assms
using card_5_3_3_FC_family_case4
by (simp add: FC_family_def)

lemma card_5_3_3_FC_family_nat:
  assumes "card l = 3" and "\<forall> A \<in> l. card A = 3" and "\<Union> l \<subseteq> {0::nat..<5}"
  shows "FC_family l"
proof-
  have *: "nef 5 3 3 = 
    [[[0, 1, 2], [0, 1, 3], [2, 3, 4]], 
     [[0, 1, 2], [0, 1, 3], [0, 2, 4]], 
     [[0, 1, 2], [0, 1, 3], [0, 2, 3]],
     [[0, 1, 2], [0, 1, 3], [0, 1, 4]]]"
    by eval
  hence *: "\<forall>l\<in>set (nef 5 3 3). FC_family (f_toSet l)"
    using card_5_3_3_FC_family_case1 card_5_3_3_FC_family_case2 card_5_3_3_FC_family_case3 card_5_3_3_FC_family_case4
    by (simp add: f_toSet_def)
  from assms obtain Fl where 
    "isNKMFamily Fl (5::nat) 3 3 \<and> f_toSet Fl = l"
    using NKM_family_of_set[of 3 3 l 5]
    by auto
  thus  ?thesis 
    using FC_family_non_equivalent_families[of "families 5 3 3" 5 3 3 "permute [0..<5]"]
    using families_NKM *
    by auto
qed

lemma card_5_3_3_frankl_nats:
  assumes 
  "finite_union_closed F" and
  "l \<subseteq> F" and "card l = 3" and "\<forall> A \<in> l. card A = 3" and "\<Union> l \<subseteq> {0::nat..<5}"
shows
  "frankl F"
using assms
using card_5_3_3_FC_family_nat
by (simp add: FC_family_def)

theorem card_5_3_3_FC_family:
  assumes "card Fc = 3" and "\<forall> A \<in> Fc. card A = 3" and "card (\<Union> Fc) \<le> 5"
  shows "FC_family Fc"
apply (rule FCFamily_nat)
using assms card_5_3_3_FC_family_nat
by auto

lemma card_5_3_3_frankl:
  assumes 
  "finite_union_closed F" and
  "l \<subseteq> F" and "card l = 3" and "\<forall> A \<in> l. card A = 3" and "card (\<Union> l) \<le> 5"
shows
  "frankl F"
using assms card_5_3_3_FC_family
by (auto simp add: FC_family_def)

lemma card_5_3_3_frankl':
  assumes 
  "A \<in> F" and "B \<in> F" and "C \<in> F" and
  "distinct [A, B, C]" and
  "card A = 3" and "card B = 3" and "card C = 3" and
  "card (A \<union> B \<union> C) \<le> 5" and
  "finite_union_closed F"
shows
  "frankl F"
using assms
using card_5_3_3_frankl[of F "{A, B, C}"]
by (simp add: Un_assoc)

text{* The function @{text "check_5_3_3"} checks whether a family
contains a uniform 5 3 3 subfamily. *}

definition check_5_3_3 where
"check_5_3_3 F \<equiv>
  (length (remdups (concat [(F ! 0), (F ! 1), (F ! 2)])) \<le> 5 \<or> 
   length (remdups (concat [(F ! 0), (F ! 1), (F ! 3)])) \<le> 5 \<or>
   length (remdups (concat [(F ! 0), (F ! 2), (F ! 3)])) \<le> 5 \<or>
   length (remdups (concat [(F ! 1), (F ! 2), (F ! 3)])) \<le> 5)"

lemma  check_5_3_3':
  assumes "check_5_3_3 F" and "length F > 3" and "distinct F" and "\<forall> l \<in> set F. distinct l \<and> sorted l"
  shows "\<exists> A B C. distinct [A, B, C] \<and> A \<in> f_toSet F \<and> B \<in> f_toSet F \<and> C \<in> f_toSet F \<and> card (A \<union> B \<union> C) \<le> 5"
proof-
  {
    fix i j k
    assume "i < length F" "j < length F" "k < length F" "distinct [i, j, k]"
      "length (remdups (concat [F ! i, F ! j, F ! k])) \<le> 5"
    have "\<exists> A B C. distinct [A, B, C] \<and> A \<in> f_toSet F \<and> B \<in> f_toSet F \<and> C \<in> f_toSet F \<and> card (A \<union> B \<union> C) \<le> 5"
      apply (rule_tac x="set (F ! i)" in exI)
      apply (rule_tac x="set (F ! j)" in exI)
      apply (rule_tac x="set (F ! k)" in exI)
      using `distinct [i, j, k]` `distinct F`
      using `length (remdups (concat [F ! i, F ! j, F ! k])) \<le> 5` 
      using `i < length F` `j < length F` `k < length F`
      using distinct_card[of "remdups (concat [F ! i, F ! j, F ! k])", THEN sym]
      using distinct_list_distinct_sorted_elems
      using `\<forall> l \<in> set F. distinct l \<and> sorted l`
      by (auto simp add: f_toSet_def Un_assoc sorted_distinct_set_unique)
  } note ** = this

  from `length F > 3` have "F \<noteq> []"
    by auto

  show ?thesis
    using `check_5_3_3 F` `length F > 3` `F \<noteq> []`
    unfolding check_5_3_3_def
    using **[of 0 1 2]
    using **[of 0 1 3]
    using **[of 0 2 3]
    using **[of 1 2 3]
    by auto
qed

lemma  check_5_3_3:
  assumes "check_5_3_3 Fl" and "length Fl > 3" and "distinct Fl" and "\<forall> l \<in> set Fl. distinct l \<and> sorted l"
  shows "\<exists> F. F \<subseteq> f_toSet Fl \<and> card F = 3 \<and> card (\<Union> F) \<le> 5"
proof-
  obtain A B C where 
    "distinct [A, B, C] \<and> A \<in> f_toSet Fl \<and> B \<in> f_toSet Fl \<and> C \<in> f_toSet Fl \<and> card (A \<union> B \<union> C) \<le> 5"
    using assms
    using check_5_3_3'[of Fl]
    by auto
  thus ?thesis
    by (rule_tac x="{A, B, C}" in exI) (simp add: Un_assoc)
qed

(* ************************************************************************** *)
subsection{* Case: 6 3 4 *}
(* ************************************************************************** *)

lemma card_6_3_4_FC_family_case1:
  shows "FC_family {{0::nat, 1, 2}, {0, 3, 4}, {1, 3, 5}, {2, 4, 5}}"
proof (rule FC_family_uce_shares_nonneg)
  let ?w = "(\<lambda> x. 0)(0::nat := 1::nat, 1 := 1, 2 := 1, 3 := 1, 4 := 1, 5 := 1)"
  let ?wl = "[(0::nat, 1::nat), (1, 1), (2, 1), (3, 1), (4, 1), (5, 1)]"
  let ?A = "{{0::nat, 1, 2}, {0, 3, 4}, {1, 3, 5}, {2, 4, 5}}"
  let ?Al = "[[0::nat, 1, 2], [0, 3, 4], [1, 3, 5], [2, 4, 5]]"
  show "weight_fun ?w (\<Union> ?A)"
    by (simp add: weight_fun_def)
  show "uce_shares_nonneg ?A ?w"
  proof (rule SomeShareNegativeSound_nats)
    let ?A' = "sorted_list_of_set (sorted_list_of_set ` ?A)"
    let ?w' = "Mapping.tabulate (sorted_list_of_set (\<Union> ?A)) ?w"
    have *: "?A' = ?Al \<and> ?w' = tabulate ?wl"
    proof-
      have "\<Union>?A = {0..<6}"
        by auto
      hence "sorted_list_of_set (\<Union>?A) = [0..<6]"
        by auto
      hence "map (\<lambda>k. (k, ?w k)) (sorted_list_of_set (\<Union>?A)) = ?wl"
        apply (subst list_eq_iff_nth_eq)
        by auto (subgoal_tac "i = 0", auto)
      thus ?thesis
        unfolding tabulate_def Mapping.tabulate_def Mapping.update_def
        by (auto simp add: fun_upd_twist)
    qed
    show "SomeShareNegative ?A' ?w' = False"
      by ((subst *)+) eval
  qed simp_all
qed

lemma card_6_3_4_frankl_case1: 
  assumes "{{0::nat, 1, 2}, {0, 3, 4}, {1, 3, 5}, {2, 4, 5}} \<subseteq> F"
  assumes "finite_union_closed F"
  shows "frankl F"
using card_6_3_4_FC_family_case1
using assms
by (simp add: FC_family_def)

lemma card_6_3_4_FC_family_case2:
  shows "FC_family {{0::nat, 1, 2}, {0, 1, 3}, {2, 4, 5}, {3, 4, 5}}"
proof (rule FC_family_uce_shares_nonneg)
  let ?w = "(\<lambda> x. 0)(0::nat := 1::nat, 1 := 1, 2 := 1, 3 := 1, 4 := 1, 5 := 1)"
  let ?wl = "[(0::nat, 1::nat), (1, 1), (2, 1), (3, 1), (4, 1), (5, 1)]"
  let ?A = "{{0::nat, 1, 2}, {0, 1, 3}, {2, 4, 5}, {3, 4, 5}}"
  let ?Al = "[[0::nat, 1, 2], [0, 1, 3], [2, 4, 5], [3, 4, 5]]"
  show "weight_fun ?w (\<Union> ?A)"
    by (simp add: weight_fun_def)
  show "uce_shares_nonneg ?A ?w"
  proof (rule SomeShareNegativeSound_nats)
    let ?A' = "sorted_list_of_set (sorted_list_of_set ` ?A)"
    let ?w' = "Mapping.tabulate (sorted_list_of_set (\<Union> ?A)) ?w"
    have *: "?A' = ?Al \<and> ?w' = tabulate ?wl"
    proof-
      have "\<Union>?A = {0..<6}"
        by auto
      hence "sorted_list_of_set (\<Union>?A) = [0..<6]"
        by auto
      hence "map (\<lambda>k. (k, ?w k)) (sorted_list_of_set (\<Union>?A)) = ?wl"
        apply (subst list_eq_iff_nth_eq)
        by auto (subgoal_tac "i = 0", auto)
      thus ?thesis
        unfolding tabulate_def Mapping.tabulate_def Mapping.update_def
        by (auto simp add: fun_upd_twist)
    qed
    show "SomeShareNegative ?A' ?w' = False"
      by ((subst *)+) eval
  qed simp_all
qed

lemma card_6_3_4_frankl_case2:
  assumes "{{0::nat, 1, 2}, {0, 1, 3}, {2, 4, 5}, {3, 4, 5}} \<subseteq> F"
  assumes "finite_union_closed F"
  shows "frankl F"
using card_6_3_4_FC_family_case2
using assms
by (simp add: FC_family_def)

lemma card_6_3_4_FC_family_nat:
  assumes "card l = 4" and "\<forall> A \<in> l. card A = 3" and "\<Union> l \<subseteq> {0::nat..<6}"
  shows "FC_family l"
proof-
  let ?fams = "families 6 3 4"
  let ?fams' = "filter (\<lambda> F. \<not> check_5_3_3 F) ?fams"
  let ?perms = "permute [0..<6]"
  let ?nefams = "non_equivalent_families ?fams' ?perms"
  have *: "?nefams = [
       [[0, 1, 2], [0, 3, 4], [1, 3, 5], [2, 4, 5]],
       [[0, 1, 2], [0, 1, 3], [2, 4, 5], [3, 4, 5]]
    ]"
    by eval
  obtain Fl where "Fl \<in> set ?fams" "f_toSet Fl = l" "isNKMFamily Fl 6 3 4"
    using canonical_family_list[of l 4 3 6]
    using assms
    by auto

  show ?thesis
  proof (cases "check_5_3_3 Fl")
    case True
    then obtain F' where
      "F' \<subseteq> f_toSet Fl" "card F' = 3" "card (\<Union> F') \<le> 5"
      using check_5_3_3[of Fl]
      using `isNKMFamily Fl 6 3 4`
      unfolding isNKMFamily_def
      by auto
    hence "FC_family F'"
      using card_5_3_3_FC_family[of F']
      using `f_toSet Fl = l` `\<forall> A \<in> l. card A = 3`
      using assms
      by (auto simp add: f_toSet_def)
    thus ?thesis
      using `F' \<subseteq> f_toSet Fl` `f_toSet Fl = l`
      by (auto simp add: FC_family_def)
  next
    case False
    hence "Fl \<in> set ?fams'"
      using `Fl \<in> set ?fams`
      by simp
    moreover
    have "\<forall>l\<in>set ?nefams. FC_family (f_toSet l)"
      using * card_6_3_4_FC_family_case1 card_6_3_4_FC_family_case2
      by (simp add: f_toSet_def)
    ultimately
    show ?thesis
      using `f_toSet Fl = l`
      using FC_family_non_equivalent_families[of ?fams' 6 3 4 "permute [0..<6]"]
      by auto
  qed
qed

lemma card_6_3_4_frankl_nats:
assumes
  "finite_union_closed F" and
  "l \<subseteq> F" and "card l = 4" and "\<forall> A \<in> l. card A = 3" "\<Union> l \<subseteq> {0::nat..<6}"
shows
  "frankl F"
using assms card_6_3_4_FC_family_nat
by (auto simp add: FC_family_def)

theorem card_6_3_4_FC_family:
  assumes "card Fc = 4" and "\<forall> A \<in> Fc. card A = 3" and "card (\<Union> Fc) \<le> 6"
  shows "FC_family Fc"
apply (rule FCFamily_nat)
using assms card_6_3_4_FC_family_nat
by auto

lemma card_6_3_4_frankl:
  assumes 
  "finite_union_closed F" and
  "l \<subseteq> F" and "card l = 4" and "\<forall> A \<in> l. card A = 3" and "card (\<Union> l) \<le> 6"
shows
  "frankl F"
using assms card_6_3_4_FC_family
by (auto simp add: FC_family_def)

lemma card_6_3_4_frankl':
  assumes 
  "A \<in> F" and "B \<in> F" and "C \<in> F" and "D \<in> F" and
  "distinct [A, B, C, D]" and
  "card A = 3" and "card B = 3" and "card C = 3" and "card D = 3" and
  "card (A \<union> B \<union> C \<union> D) \<le> 6" and
  "finite_union_closed F"
shows
  "frankl F"
using assms
using card_6_3_4_frankl[of F "{A, B, C, D}"]
by (simp add: Un_assoc)

text{* The function @{text "check_6_3_4"} checks whether a uniform 7 3
4 family contains a uniform 6 3 4 subfamily. *}

definition check_6_3_4 where
 "check_6_3_4 F \<equiv> length (remdups (concat F)) \<le> 6"

lemma  check_6_3_4':
  assumes "check_6_3_4 F" and "length F = 4" and "distinct F" and "\<forall> l \<in> set F. distinct l \<and> sorted l"
  shows "\<exists> A B C D. distinct [A, B, C, D] \<and> A \<in> f_toSet F \<and> B \<in> f_toSet F \<and> C \<in> f_toSet F \<and> D \<in> f_toSet F \<and> card (A \<union> B \<union> C \<union> D) \<le> 6"
proof-
  have "F \<noteq> []" "0 < length F" "1 < length F" "2 < length F" "3 < length F"
    using `length F = 4`
    by auto
  moreover
  have "F = [F ! 0, F ! 1, F ! 2, F ! 3]"
    using `length F = 4`
    using map_nth[of F]
    by (subgoal_tac "[0..<length F] = [0, 1, 2, 3]", auto) eval
  hence "length (remdups (concat [F ! 0, F ! 1, F ! 2, F ! 3])) \<le> 6"
    using `check_6_3_4 F` unfolding check_6_3_4_def
    by simp
  ultimately
  show ?thesis
      apply (rule_tac x="set (F ! 0)" in exI)
      apply (rule_tac x="set (F ! 1)" in exI)
      apply (rule_tac x="set (F ! 2)" in exI)
      apply (rule_tac x="set (F ! 3)" in exI)
      using `distinct F`
      using `length (remdups (concat [F ! 0, F ! 1, F ! 2, F ! 3])) \<le> 6` 
      using `0 < length F` `1 < length F` `2 < length F` `3 < length F`
      using distinct_card[of "remdups (concat [F ! 0, F ! 1, F ! 2, F ! 3])", THEN sym]
      using distinct_list_distinct_sorted_elems[of _ _ F]
      using `\<forall> l \<in> set F. distinct l \<and> sorted l`
      by (auto simp add: f_toSet_def Un_assoc sorted_distinct_set_unique)
qed

lemma  check_6_3_4:
  assumes "check_6_3_4 Fl" and "length Fl = 4" and "distinct Fl" and "\<forall> l \<in> set Fl. distinct l \<and> sorted l"
  shows "\<exists> F. F \<subseteq> f_toSet Fl \<and> card F = 4 \<and> card (\<Union> F) \<le> 6"
proof-
  obtain A B C D where 
    "distinct [A, B, C, D] \<and> A \<in> f_toSet Fl \<and> B \<in> f_toSet Fl \<and> C \<in> f_toSet Fl \<and> D \<in> f_toSet Fl \<and> card (A \<union> B \<union> C \<union> D) \<le> 6"
    using assms
    using check_6_3_4'[of Fl]
    by blast
  thus ?thesis
    by (rule_tac x="{A, B, C, D}" in exI) (simp add: Un_assoc)
qed


(* ************************************************************************** *)
subsection{* Case: 7 3 4 *}
(* ************************************************************************** *)

lemma card_7_3_4_FC_family_case1: 
  shows "FC_family {{0::nat, 1, 2}, {0, 3, 4}, {1, 3, 5}, {2, 4, 6}}"
proof (rule FC_family_uce_shares_nonneg)
  let ?w = "(\<lambda> x. 0)(0::nat := 2::nat, 1 := 2, 2 := 2, 3 := 2, 4 := 2, 5 := 1, 6 := 1)"
  let ?wl = "[(0::nat, 2::nat), (1, 2), (2, 2), (3, 2), (4, 2), (5, 1), (6, 1)]"
  let ?A = "{{0::nat, 1, 2}, {0, 3, 4}, {1, 3, 5}, {2, 4, 6}}"
  let ?Al = "[[0::nat, 1, 2], [0, 3, 4], [1, 3, 5], [2, 4, 6]]"
  show "weight_fun ?w (\<Union> ?A)"
    by (simp add: weight_fun_def)
  show "uce_shares_nonneg ?A ?w"
  proof (rule SomeShareNegativeSound_nats)
    let ?A' = "sorted_list_of_set (sorted_list_of_set ` ?A)"
    let ?w' = "Mapping.tabulate (sorted_list_of_set (\<Union> ?A)) ?w"
    have *: "?A' = ?Al \<and> ?w' = tabulate ?wl"
    proof-
      have "\<Union>?A = {0..<7}"
        by auto
      hence "sorted_list_of_set (\<Union>?A) = [0..<7]"
        by auto
      hence "map (\<lambda>k. (k, ?w k)) (sorted_list_of_set (\<Union>?A)) = ?wl"
        apply (subst list_eq_iff_nth_eq)
        by auto (subgoal_tac "i = 0", auto)
      thus ?thesis
        unfolding tabulate_def Mapping.tabulate_def Mapping.update_def
        by (auto simp add: fun_upd_twist)
    qed

    show "SomeShareNegative ?A' ?w' = False"
      by ((subst * )+) eval
  qed simp_all
qed

lemma card_7_3_4_frankl_case1: 
  assumes "{{0::nat, 1, 2}, {0, 3, 4}, {1, 3, 5}, {2, 4, 6}} \<subseteq> F"
  assumes "finite_union_closed F"
  shows "frankl F"
using assms
using card_7_3_4_FC_family_case1
by (simp add: FC_family_def)

lemma card_7_3_4_FC_family_case2: 
  shows "FC_family {{0::nat, 1, 2}, {0, 3, 4}, {0, 5, 6}, {1, 3, 5}}"
proof (rule FC_family_uce_shares_nonneg)
  let ?w = "(\<lambda> x. 0)(0::nat := 2::nat, 1 := 1, 2 := 1, 3 := 1, 4 := 1, 5 := 1, 6 := 1)"
  let ?wl = "[(0::nat, 2::nat), (1, 1), (2, 1), (3, 1), (4, 1), (5, 1), (6, 1)]"
  let ?A = "{{0::nat, 1, 2}, {0, 3, 4}, {0, 5, 6}, {1, 3, 5}}"
  let ?Al = "[[0::nat, 1, 2], [0, 3, 4], [0, 5, 6], [1, 3, 5]]"

  show "weight_fun ?w (\<Union> ?A)"
    by (simp add: weight_fun_def)
  show "uce_shares_nonneg ?A ?w"
  proof (rule SomeShareNegativeSound_nats)
    let ?A' = "sorted_list_of_set (sorted_list_of_set ` ?A)"
    let ?w' = "Mapping.tabulate (sorted_list_of_set (\<Union> ?A)) ?w"
    have *: "?A' = ?Al \<and> ?w' = tabulate ?wl"
    proof-
      have "\<Union>?A = {0..<7}"
        by auto
      hence "sorted_list_of_set (\<Union>?A) = [0..<7]"
        by auto
      hence "map (\<lambda>k. (k, ?w k)) (sorted_list_of_set (\<Union>?A)) = ?wl"
        apply (subst list_eq_iff_nth_eq)
        by auto (subgoal_tac "i = 0", auto)
      thus ?thesis
        unfolding tabulate_def Mapping.tabulate_def Mapping.update_def
        by (auto simp add: fun_upd_twist)
    qed
    
    show "SomeShareNegative ?A' ?w' = False"
      by ((subst * )+) eval
  qed simp_all
qed

lemma card_7_3_4_frankl_case2: 
  assumes "{{0::nat, 1, 2}, {0, 3, 4}, {0, 5, 6}, {1, 3, 5}} \<subseteq> F"
  assumes "finite_union_closed F"
  shows "frankl F"
using assms card_7_3_4_FC_family_case2
by (simp add: FC_family_def)

lemma card_7_3_4_FC_family_case3:
  shows "FC_family {{0::nat, 1, 2}, {0, 1, 3}, {2, 4, 5}, {4, 5, 6}}"
proof (rule FC_family_uce_shares_nonneg)
  let ?w = "(\<lambda> x. 0)(0::nat := 3::nat, 1 := 3, 2 := 4, 3 := 2, 4 := 3, 5 := 3, 6 := 2)"
  let ?wl = "[(0::nat, 3::nat), (1, 3), (2, 4), (3, 2), (4, 3), (5, 3), (6, 2)]"
  let ?A = "{{0::nat, 1, 2}, {0, 1, 3}, {2, 4, 5}, {4, 5, 6}}"
  let ?Al = "[[0::nat, 1, 2], [0, 1, 3], [2, 4, 5], [4, 5, 6]]"
  show "weight_fun ?w (\<Union> ?A)"
    by (simp add: weight_fun_def)
  show "uce_shares_nonneg ?A ?w"
  proof (rule SomeShareNegativeSound_nats)
    let ?A' = "sorted_list_of_set (sorted_list_of_set ` ?A)"
    let ?w' = "Mapping.tabulate (sorted_list_of_set (\<Union> ?A)) ?w"
    have *: "?A' = ?Al \<and> ?w' = tabulate ?wl"
    proof-
      have "\<Union>?A = {0..<7}"
        by auto
      hence "sorted_list_of_set (\<Union>?A) = [0..<7]"
        by auto
      hence "map (\<lambda>k. (k, ?w k)) (sorted_list_of_set (\<Union>?A)) = ?wl"
        apply (subst list_eq_iff_nth_eq)
        by auto (subgoal_tac "i = 0", auto)
      thus ?thesis
        unfolding tabulate_def Mapping.tabulate_def Mapping.update_def
        by (auto simp add: fun_upd_twist)
    qed
    
    show "SomeShareNegative ?A' ?w' = False"
      by ((subst * )+) eval
  qed simp_all
qed

lemma card_7_3_4_frankl_case3:
  assumes "{{0::nat, 1, 2}, {0, 1, 3}, {2, 4, 5}, {4, 5, 6}} \<subseteq> F"
  assumes "finite_union_closed F"
  shows "frankl F"
using assms card_7_3_4_FC_family_case3
by (simp add: FC_family_def)

lemma card_7_3_4_FC_family_case4:
  shows "FC_family {{0::nat, 1, 2}, {0, 1, 3}, {2, 4, 5}, {3, 4, 6}}"
proof (rule FC_family_uce_shares_nonneg)
  let ?w = "(\<lambda> x. 0)(0::nat := 3::nat, 1 := 3, 2 := 3, 3 := 3, 4 := 2, 5 := 1, 6 := 1)"
  let ?wl = "[(0::nat, 3::nat), (1, 3), (2, 3), (3, 3), (4, 2), (5, 1), (6, 1)]"
  let ?A = "{{0::nat, 1, 2}, {0, 1, 3}, {2, 4, 5}, {3, 4, 6}}"
  let ?Al = "[[0::nat, 1, 2], [0, 1, 3], [2, 4, 5], [3, 4, 6]]"
  show "weight_fun ?w (\<Union> ?A)"
    by (simp add: weight_fun_def)
  show "uce_shares_nonneg ?A ?w"
  proof (rule SomeShareNegativeSound_nats)
    let ?A' = "sorted_list_of_set (sorted_list_of_set ` ?A)"
    let ?w' = "Mapping.tabulate (sorted_list_of_set (\<Union> ?A)) ?w"
    have *: "?A' = ?Al \<and> ?w' = tabulate ?wl"
    proof-
      have "\<Union>?A = {0..<7}"
        by auto
      hence "sorted_list_of_set (\<Union>?A) = [0..<7]"
        by auto
      hence "map (\<lambda>k. (k, ?w k)) (sorted_list_of_set (\<Union>?A)) = ?wl"
        apply (subst list_eq_iff_nth_eq)
        by auto (subgoal_tac "i = 0", auto)
      thus ?thesis
        unfolding tabulate_def Mapping.tabulate_def Mapping.update_def
        by (auto simp add: fun_upd_twist)
    qed

    show "SomeShareNegative ?A' ?w' = False"
      by ((subst * )+) eval
  qed simp_all
qed

lemma card_7_3_4_frankl_case4:
  assumes "{{0::nat, 1, 2}, {0, 1, 3}, {2, 4, 5}, {3, 4, 6}} \<subseteq> F"
  assumes "finite_union_closed F"
  shows "frankl F"
using assms card_7_3_4_FC_family_case4
by (simp add: FC_family_def)

lemma card_7_3_4_FC_family_case5:
  shows "FC_family {{0::nat, 1, 2}, {0, 1, 3}, {0, 4, 5}, {4, 5, 6}}"
proof (rule FC_family_uce_shares_nonneg)
  let ?w = "(\<lambda> x. 0)(0::nat := 6::nat, 1 := 4, 2 := 3, 3 := 3, 4 := 4, 5 := 4, 6 := 2)"
  let ?wl = "[(0::nat, 6::nat), (1, 4), (2, 3), (3, 3), (4, 4), (5, 4), (6, 2)]"
  let ?A = "{{0::nat, 1, 2}, {0, 1, 3}, {0, 4, 5}, {4, 5, 6}}"
  let ?Al = "[[0::nat, 1, 2], [0, 1, 3], [0, 4, 5], [4, 5, 6]]"
  show "weight_fun ?w (\<Union> ?A)"
    by (simp add: weight_fun_def)
  show "uce_shares_nonneg ?A ?w"
  proof (rule SomeShareNegativeSound_nats)
    let ?A' = "sorted_list_of_set (sorted_list_of_set ` ?A)"
    let ?w' = "Mapping.tabulate (sorted_list_of_set (\<Union> ?A)) ?w"
    have *: "?A' = ?Al \<and> ?w' = tabulate ?wl"
    proof-
      have "\<Union>?A = {0..<7}"
        by auto
      hence "sorted_list_of_set (\<Union>?A) = [0..<7]"
        by auto
      hence "map (\<lambda>k. (k, ?w k)) (sorted_list_of_set (\<Union>?A)) = ?wl"
        apply (subst list_eq_iff_nth_eq)
        by auto (subgoal_tac "i = 0", auto)
      thus ?thesis
        unfolding tabulate_def Mapping.tabulate_def Mapping.update_def
        by (auto simp add: fun_upd_twist)
    qed
    
    show "SomeShareNegative ?A' ?w' = False"
      by ((subst * )+) eval
  qed simp_all
qed

lemma card_7_3_4_frankl_case5:
  assumes "{{0::nat, 1, 2}, {0, 1, 3}, {0, 4, 5}, {4, 5, 6}} \<subseteq> F"
  assumes "finite_union_closed F"
  shows "frankl F"
using assms card_7_3_4_FC_family_case5
by (simp add: FC_family_def)

lemma card_7_3_4_FC_family_case6:
  shows "FC_family {{0::nat, 1, 2}, {0, 1, 3}, {0, 4, 5}, {2, 4, 6}}"
proof (rule FC_family_uce_shares_nonneg)
  let ?w = "(\<lambda> x. 0)(0::nat := 3::nat, 1 := 2, 2 := 3, 3 := 1, 4 := 3, 5 := 2, 6 := 2)"
  let ?wl = "[(0::nat, 3::nat), (1, 2), (2, 3), (3, 1), (4, 3), (5, 2), (6, 2)]"
  let ?A = "{{0::nat, 1, 2}, {0, 1, 3}, {0, 4, 5}, {2, 4, 6}}"
  let ?Al = "[[0::nat, 1, 2], [0, 1, 3], [0, 4, 5], [2, 4, 6]]"
  show "weight_fun ?w (\<Union> ?A)"
    by (simp add: weight_fun_def)
  show "uce_shares_nonneg ?A ?w"
  proof (rule SomeShareNegativeSound_nats)
    let ?A' = "sorted_list_of_set (sorted_list_of_set ` ?A)"
    let ?w' = "Mapping.tabulate (sorted_list_of_set (\<Union> ?A)) ?w"
    have *: "?A' = ?Al \<and> ?w' = tabulate ?wl"
    proof-
      have "\<Union>?A = {0..<7}"
        by auto
      hence "sorted_list_of_set (\<Union>?A) = [0..<7]"
        by auto
      hence "map (\<lambda>k. (k, ?w k)) (sorted_list_of_set (\<Union>?A)) = ?wl"
        apply (subst list_eq_iff_nth_eq)
        by auto (subgoal_tac "i = 0", auto)
      thus ?thesis
        unfolding tabulate_def Mapping.tabulate_def Mapping.update_def
        by (auto simp add: fun_upd_twist)
    qed
    
    show "SomeShareNegative ?A' ?w' = False"
      by ((subst * )+) eval
  qed simp_all
qed

lemma card_7_3_4_frankl_case6:
  assumes "{{0::nat, 1, 2}, {0, 1, 3}, {0, 4, 5}, {2, 4, 6}} \<subseteq> F"
  assumes "finite_union_closed F"
  shows "frankl F"
using assms card_7_3_4_FC_family_case6
by (simp add: FC_family_def)

lemma card_7_3_4_FC_family_case7:
  shows "FC_family {{0::nat, 1, 2}, {0, 1, 3}, {0, 4, 5}, {1, 4, 6}}"
proof (rule FC_family_uce_shares_nonneg)
  let ?w = "(\<lambda> x. 0)(0::nat := 2::nat, 1 := 2, 2 := 1, 3 := 1, 4 := 1, 5 := 1, 6 := 1)"
  let ?wl = "[(0::nat, 2::nat), (1, 2), (2, 1), (3, 1), (4, 1), (5, 1), (6, 1)]"
  let ?A = "{{0::nat, 1, 2}, {0, 1, 3}, {0, 4, 5}, {1, 4, 6}}"
  let ?Al = "[[0::nat, 1, 2], [0, 1, 3], [0, 4, 5], [1, 4, 6]]"
  show "weight_fun ?w (\<Union> ?A)"
    by (simp add: weight_fun_def)
  show "uce_shares_nonneg ?A ?w"
  proof (rule SomeShareNegativeSound_nats)
    let ?A' = "sorted_list_of_set (sorted_list_of_set ` ?A)"
    let ?w' = "Mapping.tabulate (sorted_list_of_set (\<Union> ?A)) ?w"
    have *: "?A' = ?Al \<and> ?w' = tabulate ?wl"
    proof-
      have "\<Union>?A = {0..<7}"
        by auto
      hence "sorted_list_of_set (\<Union>?A) = [0..<7]"
        by auto
      hence "map (\<lambda>k. (k, ?w k)) (sorted_list_of_set (\<Union>?A)) = ?wl"
        apply (subst list_eq_iff_nth_eq)
        by auto (subgoal_tac "i = 0", auto)
      thus ?thesis
        unfolding tabulate_def Mapping.tabulate_def Mapping.update_def
        by (auto simp add: fun_upd_twist)
    qed
    
    show "SomeShareNegative ?A' ?w' = False"
      by ((subst * )+) eval
  qed simp_all
qed

lemma card_7_3_4_frankl_case7:
  assumes "{{0::nat, 1, 2}, {0, 1, 3}, {0, 4, 5}, {1, 4, 6}} \<subseteq> F"
  assumes "finite_union_closed F"
  shows "frankl F"
using assms card_7_3_4_FC_family_case7
by (simp add: FC_family_def)

lemma card_7_3_4_FC_family_case8:
  shows "FC_family {{0::nat, 1, 2}, {0, 1, 3}, {0, 4, 5}, {0, 4, 6}}"
proof (rule FC_family_uce_shares_nonneg)
  let ?w = "(\<lambda> x. 0)(0::nat := 2::nat, 1 := 1, 2 := 1, 3 := 1, 4 := 1, 5 := 1, 6 := 1)"
  let ?wl = "[(0::nat, 2::nat), (1, 1), (2, 1), (3, 1), (4, 1), (5, 1), (6, 1)]"
  let ?A = "{{0::nat, 1, 2}, {0, 1, 3}, {0, 4, 5}, {0, 4, 6}}"
  let ?Al = "[[0::nat, 1, 2], [0, 1, 3], [0, 4, 5], [0, 4, 6]]"
  show "weight_fun ?w (\<Union> ?A)"
    by (simp add: weight_fun_def)
  show "uce_shares_nonneg ?A ?w"
  proof (rule SomeShareNegativeSound_nats)
    let ?A' = "sorted_list_of_set (sorted_list_of_set ` ?A)"
    let ?w' = "Mapping.tabulate (sorted_list_of_set (\<Union> ?A)) ?w"
    have *: "?A' = ?Al \<and> ?w' = tabulate ?wl"
    proof-
      have "\<Union>?A = {0..<7}"
        by auto
      hence "sorted_list_of_set (\<Union>?A) = [0..<7]"
        by auto
      hence "map (\<lambda>k. (k, ?w k)) (sorted_list_of_set (\<Union>?A)) = ?wl"
        apply (subst list_eq_iff_nth_eq)
        by auto (subgoal_tac "i = 0", auto)
      thus ?thesis
        unfolding tabulate_def Mapping.tabulate_def Mapping.update_def
        by (auto simp add: fun_upd_twist)
    qed

    show "SomeShareNegative ?A' ?w' = False"
	by ((subst * )+) eval
  qed simp_all
qed

lemma card_7_3_4_frankl_case8:
  assumes "{{0::nat, 1, 2}, {0, 1, 3}, {0, 4, 5}, {0, 4, 6}} \<subseteq> F"
  assumes "finite_union_closed F"
  shows "frankl F"
using assms card_7_3_4_FC_family_case8
by (simp add: FC_family_def)

lemma card_7_3_4_FC_family_nat:
  assumes "card l = 4" and "\<forall> A \<in> l. card A = 3" and "\<Union> l \<subseteq> {0::nat..<7}"
  shows "FC_family l"
proof-
  let ?fams = "families 7 3 4"
  let ?fams' = "filter (\<lambda> F. \<not> check_5_3_3 F \<and> \<not> check_6_3_4 F) ?fams"
  let ?perms = "permute [0..<7]"
  let ?nefams = "non_equivalent_families ?fams' ?perms"
  have *: "?nefams = [
  [[0, 1, 2], [0, 3, 4], [1, 3, 5], [2, 4, 6]],
  [[0, 1, 2], [0, 3, 4], [0, 5, 6], [1, 3, 5]],
  [[0, 1, 2], [0, 1, 3], [2, 4, 5], [4, 5, 6]],
  [[0, 1, 2], [0, 1, 3], [2, 4, 5], [3, 4, 6]],
  [[0, 1, 2], [0, 1, 3], [0, 4, 5], [4, 5, 6]],
  [[0, 1, 2], [0, 1, 3], [0, 4, 5], [2, 4, 6]],
  [[0, 1, 2], [0, 1, 3], [0, 4, 5], [1, 4, 6]],
  [[0, 1, 2], [0, 1, 3], [0, 4, 5], [0, 4, 6]]
    ]"
    by eval

  obtain Fl where "Fl \<in> set ?fams" "f_toSet Fl = l" "isNKMFamily Fl 7 3 4"
    using canonical_family_list[of l 4 3 7]
    using assms
    by auto

  show ?thesis
  proof (cases "check_5_3_3 Fl")
    case True
    then obtain F' where
      "F' \<subseteq> f_toSet Fl" "card F' = 3" "card (\<Union> F') \<le> 5"
      using check_5_3_3[of Fl]
      using `isNKMFamily Fl 7 3 4`
      unfolding isNKMFamily_def
      by auto
    hence "FC_family F'"
      using card_5_3_3_FC_family[of F']
      using `f_toSet Fl = l` `\<forall> A \<in> l. card A = 3`
      using assms
      by (auto simp add: f_toSet_def)
    thus ?thesis
      using `F' \<subseteq> f_toSet Fl` `f_toSet Fl = l`
      by (auto simp add: FC_family_def)
  next
    case False
    show ?thesis
    proof (cases "check_6_3_4 Fl")
      case True
      then obtain F' where
        "F' \<subseteq> f_toSet Fl" "card F' = 4" "card (\<Union> F') \<le> 6"
        using check_6_3_4[of Fl]
        using `isNKMFamily Fl 7 3 4`
        unfolding isNKMFamily_def
        by auto
      hence "FC_family F'"
        using card_6_3_4_FC_family[of F']
        using `f_toSet Fl = l` `\<forall> A \<in> l. card A = 3`
        using assms
        by (auto simp add: f_toSet_def)
      thus ?thesis
        using `F' \<subseteq> f_toSet Fl` `f_toSet Fl = l`
        by (auto simp add: FC_family_def)
    next
      case False
      with `\<not> check_5_3_3 Fl` have "Fl \<in> set ?fams'"
        using `Fl \<in> set ?fams`
        by simp
      moreover
      have "\<forall>l\<in>set ?nefams. FC_family (f_toSet l)"
        using * card_7_3_4_FC_family_case1 card_7_3_4_FC_family_case2
          card_7_3_4_FC_family_case3 card_7_3_4_FC_family_case4
          card_7_3_4_FC_family_case5 card_7_3_4_FC_family_case6
          card_7_3_4_FC_family_case7 card_7_3_4_FC_family_case8
        by (simp add: f_toSet_def)
      ultimately
      show ?thesis
        using `f_toSet Fl = l`
        using FC_family_non_equivalent_families[of ?fams' 7 3 4 "permute [0..<7]"]
        by auto
    qed
  qed
qed

lemma card_7_3_4_frankl_nats:
assumes
  "finite_union_closed F"
  "l \<subseteq> F" and "card l = 4" and "\<forall> A \<in> l. card A = 3" and "\<Union> l \<subseteq> {0::nat..<7}"
shows
  "frankl F"
using card_7_3_4_FC_family_nat assms
by (simp add: FC_family_def)

theorem card_7_3_4_FC_family:
  assumes  "card Fc = 4" and "\<forall> A \<in> Fc. card A = 3" and "card (\<Union> Fc) \<le> 7"
  shows "FC_family Fc"
apply (rule FCFamily_nat)
using assms card_7_3_4_FC_family_nat
by auto

lemma card_7_3_4_frankl:
  assumes 
  "finite_union_closed F" and
  "l \<subseteq> F" and "card l = 4" and "\<forall> A \<in> l. card A = 3" and "card (\<Union> l) \<le> 7"
shows
  "frankl F"
using assms card_7_3_4_FC_family
by (auto simp add: FC_family_def)

lemma card_7_3_4_frankl':
  assumes 
  "A \<in> F" and "B \<in> F" and "C \<in> F" and "D \<in> F" and
  "distinct [A, B, C, D]" and
  "card A = 3" and "card B = 3" and "card C = 3" and "card D = 3" and
  "card (A \<union> B \<union> C \<union> D) \<le> 7"
  "finite_union_closed F"
shows
  "frankl F"
using assms
using card_7_3_4_frankl[of F "{A, B, C, D}"]
by (simp add: Un_assoc)

end
