header{* Auxiliary lemmas about bijective functions *}

theory MoreFun
imports Main
begin

(* -------------------------------------------------------------------------- *)
subsection{* Extending bijective functions *}
(* -------------------------------------------------------------------------- *)

lemma bij_betw_extend:
  fixes X X' :: "'a set" and Y Y' :: "'b set"
  assumes "bij_betw f X Y" and "card X' = card Y'" and "finite X'" "finite Y'" and
          "X \<inter> X' = {}" "Y \<inter> Y' = {}"
  shows "\<exists> f'. bij_betw f' (X \<union> X') (Y \<union> Y') \<and> (\<forall> x \<in> X. f x = f' x)"
proof-
  obtain fa where "bij_betw fa X' Y'"
    using finite_same_card_bij[of X' Y'] `finite X'` `finite Y'` `card X' = card Y'`
    by auto
  let ?f = "\<lambda> x. if x \<in> X then f x else fa x"
  have "bij_betw ?f X Y"
    using `bij_betw f X Y`
    unfolding bij_betw_def inj_on_def
    by auto
  moreover
  have "bij_betw ?f X' Y'"
    using `bij_betw fa X' Y'` `X \<inter> X' = {}`
    unfolding bij_betw_def inj_on_def
    by auto
  ultimately
  show ?thesis
    apply (rule_tac x="?f" in exI)
    using bij_betw_Disj_Un[of X X' Y Y' ?f] `X \<inter> X' = {}` `Y \<inter> Y' = {}`
    by auto
qed

text{* This should hold for every infinite type --- for our
applications, it suffices to consider only @{typ "nat"}. *}
lemma nat_set_extend:
  assumes "finite X"
  shows "\<exists> X'::nat set. finite X' \<and> card X' = n \<and> X \<inter> X' = {}"
proof-
  let ?X' = "{(Max X) + 1 ..< (Max X) + 1 + n}"
  have "X \<inter> ?X' = {}"
  proof (auto)
    fix x
    assume "x \<in> X" "x \<ge> Suc (Max X)"
    have "x \<le> Max X"
      using `finite X` `x \<in> X` Max_ge[of X x]
      by simp
    show False
      using `x \<ge> Suc (Max X)` `x \<le> Max X`
      by simp
  qed
  thus ?thesis
    by (rule_tac x="?X'" in exI) simp_all
qed

lemma bij_betw_inj_extend:
  fixes X::"'a set" and Y::"nat set"
  assumes "bij_betw f X Y" and "finite Y" and "finite X'"
  shows "\<exists> f'. inj_on f' (X \<union> X') \<and> (\<forall> x \<in> X. f' x = f x)"
proof-
  let ?X' = "X' - X"
  obtain Y' where "card ?X' = card Y'" "finite Y'" "Y \<inter> Y' = {}"
    using nat_set_extend[of Y "card ?X'"]
    using `finite X'` `finite Y`
    by force
  thus ?thesis
    using assms
    using bij_betw_extend[of f X Y ?X' Y']
    unfolding bij_betw_def
    by auto
qed

(* -------------------------------------------------------------------------  *)
subsection{* Bijections between the domain of a set family and natural numbers. *}
(* -------------------------------------------------------------------------- *)

lemma bij_card:
  assumes "bij_betw h (\<Union> F) {0..<card (\<Union> F)}"
  assumes "A \<in> F"
  shows "card A = card (h ` A)"
using assms
using card_image[of h A]
unfolding bij_betw_def inj_on_def
by auto

lemma bij_card_Int:
  assumes "bij_betw h (\<Union> F) {0..<card (\<Union> F)}"
  assumes "A \<in> F" and "B \<in> F"
  shows "card (A \<inter> B) = card (h ` A \<inter> h ` B)"
proof-
  have "A \<subseteq> \<Union> F" "B \<subseteq> \<Union> F"
    using `A \<in> F` `B \<in> F`
    by auto
  thus ?thesis
    using assms
    using inj_on_image_Int[of h "\<Union> F" A B, THEN sym]
    using card_image[of h "A \<inter> B"]
    unfolding bij_betw_def inj_on_def
    by simp
qed

lemma bij_card_Un:
  assumes "bij_betw h (\<Union> F) {0..<card (\<Union> F)}" 
  assumes "A \<subseteq> F"
  shows "card (\<Union> A) = card (\<Union> (op ` h ` A))"
proof-
  have "h ` (\<Union> A) = \<Union> (op ` h ` A)"
    by auto
  moreover
  have "inj_on h (\<Union> A)"
    using `bij_betw h (\<Union> F) {0..<card (\<Union> F)}` `A \<subseteq> F`
    unfolding bij_betw_def
    using subset_inj_on[of h "\<Union> F" "\<Union> A"]
    by auto
  ultimately
  show ?thesis
    using card_image[of h "\<Union> A"]
    by simp
qed

lemma bij_card_image_inj:
assumes "bij_betw h (\<Union> F) {0..<card (\<Union> F)}"
shows "inj_on (op ` h) F"
unfolding inj_on_def
proof (rule ballI, rule ballI)
  fix x y
  assume "x \<in> F" "y \<in> F"
  thus "h ` x = h ` y \<longrightarrow> x = y"
    using inj_on_Un_image_eq_iff[of h x y] assms
    unfolding bij_betw_def inj_on_def
    by auto
qed

(* -------------------------------------------------------------------------- *)
subsection{* Bijections betwen distinct lists' elements and natural numbers *}
(* -------------------------------------------------------------------------- *)

definition swap where
  "swap f a b = f (a := f b, b := f a)"

lemma bij_betw_swap:
  assumes "bij_betw f A B" and "a \<in> A" and "b \<in> A"
  shows "bij_betw (swap f a b) A B"
proof (cases "a = b")
  case True
  thus ?thesis
    unfolding swap_def
    using assms
    by simp
next
  case False
  show ?thesis
    unfolding bij_betw_def
  proof
    let ?f = "swap f a b"
    show "inj_on ?f A"
      unfolding inj_on_def
    proof (safe)
      fix x y
      assume "x \<in> A" "y \<in> A" "?f x = ?f y"
      thus "x = y"
        using assms
        unfolding swap_def bij_betw_def inj_on_def
        by (auto split: split_if_asm)
    qed
    
    show "swap f a b ` A = B"
      unfolding swap_def
      using assms
      unfolding bij_betw_def
    proof (auto)
      fix x
      assume "x \<in> A"
      show "f x \<in> f(a := f b, b := f a) ` A"
      proof (cases "x = a")
        case True
        show ?thesis
          apply (rule rev_image_eqI[of b])
          using `x = a` `b \<in> A` `a \<noteq> b`
          by simp_all
      next
        case False
        show ?thesis
        proof (cases "x = b")
          case True
          show ?thesis
            apply (rule rev_image_eqI[of a])
            using `x = b` `a \<in> A` `a \<noteq> b`
            by simp_all
        next
          case False
          show ?thesis
            apply (rule rev_image_eqI[of x])
            using `x \<in> A` `x \<noteq> a` `x \<noteq> b`
            by simp_all
        qed
      qed
    qed
  qed
qed

lemma ex_bij_betw_nat_finite_list:
  assumes "distinct l" and "set l \<subseteq> X" and "finite X"
  shows "\<exists> b. bij_betw b {0..<card X} X \<and> (\<forall> i. i < length l \<longrightarrow> b i = l ! i)"
using assms
proof (induct l rule: rev_induct)
  case Nil
  from `finite X` obtain b where "bij_betw b {0..<card X} X"
    using ex_bij_betw_nat_finite
    by auto
  thus ?case
    by auto
next
  case (snoc a l')
  then obtain b where "bij_betw b {0..<card X} X" "\<forall>i<length l'. b i = l' ! i"
    by auto
        
  have "a \<in> b ` {0..<card X}"
    using `bij_betw b {0..<card X} X` snoc(3)
    unfolding bij_betw_def
    by auto
  then obtain k where "k \<in> {0..<card X}" "b k = a"
    by auto

  let ?n = "length l'"

  have "?n \<in> {0..<card X}"
    using snoc(2) snoc(3)
    using distinct_card[of "l' @ [a]"]
    using card_mono[of X "set (l' @ [a])"] `finite X`
    by auto

  show ?case
  proof(rule exI, rule conjI)
    let ?b = "swap b k ?n"
    show "bij_betw ?b {0..<card X} X"
      apply (rule bij_betw_swap)
      using `bij_betw b {0..<card X} X` `?n \<in> {0..<card X}` `k \<in> {0..<card X}`
      by simp_all

    have "length l' \<le> k"
      apply (rule ccontr) 
      using `\<forall>i<length l'. b i = l' ! i` `b k = a` snoc(2)
      by auto

    show "\<forall>i<length (l' @ [a]). ?b i = (l' @ [a]) ! i"
      using `\<forall>i<length l'. b i = l' ! i` `b k = a` `k \<ge> length l'`
      unfolding swap_def
      by (auto simp add: nth_append)
  qed
qed

lemma ex_bij_betw_nat_finite_list_inv:
  assumes "distinct l" and "set l \<subseteq> X" and "finite X"
  shows "\<exists> b. bij_betw b X {0..<card X}  \<and> (\<forall> i. i < length l \<longrightarrow> b (l ! i) = i)"
proof-
  from assms
  obtain b where "bij_betw b {0..<card X} X" "\<forall>i<length l. b i = l ! i"
    using ex_bij_betw_nat_finite_list[of l X]
    by auto
  let ?b = "inv_into {0..<card X} b"
  show ?thesis
  proof (rule_tac x="?b" in exI, safe)
    show "bij_betw ?b X {0..<card X}"
      using `bij_betw b {0..<card X} X`
      by (rule bij_betw_inv_into)
  next
    fix i
    assume "i < length l"
    hence "l ! i = b i"
      using `\<forall>i<length l. b i = l ! i`
      by simp
    moreover
    have "i \<in> {0..<card X}"
    proof-
      have "length l \<le> card X"
        using assms
        using distinct_card[of l] card_mono[of X "set l"]
        by simp
      thus ?thesis
        using `i < length l`
        by auto
    qed
    ultimately
    show "?b (l ! i) = i"
      using `bij_betw b {0..<card X} X`
      unfolding bij_betw_def
      by auto
  qed
qed

end
