header{* Auxiliary functions about lists *}
theory MoreList
imports Main
begin

lemma ex_list_of_set: 
  assumes "finite A"
  shows "\<exists> l. distinct l \<and> set l = A"
using assms
proof (induct A)
  case empty
  thus ?case
    by auto
next
  case (insert x A')
  then obtain l where "distinct l" "set l = A'"
    by auto
  hence "distinct (x # l)" "set (x # l) = insert x A'"
   using insert(2)
   by auto
  thus ?case
    by blast
qed

lemma map_of_sort_key:
  assumes "distinct P"
  shows "map_of (sort_key snd (zip P (map f P))) = map_of (zip P (map f P))"
proof (rule ext)
  fix x
  show "map_of (sort_key snd (zip P (map f P))) x = map_of (zip P (map f P)) x"
  proof (cases "x \<in> set P")
    case True
    hence "(x, f x) \<in> set (zip P (map f P))" 
          "(x, f x) \<in> set (sort_key snd (zip P (map f P)))"
      by (auto simp add: set_zip in_set_conv_nth)
    moreover
    have "distinct (map fst (sort_key snd (zip P (map f P))))"
      using `distinct P`
      by (auto simp add: distinct_map inj_on_def set_zip intro: distinct_zipI1)
    ultimately
    show ?thesis
      using `distinct P`
      using Some_eq_map_of_iff[of "zip P (map f P)" "f x" x]
      using Some_eq_map_of_iff[of "sort_key snd (zip P (map f P))" "f x" x]
      by simp
  next
    case False
    hence *: "map_of (zip P (map f P)) x = None"
      "map_of (sort_key snd (zip P (map f P))) x = None"
      using map_of_eq_None_iff[of "zip P (map f P)" x]
      using map_of_eq_None_iff[of "sort_key snd (zip P (map f P))" x]
      by auto
    show ?thesis
      by (subst *, subst *) simp
  qed
qed

(* -------------------------------------------------------------------------- *)

lemma sorted_first_min: 
  "\<lbrakk>sorted (x # xs); x' \<in> set xs\<rbrakk> \<Longrightarrow> x \<le> x'"
by (induct xs arbitrary: x)(auto, force)

lemma sorted_tl: 
  "sorted (x # xs) \<Longrightarrow> sorted xs"
by (induct xs) auto

context linorder
begin
inductive sorted_desc :: "'a list \<Rightarrow> bool" where
  Nil [iff]: "sorted_desc []"
| Cons: "\<forall>y\<in>set xs. x \<ge> y \<Longrightarrow> sorted_desc xs \<Longrightarrow> sorted_desc (x # xs)"
end

lemma sorted_desc_single [iff]:
  "sorted_desc [x]"
  by (rule sorted_desc.Cons) auto

lemma sorted_desc_many:
  "x \<ge> y \<Longrightarrow> sorted_desc (y # zs) \<Longrightarrow> sorted_desc (x # y # zs)"
  by (rule sorted_desc.Cons) (cases "y # zs" rule: sorted_desc.cases, auto)

lemma sorted_desc_many_eq [simp, code]:
  "sorted_desc (x # y # zs) \<longleftrightarrow> x \<ge> y \<and> sorted_desc (y # zs)"
  by (auto intro: sorted_desc_many elim: sorted_desc.cases)

lemma sorted_desc_first_max: "\<lbrakk>sorted_desc (x # xs); x' \<in> set xs\<rbrakk> \<Longrightarrow> x \<ge> x'"
by (induct xs arbitrary: x)(auto, force)

lemma sorted_desc_tl:
  "sorted_desc (x # xs) \<Longrightarrow> sorted_desc xs"
by (induct xs) auto

lemma sorted_sorted_desc_rev: "sorted xs = sorted_desc (rev xs)"
by (induct xs rule: rev_induct) (auto simp add: sorted_append elim: sorted_desc.cases)

lemma sorted_negate: "sorted xs = sorted_desc (map (\<lambda> x::'a::linordered_ab_group_add. - x) xs)"
proof (induct xs)
  case Nil
  thus ?case
    by simp
next
  case (Cons x xs)
  thus ?case
    using sorted_tl[of x xs] sorted_desc_tl[of "-x" "map uminus xs"]
    using sorted_first_min[of x xs] sorted_desc_first_max[of "-x" "map uminus xs"]
    by (auto intro!: sorted_desc.Cons sorted.Cons) force
qed

lemma sorted_rev_uminus:
  fixes l::"('a \<times> 'b::linordered_ab_group_add) list"
  shows "sorted (rev (map (\<lambda>(a, b). - b) (sort_key snd l)))"
  apply (subst sorted_sorted_desc_rev)
  using sorted_negate[of "map snd (sort_key snd l)"]
  by (simp add: comp_def split_def)

lemma sorted_takeWhile_snd_neg:
  fixes f :: "'a \<Rightarrow> 'b::linordered_ab_group_add"
  assumes "U = sort_key snd (zip P (map f P))" and "A \<in> set P" and "f A < 0"
  shows "(A, f A) \<in> set (takeWhile (\<lambda> (a, b). b < 0) U)"
proof-
  have "sorted (rev (map (\<lambda>(a, b). - b) U))"
    using sorted_rev_uminus `U = sort_key snd (zip P (map f P))`
    by simp
  thus ?thesis
    using filter_equals_takeWhile_sorted_rev[of "\<lambda> (a, b). -b" "U" "0", THEN sym]
    using `A \<in> set P` `f A < 0` `U = sort_key snd (zip P (map f P))`
    unfolding split_def
    by (auto simp add: zip_map2 zip_same_conv_map)
qed

lemma sorted_map:
  assumes "sorted l" and "\<forall> x y. x \<le> y \<longrightarrow> f x \<le> f y"
  shows "sorted (map f l)"
using assms
by (induct l) (auto simp add: sorted_Cons)

(* -------------------------------------------------------------------------- *)

lemma length_sorted_list_of_set':
  assumes "finite X" and "sorted l" and "distinct l" and "set l = X"
  shows "length l = card X"
using assms
proof (induct X arbitrary: l)
  case empty
  thus ?case
    by simp
next
  case (insert a l')
  have "length l \<noteq> 0"
    using insert(6)
    by auto
  show ?case
    using insert(1) insert(2) insert(3)[of "remove1 a l"] insert(4) insert(5) insert(6)
    apply (auto simp add: sorted_remove1 length_remove1)
    using `length l \<noteq> 0`
    by arith
qed

lemma length_sorted_list_of_set:
  assumes "finite X"
  shows "length (sorted_list_of_set X) = card X"
using assms
using sorted_list_of_set[of X] length_sorted_list_of_set'[of X "sorted_list_of_set X"]
by simp

lemma sorted_list_of_set_inj:
  assumes "finite x" and "finite y"
  assumes "sorted_list_of_set x = sorted_list_of_set y"
  shows "x = y"
proof-
  have "x = set (sorted_list_of_set x)" "y = set (sorted_list_of_set y)"
    using sorted_list_of_set[of x] sorted_list_of_set[of y]
    using `finite x` `finite y`
    by simp_all
  thus ?thesis
    using `sorted_list_of_set x = sorted_list_of_set y`
    by simp
qed

(* -------------------------------------------------------------------------- *)

lemma exists_zip: "\<forall> (x, y) \<in> set L'. y = f x \<Longrightarrow>  L' = zip (map fst L') (map f (map fst L'))"
proof (rule nth_equalityI)
  assume "\<forall> (x, y) \<in> set L'. y = f x"
  show "\<forall> i < length L'. L' ! i = (zip (map fst L') (map f (map fst L'))) ! i"
  proof (safe)
    fix i
    assume "i < length L'"
    hence "snd (L' ! i) = f (fst (L' ! i))"
      using `\<forall> (x, y) \<in> set L'. y = f x`
      using in_set_conv_nth[of "L' ! i" L']
      by auto
    thus "L' ! i = zip (map fst L') (map f (map fst L')) ! i"
      using `i < length L'`
      using surjective_pairing[of "L' ! i"]
      by simp
  qed
qed simp

(* ************************************************************************** *)
(* Power set of a list *)
(* ************************************************************************** *)
primrec ListPow where
  "ListPow [] = [[]]"
| "ListPow (h # t) = 
     (let X = ListPow t in
        X @ map (op # h) X)"

lemma setListPow: "set (map set (ListPow X)) = Pow (set X)"
proof (induct X)
  case Nil
  thus ?case
    by simp
next
  case (Cons a l')
  thus ?case
    using Cons[THEN sym]
    by (auto simp add: Let_def comp_def Pow_insert)
qed

lemma distinctListPow: "distinct A \<Longrightarrow> distinct (ListPow A)"
proof (induct A)
  case Nil
  thus ?case
    by simp
next
  case (Cons a A)
  thus ?case
  proof (auto simp add: Let_def distinct_map inj_on_def)
    fix x
    assume "a \<notin> set A"
    assume "a # x \<in> set (ListPow A)"
    hence "set (a # x) \<in> Pow (set A)"
      using setListPow[of A]
      by (auto simp del: set.simps)
    thus False
      using `a \<notin> set A`
      by simp
  qed
qed

lemma distinctListPowElems:
  assumes 
  "distinct A" and "x \<in> set (ListPow A)"
  shows
  "distinct x"
using assms
proof (induct A arbitrary: x)
  case Nil
  thus ?case
    by simp
next
  case (Cons h t)
  thus ?case
  proof (cases "x \<in> set (ListPow t)")
    case True
    thus ?thesis
      using Cons
      by simp
  next
    case False
    then obtain y where "y \<in> set (ListPow t)" "x = h # y"
      using Cons(3)
      by (auto simp add: Let_def)
    thus ?thesis
      using Cons(2) Cons(1)
      using setListPow[of t]
      by auto
  qed
qed

lemma sortedListPowElems:
  assumes 
  "sorted A" and "x \<in> set (ListPow A)"
  shows
  "sorted x"
using assms
proof (induct A arbitrary: x)
  case Nil
  thus ?case
    by simp
next
  case (Cons t h)
  show ?case
  proof (cases "x \<in> set (ListPow t)")
    case True
    thus ?thesis
      using Cons
      by simp
  next
    case False
    then obtain y where "y \<in> set (ListPow t)" "x = h # y"
      using Cons(4)
      by (auto simp add: Let_def)
    thus ?thesis
      using Cons(1) Cons(2) Cons(3)
      using setListPow[of t]
      using sorted_Cons[of h y]
      by auto
  qed
qed

lemma noPermsListPow:
  assumes 
  "distinct A" "sorted A"
  "x \<in> set (ListPow A)" "y \<in> set (ListPow A)"
  "set x = set y"
  shows "x = y"
using assms
using sortedListPowElems[of A x]
using distinctListPowElems[of A x]
using sortedListPowElems[of A y]
using distinctListPowElems[of A y]
by (simp add: sorted_distinct_set_unique)

(* -------------------------------------------------------------------------- *)

lemma inj_on_fst:
  assumes "\<forall> (x, y) \<in> set l. y = f x" "distinct l"
  shows "inj_on fst (set l)"
using assms
unfolding inj_on_def split_def
by auto (subgoal_tac "b = f aa", auto)

(* -------------------------------------------------------------------------- *)

lemma distinct_list_distinct_sorted_elems: 
  assumes "i \<noteq> j" and "i < length F" and "j < length F" 
  "distinct F" and "\<forall> l \<in> List.set F. distinct l \<and> sorted l"
  shows "List.set (F ! i) \<noteq> List.set (F ! j)"
using assms
using nth_eq_iff_index_eq[of F i j] `distinct F`
using sorted_distinct_set_unique[of "F ! i" "F ! j"]
by auto

end