header{* Auxiliary lemmas about mappings *}

theory MoreMap
imports "~~/src/HOL/Library/Mapping"
begin

definition tabulate  :: "('a \<times> 'b) list \<Rightarrow> ('a, 'b) mapping" where
  "tabulate l = foldl (\<lambda> m a. Mapping.update (fst a) (snd a) m) Mapping.empty l"

lemma  tabulate_map_of: "distinct (map fst l) \<Longrightarrow> tabulate l = Mapping.Mapping (map_of l)"
unfolding tabulate_def
apply (induct l rule: rev_induct)
apply (auto simp add: Mapping.empty_def Mapping.update_def)
by (rule ext) (auto simp add: map_add_dom_app_simps dom_map_of_conv_image_fst)

end
