header{* Auxiliary lemmas about (finite) sets *}

theory MoreSet
imports Main
begin

lemma finiteUn_iff: 
  shows "finite (\<Union> F) \<longleftrightarrow> finite F \<and> (\<forall> S \<in> F. finite S)"
proof (auto dest: finite_UnionD)
  fix S
  assume "finite (\<Union> F)" "S \<in> F"
  hence "S \<subseteq> \<Union> F"
    by auto
  thus "finite S"
    using `finite (\<Union> F)`
    by (auto simp add: finite_subset)
qed

lemma card_1_iff_singleton: 
  shows "card A = 1 \<longleftrightarrow> (\<exists> a. A = {a})"
proof
  assume "card A = 1"
  hence "A \<noteq> {}"
    by auto
  then obtain a where "a \<in> A"
    by auto
  hence "A = {a}"
    using card_Diff_singleton[of A a] `card A = 1`
    using card_0_eq[of "A - {a}"]
    by (auto simp add: card_ge_0_finite)
  thus "\<exists> a. A = {a}"
    by simp
qed auto

lemma card_2_iff_dubleton: 
  shows "card A = 2 \<longleftrightarrow> (\<exists> a b. A = {a, b} \<and> a \<noteq> b)"
proof
  assume "card A = 2"
  hence "A \<noteq> {}"
    by auto
  then obtain a where "a \<in> A"
    by auto
  hence "card (A - {a}) = 1"
    using `card A = 2`
    using card_Diff_singleton[of A a]
    by (auto simp add: card_ge_0_finite)
  then obtain b where "A - {a} = {b}"
    using card_1_iff_singleton[of "A - {a}"]
    by auto
  hence "a \<noteq> b"
    by auto
  moreover
  hence "A = {a, b}"
    using `a \<in> A` `A - {a} = {b}`
    by auto
  ultimately
  show "(\<exists> a b. A = {a, b} \<and> a \<noteq> b)"
    by auto
qed auto

lemma subset_eq_card:
  assumes  "finite F" and "card F \<ge> n"
  shows "\<exists> F'. F' \<subseteq> F \<and> card F' = n"
using assms
proof (induct F rule: finite_induct)
  case empty
  thus ?case
    by simp
next
  case (insert a F)
  thus ?case
  proof (cases "n \<le> card F")
    case True
    thus ?thesis
      using insert(3)
      by auto
  next
    case False
    hence "n = card (insert a F)"
      using insert
      by auto
    thus ?thesis
      by auto
  qed
qed

lemma subset_card_eq:
  assumes "A \<subseteq> B" and "card A = card B" and "finite B"
  shows "A = B"
proof-
  obtain h where "bij_betw h B A"
    using finite_same_card_bij[of B A] assms
    by (auto simp add: finite_subset)
  thus ?thesis
    unfolding bij_betw_def
    using endo_inj_surj[of B h]
    using `A \<subseteq> B` `finite B`
    by auto
qed

lemma card_n_n_aux:
  assumes "A \<noteq> B" and "card A = card B" and "finite A" and "finite B"
  shows "card (A \<union> B) \<noteq> card A"
apply (rule ccontr)
using assms
using subset_card_eq[of A "A \<union> B"]
using subset_card_eq[of B A]
by auto

lemma card_n_n:
  assumes "card A = n" and "card B = n" and "n > 0" and "A \<noteq> B"
  shows "n < card (A \<union> B) \<and> card (A \<union> B) \<le> 2*n"
using assms
using card_mono[of A "A \<inter> B"]
using card_Un_Int[of A B]
using card_gt_0_iff[of A]  card_gt_0_iff[of B]
using card_n_n_aux[of A B]
by auto

end
