header{* SomeShareNegative --- the combinatorial search function *}

theory SomeShareNegative
imports Main Frankl MoreList
begin

text{* 
According to the theorem

@{thm [display] FC_family_uce_shares_nonneg[no_vars]}

to show that a family is an FC family, it suffices to show that there
is no member of union closed extension of a given family with a
negative share. The function @{text "SomeShareNegative"} performs a
combinatorial enumeration of union closed extensions of a given family
and checks whether it contains a family with a negative share with
respect to the given weight function. We give a rather abstract
(nonexecutable) definition of this function and prove its main
properties. This function will be later refined and a more efficient,
executable implementation will be given. *}

fun SomeShareNegative_aux :: "'a set list \<Rightarrow> 'a set set  \<Rightarrow> 'a set set \<Rightarrow> ('a \<Rightarrow> nat) \<Rightarrow> 'a set \<Rightarrow> bool" where
  "SomeShareNegative_aux [] F Init w X = (Family_share F w X < 0)"
| "SomeShareNegative_aux (h # t) F Init w X = 
    (if Family_share F w X + listsum (map (\<lambda> A. set_share A w X) (h # t)) \<ge> 0 then
        False
     else if SomeShareNegative_aux t F Init w X then
        True
     else if h \<in> F then
        False
     else
        SomeShareNegative_aux t (insert_and_close_additional h F Init) Init w X
    )
"

lemma SomeShareNegative_aux_correct:
  assumes "SomeShareNegative_aux L F Init w X = False" and
  "\<forall> A \<in> set L. set_share A w X < 0" and
  "distinct L" and
  "finite F'" and "F' \<supseteq> F" and
  "union_closed_additional F' Init" and
  "\<forall> A \<in> F' - F. set_share A w X < 0 \<longrightarrow> A \<in> List.set L"
  shows "Family_share F' w X \<ge> 0"
using assms
proof (induct L F Init w X rule: SomeShareNegative_aux.induct)
  case (1 F Init w X)
  show ?case
  proof-
    let ?ss = "\<lambda> A. set_share A w X"
    have "setsum ?ss F' = setsum ?ss (F \<union> (F' - F))"
      apply (subst setsum_cong[of F' "F \<union> (F' - F)" ?ss ?ss])
      using `F' \<supseteq> F`
      by auto
    also have "... = setsum ?ss F + setsum ?ss (F' - F)"
      apply (rule setsum_Un_disjoint)
      using `finite F'` `F' \<supseteq> F`
      by (auto simp add: finite_subset)
    finally have "setsum ?ss F' = setsum ?ss F + setsum ?ss (F' - F)"
      .
    moreover
    have "setsum ?ss (F' - F) \<ge> 0"
      apply (rule setsum_nonneg)
      using `\<forall>A\<in>F' - F. set_share A w X < 0 \<longrightarrow> A \<in> set []`
      by force
    moreover
    have "setsum ?ss F \<ge> 0"
      using `SomeShareNegative_aux [] F Init w X = False`
      by (simp add: Family_share_def)
    ultimately
    show ?thesis
      by (simp add: Family_share_def)
  qed
next
  case (2 h t F Init w X)
  let ?ss = "\<lambda> A. set_share A w X"
  show ?case
  proof (cases "Family_share F w X + listsum (map ?ss (h # t)) \<ge> 0")
    case True
    let ?Fp = "{A. A \<in> F' - F \<and> ?ss A \<ge> 0}"
    let ?Fn = "{A. A \<in> F' - F \<and> ?ss A < 0}"
    
    have "(\<Sum>A\<in>F'. ?ss A) =  (\<Sum>A\<in>(F' - F) \<union> F. ?ss A)"
      apply (rule setsum_cong)
      using `F \<subseteq> F'`
      by auto
    also have "... = (\<Sum>A\<in>(F' - F). ?ss A) + (\<Sum>A\<in>F. ?ss A)"
      apply (rule setsum_Un_disjoint)
      using `finite F'` `F' \<supseteq> F`
      by (auto simp add: finite_subset)
    finally have *: "(\<Sum>A\<in>F'. ?ss A) = (\<Sum>A\<in>(F' - F). ?ss A) + (\<Sum>A\<in>F. ?ss A)"
      .
    
    have "(\<Sum>A\<in>(F' - F). ?ss A) = (\<Sum>A\<in>?Fp \<union> ?Fn. ?ss A)"
      by (rule setsum_cong) auto
    also have "... = (\<Sum>A\<in>?Fp. ?ss A) + (\<Sum>A\<in>?Fn. ?ss A)"
      apply (rule setsum_Un_disjoint)
      using `finite F'`
      by auto
    finally have **: "(\<Sum>A\<in>(F' - F). ?ss A) = (\<Sum>A\<in>?Fp. ?ss A) + (\<Sum>A\<in>?Fn. ?ss A)"
      by auto
    
    have "(\<Sum>A\<in>?Fp. ?ss A) \<ge> 0"
      by (rule setsum_nonneg) auto
    hence "(\<Sum>A\<in>F'. ?ss A) \<ge> (\<Sum>A\<in>?Fn. ?ss A) + (\<Sum>A\<in>F. ?ss A)"
      using * **
      by simp
    
    let ?L = "set (h # t)"
    have "listsum (map ?ss (h # t)) = (\<Sum>A\<in>?L. ?ss A)"
      using `distinct (h # t)`
      by (simp add: listsum_distinct_conv_setsum_set)
    moreover
    have "(\<Sum>A\<in>?L. ?ss A) = (\<Sum>A\<in>(?Fn \<union> (?L - ?Fn)). ?ss A)"
      apply (rule setsum_cong)
      using `\<forall>A\<in>F' -  F. ?ss A < 0 \<longrightarrow> A \<in> List.set (h # t)`
      by force auto
    also have "... = (\<Sum>A\<in>?Fn. ?ss A) + (\<Sum>A\<in>(?L - ?Fn). ?ss A)"
      apply (rule setsum_Un_disjoint)
      using `finite F'`
      by auto
    also have "... \<le> (\<Sum>A\<in>?Fn. ?ss A)"
    proof-
      have "(\<Sum>A\<in>(?L - ?Fn). ?ss A) \<le> 0"
        apply (rule setsum_nonpos)
        using `\<forall> A \<in> set (h # t). ?ss A < 0`
        by auto
      thus ?thesis
        by simp
    qed
    finally
    have "Family_share F' w X \<ge> 0"
      using `(\<Sum>A\<in>F'. ?ss A) \<ge> (\<Sum>A\<in>?Fn. ?ss A) + (\<Sum>A\<in>F. ?ss A)`
      using `Family_share F w X + listsum (map ?ss (h # t)) \<ge> 0`
      unfolding Family_share_def
      by simp
    thus ?thesis
      by simp
  next
    case False
    note * = this
    have "\<not> SomeShareNegative_aux t F Init w X"
      using `SomeShareNegative_aux (h # t) F Init w X = False` *
      by auto
    note * = * this
    note * = * `finite F'` `F \<subseteq> F'` `union_closed_additional F' Init`
    have "\<forall>A\<in>set t. ?ss A < 0" "distinct t"
      using `\<forall>A\<in>set (h # t). ?ss A < 0` `distinct (h # t)`
      by auto
    note * = * this
    
    show ?thesis
    proof (cases "h \<in> F")
      case True
      show ?thesis
      proof (rule 2(1))
        show "\<forall>A\<in>F' - F. ?ss A < 0 \<longrightarrow> A \<in> set t"
          using `h \<in> F`
          using `\<forall>A\<in>F' - F. ?ss A < 0 \<longrightarrow>  A \<in> set (h # t)`
          by auto
      next
        show "\<not> 0 \<le> Family_share F w X + listsum (map ?ss (h # t))" 
          using *
          by auto
      qed (auto simp add: *)
    next
      case False
      let ?F' = "insert_and_close_additional h F Init"
      let ?s' = "Family_share ?F' w X"
      show ?thesis
      proof (cases "h \<in> F'")
        case True
        show ?thesis
        proof (rule 2(2))
          show "SomeShareNegative_aux t ?F' Init w X = False" "\<not> h \<in> F"
              "\<not> Family_share F w X + listsum (map ?ss (h # t)) \<ge> 0"
            using `SomeShareNegative_aux (h # t) F Init w X = False` `\<not> h \<in> F` *
            by auto
        next
          show "\<forall> A \<in> F' - ?F'. ?ss A < 0 \<longrightarrow> A \<in> set t"
            using `\<forall> A \<in> F' - F. ?ss A < 0 \<longrightarrow> A \<in> set (h # t)`
            using `h \<notin> F`
            by auto
        next
          show "?F' \<subseteq> F'"
            using `F \<subseteq> F'` `h \<in> F'` `union_closed_additional F' Init`
            by (auto simp add: union_closed_def)
        qed (auto simp add: *)
      next
        case False
        show ?thesis
        proof (rule 2(1))
          show "\<not> Family_share F w X + listsum (map ?ss (h # t)) \<ge> 0"
            using `\<not> Family_share F w X + listsum (map ?ss (h # t)) \<ge> 0`
            .
        next
          show "\<forall>A\<in>F' - F. ?ss A < 0 \<longrightarrow> A \<in> set t"
            using `h \<notin> F'`
            using `\<forall>A\<in>F' - F. ?ss A < 0 \<longrightarrow>  A \<in> set (h # t)`
            by auto
        qed (auto simp add: *)
      qed
    qed
  qed
qed

definition SomeShareNegative :: "'a set set \<Rightarrow> ('a \<Rightarrow> nat) \<Rightarrow> bool" where
"SomeShareNegative A w \<equiv>
  let X = (\<Union> A);
      P = Pow X;
      A = closure A;
      N = {x. x \<in> P \<and> set_share x w X < 0}; 
      L = (SOME L. distinct L \<and> set L = N) in
      SomeShareNegative_aux L {} A w X"

lemma SomeShareNegativeFalse_FamilyShare:
  assumes 
  "SomeShareNegative A w = False" and
  "finite (\<Union> A)" and "F \<in> \<lbrace>A\<rbrace>"
  shows "\<bowtie> F w (\<Union> A) \<ge> 0"
proof (rule SomeShareNegative_aux_correct)
  let ?X = "\<Union> A"
  let ?P = "Pow ?X"
  let ?A = "closure A"
  let ?N = "{x. x \<in> ?P \<and> set_share x w ?X < 0}"
  let ?L = "SOME L. distinct L \<and> set L = ?N"

  have *: "distinct ?L \<and> set ?L = ?N"
  proof (rule someI_ex)
    have "finite ?N"
      using `finite (\<Union> A)`
      by simp
    thus "\<exists> L. distinct L \<and> set L = ?N"
      by (rule ex_list_of_set)
  qed

  show "SomeShareNegative_aux ?L {} ?A w (\<Union> A) = False"
    using assms
    unfolding SomeShareNegative_def Let_def
    by simp

  show "\<forall> a \<in> set ?L. set_share a w (\<Union> A) < 0" "distinct ?L"
    using *
    by simp_all

  show "\<forall> a \<in> F - {}. set_share a w (\<Union> A) < 0 \<longrightarrow> a \<in> set ?L"
    using `F \<in> union_closed_extension A` *
    by auto

  show "finite F"
    using `F \<in> union_closed_extension A` `finite (\<Union> A)` 
    by (auto simp add: finite_subset)
next
  show "union_closed_additional F (closure A)"
    using `F \<in> union_closed_extension A` `finite (\<Union> A)`
    by (simp add: union_closed_additional_closure finiteUn_iff)
qed (auto simp add: assms)

theorem SomeShareNegativeSound:
  assumes "finite (\<Union> A)"
  shows "SomeShareNegative A w = False \<Longrightarrow> uce_shares_nonneg A w"
using assms
using SomeShareNegativeFalse_FamilyShare
by auto

end