header{* SomeShareNegative -- executable implementation *}

theory SomeShareNegativeImpl
imports Main Rat Debug
  "~~/src/HOL/Library/List_lexord"
  MoreMap
  SomeShareNegative FamilyImpl
begin

text{* In this section we define a refinement of the @{text
"SomeShareNegative"} function in several steps in order to obtain a
more efficient, executable implementation. Optimizations are
introduced gradually, through separate refinement steps. *}

locale SomeShareNegative_Impl = FamilyImpl toList for
  toList :: "'s \<Rightarrow> 'a list"
begin

fun SomeShareNegative_aux_1 :: "'s list \<Rightarrow> 's list  \<Rightarrow> 's list \<Rightarrow> ('a \<Rightarrow> nat) \<Rightarrow> 's \<Rightarrow> bool" where
  "SomeShareNegative_aux_1 [] F Init w X = (Family_share F w X < 0)"
| "SomeShareNegative_aux_1 (h # t) F Init w X = 
    (if Family_share F w X + listsum (map (\<lambda> A. set_share A w X) (h # t)) \<ge> 0 then
        False
     else if SomeShareNegative_aux_1 t F Init w X then
        True
     else if h \<in> set F then
        False
     else
        SomeShareNegative_aux_1 t (insert_and_close_additional h F Init) Init w X
     )
"

lemma SomeShareNegative_aux_1_SomeShareNegative_aux:
  assumes "distinct F" 
          "\<forall> l \<in> set F. inv l"
          "\<forall> l \<in> set L. inv l"
          "\<forall> l \<in> set Init. inv l"
          "inv X"
  shows "SomeShareNegative_aux_1 L F Init w X = SomeShareNegative_aux (map toSet L) (f_toSet F) (f_toSet Init) w (toSet X)"
using assms
proof (induct L arbitrary: F)
  case Nil
  thus ?case
    using Family_share[of F X w]
    by simp
next
  case (Cons h t)
  have *: "Family_share F w X + listsum (map (\<lambda> A. set_share A w X) (h # t)) = 
           Frankl.Family_share (f_toSet F) w (toSet X) + listsum (map (\<lambda> A. Frankl.set_share A w (toSet X)) (map toSet (h # t)))"
  proof-
    have "listsum (map (\<lambda> A. set_share A w X) (h # t)) = listsum (map (\<lambda> A. Frankl.set_share A w (toSet X)) (map toSet (h # t)))"
    proof-
      have "map (\<lambda> A. set_share A w X) t = map (\<lambda> x. Frankl.set_share (toSet x) w (toSet X)) t"
        using `\<forall>a\<in>set (h # t). inv a` `inv X`
        using set_share
        by auto
      hence "(\<Sum>A\<leftarrow>t. set_share A w X) = (\<Sum>x\<leftarrow>t. Frankl.set_share (toSet x) w (toSet X))"
        by metis
      thus ?thesis
        using `\<forall>a\<in>set (h # t). inv a` `inv X`
        by (auto simp add: set_share comp_def)
    qed
    thus ?thesis
      using Family_share[of F X w]
      using `distinct F` `\<forall>a\<in>set F. inv a` `inv X`
      by simp
  qed
    
  show ?case
  proof (cases "Family_share F w X + listsum (map (\<lambda> A. set_share A w X) (h # t)) \<ge> 0")
    case True
    thus ?thesis
      using *
      by simp
  next
    case False
    have **: "SomeShareNegative_aux_1 t F Init w X = SomeShareNegative_aux (map toSet t) (f_toSet F) (f_toSet Init) w (toSet X)"
      using Cons
      by auto
      
    show ?thesis
    proof (cases "SomeShareNegative_aux_1 t F Init w X")
      case True
      show ?thesis
        using `\<not> Family_share F w X + listsum (map (\<lambda> A. set_share A w X) (h # t)) \<ge> 0` *
        using `SomeShareNegative_aux_1 t F Init w X` **
        by auto
    next
      case False
      have ***: "(h \<in> set F) = (toSet h \<in> f_toSet F)"
        apply (rule set_set[of F h])
        using `\<forall>a\<in>set F. inv a` `\<forall>a\<in>set (h # t). inv a`
        by auto
      show ?thesis
      proof (cases "h \<in> set F")
        case True
        show ?thesis
          using `\<not> Family_share F w X + listsum (map (\<lambda> A. set_share A w X) (h # t)) \<ge> 0` *
          using `\<not> SomeShareNegative_aux_1 t F Init w X` **
          using `h \<in> set F` ***
          by simp
      next
        case False
        let ?F' = "insert_and_close_additional h F Init"

        have "SomeShareNegative_aux_1 t (insert_and_close_additional h F Init) Init w X =
              SomeShareNegative_aux (map toSet t) (Frankl.insert_and_close_additional (toSet h) (f_toSet F) (f_toSet Init)) (f_toSet Init) w (toSet X)"
        proof (subst Cons(1))
          show "distinct ?F'"
            using `distinct F`
            by (simp add: distinct_insert_sets)
        next
          show "inv X" "\<forall> l \<in> set t. inv l" "\<forall> l \<in> set Init. inv l"
            using `inv X` `\<forall> l \<in> set (h # t). inv l` `\<forall> l \<in> set Init. inv l`
            by simp_all
        next
          show "\<forall> l \<in> (set ?F'). inv l"
            using `\<forall>a\<in>set F. inv a` `\<forall>a\<in>set (h # t). inv a` `\<forall>a\<in>set Init. inv a`
            using `distinct F`
            by (auto simp add: insert_sets_remdups union_inv)
        next
          show "SomeShareNegative_aux (map toSet t) (f_toSet (insert_and_close_additional h F Init)) (f_toSet Init) w (toSet X) =
                SomeShareNegative_aux (map toSet t) (Frankl.insert_and_close_additional (toSet h) (f_toSet F) (f_toSet Init)) (f_toSet Init) w
     (toSet X)"
            using `distinct F`
            using insert_and_close_additional
            by simp
        qed
        thus ?thesis
          using `\<not> Family_share F w X + listsum (map (\<lambda> A. set_share A w X) (h # t)) \<ge> 0` *
          using `\<not> SomeShareNegative_aux_1 t F Init w X` **
          using `\<not> h \<in> set F` ***
          by simp
      qed
    qed
  qed
qed

(* -------------------------------------------------------------------------- *)
fun SomeShareNegative_aux_2 :: "('s \<times> int) list \<Rightarrow> ('s list \<times> int) \<Rightarrow> 's list \<Rightarrow> ('a \<Rightarrow> nat) \<Rightarrow> 's \<Rightarrow> bool" where
  "SomeShareNegative_aux_2 [] (F, s) Init w X = (s < 0)"
| "SomeShareNegative_aux_2 (h # t) (F, s) Init w X = 
    (if s + listsum (map snd (h # t)) \<ge> 0 then
        False
     else if SomeShareNegative_aux_2 t (F, s) Init w X then
        True
     else if fst h \<in> set F then
        False
     else
        let F' = insert_and_close_additional (fst h) F Init;
            s' = Family_share F' w X in
        SomeShareNegative_aux_2 t (F', s') Init w X
    )
"

lemma SomeShareNegative_aux_2_SomeShareNegative_aux_1:
  assumes "L = zip l (map (\<lambda> F. set_share F w X) l)" "c = Family_share F w X"
  shows "SomeShareNegative_aux_2  L (F, c) Init w X = SomeShareNegative_aux_1 l F Init w X"
using assms
by (induct l arbitrary: F L c) (auto simp add: Let_def)

(* -------------------------------------------------------------------------- *)

fun SomeShareNegative_aux_3 :: "('s \<times> int) list \<Rightarrow> ('s list \<times> int) \<Rightarrow> 's list \<Rightarrow> ('s, int) mapping \<Rightarrow> bool" where
  "SomeShareNegative_aux_3 [] (F, s) Init shares = (s < 0)"
| "SomeShareNegative_aux_3 (h # t) (F, s) Init shares = 
    (if s + listsum (map snd (h # t)) \<ge> 0 then
        False
     else if SomeShareNegative_aux_3 t (F, s) Init shares then
        True
     else if fst h \<in> set F then
        False
     else
        let F' = insert_and_close_additional (fst h) F Init;
            s' = Family_share_cached F' shares in
        SomeShareNegative_aux_3 t (F', s') Init shares
    )
"

lemma SomeShareNegative_aux_3_SomeShareNegative_aux_2:
  assumes "\<forall> A. inv A \<and> toSet A \<subseteq> S \<longrightarrow> Mapping.lookup shares A = Some (set_share A w X)"
          "\<forall> A \<in> set F. inv A \<and> toSet A \<subseteq> S"
          "\<forall> A \<in> set Init. inv A \<and> toSet A \<subseteq> S"
          "\<forall> A \<in> set (map fst l). inv A \<and> toSet A \<subseteq> S"
          "distinct F"
  shows "SomeShareNegative_aux_3 l (F, s) Init shares = SomeShareNegative_aux_2 l (F, s) Init w X"
using assms
proof (induct l arbitrary: F s)
  case Nil
  thus ?case
    by simp
next
  case (Cons h t)
  show ?case
  proof (cases "s + listsum (map snd (h # t)) \<ge> 0")
    case True
    thus ?thesis
      by simp
  next
    case False
    show ?thesis
    proof (cases "fst h \<in> set F")
      case True
      thus ?thesis
        using `\<not> s + listsum (map snd (h # t)) \<ge> 0` Cons
        by simp
    next
      case False
      let ?F' = "insert_and_close_additional (fst h) F Init"
      let ?s' = "Family_share_cached ?F' shares"
      let ?s'' = "Family_share ?F' w X"

      have "\<forall>A\<in>set ?F'. toSet A \<subseteq> S"
        apply (rule insert_and_close_additional_subset[of F S "fst h" Init])
        using  Cons(3) Cons(4) Cons(5)
        using `distinct F` 
        by simp_all
      
      have "\<forall>A\<in>set ?F'. inv A"
        apply (rule insert_and_close_additional_inv)
        using  Cons(3) Cons(4) Cons(5)
        using `distinct F` 
        by simp_all

      have "distinct ?F'"
        using `distinct F`
        by (simp add: distinct_insert_sets)

      have "?s' = ?s''"
        apply (rule Family_share_cached_Family_share[of S shares w X ?F'])
        using `\<forall>A\<in>set ?F'. toSet A \<subseteq> S` `\<forall>A\<in>set ?F'. inv A` Cons(2)
        by simp_all
        
      hence "SomeShareNegative_aux_3 t (?F', ?s') Init shares = SomeShareNegative_aux_2 t (?F', ?s'') Init w X"
        using Cons(1)[of ?F' ?s'] Cons(2) Cons(3) Cons(4) Cons(5)
        using `\<forall>A\<in>set ?F'. toSet A \<subseteq> S` `\<forall>A\<in>set ?F'. inv A`
        using `distinct ?F'` 
        by auto
      thus ?thesis
        using `\<not> s + listsum (map snd (h # t)) \<ge> 0` `fst h \<notin> set F` Cons
        by auto
    qed
  qed
qed

(* -------------------------------------------------------------------------- *)

lemma SomeShareNegative_aux_3_correct: 
  assumes "SomeShareNegative_aux_3 L (F, c) Init shares = False"
  "\<forall> (x, y) \<in> set L. y = set_share x w X"
  "c = Family_share F w X"
  "\<forall>A. inv A \<and> toSet A \<subseteq> S \<longrightarrow> Mapping.lookup shares A = Some (set_share A w X)"
  "\<forall>A\<in>set F. inv A \<and> toSet A \<subseteq> S"
  "\<forall>A\<in>set Init. inv A \<and> toSet A \<subseteq> S"
  "\<forall>A\<in>set (map fst L). inv A \<and> toSet A \<subseteq> S"
  "distinct F"
  "inv X"
  "\<forall>A\<in>set (map fst L). Frankl.set_share (toSet A) w (toSet X) < 0"
  "finite F'"
  "union_closed_additional F' (f_toSet Init)"
  "f_toSet F \<subseteq> F'"
  "\<forall>A\<in>F' - f_toSet F. (Frankl.set_share A w (toSet X) < 0 \<longrightarrow> A \<in> f_toSet (map fst L))"
  "distinct L"
  shows "Frankl.Family_share F' w (toSet X) \<ge> 0"
using assms
using exists_zip[of L "\<lambda> x. set_share x w X"]
apply (subst (asm) SomeShareNegative_aux_3_SomeShareNegative_aux_2[of S shares w X])
apply simp_all
apply (subst (asm) SomeShareNegative_aux_2_SomeShareNegative_aux_1[of L "map fst L"])
apply (simp_all add: comp_def)
apply (subst (asm) SomeShareNegative_aux_1_SomeShareNegative_aux)
apply simp_all
apply (rule SomeShareNegative_aux_correct[of "map toSet (map fst L)" "f_toSet F" "f_toSet Init" w "toSet X" F'])
apply (simp_all add: comp_def)
proof-
  assume *: "\<forall>A\<in>set L. inv (fst A) \<and> toSet (fst A) \<subseteq> S" "distinct L" "\<forall>x\<in>set L. case x of (x, y) \<Rightarrow> y = set_share x w X"
  have "\<forall>a\<in>set (map fst L). inv a"
    using `\<forall>A\<in>set L. inv (fst A) \<and> toSet (fst A) \<subseteq> S`
    by simp
  hence "inj_on toSet (set (map fst L))"
    by (rule inv_inj)
  thus "distinct (map (\<lambda> x. toSet (fst x)) L)" 
    using comp_inj_on_iff[of fst "set L" toSet] * inj_on_fst[of L]
    by (auto simp add: distinct_map comp_def)
qed

(* -------------------------------------------------------------------------- *)

fun SomeShareNegative_aux_4 :: "(('s \<times> int) list \<times> int) \<Rightarrow> ('s list \<times> int) \<Rightarrow> 's list \<Rightarrow> ('s, int) mapping \<Rightarrow> bool" where
  "SomeShareNegative_aux_4 ([], _) (F, s) Init shares = (s < 0)"
| "SomeShareNegative_aux_4 ((h # t), ls) (F, s) Init shares = 
    (if s + ls \<ge> 0 then
        False
     else if SomeShareNegative_aux_4 (t, ls - snd h) (F, s) Init shares then
        True
     else if fst h \<in> set F then
        False
     else
        let F' = insert_and_close_additional (fst h) F Init;
            s' = Family_share_cached F' shares in
        SomeShareNegative_aux_4 (t, ls - snd h) (F', s') Init shares
    )
"

lemma SomeShareNegative_aux_4_SomeShareNegative_aux_3:
  shows "SomeShareNegative_aux_4 (l, listsum (map snd l)) (F, s) Init shares = 
  SomeShareNegative_aux_3 l (F, s) Init shares"
by (induct l arbitrary: F s) auto

lemma SomeShareNegative_aux_4_equal_set:
  assumes "set F = set F'" "distinct F" "distinct F'"
  shows "SomeShareNegative_aux_4 (l, ls) (F, s) Init shares =
SomeShareNegative_aux_4 (l, ls) (F', s) Init shares"
using assms
proof (induct l arbitrary: F F' s ls)
  case Nil
  thus ?case
    by simp
next
  case (Cons h t)
  show ?case
  proof (cases "s + ls \<ge> 0")
    case True
    thus ?thesis
      by simp
  next
    case False
    show ?thesis
    proof (cases "SomeShareNegative_aux_4 (t, ls - snd h) (F, s) Init shares")
      case True
      thus ?thesis
        using `\<not> s + ls \<ge> 0`
        using Cons(1)[of F F' "ls - snd h" s] Cons(2) Cons(3) Cons(4)
        by auto
    next
      case False
      show ?thesis
      proof (cases "fst h \<in> set F")
        case True
        thus ?thesis
          using `\<not> s + ls \<ge> 0`
          using `\<not> SomeShareNegative_aux_4 (t, ls - snd h) (F, s) Init shares`
          using Cons(1)[of F F' "ls - snd h" s] Cons(2) Cons(3) Cons(4)
          by auto
      next
        case False
        let ?F = "insert_and_close_additional (fst h) F Init"
        let ?F' = "insert_and_close_additional (fst h) F' Init"
        have "set ?F = set ?F'"
          using `set F = set F'` `distinct F` `distinct F'`
          by (rule insert_and_close_additional_equal_set)
        hence "Family_share_cached ?F shares = Family_share_cached ?F' shares"
          using Family_share_cached_equal_set[of ?F ?F' shares]
          using `distinct F` `distinct F'`
          by (simp add: distinct_insert_sets)
        thus ?thesis
          using `fst h \<notin> set F`
          using `\<not> s + ls \<ge> 0`
          using `\<not> SomeShareNegative_aux_4 (t, ls - snd h) (F, s) Init shares`
          using Cons(1)[of F F' "ls - snd h" s] Cons(2) Cons(3) Cons(4)
          using `set ?F = set ?F'`
          using Cons(1)[of ?F ?F']
          by (simp add: Let_def distinct_insert_sets)
      qed
    qed
  qed
qed

(* -------------------------------------------------------------------------- *)

function SomeShareNegative_aux_5 :: "(('s \<times> int) list \<times> int) \<Rightarrow> ('s list \<times> int) \<Rightarrow> 's list \<Rightarrow> ('s, int) mapping \<Rightarrow> bool" where
  "SomeShareNegative_aux_5 ([], _) (F, s) Init shares = 
      (s < 0)"
| "SomeShareNegative_aux_5 ((h # t), ls) (F, s) Init shares = 
    (if s + ls \<ge> 0 then
        False
     else if SomeShareNegative_aux_5 (t, ls - snd h) (F, s) Init shares then
        True
     else if fst h \<in> set F then
        False
     else
        let (F', s') = insert_and_close_additional' (fst h) (F, s) Init shares in
        SomeShareNegative_aux_5 (t, ls - snd h) (F', s') Init shares
    )"
by pat_completeness auto
termination
by (relation "measure (\<lambda> ((L, _), _, _, _). length L)") auto

lemma SomeShareNegative_aux_5_SomeShareNegative_aux_4:
assumes "s = Family_share_cached F shares" "distinct F"
shows "SomeShareNegative_aux_5 (L, ls) (F, s) Init shares = 
SomeShareNegative_aux_4 (L, ls) (F, s) Init shares"
using assms
proof (induct L arbitrary: F s ls)
  case Nil
  thus ?case
    by simp
next
  case (Cons h t)
  show ?case
  proof (cases "0 \<le> s + ls")
    case True
    thus ?thesis
      unfolding SomeShareNegative_aux_4.simps SomeShareNegative_aux_5.simps
      by simp
  next
    case False
    hence *: "SomeShareNegative_aux_5 (t, ls - snd h) (F, s) Init shares = SomeShareNegative_aux_4 (t, ls - snd h) (F, s) Init shares"
      using Cons(1)[of s F "ls - snd h"] Cons(2) Cons(3)
      by auto
    show ?thesis
    proof (cases "SomeShareNegative_aux_5 (t, ls - snd h) (F, s) Init shares")
      case True
      thus ?thesis
        using `\<not> 0 \<le> s + ls` *
        by simp
    next
      case False
      show ?thesis
      proof (cases "fst h \<in> set F")
        case True
        thus ?thesis
          using `\<not> 0 \<le> s + ls`
          using `\<not> SomeShareNegative_aux_5 (t, ls - snd h) (F, s) Init shares`
          using *
          by simp
      next
        case False
        let ?F1s1 = "insert_and_close_additional' (fst h) (F, s) Init shares"
        let ?F1 = "fst ?F1s1"
        let ?s1 = "snd ?F1s1"
        let ?F2 = "insert_and_close_additional (fst h) F Init"
        let ?s2 = "Family_share_cached ?F2 shares"

        have "distinct ?F1" "distinct ?F2"
          using `distinct F`
          unfolding Let_def
          by (auto simp add: distinct_insert_sets)

        have "set ?F1 = set ?F2 \<and> ?s1 = ?s2"
          apply (rule insert_and_close_additional'[of F "fst h" shares Init ?F1 ?s1 ?F2 ?s2])
          using `distinct F` Cons(2)
          by (auto simp add: Let_def comp_def)
        hence "set ?F1 = set ?F2" "?s1 = ?s2"
          by (rule conjunct1, rule conjunct2)

        have "SomeShareNegative_aux_4 (t, ls - snd h) (?F1, ?s1) Init shares = 
          SomeShareNegative_aux_4 (t, ls - snd h) (?F2, ?s2) Init shares"
        proof (subst SomeShareNegative_aux_4_equal_set[of ?F1 ?F2 t "ls - snd h" ?s1 Init shares])
          show "set ?F1 = set ?F2"
            using `set ?F1 = set ?F2`
            .
        next
          show "distinct ?F1" "distinct ?F2"
            using `distinct ?F1` `distinct ?F2`
            .
        next
          show "SomeShareNegative_aux_4 (t, ls - snd h) (?F2, ?s1) Init shares = 
            SomeShareNegative_aux_4 (t, ls - snd h) (?F2, ?s2) Init shares"
            by (subst `?s1 = ?s2`, rule refl)
        qed
        moreover
        have "SomeShareNegative_aux_5 (t, ls - snd h) (?F1, ?s1) Init shares = SomeShareNegative_aux_4 (t, ls - snd h) (?F1, ?s1) Init shares"
          apply (rule Cons(1)[of ?s1 ?F1 "ls - snd h"])
          using Cons(2) `distinct ?F1`
          using insert_and_close_additional'_Family_share_cached[of "fst h" F shares Init]
          by (auto simp add: Let_def comp_def)
        ultimately
        show ?thesis
          using `fst h \<notin> set F`
          using `\<not> 0 \<le> s + ls`
          using `\<not> SomeShareNegative_aux_5 (t, ls - snd h) (F, s) Init shares` *
          by (simp add: Let_def)
      qed
    qed
  qed
qed

(* -------------------------------------------------------------------------- *)

definition SomeShareNegative :: "'s list \<Rightarrow> ('a, nat) mapping \<Rightarrow> bool" where
"SomeShareNegative A w \<equiv>
  let S = Union A;
      P = pow S;
      A = close A;
      U' = map (\<lambda> A. set_share_map A w S) P;
      U = sort_key snd (zip P U');
      shares = tabulate U;
      L =  takeWhile (\<lambda> (a, b). b < 0) U;
      F = [] in
      SomeShareNegative_aux_5 (L, listsum (map snd L)) (F, 0) A shares"

text{* TODO: Show that this implementation of SomeShareNegative refines 
the abstract implementation of SomeShareNegative given in SomeShareNegative.thy (requires modifications). *}

lemma SomeShareNegativeFalse_FamilyShare:
  assumes 
  "SomeShareNegative A w = False"
  "A' = f_toSet A"
  "\<forall> l \<in> set A. inv l" 
  "finite F"
  "union_closed_additional F (closure A')"
  "\<forall> x \<in> F. x \<subseteq> \<Union> A'"
  "\<forall> x \<in> \<Union>A'. Mapping.lookup w x = Some (w' x)"
  shows "\<bowtie> F w' (\<Union> A') \<ge> 0"
proof-
  let ?S = "Union A"
  let ?P = "pow ?S"
  let ?A = "close A"
  let ?U' = "map (\<lambda> A. set_share_map A w ?S) ?P"
  let ?U = "sort_key snd (zip ?P ?U')"
  let ?shares = "tabulate ?U"
  let ?L = "takeWhile (\<lambda> (a, b). b < 0) ?U"
  let ?F = "[]"

  have "inv (Union A)"
    using `\<forall> l \<in> set A. inv l`
    using Union_inv[of A]
    by simp

  have *: "\<forall> x \<in> set ?P. set_share_map x w (Union A) = set_share x w' (Union A)"
  proof
    fix x
    assume "x \<in> set ?P"
    hence "toSet x \<subseteq> \<Union> A'" "inv x"
      using pow_set[of "Union A"]
      using pow_inv[of "Union A"]
      using Union_set[of A] `inv (Union A)`  `A' = f_toSet A`
      by auto
    hence "\<forall> a \<in> toSet x. Mapping.lookup w a = Some (w' a)"
      using `\<forall> a \<in> \<Union>A'. Mapping.lookup w a = Some (w' a)`
      by auto
    thus "set_share_map x w (Union A) = set_share x w' (Union A)"
      using set_weight_map[of x w w']
      using set_weight_map[of "Union A" w w']
      using `\<forall> a \<in> \<Union>A'. Mapping.lookup w a = Some (w' a)`
      using Union_set[of A]
      using `inv (Union A)` `inv x` `A' = f_toSet A`
      by (simp add: set_share_def)
  qed

  show ?thesis
  proof (subst `A' = f_toSet A`, subst Union_set[THEN sym], rule SomeShareNegative_aux_3_correct[of ?L ?F 0 ?A ?shares])
    show "SomeShareNegative_aux_3 ?L (?F, 0) ?A ?shares = False"
      using `SomeShareNegative A w = False`
      unfolding SomeShareNegative_def Let_def
      using SomeShareNegative_aux_4_SomeShareNegative_aux_3
      using SomeShareNegative_aux_5_SomeShareNegative_aux_4
      by simp
  next
    show "\<forall> (x, y) \<in> set ?L. y = set_share x w' (Union A)"
      using *
      by (auto dest!: set_takeWhileD simp add: set_zip)
  next
    show "0 = Family_share [] w' (Union A)"
      by (simp add: Family_share_def)
  next
    show "\<forall> A'. inv A' \<and> toSet A' \<subseteq> toSet ?S \<longrightarrow> Mapping.lookup ?shares A' = Some (set_share A' w' (Union A))"
    proof-
      have "distinct ?P"
        using `inv (Union A)`
        by (simp add: pow_distinct)
      hence "distinct (map fst ?U)"
        using inj_on_fst[of ?U]
        by (force simp add: distinct_map distinct_zipI1 set_zip)
      thus ?thesis
        using `distinct ?P`
        using `inv (Union A)`
        using in_set_pow
        using *
        using tabulate_map_of[of ?U]
        using inj_on_fst[of ?U]
        by (auto simp add: tabulate_map_of map_of_sort_key map_of_zip_map)
    qed
  next
    show "\<forall> A' \<in> set (close A). inv A' \<and> toSet A' \<subseteq> toSet (Union A)"
      using close_inv[of A] `\<forall>l\<in>set A. inv l`
      using close_subset[of A "toSet (Union A)"]
      using Union_set[of A]
      by auto
  next
    show "\<forall> A' \<in> set (map fst ?L). inv A' \<and> toSet A' \<subseteq> toSet (Union A)"
        using pow_inv[of "Union A"] using pow_set[of "Union A"] `inv (Union A)`
        by (auto dest!: set_takeWhileD set_zip_leftD) force
  next
    show "inv (Union A)"
      using `inv (Union A)`
      .
  next
    show "\<forall>A'\<in>set (map fst ?L). Frankl.set_share (toSet A') w' (toSet (Union A)) < 0"
    proof-
      { 
        fix a b
        assume "(a, b) \<in> set (zip ?P ?U')" "b < 0"
        hence "a \<in> set ?P" "set_share_map a w (Union A) < 0"
          by (auto simp add: set_zip)
        hence "Frankl.set_share (toSet a) w' (toSet (Union A)) < 0"
          using * set_share[of a "Union A" w']
          using `inv (Union A)`
          using pow_inv[of "Union A"]
          by auto
      }
      thus ?thesis
        by (auto dest!: set_takeWhileD)
    qed
  next
    show "finite F"
      using `finite F`
      .
  next
    show "union_closed_additional F (f_toSet (close A))"
      using `union_closed_additional F (closure A')` `A' = f_toSet A`
      using close_set[of A]
      by simp
  next
    show "\<forall>x\<in>F - f_toSet []. (Frankl.set_share x w' (toSet (Union A)) < 0 \<longrightarrow> 
      x \<in> f_toSet (map fst ?L))"
    proof(safe)
      fix x
      assume "x \<in> F" "Frankl.set_share x w' (toSet (Union A)) < 0"
      have "x \<subseteq> toSet (Union A)"
        using `\<forall> x \<in> F. x \<subseteq> \<Union> A'` `x \<in> F`
        using Union_set[of A] `A' = f_toSet A`
        by simp
      hence "x \<in> f_toSet ?P"
        using pow_set[of "Union A"]
        by simp
      then obtain x' where "x = toSet x'" "x' \<in> set ?P" "inv x'"
        using pow_inv[of "Union A"] `inv (Union A)`
        by auto
      have "(x', set_share_map x' w (Union A)) \<in> set ?L"
        apply (rule sorted_takeWhile_snd_neg[of ?U ?P])
        using `x' \<in> set ?P` `x = toSet x'`
        using `Frankl.set_share x w' (toSet (Union A)) < 0` `inv (Union A)` `inv x'`
        using set_share *
        by auto
      thus "x \<in> f_toSet (map fst ?L)"
        using `x = toSet x'`
        by (force simp add: comp_def)
    qed
  next
    show "distinct ?L"
      using `inv (Union A)`
      by (auto intro!: distinct_takeWhile distinct_zipI1 pow_distinct)
  qed simp_all
qed

lemma SomeShareNegativeSound:
assumes
  "\<forall>l\<in>set A. inv l"
  "A' = f_toSet A"
  "\<forall>x\<in>A'. finite x"
  "\<forall>x\<in>\<Union>A'. Mapping.lookup w x = Some (w' x)"
  shows "SomeShareNegative A w = False \<Longrightarrow> uce_shares_nonneg A' w'"
proof
  fix F
  assume "SomeShareNegative A w = False" "F \<in> \<lbrace>A'\<rbrace>"
  hence "union_closed F" "F \<subseteq> Pow (\<Union> A')"  "\<forall>A''\<in>F. op \<union> A'' ` A' \<subseteq> F"
    by auto

  have "finite F" "\<forall> x \<in> F. finite x"
    using `F \<subseteq> Pow (\<Union> A')` `\<forall> X \<in> A'. finite X` `A' = f_toSet A`
    by (auto simp add: finite_subset)

  show "0 \<le> Frankl.Family_share F w' (\<Union>A')"
  proof (subst `A' = f_toSet A`, rule SomeShareNegativeFalse_FamilyShare)
    show "SomeShareNegative A w = False"
      by fact
  next
    show "union_closed_additional F (closure (f_toSet A))"
      apply (subst `A' = f_toSet A`[THEN sym])
      using `union_closed F`
    proof (auto)
      fix A'' x
      assume "A'' \<in> F" "x \<in> closure A'"
      hence "x \<union> A'' \<in> F"
        using `union_closed F` `\<forall> A'' \<in> F. image (op \<union> A'') A' \<subseteq> F`
        using closure_additional_set[of A' x A'' F] `A' = f_toSet A`
        by simp
      thus "A'' \<union> x \<in> F"
        by (simp add: Un_commute)
    qed
  next
    show "finite F"
      by fact
  next
    show "\<forall>l\<in>set A. inv l"
      by fact
  next
    show "\<forall> x \<in> F. x \<subseteq> \<Union> f_toSet A"
      using `A' = f_toSet A`
      using `F \<subseteq> Pow (\<Union> A')`
      by auto
  next
    show "\<forall> a \<in> \<Union> f_toSet A. Mapping.lookup w a = Some (w' a)"
      using `\<forall> x \<in> \<Union> A'. Mapping.lookup w x = Some (w' x)`
      using `A' = f_toSet A`
      by auto
  qed simp
qed

end

interpretation SomeShareNegative_Impl_lists:
  SomeShareNegative_Impl "List.set" "\<lambda> l. sorted l \<and> distinct l" "[]" merge ListPow set_weight_l set_weight_map_l id
proof qed

lemma SomeShareNegativeSound_lists:
  assumes "finite A" "\<forall> X \<in> A. finite X" 
  "A' = sorted_list_of_set (sorted_list_of_set ` A)"
  "w' = Mapping.tabulate (sorted_list_of_set (\<Union> A)) w"
  shows "SomeShareNegative_Impl_lists.SomeShareNegative A' w' = False \<Longrightarrow> uce_shares_nonneg A w"
proof (rule SomeShareNegative_Impl_lists.SomeShareNegativeSound)
  show "A = set (map set A')"
  proof-
    have "\<forall> x \<in> A. x \<in> set ` sorted_list_of_set ` A"
    proof (safe)
      fix x
      assume "x \<in> A"
      show "x \<in> set ` sorted_list_of_set ` A"
        apply (rule rev_image_eqI[of "sorted_list_of_set x"])
        using  `\<forall> x \<in> A. finite x` `x \<in> A`
        by auto
    qed
    thus ?thesis
      using `finite A` `A' = sorted_list_of_set (image sorted_list_of_set  A)`
      by auto
  qed

  show "\<forall>x\<in>\<Union>A. Mapping.lookup w' x = Some (w x)"
    using `w' = Mapping.tabulate (sorted_list_of_set (\<Union> A)) w`
    using `A = set (map set A')`
    by auto

  show "\<forall>l\<in>set A'. sorted l \<and> distinct l"
    using `finite A` `A' = sorted_list_of_set (image sorted_list_of_set A)`
    using sorted_list_of_set[of "sorted_list_of_set ` A"] `\<forall> x \<in> A. finite x`
    by auto
qed (simp_all add: assms)

(* ----------------------------------------------------------------------- *)
(* Implementation by natural numbers                                       *)
(* ----------------------------------------------------------------------- *)

definition SomeShareNegative_n where
 [simp, code del]: "SomeShareNegative_n = SomeShareNegative_Impl.SomeShareNegative 0 bitor pow_n set_weight_map_n"
definition SomeShareNegative_aux_5_n where
 [simp, code del]: "SomeShareNegative_aux_5_n = SomeShareNegative_Impl.SomeShareNegative_aux_5 bitor"

interpretation SomeShareNegative_Impl_nats: SomeShareNegative_Impl "set \<circ> nat2list" "\<lambda> n. True" 0 bitor pow_n set_weight_n set_weight_map_n nat2list
  where
"SomeShareNegative_Impl.SomeShareNegative 0 bitor pow_n set_weight_map_n = SomeShareNegative_n" and
"SomeShareNegative_Impl.SomeShareNegative_aux_5 bitor = SomeShareNegative_aux_5_n"
proof (unfold_locales)
qed auto

abbreviation SomeShareNegative where
"SomeShareNegative \<equiv> \<lambda> A w. SomeShareNegative_n (map list2nat A) w"

lemma SomeShareNegativeSound_nats:
  assumes "finite A" "\<forall> X \<in> A. finite X" 
  "A' = sorted_list_of_set (sorted_list_of_set ` A)"
  "w' = Mapping.tabulate (sorted_list_of_set (\<Union> A)) w"
  shows "SomeShareNegative A' w' = False \<Longrightarrow> uce_shares_nonneg A w"
proof (rule SomeShareNegative_Impl_nats.SomeShareNegativeSound)
  show "A = set (map (set \<circ> nat2list) (map list2nat A'))"
  proof-
    have "\<forall> x \<in> A. x \<in> (set \<circ> nat2list) ` (list2nat \<circ> sorted_list_of_set) ` A"
    proof (safe)
      fix x
      assume "x \<in> A"
      show "x \<in> (set \<circ> nat2list) ` (list2nat \<circ> sorted_list_of_set) ` A"
        apply (rule rev_image_eqI[of "list2nat (sorted_list_of_set x)"])
        using  `\<forall> x \<in> A. finite x` `x \<in> A`
        using nat2list_list2nat[of "sorted_list_of_set x"]
        by auto
    qed
    thus ?thesis
      using `finite A` `A' = sorted_list_of_set (image sorted_list_of_set A)`
      using nat2list_list2nat
      by auto
  qed

  show "\<forall>x\<in>\<Union>A. Mapping.lookup w' x = Some (w x)"
    using `w' = Mapping.tabulate (sorted_list_of_set (\<Union> A)) w`
    using `A = set (map (set \<circ> nat2list) (map list2nat A'))`
    by auto
qed (simp_all add: assms)

end