theory th_prop1aux2_complete_proof
imports Main 
begin
typedecl point
typedecl line
typedecl circle

consts eq_point ::  "point \<Rightarrow> point \<Rightarrow>  bool "
consts not_eq_point ::  "point \<Rightarrow> point \<Rightarrow>  bool "
consts eq_line ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts not_eq_line ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts eq_circle ::  "circle \<Rightarrow> circle \<Rightarrow>  bool "
consts not_eq_circle ::  "circle \<Rightarrow> circle \<Rightarrow>  bool "
consts on ::  "point \<Rightarrow> line \<Rightarrow>  bool "
consts not_on ::  "point \<Rightarrow> line \<Rightarrow>  bool "
consts intersects ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts not_intersects ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts onc ::  "point \<Rightarrow> circle \<Rightarrow>  bool "
consts not_onc ::  "point \<Rightarrow> circle \<Rightarrow>  bool "
consts inside ::  "point \<Rightarrow> circle \<Rightarrow>  bool "
consts not_inside ::  "point \<Rightarrow> circle \<Rightarrow>  bool "
consts center ::  "point \<Rightarrow> circle \<Rightarrow>  bool "
consts not_center ::  "point \<Rightarrow> circle \<Rightarrow>  bool "
consts intersectscc ::  "circle \<Rightarrow> circle \<Rightarrow>  bool "
consts not_intersectscc ::  "circle \<Rightarrow> circle \<Rightarrow>  bool "
consts intersectslc ::  "circle \<Rightarrow> line \<Rightarrow>  bool "
consts not_intersectslc ::  "circle \<Rightarrow> line \<Rightarrow>  bool "
consts comp ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_comp ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts bet ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_bet ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts col ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_col ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong_area ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong_area ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong_area_leq ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong_area_leq ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong_area_zero ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong_area_zero ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts area_add ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_area_add ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong_add ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong_add ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts sameside ::  "point \<Rightarrow> point \<Rightarrow> line \<Rightarrow>  bool "
consts not_sameside ::  "point \<Rightarrow> point \<Rightarrow> line \<Rightarrow>  bool "
consts segment_add ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_segment_add ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts right_angle ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_right_angle ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong_zero ::  "point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong_zero ::  "point \<Rightarrow> point \<Rightarrow>  bool "
consts cong_less ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong_less ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong_leq ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong_leq ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong_angle ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong_angle ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts angle_add ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_angle_add ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong_angle_less ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong_angle_less ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong_angle_leq ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong_angle_leq ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong_angle_zero ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong_angle_zero ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "

axiomatization where 

ax_angle1_1: "\<lbrakk>A ~= B; A ~= C; on A s; on B s; on C s; \<not> bet B A C\<rbrakk> \<Longrightarrow> (cong_angle_zero B A C)"
and ax_angle1_2: "\<lbrakk>A ~= B; A ~= C; on A s; on B s; cong_angle_zero B A C\<rbrakk> \<Longrightarrow> (on C s \<and> \<not> bet B A C)"
and ax_angle2_1: "\<lbrakk>on A t; on A u; on B t; on C u; A ~= B; A ~= C; \<not> on D t; \<not> on D u; t ~= u; angle_add B A D D A C B A C\<rbrakk> \<Longrightarrow> (sameside B D u \<and> sameside C D t)"
and ax_angle2_2: "\<lbrakk>on A t; on A u; on B t; on C u; A ~= B; A ~= C; \<not> on D t; \<not> on D u; t ~= u; sameside B D u; sameside C D t\<rbrakk> \<Longrightarrow> (angle_add B A D D A C B A C)"
and ax_angle3_1: "\<lbrakk>on A t; on B t; bet A C B; \<not> on D t; cong_angle A C D D C B\<rbrakk> \<Longrightarrow> (right_angle A C D)"
and ax_angle3_2: "\<lbrakk>on A t; on B t; bet A C B; \<not> on D t; right_angle A C D\<rbrakk> \<Longrightarrow> (cong_angle A C D D C B)"
and ax_angle4: "\<lbrakk>on A u; on B u; on C u; on A v; on D v; on E v; B ~= A; C ~= A; D ~= A; E ~= A; \<not> bet B A C; \<not> bet D A E\<rbrakk> \<Longrightarrow> (cong_angle B A D C A E)"
and ax_angle5: "\<lbrakk>on A t; on B t; on B u; on C u; on C v; on D v; B ~= C; sameside A D v; angle_add A B C B C D I J K; right_angle L M N; right_angle P Q R; angle_add L M N P Q R S T U; cong_angle_less I J K S T U; on V t; on V v\<rbrakk> \<Longrightarrow> (intersects t v \<and> sameside V A u)"
and ax_area1_1: "\<lbrakk>on A s; on B s; A ~= B; cong_area_zero A B C\<rbrakk> \<Longrightarrow> (on C s)"
and ax_area1_2: "\<lbrakk>on A s; on B s; A ~= B; on C s\<rbrakk> \<Longrightarrow> (cong_area_zero A B C)"
and ax_area2_1: "\<lbrakk>on A t; on B t; on C t; A ~= B; A ~= C; B ~= C; \<not> on D t; bet A C B\<rbrakk> \<Longrightarrow> (area_add A C D D C B A D B)"
and ax_area2_2: "\<lbrakk>on A t; on B t; on C t; A ~= B; A ~= C; B ~= C; \<not> on D t; area_add A C D D C B A D B\<rbrakk> \<Longrightarrow> (bet A C B)"
and ax_bet1: "\<lbrakk>bet A B C\<rbrakk> \<Longrightarrow> (bet C B A \<and> A ~= B \<and> A ~= C \<and> \<not> bet B A C)"
and ax_bet2: "\<lbrakk>bet A B C; on A s; on B s\<rbrakk> \<Longrightarrow> (on C s)"
and ax_bet3: "\<lbrakk>bet A B C; on A s; on C s\<rbrakk> \<Longrightarrow> (on B s)"
and ax_bet4: "\<lbrakk>bet A B C; bet A D B\<rbrakk> \<Longrightarrow> (bet A D C)"
and ax_bet5: "\<lbrakk>bet A B C; bet B C D\<rbrakk> \<Longrightarrow> (bet A B D)"
and ax_bet7: "\<lbrakk>bet A B C; bet A B D\<rbrakk> \<Longrightarrow> (\<not> bet C B D)"
and ax_circle1: "\<lbrakk>on A s; on B s; on C s; inside A CI4; onc B CI4; onc C CI4; B ~= C\<rbrakk> \<Longrightarrow> (bet B A C)"
and ax_circle2_1: "\<lbrakk>inside A CI3; inside B CI3; bet A C B\<rbrakk> \<Longrightarrow> (inside C CI3)"
and ax_circle2_2: "\<lbrakk>inside A CI3; onc B CI3; bet A C B\<rbrakk> \<Longrightarrow> (inside C CI3)"
and ax_circle2_3: "\<lbrakk>onc A CI3; inside B CI3; bet A C B\<rbrakk> \<Longrightarrow> (inside C CI3)"
and ax_circle2_4: "\<lbrakk>onc A CI3; onc B CI3; bet A C B\<rbrakk> \<Longrightarrow> (inside C CI3)"
and ax_circle3_1: "\<lbrakk>inside A CI3; \<not> inside C CI3; bet A C B\<rbrakk> \<Longrightarrow> (\<not> inside B CI3 \<and> \<not> onc B CI3)"
and ax_circle3_2: "\<lbrakk>onc A CI3; \<not> inside C CI3; bet A C B\<rbrakk> \<Longrightarrow> (\<not> inside B CI3 \<and> \<not> onc B CI3)"
and ax_circle4: "\<lbrakk>CI0 ~= CI1; intersectscc CI0 CI1; C ~= D; onc C CI0; onc C CI1; onc D CI0; onc D CI1; center E CI0; center F CI1; on E v; on F v\<rbrakk> \<Longrightarrow> (\<not> sameside C D v)"
and ax_cong_angle_less: "\<lbrakk>angle_add A B C D E F G I J\<rbrakk> \<Longrightarrow> (cong_angle_less A B C G I J \<and> cong_angle_less D E F G I J)"
and ax_cong_angle_reflexivity: "(cong_angle A B C A B C)"
and ax_cong_angle_symmetry: "\<lbrakk>cong_angle A B C D E F\<rbrakk> \<Longrightarrow> (cong_angle D E F A B C)"
and ax_cong_angle_transitivity: "\<lbrakk>cong_angle A B C D E F; cong_angle A B C G I J\<rbrakk> \<Longrightarrow> (cong_angle D E F G I J)"
and ax_cong_eq1: "\<lbrakk>cong A A B C\<rbrakk> \<Longrightarrow> (B = C)"
and ax_cong_leq2: "\<lbrakk>cong A B C D\<rbrakk> \<Longrightarrow> (cong_leq A B C D)"
and ax_cong_leq3: "\<lbrakk>cong_less A B C D\<rbrakk> \<Longrightarrow> (cong_leq A B C D)"
and ax_cong_less1: "\<lbrakk>segment_add A B C D E F\<rbrakk> \<Longrightarrow> (cong_less A B E F \<and> cong_less C D E F)"
and ax_cong_less2: "\<lbrakk>cong_less A B C D; segment_add A B E F G I; segment_add C D E F J K\<rbrakk> \<Longrightarrow> (cong_less G I J K)"
and ax_cong_less3: "\<lbrakk>cong_less A B C D; cong A B E F\<rbrakk> \<Longrightarrow> (cong_less E F C D)"
and ax_cong_less4: "\<lbrakk>cong_less A B C D; cong C D E F\<rbrakk> \<Longrightarrow> (cong_less A B E F)"
and ax_cong_reflexivity: "(cong A B A B)"
and ax_cong_symmetry1: "\<lbrakk>cong A B C D\<rbrakk> \<Longrightarrow> (cong C D A B)"
and ax_cong_symmetry2: "\<lbrakk>cong A B C D\<rbrakk> \<Longrightarrow> (cong B A C D)"
and ax_cong_symmetry: "\<lbrakk>cong A B C D\<rbrakk> \<Longrightarrow> (cong C D A B)"
and ax_cong_transitivity: "\<lbrakk>cong A B C D; cong A B E F\<rbrakk> \<Longrightarrow> (cong C D E F)"
and ax_cong_zero1: "\<lbrakk>cong A B C C\<rbrakk> \<Longrightarrow> (cong_zero A B)"
and ax_cong_zero2: "\<lbrakk>cong_zero A B\<rbrakk> \<Longrightarrow> (cong A B C C)"
and ax_false_bet: "\<lbrakk>bet A B C; \<not> bet A B C\<rbrakk> \<Longrightarrow> (False)"
and ax_false_inside: "\<lbrakk>inside B CI0; \<not> inside B CI0\<rbrakk> \<Longrightarrow> (False)"
and ax_false_onc: "\<lbrakk>onc B CI0; \<not> onc B CI0\<rbrakk> \<Longrightarrow> (False)"
and ax_false_on: "\<lbrakk>on B p; \<not> on B p\<rbrakk> \<Longrightarrow> (False)"
and ax_false_sameside: "\<lbrakk>sameside B C p; \<not> sameside B C p\<rbrakk> \<Longrightarrow> (False)"
and ax_generalities1: "\<lbrakk>A ~= B; on A r; on B r; on A s; on B s\<rbrakk> \<Longrightarrow> (r = s)"
and ax_generalities2: "\<lbrakk>center A CI2; center B CI2\<rbrakk> \<Longrightarrow> (A = B)"
and ax_generalities3: "\<lbrakk>center A CI1\<rbrakk> \<Longrightarrow> (inside A CI1)"
and ax_generalities4: "\<lbrakk>center A CI1\<rbrakk> \<Longrightarrow> (\<not> onc A CI1)"
and ax_incidence1: "\<lbrakk>on D p; on D q; on D r; on E p; on F q; on G r; sameside F G p; sameside E F r\<rbrakk> \<Longrightarrow> (\<not> sameside E G q)"
and ax_incidence2: "\<lbrakk>on D p; on D q; on D r; on E p; on F q; on G r; sameside F G p; \<not> sameside E G q; \<not> on G q; E ~= D\<rbrakk> \<Longrightarrow> (sameside E F r)"
and ax_incidence3: "\<lbrakk>on D p; on D q; on D r; on E p; on F q; on G r; sameside F G p; sameside E F r; sameside G I q; sameside F I r\<rbrakk> \<Longrightarrow> (sameside F I p)"
and ax_metric1_1: "\<lbrakk>cong_zero A B\<rbrakk> \<Longrightarrow> (A = B)"
and ax_metric1_2: "(cong_zero A A)"
and ax_metric2: "(cong_leq A A B C)"
and ax_metric3: "(cong A B B A)"
and ax_metric4: "\<lbrakk>A ~= B; A ~= C\<rbrakk> \<Longrightarrow> (cong_angle A B C C B A)"
and ax_metric5_1: "\<lbrakk>cong_angle_zero A B C\<rbrakk> \<Longrightarrow> (cong_angle_leq A B C D E F)"
and ax_metric5_2: "\<lbrakk>right_angle D E F; right_angle G I J; angle_add D E F G I J K L M\<rbrakk> \<Longrightarrow> (cong_angle_leq A B C K L M)"
and ax_metric6: "(cong_area_zero A A B)"
and ax_metric7: "\<lbrakk>cong_area_zero A B C\<rbrakk> \<Longrightarrow> (cong_area_leq A B C D E F)"
and ax_metric8: "(cong_area A B C C A B \<and> cong_area A B C A C B)"
and ax_metric9: "\<lbrakk>cong A B D E; cong B C E F; cong C A F D; cong_angle A B C D E F; cong_angle B C A E F D; cong_angle C A B F D E\<rbrakk> \<Longrightarrow> (cong_area A B C D E F)"
and ax_pasch1: "\<lbrakk>bet A B C; sameside A C s\<rbrakk> \<Longrightarrow> (sameside A B s)"
and ax_pasch2: "\<lbrakk>bet A B C; on A s; \<not> on B s\<rbrakk> \<Longrightarrow> (sameside B C s)"
and ax_pasch3: "\<lbrakk>bet A B C; on B s\<rbrakk> \<Longrightarrow> (\<not> sameside A C s)"
and ax_pasch4: "\<lbrakk>A ~= B; B ~= C; s ~= t; on A t; on B t; on C t; \<not> sameside A C s; on B s\<rbrakk> \<Longrightarrow> (bet A B C)"
and ax_postulate4: "\<lbrakk>right_angle A B C; right_angle D E F\<rbrakk> \<Longrightarrow> (cong_angle A B C D E F)"
and ax_rule1: "\<lbrakk>\<not> on A r; \<not> on B r; \<not> sameside A B r; on A s; on B s\<rbrakk> \<Longrightarrow> (intersects r s)"
and ax_rule2_1: "\<lbrakk>onc A CI2; onc B CI2; \<not> on A s; \<not> on B s; \<not> sameside A B s\<rbrakk> \<Longrightarrow> (intersectslc CI3 r)"
and ax_rule2_2: "\<lbrakk>onc A CI2; inside B CI2; \<not> on A s; \<not> on B s; \<not> sameside A B s\<rbrakk> \<Longrightarrow> (intersectslc CI3 r)"
and ax_rule2_3: "\<lbrakk>inside A CI2; onc B CI2; \<not> on A s; \<not> on B s; \<not> sameside A B s\<rbrakk> \<Longrightarrow> (intersectslc CI3 r)"
and ax_rule2_4: "\<lbrakk>inside A CI2; inside B CI2; \<not> on A s; \<not> on B s; \<not> sameside A B s\<rbrakk> \<Longrightarrow> (intersectslc CI3 r)"
and ax_rule3: "\<lbrakk>inside A CI1; on A r\<rbrakk> \<Longrightarrow> (intersectslc CI2 q)"
and ax_rule4: "\<lbrakk>onc A CI2; onc B CI2; inside A CI3; \<not> onc B CI3; \<not> inside B CI3\<rbrakk> \<Longrightarrow> (intersectscc CI2 CI3)"
and ax_rule5: "\<lbrakk>onc A CI2; inside B CI2; inside A CI3; onc B CI3\<rbrakk> \<Longrightarrow> (intersectscc CI2 CI3)"
and ax_sameside1: "\<lbrakk>\<not> on A q\<rbrakk> \<Longrightarrow> (sameside A A q)"
and ax_sameside2: "\<lbrakk>sameside A B r\<rbrakk> \<Longrightarrow> (sameside B A r)"
and ax_sameside3: "\<lbrakk>sameside A B r\<rbrakk> \<Longrightarrow> (\<not> on A r)"
and ax_sameside4: "\<lbrakk>sameside A B s; sameside A C s\<rbrakk> \<Longrightarrow> (sameside B C s)"
and ax_segment1: "\<lbrakk>bet A B C\<rbrakk> \<Longrightarrow> (segment_add A B B C A C)"
and ax_segment2: "\<lbrakk>center A CI3; center A CI4; onc B CI3; onc C CI4; cong A B A C\<rbrakk> \<Longrightarrow> (CI3 = CI4)"
and ax_segment3_1: "\<lbrakk>center A CI3; onc B CI3; cong A C A B\<rbrakk> \<Longrightarrow> (onc C CI3)"
and ax_segment3_2: "\<lbrakk>center A CI3; onc B CI3; onc C CI3\<rbrakk> \<Longrightarrow> (cong A C A B)"
and ax_segment4_1: "\<lbrakk>center A CI3; onc B CI3; cong_less A C A B\<rbrakk> \<Longrightarrow> (inside C CI3)"
and ax_segment4_2: "\<lbrakk>center A CI3; onc B CI3; inside C CI3\<rbrakk> \<Longrightarrow> (cong_less A C A B)"
and ax_segment_add1: "\<lbrakk>segment_add A B C D E F; cong A B G I\<rbrakk> \<Longrightarrow> (segment_add G I C D E F)"
and ax_segment_add2: "\<lbrakk>segment_add A B C D E F; cong C D G I\<rbrakk> \<Longrightarrow> (segment_add A B G I E F)"
and ax_segment_add3: "\<lbrakk>segment_add A B C D E F; cong E F G I\<rbrakk> \<Longrightarrow> (segment_add A B C D G I)"
and ax_segment_add4: "\<lbrakk>segment_add A B C D E F\<rbrakk> \<Longrightarrow> (segment_add C D A B E F)"
and ax_segment_add5: "\<lbrakk>cong_zero C D\<rbrakk> \<Longrightarrow> (segment_add A B C D A B \<and> segment_add C D A B A B)"
and ax_segment_add6: "\<lbrakk>segment_add A B C D E F; segment_add G I J K L M; cong A B G I; cong C D J K\<rbrakk> \<Longrightarrow> (cong E F L M)"
and ax_segment_add7: "\<lbrakk>segment_add A B C D E F; segment_add G I J K L M; cong A B G I; cong E F L M\<rbrakk> \<Longrightarrow> (cong C D J K)"
and ax_segment_add8: "\<lbrakk>segment_add A B C D E F; segment_add G I J K L M; cong C D J K; cong E F L M\<rbrakk> \<Longrightarrow> (cong A B G I)"
and ax_bet6: "\<lbrakk>on A s; on B s; on C s; A ~= B; A ~= C; B ~= C\<rbrakk> \<Longrightarrow> (bet A B C)\<or>(bet B A C)\<or>(bet A C B)"
and ax_branch_bet: "(bet A B C)\<or>(\<not> bet A B C)"
and ax_branch_inside: "(inside B CI0)\<or>(\<not> inside B CI0)"
and ax_branch_onc: "(onc B CI0)\<or>(\<not> onc B CI0)"
and ax_branch_on: "(on B p)\<or>(\<not> on B p)"
and ax_branch_sameside: "(sameside B C p)\<or>(\<not> sameside B C p)"
and ax_cong_leq1: "\<lbrakk>cong_leq A B C D\<rbrakk> \<Longrightarrow> (cong A B C D)\<or>(cong_less A B C D)"
and ax_sameside5: "\<lbrakk>\<not> on A s; \<not> on B s; \<not> on C s; \<not> sameside A B s\<rbrakk> \<Longrightarrow> (sameside A C s)\<or>(sameside B C s)"
and ax_g1: "(A = B)\<or>(A ~= B)"
and ax_g2: "(p = q)\<or>(p ~= q)"
and ax_g3: "(CI0 = CI1)\<or>(CI0 ~= CI1)"
and ax_intersections1: "\<lbrakk>intersects p q\<rbrakk> \<Longrightarrow> \<exists>(C::point).(on C p \<and> on C q)"
and ax_intersections2: "\<lbrakk>intersectslc CI1 p\<rbrakk> \<Longrightarrow> \<exists>(C::point).(on C q \<and> onc C CI0)"
and ax_intersections3: "\<lbrakk>intersectslc CI1 p\<rbrakk> \<Longrightarrow> \<exists>(C::point)(D::point).(on C q \<and> onc C CI0 \<and> on D q \<and> onc D CI0 \<and> C ~= D)"
and ax_intersections4: "\<lbrakk>inside C CI0; on C q; \<not> inside D CI0; \<not> onc D CI0; on D q\<rbrakk> \<Longrightarrow> \<exists>(E::point).(onc E CI0 \<and> on E q \<and> bet C E D)"
and ax_intersections5: "\<lbrakk>inside C CI0; on C q; D ~= C; on D q\<rbrakk> \<Longrightarrow> \<exists>(E::point).(onc E CI0 \<and> on E q \<and> bet E C D)"
and ax_intersections6: "\<lbrakk>intersectscc CI0 CI1\<rbrakk> \<Longrightarrow> \<exists>(C::point).(onc C CI0 \<and> onc C CI1)"
and ax_intersections7: "\<lbrakk>intersectscc CI0 CI1\<rbrakk> \<Longrightarrow> \<exists>(C::point)(D::point).(onc C CI0 \<and> onc C CI1 \<and> onc D CI0 \<and> onc D CI1 \<and> C ~= D)"
and ax_intersections8: "\<lbrakk>intersectscc CI0 CI1; center C CI0; center D CI1; on C u; on D u; \<not> on E u\<rbrakk> \<Longrightarrow> \<exists>(G::point).(onc G CI0 \<and> onc G CI1 \<and> sameside G E u)"
and ax_intersections9: "\<lbrakk>intersectscc CI0 CI1; center C CI0; center D CI1; on C u; on D u; \<not> on E u\<rbrakk> \<Longrightarrow> \<exists>(G::point).(onc G CI0 \<and> onc G CI1 \<and> \<not> sameside G E u \<and> \<not> on G u)"
and ax_lines_and_circles1: "\<lbrakk>A ~= B\<rbrakk> \<Longrightarrow> \<exists>(r::line).(on A r \<and> on B r)"
and ax_lines_and_circles2: "\<lbrakk>A ~= B\<rbrakk> \<Longrightarrow> \<exists>(CI2::circle).(center A CI2 \<and> onc B CI2)"
and ax_points2: "\<exists>(B::point).(on B p)"
and ax_points3: "\<lbrakk>on B p; on C p; B ~= C\<rbrakk> \<Longrightarrow> \<exists>(D::point).(on D p \<and> bet B D C)"
and ax_points4: "\<lbrakk>on B p; on C p; B ~= C\<rbrakk> \<Longrightarrow> \<exists>(D::point).(on D p \<and> bet B C D)"
and ax_points5: "\<lbrakk>\<not> on B p\<rbrakk> \<Longrightarrow> \<exists>(C::point).(sameside B C p)"
and ax_points6: "\<lbrakk>\<not> on B p\<rbrakk> \<Longrightarrow> \<exists>(C::point).(\<not> on C p \<and> \<not> sameside B C p)"
and ax_points7: "\<exists>(B::point).(onc B CI0)"
and ax_points8: "\<exists>(B::point).(inside B CI0)"
and ax_points9: "\<exists>(B::point).(\<not> inside B CI0 \<and> \<not> onc B CI0)"
and ax_points1: "\<exists>(A::point).(False)"

lemma th_prop1aux2_01 :  assumes  "A ~= B" and "on A p" and "on B p" and "cong A B B C" and "cong B C C A"  shows "(C ~= A)" 

proof - 

from `A ~= B`
have "B ~= A"
  by (rule not_sym)

have "A = C \<or> A ~= C"
  by (subst disj_commute, rule excluded_middle)

   show ?thesis
   proof(cases "A = C")
     case True


      from `cong B C C A` and `A = C`
      have "cong B A A A"
        by simp

      from `cong B A A A`
      have "cong_zero B A"
        by (rule ax_cong_zero1)

      from `cong_zero B A`
      have "B = A"
        by (rule ax_metric1_1)

      from `B ~= A` and `B = A`
      have "False"
        by (rule notE)

      from this
      show ?thesis 
        by (rule FalseE) 
   next
     case False


      from `A ~= C`
      have "C ~= A"
        by (rule not_sym)

      from `C ~= A`
      show ?thesis 
        by assumption
   qed
qed



lemma th_prop1aux2_02 :  assumes  "A ~= B" and "on A p" and "on B p" and "cong A B B C" and "cong B C C A" and "C ~= A"  shows "(C ~= B)" 

proof - 

from `A ~= B`
have "B ~= A"
  by (rule not_sym)

have "B = C \<or> B ~= C"
  by (subst disj_commute, rule excluded_middle)

   show ?thesis
   proof(cases "B = C")
     case True


      from `cong B C C A` and `B = C`
      have "cong B B B A"
        by simp

      from `cong B B B A`
      have "B = A"
        by (rule ax_cong_eq1)

      from `B ~= A` and `B = A`
      have "False"
        by (rule notE)

      from this
      show ?thesis 
        by (rule FalseE) 
   next
     case False


      from `B ~= C`
      have "C ~= B"
        by (rule not_sym)

      from `C ~= B`
      show ?thesis 
        by assumption
   qed
qed



lemma th_prop1aux2_03 :  assumes  "A ~= B" and "on A p" and "on B p" and "cong A B B C" and "cong B C C A" and "C ~= A" and "C ~= B"  shows "(\<not> on C p)" 

proof - 

have "cong A B B A"
  by (rule ax_metric3)

have "cong B A A B"
  by (rule ax_metric3)

have "cong C A A C"
  by (rule ax_metric3)

from `cong A B B C` and `cong A B B A`
have "cong B C B A"
  by (rule ax_cong_transitivity)

from `cong B A A B` and `cong B A A B`
have "cong A B A B"
  by (rule ax_cong_transitivity)

from `cong A B B C` and `cong A B A B`
have "cong B C A B"
  by (rule ax_cong_transitivity)

from `cong B C A B` and `cong B C C A`
have "cong A B C A"
  by (rule ax_cong_transitivity)

from `cong A B C A` and `cong A B A B`
have "cong C A A B"
  by (rule ax_cong_transitivity)

from `cong C A A B` and `cong C A A C`
have "cong A B A C"
  by (rule ax_cong_transitivity)

from `cong A B A C` and `cong A B A B`
have "cong A C A B"
  by (rule ax_cong_transitivity)

from `A ~= B`
obtain alpha::circle
  where "center A alpha" and "onc B alpha"
  using ax_lines_and_circles2 [of "A" "B"] 
  by auto 

from `center A alpha`
have "inside A alpha"
  by (rule ax_generalities3)

from `center A alpha` and `onc B alpha` and `cong A C A B`
have "onc C alpha"
  by (rule ax_segment3_1)

from `C ~= B`
have "B ~= C"
  by (rule not_sym)

from `A ~= B`
have "B ~= A"
  by (rule not_sym)

have "on C p \<or> \<not> on C p"
  by (subst disj_commute, rule excluded_middle)

   show ?thesis
   proof(cases "on C p")
     case True


      from `on A p` and `on B p` and `on C p` and `inside A alpha` and `onc B alpha` and `onc C alpha` and `B ~= C`
      have "bet B A C"
        by (rule ax_circle1)

      from `bet B A C`
      have "bet C A B" and "B ~= A" and "B ~= C" and "\<not> bet A B C"
        using ax_bet1 [of "B" "A" "C"] 
        by auto 

      from `bet C A B`
      have "bet B A C" and "C ~= A" and "C ~= B" and "\<not> bet A C B"
        using ax_bet1 [of "C" "A" "B"] 
        by auto 

      from `B ~= A`
      obtain beta::circle
        where "center B beta" and "onc A beta"
        using ax_lines_and_circles2 [of "B" "A"] 
        by auto 

      from `center B beta`
      have "inside B beta"
        by (rule ax_generalities3)

      from `center B beta` and `onc A beta` and `cong B C B A`
      have "onc C beta"
        by (rule ax_segment3_1)

      from `C ~= A`
      have "A ~= C"
        by (rule not_sym)

      from `on B p` and `on A p` and `on C p` and `inside B beta` and `onc A beta` and `onc C beta` and `A ~= C`
      have "bet A B C"
        by (rule ax_circle1)

      from `\<not> bet A B C` and `bet A B C`
      have "False"
        by (rule notE)

      from this
      show ?thesis 
        by (rule FalseE) 
   next
     case False


      from `\<not> on C p`
      show ?thesis 
        by assumption
   qed
qed

end

(*Transformed by Vernacular package (2016)*)