(*
Title: Examples of proofs in axiomatic system \emph{E}
Authors: Formal system \emph{E} for Euclid's Elements
Formalized by: Sana Stojanovic Djurdjevic
Proved by: ArgoAvigadChecker
Date: 07.01.2017.
 *)

Ltac hyp_of_type t :=
 match goal with
| H1:t |- _ => H1
  end.

Tactic Notation "by" "cases" "on" constr(t) :=
  let H := hyp_of_type t in decompose [or] H; clear H.

Ltac applying l := apply l;repeat split;repeat subst;intuition.
Ltac contradict := solve [intuition].
Ltac substitution := intuition;repeat subst;intuition.
Ltac conclude := assumption||solve [firstorder].
Ltac decompAnd H :=try (progress (decompose [and] H);clear H).

Parameter point : Type.
Parameter line : Type.
Parameter circle : Type.

Parameter eq_point : point -> point -> Prop.
Parameter not_eq_point : point -> point -> Prop.
Parameter eq_line : line -> line -> Prop.
Parameter not_eq_line : line -> line -> Prop.
Parameter eq_circle : circle -> circle -> Prop.
Parameter not_eq_circle : circle -> circle -> Prop.
Parameter on : point -> line -> Prop.
Parameter not_on : point -> line -> Prop.
Parameter intersects : line -> line -> Prop.
Parameter not_intersects : line -> line -> Prop.
Parameter onc : point -> circle -> Prop.
Parameter not_onc : point -> circle -> Prop.
Parameter inside : point -> circle -> Prop.
Parameter not_inside : point -> circle -> Prop.
Parameter center : point -> circle -> Prop.
Parameter not_center : point -> circle -> Prop.
Parameter intersectscc : circle -> circle -> Prop.
Parameter not_intersectscc : circle -> circle -> Prop.
Parameter intersectslc : circle -> line -> Prop.
Parameter not_intersectslc : circle -> line -> Prop.
Parameter comp : point -> point -> point -> point -> Prop.
Parameter not_comp : point -> point -> point -> point -> Prop.
Parameter bet : point -> point -> point -> Prop.
Parameter not_bet : point -> point -> point -> Prop.
Parameter col : point -> point -> point -> Prop.
Parameter not_col : point -> point -> point -> Prop.
Parameter cong : point -> point -> point -> point -> Prop.
Parameter not_cong : point -> point -> point -> point -> Prop.
Parameter cong_area : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_cong_area : point -> point -> point -> point -> point -> point -> Prop.
Parameter cong_area_leq : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_cong_area_leq : point -> point -> point -> point -> point -> point -> Prop.
Parameter cong_area_zero : point -> point -> point -> Prop.
Parameter not_cong_area_zero : point -> point -> point -> Prop.
Parameter area_add : point -> point -> point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter not_area_add : point -> point -> point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter cong_add : point -> point -> point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter not_cong_add : point -> point -> point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter sameside : point -> point -> line -> Prop.
Parameter not_sameside : point -> point -> line -> Prop.
Parameter segment_add : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_segment_add : point -> point -> point -> point -> point -> point -> Prop.
Parameter right_angle : point -> point -> point -> Prop.
Parameter not_right_angle : point -> point -> point -> Prop.
Parameter cong_zero : point -> point -> Prop.
Parameter not_cong_zero : point -> point -> Prop.
Parameter cong_less : point -> point -> point -> point -> Prop.
Parameter not_cong_less : point -> point -> point -> point -> Prop.
Parameter cong_leq : point -> point -> point -> point -> Prop.
Parameter not_cong_leq : point -> point -> point -> point -> Prop.
Parameter cong_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_cong_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter angle_add : point -> point -> point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter not_angle_add : point -> point -> point -> point -> point -> point -> point -> point -> point -> Prop.
Parameter cong_angle_less : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_cong_angle_less : point -> point -> point -> point -> point -> point -> Prop.
Parameter cong_angle_leq : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_cong_angle_leq : point -> point -> point -> point -> point -> point -> Prop.
Parameter cong_angle_zero : point -> point -> point -> Prop.
Parameter not_cong_angle_zero : point -> point -> point -> Prop.

Axiom ax_angle1_1 : forall (A:point) (B:point) (C:point) (s:line), (A <> B /\ A <> C /\ on A s /\ on B s /\ on C s /\ not_bet B A C) -> cong_angle_zero B A C.
Axiom ax_angle1_2 : forall (A:point) (B:point) (C:point) (s:line), (A <> B /\ A <> C /\ on A s /\ on B s /\ cong_angle_zero B A C) -> (on C s /\ not_bet B A C).
Axiom ax_angle2_1 : forall (A:point) (t:line) (u:line) (B:point) (C:point) (D:point), (on A t /\ on A u /\ on B t /\ on C u /\ A <> B /\ A <> C /\ not_on D t /\ not_on D u /\ t <> u /\ angle_add B A D D A C B A C) -> (sameside B D u /\ sameside C D t).
Axiom ax_angle2_2 : forall (A:point) (t:line) (u:line) (B:point) (C:point) (D:point), (on A t /\ on A u /\ on B t /\ on C u /\ A <> B /\ A <> C /\ not_on D t /\ not_on D u /\ t <> u /\ sameside B D u /\ sameside C D t) -> angle_add B A D D A C B A C.
Axiom ax_angle3_1 : forall (A:point) (t:line) (B:point) (C:point) (D:point), (on A t /\ on B t /\ bet A C B /\ not_on D t /\ cong_angle A C D D C B) -> right_angle A C D.
Axiom ax_angle3_2 : forall (A:point) (t:line) (B:point) (C:point) (D:point), (on A t /\ on B t /\ bet A C B /\ not_on D t /\ right_angle A C D) -> cong_angle A C D D C B.
Axiom ax_angle4 : forall (A:point) (u:line) (B:point) (C:point) (v:line) (D:point) (E:point), (on A u /\ on B u /\ on C u /\ on A v /\ on D v /\ on E v /\ B <> A /\ C <> A /\ D <> A /\ E <> A /\ not_bet B A C /\ not_bet D A E) -> cong_angle B A D C A E.
Axiom ax_angle5 : forall (A:point) (t:line) (B:point) (u:line) (C:point) (v:line) (D:point) (I:point) (J:point) (K:point) (L:point) (M:point) (N:point) (P:point) (Q:point) (R:point) (S:point) (T:point) (U:point) (V:point), (on A t /\ on B t /\ on B u /\ on C u /\ on C v /\ on D v /\ B <> C /\ sameside A D v /\ angle_add A B C B C D I J K /\ right_angle L M N /\ right_angle P Q R /\ angle_add L M N P Q R S T U /\ cong_angle_less I J K S T U /\ on V t /\ on V v) -> (intersects t v /\ sameside V A u).
Axiom ax_area1_1 : forall (A:point) (s:line) (B:point) (C:point), (on A s /\ on B s /\ A <> B /\ cong_area_zero A B C) -> on C s.
Axiom ax_area1_2 : forall (A:point) (s:line) (B:point) (C:point), (on A s /\ on B s /\ A <> B /\ on C s) -> cong_area_zero A B C.
Axiom ax_area2_1 : forall (A:point) (t:line) (B:point) (C:point) (D:point), (on A t /\ on B t /\ on C t /\ A <> B /\ A <> C /\ B <> C /\ not_on D t /\ bet A C B) -> area_add A C D D C B A D B.
Axiom ax_area2_2 : forall (A:point) (t:line) (B:point) (C:point) (D:point), (on A t /\ on B t /\ on C t /\ A <> B /\ A <> C /\ B <> C /\ not_on D t /\ area_add A C D D C B A D B) -> bet A C B.
Axiom ax_bet1 : forall (A:point) (B:point) (C:point), bet A B C -> (bet C B A /\ A <> B /\ A <> C /\ not_bet B A C).
Axiom ax_bet2 : forall (A:point) (B:point) (C:point) (s:line), (bet A B C /\ on A s /\ on B s) -> on C s.
Axiom ax_bet3 : forall (A:point) (B:point) (C:point) (s:line), (bet A B C /\ on A s /\ on C s) -> on B s.
Axiom ax_bet4 : forall (A:point) (B:point) (C:point) (D:point), (bet A B C /\ bet A D B) -> bet A D C.
Axiom ax_bet5 : forall (A:point) (B:point) (C:point) (D:point), (bet A B C /\ bet B C D) -> bet A B D.
Axiom ax_bet7 : forall (A:point) (B:point) (C:point) (D:point), (bet A B C /\ bet A B D) -> not_bet C B D.
Axiom ax_circle1 : forall (A:point) (s:line) (B:point) (C:point) (CI4:circle), (on A s /\ on B s /\ on C s /\ inside A CI4 /\ onc B CI4 /\ onc C CI4 /\ B <> C) -> bet B A C.
Axiom ax_circle2_1 : forall (A:point) (CI3:circle) (B:point) (C:point), (inside A CI3 /\ inside B CI3 /\ bet A C B) -> inside C CI3.
Axiom ax_circle2_2 : forall (A:point) (CI3:circle) (B:point) (C:point), (inside A CI3 /\ onc B CI3 /\ bet A C B) -> inside C CI3.
Axiom ax_circle2_3 : forall (A:point) (CI3:circle) (B:point) (C:point), (onc A CI3 /\ inside B CI3 /\ bet A C B) -> inside C CI3.
Axiom ax_circle2_4 : forall (A:point) (CI3:circle) (B:point) (C:point), (onc A CI3 /\ onc B CI3 /\ bet A C B) -> inside C CI3.
Axiom ax_circle3_1 : forall (A:point) (CI3:circle) (C:point) (B:point), (inside A CI3 /\ not_inside C CI3 /\ bet A C B) -> (not_inside B CI3 /\ not_onc B CI3).
Axiom ax_circle3_2 : forall (A:point) (CI3:circle) (C:point) (B:point), (onc A CI3 /\ not_inside C CI3 /\ bet A C B) -> (not_inside B CI3 /\ not_onc B CI3).
Axiom ax_circle4 : forall (CI0:circle) (CI1:circle) (C:point) (D:point) (E:point) (F:point) (v:line), (CI0 <> CI1 /\ intersectscc CI0 CI1 /\ C <> D /\ onc C CI0 /\ onc C CI1 /\ onc D CI0 /\ onc D CI1 /\ center E CI0 /\ center F CI1 /\ on E v /\ on F v) -> not_sameside C D v.
Axiom ax_cong_angle_less : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point) (J:point), angle_add A B C D E F G I J -> (cong_angle_less A B C G I J /\ cong_angle_less D E F G I J).
Axiom ax_cong_angle_reflexivity : forall (A:point) (B:point) (C:point), cong_angle A B C A B C.
Axiom ax_cong_angle_symmetry : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), cong_angle A B C D E F -> cong_angle D E F A B C.
Axiom ax_cong_angle_transitivity : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point) (J:point), (cong_angle A B C D E F /\ cong_angle A B C G I J) -> cong_angle D E F G I J.
Axiom ax_cong_eq1 : forall (A:point) (B:point) (C:point), cong A A B C -> B = C.
Axiom ax_cong_leq2 : forall (A:point) (B:point) (C:point) (D:point), cong A B C D -> cong_leq A B C D.
Axiom ax_cong_leq3 : forall (A:point) (B:point) (C:point) (D:point), cong_less A B C D -> cong_leq A B C D.
Axiom ax_cong_less1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), segment_add A B C D E F -> (cong_less A B E F /\ cong_less C D E F).
Axiom ax_cong_less2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point) (J:point) (K:point), (cong_less A B C D /\ segment_add A B E F G I /\ segment_add C D E F J K) -> cong_less G I J K.
Axiom ax_cong_less3 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (cong_less A B C D /\ cong A B E F) -> cong_less E F C D.
Axiom ax_cong_less4 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (cong_less A B C D /\ cong C D E F) -> cong_less A B E F.
Axiom ax_cong_reflexivity : forall (A:point) (B:point), cong A B A B.
Axiom ax_cong_symmetry1 : forall (A:point) (B:point) (C:point) (D:point), cong A B C D -> cong C D A B.
Axiom ax_cong_symmetry2 : forall (A:point) (B:point) (C:point) (D:point), cong A B C D -> cong B A C D.
Axiom ax_cong_symmetry : forall (A:point) (B:point) (C:point) (D:point), cong A B C D -> cong C D A B.
Axiom ax_cong_transitivity : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (cong A B C D /\ cong A B E F) -> cong C D E F.
Axiom ax_cong_zero1 : forall (A:point) (B:point) (C:point), cong A B C C -> cong_zero A B.
Axiom ax_cong_zero2 : forall (A:point) (B:point) (C:point), cong_zero A B -> cong A B C C.
Axiom ax_false_bet : forall (A:point) (B:point) (C:point), (bet A B C /\ not_bet A B C) -> (False).
Axiom ax_false_inside : forall (B:point) (CI0:circle), (inside B CI0 /\ not_inside B CI0) -> (False).
Axiom ax_false_onc : forall (B:point) (CI0:circle), (onc B CI0 /\ not_onc B CI0) -> (False).
Axiom ax_false_on : forall (B:point) (p:line), (on B p /\ not_on B p) -> (False).
Axiom ax_false_sameside : forall (B:point) (C:point) (p:line), (sameside B C p /\ not_sameside B C p) -> (False).
Axiom ax_generalities1 : forall (A:point) (B:point) (r:line) (s:line), (A <> B /\ on A r /\ on B r /\ on A s /\ on B s) -> r = s.
Axiom ax_generalities2 : forall (A:point) (CI2:circle) (B:point), (center A CI2 /\ center B CI2) -> A = B.
Axiom ax_generalities3 : forall (A:point) (CI1:circle), center A CI1 -> inside A CI1.
Axiom ax_generalities4 : forall (A:point) (CI1:circle), center A CI1 -> not_onc A CI1.
Axiom ax_incidence1 : forall (D:point) (p:line) (q:line) (r:line) (E:point) (F:point) (G:point), (on D p /\ on D q /\ on D r /\ on E p /\ on F q /\ on G r /\ sameside F G p /\ sameside E F r) -> not_sameside E G q.
Axiom ax_incidence2 : forall (D:point) (p:line) (q:line) (r:line) (E:point) (F:point) (G:point), (on D p /\ on D q /\ on D r /\ on E p /\ on F q /\ on G r /\ sameside F G p /\ not_sameside E G q /\ not_on G q /\ E <> D) -> sameside E F r.
Axiom ax_incidence3 : forall (D:point) (p:line) (q:line) (r:line) (E:point) (F:point) (G:point) (I:point), (on D p /\ on D q /\ on D r /\ on E p /\ on F q /\ on G r /\ sameside F G p /\ sameside E F r /\ sameside G I q /\ sameside F I r) -> sameside F I p.
Axiom ax_metric1_1 : forall (A:point) (B:point), cong_zero A B -> A = B.
Axiom ax_metric1_2 : forall (A:point), cong_zero A A.
Axiom ax_metric2 : forall (A:point) (B:point) (C:point), cong_leq A A B C.
Axiom ax_metric3 : forall (A:point) (B:point), cong A B B A.
Axiom ax_metric4 : forall (A:point) (B:point) (C:point), (A <> B /\ A <> C) -> cong_angle A B C C B A.
Axiom ax_metric5_1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), cong_angle_zero A B C -> cong_angle_leq A B C D E F.
Axiom ax_metric5_2 : forall (D:point) (E:point) (F:point) (G:point) (I:point) (J:point) (K:point) (L:point) (M:point) (A:point) (B:point) (C:point), (right_angle D E F /\ right_angle G I J /\ angle_add D E F G I J K L M) -> cong_angle_leq A B C K L M.
Axiom ax_metric6 : forall (A:point) (B:point), cong_area_zero A A B.
Axiom ax_metric7 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), cong_area_zero A B C -> cong_area_leq A B C D E F.
Axiom ax_metric8 : forall (A:point) (B:point) (C:point), (cong_area A B C C A B /\ cong_area A B C A C B).
Axiom ax_metric9 : forall (A:point) (B:point) (D:point) (E:point) (C:point) (F:point), (cong A B D E /\ cong B C E F /\ cong C A F D /\ cong_angle A B C D E F /\ cong_angle B C A E F D /\ cong_angle C A B F D E) -> cong_area A B C D E F.
Axiom ax_pasch1 : forall (A:point) (B:point) (C:point) (s:line), (bet A B C /\ sameside A C s) -> sameside A B s.
Axiom ax_pasch2 : forall (A:point) (B:point) (C:point) (s:line), (bet A B C /\ on A s /\ not_on B s) -> sameside B C s.
Axiom ax_pasch3 : forall (A:point) (B:point) (C:point) (s:line), (bet A B C /\ on B s) -> not_sameside A C s.
Axiom ax_pasch4 : forall (A:point) (B:point) (C:point) (s:line) (t:line), (A <> B /\ B <> C /\ s <> t /\ on A t /\ on B t /\ on C t /\ not_sameside A C s /\ on B s) -> bet A B C.
Axiom ax_postulate4 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point), (right_angle A B C /\ right_angle D E F) -> cong_angle A B C D E F.
Axiom ax_rule1 : forall (A:point) (r:line) (B:point) (s:line), (not_on A r /\ not_on B r /\ not_sameside A B r /\ on A s /\ on B s) -> intersects r s.
Axiom ax_rule2_1 : forall (A:point) (CI2:circle) (B:point) (s:line) (CI3:circle) (r:line), (onc A CI2 /\ onc B CI2 /\ not_on A s /\ not_on B s /\ not_sameside A B s) -> intersectslc CI3 r.
Axiom ax_rule2_2 : forall (A:point) (CI2:circle) (B:point) (s:line) (CI3:circle) (r:line), (onc A CI2 /\ inside B CI2 /\ not_on A s /\ not_on B s /\ not_sameside A B s) -> intersectslc CI3 r.
Axiom ax_rule2_3 : forall (A:point) (CI2:circle) (B:point) (s:line) (CI3:circle) (r:line), (inside A CI2 /\ onc B CI2 /\ not_on A s /\ not_on B s /\ not_sameside A B s) -> intersectslc CI3 r.
Axiom ax_rule2_4 : forall (A:point) (CI2:circle) (B:point) (s:line) (CI3:circle) (r:line), (inside A CI2 /\ inside B CI2 /\ not_on A s /\ not_on B s /\ not_sameside A B s) -> intersectslc CI3 r.
Axiom ax_rule3 : forall (A:point) (CI1:circle) (r:line) (CI2:circle) (q:line), (inside A CI1 /\ on A r) -> intersectslc CI2 q.
Axiom ax_rule4 : forall (A:point) (CI2:circle) (B:point) (CI3:circle), (onc A CI2 /\ onc B CI2 /\ inside A CI3 /\ not_onc B CI3 /\ not_inside B CI3) -> intersectscc CI2 CI3.
Axiom ax_rule5 : forall (A:point) (CI2:circle) (B:point) (CI3:circle), (onc A CI2 /\ inside B CI2 /\ inside A CI3 /\ onc B CI3) -> intersectscc CI2 CI3.
Axiom ax_sameside1 : forall (A:point) (q:line), not_on A q -> sameside A A q.
Axiom ax_sameside2 : forall (A:point) (B:point) (r:line), sameside A B r -> sameside B A r.
Axiom ax_sameside3 : forall (A:point) (B:point) (r:line), sameside A B r -> not_on A r.
Axiom ax_sameside4 : forall (A:point) (B:point) (s:line) (C:point), (sameside A B s /\ sameside A C s) -> sameside B C s.
Axiom ax_segment1 : forall (A:point) (B:point) (C:point), bet A B C -> segment_add A B B C A C.
Axiom ax_segment2 : forall (A:point) (CI3:circle) (CI4:circle) (B:point) (C:point), (center A CI3 /\ center A CI4 /\ onc B CI3 /\ onc C CI4 /\ cong A B A C) -> CI3 = CI4.
Axiom ax_segment3_1 : forall (A:point) (CI3:circle) (B:point) (C:point), (center A CI3 /\ onc B CI3 /\ cong A C A B) -> onc C CI3.
Axiom ax_segment3_2 : forall (A:point) (CI3:circle) (B:point) (C:point), (center A CI3 /\ onc B CI3 /\ onc C CI3) -> cong A C A B.
Axiom ax_segment4_1 : forall (A:point) (CI3:circle) (B:point) (C:point), (center A CI3 /\ onc B CI3 /\ cong_less A C A B) -> inside C CI3.
Axiom ax_segment4_2 : forall (A:point) (CI3:circle) (B:point) (C:point), (center A CI3 /\ onc B CI3 /\ inside C CI3) -> cong_less A C A B.
Axiom ax_segment_add1 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), (segment_add A B C D E F /\ cong A B G I) -> segment_add G I C D E F.
Axiom ax_segment_add2 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), (segment_add A B C D E F /\ cong C D G I) -> segment_add A B G I E F.
Axiom ax_segment_add3 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), (segment_add A B C D E F /\ cong E F G I) -> segment_add A B C D G I.
Axiom ax_segment_add4 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point), segment_add A B C D E F -> segment_add C D A B E F.
Axiom ax_segment_add5 : forall (C:point) (D:point) (A:point) (B:point), cong_zero C D -> (segment_add A B C D A B /\ segment_add C D A B A B).
Axiom ax_segment_add6 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point) (J:point) (K:point) (L:point) (M:point), (segment_add A B C D E F /\ segment_add G I J K L M /\ cong A B G I /\ cong C D J K) -> cong E F L M.
Axiom ax_segment_add7 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point) (J:point) (K:point) (L:point) (M:point), (segment_add A B C D E F /\ segment_add G I J K L M /\ cong A B G I /\ cong E F L M) -> cong C D J K.
Axiom ax_segment_add8 : forall (A:point) (B:point) (C:point) (D:point) (E:point) (F:point) (G:point) (I:point) (J:point) (K:point) (L:point) (M:point), (segment_add A B C D E F /\ segment_add G I J K L M /\ cong C D J K /\ cong E F L M) -> cong A B G I.
Axiom ax_bet6 : forall (A:point) (s:line) (B:point) (C:point), (on A s /\ on B s /\ on C s /\ A <> B /\ A <> C /\ B <> C) -> bet A B C \/ bet B A C \/ bet A C B.
Axiom ax_branch_bet : forall (A:point) (B:point) (C:point), bet A B C \/ not_bet A B C.
Axiom ax_branch_inside : forall (B:point) (CI0:circle), inside B CI0 \/ not_inside B CI0.
Axiom ax_branch_onc : forall (B:point) (CI0:circle), onc B CI0 \/ not_onc B CI0.
Axiom ax_branch_on : forall (B:point) (p:line), on B p \/ not_on B p.
Axiom ax_branch_sameside : forall (B:point) (C:point) (p:line), sameside B C p \/ not_sameside B C p.
Axiom ax_cong_leq1 : forall (A:point) (B:point) (C:point) (D:point), cong_leq A B C D -> cong A B C D \/ cong_less A B C D.
Axiom ax_sameside5 : forall (A:point) (s:line) (B:point) (C:point), (not_on A s /\ not_on B s /\ not_on C s /\ not_sameside A B s) -> sameside A C s \/ sameside B C s.
Axiom ax_g1 : forall (A:point) (B:point), A = B \/ A <> B.
Axiom ax_g2 : forall (p:line) (q:line), p = q \/ p <> q.
Axiom ax_g3 : forall (CI0:circle) (CI1:circle), CI0 = CI1 \/ CI0 <> CI1.
Axiom ax_intersections1 : forall (p:line) (q:line), intersects p q -> exists C:point, (on C p /\ on C q).
Axiom ax_intersections2 : forall (CI1:circle) (p:line) (q:line) (CI0:circle), intersectslc CI1 p -> exists C:point, (on C q /\ onc C CI0).
Axiom ax_intersections3 : forall (CI1:circle) (p:line) (q:line) (CI0:circle), intersectslc CI1 p -> exists C:point, exists D:point, (on C q /\ onc C CI0 /\ on D q /\ onc D CI0 /\ C <> D).
Axiom ax_intersections4 : forall (C:point) (CI0:circle) (q:line) (D:point), (inside C CI0 /\ on C q /\ not_inside D CI0 /\ not_onc D CI0 /\ on D q) -> exists E:point, (onc E CI0 /\ on E q /\ bet C E D).
Axiom ax_intersections5 : forall (C:point) (CI0:circle) (q:line) (D:point), (inside C CI0 /\ on C q /\ D <> C /\ on D q) -> exists E:point, (onc E CI0 /\ on E q /\ bet E C D).
Axiom ax_intersections6 : forall (CI0:circle) (CI1:circle), intersectscc CI0 CI1 -> exists C:point, (onc C CI0 /\ onc C CI1).
Axiom ax_intersections7 : forall (CI0:circle) (CI1:circle), intersectscc CI0 CI1 -> exists C:point, exists D:point, (onc C CI0 /\ onc C CI1 /\ onc D CI0 /\ onc D CI1 /\ C <> D).
Axiom ax_intersections8 : forall (CI0:circle) (CI1:circle) (C:point) (D:point) (u:line) (E:point), (intersectscc CI0 CI1 /\ center C CI0 /\ center D CI1 /\ on C u /\ on D u /\ not_on E u) -> exists G:point, (onc G CI0 /\ onc G CI1 /\ sameside G E u).
Axiom ax_intersections9 : forall (CI0:circle) (CI1:circle) (C:point) (D:point) (u:line) (E:point), (intersectscc CI0 CI1 /\ center C CI0 /\ center D CI1 /\ on C u /\ on D u /\ not_on E u) -> exists G:point, (onc G CI0 /\ onc G CI1 /\ not_sameside G E u /\ not_on G u).
Axiom ax_lines_and_circles1 : forall (A:point) (B:point), A <> B -> exists r:line, (on A r /\ on B r).
Axiom ax_lines_and_circles2 : forall (A:point) (B:point), A <> B -> exists CI2:circle, (center A CI2 /\ onc B CI2).
Axiom ax_points2 : forall (p:line), exists B:point, on B p.
Axiom ax_points3 : forall (B:point) (p:line) (C:point), (on B p /\ on C p /\ B <> C) -> exists D:point, (on D p /\ bet B D C).
Axiom ax_points4 : forall (B:point) (p:line) (C:point), (on B p /\ on C p /\ B <> C) -> exists D:point, (on D p /\ bet B C D).
Axiom ax_points5 : forall (B:point) (p:line), not_on B p -> exists C:point, sameside B C p.
Axiom ax_points6 : forall (B:point) (p:line), not_on B p -> exists C:point, (not_on C p /\ not_sameside B C p).
Axiom ax_points7 : forall (CI0:circle), exists B:point, onc B CI0.
Axiom ax_points8 : forall (CI0:circle), exists B:point, inside B CI0.
Axiom ax_points9 : forall (CI0:circle), exists B:point, (not_inside B CI0 /\ not_onc B CI0).
Axiom ax_points1 : exists A:point, (False).

(* Chapter : Hilbert *)

Theorem th_prop2_01 : forall (B:point) (C:point) (A:point), (B <> C /\ A <> B /\ A <> C) -> exists D:point, (D <> A /\ D <> B /\ cong A B B D /\ cong B D D A).
Proof.
Admitted.

Theorem th_prop2_02 : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ C <> A /\ C <> B /\ D <> C /\ D <> A /\ cong C A A D /\ cong A D D C) -> exists p:line, (on D p /\ on C p).
Proof.
 intros.
 assert (C <> D)  by substitution.
 let Hnew := fresh in  assert ( Hnew : exists u, (on C u /\ on D u)) by applying (ax_lines_and_circles1 C D ) ;destruct Hnew as [u Hnew];decompAnd Hnew.
 conclude.
Qed.

Theorem th_prop2_03 : forall (A:point) (B:point) (C:point) (D:point) (p:line), (A <> B /\ C <> A /\ C <> B /\ D <> C /\ D <> A /\ cong C A A D /\ cong A D D C /\ on D p /\ on C p) -> exists q:line, (on D q /\ on A q).
Proof.
 intros.
 assert (A <> D)  by substitution.
 let Hnew := fresh in  assert ( Hnew : exists s, (on A s /\ on D s)) by applying (ax_lines_and_circles1 A D ) ;destruct Hnew as [s Hnew];decompAnd Hnew.
 conclude.
Qed.

Theorem th_prop2_04 : forall (A:point) (B:point) (C:point) (D:point) (p:line) (q:line), (A <> B /\ C <> A /\ C <> B /\ D <> C /\ D <> A /\ cong C A A D /\ cong A D D C /\ on D p /\ on C p /\ on D q /\ on A q) -> exists alpha:circle, (center A alpha /\ onc B alpha).
Proof.
 intros.
 let Hnew := fresh in  assert ( Hnew : exists alpha, (center A alpha /\ onc B alpha)) by applying (ax_lines_and_circles2 A B ) ;destruct Hnew as [alpha Hnew];decompAnd Hnew.
 conclude.
Qed.

Theorem th_prop2_05 : forall (A:point) (B:point) (C:point) (D:point) (p:line) (q:line) (alpha:circle), (A <> B /\ C <> A /\ C <> B /\ D <> C /\ D <> A /\ cong C A A D /\ cong A D D C /\ on D p /\ on C p /\ on D q /\ on A q /\ center A alpha /\ onc B alpha) -> exists E:point, (on E q /\ onc E alpha /\ bet D A E).
Proof.
 intros.
 assert (inside A alpha) by applying (ax_generalities3 A alpha ) .
 let Hnew := fresh in  assert ( Hnew : exists E, (onc E alpha /\ on E q /\ bet E A D)) by applying (ax_intersections5 A alpha q D ) ;destruct Hnew as [E Hnew];decompAnd Hnew.
 assert (bet D A E /\ E <> A /\ E <> D /\ not_bet A E D) by applying (ax_bet1 E A D ) .
 conclude.
Qed.

Theorem th_prop2_06 : forall (A:point) (B:point) (C:point) (D:point) (p:line) (q:line) (alpha:circle) (E:point), (A <> B /\ C <> A /\ C <> B /\ D <> C /\ D <> A /\ cong C A A D /\ cong A D D C /\ on D p /\ on C p /\ on D q /\ on A q /\ center A alpha /\ onc B alpha /\ on E q /\ onc E alpha /\ bet D A E) -> segment_add D A A E D E.
Proof.
 intros.
 assert (segment_add D A A E D E) by applying (ax_segment1 D A E ) .
 conclude.
Qed.

Theorem th_prop2_07 : forall (B:point) (C:point) (A:point) (D:point) (t:line) (u:line) (alpha2:circle) (I:point), (B <> C /\ A <> B /\ A <> C /\ D <> A /\ D <> B /\ cong A B B D /\ cong B D D A /\ on D t /\ on A t /\ on D u /\ on B u /\ center B alpha2 /\ onc C alpha2 /\ on I u /\ onc I alpha2 /\ bet D B I /\ segment_add D B B I D I) -> segment_add D I D A B I.
Proof.
Admitted.

Theorem th_prop2_08 : forall (A:point) (B:point) (C:point) (D:point) (p:line) (q:line) (alpha:circle) (E:point), (A <> B /\ C <> A /\ C <> B /\ D <> C /\ D <> A /\ cong C A A D /\ cong A D D C /\ on D p /\ on C p /\ on D q /\ on A q /\ center A alpha /\ onc B alpha /\ on E q /\ onc E alpha /\ bet D A E /\ segment_add D A A E D E /\ segment_add D E D C A E) -> cong_less D C D E.
Proof.
 intros.
 assert (cong D A A D) by applying (ax_metric3 D A ) .
 assert (cong_less D A D E /\ cong_less A E D E) by applying (ax_cong_less1 D A A E D E ) .
 assert (cong_less A D D E) by applying (ax_cong_less3 D A D E A D ) .
 assert (cong_less D C D E) by applying (ax_cong_less3 A D D E D C ) .
 conclude.
Qed.

Theorem th_prop2_09 : forall (A:point) (B:point) (C:point) (D:point) (p:line) (q:line) (alpha:circle) (E:point), (A <> B /\ C <> A /\ C <> B /\ D <> C /\ D <> A /\ cong C A A D /\ cong A D D C /\ on D p /\ on C p /\ on D q /\ on A q /\ center A alpha /\ onc B alpha /\ on E q /\ onc E alpha /\ bet D A E /\ segment_add D A A E D E /\ segment_add D E D C A E /\ cong_less D C D E) -> exists beta:circle, (center D beta /\ onc E beta).
Proof.
 intros.
 assert (bet E A D /\ D <> A /\ D <> E /\ not_bet A D E) by applying (ax_bet1 D A E ) .
 let Hnew := fresh in  assert ( Hnew : exists beta5, (center D beta5 /\ onc E beta5)) by applying (ax_lines_and_circles2 D E ) ;destruct Hnew as [beta5 Hnew];decompAnd Hnew.
 conclude.
Qed.

Theorem th_prop2_10 : forall (A:point) (B:point) (C:point) (D:point) (p:line) (q:line) (alpha:circle) (E:point) (beta:circle), (A <> B /\ C <> A /\ C <> B /\ D <> C /\ D <> A /\ cong C A A D /\ cong A D D C /\ on D p /\ on C p /\ on D q /\ on A q /\ center A alpha /\ onc B alpha /\ on E q /\ onc E alpha /\ bet D A E /\ segment_add D A A E D E /\ segment_add D E D C A E /\ cong_less D C D E /\ center D beta /\ onc E beta) -> inside C beta.
Proof.
 intros.
 assert (inside C beta) by applying (ax_segment4_1 D beta E C ) .
 conclude.
Qed.

Theorem th_prop2_11 : forall (A:point) (B:point) (C:point) (D:point) (p:line) (q:line) (alpha:circle) (E:point) (beta:circle), (A <> B /\ C <> A /\ C <> B /\ D <> C /\ D <> A /\ cong C A A D /\ cong A D D C /\ on D p /\ on C p /\ on D q /\ on A q /\ center A alpha /\ onc B alpha /\ on E q /\ onc E alpha /\ bet D A E /\ segment_add D A A E D E /\ segment_add D E D C A E /\ cong_less D C D E /\ center D beta /\ onc E beta /\ inside C beta) -> exists F:point, (onc F beta /\ on F p /\ bet D C F).
Proof.
 intros.
 let Hnew := fresh in  assert ( Hnew : exists F, (onc F beta /\ on F p /\ bet F C D)) by applying (ax_intersections5 C beta p D ) ;destruct Hnew as [F Hnew];decompAnd Hnew.
 assert (bet D C F /\ F <> C /\ F <> D /\ not_bet C F D) by applying (ax_bet1 F C D ) .
 conclude.
Qed.

Theorem th_prop2_12 : forall (A:point) (B:point) (C:point) (D:point) (p:line) (q:line) (alpha:circle) (E:point) (beta:circle) (F:point), (A <> B /\ C <> A /\ C <> B /\ D <> C /\ D <> A /\ cong C A A D /\ cong A D D C /\ on D p /\ on C p /\ on D q /\ on A q /\ center A alpha /\ onc B alpha /\ on E q /\ onc E alpha /\ bet D A E /\ segment_add D A A E D E /\ segment_add D E D C A E /\ cong_less D C D E /\ center D beta /\ onc E beta /\ inside C beta /\ onc F beta /\ on F p /\ bet D C F) -> segment_add D C C F D F.
Proof.
 intros.
 assert (segment_add D C C F D F) by applying (ax_segment1 D C F ) .
 conclude.
Qed.

Theorem th_prop2_13 : forall (A:point) (B:point) (C:point) (D:point) (p:line) (q:line) (alpha:circle) (E:point) (beta:circle) (F:point), (A <> B /\ C <> A /\ C <> B /\ D <> C /\ D <> A /\ cong C A A D /\ cong A D D C /\ on D p /\ on C p /\ on D q /\ on A q /\ center A alpha /\ onc B alpha /\ on E q /\ onc E alpha /\ bet D A E /\ segment_add D A A E D E /\ segment_add D E D C A E /\ cong_less D C D E /\ center D beta /\ onc E beta /\ inside C beta /\ onc F beta /\ on F p /\ bet D C F /\ segment_add D C C F D F) -> cong D F D E.
Proof.
 intros.
 assert (cong D F D E) by applying (ax_segment3_2 D beta E F ) .
 conclude.
Qed.

Theorem th_prop2_14 : forall (B:point) (C:point) (A:point) (D:point) (t:line) (u:line) (alpha2:circle) (I:point) (alpha3:circle) (K:point), (B <> C /\ A <> B /\ A <> C /\ D <> A /\ D <> B /\ cong A B B D /\ cong B D D A /\ on D t /\ on A t /\ on D u /\ on B u /\ center B alpha2 /\ onc C alpha2 /\ on I u /\ onc I alpha2 /\ bet D B I /\ segment_add D B B I D I /\ segment_add D I D A B I /\ cong_less D A D I /\ center D alpha3 /\ onc I alpha3 /\ inside A alpha3 /\ onc K alpha3 /\ on K t /\ bet D A K /\ segment_add D A A K D K /\ cong D K D I) -> segment_add D A B I D K.
Proof.
Admitted.

Theorem th_prop2_15 : forall (B:point) (C:point) (A:point) (D:point) (t:line) (u:line) (alpha2:circle) (I:point) (alpha3:circle) (K:point), (B <> C /\ A <> B /\ A <> C /\ D <> A /\ D <> B /\ cong A B B D /\ cong B D D A /\ on D t /\ on A t /\ on D u /\ on B u /\ center B alpha2 /\ onc C alpha2 /\ on I u /\ onc I alpha2 /\ bet D B I /\ segment_add D B B I D I /\ segment_add D I D A B I /\ cong_less D A D I /\ center D alpha3 /\ onc I alpha3 /\ inside A alpha3 /\ onc K alpha3 /\ on K t /\ bet D A K /\ segment_add D A A K D K /\ cong D K D I /\ segment_add D A B I D K) -> cong A K B I.
Proof.
Admitted.

Theorem th_prop2_16 : forall (A:point) (B:point) (C:point) (D:point) (p:line) (q:line) (alpha:circle) (E:point) (beta:circle) (F:point), (A <> B /\ C <> A /\ C <> B /\ D <> C /\ D <> A /\ cong C A A D /\ cong A D D C /\ on D p /\ on C p /\ on D q /\ on A q /\ center A alpha /\ onc B alpha /\ on E q /\ onc E alpha /\ bet D A E /\ segment_add D A A E D E /\ segment_add D E D C A E /\ cong_less D C D E /\ center D beta /\ onc E beta /\ inside C beta /\ onc F beta /\ on F p /\ bet D C F /\ segment_add D C C F D F /\ cong D F D E /\ segment_add D C A E D F /\ cong C F A E) -> cong A E A B.
Proof.
 intros.
 assert (cong A E A B) by applying (ax_segment3_2 A alpha B E ) .
 conclude.
Qed.

Theorem th_prop2_17 : forall (A:point) (B:point) (C:point) (D:point) (p:line) (q:line) (alpha:circle) (E:point) (beta:circle) (F:point), (A <> B /\ C <> A /\ C <> B /\ D <> C /\ D <> A /\ cong C A A D /\ cong A D D C /\ on D p /\ on C p /\ on D q /\ on A q /\ center A alpha /\ onc B alpha /\ on E q /\ onc E alpha /\ bet D A E /\ segment_add D A A E D E /\ segment_add D E D C A E /\ cong_less D C D E /\ center D beta /\ onc E beta /\ inside C beta /\ onc F beta /\ on F p /\ bet D C F /\ segment_add D C C F D F /\ cong D F D E /\ segment_add D C A E D F /\ cong C F A E /\ cong A E A B) -> cong C F A B.
Proof.
 intros.
 assert (cong A E C F) by applying (ax_cong_symmetry C F A E ) .
 assert (cong A B C F) by applying (ax_cong_transitivity A E A B C F ) .
 assert (cong C F A B) by applying (ax_cong_symmetry A B C F ) .
 conclude.
Qed.

