theory th_14_complete_proof
imports Main 
begin
typedecl point
typedecl line
typedecl plane

consts eq_point ::  "point \<Rightarrow> point \<Rightarrow>  bool "
consts not_eq_point ::  "point \<Rightarrow> point \<Rightarrow>  bool "
consts eq_line ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts not_eq_line ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts eq_plane ::  "plane \<Rightarrow> plane \<Rightarrow>  bool "
consts not_eq_plane ::  "plane \<Rightarrow> plane \<Rightarrow>  bool "
consts inc_po_l ::  "point \<Rightarrow> line \<Rightarrow>  bool "
consts not_inc_po_l ::  "point \<Rightarrow> line \<Rightarrow>  bool "
consts inc_po_pl ::  "point \<Rightarrow> plane \<Rightarrow>  bool "
consts not_inc_po_pl ::  "point \<Rightarrow> plane \<Rightarrow>  bool "
consts inc_l_pl ::  "line \<Rightarrow> plane \<Rightarrow>  bool "
consts not_inc_l_pl ::  "line \<Rightarrow> plane \<Rightarrow>  bool "
consts int_l_l ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts not_int_l_l ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts int_l_pl ::  "line \<Rightarrow> plane \<Rightarrow>  bool "
consts not_int_l_pl ::  "line \<Rightarrow> plane \<Rightarrow>  bool "
consts int_pl_pl ::  "plane \<Rightarrow> plane \<Rightarrow>  bool "
consts not_int_pl_pl ::  "plane \<Rightarrow> plane \<Rightarrow>  bool "
consts cop ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cop ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts col ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_col ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts bet ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_bet ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong_angle ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong_angle ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts order ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_order ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cut ::  "line \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cut ::  "line \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts pash ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> line \<Rightarrow> plane \<Rightarrow>  bool "
consts not_pash ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> line \<Rightarrow> plane \<Rightarrow>  bool "
consts parallel ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts not_parallel ::  "line \<Rightarrow> line \<Rightarrow>  bool "

axiomatization where 

ax_cut_1: "\<lbrakk>\<not> inc_po_l B p; \<not> inc_po_l C p; inc_po_l D p; bet B D C\<rbrakk> \<Longrightarrow> (cut p B C)"
and ax_D11b: "\<lbrakk>inc_po_l A q; \<not> inc_po_pl A gamma\<rbrakk> \<Longrightarrow> (\<not> inc_l_pl q gamma)"
and ax_D11: "\<lbrakk>inc_l_pl q gamma; inc_po_l A q\<rbrakk> \<Longrightarrow> (inc_po_pl A gamma)"
and ax_D1a: "\<lbrakk>A ~= B; inc_po_l A s; inc_po_l B s; \<not> inc_po_l C s\<rbrakk> \<Longrightarrow> (\<not> col A B C)"
and ax_D1: "\<lbrakk>inc_po_l A s; inc_po_l B s; inc_po_l C s\<rbrakk> \<Longrightarrow> (col A B C)"
and ax_D2a: "\<lbrakk>A ~= B; inc_po_l A s; inc_po_l B s; \<not> col A B C\<rbrakk> \<Longrightarrow> (\<not> inc_po_l C s)"
and ax_D3a: "\<lbrakk>\<not> col A B C; inc_po_pl A beta1; inc_po_pl B beta1; inc_po_pl C beta1; \<not> inc_po_pl D beta1\<rbrakk> \<Longrightarrow> (\<not> cop A B C D)"
and ax_D3: "\<lbrakk>inc_po_pl A beta1; inc_po_pl B beta1; inc_po_pl C beta1; inc_po_pl D beta1\<rbrakk> \<Longrightarrow> (cop A B C D)"
and ax_D4a: "\<lbrakk>\<not> col A B C; inc_po_pl A beta1; inc_po_pl B beta1; inc_po_pl C beta1; \<not> cop A B C D\<rbrakk> \<Longrightarrow> (\<not> inc_po_pl D beta1)"
and ax_D5a: "\<lbrakk>p ~= q; \<not> int_l_l p q; inc_po_l C p\<rbrakk> \<Longrightarrow> (\<not> inc_po_l C q)"
and ax_D5: "\<lbrakk>p ~= q; inc_po_l C p; inc_po_l C q\<rbrakk> \<Longrightarrow> (int_l_l p q)"
and ax_D7a: "\<lbrakk>alpha ~= beta; inc_po_pl C alpha; \<not> int_pl_pl alpha beta\<rbrakk> \<Longrightarrow> (\<not> inc_po_pl C beta)"
and ax_D7: "\<lbrakk>alpha ~= beta; inc_po_pl C alpha; inc_po_pl C beta\<rbrakk> \<Longrightarrow> (int_pl_pl alpha beta)"
and ax_D9a: "\<lbrakk>\<not> inc_l_pl p beta; \<not> int_l_pl p beta; inc_po_l C p\<rbrakk> \<Longrightarrow> (\<not> inc_po_pl C beta)"
and ax_D9b: "\<lbrakk>\<not> inc_l_pl p beta; \<not> int_l_pl p beta; inc_po_pl C beta\<rbrakk> \<Longrightarrow> (\<not> inc_po_l C p)"
and ax_D9: "\<lbrakk>\<not> inc_l_pl p beta; inc_po_l C p; inc_po_pl C beta\<rbrakk> \<Longrightarrow> (int_l_pl p beta)"
and ax_false_bet: "\<lbrakk>bet A B C; \<not> bet A B C\<rbrakk> \<Longrightarrow> (False)"
and ax_false_col: "\<lbrakk>col A B C; \<not> col A B C\<rbrakk> \<Longrightarrow> (False)"
and ax_false_cop: "\<lbrakk>cop A B C D; \<not> cop A B C D\<rbrakk> \<Longrightarrow> (False)"
and ax_false_cut: "\<lbrakk>cut p B C; \<not> cut p B C\<rbrakk> \<Longrightarrow> (False)"
and ax_false_inc_l_pl: "\<lbrakk>inc_l_pl p beta; \<not> inc_l_pl p beta\<rbrakk> \<Longrightarrow> (False)"
and ax_false_inc_po_l: "\<lbrakk>inc_po_l A q; \<not> inc_po_l A q\<rbrakk> \<Longrightarrow> (False)"
and ax_false_inc_po_pl: "\<lbrakk>inc_po_pl A beta; \<not> inc_po_pl A beta\<rbrakk> \<Longrightarrow> (False)"
and ax_false_int_l_l: "\<lbrakk>int_l_l p q; \<not> int_l_l p q\<rbrakk> \<Longrightarrow> (False)"
and ax_false_int_l_pl: "\<lbrakk>int_l_pl p beta; \<not> int_l_pl p beta\<rbrakk> \<Longrightarrow> (False)"
and ax_false_int_pl_pl: "\<lbrakk>int_pl_pl alpha beta; \<not> int_pl_pl alpha beta\<rbrakk> \<Longrightarrow> (False)"
and ax_false_pash: "\<lbrakk>pash A B C s beta1; \<not> pash A B C s beta1\<rbrakk> \<Longrightarrow> (False)"
and ax_I2: "\<lbrakk>A ~= B; inc_po_l A r; inc_po_l B r; inc_po_l A s; inc_po_l B s\<rbrakk> \<Longrightarrow> (r = s)"
and ax_I5: "\<lbrakk>\<not> col A B C; inc_po_pl A alpha1; inc_po_pl B alpha1; inc_po_pl C alpha1; inc_po_pl A beta1; inc_po_pl B beta1; inc_po_pl C beta1\<rbrakk> \<Longrightarrow> (alpha1 = beta1)"
and ax_I6: "\<lbrakk>A ~= B; inc_po_l A r; inc_po_l B r; inc_po_pl A alpha1; inc_po_pl B alpha1\<rbrakk> \<Longrightarrow> (inc_l_pl r alpha1)"
and ax_II1: "\<lbrakk>bet A B C\<rbrakk> \<Longrightarrow> (A ~= B \<and> A ~= C \<and> B ~= C \<and> col A B C \<and> bet C B A)"
and ax_II3: "\<lbrakk>A ~= B; A ~= C; B ~= C; bet A B C\<rbrakk> \<Longrightarrow> (\<not> bet B C A \<and> \<not> bet C A B)"
and ax_pash_1: "\<lbrakk>\<not> col A B C; inc_po_pl A beta1; inc_po_pl B beta1; inc_po_pl C beta1; inc_l_pl s beta1; \<not> inc_po_l A s; \<not> inc_po_l B s; \<not> inc_po_l C s; cut s B C\<rbrakk> \<Longrightarrow> (pash A B C s beta1)"
and ax_pash_2: "\<lbrakk>pash A B C s beta1\<rbrakk> \<Longrightarrow> (\<not> col A B C \<and> inc_po_pl A beta1 \<and> inc_po_pl B beta1 \<and> inc_po_pl C beta1 \<and> inc_l_pl s beta1 \<and> \<not> inc_po_l A s \<and> \<not> inc_po_l B s \<and> \<not> inc_po_l C s \<and> cut s B C)"
and ax_sym_col1: "\<lbrakk>col A B C\<rbrakk> \<Longrightarrow> (col B C A)"
and ax_sym_col2: "\<lbrakk>col A B C\<rbrakk> \<Longrightarrow> (col B A C)"
and ax_sym_col: "\<lbrakk>col A B C\<rbrakk> \<Longrightarrow> (col A C B \<and> col B A C \<and> col B C A \<and> col C A B \<and> col C B A)"
and ax_sym_cop1: "\<lbrakk>cop A B C D\<rbrakk> \<Longrightarrow> (cop B C D A)"
and ax_sym_cop2: "\<lbrakk>cop A B C D\<rbrakk> \<Longrightarrow> (cop B A C D)"
and ax_sym_cop: "\<lbrakk>cop A B C D\<rbrakk> \<Longrightarrow> (cop A B D C \<and> cop A C B D \<and> cop A C D B \<and> cop A D B C \<and> cop A D C B \<and> cop B A C D \<and> cop B A D C \<and> cop B C A D \<and> cop B C D A \<and> cop B D A C \<and> cop B D C A \<and> cop C A B D \<and> cop C A D B \<and> cop C B A D \<and> cop C B D A \<and> cop C D A B \<and> cop C D B A \<and> cop D A B C \<and> cop D A C B \<and> cop D B A C \<and> cop D B C A \<and> cop D C A B \<and> cop D C B A)"
and ax_sym_int_l_l: "\<lbrakk>int_l_l p q\<rbrakk> \<Longrightarrow> (int_l_l q p)"
and ax_sym_int_pl_pl: "\<lbrakk>int_pl_pl alpha beta\<rbrakk> \<Longrightarrow> (int_pl_pl beta alpha)"
and ax_sym_ncol1: "\<lbrakk>\<not> col A B C\<rbrakk> \<Longrightarrow> (\<not> col B C A)"
and ax_sym_ncol2: "\<lbrakk>\<not> col A B C\<rbrakk> \<Longrightarrow> (\<not> col B A C)"
and ax_sym_ncol: "\<lbrakk>\<not> col A B C\<rbrakk> \<Longrightarrow> (\<not> col A C B \<and> \<not> col B A C \<and> \<not> col B C A \<and> \<not> col C A B \<and> \<not> col C B A)"
and ax_sym_ncop1: "\<lbrakk>\<not> cop A B C D\<rbrakk> \<Longrightarrow> (\<not> cop B C D A)"
and ax_sym_ncop2: "\<lbrakk>\<not> cop A B C D\<rbrakk> \<Longrightarrow> (\<not> cop B A C D)"
and ax_sym_ncop: "\<lbrakk>\<not> cop A B C D\<rbrakk> \<Longrightarrow> (\<not> cop A B D C \<and> \<not> cop A C B D \<and> \<not> cop A C D B \<and> \<not> cop A D B C \<and> \<not> cop A D C B \<and> \<not> cop B A C D \<and> \<not> cop B A D C \<and> \<not> cop B C A D \<and> \<not> cop B C D A \<and> \<not> cop B D A C \<and> \<not> cop B D C A \<and> \<not> cop C A B D \<and> \<not> cop C A D B \<and> \<not> cop C B A D \<and> \<not> cop C B D A \<and> \<not> cop C D A B \<and> \<not> cop C D B A \<and> \<not> cop D A B C \<and> \<not> cop D A C B \<and> \<not> cop D B A C \<and> \<not> cop D B C A \<and> \<not> cop D C A B \<and> \<not> cop D C B A)"
and ax_sym_nint_l_l: "\<lbrakk>\<not> int_l_l p q\<rbrakk> \<Longrightarrow> (\<not> int_l_l q p)"
and ax_sym_nint_pl_pl: "\<lbrakk>\<not> int_pl_pl alpha beta\<rbrakk> \<Longrightarrow> (\<not> int_pl_pl beta alpha)"
and ax_branch_bet: "(bet A B C)\<or>(\<not> bet A B C)"
and ax_branch_col: "\<lbrakk>A ~= B; A ~= C; B ~= C\<rbrakk> \<Longrightarrow> (col A B C)\<or>(\<not> col A B C)"
and ax_branch_cop: "\<lbrakk>A ~= B; A ~= C; A ~= D; B ~= C; B ~= D; C ~= D\<rbrakk> \<Longrightarrow> (cop A B C D)\<or>(\<not> cop A B C D)"
and ax_branch_cut: "\<lbrakk>B ~= C\<rbrakk> \<Longrightarrow> (cut p B C)\<or>(\<not> cut p B C)"
and ax_branch_inc_l_pl: "(inc_l_pl p beta)\<or>(\<not> inc_l_pl p beta)"
and ax_branch_inc_po_l: "(inc_po_l A q)\<or>(\<not> inc_po_l A q)"
and ax_branch_inc_po_pl: "(inc_po_pl A beta)\<or>(\<not> inc_po_pl A beta)"
and ax_branch_int_l_l: "\<lbrakk>p ~= q\<rbrakk> \<Longrightarrow> (int_l_l p q)\<or>(\<not> int_l_l p q)"
and ax_branch_int_l_pl: "(int_l_pl p beta)\<or>(\<not> int_l_pl p beta)"
and ax_branch_int_pl_pl: "\<lbrakk>alpha ~= beta\<rbrakk> \<Longrightarrow> (int_pl_pl alpha beta)\<or>(\<not> int_pl_pl alpha beta)"
and ax_branch_pash: "\<lbrakk>A ~= B; A ~= C; B ~= C\<rbrakk> \<Longrightarrow> (pash A B C s beta1)\<or>(\<not> pash A B C s beta1)"
and ax_II4: "\<lbrakk>pash A B C s beta1\<rbrakk> \<Longrightarrow> (cut s C A)\<or>(cut s A B)"
and ax_g1: "(A = B)\<or>(A ~= B)"
and ax_g2: "(p = q)\<or>(p ~= q)"
and ax_g3: "(alpha = beta)\<or>(alpha ~= beta)"
and ax_cut_2: "\<lbrakk>cut p B C\<rbrakk> \<Longrightarrow> \<exists>(D::point).(\<not> inc_po_l B p \<and> \<not> inc_po_l C p \<and> inc_po_l D p \<and> bet B D C)"
and ax_D10: "\<lbrakk>int_l_pl p beta\<rbrakk> \<Longrightarrow> \<exists>(C::point).(inc_po_l C p \<and> inc_po_pl C beta \<and> \<not> inc_l_pl p beta)"
and ax_D11a: "\<lbrakk>\<not> inc_l_pl p beta\<rbrakk> \<Longrightarrow> \<exists>(C::point).(inc_po_l C p \<and> \<not> inc_po_pl C beta)"
and ax_D2: "\<lbrakk>col A B C\<rbrakk> \<Longrightarrow> \<exists>(s::line).(inc_po_l A s \<and> inc_po_l B s \<and> inc_po_l C s)"
and ax_D4: "\<lbrakk>cop A B C D\<rbrakk> \<Longrightarrow> \<exists>(beta1::plane).(inc_po_pl A beta1 \<and> inc_po_pl B beta1 \<and> inc_po_pl C beta1 \<and> inc_po_pl D beta1)"
and ax_D6: "\<lbrakk>int_l_l p q\<rbrakk> \<Longrightarrow> \<exists>(C::point).(p ~= q \<and> inc_po_l C p \<and> inc_po_l C q)"
and ax_D8: "\<lbrakk>int_pl_pl alpha beta\<rbrakk> \<Longrightarrow> \<exists>(C::point).(alpha ~= beta \<and> inc_po_pl C alpha \<and> inc_po_pl C beta)"
and ax_I1: "\<lbrakk>A ~= B\<rbrakk> \<Longrightarrow> \<exists>(r::line).(inc_po_l A r \<and> inc_po_l B r)"
and ax_I3a: "\<exists>(B::point)(C::point).(B ~= C \<and> inc_po_l B p \<and> inc_po_l C p)"
and ax_I4a: "\<lbrakk>\<not> col A B C\<rbrakk> \<Longrightarrow> \<exists>(alpha1::plane).(inc_po_pl A alpha1 \<and> inc_po_pl B alpha1 \<and> inc_po_pl C alpha1)"
and ax_I4b: "\<exists>(B::point).(inc_po_pl B alpha)"
and ax_I7: "\<lbrakk>alpha ~= beta; inc_po_pl C alpha; inc_po_pl C beta\<rbrakk> \<Longrightarrow> \<exists>(D::point).(C ~= D \<and> inc_po_pl D alpha \<and> inc_po_pl D beta)"
and ax_II2: "\<lbrakk>A ~= B\<rbrakk> \<Longrightarrow> \<exists>(C::point).(bet A B C)"
and ax_I3b: "\<exists>(A::point)(B::point)(C::point).(\<not> col A B C)"
and ax_I8: "\<exists>(A::point)(B::point)(C::point)(D::point).(\<not> cop A B C D)"

lemma th_14_01 :  assumes  "\<not> inc_po_pl A alpha" and "\<not> inc_po_pl B alpha" and "\<not> inc_po_pl C alpha" and "\<not> col A B C" and "inc_po_l A p" and "inc_po_l B p" and "inc_po_l B q" and "inc_po_l C q" and "inc_po_l C r" and "inc_po_l A r" and "inc_po_pl D alpha" and "inc_po_l D p" and "inc_po_pl E alpha" and "inc_po_l E q" and "inc_po_pl F alpha" and "inc_po_l F r"  shows "\<exists>(beta::plane).(inc_po_pl A beta \<and> inc_po_pl B beta \<and> inc_po_pl C beta)" 

proof - 

from `\<not> col A B C`
obtain beta::plane
  where "inc_po_pl A beta" and "inc_po_pl B beta" and "inc_po_pl C beta"
  using ax_I4a [of "A" "B" "C"] 
  by auto 

from `inc_po_pl A beta` and `inc_po_pl B beta` and `inc_po_pl C beta`
have ?thesis
  by auto 

from this
show ?thesis 
.
qed



lemma th_14_02 :  assumes  "\<not> inc_po_pl A alpha" and "\<not> inc_po_pl B alpha" and "\<not> inc_po_pl C alpha" and "\<not> col A B C" and "inc_po_l A p" and "inc_po_l B p" and "inc_po_l B q" and "inc_po_l C q" and "inc_po_l C r" and "inc_po_l A r" and "inc_po_pl D alpha" and "inc_po_l D p" and "inc_po_pl E alpha" and "inc_po_l E q" and "inc_po_pl F alpha" and "inc_po_l F r" and "inc_po_pl A beta" and "inc_po_pl B beta" and "inc_po_pl C beta"  shows "(inc_l_pl p beta)" 

proof - 

from `inc_po_l A r` and `inc_po_l A r` and `inc_po_l C r`
have "col A A C"
  by (rule ax_D1)

have "A = B \<or> A ~= B"
  by (subst disj_commute, rule excluded_middle)

   show ?thesis
   proof(cases "A = B")
     case True


      from `col A A C` and `A = B`
      have "col A B C"
        by simp

      from `\<not> col A B C` and `col A B C`
      have "False"
        by (rule notE)

      from this
      show ?thesis 
        by (rule FalseE) 
   next
     case False


      from `A ~= B` and `inc_po_l A p` and `inc_po_l B p` and `inc_po_pl A beta` and `inc_po_pl B beta`
      have "inc_l_pl p beta"
        by (rule ax_I6)

      from `inc_l_pl p beta`
      show ?thesis 
        by assumption
   qed
qed



lemma th_14_03 :  assumes  "\<not> inc_po_pl A alpha" and "\<not> inc_po_pl B alpha" and "\<not> inc_po_pl C alpha" and "\<not> col A B C" and "inc_po_l A p" and "inc_po_l B p" and "inc_po_l B q" and "inc_po_l C q" and "inc_po_l C r" and "inc_po_l A r" and "inc_po_pl D alpha" and "inc_po_l D p" and "inc_po_pl E alpha" and "inc_po_l E q" and "inc_po_pl F alpha" and "inc_po_l F r" and "inc_po_pl A beta" and "inc_po_pl B beta" and "inc_po_pl C beta" and "inc_l_pl p beta"  shows "(inc_l_pl q beta)" 

proof - 

from `inc_po_l A p` and `inc_po_l B p` and `inc_po_l B p`
have "col A B B"
  by (rule ax_D1)

have "B = C \<or> B ~= C"
  by (subst disj_commute, rule excluded_middle)

   show ?thesis
   proof(cases "B = C")
     case True


      from `col A B B` and `B = C`
      have "col A B C"
        by simp

      from `\<not> col A B C` and `col A B C`
      have "False"
        by (rule notE)

      from this
      show ?thesis 
        by (rule FalseE) 
   next
     case False


      from `B ~= C` and `inc_po_l B q` and `inc_po_l C q` and `inc_po_pl B beta` and `inc_po_pl C beta`
      have "inc_l_pl q beta"
        by (rule ax_I6)

      from `inc_l_pl q beta`
      show ?thesis 
        by assumption
   qed
qed



lemma th_14_04 :  assumes  "\<not> inc_po_pl A alpha" and "\<not> inc_po_pl B alpha" and "\<not> inc_po_pl C alpha" and "\<not> col A B C" and "inc_po_l A p" and "inc_po_l B p" and "inc_po_l B q" and "inc_po_l C q" and "inc_po_l C r" and "inc_po_l A r" and "inc_po_pl D alpha" and "inc_po_l D p" and "inc_po_pl E alpha" and "inc_po_l E q" and "inc_po_pl F alpha" and "inc_po_l F r" and "inc_po_pl A beta" and "inc_po_pl B beta" and "inc_po_pl C beta" and "inc_l_pl p beta" and "inc_l_pl q beta"  shows "(inc_l_pl r beta)" 

proof - 

from `inc_po_l A p` and `inc_po_l B p` and `inc_po_l A p`
have "col A B A"
  by (rule ax_D1)

have "A = C \<or> A ~= C"
  by (subst disj_commute, rule excluded_middle)

   show ?thesis
   proof(cases "A = C")
     case True


      from `col A B A` and `A = C`
      have "col A B C"
        by simp

      from `\<not> col A B C` and `col A B C`
      have "False"
        by (rule notE)

      from this
      show ?thesis 
        by (rule FalseE) 
   next
     case False


      from `A ~= C` and `inc_po_l A r` and `inc_po_l C r` and `inc_po_pl A beta` and `inc_po_pl C beta`
      have "inc_l_pl r beta"
        by (rule ax_I6)

      from `inc_l_pl r beta`
      show ?thesis 
        by assumption
   qed
qed



lemma th_14_05 :  assumes  "\<not> inc_po_pl A alpha" and "\<not> inc_po_pl B alpha" and "\<not> inc_po_pl C alpha" and "\<not> col A B C" and "inc_po_l A p" and "inc_po_l B p" and "inc_po_l B q" and "inc_po_l C q" and "inc_po_l C r" and "inc_po_l A r" and "inc_po_pl D alpha" and "inc_po_l D p" and "inc_po_pl E alpha" and "inc_po_l E q" and "inc_po_pl F alpha" and "inc_po_l F r" and "inc_po_pl A beta" and "inc_po_pl B beta" and "inc_po_pl C beta" and "inc_l_pl p beta" and "inc_l_pl q beta" and "inc_l_pl r beta"  shows "(inc_po_pl D beta \<and> inc_po_pl E beta \<and> inc_po_pl F beta)" 

proof - 

from `inc_l_pl p beta` and `inc_po_l D p`
have "inc_po_pl D beta"
  by (rule ax_D11)

from `inc_l_pl q beta` and `inc_po_l E q`
have "inc_po_pl E beta"
  by (rule ax_D11)

from `inc_l_pl r beta` and `inc_po_l F r`
have "inc_po_pl F beta"
  by (rule ax_D11)

from `inc_po_pl D beta` and `inc_po_pl E beta` and `inc_po_pl F beta`
have ?thesis
  by -((rule conjI, assumption)+, assumption)

from this
show ?thesis 
.
qed



lemma th_14_06 :  assumes  "\<not> inc_po_pl B alpha" and "\<not> inc_po_pl C alpha" and "\<not> inc_po_pl D alpha" and "\<not> col B C D" and "inc_po_l B t" and "inc_po_l C t" and "inc_po_l C u" and "inc_po_l D u" and "inc_po_l D v" and "inc_po_l B v" and "inc_po_pl I alpha" and "inc_po_l I t" and "inc_po_pl J alpha" and "inc_po_l J u" and "inc_po_pl K alpha" and "inc_po_l K v" and "inc_po_pl B gamma3" and "inc_po_pl C gamma3" and "inc_po_pl D gamma3" and "inc_l_pl t gamma3" and "inc_l_pl u gamma3" and "inc_l_pl v gamma3" and "inc_po_pl I gamma3" and "inc_po_pl J gamma3" and "inc_po_pl K gamma3"  shows "\<exists>(t1::line).(inc_l_pl t1 alpha \<and> inc_l_pl t1 gamma3)" 
sorry 


lemma th_14_07 :  assumes  "\<not> inc_po_pl B alpha" and "\<not> inc_po_pl C alpha" and "\<not> inc_po_pl D alpha" and "\<not> col B C D" and "inc_po_l B t" and "inc_po_l C t" and "inc_po_l C u" and "inc_po_l D u" and "inc_po_l D v" and "inc_po_l B v" and "inc_po_pl I alpha" and "inc_po_l I t" and "inc_po_pl J alpha" and "inc_po_l J u" and "inc_po_pl K alpha" and "inc_po_l K v" and "inc_po_pl B gamma3" and "inc_po_pl C gamma3" and "inc_po_pl D gamma3" and "inc_l_pl t gamma3" and "inc_l_pl u gamma3" and "inc_l_pl v gamma3" and "inc_po_pl I gamma3" and "inc_po_pl J gamma3" and "inc_po_pl K gamma3" and "inc_l_pl t1 alpha" and "inc_l_pl t1 gamma3"  shows "\<exists>(N::point)(P::point).(N ~= P \<and> inc_po_l N t1 \<and> inc_po_l P t1)" 
sorry 


lemma th_14_08 :  assumes  "\<not> inc_po_pl B alpha" and "\<not> inc_po_pl C alpha" and "\<not> inc_po_pl D alpha" and "\<not> col B C D" and "inc_po_l B t" and "inc_po_l C t" and "inc_po_l C u" and "inc_po_l D u" and "inc_po_l D v" and "inc_po_l B v" and "inc_po_pl I alpha" and "inc_po_l I t" and "inc_po_pl J alpha" and "inc_po_l J u" and "inc_po_pl K alpha" and "inc_po_l K v" and "inc_po_pl B gamma3" and "inc_po_pl C gamma3" and "inc_po_pl D gamma3" and "inc_l_pl t gamma3" and "inc_l_pl u gamma3" and "inc_l_pl v gamma3" and "inc_po_pl I gamma3" and "inc_po_pl J gamma3" and "inc_po_pl K gamma3" and "inc_l_pl t1 alpha" and "inc_l_pl t1 gamma3" and "N ~= P" and "inc_po_l N t1" and "inc_po_l P t1"  shows "(inc_po_l I t1 \<and> inc_po_l J t1 \<and> inc_po_l K t1)" 
sorry 


lemma th_14_09 :  assumes  "\<not> inc_po_pl A alpha" and "\<not> inc_po_pl B alpha" and "\<not> inc_po_pl C alpha" and "\<not> col A B C" and "inc_po_l A p" and "inc_po_l B p" and "inc_po_l B q" and "inc_po_l C q" and "inc_po_l C r" and "inc_po_l A r" and "inc_po_pl D alpha" and "inc_po_l D p" and "inc_po_pl E alpha" and "inc_po_l E q" and "inc_po_pl F alpha" and "inc_po_l F r" and "inc_po_pl A beta" and "inc_po_pl B beta" and "inc_po_pl C beta" and "inc_l_pl p beta" and "inc_l_pl q beta" and "inc_l_pl r beta" and "inc_po_pl D beta" and "inc_po_pl E beta" and "inc_po_pl F beta" and "inc_l_pl s alpha" and "inc_l_pl s beta" and "G ~= I" and "inc_po_l G s" and "inc_po_l I s" and "inc_po_l D s" and "inc_po_l E s" and "inc_po_l F s"  shows "(col D E F)" 

proof - 

from `inc_po_l D s` and `inc_po_l E s` and `inc_po_l F s`
have "col D E F"
  by (rule ax_D1)

from `col D E F`
have ?thesis
  by assumption

from this
show ?thesis 
.
qed

end

(*Transformed by Vernacular package (2016)*)