(*
Title: High school geometry theorems
Authors: Hilbert's axiomatic system
Formalized by: Sana Stojanovic Djurdjevic
Proved by: ArgoGeoChecker
Date: 07.01.2017.
 *)

Ltac hyp_of_type t :=
 match goal with
| H1:t |- _ => H1
  end.

Tactic Notation "by" "cases" "on" constr(t) :=
  let H := hyp_of_type t in decompose [or] H; clear H.

Ltac applying l := apply l;repeat split;repeat subst;intuition.
Ltac contradict := solve [intuition].
Ltac substitution := intuition;repeat subst;intuition.
Ltac conclude := assumption||solve [firstorder].
Ltac decompAnd H :=try (progress (decompose [and] H);clear H).

Parameter point : Type.
Parameter line : Type.
Parameter plane : Type.

Parameter eq_point : point -> point -> Prop.
Parameter not_eq_point : point -> point -> Prop.
Parameter eq_line : line -> line -> Prop.
Parameter not_eq_line : line -> line -> Prop.
Parameter eq_plane : plane -> plane -> Prop.
Parameter not_eq_plane : plane -> plane -> Prop.
Parameter inc_po_l : point -> line -> Prop.
Parameter not_inc_po_l : point -> line -> Prop.
Parameter inc_po_pl : point -> plane -> Prop.
Parameter not_inc_po_pl : point -> plane -> Prop.
Parameter inc_l_pl : line -> plane -> Prop.
Parameter not_inc_l_pl : line -> plane -> Prop.
Parameter int_l_l : line -> line -> Prop.
Parameter not_int_l_l : line -> line -> Prop.
Parameter int_l_pl : line -> plane -> Prop.
Parameter not_int_l_pl : line -> plane -> Prop.
Parameter int_pl_pl : plane -> plane -> Prop.
Parameter not_int_pl_pl : plane -> plane -> Prop.
Parameter cop : point -> point -> point -> point -> Prop.
Parameter not_cop : point -> point -> point -> point -> Prop.
Parameter col : point -> point -> point -> Prop.
Parameter not_col : point -> point -> point -> Prop.
Parameter bet : point -> point -> point -> Prop.
Parameter not_bet : point -> point -> point -> Prop.
Parameter cong : point -> point -> point -> point -> Prop.
Parameter not_cong : point -> point -> point -> point -> Prop.
Parameter cong_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_cong_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter order : point -> point -> point -> point -> Prop.
Parameter not_order : point -> point -> point -> point -> Prop.
Parameter cut : line -> point -> point -> Prop.
Parameter not_cut : line -> point -> point -> Prop.
Parameter pash : point -> point -> point -> line -> plane -> Prop.
Parameter not_pash : point -> point -> point -> line -> plane -> Prop.
Parameter parallel : line -> line -> Prop.
Parameter not_parallel : line -> line -> Prop.

Axiom ax_cut_1 : forall (B:point) (p:line) (C:point) (D:point), (not_inc_po_l B p /\ not_inc_po_l C p /\ inc_po_l D p /\ bet B D C) -> cut p B C.
Axiom ax_D11b : forall (A:point) (q:line) (gamma:plane), (inc_po_l A q /\ not_inc_po_pl A gamma) -> not_inc_l_pl q gamma.
Axiom ax_D11 : forall (q:line) (gamma:plane) (A:point), (inc_l_pl q gamma /\ inc_po_l A q) -> inc_po_pl A gamma.
Axiom ax_D1a : forall (A:point) (B:point) (s:line) (C:point), (A <> B /\ inc_po_l A s /\ inc_po_l B s /\ not_inc_po_l C s) -> not_col A B C.
Axiom ax_D1 : forall (A:point) (s:line) (B:point) (C:point), (inc_po_l A s /\ inc_po_l B s /\ inc_po_l C s) -> col A B C.
Axiom ax_D2a : forall (A:point) (B:point) (s:line) (C:point), (A <> B /\ inc_po_l A s /\ inc_po_l B s /\ not_col A B C) -> not_inc_po_l C s.
Axiom ax_D3a : forall (A:point) (B:point) (C:point) (beta1:plane) (D:point), (not_col A B C /\ inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ not_inc_po_pl D beta1) -> not_cop A B C D.
Axiom ax_D3 : forall (A:point) (beta1:plane) (B:point) (C:point) (D:point), (inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ inc_po_pl D beta1) -> cop A B C D.
Axiom ax_D4a : forall (A:point) (B:point) (C:point) (beta1:plane) (D:point), (not_col A B C /\ inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ not_cop A B C D) -> not_inc_po_pl D beta1.
Axiom ax_D5a : forall (p:line) (q:line) (C:point), (p <> q /\ not_int_l_l p q /\ inc_po_l C p) -> not_inc_po_l C q.
Axiom ax_D5 : forall (p:line) (q:line) (C:point), (p <> q /\ inc_po_l C p /\ inc_po_l C q) -> int_l_l p q.
Axiom ax_D7a : forall (alpha:plane) (beta:plane) (C:point), (alpha <> beta /\ inc_po_pl C alpha /\ not_int_pl_pl alpha beta) -> not_inc_po_pl C beta.
Axiom ax_D7 : forall (alpha:plane) (beta:plane) (C:point), (alpha <> beta /\ inc_po_pl C alpha /\ inc_po_pl C beta) -> int_pl_pl alpha beta.
Axiom ax_D9a : forall (p:line) (beta:plane) (C:point), (not_inc_l_pl p beta /\ not_int_l_pl p beta /\ inc_po_l C p) -> not_inc_po_pl C beta.
Axiom ax_D9b : forall (p:line) (beta:plane) (C:point), (not_inc_l_pl p beta /\ not_int_l_pl p beta /\ inc_po_pl C beta) -> not_inc_po_l C p.
Axiom ax_D9 : forall (p:line) (beta:plane) (C:point), (not_inc_l_pl p beta /\ inc_po_l C p /\ inc_po_pl C beta) -> int_l_pl p beta.
Axiom ax_false_bet : forall (A:point) (B:point) (C:point), (bet A B C /\ not_bet A B C) -> (False).
Axiom ax_false_col : forall (A:point) (B:point) (C:point), (col A B C /\ not_col A B C) -> (False).
Axiom ax_false_cop : forall (A:point) (B:point) (C:point) (D:point), (cop A B C D /\ not_cop A B C D) -> (False).
Axiom ax_false_cut : forall (p:line) (B:point) (C:point), (cut p B C /\ not_cut p B C) -> (False).
Axiom ax_false_inc_l_pl : forall (p:line) (beta:plane), (inc_l_pl p beta /\ not_inc_l_pl p beta) -> (False).
Axiom ax_false_inc_po_l : forall (A:point) (q:line), (inc_po_l A q /\ not_inc_po_l A q) -> (False).
Axiom ax_false_inc_po_pl : forall (A:point) (beta:plane), (inc_po_pl A beta /\ not_inc_po_pl A beta) -> (False).
Axiom ax_false_int_l_l : forall (p:line) (q:line), (int_l_l p q /\ not_int_l_l p q) -> (False).
Axiom ax_false_int_l_pl : forall (p:line) (beta:plane), (int_l_pl p beta /\ not_int_l_pl p beta) -> (False).
Axiom ax_false_int_pl_pl : forall (alpha:plane) (beta:plane), (int_pl_pl alpha beta /\ not_int_pl_pl alpha beta) -> (False).
Axiom ax_false_pash : forall (A:point) (B:point) (C:point) (s:line) (beta1:plane), (pash A B C s beta1 /\ not_pash A B C s beta1) -> (False).
Axiom ax_I2 : forall (A:point) (B:point) (r:line) (s:line), (A <> B /\ inc_po_l A r /\ inc_po_l B r /\ inc_po_l A s /\ inc_po_l B s) -> r = s.
Axiom ax_I5 : forall (A:point) (B:point) (C:point) (alpha1:plane) (beta1:plane), (not_col A B C /\ inc_po_pl A alpha1 /\ inc_po_pl B alpha1 /\ inc_po_pl C alpha1 /\ inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1) -> alpha1 = beta1.
Axiom ax_I6 : forall (A:point) (B:point) (r:line) (alpha1:plane), (A <> B /\ inc_po_l A r /\ inc_po_l B r /\ inc_po_pl A alpha1 /\ inc_po_pl B alpha1) -> inc_l_pl r alpha1.
Axiom ax_II1 : forall (A:point) (B:point) (C:point), bet A B C -> (A <> B /\ A <> C /\ B <> C /\ col A B C /\ bet C B A).
Axiom ax_II3 : forall (A:point) (B:point) (C:point), (A <> B /\ A <> C /\ B <> C /\ bet A B C) -> (not_bet B C A /\ not_bet C A B).
Axiom ax_pash_1 : forall (A:point) (B:point) (C:point) (beta1:plane) (s:line), (not_col A B C /\ inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ inc_l_pl s beta1 /\ not_inc_po_l A s /\ not_inc_po_l B s /\ not_inc_po_l C s /\ cut s B C) -> pash A B C s beta1.
Axiom ax_pash_2 : forall (A:point) (B:point) (C:point) (s:line) (beta1:plane), pash A B C s beta1 -> (not_col A B C /\ inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ inc_l_pl s beta1 /\ not_inc_po_l A s /\ not_inc_po_l B s /\ not_inc_po_l C s /\ cut s B C).
Axiom ax_sym_col1 : forall (A:point) (B:point) (C:point), col A B C -> col B C A.
Axiom ax_sym_col2 : forall (A:point) (B:point) (C:point), col A B C -> col B A C.
Axiom ax_sym_col : forall (A:point) (B:point) (C:point), col A B C -> (col A C B /\ col B A C /\ col B C A /\ col C A B /\ col C B A).
Axiom ax_sym_cop1 : forall (A:point) (B:point) (C:point) (D:point), cop A B C D -> cop B C D A.
Axiom ax_sym_cop2 : forall (A:point) (B:point) (C:point) (D:point), cop A B C D -> cop B A C D.
Axiom ax_sym_cop : forall (A:point) (B:point) (C:point) (D:point), cop A B C D -> (cop A B D C /\ cop A C B D /\ cop A C D B /\ cop A D B C /\ cop A D C B /\ cop B A C D /\ cop B A D C /\ cop B C A D /\ cop B C D A /\ cop B D A C /\ cop B D C A /\ cop C A B D /\ cop C A D B /\ cop C B A D /\ cop C B D A /\ cop C D A B /\ cop C D B A /\ cop D A B C /\ cop D A C B /\ cop D B A C /\ cop D B C A /\ cop D C A B /\ cop D C B A).
Axiom ax_sym_int_l_l : forall (p:line) (q:line), int_l_l p q -> int_l_l q p.
Axiom ax_sym_int_pl_pl : forall (alpha:plane) (beta:plane), int_pl_pl alpha beta -> int_pl_pl beta alpha.
Axiom ax_sym_ncol1 : forall (A:point) (B:point) (C:point), not_col A B C -> not_col B C A.
Axiom ax_sym_ncol2 : forall (A:point) (B:point) (C:point), not_col A B C -> not_col B A C.
Axiom ax_sym_ncol : forall (A:point) (B:point) (C:point), not_col A B C -> (not_col A C B /\ not_col B A C /\ not_col B C A /\ not_col C A B /\ not_col C B A).
Axiom ax_sym_ncop1 : forall (A:point) (B:point) (C:point) (D:point), not_cop A B C D -> not_cop B C D A.
Axiom ax_sym_ncop2 : forall (A:point) (B:point) (C:point) (D:point), not_cop A B C D -> not_cop B A C D.
Axiom ax_sym_ncop : forall (A:point) (B:point) (C:point) (D:point), not_cop A B C D -> (not_cop A B D C /\ not_cop A C B D /\ not_cop A C D B /\ not_cop A D B C /\ not_cop A D C B /\ not_cop B A C D /\ not_cop B A D C /\ not_cop B C A D /\ not_cop B C D A /\ not_cop B D A C /\ not_cop B D C A /\ not_cop C A B D /\ not_cop C A D B /\ not_cop C B A D /\ not_cop C B D A /\ not_cop C D A B /\ not_cop C D B A /\ not_cop D A B C /\ not_cop D A C B /\ not_cop D B A C /\ not_cop D B C A /\ not_cop D C A B /\ not_cop D C B A).
Axiom ax_sym_nint_l_l : forall (p:line) (q:line), not_int_l_l p q -> not_int_l_l q p.
Axiom ax_sym_nint_pl_pl : forall (alpha:plane) (beta:plane), not_int_pl_pl alpha beta -> not_int_pl_pl beta alpha.
Axiom ax_branch_bet : forall (A:point) (B:point) (C:point), bet A B C \/ not_bet A B C.
Axiom ax_branch_col : forall (A:point) (B:point) (C:point), (A <> B /\ A <> C /\ B <> C) -> col A B C \/ not_col A B C.
Axiom ax_branch_cop : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ A <> C /\ A <> D /\ B <> C /\ B <> D /\ C <> D) -> cop A B C D \/ not_cop A B C D.
Axiom ax_branch_cut : forall (B:point) (C:point) (p:line), B <> C -> cut p B C \/ not_cut p B C.
Axiom ax_branch_inc_l_pl : forall (p:line) (beta:plane), inc_l_pl p beta \/ not_inc_l_pl p beta.
Axiom ax_branch_inc_po_l : forall (A:point) (q:line), inc_po_l A q \/ not_inc_po_l A q.
Axiom ax_branch_inc_po_pl : forall (A:point) (beta:plane), inc_po_pl A beta \/ not_inc_po_pl A beta.
Axiom ax_branch_int_l_l : forall (p:line) (q:line), p <> q -> int_l_l p q \/ not_int_l_l p q.
Axiom ax_branch_int_l_pl : forall (p:line) (beta:plane), int_l_pl p beta \/ not_int_l_pl p beta.
Axiom ax_branch_int_pl_pl : forall (alpha:plane) (beta:plane), alpha <> beta -> int_pl_pl alpha beta \/ not_int_pl_pl alpha beta.
Axiom ax_branch_pash : forall (A:point) (B:point) (C:point) (s:line) (beta1:plane), (A <> B /\ A <> C /\ B <> C) -> pash A B C s beta1 \/ not_pash A B C s beta1.
Axiom ax_II4 : forall (A:point) (B:point) (C:point) (s:line) (beta1:plane), pash A B C s beta1 -> cut s C A \/ cut s A B.
Axiom ax_g1 : forall (A:point) (B:point), A = B \/ A <> B.
Axiom ax_g2 : forall (p:line) (q:line), p = q \/ p <> q.
Axiom ax_g3 : forall (alpha:plane) (beta:plane), alpha = beta \/ alpha <> beta.
Axiom ax_cut_2 : forall (p:line) (B:point) (C:point), cut p B C -> exists D:point, (not_inc_po_l B p /\ not_inc_po_l C p /\ inc_po_l D p /\ bet B D C).
Axiom ax_D10 : forall (p:line) (beta:plane), int_l_pl p beta -> exists C:point, (inc_po_l C p /\ inc_po_pl C beta /\ not_inc_l_pl p beta).
Axiom ax_D11a : forall (p:line) (beta:plane), not_inc_l_pl p beta -> exists C:point, (inc_po_l C p /\ not_inc_po_pl C beta).
Axiom ax_D2 : forall (A:point) (B:point) (C:point), col A B C -> exists s:line, (inc_po_l A s /\ inc_po_l B s /\ inc_po_l C s).
Axiom ax_D4 : forall (A:point) (B:point) (C:point) (D:point), cop A B C D -> exists beta1:plane, (inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ inc_po_pl D beta1).
Axiom ax_D6 : forall (p:line) (q:line), int_l_l p q -> exists C:point, (p <> q /\ inc_po_l C p /\ inc_po_l C q).
Axiom ax_D8 : forall (alpha:plane) (beta:plane), int_pl_pl alpha beta -> exists C:point, (alpha <> beta /\ inc_po_pl C alpha /\ inc_po_pl C beta).
Axiom ax_I1 : forall (A:point) (B:point), A <> B -> exists r:line, (inc_po_l A r /\ inc_po_l B r).
Axiom ax_I3a : forall (p:line), exists B:point, exists C:point, (B <> C /\ inc_po_l B p /\ inc_po_l C p).
Axiom ax_I4a : forall (A:point) (B:point) (C:point), not_col A B C -> exists alpha1:plane, (inc_po_pl A alpha1 /\ inc_po_pl B alpha1 /\ inc_po_pl C alpha1).
Axiom ax_I4b : forall (alpha:plane), exists B:point, inc_po_pl B alpha.
Axiom ax_I7 : forall (alpha:plane) (beta:plane) (C:point), (alpha <> beta /\ inc_po_pl C alpha /\ inc_po_pl C beta) -> exists D:point, (C <> D /\ inc_po_pl D alpha /\ inc_po_pl D beta).
Axiom ax_II2 : forall (A:point) (B:point), A <> B -> exists C:point, bet A B C.
Axiom ax_I3b : exists A:point, exists B:point, exists C:point, not_col A B C.
Axiom ax_I8 : exists A:point, exists B:point, exists C:point, exists D:point, not_cop A B C D.

(* Chapter : Hilbert *)

Theorem th_14_01 : forall (A:point) (alpha:plane) (B:point) (C:point) (p:line) (q:line) (r:line) (D:point) (E:point) (F:point), (not_inc_po_pl A alpha /\ not_inc_po_pl B alpha /\ not_inc_po_pl C alpha /\ not_col A B C /\ inc_po_l A p /\ inc_po_l B p /\ inc_po_l B q /\ inc_po_l C q /\ inc_po_l C r /\ inc_po_l A r /\ inc_po_pl D alpha /\ inc_po_l D p /\ inc_po_pl E alpha /\ inc_po_l E q /\ inc_po_pl F alpha /\ inc_po_l F r) -> exists beta:plane, (inc_po_pl A beta /\ inc_po_pl B beta /\ inc_po_pl C beta).
Proof.
 intros.
 let Hnew := fresh in  assert ( Hnew : exists beta, (inc_po_pl A beta /\ inc_po_pl B beta /\ inc_po_pl C beta)) by applying (ax_I4a A B C ) ;destruct Hnew as [beta Hnew];decompAnd Hnew.
 conclude.
Qed.

Theorem th_14_02 : forall (A:point) (alpha:plane) (B:point) (C:point) (p:line) (q:line) (r:line) (D:point) (E:point) (F:point) (beta:plane), (not_inc_po_pl A alpha /\ not_inc_po_pl B alpha /\ not_inc_po_pl C alpha /\ not_col A B C /\ inc_po_l A p /\ inc_po_l B p /\ inc_po_l B q /\ inc_po_l C q /\ inc_po_l C r /\ inc_po_l A r /\ inc_po_pl D alpha /\ inc_po_l D p /\ inc_po_pl E alpha /\ inc_po_l E q /\ inc_po_pl F alpha /\ inc_po_l F r /\ inc_po_pl A beta /\ inc_po_pl B beta /\ inc_po_pl C beta) -> inc_l_pl p beta.
Proof.
 intros.
 assert (col A A C) by applying (ax_D1 A r A C ) .
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
    by cases on (A = B \/ A <> B).
    - { (* Case : A = B *)
       assert (col A B C)  by substitution.
       assert (False) by applying (ax_false_col A B C ) .
       contradict.
      }
    - { (* Case : A <> B *)
       assert (inc_l_pl p beta) by applying (ax_I6 A B p beta ) .
       conclude.
      }
Qed.

Theorem th_14_03 : forall (A:point) (alpha:plane) (B:point) (C:point) (p:line) (q:line) (r:line) (D:point) (E:point) (F:point) (beta:plane), (not_inc_po_pl A alpha /\ not_inc_po_pl B alpha /\ not_inc_po_pl C alpha /\ not_col A B C /\ inc_po_l A p /\ inc_po_l B p /\ inc_po_l B q /\ inc_po_l C q /\ inc_po_l C r /\ inc_po_l A r /\ inc_po_pl D alpha /\ inc_po_l D p /\ inc_po_pl E alpha /\ inc_po_l E q /\ inc_po_pl F alpha /\ inc_po_l F r /\ inc_po_pl A beta /\ inc_po_pl B beta /\ inc_po_pl C beta /\ inc_l_pl p beta) -> inc_l_pl q beta.
Proof.
 intros.
 assert (col A B B) by applying (ax_D1 A p B B ) .
 assert (B = C \/ B <> C) by applying (ax_g1 B C ) .
    by cases on (B = C \/ B <> C).
    - { (* Case : B = C *)
       assert (col A B C)  by substitution.
       assert (False) by applying (ax_false_col A B C ) .
       contradict.
      }
    - { (* Case : B <> C *)
       assert (inc_l_pl q beta) by applying (ax_I6 B C q beta ) .
       conclude.
      }
Qed.

Theorem th_14_04 : forall (A:point) (alpha:plane) (B:point) (C:point) (p:line) (q:line) (r:line) (D:point) (E:point) (F:point) (beta:plane), (not_inc_po_pl A alpha /\ not_inc_po_pl B alpha /\ not_inc_po_pl C alpha /\ not_col A B C /\ inc_po_l A p /\ inc_po_l B p /\ inc_po_l B q /\ inc_po_l C q /\ inc_po_l C r /\ inc_po_l A r /\ inc_po_pl D alpha /\ inc_po_l D p /\ inc_po_pl E alpha /\ inc_po_l E q /\ inc_po_pl F alpha /\ inc_po_l F r /\ inc_po_pl A beta /\ inc_po_pl B beta /\ inc_po_pl C beta /\ inc_l_pl p beta /\ inc_l_pl q beta) -> inc_l_pl r beta.
Proof.
 intros.
 assert (col A B A) by applying (ax_D1 A p B A ) .
 assert (A = C \/ A <> C) by applying (ax_g1 A C ) .
    by cases on (A = C \/ A <> C).
    - { (* Case : A = C *)
       assert (col A B C)  by substitution.
       assert (False) by applying (ax_false_col A B C ) .
       contradict.
      }
    - { (* Case : A <> C *)
       assert (inc_l_pl r beta) by applying (ax_I6 A C r beta ) .
       conclude.
      }
Qed.

Theorem th_14_05 : forall (A:point) (alpha:plane) (B:point) (C:point) (p:line) (q:line) (r:line) (D:point) (E:point) (F:point) (beta:plane), (not_inc_po_pl A alpha /\ not_inc_po_pl B alpha /\ not_inc_po_pl C alpha /\ not_col A B C /\ inc_po_l A p /\ inc_po_l B p /\ inc_po_l B q /\ inc_po_l C q /\ inc_po_l C r /\ inc_po_l A r /\ inc_po_pl D alpha /\ inc_po_l D p /\ inc_po_pl E alpha /\ inc_po_l E q /\ inc_po_pl F alpha /\ inc_po_l F r /\ inc_po_pl A beta /\ inc_po_pl B beta /\ inc_po_pl C beta /\ inc_l_pl p beta /\ inc_l_pl q beta /\ inc_l_pl r beta) -> (inc_po_pl D beta /\ inc_po_pl E beta /\ inc_po_pl F beta).
Proof.
 intros.
 assert (inc_po_pl D beta) by applying (ax_D11 p beta D ) .
 assert (inc_po_pl E beta) by applying (ax_D11 q beta E ) .
 assert (inc_po_pl F beta) by applying (ax_D11 r beta F ) .
 conclude.
Qed.

Theorem th_14_06 : forall (B:point) (alpha:plane) (C:point) (D:point) (t:line) (u:line) (v:line) (I:point) (J:point) (K:point) (gamma3:plane), (not_inc_po_pl B alpha /\ not_inc_po_pl C alpha /\ not_inc_po_pl D alpha /\ not_col B C D /\ inc_po_l B t /\ inc_po_l C t /\ inc_po_l C u /\ inc_po_l D u /\ inc_po_l D v /\ inc_po_l B v /\ inc_po_pl I alpha /\ inc_po_l I t /\ inc_po_pl J alpha /\ inc_po_l J u /\ inc_po_pl K alpha /\ inc_po_l K v /\ inc_po_pl B gamma3 /\ inc_po_pl C gamma3 /\ inc_po_pl D gamma3 /\ inc_l_pl t gamma3 /\ inc_l_pl u gamma3 /\ inc_l_pl v gamma3 /\ inc_po_pl I gamma3 /\ inc_po_pl J gamma3 /\ inc_po_pl K gamma3) -> exists t1:line, (inc_l_pl t1 alpha /\ inc_l_pl t1 gamma3).
Proof.
Admitted.

Theorem th_14_07 : forall (B:point) (alpha:plane) (C:point) (D:point) (t:line) (u:line) (v:line) (I:point) (J:point) (K:point) (gamma3:plane) (t1:line), (not_inc_po_pl B alpha /\ not_inc_po_pl C alpha /\ not_inc_po_pl D alpha /\ not_col B C D /\ inc_po_l B t /\ inc_po_l C t /\ inc_po_l C u /\ inc_po_l D u /\ inc_po_l D v /\ inc_po_l B v /\ inc_po_pl I alpha /\ inc_po_l I t /\ inc_po_pl J alpha /\ inc_po_l J u /\ inc_po_pl K alpha /\ inc_po_l K v /\ inc_po_pl B gamma3 /\ inc_po_pl C gamma3 /\ inc_po_pl D gamma3 /\ inc_l_pl t gamma3 /\ inc_l_pl u gamma3 /\ inc_l_pl v gamma3 /\ inc_po_pl I gamma3 /\ inc_po_pl J gamma3 /\ inc_po_pl K gamma3 /\ inc_l_pl t1 alpha /\ inc_l_pl t1 gamma3) -> exists N:point, exists P:point, (N <> P /\ inc_po_l N t1 /\ inc_po_l P t1).
Proof.
Admitted.

Theorem th_14_08 : forall (B:point) (alpha:plane) (C:point) (D:point) (t:line) (u:line) (v:line) (I:point) (J:point) (K:point) (gamma3:plane) (t1:line) (N:point) (P:point), (not_inc_po_pl B alpha /\ not_inc_po_pl C alpha /\ not_inc_po_pl D alpha /\ not_col B C D /\ inc_po_l B t /\ inc_po_l C t /\ inc_po_l C u /\ inc_po_l D u /\ inc_po_l D v /\ inc_po_l B v /\ inc_po_pl I alpha /\ inc_po_l I t /\ inc_po_pl J alpha /\ inc_po_l J u /\ inc_po_pl K alpha /\ inc_po_l K v /\ inc_po_pl B gamma3 /\ inc_po_pl C gamma3 /\ inc_po_pl D gamma3 /\ inc_l_pl t gamma3 /\ inc_l_pl u gamma3 /\ inc_l_pl v gamma3 /\ inc_po_pl I gamma3 /\ inc_po_pl J gamma3 /\ inc_po_pl K gamma3 /\ inc_l_pl t1 alpha /\ inc_l_pl t1 gamma3 /\ N <> P /\ inc_po_l N t1 /\ inc_po_l P t1) -> (inc_po_l I t1 /\ inc_po_l J t1 /\ inc_po_l K t1).
Proof.
Admitted.

Theorem th_14_09 : forall (A:point) (alpha:plane) (B:point) (C:point) (p:line) (q:line) (r:line) (D:point) (E:point) (F:point) (beta:plane) (s:line) (G:point) (I:point), (not_inc_po_pl A alpha /\ not_inc_po_pl B alpha /\ not_inc_po_pl C alpha /\ not_col A B C /\ inc_po_l A p /\ inc_po_l B p /\ inc_po_l B q /\ inc_po_l C q /\ inc_po_l C r /\ inc_po_l A r /\ inc_po_pl D alpha /\ inc_po_l D p /\ inc_po_pl E alpha /\ inc_po_l E q /\ inc_po_pl F alpha /\ inc_po_l F r /\ inc_po_pl A beta /\ inc_po_pl B beta /\ inc_po_pl C beta /\ inc_l_pl p beta /\ inc_l_pl q beta /\ inc_l_pl r beta /\ inc_po_pl D beta /\ inc_po_pl E beta /\ inc_po_pl F beta /\ inc_l_pl s alpha /\ inc_l_pl s beta /\ G <> I /\ inc_po_l G s /\ inc_po_l I s /\ inc_po_l D s /\ inc_po_l E s /\ inc_po_l F s) -> col D E F.
Proof.
 intros.
 assert (col D E F) by applying (ax_D1 D s E F ) .
 conclude.
Qed.

