(*
Title: High school geometry theorems
Authors: Hilbert's axiomatic system
Formalized by: Sana Stojanovic Djurdjevic
Proved by: ArgoGeoChecker
Date: 07.01.2017.
 *)

Ltac hyp_of_type t :=
 match goal with
| H1:t |- _ => H1
  end.

Tactic Notation "by" "cases" "on" constr(t) :=
  let H := hyp_of_type t in decompose [or] H; clear H.

Ltac applying l := apply l;repeat split;repeat subst;intuition.
Ltac contradict := solve [intuition].
Ltac substitution := intuition;repeat subst;intuition.
Ltac conclude := assumption||solve [firstorder].
Ltac decompAnd H :=try (progress (decompose [and] H);clear H).

Parameter point : Type.
Parameter line : Type.
Parameter plane : Type.

Parameter eq_point : point -> point -> Prop.
Parameter not_eq_point : point -> point -> Prop.
Parameter eq_line : line -> line -> Prop.
Parameter not_eq_line : line -> line -> Prop.
Parameter eq_plane : plane -> plane -> Prop.
Parameter not_eq_plane : plane -> plane -> Prop.
Parameter inc_po_l : point -> line -> Prop.
Parameter not_inc_po_l : point -> line -> Prop.
Parameter inc_po_pl : point -> plane -> Prop.
Parameter not_inc_po_pl : point -> plane -> Prop.
Parameter inc_l_pl : line -> plane -> Prop.
Parameter not_inc_l_pl : line -> plane -> Prop.
Parameter int_l_l : line -> line -> Prop.
Parameter not_int_l_l : line -> line -> Prop.
Parameter int_l_pl : line -> plane -> Prop.
Parameter not_int_l_pl : line -> plane -> Prop.
Parameter int_pl_pl : plane -> plane -> Prop.
Parameter not_int_pl_pl : plane -> plane -> Prop.
Parameter cop : point -> point -> point -> point -> Prop.
Parameter not_cop : point -> point -> point -> point -> Prop.
Parameter col : point -> point -> point -> Prop.
Parameter not_col : point -> point -> point -> Prop.
Parameter bet : point -> point -> point -> Prop.
Parameter not_bet : point -> point -> point -> Prop.
Parameter cong : point -> point -> point -> point -> Prop.
Parameter not_cong : point -> point -> point -> point -> Prop.
Parameter cong_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_cong_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter order : point -> point -> point -> point -> Prop.
Parameter not_order : point -> point -> point -> point -> Prop.
Parameter cut : line -> point -> point -> Prop.
Parameter not_cut : line -> point -> point -> Prop.
Parameter pash : point -> point -> point -> line -> plane -> Prop.
Parameter not_pash : point -> point -> point -> line -> plane -> Prop.
Parameter parallel : line -> line -> Prop.
Parameter not_parallel : line -> line -> Prop.

Axiom ax_cut_1 : forall (B:point) (p:line) (C:point) (D:point), (not_inc_po_l B p /\ not_inc_po_l C p /\ inc_po_l D p /\ bet B D C) -> cut p B C.
Axiom ax_D11b : forall (A:point) (q:line) (gamma:plane), (inc_po_l A q /\ not_inc_po_pl A gamma) -> not_inc_l_pl q gamma.
Axiom ax_D11 : forall (q:line) (gamma:plane) (A:point), (inc_l_pl q gamma /\ inc_po_l A q) -> inc_po_pl A gamma.
Axiom ax_D1a : forall (A:point) (B:point) (s:line) (C:point), (A <> B /\ inc_po_l A s /\ inc_po_l B s /\ not_inc_po_l C s) -> not_col A B C.
Axiom ax_D1 : forall (A:point) (s:line) (B:point) (C:point), (inc_po_l A s /\ inc_po_l B s /\ inc_po_l C s) -> col A B C.
Axiom ax_D2a : forall (A:point) (B:point) (s:line) (C:point), (A <> B /\ inc_po_l A s /\ inc_po_l B s /\ not_col A B C) -> not_inc_po_l C s.
Axiom ax_D3a : forall (A:point) (B:point) (C:point) (beta1:plane) (D:point), (not_col A B C /\ inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ not_inc_po_pl D beta1) -> not_cop A B C D.
Axiom ax_D3 : forall (A:point) (beta1:plane) (B:point) (C:point) (D:point), (inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ inc_po_pl D beta1) -> cop A B C D.
Axiom ax_D4a : forall (A:point) (B:point) (C:point) (beta1:plane) (D:point), (not_col A B C /\ inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ not_cop A B C D) -> not_inc_po_pl D beta1.
Axiom ax_D5a : forall (p:line) (q:line) (C:point), (p <> q /\ not_int_l_l p q /\ inc_po_l C p) -> not_inc_po_l C q.
Axiom ax_D5 : forall (p:line) (q:line) (C:point), (p <> q /\ inc_po_l C p /\ inc_po_l C q) -> int_l_l p q.
Axiom ax_D7a : forall (alpha:plane) (beta:plane) (C:point), (alpha <> beta /\ inc_po_pl C alpha /\ not_int_pl_pl alpha beta) -> not_inc_po_pl C beta.
Axiom ax_D7 : forall (alpha:plane) (beta:plane) (C:point), (alpha <> beta /\ inc_po_pl C alpha /\ inc_po_pl C beta) -> int_pl_pl alpha beta.
Axiom ax_D9a : forall (p:line) (beta:plane) (C:point), (not_inc_l_pl p beta /\ not_int_l_pl p beta /\ inc_po_l C p) -> not_inc_po_pl C beta.
Axiom ax_D9b : forall (p:line) (beta:plane) (C:point), (not_inc_l_pl p beta /\ not_int_l_pl p beta /\ inc_po_pl C beta) -> not_inc_po_l C p.
Axiom ax_D9 : forall (p:line) (beta:plane) (C:point), (not_inc_l_pl p beta /\ inc_po_l C p /\ inc_po_pl C beta) -> int_l_pl p beta.
Axiom ax_false_bet : forall (A:point) (B:point) (C:point), (bet A B C /\ not_bet A B C) -> (False).
Axiom ax_false_col : forall (A:point) (B:point) (C:point), (col A B C /\ not_col A B C) -> (False).
Axiom ax_false_cop : forall (A:point) (B:point) (C:point) (D:point), (cop A B C D /\ not_cop A B C D) -> (False).
Axiom ax_false_cut : forall (p:line) (B:point) (C:point), (cut p B C /\ not_cut p B C) -> (False).
Axiom ax_false_inc_l_pl : forall (p:line) (beta:plane), (inc_l_pl p beta /\ not_inc_l_pl p beta) -> (False).
Axiom ax_false_inc_po_l : forall (A:point) (q:line), (inc_po_l A q /\ not_inc_po_l A q) -> (False).
Axiom ax_false_inc_po_pl : forall (A:point) (beta:plane), (inc_po_pl A beta /\ not_inc_po_pl A beta) -> (False).
Axiom ax_false_int_l_l : forall (p:line) (q:line), (int_l_l p q /\ not_int_l_l p q) -> (False).
Axiom ax_false_int_l_pl : forall (p:line) (beta:plane), (int_l_pl p beta /\ not_int_l_pl p beta) -> (False).
Axiom ax_false_int_pl_pl : forall (alpha:plane) (beta:plane), (int_pl_pl alpha beta /\ not_int_pl_pl alpha beta) -> (False).
Axiom ax_false_pash : forall (A:point) (B:point) (C:point) (s:line) (beta1:plane), (pash A B C s beta1 /\ not_pash A B C s beta1) -> (False).
Axiom ax_I2 : forall (A:point) (B:point) (r:line) (s:line), (A <> B /\ inc_po_l A r /\ inc_po_l B r /\ inc_po_l A s /\ inc_po_l B s) -> r = s.
Axiom ax_I5 : forall (A:point) (B:point) (C:point) (alpha1:plane) (beta1:plane), (not_col A B C /\ inc_po_pl A alpha1 /\ inc_po_pl B alpha1 /\ inc_po_pl C alpha1 /\ inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1) -> alpha1 = beta1.
Axiom ax_I6 : forall (A:point) (B:point) (r:line) (alpha1:plane), (A <> B /\ inc_po_l A r /\ inc_po_l B r /\ inc_po_pl A alpha1 /\ inc_po_pl B alpha1) -> inc_l_pl r alpha1.
Axiom ax_II1 : forall (A:point) (B:point) (C:point), bet A B C -> (A <> B /\ A <> C /\ B <> C /\ col A B C /\ bet C B A).
Axiom ax_II3 : forall (A:point) (B:point) (C:point), (A <> B /\ A <> C /\ B <> C /\ bet A B C) -> (not_bet B C A /\ not_bet C A B).
Axiom ax_pash_1 : forall (A:point) (B:point) (C:point) (beta1:plane) (s:line), (not_col A B C /\ inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ inc_l_pl s beta1 /\ not_inc_po_l A s /\ not_inc_po_l B s /\ not_inc_po_l C s /\ cut s B C) -> pash A B C s beta1.
Axiom ax_pash_2 : forall (A:point) (B:point) (C:point) (s:line) (beta1:plane), pash A B C s beta1 -> (not_col A B C /\ inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ inc_l_pl s beta1 /\ not_inc_po_l A s /\ not_inc_po_l B s /\ not_inc_po_l C s /\ cut s B C).
Axiom ax_sym_col1 : forall (A:point) (B:point) (C:point), col A B C -> col B C A.
Axiom ax_sym_col2 : forall (A:point) (B:point) (C:point), col A B C -> col B A C.
Axiom ax_sym_col : forall (A:point) (B:point) (C:point), col A B C -> (col A C B /\ col B A C /\ col B C A /\ col C A B /\ col C B A).
Axiom ax_sym_cop1 : forall (A:point) (B:point) (C:point) (D:point), cop A B C D -> cop B C D A.
Axiom ax_sym_cop2 : forall (A:point) (B:point) (C:point) (D:point), cop A B C D -> cop B A C D.
Axiom ax_sym_cop : forall (A:point) (B:point) (C:point) (D:point), cop A B C D -> (cop A B D C /\ cop A C B D /\ cop A C D B /\ cop A D B C /\ cop A D C B /\ cop B A C D /\ cop B A D C /\ cop B C A D /\ cop B C D A /\ cop B D A C /\ cop B D C A /\ cop C A B D /\ cop C A D B /\ cop C B A D /\ cop C B D A /\ cop C D A B /\ cop C D B A /\ cop D A B C /\ cop D A C B /\ cop D B A C /\ cop D B C A /\ cop D C A B /\ cop D C B A).
Axiom ax_sym_int_l_l : forall (p:line) (q:line), int_l_l p q -> int_l_l q p.
Axiom ax_sym_int_pl_pl : forall (alpha:plane) (beta:plane), int_pl_pl alpha beta -> int_pl_pl beta alpha.
Axiom ax_sym_ncol1 : forall (A:point) (B:point) (C:point), not_col A B C -> not_col B C A.
Axiom ax_sym_ncol2 : forall (A:point) (B:point) (C:point), not_col A B C -> not_col B A C.
Axiom ax_sym_ncol : forall (A:point) (B:point) (C:point), not_col A B C -> (not_col A C B /\ not_col B A C /\ not_col B C A /\ not_col C A B /\ not_col C B A).
Axiom ax_sym_ncop1 : forall (A:point) (B:point) (C:point) (D:point), not_cop A B C D -> not_cop B C D A.
Axiom ax_sym_ncop2 : forall (A:point) (B:point) (C:point) (D:point), not_cop A B C D -> not_cop B A C D.
Axiom ax_sym_ncop : forall (A:point) (B:point) (C:point) (D:point), not_cop A B C D -> (not_cop A B D C /\ not_cop A C B D /\ not_cop A C D B /\ not_cop A D B C /\ not_cop A D C B /\ not_cop B A C D /\ not_cop B A D C /\ not_cop B C A D /\ not_cop B C D A /\ not_cop B D A C /\ not_cop B D C A /\ not_cop C A B D /\ not_cop C A D B /\ not_cop C B A D /\ not_cop C B D A /\ not_cop C D A B /\ not_cop C D B A /\ not_cop D A B C /\ not_cop D A C B /\ not_cop D B A C /\ not_cop D B C A /\ not_cop D C A B /\ not_cop D C B A).
Axiom ax_sym_nint_l_l : forall (p:line) (q:line), not_int_l_l p q -> not_int_l_l q p.
Axiom ax_sym_nint_pl_pl : forall (alpha:plane) (beta:plane), not_int_pl_pl alpha beta -> not_int_pl_pl beta alpha.
Axiom ax_branch_bet : forall (A:point) (B:point) (C:point), bet A B C \/ not_bet A B C.
Axiom ax_branch_col : forall (A:point) (B:point) (C:point), (A <> B /\ A <> C /\ B <> C) -> col A B C \/ not_col A B C.
Axiom ax_branch_cop : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ A <> C /\ A <> D /\ B <> C /\ B <> D /\ C <> D) -> cop A B C D \/ not_cop A B C D.
Axiom ax_branch_cut : forall (B:point) (C:point) (p:line), B <> C -> cut p B C \/ not_cut p B C.
Axiom ax_branch_inc_l_pl : forall (p:line) (beta:plane), inc_l_pl p beta \/ not_inc_l_pl p beta.
Axiom ax_branch_inc_po_l : forall (A:point) (q:line), inc_po_l A q \/ not_inc_po_l A q.
Axiom ax_branch_inc_po_pl : forall (A:point) (beta:plane), inc_po_pl A beta \/ not_inc_po_pl A beta.
Axiom ax_branch_int_l_l : forall (p:line) (q:line), p <> q -> int_l_l p q \/ not_int_l_l p q.
Axiom ax_branch_int_l_pl : forall (p:line) (beta:plane), int_l_pl p beta \/ not_int_l_pl p beta.
Axiom ax_branch_int_pl_pl : forall (alpha:plane) (beta:plane), alpha <> beta -> int_pl_pl alpha beta \/ not_int_pl_pl alpha beta.
Axiom ax_branch_pash : forall (A:point) (B:point) (C:point) (s:line) (beta1:plane), (A <> B /\ A <> C /\ B <> C) -> pash A B C s beta1 \/ not_pash A B C s beta1.
Axiom ax_II4 : forall (A:point) (B:point) (C:point) (s:line) (beta1:plane), pash A B C s beta1 -> cut s C A \/ cut s A B.
Axiom ax_g1 : forall (A:point) (B:point), A = B \/ A <> B.
Axiom ax_g2 : forall (p:line) (q:line), p = q \/ p <> q.
Axiom ax_g3 : forall (alpha:plane) (beta:plane), alpha = beta \/ alpha <> beta.
Axiom ax_cut_2 : forall (p:line) (B:point) (C:point), cut p B C -> exists D:point, (not_inc_po_l B p /\ not_inc_po_l C p /\ inc_po_l D p /\ bet B D C).
Axiom ax_D10 : forall (p:line) (beta:plane), int_l_pl p beta -> exists C:point, (inc_po_l C p /\ inc_po_pl C beta /\ not_inc_l_pl p beta).
Axiom ax_D11a : forall (p:line) (beta:plane), not_inc_l_pl p beta -> exists C:point, (inc_po_l C p /\ not_inc_po_pl C beta).
Axiom ax_D2 : forall (A:point) (B:point) (C:point), col A B C -> exists s:line, (inc_po_l A s /\ inc_po_l B s /\ inc_po_l C s).
Axiom ax_D4 : forall (A:point) (B:point) (C:point) (D:point), cop A B C D -> exists beta1:plane, (inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ inc_po_pl D beta1).
Axiom ax_D6 : forall (p:line) (q:line), int_l_l p q -> exists C:point, (p <> q /\ inc_po_l C p /\ inc_po_l C q).
Axiom ax_D8 : forall (alpha:plane) (beta:plane), int_pl_pl alpha beta -> exists C:point, (alpha <> beta /\ inc_po_pl C alpha /\ inc_po_pl C beta).
Axiom ax_I1 : forall (A:point) (B:point), A <> B -> exists r:line, (inc_po_l A r /\ inc_po_l B r).
Axiom ax_I3a : forall (p:line), exists B:point, exists C:point, (B <> C /\ inc_po_l B p /\ inc_po_l C p).
Axiom ax_I4a : forall (A:point) (B:point) (C:point), not_col A B C -> exists alpha1:plane, (inc_po_pl A alpha1 /\ inc_po_pl B alpha1 /\ inc_po_pl C alpha1).
Axiom ax_I4b : forall (alpha:plane), exists B:point, inc_po_pl B alpha.
Axiom ax_I7 : forall (alpha:plane) (beta:plane) (C:point), (alpha <> beta /\ inc_po_pl C alpha /\ inc_po_pl C beta) -> exists D:point, (C <> D /\ inc_po_pl D alpha /\ inc_po_pl D beta).
Axiom ax_II2 : forall (A:point) (B:point), A <> B -> exists C:point, bet A B C.
Axiom ax_I3b : exists A:point, exists B:point, exists C:point, not_col A B C.
Axiom ax_I8 : exists A:point, exists B:point, exists C:point, exists D:point, not_cop A B C D.

(* Chapter : Hilbert *)

Theorem th_6_01 : forall (p:line) (q:line) (r:line) (A:point) (B:point) (C:point), (p <> q /\ q <> r /\ r <> p /\ int_l_l p q /\ int_l_l q r /\ int_l_l r p /\ inc_po_l A p /\ inc_po_l A q /\ not_inc_po_l A r /\ not_inc_po_l B p /\ inc_po_l B q /\ inc_po_l B r /\ inc_po_l C p /\ not_inc_po_l C q /\ inc_po_l C r) -> exists alpha:plane, (inc_po_pl A alpha /\ inc_po_pl B alpha /\ inc_po_pl C alpha).
Proof.
 intros.
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
    by cases on (A = B \/ A <> B).
    - { (* Case : A = B *)
       assert (not_inc_po_l A p)  by substitution.
       assert (False) by applying (ax_false_inc_po_l A p ) .
       contradict.
      }
    - { (* Case : A <> B *)
       assert (not_col A B C) by applying (ax_D1a A B q C ) .
 let Hnew := fresh in  assert ( Hnew : exists alpha, (inc_po_pl A alpha /\ inc_po_pl B alpha /\ inc_po_pl C alpha)) by applying (ax_I4a A B C ) ;destruct Hnew as [alpha Hnew];decompAnd Hnew.
       conclude.
      }
Qed.

Theorem th_6_02 : forall (p:line) (q:line) (r:line) (A:point) (B:point) (C:point) (alpha:plane), (p <> q /\ q <> r /\ r <> p /\ int_l_l p q /\ int_l_l q r /\ int_l_l r p /\ inc_po_l A p /\ inc_po_l A q /\ not_inc_po_l A r /\ not_inc_po_l B p /\ inc_po_l B q /\ inc_po_l B r /\ inc_po_l C p /\ not_inc_po_l C q /\ inc_po_l C r /\ inc_po_pl A alpha /\ inc_po_pl B alpha /\ inc_po_pl C alpha) -> (inc_l_pl p alpha /\ inc_l_pl q alpha /\ inc_l_pl r alpha).
Proof.
 intros.
 assert (A = B \/ A <> B) by applying (ax_g1 A B ) .
    by cases on (A = B \/ A <> B).
    - { (* Case : A = B *)
       assert (not_inc_po_l A p)  by substitution.
       assert (False) by applying (ax_false_inc_po_l A p ) .
       contradict.
      }
    - { (* Case : A <> B *)
       assert (inc_l_pl q alpha) by applying (ax_I6 A B q alpha ) .
       assert (A = C \/ A <> C) by applying (ax_g1 A C ) .
          by cases on (A = C \/ A <> C).
          - { (* Case : A = C *)
             assert (not_inc_po_l A q)  by substitution.
             assert (False) by applying (ax_false_inc_po_l A q ) .
             contradict.
            }
          - { (* Case : A <> C *)
             assert (inc_l_pl p alpha) by applying (ax_I6 A C p alpha ) .
             assert (B = C \/ B <> C) by applying (ax_g1 B C ) .
                by cases on (B = C \/ B <> C).
                - { (* Case : B = C *)
                   assert (inc_po_l B p)  by substitution.
                   assert (False) by applying (ax_false_inc_po_l B p ) .
                   contradict.
                  }
                - { (* Case : B <> C *)
                   assert (inc_l_pl r alpha) by applying (ax_I6 B C r alpha ) .
                   conclude.
                  }
            }
      }
Qed.

