theory th_7_complete_proof
imports Main 
begin
typedecl point
typedecl line
typedecl plane

consts eq_point ::  "point \<Rightarrow> point \<Rightarrow>  bool "
consts not_eq_point ::  "point \<Rightarrow> point \<Rightarrow>  bool "
consts eq_line ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts not_eq_line ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts eq_plane ::  "plane \<Rightarrow> plane \<Rightarrow>  bool "
consts not_eq_plane ::  "plane \<Rightarrow> plane \<Rightarrow>  bool "
consts inc_po_l ::  "point \<Rightarrow> line \<Rightarrow>  bool "
consts not_inc_po_l ::  "point \<Rightarrow> line \<Rightarrow>  bool "
consts inc_po_pl ::  "point \<Rightarrow> plane \<Rightarrow>  bool "
consts not_inc_po_pl ::  "point \<Rightarrow> plane \<Rightarrow>  bool "
consts inc_l_pl ::  "line \<Rightarrow> plane \<Rightarrow>  bool "
consts not_inc_l_pl ::  "line \<Rightarrow> plane \<Rightarrow>  bool "
consts int_l_l ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts not_int_l_l ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts int_l_pl ::  "line \<Rightarrow> plane \<Rightarrow>  bool "
consts not_int_l_pl ::  "line \<Rightarrow> plane \<Rightarrow>  bool "
consts int_pl_pl ::  "plane \<Rightarrow> plane \<Rightarrow>  bool "
consts not_int_pl_pl ::  "plane \<Rightarrow> plane \<Rightarrow>  bool "
consts cop ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cop ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts col ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_col ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts bet ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_bet ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cong_angle ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cong_angle ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts order ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_order ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts cut ::  "line \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts not_cut ::  "line \<Rightarrow> point \<Rightarrow> point \<Rightarrow>  bool "
consts pash ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> line \<Rightarrow> plane \<Rightarrow>  bool "
consts not_pash ::  "point \<Rightarrow> point \<Rightarrow> point \<Rightarrow> line \<Rightarrow> plane \<Rightarrow>  bool "
consts parallel ::  "line \<Rightarrow> line \<Rightarrow>  bool "
consts not_parallel ::  "line \<Rightarrow> line \<Rightarrow>  bool "

axiomatization where 

ax_cut_1: "\<lbrakk>\<not> inc_po_l B p; \<not> inc_po_l C p; inc_po_l D p; bet B D C\<rbrakk> \<Longrightarrow> (cut p B C)"
and ax_D11b: "\<lbrakk>inc_po_l A q; \<not> inc_po_pl A gamma\<rbrakk> \<Longrightarrow> (\<not> inc_l_pl q gamma)"
and ax_D11: "\<lbrakk>inc_l_pl q gamma; inc_po_l A q\<rbrakk> \<Longrightarrow> (inc_po_pl A gamma)"
and ax_D1a: "\<lbrakk>A ~= B; inc_po_l A s; inc_po_l B s; \<not> inc_po_l C s\<rbrakk> \<Longrightarrow> (\<not> col A B C)"
and ax_D1: "\<lbrakk>inc_po_l A s; inc_po_l B s; inc_po_l C s\<rbrakk> \<Longrightarrow> (col A B C)"
and ax_D2a: "\<lbrakk>A ~= B; inc_po_l A s; inc_po_l B s; \<not> col A B C\<rbrakk> \<Longrightarrow> (\<not> inc_po_l C s)"
and ax_D3a: "\<lbrakk>\<not> col A B C; inc_po_pl A beta1; inc_po_pl B beta1; inc_po_pl C beta1; \<not> inc_po_pl D beta1\<rbrakk> \<Longrightarrow> (\<not> cop A B C D)"
and ax_D3: "\<lbrakk>inc_po_pl A beta1; inc_po_pl B beta1; inc_po_pl C beta1; inc_po_pl D beta1\<rbrakk> \<Longrightarrow> (cop A B C D)"
and ax_D4a: "\<lbrakk>\<not> col A B C; inc_po_pl A beta1; inc_po_pl B beta1; inc_po_pl C beta1; \<not> cop A B C D\<rbrakk> \<Longrightarrow> (\<not> inc_po_pl D beta1)"
and ax_D5a: "\<lbrakk>p ~= q; \<not> int_l_l p q; inc_po_l C p\<rbrakk> \<Longrightarrow> (\<not> inc_po_l C q)"
and ax_D5: "\<lbrakk>p ~= q; inc_po_l C p; inc_po_l C q\<rbrakk> \<Longrightarrow> (int_l_l p q)"
and ax_D7a: "\<lbrakk>alpha ~= beta; inc_po_pl C alpha; \<not> int_pl_pl alpha beta\<rbrakk> \<Longrightarrow> (\<not> inc_po_pl C beta)"
and ax_D7: "\<lbrakk>alpha ~= beta; inc_po_pl C alpha; inc_po_pl C beta\<rbrakk> \<Longrightarrow> (int_pl_pl alpha beta)"
and ax_D9a: "\<lbrakk>\<not> inc_l_pl p beta; \<not> int_l_pl p beta; inc_po_l C p\<rbrakk> \<Longrightarrow> (\<not> inc_po_pl C beta)"
and ax_D9b: "\<lbrakk>\<not> inc_l_pl p beta; \<not> int_l_pl p beta; inc_po_pl C beta\<rbrakk> \<Longrightarrow> (\<not> inc_po_l C p)"
and ax_D9: "\<lbrakk>\<not> inc_l_pl p beta; inc_po_l C p; inc_po_pl C beta\<rbrakk> \<Longrightarrow> (int_l_pl p beta)"
and ax_false_bet: "\<lbrakk>bet A B C; \<not> bet A B C\<rbrakk> \<Longrightarrow> (False)"
and ax_false_col: "\<lbrakk>col A B C; \<not> col A B C\<rbrakk> \<Longrightarrow> (False)"
and ax_false_cop: "\<lbrakk>cop A B C D; \<not> cop A B C D\<rbrakk> \<Longrightarrow> (False)"
and ax_false_cut: "\<lbrakk>cut p B C; \<not> cut p B C\<rbrakk> \<Longrightarrow> (False)"
and ax_false_inc_l_pl: "\<lbrakk>inc_l_pl p beta; \<not> inc_l_pl p beta\<rbrakk> \<Longrightarrow> (False)"
and ax_false_inc_po_l: "\<lbrakk>inc_po_l A q; \<not> inc_po_l A q\<rbrakk> \<Longrightarrow> (False)"
and ax_false_inc_po_pl: "\<lbrakk>inc_po_pl A beta; \<not> inc_po_pl A beta\<rbrakk> \<Longrightarrow> (False)"
and ax_false_int_l_l: "\<lbrakk>int_l_l p q; \<not> int_l_l p q\<rbrakk> \<Longrightarrow> (False)"
and ax_false_int_l_pl: "\<lbrakk>int_l_pl p beta; \<not> int_l_pl p beta\<rbrakk> \<Longrightarrow> (False)"
and ax_false_int_pl_pl: "\<lbrakk>int_pl_pl alpha beta; \<not> int_pl_pl alpha beta\<rbrakk> \<Longrightarrow> (False)"
and ax_false_pash: "\<lbrakk>pash A B C s beta1; \<not> pash A B C s beta1\<rbrakk> \<Longrightarrow> (False)"
and ax_I2: "\<lbrakk>A ~= B; inc_po_l A r; inc_po_l B r; inc_po_l A s; inc_po_l B s\<rbrakk> \<Longrightarrow> (r = s)"
and ax_I5: "\<lbrakk>\<not> col A B C; inc_po_pl A alpha1; inc_po_pl B alpha1; inc_po_pl C alpha1; inc_po_pl A beta1; inc_po_pl B beta1; inc_po_pl C beta1\<rbrakk> \<Longrightarrow> (alpha1 = beta1)"
and ax_I6: "\<lbrakk>A ~= B; inc_po_l A r; inc_po_l B r; inc_po_pl A alpha1; inc_po_pl B alpha1\<rbrakk> \<Longrightarrow> (inc_l_pl r alpha1)"
and ax_II1: "\<lbrakk>bet A B C\<rbrakk> \<Longrightarrow> (A ~= B \<and> A ~= C \<and> B ~= C \<and> col A B C \<and> bet C B A)"
and ax_II3: "\<lbrakk>A ~= B; A ~= C; B ~= C; bet A B C\<rbrakk> \<Longrightarrow> (\<not> bet B C A \<and> \<not> bet C A B)"
and ax_pash_1: "\<lbrakk>\<not> col A B C; inc_po_pl A beta1; inc_po_pl B beta1; inc_po_pl C beta1; inc_l_pl s beta1; \<not> inc_po_l A s; \<not> inc_po_l B s; \<not> inc_po_l C s; cut s B C\<rbrakk> \<Longrightarrow> (pash A B C s beta1)"
and ax_pash_2: "\<lbrakk>pash A B C s beta1\<rbrakk> \<Longrightarrow> (\<not> col A B C \<and> inc_po_pl A beta1 \<and> inc_po_pl B beta1 \<and> inc_po_pl C beta1 \<and> inc_l_pl s beta1 \<and> \<not> inc_po_l A s \<and> \<not> inc_po_l B s \<and> \<not> inc_po_l C s \<and> cut s B C)"
and ax_sym_col1: "\<lbrakk>col A B C\<rbrakk> \<Longrightarrow> (col B C A)"
and ax_sym_col2: "\<lbrakk>col A B C\<rbrakk> \<Longrightarrow> (col B A C)"
and ax_sym_col: "\<lbrakk>col A B C\<rbrakk> \<Longrightarrow> (col A C B \<and> col B A C \<and> col B C A \<and> col C A B \<and> col C B A)"
and ax_sym_cop1: "\<lbrakk>cop A B C D\<rbrakk> \<Longrightarrow> (cop B C D A)"
and ax_sym_cop2: "\<lbrakk>cop A B C D\<rbrakk> \<Longrightarrow> (cop B A C D)"
and ax_sym_cop: "\<lbrakk>cop A B C D\<rbrakk> \<Longrightarrow> (cop A B D C \<and> cop A C B D \<and> cop A C D B \<and> cop A D B C \<and> cop A D C B \<and> cop B A C D \<and> cop B A D C \<and> cop B C A D \<and> cop B C D A \<and> cop B D A C \<and> cop B D C A \<and> cop C A B D \<and> cop C A D B \<and> cop C B A D \<and> cop C B D A \<and> cop C D A B \<and> cop C D B A \<and> cop D A B C \<and> cop D A C B \<and> cop D B A C \<and> cop D B C A \<and> cop D C A B \<and> cop D C B A)"
and ax_sym_int_l_l: "\<lbrakk>int_l_l p q\<rbrakk> \<Longrightarrow> (int_l_l q p)"
and ax_sym_int_pl_pl: "\<lbrakk>int_pl_pl alpha beta\<rbrakk> \<Longrightarrow> (int_pl_pl beta alpha)"
and ax_sym_ncol1: "\<lbrakk>\<not> col A B C\<rbrakk> \<Longrightarrow> (\<not> col B C A)"
and ax_sym_ncol2: "\<lbrakk>\<not> col A B C\<rbrakk> \<Longrightarrow> (\<not> col B A C)"
and ax_sym_ncol: "\<lbrakk>\<not> col A B C\<rbrakk> \<Longrightarrow> (\<not> col A C B \<and> \<not> col B A C \<and> \<not> col B C A \<and> \<not> col C A B \<and> \<not> col C B A)"
and ax_sym_ncop1: "\<lbrakk>\<not> cop A B C D\<rbrakk> \<Longrightarrow> (\<not> cop B C D A)"
and ax_sym_ncop2: "\<lbrakk>\<not> cop A B C D\<rbrakk> \<Longrightarrow> (\<not> cop B A C D)"
and ax_sym_ncop: "\<lbrakk>\<not> cop A B C D\<rbrakk> \<Longrightarrow> (\<not> cop A B D C \<and> \<not> cop A C B D \<and> \<not> cop A C D B \<and> \<not> cop A D B C \<and> \<not> cop A D C B \<and> \<not> cop B A C D \<and> \<not> cop B A D C \<and> \<not> cop B C A D \<and> \<not> cop B C D A \<and> \<not> cop B D A C \<and> \<not> cop B D C A \<and> \<not> cop C A B D \<and> \<not> cop C A D B \<and> \<not> cop C B A D \<and> \<not> cop C B D A \<and> \<not> cop C D A B \<and> \<not> cop C D B A \<and> \<not> cop D A B C \<and> \<not> cop D A C B \<and> \<not> cop D B A C \<and> \<not> cop D B C A \<and> \<not> cop D C A B \<and> \<not> cop D C B A)"
and ax_sym_nint_l_l: "\<lbrakk>\<not> int_l_l p q\<rbrakk> \<Longrightarrow> (\<not> int_l_l q p)"
and ax_sym_nint_pl_pl: "\<lbrakk>\<not> int_pl_pl alpha beta\<rbrakk> \<Longrightarrow> (\<not> int_pl_pl beta alpha)"
and ax_branch_bet: "(bet A B C)\<or>(\<not> bet A B C)"
and ax_branch_col: "\<lbrakk>A ~= B; A ~= C; B ~= C\<rbrakk> \<Longrightarrow> (col A B C)\<or>(\<not> col A B C)"
and ax_branch_cop: "\<lbrakk>A ~= B; A ~= C; A ~= D; B ~= C; B ~= D; C ~= D\<rbrakk> \<Longrightarrow> (cop A B C D)\<or>(\<not> cop A B C D)"
and ax_branch_cut: "\<lbrakk>B ~= C\<rbrakk> \<Longrightarrow> (cut p B C)\<or>(\<not> cut p B C)"
and ax_branch_inc_l_pl: "(inc_l_pl p beta)\<or>(\<not> inc_l_pl p beta)"
and ax_branch_inc_po_l: "(inc_po_l A q)\<or>(\<not> inc_po_l A q)"
and ax_branch_inc_po_pl: "(inc_po_pl A beta)\<or>(\<not> inc_po_pl A beta)"
and ax_branch_int_l_l: "\<lbrakk>p ~= q\<rbrakk> \<Longrightarrow> (int_l_l p q)\<or>(\<not> int_l_l p q)"
and ax_branch_int_l_pl: "(int_l_pl p beta)\<or>(\<not> int_l_pl p beta)"
and ax_branch_int_pl_pl: "\<lbrakk>alpha ~= beta\<rbrakk> \<Longrightarrow> (int_pl_pl alpha beta)\<or>(\<not> int_pl_pl alpha beta)"
and ax_branch_pash: "\<lbrakk>A ~= B; A ~= C; B ~= C\<rbrakk> \<Longrightarrow> (pash A B C s beta1)\<or>(\<not> pash A B C s beta1)"
and ax_II4: "\<lbrakk>pash A B C s beta1\<rbrakk> \<Longrightarrow> (cut s C A)\<or>(cut s A B)"
and ax_g1: "(A = B)\<or>(A ~= B)"
and ax_g2: "(p = q)\<or>(p ~= q)"
and ax_g3: "(alpha = beta)\<or>(alpha ~= beta)"
and ax_cut_2: "\<lbrakk>cut p B C\<rbrakk> \<Longrightarrow> \<exists>(D::point).(\<not> inc_po_l B p \<and> \<not> inc_po_l C p \<and> inc_po_l D p \<and> bet B D C)"
and ax_D10: "\<lbrakk>int_l_pl p beta\<rbrakk> \<Longrightarrow> \<exists>(C::point).(inc_po_l C p \<and> inc_po_pl C beta \<and> \<not> inc_l_pl p beta)"
and ax_D11a: "\<lbrakk>\<not> inc_l_pl p beta\<rbrakk> \<Longrightarrow> \<exists>(C::point).(inc_po_l C p \<and> \<not> inc_po_pl C beta)"
and ax_D2: "\<lbrakk>col A B C\<rbrakk> \<Longrightarrow> \<exists>(s::line).(inc_po_l A s \<and> inc_po_l B s \<and> inc_po_l C s)"
and ax_D4: "\<lbrakk>cop A B C D\<rbrakk> \<Longrightarrow> \<exists>(beta1::plane).(inc_po_pl A beta1 \<and> inc_po_pl B beta1 \<and> inc_po_pl C beta1 \<and> inc_po_pl D beta1)"
and ax_D6: "\<lbrakk>int_l_l p q\<rbrakk> \<Longrightarrow> \<exists>(C::point).(p ~= q \<and> inc_po_l C p \<and> inc_po_l C q)"
and ax_D8: "\<lbrakk>int_pl_pl alpha beta\<rbrakk> \<Longrightarrow> \<exists>(C::point).(alpha ~= beta \<and> inc_po_pl C alpha \<and> inc_po_pl C beta)"
and ax_I1: "\<lbrakk>A ~= B\<rbrakk> \<Longrightarrow> \<exists>(r::line).(inc_po_l A r \<and> inc_po_l B r)"
and ax_I3a: "\<exists>(B::point)(C::point).(B ~= C \<and> inc_po_l B p \<and> inc_po_l C p)"
and ax_I4a: "\<lbrakk>\<not> col A B C\<rbrakk> \<Longrightarrow> \<exists>(alpha1::plane).(inc_po_pl A alpha1 \<and> inc_po_pl B alpha1 \<and> inc_po_pl C alpha1)"
and ax_I4b: "\<exists>(B::point).(inc_po_pl B alpha)"
and ax_I7: "\<lbrakk>alpha ~= beta; inc_po_pl C alpha; inc_po_pl C beta\<rbrakk> \<Longrightarrow> \<exists>(D::point).(C ~= D \<and> inc_po_pl D alpha \<and> inc_po_pl D beta)"
and ax_II2: "\<lbrakk>A ~= B\<rbrakk> \<Longrightarrow> \<exists>(C::point).(bet A B C)"
and ax_I3b: "\<exists>(A::point)(B::point)(C::point).(\<not> col A B C)"
and ax_I8: "\<exists>(A::point)(B::point)(C::point)(D::point).(\<not> cop A B C D)"

lemma th_7_01 :  assumes  "A ~= B"  shows "\<exists>(p::line)(C::point).(inc_po_l A p \<and> inc_po_l B p \<and> \<not> inc_po_l C p)" 

proof - 

from `A ~= B`
obtain p::line
  where "inc_po_l A p" and "inc_po_l B p"
  using ax_I1 [of "A" "B"] 
  by auto 

obtain C::point and D::point and E::point
  where "\<not> col C D E"
  using ax_I3b
  by auto 

have "inc_po_l C p \<or> \<not> inc_po_l C p"
  by (subst disj_commute, rule excluded_middle)

   show ?thesis
   proof(cases "inc_po_l C p")
     case True


      have "inc_po_l D p \<or> \<not> inc_po_l D p"
        by (subst disj_commute, rule excluded_middle)

         show ?thesis
         proof(cases "inc_po_l D p")
           case True


            have "inc_po_l E p \<or> \<not> inc_po_l E p"
              by (subst disj_commute, rule excluded_middle)

               show ?thesis
               proof(cases "inc_po_l E p")
                 case True


                  from `inc_po_l C p` and `inc_po_l D p` and `inc_po_l E p`
                  have "col C D E"
                    by (rule ax_D1)

                  from `\<not> col C D E` and `col C D E`
                  have "False"
                    by (rule notE)

                  from this
                  show ?thesis 
                    by (rule FalseE) 
               next
                 case False


                  from `inc_po_l A p` and `inc_po_l B p` and `\<not> inc_po_l E p`
                  show ?thesis 
                    by auto 
               qed
         next
           case False


            from `inc_po_l A p` and `inc_po_l B p` and `\<not> inc_po_l D p`
            show ?thesis 
              by auto 
         qed
   next
     case False


      from `inc_po_l A p` and `inc_po_l B p` and `\<not> inc_po_l C p`
      show ?thesis 
        by auto 
   qed
qed



lemma th_7_02 :  assumes  "A ~= B" and "inc_po_l A p" and "inc_po_l B p" and "\<not> inc_po_l C p"  shows "\<exists>(D::point).(bet B C D)" 

proof - 

have "B = C \<or> B ~= C"
  by (subst disj_commute, rule excluded_middle)

   show ?thesis
   proof(cases "B = C")
     case True


      from `\<not> inc_po_l C p` and `B = C`
      have "\<not> inc_po_l B p"
        by simp

      from `\<not> inc_po_l B p` and `inc_po_l B p`
      have "False"
        by (rule notE)

      from this
      show ?thesis 
        by (rule FalseE) 
   next
     case False


      from `B ~= C`
      obtain G::point
        where "bet B C G"
        using ax_II2 [of "B" "C"] 
        by auto 

      from `bet B C G`
      show ?thesis 
        by auto 
   qed
qed



lemma th_7_03 :  assumes  "A ~= B" and "inc_po_l A p" and "inc_po_l B p" and "\<not> inc_po_l C p" and "bet B C D"  shows "\<exists>(E::point).(bet A D E)" 

proof - 

from `bet B C D`
have "B ~= C" and "B ~= D" and "C ~= D" and "col B C D" and "bet D C B"
  using ax_II1 [of "B" "C" "D"] 
  by auto 

from `col B C D`
have "col B D C" and "col C B D" and "col C D B" and "col D B C" and "col D C B"
  using ax_sym_col [of "B" "C" "D"] 
  by auto 

from `A ~= B`
have "B ~= A"
  by (rule not_sym)

from `B ~= A` and `inc_po_l B p` and `inc_po_l A p` and `\<not> inc_po_l C p`
have "\<not> col B A C"
  by (rule ax_D1a)

have "A = D \<or> A ~= D"
  by (subst disj_commute, rule excluded_middle)

   show ?thesis
   proof(cases "A = D")
     case True


      from `\<not> col B A C` and `A = D`
      have "\<not> col B D C"
        by simp

      from `\<not> col B D C` and `col B D C`
      have "False"
        by (rule notE)

      from this
      show ?thesis 
        by (rule FalseE) 
   next
     case False


      from `A ~= D`
      obtain G::point
        where "bet A D G"
        using ax_II2 [of "A" "D"] 
        by auto 

      from `bet A D G`
      show ?thesis 
        by auto 
   qed
qed



lemma th_7_04 :  assumes  "A ~= B" and "inc_po_l A p" and "inc_po_l B p" and "\<not> inc_po_l C p" and "bet B C D" and "bet A D E"  shows "(\<not> col A B D)" 

proof - 

from `bet B C D`
have "B ~= C" and "B ~= D" and "C ~= D" and "col B C D" and "bet D C B"
  using ax_II1 [of "B" "C" "D"] 
  by auto 

from `col B C D`
have "col B D C" and "col C B D" and "col C D B" and "col D B C" and "col D C B"
  using ax_sym_col [of "B" "C" "D"] 
  by auto 

have "inc_po_l D p \<or> \<not> inc_po_l D p"
  by (subst disj_commute, rule excluded_middle)

   show ?thesis
   proof(cases "inc_po_l D p")
     case True


      from `B ~= D` and `inc_po_l B p` and `inc_po_l D p` and `\<not> inc_po_l C p`
      have "\<not> col B D C"
        by (rule ax_D1a)

      from `\<not> col B D C` and `col B D C`
      have "False"
        by (rule notE)

      from this
      show ?thesis 
        by (rule FalseE) 
   next
     case False


      from `A ~= B` and `inc_po_l A p` and `inc_po_l B p` and `\<not> inc_po_l D p`
      have "\<not> col A B D"
        by (rule ax_D1a)

      from `\<not> col A B D`
      show ?thesis 
        by assumption
   qed
qed



lemma th_7_05 :  assumes  "A ~= B" and "inc_po_l A p" and "inc_po_l B p" and "\<not> inc_po_l C p" and "bet B C D" and "bet A D E" and "\<not> col A B D"  shows "\<exists>(q::line).(inc_po_l E q \<and> inc_po_l C q)" 

proof - 

have "A = C \<or> A ~= C"
  by (subst disj_commute, rule excluded_middle)

   show ?thesis
   proof(cases "A = C")
     case True


      from `\<not> inc_po_l C p` and `A = C`
      have "\<not> inc_po_l A p"
        by simp

      from `\<not> inc_po_l A p` and `inc_po_l A p`
      have "False"
        by (rule notE)

      from this
      show ?thesis 
        by (rule FalseE) 
   next
     case False


      from `A ~= C`
      obtain q::line
        where "inc_po_l A q" and "inc_po_l C q"
        using ax_I1 [of "A" "C"] 
        by auto 

      have "B = C \<or> B ~= C"
        by (subst disj_commute, rule excluded_middle)

         show ?thesis
         proof(cases "B = C")
           case True


            from `\<not> inc_po_l C p` and `B = C`
            have "\<not> inc_po_l B p"
              by simp

            from `\<not> inc_po_l B p` and `inc_po_l B p`
            have "False"
              by (rule notE)

            from this
            show ?thesis 
              by (rule FalseE) 
         next
           case False


            from `B ~= C`
            obtain r::line
              where "inc_po_l B r" and "inc_po_l C r"
              using ax_I1 [of "B" "C"] 
              by auto 

            have "B = E \<or> B ~= E"
              by (subst disj_commute, rule excluded_middle)

               show ?thesis
               proof(cases "B = E")
                 case True


                  from `inc_po_l B r` and `B = E`
                  have "inc_po_l E r"
                    by simp

                  from `inc_po_l E r` and `inc_po_l C r`
                  show ?thesis 
                    by auto 
               next
                 case False


                  have "C = E \<or> C ~= E"
                    by (subst disj_commute, rule excluded_middle)

                     show ?thesis
                     proof(cases "C = E")
                       case True


                        from `inc_po_l C q` and `C = E`
                        have "inc_po_l E q"
                          by simp

                        from `inc_po_l E q` and `inc_po_l C q`
                        show ?thesis 
                          by auto 
                     next
                       case False


                        from `C ~= E`
                        obtain u::line
                          where "inc_po_l C u" and "inc_po_l E u"
                          using ax_I1 [of "C" "E"] 
                          by auto 

                        from `inc_po_l E u` and `inc_po_l C u`
                        show ?thesis 
                          by auto 
                     qed
               qed
         qed
   qed
qed



lemma th_7_06 :  assumes  "A ~= B" and "inc_po_l A p" and "inc_po_l B p" and "\<not> inc_po_l C p" and "bet B C D" and "bet A D E" and "\<not> col A B D" and "inc_po_l E q" and "inc_po_l C q"  shows "(\<not> inc_po_l A q)" 

proof - 

from `bet A D E`
have "A ~= D" and "A ~= E" and "D ~= E" and "col A D E" and "bet E D A"
  using ax_II1 [of "A" "D" "E"] 
  by auto 

from `bet B C D`
have "B ~= C" and "B ~= D" and "C ~= D" and "col B C D" and "bet D C B"
  using ax_II1 [of "B" "C" "D"] 
  by auto 

from `col A D E`
have "col A E D" and "col D A E" and "col D E A" and "col E A D" and "col E D A"
  using ax_sym_col [of "A" "D" "E"] 
  by auto 

from `col B C D`
have "col B D C" and "col C B D" and "col C D B" and "col D B C" and "col D C B"
  using ax_sym_col [of "B" "C" "D"] 
  by auto 

from `A ~= B` and `inc_po_l A p` and `inc_po_l B p` and `\<not> inc_po_l C p`
have "\<not> col A B C"
  by (rule ax_D1a)

have "inc_po_l A q \<or> \<not> inc_po_l A q"
  by (subst disj_commute, rule excluded_middle)

   show ?thesis
   proof(cases "inc_po_l A q")
     case True


      have "inc_po_l B q \<or> \<not> inc_po_l B q"
        by (subst disj_commute, rule excluded_middle)

         show ?thesis
         proof(cases "inc_po_l B q")
           case True


            from `inc_po_l A q` and `inc_po_l B q` and `inc_po_l C q`
            have "col A B C"
              by (rule ax_D1)

            from `\<not> col A B C` and `col A B C`
            have "False"
              by (rule notE)

            from this
            show ?thesis 
              by (rule FalseE) 
         next
           case False


            have "inc_po_l D q \<or> \<not> inc_po_l D q"
              by (subst disj_commute, rule excluded_middle)

               show ?thesis
               proof(cases "inc_po_l D q")
                 case True


                  from `C ~= D` and `inc_po_l C q` and `inc_po_l D q` and `\<not> inc_po_l B q`
                  have "\<not> col C D B"
                    by (rule ax_D1a)

                  from `\<not> col C D B` and `col C D B`
                  have "False"
                    by (rule notE)

                  from this
                  show ?thesis 
                    by (rule FalseE) 
               next
                 case False


                  from `A ~= E` and `inc_po_l A q` and `inc_po_l E q` and `\<not> inc_po_l D q`
                  have "\<not> col A E D"
                    by (rule ax_D1a)

                  from `\<not> col A E D` and `col A E D`
                  have "False"
                    by (rule notE)

                  from this
                  show ?thesis 
                    by (rule FalseE) 
               qed
         qed
   next
     case False


      from `\<not> inc_po_l A q`
      show ?thesis 
        by assumption
   qed
qed



lemma th_7_07 :  assumes  "A ~= B" and "inc_po_l A p" and "inc_po_l B p" and "\<not> inc_po_l C p" and "bet B C D" and "bet A D E" and "\<not> col A B D" and "inc_po_l E q" and "inc_po_l C q" and "\<not> inc_po_l A q"  shows "\<exists>(alpha::plane).(inc_po_pl A alpha \<and> inc_po_pl B alpha \<and> inc_po_pl D alpha)" 

proof - 

from `\<not> col A B D`
obtain alpha::plane
  where "inc_po_pl A alpha" and "inc_po_pl B alpha" and "inc_po_pl D alpha"
  using ax_I4a [of "A" "B" "D"] 
  by auto 

from `inc_po_pl A alpha` and `inc_po_pl B alpha` and `inc_po_pl D alpha`
have ?thesis
  by auto 

from this
show ?thesis 
.
qed



lemma th_7_08 :  assumes  "A ~= B" and "inc_po_l A p" and "inc_po_l B p" and "\<not> inc_po_l C p" and "bet B C D" and "bet A D E" and "\<not> col A B D" and "inc_po_l E q" and "inc_po_l C q" and "\<not> inc_po_l A q" and "inc_po_pl A alpha" and "inc_po_pl B alpha" and "inc_po_pl D alpha"  shows "(inc_po_pl C alpha)" 

proof - 

from `bet B C D`
have "B ~= C" and "B ~= D" and "C ~= D" and "col B C D" and "bet D C B"
  using ax_II1 [of "B" "C" "D"] 
  by auto 

from `col B C D`
obtain s::line
  where "inc_po_l B s" and "inc_po_l C s" and "inc_po_l D s"
  using ax_D2 [of "B" "C" "D"] 
  by auto 

from `B ~= D` and `inc_po_l B s` and `inc_po_l D s` and `inc_po_pl B alpha` and `inc_po_pl D alpha`
have "inc_l_pl s alpha"
  by (rule ax_I6)

from `inc_l_pl s alpha` and `inc_po_l C s`
have "inc_po_pl C alpha"
  by (rule ax_D11)

from `inc_po_pl C alpha`
have ?thesis
  by assumption

from this
show ?thesis 
.
qed



lemma th_7_09 :  assumes  "A ~= B" and "inc_po_l A p" and "inc_po_l B p" and "\<not> inc_po_l C p" and "bet B C D" and "bet A D E" and "\<not> col A B D" and "inc_po_l E q" and "inc_po_l C q" and "\<not> inc_po_l A q" and "inc_po_pl A alpha" and "inc_po_pl B alpha" and "inc_po_pl D alpha" and "inc_po_pl C alpha"  shows "(inc_po_pl E alpha)" 

proof - 

from `bet A D E`
have "A ~= D" and "A ~= E" and "D ~= E" and "col A D E" and "bet E D A"
  using ax_II1 [of "A" "D" "E"] 
  by auto 

from `bet B C D`
have "B ~= C" and "B ~= D" and "C ~= D" and "col B C D" and "bet D C B"
  using ax_II1 [of "B" "C" "D"] 
  by auto 

from `col B C D`
have "col B D C" and "col C B D" and "col C D B" and "col D B C" and "col D C B"
  using ax_sym_col [of "B" "C" "D"] 
  by auto 

from `A ~= D`
obtain s::line
  where "inc_po_l A s" and "inc_po_l D s"
  using ax_I1 [of "A" "D"] 
  by auto 

from `A ~= D` and `inc_po_l A s` and `inc_po_l D s` and `inc_po_pl A alpha` and `inc_po_pl D alpha`
have "inc_l_pl s alpha"
  by (rule ax_I6)

have "inc_po_l B q \<or> \<not> inc_po_l B q"
  by (subst disj_commute, rule excluded_middle)

   show ?thesis
   proof(cases "inc_po_l B q")
     case True


      from `B ~= C` and `inc_po_l B q` and `inc_po_l C q` and `inc_po_pl B alpha` and `inc_po_pl C alpha`
      have "inc_l_pl q alpha"
        by (rule ax_I6)

      from `inc_l_pl q alpha` and `inc_po_l E q`
      have "inc_po_pl E alpha"
        by (rule ax_D11)

      from `inc_po_pl E alpha`
      show ?thesis 
        by assumption
   next
     case False


      have "A = C \<or> A ~= C"
        by (subst disj_commute, rule excluded_middle)

         show ?thesis
         proof(cases "A = C")
           case True


            from `col C B D` and `A = C`
            have "col A B D"
              by simp

            from `\<not> col A B D` and `col A B D`
            have "False"
              by (rule notE)

            from this
            show ?thesis 
              by (rule FalseE) 
         next
           case False


            from `A ~= C`
            obtain r::line
              where "inc_po_l A r" and "inc_po_l C r"
              using ax_I1 [of "A" "C"] 
              by auto 

            from `A ~= C` and `inc_po_l A r` and `inc_po_l C r` and `inc_po_pl A alpha` and `inc_po_pl C alpha`
            have "inc_l_pl r alpha"
              by (rule ax_I6)

            have "inc_po_l B r \<or> \<not> inc_po_l B r"
              by (subst disj_commute, rule excluded_middle)

               show ?thesis
               proof(cases "inc_po_l B r")
                 case True


                  have "inc_po_l D r \<or> \<not> inc_po_l D r"
                    by (subst disj_commute, rule excluded_middle)

                     show ?thesis
                     proof(cases "inc_po_l D r")
                       case True


                        have "inc_po_l E r \<or> \<not> inc_po_l E r"
                          by (subst disj_commute, rule excluded_middle)

                           show ?thesis
                           proof(cases "inc_po_l E r")
                             case True


                              from `inc_l_pl r alpha` and `inc_po_l E r`
                              have "inc_po_pl E alpha"
                                by (rule ax_D11)

                              from `inc_po_pl E alpha`
                              show ?thesis 
                                by assumption
                           next
                             case False


                              from `A ~= D` and `inc_po_l A r` and `inc_po_l D r` and `\<not> inc_po_l E r`
                              have "\<not> col A D E"
                                by (rule ax_D1a)

                              from `\<not> col A D E` and `col A D E`
                              have "False"
                                by (rule notE)

                              from this
                              show ?thesis 
                                by (rule FalseE) 
                           qed
                     next
                       case False


                        from `B ~= C` and `inc_po_l B r` and `inc_po_l C r` and `\<not> inc_po_l D r`
                        have "\<not> col B C D"
                          by (rule ax_D1a)

                        from `\<not> col B C D` and `col B C D`
                        have "False"
                          by (rule notE)

                        from this
                        show ?thesis 
                          by (rule FalseE) 
                     qed
               next
                 case False


                  have "inc_po_l E s \<or> \<not> inc_po_l E s"
                    by (subst disj_commute, rule excluded_middle)

                     show ?thesis
                     proof(cases "inc_po_l E s")
                       case True


                        from `inc_l_pl s alpha` and `inc_po_l E s`
                        have "inc_po_pl E alpha"
                          by (rule ax_D11)

                        from `inc_po_pl E alpha`
                        show ?thesis 
                          by assumption
                     next
                       case False


                        from `A ~= D` and `inc_po_l A s` and `inc_po_l D s` and `\<not> inc_po_l E s`
                        have "\<not> col A D E"
                          by (rule ax_D1a)

                        from `\<not> col A D E` and `col A D E`
                        have "False"
                          by (rule notE)

                        from this
                        show ?thesis 
                          by (rule FalseE) 
                     qed
               qed
         qed
   qed
qed



lemma th_7_10 :  assumes  "A ~= B" and "inc_po_l A r" and "inc_po_l B r" and "\<not> inc_po_l D r" and "bet B D E" and "bet A E F" and "\<not> col A B E" and "inc_po_l F v" and "inc_po_l D v" and "\<not> inc_po_l A v" and "inc_po_pl A gamma2" and "inc_po_pl B gamma2" and "inc_po_pl E gamma2" and "inc_po_pl D gamma2" and "inc_po_pl F gamma2"  shows "(inc_l_pl v gamma2)" 
sorry 


lemma th_7_11 :  assumes  "A ~= B" and "inc_po_l A r" and "inc_po_l B r" and "\<not> inc_po_l D r" and "bet B D E" and "bet A E F" and "\<not> col A B E" and "inc_po_l F v" and "inc_po_l D v" and "\<not> inc_po_l A v" and "inc_po_pl A gamma2" and "inc_po_pl B gamma2" and "inc_po_pl E gamma2" and "inc_po_pl D gamma2" and "inc_po_pl F gamma2" and "inc_l_pl v gamma2"  shows "(\<not> inc_po_l A v)" 
sorry 


lemma th_7_12 :  assumes  "A ~= B" and "inc_po_l A p" and "inc_po_l B p" and "\<not> inc_po_l C p" and "bet B C D" and "bet A D E" and "\<not> col A B D" and "inc_po_l E q" and "inc_po_l C q" and "\<not> inc_po_l A q" and "inc_po_pl A alpha" and "inc_po_pl B alpha" and "inc_po_pl D alpha" and "inc_po_pl C alpha" and "inc_po_pl E alpha" and "inc_l_pl q alpha" and "\<not> inc_po_l A q"  shows "(\<not> inc_po_l B q)" 

proof - 

from `bet A D E`
have "A ~= D" and "A ~= E" and "D ~= E" and "col A D E" and "bet E D A"
  using ax_II1 [of "A" "D" "E"] 
  by auto 

from `bet B C D`
have "B ~= C" and "B ~= D" and "C ~= D" and "col B C D" and "bet D C B"
  using ax_II1 [of "B" "C" "D"] 
  by auto 

from `bet E D A`
have "E ~= D" and "E ~= A" and "D ~= A" and "col E D A" and "bet A D E"
  using ax_II1 [of "E" "D" "A"] 
  by auto 

from `D ~= E`
have "E ~= D"
  by (rule not_sym)

have "inc_po_l B q \<or> \<not> inc_po_l B q"
  by (subst disj_commute, rule excluded_middle)

   show ?thesis
   proof(cases "inc_po_l B q")
     case True


      have "inc_po_l D q \<or> \<not> inc_po_l D q"
        by (subst disj_commute, rule excluded_middle)

         show ?thesis
         proof(cases "inc_po_l D q")
           case True


            from `E ~= D` and `inc_po_l E q` and `inc_po_l D q` and `\<not> inc_po_l A q`
            have "\<not> col E D A"
              by (rule ax_D1a)

            from `\<not> col E D A` and `col E D A`
            have "False"
              by (rule notE)

            from this
            show ?thesis 
              by (rule FalseE) 
         next
           case False


            from `B ~= C` and `inc_po_l B q` and `inc_po_l C q` and `\<not> inc_po_l D q`
            have "\<not> col B C D"
              by (rule ax_D1a)

            from `\<not> col B C D` and `col B C D`
            have "False"
              by (rule notE)

            from this
            show ?thesis 
              by (rule FalseE) 
         qed
   next
     case False


      from `\<not> inc_po_l B q`
      show ?thesis 
        by assumption
   qed
qed



lemma th_7_13 :  assumes  "A ~= B" and "inc_po_l A p" and "inc_po_l B p" and "\<not> inc_po_l C p" and "bet B C D" and "bet A D E" and "\<not> col A B D" and "inc_po_l E q" and "inc_po_l C q" and "\<not> inc_po_l A q" and "inc_po_pl A alpha" and "inc_po_pl B alpha" and "inc_po_pl D alpha" and "inc_po_pl C alpha" and "inc_po_pl E alpha" and "inc_l_pl q alpha" and "\<not> inc_po_l A q" and "\<not> inc_po_l B q"  shows "(\<not> inc_po_l D q)" 

proof - 

from `bet B C D`
have "B ~= C" and "B ~= D" and "C ~= D" and "col B C D" and "bet D C B"
  using ax_II1 [of "B" "C" "D"] 
  by auto 

from `bet D C B`
have "D ~= C" and "D ~= B" and "C ~= B" and "col D C B" and "bet B C D"
  using ax_II1 [of "D" "C" "B"] 
  by auto 

from `C ~= D`
have "D ~= C"
  by (rule not_sym)

have "inc_po_l D q \<or> \<not> inc_po_l D q"
  by (subst disj_commute, rule excluded_middle)

   show ?thesis
   proof(cases "inc_po_l D q")
     case True


      from `D ~= C` and `inc_po_l D q` and `inc_po_l C q` and `\<not> inc_po_l B q`
      have "\<not> col D C B"
        by (rule ax_D1a)

      from `\<not> col D C B` and `col D C B`
      have "False"
        by (rule notE)

      from this
      show ?thesis 
        by (rule FalseE) 
   next
     case False


      from `\<not> inc_po_l D q`
      show ?thesis 
        by assumption
   qed
qed



lemma th_7_14 :  assumes  "A ~= B" and "inc_po_l A p" and "inc_po_l B p" and "\<not> inc_po_l C p" and "bet B C D" and "bet A D E" and "\<not> col A B D" and "inc_po_l E q" and "inc_po_l C q" and "\<not> inc_po_l A q" and "inc_po_pl A alpha" and "inc_po_pl B alpha" and "inc_po_pl D alpha" and "inc_po_pl C alpha" and "inc_po_pl E alpha" and "inc_l_pl q alpha" and "\<not> inc_po_l A q" and "\<not> inc_po_l B q" and "\<not> inc_po_l D q"  shows "(cut q B D)" 

proof - 

from `\<not> inc_po_l B q` and `\<not> inc_po_l D q` and `inc_po_l C q` and `bet B C D`
have "cut q B D"
  by (rule ax_cut_1)

from `cut q B D`
have ?thesis
  by assumption

from this
show ?thesis 
.
qed



lemma th_7_15 :  assumes  "A ~= B" and "inc_po_l A p" and "inc_po_l B p" and "\<not> inc_po_l C p" and "bet B C D" and "bet A D E" and "\<not> col A B D" and "inc_po_l E q" and "inc_po_l C q" and "\<not> inc_po_l A q" and "inc_po_pl A alpha" and "inc_po_pl B alpha" and "inc_po_pl D alpha" and "inc_po_pl C alpha" and "inc_po_pl E alpha" and "inc_l_pl q alpha" and "\<not> inc_po_l A q" and "\<not> inc_po_l B q" and "\<not> inc_po_l D q" and "cut q B D"  shows "\<exists>(r::line).(pash A B D q alpha \<and> D ~= A \<and> inc_po_l D r \<and> inc_po_l A r)" 

proof - 

from `inc_po_l A p` and `inc_po_l B p` and `inc_po_l A p`
have "col A B A"
  by (rule ax_D1)

from `\<not> col A B D` and `inc_po_pl A alpha` and `inc_po_pl B alpha` and `inc_po_pl D alpha` and `inc_l_pl q alpha` and `\<not> inc_po_l A q` and `\<not> inc_po_l B q` and `\<not> inc_po_l D q` and `cut q B D`
have "pash A B D q alpha"
  by (rule ax_pash_1)

have "A = D \<or> A ~= D"
  by (subst disj_commute, rule excluded_middle)

   show ?thesis
   proof(cases "A = D")
     case True


      from `col A B A` and `A = D`
      have "col A B D"
        by simp

      from `\<not> col A B D` and `col A B D`
      have "False"
        by (rule notE)

      from this
      show ?thesis 
        by (rule FalseE) 
   next
     case False


      from `A ~= D`
      obtain r::line
        where "inc_po_l A r" and "inc_po_l D r"
        using ax_I1 [of "A" "D"] 
        by auto 

      from `A ~= D`
      have "D ~= A"
        by (rule not_sym)

      from `pash A B D q alpha` and `D ~= A` and `inc_po_l D r` and `inc_po_l A r`
      show ?thesis 
        by auto 
   qed
qed



lemma th_7_16 :  assumes  "A ~= B" and "inc_po_l A r" and "inc_po_l B r" and "\<not> inc_po_l D r" and "bet B D E" and "bet A E F" and "\<not> col A B E" and "inc_po_l F v" and "inc_po_l D v" and "\<not> inc_po_l A v" and "inc_po_pl A gamma2" and "inc_po_pl B gamma2" and "inc_po_pl E gamma2" and "inc_po_pl D gamma2" and "inc_po_pl F gamma2" and "inc_l_pl v gamma2" and "\<not> inc_po_l A v" and "\<not> inc_po_l B v" and "\<not> inc_po_l E v" and "cut v B E" and "pash A B E v gamma2" and "E ~= A" and "inc_po_l E q1" and "inc_po_l A q1"  shows "\<exists>(K::point).(bet A K B)" 
sorry 
end

(*Transformed by Vernacular package (2016)*)