(*
Title: High school geometry theorems
Authors: Hilbert's axiomatic system
Formalized by: Sana Stojanovic Djurdjevic
Proved by: ArgoGeoChecker
Date: 14.05.2016.
 *)

Ltac hyp_of_type t :=
 match goal with
| H1:t |- _ => H1
  end.

Tactic Notation "by" "cases" "on" constr(t) :=
  let H := hyp_of_type t in decompose [or] H; clear H.

Ltac applying l := apply l;repeat split;repeat subst;intuition.
Ltac contradict := solve [intuition].
Ltac substitution := intuition;repeat subst;intuition.
Ltac conclude := assumption||solve [firstorder].
Ltac decompAnd H :=try (progress (decompose [and] H);clear H).

Parameter point : Type.
Parameter line : Type.
Parameter plane : Type.

Parameter eq_point : point -> point -> Prop.
Parameter not_eq_point : point -> point -> Prop.
Parameter eq_line : line -> line -> Prop.
Parameter not_eq_line : line -> line -> Prop.
Parameter eq_plane : plane -> plane -> Prop.
Parameter not_eq_plane : plane -> plane -> Prop.
Parameter inc_po_l : point -> line -> Prop.
Parameter not_inc_po_l : point -> line -> Prop.
Parameter inc_po_pl : point -> plane -> Prop.
Parameter not_inc_po_pl : point -> plane -> Prop.
Parameter inc_l_pl : line -> plane -> Prop.
Parameter not_inc_l_pl : line -> plane -> Prop.
Parameter int_l_l : line -> line -> Prop.
Parameter not_int_l_l : line -> line -> Prop.
Parameter int_l_pl : line -> plane -> Prop.
Parameter not_int_l_pl : line -> plane -> Prop.
Parameter int_pl_pl : plane -> plane -> Prop.
Parameter not_int_pl_pl : plane -> plane -> Prop.
Parameter cop : point -> point -> point -> point -> Prop.
Parameter not_cop : point -> point -> point -> point -> Prop.
Parameter col : point -> point -> point -> Prop.
Parameter not_col : point -> point -> point -> Prop.
Parameter bet : point -> point -> point -> Prop.
Parameter not_bet : point -> point -> point -> Prop.
Parameter cong : point -> point -> point -> point -> Prop.
Parameter not_cong : point -> point -> point -> point -> Prop.
Parameter cong_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter not_cong_angle : point -> point -> point -> point -> point -> point -> Prop.
Parameter order : point -> point -> point -> point -> Prop.
Parameter not_order : point -> point -> point -> point -> Prop.
Parameter cut : line -> point -> point -> Prop.
Parameter not_cut : line -> point -> point -> Prop.
Parameter pash : point -> point -> point -> line -> plane -> Prop.
Parameter not_pash : point -> point -> point -> line -> plane -> Prop.
Parameter parallel : line -> line -> Prop.
Parameter not_parallel : line -> line -> Prop.

Axiom ax_cut_1 : forall (B:point) (p:line) (C:point) (D:point), (not_inc_po_l B p /\ not_inc_po_l C p /\ inc_po_l D p /\ bet B D C) -> cut p B C.
Axiom ax_D11b : forall (A:point) (q:line) (gamma:plane), (inc_po_l A q /\ not_inc_po_pl A gamma) -> not_inc_l_pl q gamma.
Axiom ax_D11 : forall (q:line) (gamma:plane) (A:point), (inc_l_pl q gamma /\ inc_po_l A q) -> inc_po_pl A gamma.
Axiom ax_D1a : forall (A:point) (B:point) (s:line) (C:point), (A <> B /\ inc_po_l A s /\ inc_po_l B s /\ not_inc_po_l C s) -> not_col A B C.
Axiom ax_D1 : forall (A:point) (s:line) (B:point) (C:point), (inc_po_l A s /\ inc_po_l B s /\ inc_po_l C s) -> col A B C.
Axiom ax_D2a : forall (A:point) (B:point) (s:line) (C:point), (A <> B /\ inc_po_l A s /\ inc_po_l B s /\ not_col A B C) -> not_inc_po_l C s.
Axiom ax_D3a : forall (A:point) (B:point) (C:point) (beta1:plane) (D:point), (not_col A B C /\ inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ not_inc_po_pl D beta1) -> not_cop A B C D.
Axiom ax_D3 : forall (A:point) (beta1:plane) (B:point) (C:point) (D:point), (inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ inc_po_pl D beta1) -> cop A B C D.
Axiom ax_D4a : forall (A:point) (B:point) (C:point) (beta1:plane) (D:point), (not_col A B C /\ inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ not_cop A B C D) -> not_inc_po_pl D beta1.
Axiom ax_D5a : forall (p:line) (q:line) (C:point), (p <> q /\ not_int_l_l p q /\ inc_po_l C p) -> not_inc_po_l C q.
Axiom ax_D5 : forall (p:line) (q:line) (C:point), (p <> q /\ inc_po_l C p /\ inc_po_l C q) -> int_l_l p q.
Axiom ax_D7a : forall (alpha:plane) (beta:plane) (C:point), (alpha <> beta /\ inc_po_pl C alpha /\ not_int_pl_pl alpha beta) -> not_inc_po_pl C beta.
Axiom ax_D7 : forall (alpha:plane) (beta:plane) (C:point), (alpha <> beta /\ inc_po_pl C alpha /\ inc_po_pl C beta) -> int_pl_pl alpha beta.
Axiom ax_D9a : forall (p:line) (beta:plane) (C:point), (not_inc_l_pl p beta /\ not_int_l_pl p beta /\ inc_po_l C p) -> not_inc_po_pl C beta.
Axiom ax_D9b : forall (p:line) (beta:plane) (C:point), (not_inc_l_pl p beta /\ not_int_l_pl p beta /\ inc_po_pl C beta) -> not_inc_po_l C p.
Axiom ax_D9 : forall (p:line) (beta:plane) (C:point), (not_inc_l_pl p beta /\ inc_po_l C p /\ inc_po_pl C beta) -> int_l_pl p beta.
Axiom ax_false_bet : forall (A:point) (B:point) (C:point), (bet A B C /\ not_bet A B C) -> (False).
Axiom ax_false_col : forall (A:point) (B:point) (C:point), (col A B C /\ not_col A B C) -> (False).
Axiom ax_false_cop : forall (A:point) (B:point) (C:point) (D:point), (cop A B C D /\ not_cop A B C D) -> (False).
Axiom ax_false_cut : forall (p:line) (B:point) (C:point), (cut p B C /\ not_cut p B C) -> (False).
Axiom ax_false_inc_l_pl : forall (p:line) (beta:plane), (inc_l_pl p beta /\ not_inc_l_pl p beta) -> (False).
Axiom ax_false_inc_po_l : forall (A:point) (q:line), (inc_po_l A q /\ not_inc_po_l A q) -> (False).
Axiom ax_false_inc_po_pl : forall (A:point) (beta:plane), (inc_po_pl A beta /\ not_inc_po_pl A beta) -> (False).
Axiom ax_false_int_l_l : forall (p:line) (q:line), (int_l_l p q /\ not_int_l_l p q) -> (False).
Axiom ax_false_int_l_pl : forall (p:line) (beta:plane), (int_l_pl p beta /\ not_int_l_pl p beta) -> (False).
Axiom ax_false_int_pl_pl : forall (alpha:plane) (beta:plane), (int_pl_pl alpha beta /\ not_int_pl_pl alpha beta) -> (False).
Axiom ax_false_pash : forall (A:point) (B:point) (C:point) (s:line) (beta1:plane), (pash A B C s beta1 /\ not_pash A B C s beta1) -> (False).
Axiom ax_I2 : forall (A:point) (B:point) (r:line) (s:line), (A <> B /\ inc_po_l A r /\ inc_po_l B r /\ inc_po_l A s /\ inc_po_l B s) -> r = s.
Axiom ax_I5 : forall (A:point) (B:point) (C:point) (alpha1:plane) (beta1:plane), (not_col A B C /\ inc_po_pl A alpha1 /\ inc_po_pl B alpha1 /\ inc_po_pl C alpha1 /\ inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1) -> alpha1 = beta1.
Axiom ax_I6 : forall (A:point) (B:point) (r:line) (alpha1:plane), (A <> B /\ inc_po_l A r /\ inc_po_l B r /\ inc_po_pl A alpha1 /\ inc_po_pl B alpha1) -> inc_l_pl r alpha1.
Axiom ax_II1 : forall (A:point) (B:point) (C:point), bet A B C -> (A <> B /\ A <> C /\ B <> C /\ col A B C /\ bet C B A).
Axiom ax_II3 : forall (A:point) (B:point) (C:point), (A <> B /\ A <> C /\ B <> C /\ bet A B C) -> (not_bet B C A /\ not_bet C A B).
Axiom ax_pash_1 : forall (A:point) (B:point) (C:point) (beta1:plane) (s:line), (not_col A B C /\ inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ inc_l_pl s beta1 /\ not_inc_po_l A s /\ not_inc_po_l B s /\ not_inc_po_l C s /\ cut s B C) -> pash A B C s beta1.
Axiom ax_pash_2 : forall (A:point) (B:point) (C:point) (s:line) (beta1:plane), pash A B C s beta1 -> (not_col A B C /\ inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ inc_l_pl s beta1 /\ not_inc_po_l A s /\ not_inc_po_l B s /\ not_inc_po_l C s /\ cut s B C).
Axiom ax_sym_col1 : forall (A:point) (B:point) (C:point), col A B C -> col B C A.
Axiom ax_sym_col2 : forall (A:point) (B:point) (C:point), col A B C -> col B A C.
Axiom ax_sym_col : forall (A:point) (B:point) (C:point), col A B C -> (col A C B /\ col B A C /\ col B C A /\ col C A B /\ col C B A).
Axiom ax_sym_cop1 : forall (A:point) (B:point) (C:point) (D:point), cop A B C D -> cop B C D A.
Axiom ax_sym_cop2 : forall (A:point) (B:point) (C:point) (D:point), cop A B C D -> cop B A C D.
Axiom ax_sym_cop : forall (A:point) (B:point) (C:point) (D:point), cop A B C D -> (cop A B D C /\ cop A C B D /\ cop A C D B /\ cop A D B C /\ cop A D C B /\ cop B A C D /\ cop B A D C /\ cop B C A D /\ cop B C D A /\ cop B D A C /\ cop B D C A /\ cop C A B D /\ cop C A D B /\ cop C B A D /\ cop C B D A /\ cop C D A B /\ cop C D B A /\ cop D A B C /\ cop D A C B /\ cop D B A C /\ cop D B C A /\ cop D C A B /\ cop D C B A).
Axiom ax_sym_int_l_l : forall (p:line) (q:line), int_l_l p q -> int_l_l q p.
Axiom ax_sym_int_pl_pl : forall (alpha:plane) (beta:plane), int_pl_pl alpha beta -> int_pl_pl beta alpha.
Axiom ax_sym_ncol1 : forall (A:point) (B:point) (C:point), not_col A B C -> not_col B C A.
Axiom ax_sym_ncol2 : forall (A:point) (B:point) (C:point), not_col A B C -> not_col B A C.
Axiom ax_sym_ncol : forall (A:point) (B:point) (C:point), not_col A B C -> (not_col A C B /\ not_col B A C /\ not_col B C A /\ not_col C A B /\ not_col C B A).
Axiom ax_sym_ncop1 : forall (A:point) (B:point) (C:point) (D:point), not_cop A B C D -> not_cop B C D A.
Axiom ax_sym_ncop2 : forall (A:point) (B:point) (C:point) (D:point), not_cop A B C D -> not_cop B A C D.
Axiom ax_sym_ncop : forall (A:point) (B:point) (C:point) (D:point), not_cop A B C D -> (not_cop A B D C /\ not_cop A C B D /\ not_cop A C D B /\ not_cop A D B C /\ not_cop A D C B /\ not_cop B A C D /\ not_cop B A D C /\ not_cop B C A D /\ not_cop B C D A /\ not_cop B D A C /\ not_cop B D C A /\ not_cop C A B D /\ not_cop C A D B /\ not_cop C B A D /\ not_cop C B D A /\ not_cop C D A B /\ not_cop C D B A /\ not_cop D A B C /\ not_cop D A C B /\ not_cop D B A C /\ not_cop D B C A /\ not_cop D C A B /\ not_cop D C B A).
Axiom ax_sym_nint_l_l : forall (p:line) (q:line), not_int_l_l p q -> not_int_l_l q p.
Axiom ax_sym_nint_pl_pl : forall (alpha:plane) (beta:plane), not_int_pl_pl alpha beta -> not_int_pl_pl beta alpha.
Axiom ax_branch_bet : forall (A:point) (B:point) (C:point), bet A B C \/ not_bet A B C.
Axiom ax_branch_col : forall (A:point) (B:point) (C:point), (A <> B /\ A <> C /\ B <> C) -> col A B C \/ not_col A B C.
Axiom ax_branch_cop : forall (A:point) (B:point) (C:point) (D:point), (A <> B /\ A <> C /\ A <> D /\ B <> C /\ B <> D /\ C <> D) -> cop A B C D \/ not_cop A B C D.
Axiom ax_branch_cut : forall (B:point) (C:point) (p:line), B <> C -> cut p B C \/ not_cut p B C.
Axiom ax_branch_inc_l_pl : forall (p:line) (beta:plane), inc_l_pl p beta \/ not_inc_l_pl p beta.
Axiom ax_branch_inc_po_l : forall (A:point) (q:line), inc_po_l A q \/ not_inc_po_l A q.
Axiom ax_branch_inc_po_pl : forall (A:point) (beta:plane), inc_po_pl A beta \/ not_inc_po_pl A beta.
Axiom ax_branch_int_l_l : forall (p:line) (q:line), p <> q -> int_l_l p q \/ not_int_l_l p q.
Axiom ax_branch_int_l_pl : forall (p:line) (beta:plane), int_l_pl p beta \/ not_int_l_pl p beta.
Axiom ax_branch_int_pl_pl : forall (alpha:plane) (beta:plane), alpha <> beta -> int_pl_pl alpha beta \/ not_int_pl_pl alpha beta.
Axiom ax_branch_pash : forall (A:point) (B:point) (C:point) (s:line) (beta1:plane), (A <> B /\ A <> C /\ B <> C) -> pash A B C s beta1 \/ not_pash A B C s beta1.
Axiom ax_II4 : forall (A:point) (B:point) (C:point) (s:line) (beta1:plane), pash A B C s beta1 -> cut s C A \/ cut s A B.
Axiom ax_g1 : forall (A:point) (B:point), A = B \/ A <> B.
Axiom ax_g2 : forall (p:line) (q:line), p = q \/ p <> q.
Axiom ax_g3 : forall (alpha:plane) (beta:plane), alpha = beta \/ alpha <> beta.
Axiom ax_cut_2 : forall (p:line) (B:point) (C:point), cut p B C -> exists D:point, (not_inc_po_l B p /\ not_inc_po_l C p /\ inc_po_l D p /\ bet B D C).
Axiom ax_D10 : forall (p:line) (beta:plane), int_l_pl p beta -> exists C:point, (inc_po_l C p /\ inc_po_pl C beta /\ not_inc_l_pl p beta).
Axiom ax_D11a : forall (p:line) (beta:plane), not_inc_l_pl p beta -> exists C:point, (inc_po_l C p /\ not_inc_po_pl C beta).
Axiom ax_D2 : forall (A:point) (B:point) (C:point), col A B C -> exists s:line, (inc_po_l A s /\ inc_po_l B s /\ inc_po_l C s).
Axiom ax_D4 : forall (A:point) (B:point) (C:point) (D:point), cop A B C D -> exists beta1:plane, (inc_po_pl A beta1 /\ inc_po_pl B beta1 /\ inc_po_pl C beta1 /\ inc_po_pl D beta1).
Axiom ax_D6 : forall (p:line) (q:line), int_l_l p q -> exists C:point, (p <> q /\ inc_po_l C p /\ inc_po_l C q).
Axiom ax_D8 : forall (alpha:plane) (beta:plane), int_pl_pl alpha beta -> exists C:point, (alpha <> beta /\ inc_po_pl C alpha /\ inc_po_pl C beta).
Axiom ax_I1 : forall (A:point) (B:point), A <> B -> exists r:line, (inc_po_l A r /\ inc_po_l B r).
Axiom ax_I3a : forall (p:line), exists B:point, exists C:point, (B <> C /\ inc_po_l B p /\ inc_po_l C p).
Axiom ax_I4a : forall (A:point) (B:point) (C:point), not_col A B C -> exists alpha1:plane, (inc_po_pl A alpha1 /\ inc_po_pl B alpha1 /\ inc_po_pl C alpha1).
Axiom ax_I4b : forall (alpha:plane), exists B:point, inc_po_pl B alpha.
Axiom ax_I7 : forall (alpha:plane) (beta:plane) (C:point), (alpha <> beta /\ inc_po_pl C alpha /\ inc_po_pl C beta) -> exists D:point, (C <> D /\ inc_po_pl D alpha /\ inc_po_pl D beta).
Axiom ax_II2 : forall (A:point) (B:point), A <> B -> exists C:point, bet A B C.
Axiom ax_I3b : exists A:point, exists B:point, exists C:point, not_col A B C.
Axiom ax_I8 : exists A:point, exists B:point, exists C:point, exists D:point, not_cop A B C D.

(* Chapter : Hilbert *)

Theorem th_7_01 : forall (A:point) (B:point), A <> B -> exists p:line, exists C:point, (inc_po_l A p /\ inc_po_l B p /\ not_inc_po_l C p).
Proof.
 intros.
 let Hnew := fresh in  assert ( Hnew : exists p, (inc_po_l A p /\ inc_po_l B p)) by applying (ax_I1 A B ) ;destruct Hnew as [p Hnew];decompAnd Hnew.
 let Hnew := fresh in  assert ( Hnew : exists C,  exists D,  exists E, (not_col C D E)) by applying (ax_I3b ) ;destruct Hnew as [C[D[E]] Hnew];decompAnd Hnew.
 assert (inc_po_l C p \/ not_inc_po_l C p) by applying (ax_branch_inc_po_l C p ) .
    by cases on (inc_po_l C p \/ not_inc_po_l C p).
    - { (* Case : inc_po_l C p *)
       assert (inc_po_l D p \/ not_inc_po_l D p) by applying (ax_branch_inc_po_l D p ) .
          by cases on (inc_po_l D p \/ not_inc_po_l D p).
          - { (* Case : inc_po_l D p *)
             assert (inc_po_l E p \/ not_inc_po_l E p) by applying (ax_branch_inc_po_l E p ) .
                by cases on (inc_po_l E p \/ not_inc_po_l E p).
                - { (* Case : inc_po_l E p *)
                   assert (col C D E) by applying (ax_D1 C p D E ) .
                   assert (False) by applying (ax_false_col C D E ) .
                   contradict.
                  }
                - { (* Case : not_inc_po_l E p *)
                   conclude.
                  }
            }
          - { (* Case : not_inc_po_l D p *)
             conclude.
            }
      }
    - { (* Case : not_inc_po_l C p *)
       conclude.
      }
Qed.

Theorem th_7_02 : forall (A:point) (B:point) (p:line) (C:point), (A <> B /\ inc_po_l A p /\ inc_po_l B p /\ not_inc_po_l C p) -> exists D:point, bet B C D.
Proof.
 intros.
 assert (B = C \/ B <> C) by applying (ax_g1 B C ) .
    by cases on (B = C \/ B <> C).
    - { (* Case : B = C *)
       assert (not_inc_po_l B p)  by substitution.
       assert (False) by applying (ax_false_inc_po_l B p ) .
       contradict.
      }
    - { (* Case : B <> C *)
 let Hnew := fresh in  assert ( Hnew : exists G, (bet B C G)) by applying (ax_II2 B C ) ;destruct Hnew as [G Hnew];decompAnd Hnew.
       conclude.
      }
Qed.

Theorem th_7_03 : forall (A:point) (B:point) (p:line) (C:point) (D:point), (A <> B /\ inc_po_l A p /\ inc_po_l B p /\ not_inc_po_l C p /\ bet B C D) -> exists E:point, bet A D E.
Proof.
 intros.
 assert (B <> C /\ B <> D /\ C <> D /\ col B C D /\ bet D C B) by applying (ax_II1 B C D ) .
 assert (col B D C /\ col C B D /\ col C D B /\ col D B C /\ col D C B) by applying (ax_sym_col B C D ) .
 assert (B <> A)  by substitution.
 assert (not_col B A C) by applying (ax_D1a B A p C ) .
 assert (A = D \/ A <> D) by applying (ax_g1 A D ) .
    by cases on (A = D \/ A <> D).
    - { (* Case : A = D *)
       assert (not_col B D C)  by substitution.
       assert (False) by applying (ax_false_col B D C ) .
       contradict.
      }
    - { (* Case : A <> D *)
 let Hnew := fresh in  assert ( Hnew : exists G, (bet A D G)) by applying (ax_II2 A D ) ;destruct Hnew as [G Hnew];decompAnd Hnew.
       conclude.
      }
Qed.

Theorem th_7_04 : forall (A:point) (B:point) (p:line) (C:point) (D:point) (E:point), (A <> B /\ inc_po_l A p /\ inc_po_l B p /\ not_inc_po_l C p /\ bet B C D /\ bet A D E) -> not_col A B D.
Proof.
 intros.
 assert (B <> C /\ B <> D /\ C <> D /\ col B C D /\ bet D C B) by applying (ax_II1 B C D ) .
 assert (col B D C /\ col C B D /\ col C D B /\ col D B C /\ col D C B) by applying (ax_sym_col B C D ) .
 assert (inc_po_l D p \/ not_inc_po_l D p) by applying (ax_branch_inc_po_l D p ) .
    by cases on (inc_po_l D p \/ not_inc_po_l D p).
    - { (* Case : inc_po_l D p *)
       assert (not_col B D C) by applying (ax_D1a B D p C ) .
       assert (False) by applying (ax_false_col B D C ) .
       contradict.
      }
    - { (* Case : not_inc_po_l D p *)
       assert (not_col A B D) by applying (ax_D1a A B p D ) .
       conclude.
      }
Qed.

Theorem th_7_05 : forall (A:point) (B:point) (p:line) (C:point) (D:point) (E:point), (A <> B /\ inc_po_l A p /\ inc_po_l B p /\ not_inc_po_l C p /\ bet B C D /\ bet A D E /\ not_col A B D) -> exists q:line, (inc_po_l E q /\ inc_po_l C q).
Proof.
 intros.
 assert (A = C \/ A <> C) by applying (ax_g1 A C ) .
    by cases on (A = C \/ A <> C).
    - { (* Case : A = C *)
       assert (not_inc_po_l A p)  by substitution.
       assert (False) by applying (ax_false_inc_po_l A p ) .
       contradict.
      }
    - { (* Case : A <> C *)
 let Hnew := fresh in  assert ( Hnew : exists q, (inc_po_l A q /\ inc_po_l C q)) by applying (ax_I1 A C ) ;destruct Hnew as [q Hnew];decompAnd Hnew.
       assert (B = C \/ B <> C) by applying (ax_g1 B C ) .
          by cases on (B = C \/ B <> C).
          - { (* Case : B = C *)
             assert (not_inc_po_l B p)  by substitution.
             assert (False) by applying (ax_false_inc_po_l B p ) .
             contradict.
            }
          - { (* Case : B <> C *)
 let Hnew := fresh in  assert ( Hnew : exists r, (inc_po_l B r /\ inc_po_l C r)) by applying (ax_I1 B C ) ;destruct Hnew as [r Hnew];decompAnd Hnew.
             assert (B = E \/ B <> E) by applying (ax_g1 B E ) .
                by cases on (B = E \/ B <> E).
                - { (* Case : B = E *)
                   assert (inc_po_l E r)  by substitution.
                   conclude.
                  }
                - { (* Case : B <> E *)
                   assert (C = E \/ C <> E) by applying (ax_g1 C E ) .
                      by cases on (C = E \/ C <> E).
                      - { (* Case : C = E *)
                         assert (inc_po_l E q)  by substitution.
                         conclude.
                        }
                      - { (* Case : C <> E *)
 let Hnew := fresh in  assert ( Hnew : exists u, (inc_po_l C u /\ inc_po_l E u)) by applying (ax_I1 C E ) ;destruct Hnew as [u Hnew];decompAnd Hnew.
                         conclude.
                        }
                  }
            }
      }
Qed.

Theorem th_7_06 : forall (A:point) (B:point) (p:line) (C:point) (D:point) (E:point) (q:line), (A <> B /\ inc_po_l A p /\ inc_po_l B p /\ not_inc_po_l C p /\ bet B C D /\ bet A D E /\ not_col A B D /\ inc_po_l E q /\ inc_po_l C q) -> not_inc_po_l A q.
Proof.
 intros.
 assert (A <> D /\ A <> E /\ D <> E /\ col A D E /\ bet E D A) by applying (ax_II1 A D E ) .
 assert (B <> C /\ B <> D /\ C <> D /\ col B C D /\ bet D C B) by applying (ax_II1 B C D ) .
 assert (col A E D /\ col D A E /\ col D E A /\ col E A D /\ col E D A) by applying (ax_sym_col A D E ) .
 assert (col B D C /\ col C B D /\ col C D B /\ col D B C /\ col D C B) by applying (ax_sym_col B C D ) .
 assert (not_col A B C) by applying (ax_D1a A B p C ) .
 assert (inc_po_l A q \/ not_inc_po_l A q) by applying (ax_branch_inc_po_l A q ) .
    by cases on (inc_po_l A q \/ not_inc_po_l A q).
    - { (* Case : inc_po_l A q *)
       assert (inc_po_l B q \/ not_inc_po_l B q) by applying (ax_branch_inc_po_l B q ) .
          by cases on (inc_po_l B q \/ not_inc_po_l B q).
          - { (* Case : inc_po_l B q *)
             assert (col A B C) by applying (ax_D1 A q B C ) .
             assert (False) by applying (ax_false_col A B C ) .
             contradict.
            }
          - { (* Case : not_inc_po_l B q *)
             assert (inc_po_l D q \/ not_inc_po_l D q) by applying (ax_branch_inc_po_l D q ) .
                by cases on (inc_po_l D q \/ not_inc_po_l D q).
                - { (* Case : inc_po_l D q *)
                   assert (not_col C D B) by applying (ax_D1a C D q B ) .
                   assert (False) by applying (ax_false_col C D B ) .
                   contradict.
                  }
                - { (* Case : not_inc_po_l D q *)
                   assert (not_col A E D) by applying (ax_D1a A E q D ) .
                   assert (False) by applying (ax_false_col A E D ) .
                   contradict.
                  }
            }
      }
    - { (* Case : not_inc_po_l A q *)
       conclude.
      }
Qed.

Theorem th_7_07 : forall (A:point) (B:point) (p:line) (C:point) (D:point) (E:point) (q:line), (A <> B /\ inc_po_l A p /\ inc_po_l B p /\ not_inc_po_l C p /\ bet B C D /\ bet A D E /\ not_col A B D /\ inc_po_l E q /\ inc_po_l C q /\ not_inc_po_l A q) -> exists alpha:plane, (inc_po_pl A alpha /\ inc_po_pl B alpha /\ inc_po_pl D alpha).
Proof.
 intros.
 let Hnew := fresh in  assert ( Hnew : exists alpha, (inc_po_pl A alpha /\ inc_po_pl B alpha /\ inc_po_pl D alpha)) by applying (ax_I4a A B D ) ;destruct Hnew as [alpha Hnew];decompAnd Hnew.
 conclude.
Qed.

Theorem th_7_08 : forall (A:point) (B:point) (p:line) (C:point) (D:point) (E:point) (q:line) (alpha:plane), (A <> B /\ inc_po_l A p /\ inc_po_l B p /\ not_inc_po_l C p /\ bet B C D /\ bet A D E /\ not_col A B D /\ inc_po_l E q /\ inc_po_l C q /\ not_inc_po_l A q /\ inc_po_pl A alpha /\ inc_po_pl B alpha /\ inc_po_pl D alpha) -> inc_po_pl C alpha.
Proof.
 intros.
 assert (B <> C /\ B <> D /\ C <> D /\ col B C D /\ bet D C B) by applying (ax_II1 B C D ) .
 let Hnew := fresh in  assert ( Hnew : exists s, (inc_po_l B s /\ inc_po_l C s /\ inc_po_l D s)) by applying (ax_D2 B C D ) ;destruct Hnew as [s Hnew];decompAnd Hnew.
 assert (inc_l_pl s alpha) by applying (ax_I6 B D s alpha ) .
 assert (inc_po_pl C alpha) by applying (ax_D11 s alpha C ) .
 conclude.
Qed.

Theorem th_7_09 : forall (A:point) (B:point) (p:line) (C:point) (D:point) (E:point) (q:line) (alpha:plane), (A <> B /\ inc_po_l A p /\ inc_po_l B p /\ not_inc_po_l C p /\ bet B C D /\ bet A D E /\ not_col A B D /\ inc_po_l E q /\ inc_po_l C q /\ not_inc_po_l A q /\ inc_po_pl A alpha /\ inc_po_pl B alpha /\ inc_po_pl D alpha /\ inc_po_pl C alpha) -> inc_po_pl E alpha.
Proof.
 intros.
 assert (A <> D /\ A <> E /\ D <> E /\ col A D E /\ bet E D A) by applying (ax_II1 A D E ) .
 assert (B <> C /\ B <> D /\ C <> D /\ col B C D /\ bet D C B) by applying (ax_II1 B C D ) .
 assert (col B D C /\ col C B D /\ col C D B /\ col D B C /\ col D C B) by applying (ax_sym_col B C D ) .
 let Hnew := fresh in  assert ( Hnew : exists s, (inc_po_l A s /\ inc_po_l D s)) by applying (ax_I1 A D ) ;destruct Hnew as [s Hnew];decompAnd Hnew.
 assert (inc_l_pl s alpha) by applying (ax_I6 A D s alpha ) .
 assert (inc_po_l B q \/ not_inc_po_l B q) by applying (ax_branch_inc_po_l B q ) .
    by cases on (inc_po_l B q \/ not_inc_po_l B q).
    - { (* Case : inc_po_l B q *)
       assert (inc_l_pl q alpha) by applying (ax_I6 B C q alpha ) .
       assert (inc_po_pl E alpha) by applying (ax_D11 q alpha E ) .
       conclude.
      }
    - { (* Case : not_inc_po_l B q *)
       assert (A = C \/ A <> C) by applying (ax_g1 A C ) .
          by cases on (A = C \/ A <> C).
          - { (* Case : A = C *)
             assert (col A B D)  by substitution.
             assert (False) by applying (ax_false_col A B D ) .
             contradict.
            }
          - { (* Case : A <> C *)
 let Hnew := fresh in  assert ( Hnew : exists r, (inc_po_l A r /\ inc_po_l C r)) by applying (ax_I1 A C ) ;destruct Hnew as [r Hnew];decompAnd Hnew.
             assert (inc_l_pl r alpha) by applying (ax_I6 A C r alpha ) .
             assert (inc_po_l B r \/ not_inc_po_l B r) by applying (ax_branch_inc_po_l B r ) .
                by cases on (inc_po_l B r \/ not_inc_po_l B r).
                - { (* Case : inc_po_l B r *)
                   assert (inc_po_l D r \/ not_inc_po_l D r) by applying (ax_branch_inc_po_l D r ) .
                      by cases on (inc_po_l D r \/ not_inc_po_l D r).
                      - { (* Case : inc_po_l D r *)
                         assert (inc_po_l E r \/ not_inc_po_l E r) by applying (ax_branch_inc_po_l E r ) .
                            by cases on (inc_po_l E r \/ not_inc_po_l E r).
                            - { (* Case : inc_po_l E r *)
                               assert (inc_po_pl E alpha) by applying (ax_D11 r alpha E ) .
                               conclude.
                              }
                            - { (* Case : not_inc_po_l E r *)
                               assert (not_col A D E) by applying (ax_D1a A D r E ) .
                               assert (False) by applying (ax_false_col A D E ) .
                               contradict.
                              }
                        }
                      - { (* Case : not_inc_po_l D r *)
                         assert (not_col B C D) by applying (ax_D1a B C r D ) .
                         assert (False) by applying (ax_false_col B C D ) .
                         contradict.
                        }
                  }
                - { (* Case : not_inc_po_l B r *)
                   assert (inc_po_l E s \/ not_inc_po_l E s) by applying (ax_branch_inc_po_l E s ) .
                      by cases on (inc_po_l E s \/ not_inc_po_l E s).
                      - { (* Case : inc_po_l E s *)
                         assert (inc_po_pl E alpha) by applying (ax_D11 s alpha E ) .
                         conclude.
                        }
                      - { (* Case : not_inc_po_l E s *)
                         assert (not_col A D E) by applying (ax_D1a A D s E ) .
                         assert (False) by applying (ax_false_col A D E ) .
                         contradict.
                        }
                  }
            }
      }
Qed.

Theorem th_7_10 : forall (A:point) (B:point) (r:line) (D:point) (E:point) (F:point) (v:line) (gamma2:plane), (A <> B /\ inc_po_l A r /\ inc_po_l B r /\ not_inc_po_l D r /\ bet B D E /\ bet A E F /\ not_col A B E /\ inc_po_l F v /\ inc_po_l D v /\ not_inc_po_l A v /\ inc_po_pl A gamma2 /\ inc_po_pl B gamma2 /\ inc_po_pl E gamma2 /\ inc_po_pl D gamma2 /\ inc_po_pl F gamma2) -> inc_l_pl v gamma2.
Proof.
Admitted.

Theorem th_7_11 : forall (A:point) (B:point) (r:line) (D:point) (E:point) (F:point) (v:line) (gamma2:plane), (A <> B /\ inc_po_l A r /\ inc_po_l B r /\ not_inc_po_l D r /\ bet B D E /\ bet A E F /\ not_col A B E /\ inc_po_l F v /\ inc_po_l D v /\ not_inc_po_l A v /\ inc_po_pl A gamma2 /\ inc_po_pl B gamma2 /\ inc_po_pl E gamma2 /\ inc_po_pl D gamma2 /\ inc_po_pl F gamma2 /\ inc_l_pl v gamma2) -> not_inc_po_l A v.
Proof.
Admitted.

Theorem th_7_12 : forall (A:point) (B:point) (p:line) (C:point) (D:point) (E:point) (q:line) (alpha:plane), (A <> B /\ inc_po_l A p /\ inc_po_l B p /\ not_inc_po_l C p /\ bet B C D /\ bet A D E /\ not_col A B D /\ inc_po_l E q /\ inc_po_l C q /\ not_inc_po_l A q /\ inc_po_pl A alpha /\ inc_po_pl B alpha /\ inc_po_pl D alpha /\ inc_po_pl C alpha /\ inc_po_pl E alpha /\ inc_l_pl q alpha /\ not_inc_po_l A q) -> not_inc_po_l B q.
Proof.
 intros.
 assert (A <> D /\ A <> E /\ D <> E /\ col A D E /\ bet E D A) by applying (ax_II1 A D E ) .
 assert (B <> C /\ B <> D /\ C <> D /\ col B C D /\ bet D C B) by applying (ax_II1 B C D ) .
 assert (E <> D /\ E <> A /\ D <> A /\ col E D A /\ bet A D E) by applying (ax_II1 E D A ) .
 assert (E <> D)  by substitution.
 assert (inc_po_l B q \/ not_inc_po_l B q) by applying (ax_branch_inc_po_l B q ) .
    by cases on (inc_po_l B q \/ not_inc_po_l B q).
    - { (* Case : inc_po_l B q *)
       assert (inc_po_l D q \/ not_inc_po_l D q) by applying (ax_branch_inc_po_l D q ) .
          by cases on (inc_po_l D q \/ not_inc_po_l D q).
          - { (* Case : inc_po_l D q *)
             assert (not_col E D A) by applying (ax_D1a E D q A ) .
             assert (False) by applying (ax_false_col E D A ) .
             contradict.
            }
          - { (* Case : not_inc_po_l D q *)
             assert (not_col B C D) by applying (ax_D1a B C q D ) .
             assert (False) by applying (ax_false_col B C D ) .
             contradict.
            }
      }
    - { (* Case : not_inc_po_l B q *)
       conclude.
      }
Qed.

Theorem th_7_13 : forall (A:point) (B:point) (p:line) (C:point) (D:point) (E:point) (q:line) (alpha:plane), (A <> B /\ inc_po_l A p /\ inc_po_l B p /\ not_inc_po_l C p /\ bet B C D /\ bet A D E /\ not_col A B D /\ inc_po_l E q /\ inc_po_l C q /\ not_inc_po_l A q /\ inc_po_pl A alpha /\ inc_po_pl B alpha /\ inc_po_pl D alpha /\ inc_po_pl C alpha /\ inc_po_pl E alpha /\ inc_l_pl q alpha /\ not_inc_po_l A q /\ not_inc_po_l B q) -> not_inc_po_l D q.
Proof.
 intros.
 assert (B <> C /\ B <> D /\ C <> D /\ col B C D /\ bet D C B) by applying (ax_II1 B C D ) .
 assert (D <> C /\ D <> B /\ C <> B /\ col D C B /\ bet B C D) by applying (ax_II1 D C B ) .
 assert (D <> C)  by substitution.
 assert (inc_po_l D q \/ not_inc_po_l D q) by applying (ax_branch_inc_po_l D q ) .
    by cases on (inc_po_l D q \/ not_inc_po_l D q).
    - { (* Case : inc_po_l D q *)
       assert (not_col D C B) by applying (ax_D1a D C q B ) .
       assert (False) by applying (ax_false_col D C B ) .
       contradict.
      }
    - { (* Case : not_inc_po_l D q *)
       conclude.
      }
Qed.

Theorem th_7_14 : forall (A:point) (B:point) (p:line) (C:point) (D:point) (E:point) (q:line) (alpha:plane), (A <> B /\ inc_po_l A p /\ inc_po_l B p /\ not_inc_po_l C p /\ bet B C D /\ bet A D E /\ not_col A B D /\ inc_po_l E q /\ inc_po_l C q /\ not_inc_po_l A q /\ inc_po_pl A alpha /\ inc_po_pl B alpha /\ inc_po_pl D alpha /\ inc_po_pl C alpha /\ inc_po_pl E alpha /\ inc_l_pl q alpha /\ not_inc_po_l A q /\ not_inc_po_l B q /\ not_inc_po_l D q) -> cut q B D.
Proof.
 intros.
 assert (cut q B D) by applying (ax_cut_1 B q D C ) .
 conclude.
Qed.

Theorem th_7_15 : forall (A:point) (B:point) (p:line) (C:point) (D:point) (E:point) (q:line) (alpha:plane), (A <> B /\ inc_po_l A p /\ inc_po_l B p /\ not_inc_po_l C p /\ bet B C D /\ bet A D E /\ not_col A B D /\ inc_po_l E q /\ inc_po_l C q /\ not_inc_po_l A q /\ inc_po_pl A alpha /\ inc_po_pl B alpha /\ inc_po_pl D alpha /\ inc_po_pl C alpha /\ inc_po_pl E alpha /\ inc_l_pl q alpha /\ not_inc_po_l A q /\ not_inc_po_l B q /\ not_inc_po_l D q /\ cut q B D) -> exists r:line, (pash A B D q alpha /\ D <> A /\ inc_po_l D r /\ inc_po_l A r).
Proof.
 intros.
 assert (col A B A) by applying (ax_D1 A p B A ) .
 assert (pash A B D q alpha) by applying (ax_pash_1 A B D alpha q ) .
 assert (A = D \/ A <> D) by applying (ax_g1 A D ) .
    by cases on (A = D \/ A <> D).
    - { (* Case : A = D *)
       assert (col A B D)  by substitution.
       assert (False) by applying (ax_false_col A B D ) .
       contradict.
      }
    - { (* Case : A <> D *)
 let Hnew := fresh in  assert ( Hnew : exists r, (inc_po_l A r /\ inc_po_l D r)) by applying (ax_I1 A D ) ;destruct Hnew as [r Hnew];decompAnd Hnew.
       assert (D <> A)  by substitution.
       conclude.
      }
Qed.

Theorem th_7_16 : forall (A:point) (B:point) (r:line) (D:point) (E:point) (F:point) (v:line) (gamma2:plane) (q1:line), (A <> B /\ inc_po_l A r /\ inc_po_l B r /\ not_inc_po_l D r /\ bet B D E /\ bet A E F /\ not_col A B E /\ inc_po_l F v /\ inc_po_l D v /\ not_inc_po_l A v /\ inc_po_pl A gamma2 /\ inc_po_pl B gamma2 /\ inc_po_pl E gamma2 /\ inc_po_pl D gamma2 /\ inc_po_pl F gamma2 /\ inc_l_pl v gamma2 /\ not_inc_po_l A v /\ not_inc_po_l B v /\ not_inc_po_l E v /\ cut v B E /\ pash A B E v gamma2 /\ E <> A /\ inc_po_l E q1 /\ inc_po_l A q1) -> exists K:point, bet A K B.
Proof.
Admitted.

