theory KRKFunction
imports KRKStrategy KRKStrategyCorrectness
begin

(* ************************************************************************** *)
text{* Search trough all legal moves of a piece *}
(* ************************************************************************** *)

definition first_legal_move_WK where
  "first_legal_move_WK p P = first8 (\<lambda> i. let sq = kings_square (WK p) i in KRK.WK_can_move_to p sq \<and> P (moveWK p sq))"

definition first_legal_move_WR where
  "first_legal_move_WR p P = first_n (nat (files + ranks)) (\<lambda> i. let sq = rooks_square (WR p) i in KRK.WR_can_move_to p sq \<and> P (moveWR p sq))"

definition first_legal_move_white where 
  "first_legal_move_white p P = 
     (let ik = first_legal_move_WK p P
       in if ik > 0 then ik
          else let ir = first_legal_move_WR p P 
                in if ir > 0 then ir + 8 
                   else 0)"

lemma first_legal_move_WK_le[simp]: "first_legal_move_WK p P \<le> 8"
unfolding Let_def
by (auto simp add: first_legal_move_WK_def first8_def)

lemma first_legal_move_WK_P:
  assumes "first_legal_move_WK p P > 0"
  shows "P (move_white p (first_legal_move_WK p P))"
using assms first8[of "(\<lambda>i. let sq = kings_square (WK p) i in KRK.WK_can_move_to p sq \<and> P (moveWK p sq))"]
unfolding first_legal_move_WK_def
by (simp add: Let_def move_white_def)

lemma first_legal_move_WK_4:
  assumes "first_legal_move_WK p P > 4"
  shows "P (move_white p (first_legal_move_WK p P))" "all4 (\<lambda>x. let sq = kings_square (WK p) x in KRK.WK_can_move_to p sq \<longrightarrow> \<not> P (moveWK p sq))"
using assms first8[of "(\<lambda>i. let sq = kings_square (WK p) i in KRK.WK_can_move_to p sq \<and> P (moveWK p sq))"] first8_ge4[of "(\<lambda>i. let sq = kings_square (WK p) i in KRK.WK_can_move_to p sq \<and> P (moveWK p sq))"]
unfolding first_legal_move_WK_def
by (simp_all add: Let_def move_white_def)

lemma first_legal_move_WK_4':
  assumes "\<not> first_legal_move_WK p P \<le> 4" "WK p = (x, y)"
  shows "\<forall> sq. (KRK.WK_can_move_to p sq \<and> P (moveWK p sq)) \<longrightarrow> sq = (x + 1, y) \<or> sq = (x - 1, y) \<or> sq = (x, y - 1) \<or> sq = (x, y + 1)"
proof (rule allI, rule impI)
  fix sq :: "int \<times> int"
  obtain sqx sqy where "sq = (sqx, sqy)"
    by (cases sq)
  assume "KRK.WK_can_move_to p sq \<and> P (moveWK p sq)"
  thus "sq = (x + 1, y) \<or> sq = (x - 1, y) \<or> sq = (x, y - 1) \<or> sq = (x, y + 1)"
    using assms `sq = (sqx, sqy)` ex_king_scope[of x y "\<lambda> (x, y). sqx = x \<and> sqy = y"]
    unfolding first_legal_move_WK_def Let_def first8_def
    by (force split: split_if_asm simp add: kings_square_def KRK.WK_can_move_to_def)
qed

lemma first_legal_move_WK_4'':
  assumes "first_legal_move_WK p P > 0" "first_legal_move_WK p P \<le> 4" "WK p = (x, y)"
  shows "let sq = kings_square (WK p) (first_legal_move_WK p P) in sq = (x + 1, y + 1) \<or> sq = (x - 1, y - 1) \<or> sq = (x + 1, y - 1) \<or> sq = (x - 1, y + 1)"
proof-
  let ?sq = "kings_square (WK p) (first_legal_move_WK p P) "
  obtain sqx sqy where "?sq = (sqx, sqy)"
    by (cases ?sq)
  thus ?thesis
    using assms ex_king_scope[of x y "\<lambda> (x, y). sqx = x \<and> sqy = y"]
    unfolding first_legal_move_WK_def Let_def first8_def
    by (simp split: split_if_asm add: kings_square_def Let_def)
qed

lemma first_legal_move_WK_WK_can_move_to:
  assumes "first_legal_move_WK p P > 0" 
  shows "KRK.WK_can_move_to p (kings_square (WK p) (first_legal_move_WK p P))"
using assms first8[of "(\<lambda>i. let sq = kings_square (WK p) i in KRK.WK_can_move_to p sq \<and> P (moveWK p sq))"]
by (simp add: first_legal_move_WK_def Let_def)

lemma first_legal_move_WK_legal_move:
  assumes "first_legal_move_WK p P > 0" "legal_position p" "WhiteOnTurn p"
  shows "KRK.legal_move_WK p (move_white p (first_legal_move_WK p P))"
using assms first8[of "(\<lambda>i. let sq = kings_square (WK p) i in KRK.WK_can_move_to p sq \<and> P (moveWK p sq))"]
by (simp add: move_white_def first_legal_move_WK_def Let_def KRK.WK_can_move_to)

lemma first_legal_move_WK_legal_position:
  assumes "first_legal_move_WK p P > 0" "legal_position p" "WhiteOnTurn p"
  shows "legal_position (move_white p (first_legal_move_WK p P))"
using first_legal_move_WK_legal_move[OF assms]
by (simp add: KRK.legal_move_WK_def)

lemma first_legal_move_WK_zero:
  assumes "\<not> first_legal_move_WK p P > 0"
  shows "all8 (\<lambda>x. let sq = kings_square (WK p) x in KRK.WK_can_move_to p sq \<longrightarrow> \<not> P (moveWK p sq))"
using assms
unfolding first_legal_move_WK_def
by (simp add: first8_zero Let_def)

lemma first_legal_move_WR_le[simp]: "first_legal_move_WR p P \<le> files + ranks"
unfolding first_legal_move_WR_def
using first_n_le[of "nat (files + ranks)"] files_ranks_geq6
by auto

lemma first_legal_move_WR_P:
  assumes "first_legal_move_WR p P > 0"
  shows "P (move_white p ((first_legal_move_WR p P) + 8))"
using assms first_n[of "nat (files + ranks)"] first_n_le[of "nat (files + ranks)"] files_ranks_geq6
unfolding first_legal_move_WR_def
by (auto simp add: Let_def move_white_def)

lemma first_legal_move_WR_legal_move:
  assumes "first_legal_move_WR p P > 0" "legal_position p" "WhiteOnTurn p" "\<not> WRcaptured p"
  shows "KRK.legal_move_WR p (move_white p ((first_legal_move_WR p P) + 8))"
using assms first_n[of "nat (files + ranks)"]  first_n_le[of "nat (files + ranks)"] files_ranks_geq6
by (auto simp add: move_white_def first_legal_move_WR_def KRK.WR_can_move_to Let_def)
 
lemma first_legal_move_WR_legal_position:
  assumes "first_legal_move_WR p P > 0" "legal_position p" "WhiteOnTurn p" "\<not> WRcaptured p"
  shows "legal_position (move_white p ((first_legal_move_WR p P) + 8))"
using first_legal_move_WR_legal_move[OF assms]
by (simp add: KRK.legal_move_WR_def)

lemma first_legal_move_WR_zero:
  assumes "\<not> first_legal_move_WR p P > 0"
  shows "all_n (files + ranks) (\<lambda>x. let sq = rooks_square (WR p) x in KRK.WR_can_move_to p sq \<longrightarrow> \<not> P (moveWR p sq))"
using assms first_n_zero[of "nat (files + ranks)"]
unfolding first_legal_move_WR_def
by (auto simp add: Let_def all_n_def)

lemma first_legal_move_white_P:
  assumes "first_legal_move_white p P > 0"
  shows "P (move_white p (first_legal_move_white p P))"
using assms
using first_legal_move_WK_P first_legal_move_WR_P
unfolding first_legal_move_white_def
by (auto simp add: Let_def)

lemma first_legal_move_white_legal_move:
  assumes "first_legal_move_white p P > 0" "legal_position p" "WhiteOnTurn p" "\<not> WRcaptured p"
  shows "KRK.legal_move_WK p (move_white p (first_legal_move_white p P)) \<or> KRK.legal_move_WR p (move_white p (first_legal_move_white p P))"
using assms first_legal_move_WK_legal_move first_legal_move_WR_legal_move
unfolding first_legal_move_white_def
by (auto simp add: Let_def)

lemma first_legal_move_white_legal_position:
  assumes "first_legal_move_white p P > 0" "legal_position p" "WhiteOnTurn p" "\<not> WRcaptured p"
  shows "legal_position (move_white p (first_legal_move_white p P))"
using assms first_legal_move_WK_legal_position first_legal_move_WR_legal_position
unfolding first_legal_move_white_def
by (auto simp add: Let_def)

lemma first_legal_move_white_zero:
  assumes "\<not> first_legal_move_white p P > 0"
  shows "all8 (\<lambda>x. let sq = kings_square (WK p) x in KRK.WK_can_move_to p sq \<longrightarrow> \<not> P (moveWK p sq)) \<and> 
         all_n (files + ranks) (\<lambda>x. let sq = rooks_square (WR p) x in KRK.WR_can_move_to p sq \<longrightarrow> \<not> P (moveWR p sq))"
using assms first_legal_move_WR_zero first_legal_move_WK_zero 
unfolding first_legal_move_white_def
by (simp add: Let_def split: split_if_asm)

lemma first_legal_move_white_le[simp]: "first_legal_move_white p P \<le> 8 + files + ranks"
using first_n_le[of "nat (files + ranks)"] files_ranks_geq6
unfolding first_legal_move_white_def Let_def
by (auto simp add: first_legal_move_WK_def first_legal_move_WR_def) (smt first8_le)

definition min_legal_move_WR where
  "min_legal_move_WR p P = min_n (files + ranks) (\<lambda> i. let sq = rooks_square (WR p) i; (b, v) = P (moveWR p sq) in (KRK.WR_can_move_to p sq \<and> b, v))"

lemma [simp]: "min_legal_move_WR p P \<le> files + ranks"
by (simp add: min_legal_move_WR_def)

lemma min_legal_move_WR_P:
  assumes "min_legal_move_WR p P > 0"
  shows "let (b, v) = P (move_white p ((min_legal_move_WR p P) + 8)) in b"
  using assms
  by (simp add: move_white_def split_def min_legal_move_WR_def) (subst (asm) min_n_pos, simp add: Let_def split_def)

lemma min_legal_move_WR_zero:
  assumes "\<not> (min_legal_move_WR p P > 0)"
  shows "all_n (files + ranks) (\<lambda>x. let sq = rooks_square (WR p) x; (b, v) = P (moveWR p sq) in KRK.WR_can_move_to p sq \<longrightarrow> \<not> b)"
using assms
unfolding min_legal_move_WR_def
by (subst (asm) min_n_zero) (simp add: Let_def split_def)

lemma min_legal_move_WR_legal_move:
  assumes "min_legal_move_WR p P > 0" "legal_position p" "WhiteOnTurn p" "\<not> WRcaptured p"
  shows "KRK.legal_move_WR p (move_white p ((min_legal_move_WR p P) + 8))"
using assms min_n_pos[of "files + ranks" "(\<lambda>i. let sq = rooks_square (WR p) i; (b, y) = P (moveWR p sq)
            in (KRK.WR_can_move_to p sq \<and> b, y))"] KRK.WR_can_move_to[of p]
unfolding min_legal_move_WR_def
by (simp add: Let_def split_def move_white_def)

lemma min_legal_move_WR_legal_position:
  assumes "min_legal_move_WR p P > 0" "legal_position p" "WhiteOnTurn p" "\<not> WRcaptured p"
  shows "legal_position (move_white p ((min_legal_move_WR p P) + 8))"
using min_legal_move_WR_legal_move[OF assms]
by (simp add: KRK.legal_move_WR_def)


(* ************************************************************************** *)
text{* Strategy function definition *}
(* ************************************************************************** *)

definition strategy_white_move :: "KRKPosition \<Rightarrow> KRKPosition \<times> MoveType" where
 "strategy_white_move p = 
   (let i = first_legal_move_WR p immediate_mate_cond
     in if i > 0 then (move_white p (i+8), ImmediateMateMove)
    else let i = first_legal_move_white p ready_to_mate_cond
     in if i > 0 then (move_white p i, ReadyToMateMove)
    else let i = min_legal_move_WR p (KRKStrategy.squeeze_cond p)
     in if i > 0 then (move_white p (i+8), SqueezeMove)
    else let i = first_legal_move_WK p (KRKStrategy.approach_cond p)
     in if i > 0 then (move_white p i, (if i \<le> 4 then ApproachDiagMove else ApproachNonDiagMove))
    else let i = first_legal_move_WK p (KRKStrategy.keep_room_cond p)
     in if i > 0 then (move_white p i, (if i \<le> 4 then KeepRoomDiagMove else KeepRoomNonDiagMove))
    else let i = first_legal_move_WR p (KRKStrategy.rook_home_cond p)
     in if i > 0 then (move_white p (i + 8), RookHomeMove)
    else let i = first_legal_move_WR p (KRKStrategy.rook_safe_cond p)
     in if i > 0 then (move_white p (i + 8), RookSafeMove)
    else (p, ErrorMove))"

(* ---------------------------------------------------------------- *)
lemma strategy_moves:
  assumes "(p1, t1) = strategy_white_move p0"
  shows "t1 = ImmediateMateMove \<or> t1 = ReadyToMateMove \<or> t1 = SqueezeMove \<or> t1 = ApproachDiagMove \<or> t1 = ApproachNonDiagMove \<or> t1 = KeepRoomDiagMove \<or> t1 = KeepRoomNonDiagMove \<or> t1 = RookHomeMove \<or> t1 = RookSafeMove \<or> t1 = ErrorMove"
using assms
by (simp add: strategy_white_move_def Let_def split: split_if_asm)

(* --------------------------------------------------------- *)
text{* No ErrorMove *}
(* --------------------------------------------------------- *)

(* --------------------------------------------------------- *)
theorem strategy_white_move_no_error: 
  assumes "(p1, t1) = strategy_white_move p0" "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0"
  shows "t1 \<noteq> ErrorMove"
(* --------------------------------------------------------- *)
using assms 
unfolding strategy_white_move_def
using first_legal_move_WR_zero[of p0 "KRKStrategy.rook_safe_cond p0"] first_legal_move_WR_zero[of p0 "KRKStrategy.rook_home_cond p0"]
using min_legal_move_WR_zero[of p0 "KRKStrategy.squeeze_cond p0"] NoSqueezeRookHomeOrRookSafe[of p0]
by (auto simp add: Let_def split_def KRKStrategy.no_squeeze_def KRKStrategy.no_rook_safe_def KRKStrategy.no_rook_home_def split: split_if_asm)

(* --------------------------------------------------------- *)
text{* Strategy moves are always legal *}
(* --------------------------------------------------------- *)

(* --------------------------------------------------------- *)
theorem strategy_white_move_legal_move:
  assumes p0: "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0" and
              "(p1, t1) = strategy_white_move p0" 
  shows "KRK.legal_move_WK p0 p1 \<or> KRK.legal_move_WR p0 p1"
(* --------------------------------------------------------- *)
using assms strategy_white_move_no_error[of p1 t1 p0]
using first_legal_move_WK_legal_move first_legal_move_WR_legal_move first_legal_move_white_legal_move min_legal_move_WR_legal_move
by (simp add: strategy_white_move_def Let_def split: split_if_asm)

(* --------------------------------------------------------- *)
theorem strategy_white_move_legal_position:
  assumes "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0" "(p1, t1) = strategy_white_move p0"  
  shows "legal_position p1"
(* --------------------------------------------------------- *)
using strategy_white_move_legal_move[OF assms]
unfolding KRK.legal_move_WK_def KRK.legal_move_WR_def
by auto

(* --------------------------------------------------------- *)
text{* Postconditions *}
(* --------------------------------------------------------- *)

lemma ImmediateMateMove_postcond:
  assumes "strategy_white_move p0 = (p1, ImmediateMateMove)" "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0"
  shows "immediate_mate_cond p1" "KRK.legal_move_WR p0 p1"
using assms first_legal_move_WR_P[of p0 immediate_mate_cond] first_legal_move_WR_legal_move[of p0 immediate_mate_cond]
unfolding strategy_white_move_def Let_def
by (simp_all split: split_if_asm)

lemma notImmediateMateMove:
  assumes "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0" "(p1, t1) = strategy_white_move p0" "t1 \<noteq> ImmediateMateMove"
  shows "KRKStrategy.no_immediate_mate p0"
using assms WK_cannot_mate[of p0] first_legal_move_WR_zero[of p0 immediate_mate_cond]
by (simp add: KRKStrategy.no_immediate_mate_WR_def strategy_white_move_def Let_def split: split_if_asm)

lemma ReadyToMateMove_postcond:
  assumes "strategy_white_move p0 = (p1, ReadyToMateMove)" "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0"
  shows "KRKStrategy.ready_to_mate_cond p1" "KRK.legal_move_WK p0 p1 \<or> KRK.legal_move_WR p0 p1"
using assms first_legal_move_white_P[of p0 ready_to_mate_cond] first_legal_move_white_legal_move[of p0 ready_to_mate_cond]
unfolding strategy_white_move_def Let_def
by (simp_all split: split_if_asm)

lemma notReadyToMateMove:
  assumes "strategy_white_move p0 = (p1, t1)" "t1 \<noteq> ImmediateMateMove" "t1 \<noteq> ReadyToMateMove"
  shows "KRKStrategy.no_ready_to_mate_WK p0 \<and> KRKStrategy.no_ready_to_mate_WR p0"
using assms first_legal_move_white_zero[of p0 ready_to_mate_cond]
by (simp add: KRKStrategy.no_ready_to_mate_WK_def KRKStrategy.no_ready_to_mate_WR_def strategy_white_move_def Let_def split: split_if_asm)

lemma SqueezeMove_postcond:
  assumes "strategy_white_move p0 = (p1, SqueezeMove)" "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0"
  shows "let (b, v) = KRKStrategy.squeeze_cond p0 p1 in b" "KRK.legal_move_WR p0 p1"
using assms min_legal_move_WR_P[of p0 "KRKStrategy.squeeze_cond p0"] min_legal_move_WR_legal_move[of p0 "KRKStrategy.squeeze_cond p0"]
unfolding strategy_white_move_def Let_def
by (simp_all split: split_if_asm add: move_white_def rooks_square_def split_def Let_def)

lemma notSqueezeMove:
  assumes "strategy_white_move p0 = (p1, t1)" "t1 \<noteq> ImmediateMateMove" "t1 \<noteq> ReadyToMateMove" "t1 \<noteq> SqueezeMove"
  shows "KRKStrategy.no_squeeze p0"
using assms min_legal_move_WR_zero[of p0 "KRKStrategy.squeeze_cond p0"]
by (simp add: strategy_white_move_def KRKStrategy.no_squeeze_def Let_def split_def split: split_if_asm)

lemma ApproachDiagMove_postcond:
  assumes "strategy_white_move p0 = (p1, ApproachDiagMove)" "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0"
  shows "KRKStrategy.approach_cond p0 p1" "KRK.legal_move_WK p0 p1"
using assms first_legal_move_WK_P[of p0 "KRKStrategy.approach_cond p0"] first_legal_move_WK_legal_move[of p0 "KRKStrategy.approach_cond p0"]
unfolding strategy_white_move_def Let_def
by (simp_all split: split_if_asm)

lemma notApproachDiagMove:
  assumes "strategy_white_move p0 = (p1, t1)" "t1 \<noteq> ImmediateMateMove" "t1 \<noteq> ReadyToMateMove" "t1 \<noteq> SqueezeMove" "t1 \<noteq> ApproachDiagMove"
  shows "KRKStrategy.no_approach_diag p0"
using assms first_legal_move_WK_4[of p0 "KRKStrategy.approach_cond p0"]  first_legal_move_WK_zero[of p0 "KRKStrategy.approach_cond p0"]
unfolding strategy_white_move_def Let_def
by (simp split: split_if_asm add: KRKStrategy.no_approach_diag_def all8_def all4_def)

lemma ApproachNonDiagMove_postcond:
  assumes "strategy_white_move p0 = (p1, ApproachNonDiagMove)" "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0"
  shows "KRKStrategy.approach_cond p0 p1" "KRK.legal_move_WK p0 p1"
using assms first_legal_move_WK_P[of p0 "KRKStrategy.approach_cond p0"] first_legal_move_WK_legal_move[of p0 "KRKStrategy.approach_cond p0"]
unfolding strategy_white_move_def Let_def
by (simp_all split: split_if_asm)

lemma notApproachNonDiagMove:
  assumes "strategy_white_move p0 = (p1, t1)" "t1 \<noteq> ImmediateMateMove" "t1 \<noteq> ReadyToMateMove" "t1 \<noteq> SqueezeMove" "t1 \<noteq> ApproachDiagMove" "t1 \<noteq> ApproachNonDiagMove"
  shows "KRKStrategy.no_approach p0"
using assms first_legal_move_WK_zero[of p0 "KRKStrategy.approach_cond p0"]
unfolding strategy_white_move_def KRKStrategy.no_approach_def Let_def
by (simp split: split_if_asm)

lemma KeepRoomDiagMove_postcond:
  assumes "strategy_white_move p0 = (p1, KeepRoomDiagMove)" "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0"
  shows "KRKStrategy.keep_room_cond p0 p1" "KRK.legal_move_WK p0 p1"
using assms first_legal_move_WK_P[of p0 "KRKStrategy.keep_room_cond p0"] first_legal_move_WK_legal_move[of p0 "KRKStrategy.keep_room_cond p0"]
unfolding strategy_white_move_def Let_def
by (simp_all split: split_if_asm)

lemma notKeepRoomDiagMove:
  assumes "strategy_white_move p0 = (p1, t1)" "t1 \<noteq> ImmediateMateMove" "t1 \<noteq> ReadyToMateMove" "t1 \<noteq> SqueezeMove" "t1 \<noteq> ApproachDiagMove" "t1 \<noteq> ApproachNonDiagMove" "t1 \<noteq> KeepRoomDiagMove"
  shows "KRKStrategy.no_keep_room_diag p0"
using assms first_legal_move_WK_4[of p0 "KRKStrategy.keep_room_cond p0"]  first_legal_move_WK_zero[of p0 "KRKStrategy.keep_room_cond p0"]
unfolding strategy_white_move_def Let_def
by (simp split: split_if_asm add: KRKStrategy.no_keep_room_diag_def all8_def all4_def)

lemma KeepRoomNonDiagMove_postcond:
  assumes "strategy_white_move p0 = (p1, KeepRoomNonDiagMove)" "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0"
  shows "KRKStrategy.keep_room_cond p0 p1" "KRK.legal_move_WK p0 p1"
using assms first_legal_move_WK_P[of p0 "KRKStrategy.keep_room_cond p0"] first_legal_move_WK_legal_move[of p0 "KRKStrategy.keep_room_cond p0"]
unfolding strategy_white_move_def Let_def
by (simp_all split: split_if_asm)

lemma notKeepRoomNonDiagMove:
  assumes "strategy_white_move p0 = (p1, t1)" "t1 \<noteq> ImmediateMateMove" "t1 \<noteq> ReadyToMateMove" "t1 \<noteq> SqueezeMove" "t1 \<noteq> ApproachDiagMove" "t1 \<noteq> ApproachNonDiagMove" "t1 \<noteq> KeepRoomDiagMove" "t1 \<noteq> KeepRoomNonDiagMove"
  shows "KRKStrategy.no_keep_room p0"
using assms first_legal_move_WK_zero[of p0 "KRKStrategy.keep_room_cond p0"] first_legal_move_WK_zero[of p0 "KRKStrategy.keep_room_cond p0"]
unfolding KRKStrategy.no_keep_room_def strategy_white_move_def Let_def
by (simp split: split_if_asm)

lemma RookHomeMove_postcond:
  assumes "strategy_white_move p0 = (p1, RookHomeMove)" "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0"
  shows "KRKStrategy.rook_home_cond p0 p1" "KRK.legal_move_WR p0 p1"
using assms first_legal_move_WR_P[of p0 "KRKStrategy.rook_home_cond p0"]  first_legal_move_WR_legal_move[of p0 "KRKStrategy.rook_home_cond p0"]
unfolding strategy_white_move_def Let_def
by (simp_all split: split_if_asm)

lemma notRookHomeMove:
  assumes "strategy_white_move p0 = (p1, t1)" "t1 \<noteq> ImmediateMateMove" "t1 \<noteq> ReadyToMateMove" "t1 \<noteq> SqueezeMove" "t1 \<noteq> ApproachDiagMove" "t1 \<noteq> ApproachNonDiagMove" "t1 \<noteq> KeepRoomDiagMove" "t1 \<noteq> RookHomeMove" "t1 \<noteq> KeepRoomNonDiagMove"
  shows "KRKStrategy.no_rook_home p0"
using assms first_legal_move_WR_zero[of p0 "KRKStrategy.rook_home_cond p0"]
unfolding KRKStrategy.no_rook_home_def strategy_white_move_def Let_def
by (simp split: split_if_asm)

lemma RookSafeMove_postcond:
  assumes "strategy_white_move p0 = (p1, RookSafeMove)" "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0"
  shows "KRKStrategy.rook_safe_cond p0 p1" "KRK.legal_move_WR p0 p1"
using assms first_legal_move_WR_P[of p0 "KRKStrategy.rook_safe_cond p0"] first_legal_move_WR_legal_move[of p0 "KRKStrategy.rook_safe_cond p0"]
unfolding strategy_white_move_def Let_def
by (simp_all split: split_if_asm)

lemmas postcond = ImmediateMateMove_postcond ReadyToMateMove_postcond SqueezeMove_postcond ApproachDiagMove_postcond ApproachNonDiagMove_postcond KeepRoomDiagMove_postcond KeepRoomNonDiagMove_postcond RookHomeMove_postcond RookSafeMove_postcond

lemma ApproachDiagMove_diagmove:
  assumes "(p1, ApproachDiagMove) = strategy_white_move p0"
  shows "same_diag (WK p0) (WK p1)"
proof-
  obtain WKx0 WKy0 WKx1 WKy1 where "WK p0 = (WKx0, WKy0)"  "WK p1 = (WKx1, WKy1)"
    by (cases "WK p0", cases "WK p1")
  thus ?thesis
    using assms
    unfolding strategy_white_move_def
    using first_legal_move_WK_4''[of p0 "KRKStrategy.approach_cond p0" WKx0 WKy0] 
      first_legal_move_WK_4(1)[of p0 "KRKStrategy.approach_cond p0"] first_legal_move_WK_WK_can_move_to[of p0 "KRKStrategy.approach_cond p0"]
    by (auto simp add: Let_def move_white_def same_diag_def same_diag1_def same_diag2_def split: split_if_asm )
qed

lemma KeepRoomDiagMove_diagmove:
  assumes "(p1, KeepRoomDiagMove) = strategy_white_move p0"
  shows "same_diag (WK p0) (WK p1)"
proof-
  obtain WKx0 WKy0 WKx1 WKy1 where "WK p0 = (WKx0, WKy0)"  "WK p1 = (WKx1, WKy1)"
    by (cases "WK p0", cases "WK p1")
  thus ?thesis
    using assms
    unfolding strategy_white_move_def
    using first_legal_move_WK_4''[of p0 "KRKStrategy.keep_room_cond p0" WKx0 WKy0] 
      first_legal_move_WK_4(1)[of p0 "KRKStrategy.keep_room_cond p0"] first_legal_move_WK_WK_can_move_to[of p0 "KRKStrategy.keep_room_cond p0"]
    by (auto simp add: Let_def move_white_def same_diag_def same_diag1_def same_diag2_def split: split_if_asm )
qed

lemma KeepRoomNonDiagMove_nondiagmove:
  assumes "WK p0 = (WKx0, WKy0)" "WK p1 = (WKx1, WKy1)"
  "(p1, KeepRoomNonDiagMove) = strategy_white_move p0"
  shows "WKx0 = WKx1 \<or> WKy0 = WKy1"
using assms
unfolding strategy_white_move_def
using first_legal_move_WK_4'[of p0 "KRKStrategy.keep_room_cond p0" WKx0 WKy0] first_legal_move_WK_4(1)[of p0 "KRKStrategy.keep_room_cond p0"] first_legal_move_WK_WK_can_move_to[of p0 "KRKStrategy.keep_room_cond p0"]
by (auto simp add: Let_def move_white_def split: split_if_asm )

lemma ApproachNonDiagMove_nondiagmove:
  assumes "WK p0 = (WKx0, WKy0)" "WK p1 = (WKx1, WKy1)"
  "(p1, ApproachNonDiagMove) = strategy_white_move p0"
  shows "WKx0 = WKx1 \<or> WKy0 = WKy1"
using assms
unfolding strategy_white_move_def
using first_legal_move_WK_4'[of p0 "KRKStrategy.approach_cond p0" WKx0 WKy0] first_legal_move_WK_4(1)[of p0 "KRKStrategy.approach_cond p0"] first_legal_move_WK_WK_can_move_to[of p0 "KRKStrategy.approach_cond p0"]
by (auto simp add: Let_def move_white_def split: split_if_asm )


(* ---------------------------------------------------------- *)

theorem strategy_white_move_strategy_white_move_rel:
  assumes p: "WhiteOnTurn p" "\<not> WRcaptured p" "legal_position p"
  assumes m: "(p', t) = strategy_white_move p"
  shows "strategy_white_move_rel p p' t"
  using strategy_moves[OF m] assms strategy_white_move_no_error[OF m p]
  using postcond[OF _ p, of p']
  using notImmediateMateMove[OF p m]
  using notReadyToMateMove[OF m[symmetric]]
  using notSqueezeMove[OF m[symmetric]]
  using notApproachDiagMove[OF m[symmetric]]
  using notApproachNonDiagMove[OF m[symmetric]]
  using notKeepRoomDiagMove[OF m[symmetric]]
  using notKeepRoomNonDiagMove[OF m[symmetric]]
  using notRookHomeMove[OF m[symmetric]]
  using ApproachDiagMove_diagmove[of p' p]
  using KeepRoomDiagMove_diagmove[of p' p]
  apply (cases "KRKStrategy.squeeze_cond p p'")
  apply (simp add: strategy_white_move_rel_def)
  apply (erule disjE, force simp add: legal_move_white_def no_ready_to_mate_def)+
  apply (simp add: no_ready_to_mate_def)
  done

end
