theory KRKStrategyCorrectness
imports KRKStrategy KRKSymmetry LIA
begin

(* ------------------------------------------------------- *)
declare [[ smt_oracle = false ]]
declare [[ smt_timeout = 2400 ]]
declare [[ smt_trace = false ]]

abbreviation legal_move_WK where "legal_move_WK \<equiv> KRK.legal_move_WK"
abbreviation legal_move_BK where "legal_move_BK \<equiv> KRK.legal_move_BK"
abbreviation legal_move_WR where "legal_move_WR \<equiv> KRK.legal_move_WR"
abbreviation WK_can_move_to where "WK_can_move_to \<equiv> KRK.WK_can_move_to"
abbreviation room where "room \<equiv> KRKStrategy.room"
abbreviation mdcs where "mdcs \<equiv> KRKStrategy.mdcs"

(* ---------------------------------------------------------------------------- *)
text{* Interesting fact: WK cannot mate *}
(* ---------------------------------------------------------------------------- *)
lemma WK_cannot_mate'_sym: 
  "\<forall> p. (\<forall> sq. \<not> WRcaptured p \<and> WhiteOnTurn p \<and> legal_position p \<and> WK_can_move_to p sq \<longrightarrow> \<not> immediate_mate_cond (moveWK p sq))" (is "\<forall> p. ?P p")
proof (rule symmetry)
  show "\<forall>p. ?P (reflectx_p p) \<longrightarrow> ?P p"
    by (rule allI, rule impI, rule allI, erule_tac x="reflectx sq" in allE, simp)
  show "\<forall>p. ?P (reflecty_p p) \<longrightarrow> ?P p"
    by (rule allI, rule impI, rule allI, erule_tac x="reflecty sq" in allE, simp)
  show "\<forall>p. ?P (reflectdiag_p p) \<longrightarrow> ?P p"
    by (rule allI, rule impI, rule allI, erule_tac x="reflectdiag sq" in allE, simp add: files_eq_ranks)
  show "files = ranks"
    by (rule files_eq_ranks)

  show "\<forall>p. Symmetry.is_canon p \<longrightarrow> ?P p"
  proof safe
    fix p sqx sqy 
    assume ass: "Symmetry.is_canon p" "\<not> WRcaptured p" "WhiteOnTurn p" "legal_position p" "WK_can_move_to p (sqx, sqy)" "immediate_mate_cond (moveWK p (sqx, sqy))"

    obtain WKx WKy BKx BKy WRx WRy where *: "WK p = (WKx, WKy)" "BK p = (BKx, BKy)" "WR p = (WRx, WRy)" 
      by (cases "WK p", cases "BK p", cases "WR p")

    have "LIA.checkmated_optimized sqx sqy BKx BKy WRx WRy"
      using `immediate_mate_cond (moveWK p (sqx, sqy))`
      using LIA.not_checkmated[of "moveWK p (sqx, sqy)" sqx sqy BKx BKy WRx WRy] * `\<not> WRcaptured p` files_ranks_geq6
      using `WhiteOnTurn p` `WK_can_move_to p (sqx, sqy)` `legal_position p`
      unfolding immediate_mate_cond_def checkmated_def
      by simp (metis KRK.WK_can_move_to legal_move_WK_def')
    moreover
    have "LIA.WK_can_move_to WKx WKy BKx BKy WRx WRy sqx sqy"
      using LIA.WK_can_move_to[OF *(1-3) `WhiteOnTurn p` `\<not> WRcaptured p`, of sqx sqy] `WK_can_move_to p (sqx, sqy)`
      by auto
    moreover
    have "LIA.legal_position_white_on_turn WKx WKy BKx BKy WRx WRy"
      using legal_position_white_on_turn[OF * `WhiteOnTurn p` `\<not> WRcaptured p`] `legal_position p`
      by auto
    moreover
    have "LIA.is_canon WKx WKy BKx BKy WRx WRy"
      using `Symmetry.is_canon p` *(1-3) `\<not> WRcaptured p`
      by (simp add: LIA.is_canon)
    ultimately
    show False
      unfolding LIA_full_unfold LIA.is_canon_def
      by smt
  qed
qed

(* ---------------------------------------------------------- *)
theorem WK_cannot_mate:
assumes
 "\<not> WRcaptured p" "WhiteOnTurn p" "legal_position p"
shows "no_immediate_mate_WK p"
(* ---------------------------------------------------------- *)
using WK_cannot_mate'_sym[rule_format, of p] assms
by (simp add: no_immediate_mate_WK_def all8_def kings_square_def Let_def)

(* ---------------------------------------------------------- *)


(* --------------------------------------------------------- *)
text{* WR cannot be captured *}
(* --------------------------------------------------------- *)

lemma ready_to_mate_black_not_WRcaptured:
  assumes "KRKStrategy.ready_to_mate_cond p1" "\<not> WRcaptured p1" "legal_move_BK p1 p1'"
  shows "\<not> WRcaptured p1'"
proof (rule ccontr)
  obtain WKx WKy BKx BKy WRx WRy  WKx' WKy' BKx' BKy' WRx' WRy' where *:
    "WK p1 = (WKx, WKy)" "BK p1 = (BKx, BKy)" "WR p1 = (WRx, WRy)"
    "WK p1' = (WKx', WKy')" "BK p1' = (BKx', BKy')" "WR p1' = (WRx', WRy')"
    by (cases "WK p1", cases "WR p1", cases "BK p1", cases "WK p1'", cases "WR p1'", cases "BK p1'")
  have p1: "BlackOnTurn p1" "\<not> WRcaptured p1" "legal_position p1"
    using assms
    by (simp_all add: KRK.legal_move_BK_def)
  assume "\<not> ?thesis"
  hence "BKx' = WRx" "BKy' = WRy"
    using assms *
    unfolding legal_move_BK_def'
    by (auto split: split_if_asm simp add: WR_def WRcaptured_def)
  thus False
    using assms * LIA.ready_to_mate[OF _ _ *(1-3) p1] files_ranks_geq6
    unfolding LIA_full_unfold KRK.legal_move_BK_def 
    by (simp add: king_scope_iff all_king_pos_def legal_position_def KRK.kings_separated_def) smt
qed

lemma squeeze_black_not_WRcaptured:
  assumes "let (b, v) = KRKStrategy.squeeze_cond p0 p1 in b" "\<not> WRcaptured p1" "legal_move_BK p1 p1'"
  shows "\<not> WRcaptured p1'"
using assms not_WR_exposed_not_WRcaptured[of p1 p1']
unfolding KRKStrategy.squeeze_cond_def
by (simp add: KRKStrategy.squeeze_cond_def Let_def)

lemma approach_black_not_WRcaptured:
  assumes "KRKStrategy.approach_cond p0 p1" "\<not> WRcaptured p1" "legal_move_BK p1 p1'"
  shows "\<not> WRcaptured p1'"
using assms not_WR_exposed_not_WRcaptured[of p1 p1']
by (auto simp add: KRKStrategy.approach_cond_def Let_def)

lemma keep_room_black_not_WRcaptured:
  assumes "KRKStrategy.keep_room_cond p0 p1" "\<not> WRcaptured p1" "legal_move_BK p1 p1'"
  shows "\<not> WRcaptured p1'"
using assms not_WR_exposed_not_WRcaptured[of p1 p1']
by (simp add: KRKStrategy.keep_room_cond_def Let_def)

lemma chebyshev_dist_geq2:
  assumes "KRKStrategy.chebyshev_dist (BK p') (WR p') \<ge> 2"
  shows "ChessRules.king_scope (BK p') (WR p') \<longrightarrow> ChessRules.king_scope (WK p') (WR p')"
using assms
by (simp add: king_scope_chebyshev_dist)

lemma rook_safe_black_not_WRcaptured:
  assumes "KRKStrategy.rook_safe_cond p0 p1" "\<not> WRcaptured p1" "legal_move_BK p1 p1'"
  shows "\<not> WRcaptured p1'"
using assms chebyshev_dist_geq2[of p1]
by (cases "WRopt p1") (auto split: split_if_asm simp add: KRKStrategy.rook_safe_cond_def legal_move_BK_def' WR_def legal_position_def KRK.kings_separated_def)

lemma rook_home_black_not_WRcaptured:
  assumes "KRKStrategy.rook_home_cond p0 p1" "\<not> WRcaptured p1" "legal_move_BK p1 p1'"
  shows "\<not> WRcaptured p1'"
using assms
unfolding KRKStrategy.rook_home_cond_def
by (cases "WRopt p1") (auto simp add: legal_move_BK_def' WR_def legal_position_def WK_protects_WR_def KRK.kings_separated_def split: split_if_asm)

(* -------------------------------------------------------- *)
theorem strategy_white_move_rel_black_move_not_WRcaptured:
  assumes p0: "\<not> WRcaptured p0"
          "strategy_white_move_rel p0 p1 t1"
          "legal_move_BK p1 p1'"
  shows "\<not> WRcaptured p1'"
(* -------------------------------------------------------- *)
using assms
using strategy_white_move_rel_notWRCaptured[OF assms(1-2)]
using postcond[of p0 p1]
using ready_to_mate_black_not_WRcaptured[of p1 p1'] squeeze_black_not_WRcaptured[of p0 p1 p1'] approach_black_not_WRcaptured[of p0 p1 p1']
 keep_room_black_not_WRcaptured[of p0 p1 p1'] rook_home_black_not_WRcaptured[of p0 p1 p1'] rook_safe_black_not_WRcaptured[of p0 p1 p1'] 
ImmediateMateMove_checkmated[of p0 p1 ImmediateMateMove] checkmated_no_legal_move[of p1 p1']
using strategy_white_move_rel_moves[OF assms(2)]
using strategy_white_move_rel_legal_position[OF assms(2)]
by smt

(* --------------------------------------------------------- *)
text{* Strategy never leads to stalemate *}
(* --------------------------------------------------------- *)

lemma immediate_mate_cond_not_stalemate:
  assumes "immediate_mate_cond p"
  shows "\<not> stalemate p"
using assms
unfolding immediate_mate_cond_def stalemate_def
by auto

lemma ready_to_mate_cond_not_stalemate:
  assumes "ready_to_mate_cond p" and p: "BlackOnTurn p" "\<not> WRcaptured p" "legal_position p"
  shows "\<not> stalemate p"
proof (rule ccontr)
  obtain WKx WKy BKx BKy WRx WRy where *:
    "WK p = (WKx, WKy)" "BK p = (BKx, BKy)" "WR p = (WRx, WRy)"
    by (cases "WK p", cases "WR p", cases "BK p")
  assume "\<not> ?thesis"
  hence "stalemate_optimized WKx WKy BKx BKy WRx WRy" "LIA.ready_to_mate WKx WKy BKx BKy WRx WRy" "legal_position_black_on_turn WKx WKy BKx BKy WRx WRy"
    using LIA.stalemate_optimized[OF _ _ * p] LIA.ready_to_mate[OF _ _ * p] LIA.legal_position_black_on_turn[OF * p(1-2)] assms files_ranks_geq6
    by simp_all
  thus False
    by (simp add: LIA_full_unfold) smt
qed

lemma squeeze_cond_not_stalemate:
  assumes "let (b, v) = KRKStrategy.squeeze_cond p0 p1 in b"
  shows "\<not> stalemate p1"
using assms
unfolding KRKStrategy.squeeze_cond_def stalemate_def Let_def
by simp

lemma approach_not_stalemate:
  assumes "KRKStrategy.approach_cond p0 p1"
  shows "\<not> stalemate p1"
using assms
unfolding KRKStrategy.approach_cond_def stalemate_def
by simp

lemma keep_room_not_stalemate:
  assumes "KRKStrategy.keep_room_cond p0 p1"
  shows "\<not> stalemate p1"
using assms
unfolding KRKStrategy.keep_room_cond_def stalemate_def
by simp

lemma rook_home_cond_not_stalemate:
  assumes "KRKStrategy.rook_home_cond p0 p1"
  shows "\<not> stalemate p1"
using assms
unfolding KRKStrategy.rook_home_cond_def stalemate_def
by simp

lemma rook_safe_cond_not_stalemate:
  assumes "KRKStrategy.rook_safe_cond p0 p1"
  shows "\<not> stalemate p1"
using assms
unfolding KRKStrategy.rook_safe_cond_def stalemate_def
by simp


(* --------------------------------------------------------- *)
theorem strategy_white_move_rel_not_stalemate:
  assumes p0: "\<not> WRcaptured p0"and
             "strategy_white_move_rel p0 p1 t1"
  shows "\<not> stalemate p1"
(* --------------------------------------------------------- *)
using assms
using immediate_mate_cond_not_stalemate[of p1] ready_to_mate_cond_not_stalemate[of p1] squeeze_cond_not_stalemate[of p0 p1] approach_not_stalemate[of p0 p1] keep_room_not_stalemate[of p0 p1] rook_home_cond_not_stalemate[of p0 p1] rook_safe_cond_not_stalemate[of p0 p1]
using strategy_white_move_rel_notWRCaptured[OF assms(1-2)]  strategy_white_move_rel_black_on_turn[OF assms(2)] strategy_white_move_rel_legal_position[of p0 p1 t1]
using strategy_white_move_rel_moves[OF assms(2)] postcond[of p0 p1]
by smt

(* --------------------------------------------------------- *)
text{* Strategy is winning *}
(* --------------------------------------------------------- *)

(* --------------------------------------------------------- *)
theorem ImmediateMateMove:
  assumes "\<not> WRcaptured p0" "strategy_white_move_rel p0 p1 t1" "t1 = ImmediateMateMove"
  shows "checkmated p1"
(* --------------------------------------------------------- *)
by (rule ImmediateMateMove_checkmated[OF assms])

(* --------------------------------------------------------- *)
theorem ReadyToMateMove:
  "\<forall> p0 p1 p1' p2 t1 t2.
      \<not> WRcaptured p0 \<and> 
      strategy_white_move_rel p0 p1 t1 \<and> t1 = ReadyToMateMove \<and> 
      legal_move_BK p1 p1' \<and> 
      strategy_white_move_rel p1' p2 t2 \<longrightarrow> 
         t2 = ImmediateMateMove \<and> KRK.checkmated p2" (is "\<forall> p0. ?P p0")
(* --------------------------------------------------------- *)
proof (rule symmetry)
  show "\<forall>p. ?P (reflectx_p p) \<longrightarrow> ?P p"
    apply (rule allI, rule impI)
    apply (rule allI)+
    apply (erule_tac x="reflectx_p p1" in allE)
    apply (erule_tac x="reflectx_p p1'" in allE)
    apply (erule_tac x="reflectx_p p2" in allE)
    apply (erule_tac x="ReadyToMateMove" in allE)
    apply (erule_tac x="t2" in allE)
    using files_ranks_geq6
    by (auto simp add: strategy_white_move_rel_black_move_not_WRcaptured)
next
  show "\<forall>p. ?P (reflecty_p p) \<longrightarrow> ?P p"
    apply (rule allI, rule impI)
    apply (rule allI)+
    apply (erule_tac x="reflecty_p p1" in allE)
    apply (erule_tac x="reflecty_p p1'" in allE)
    apply (erule_tac x="reflecty_p p2" in allE)
    apply (erule_tac x="ReadyToMateMove" in allE)
    apply (erule_tac x="t2" in allE)
    using files_ranks_geq6
    by (auto simp add: strategy_white_move_rel_black_move_not_WRcaptured)
next
  show "\<forall>p. ?P (reflectdiag_p p) \<longrightarrow> ?P p"
    apply (rule allI, rule impI)
    apply (rule allI)+
    apply (erule_tac x="reflectdiag_p p1" in allE)
    apply (erule_tac x="reflectdiag_p p1'" in allE)
    apply (erule_tac x="reflectdiag_p p2" in allE)
    apply (erule_tac x="ReadyToMateMove" in allE)
    apply (erule_tac x="t2" in allE)
    using files_ranks_geq6
    by (auto simp add: strategy_white_move_rel_black_move_not_WRcaptured files_eq_ranks)
next
  show "files = ranks"
    by (rule files_eq_ranks)
next
  show "\<forall> p0. Symmetry.is_canon p0 \<longrightarrow> ?P p0"
  proof (safe)
    fix p0 p1 p1' p2 t1 t2
    assume "Symmetry.is_canon p0" and "\<not> WRcaptured p0" and
      wm1: "strategy_white_move_rel p0 p1 ReadyToMateMove" and bm1: "KRK.legal_move_BK p1 p1'" and wm2: "strategy_white_move_rel p1' p2 t2"
    show "t2 = ImmediateMateMove" "checkmated p2"
    proof-
      have "ready_to_mate_cond p1" and 
        p0: "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0" and 
        p1: "BlackOnTurn p1" "\<not> WRcaptured p1" "legal_position p1" and 
        p1': "WhiteOnTurn p1'" "\<not> WRcaptured p1'" "legal_position p1'"
        using  ReadyToMateMove_rel_postcond[OF wm1]
        using strategy_white_move_rel_white_on_turn[OF wm1] strategy_white_move_rel_black_on_turn[OF wm1]  strategy_white_move_rel_white_on_turn[OF wm2]
        using `\<not> WRcaptured p0` strategy_white_move_rel_notWRCaptured[OF _ wm1] strategy_white_move_rel_black_move_not_WRcaptured[OF _ wm1 bm1]
        using strategy_white_move_rel_legal_position[OF wm1] strategy_white_move_rel_legal_position[OF wm2]
        by auto

      have "\<not> KRKStrategy.no_immediate_mate p1'"
      proof (rule ccontr)
        obtain WKx0 WKy0 BKx0 BKy0 WRx0 WRy0  WKx1 WKy1 BKx1 BKy1 WRx1 WRy1  WKx1' WKy1' BKx1' BKy1' WRx1' WRy1' where
          *:
          "WK p0 = (WKx0, WKy0)" "BK p0 = (BKx0, BKy0)" "WR p0 = (WRx0, WRy0)"
          "WK p1 = (WKx1, WKy1)" "BK p1 = (BKx1, BKy1)" "WR p1 = (WRx1, WRy1)"
          "WK p1' = (WKx1', WKy1')" "BK p1' = (BKx1', BKy1')" "WR p1' = (WRx1', WRy1')"
          by (cases "WK p0", cases "WR p0", cases "BK p0", cases "WK p1", cases "WR p1", cases "BK p1", cases "WK p1'", cases "WR p1'", cases "BK p1'")

        assume "\<not> ?thesis"
        hence "LIA.no_immediate_mate_opt WKx1' WKy1' BKx1' BKy1' WRx1' WRy1'"
          using LIA.no_immediate_mate_move_opt[OF _ _ *(7-9)] `\<not> WRcaptured p1'` `WhiteOnTurn p1'` `legal_position p1'` files_ranks_geq6
          by simp
        moreover
        have "LIA.ready_to_mate WKx1 WKy1 BKx1 BKy1 WRx1 WRy1"
          using LIA.ready_to_mate[OF _ _ *(4-6) p1]  `KRKStrategy.ready_to_mate_cond p1` files_ranks_geq6
          by simp
        moreover
        have "LIA.legal_move_BK WKx1 WKy1 BKx1 BKy1 WRx1 WRy1 WKx1' WKy1' BKx1' BKy1' WRx1' WRy1'"
          using LIA.legal_move_BK[OF *(4-9) p1(1-2) p1'(1-2)]  `legal_move_BK p1 p1'`
          by auto
        moreover
        have "LIA.is_canon WKx0 WKy0 BKx0 BKy0 WRx0 WRy0"
          using `Symmetry.is_canon p0` *(1-3) `\<not> WRcaptured p0`
          by (simp add: LIA.is_canon)
        moreover
        have "BKx1 = BKx0" "BKy1 = BKy0"
          using LIA.legal_move_WK[OF *(1-6)]  LIA.legal_move_WR[OF *(1-6)] p0 p1 p1' 
          using strategy_white_move_rel_legal_move[OF wm1]
          by (auto simp add: legal_move_white_def LIA.legal_move_WK_def LIA.legal_move_WR_def)
        ultimately
        show False
          using *
          unfolding LIA.ready_to_mate_def LIA.no_immediate_mate_opt_def
          apply (simp add: rooks_square_def)
          unfolding LIA_full_unfold LIA.is_canon_def
          by smt
      qed

      thus  "t2 = ImmediateMateMove" "checkmated p2"
        using notImmediateMateMove[OF wm2] ImmediateMateMove_rel_postcond[of p1' p2] wm2
        using strategy_white_move_rel_legal_position[OF wm2]
        by (auto simp add: immediate_mate_cond_def checkmated_def)
    qed
  qed
qed

lemma ImmediateMateMove_no_legal_move_BK:
  assumes "\<not> WRcaptured p0"
  "strategy_white_move_rel p0 p1 t1" "legal_move_BK p1 p1'"
  shows "t1 \<noteq> ImmediateMateMove"
using ImmediateMateMove[of p0 p1 t1] assms checkmated_no_legal_move[of p1 p1']
by (auto simp add: checkmated_def)

lemma ReadyToMateMove_no_legal_move_BK:
  assumes 
  "\<not> WRcaptured p0"
  "strategy_white_move_rel p0 p1 t1" "legal_move_BK p1 p1'"
  "strategy_white_move_rel p1' p2 t2" "t2 \<noteq> ImmediateMateMove \<or> legal_move_BK p2 p2'"
  shows "t1 \<noteq> ReadyToMateMove"
using assms ReadyToMateMove[rule_format, of p0 p1 t1 p1' p2 t2] checkmated_no_legal_move[of p2 p2']
by auto

(* ---------------------------------------------------------------------------*)
text{* Termination lemmas *}
(* -------------------------------------------------------------------------- *)

(* ------------------------------------------------------------------ *)
text{* First three moves *}
(* ------------------------------------------------------------------ *)

(* ------------------------------------------------------------------------------- *)
theorem first_three_moves:
(* ------------------------------------------------------------------------------- *)
  shows "\<forall> p0 p1 t1 p1' p2 t2 p2' p3 t3 p3' p4 t4.  
  \<not> WRcaptured p0 \<and> 
  strategy_white_move_rel p0 p1 t1  \<and> legal_move_BK p1 p1' \<and>
  strategy_white_move_rel p1' p2 t2 \<and> legal_move_BK p2 p2' \<and> 
  strategy_white_move_rel p2' p3 t3 \<and> legal_move_BK p3 p3' \<and>
  strategy_white_move_rel p3' p4 t4 \<longrightarrow> 
     t4 \<noteq> RookHomeMove \<and> t4 \<noteq> RookSafeMove" (is "\<forall> p0. ?P p0")
proof (rule symmetry)
  have "files \<ge> 0" "ranks \<ge> 0"
    using files_ranks_geq6
    by simp_all

  show "\<forall>p. ?P (reflectx_p p) \<longrightarrow> ?P p"
    apply (rule allI, rule impI)
    apply (rule allI)+
    apply (erule_tac x="reflectx_p p1" in allE)
    apply (erule_tac x="t1" in allE)
    apply (erule_tac x="reflectx_p p1'" in allE)
    apply (erule_tac x="reflectx_p p2" in allE)
    apply (erule_tac x="t2" in allE)
    apply (erule_tac x="reflectx_p p2'" in allE)
    apply (erule_tac x="reflectx_p p3" in allE)
    apply (erule_tac x="t3" in allE)
    apply (erule_tac x="reflectx_p p3'" in allE)
    apply (erule_tac x="reflectx_p p4" in allE)
    apply (erule_tac x="t4" in allE)
    using `files \<ge> 0` `ranks \<ge> 0`
    by (metis reflectx_fields(4) reflectx_legal_move_BK reflectx_strategy_white_move_rel strategy_white_move_rel_black_move_not_WRcaptured)

  show "\<forall>p. ?P (reflecty_p p) \<longrightarrow> ?P p"
    apply (rule allI, rule impI)
    apply (rule allI)+
    apply (erule_tac x="reflecty_p p1" in allE)
    apply (erule_tac x="t1" in allE)
    apply (erule_tac x="reflecty_p p1'" in allE)
    apply (erule_tac x="reflecty_p p2" in allE)
    apply (erule_tac x="t2" in allE)
    apply (erule_tac x="reflecty_p p2'" in allE)
    apply (erule_tac x="reflecty_p p3" in allE)
    apply (erule_tac x="t3" in allE)
    apply (erule_tac x="reflecty_p p3'" in allE)
    apply (erule_tac x="reflecty_p p4" in allE)
    apply (erule_tac x="t4" in allE)
    using `files \<ge> 0` `ranks \<ge> 0`
    by (metis reflecty_fields(4) reflecty_legal_move_BK reflecty_strategy_white_move_rel strategy_white_move_rel_black_move_not_WRcaptured)

    show "\<forall>p. ?P (reflectdiag_p p) \<longrightarrow> ?P p"
    apply (rule allI, rule impI)
    apply (rule allI)+
    apply (erule_tac x="reflectdiag_p p1" in allE)
    apply (erule_tac x="t1" in allE)
    apply (erule_tac x="reflectdiag_p p1'" in allE)
    apply (erule_tac x="reflectdiag_p p2" in allE)
    apply (erule_tac x="t2" in allE)
    apply (erule_tac x="reflectdiag_p p2'" in allE)
    apply (erule_tac x="reflectdiag_p p3" in allE)
    apply (erule_tac x="t3" in allE)
    apply (erule_tac x="reflectdiag_p p3'" in allE)
    apply (erule_tac x="reflectdiag_p p4" in allE)
    apply (erule_tac x="t4" in allE)
    using `files \<ge> 0` `ranks \<ge> 0` files_eq_ranks
    by (metis reflectdiag_fields(4) reflectdiag_legal_move_BK reflectdiag_strategy_white_move_rel strategy_white_move_rel_black_move_not_WRcaptured)

  show "files = ranks"
    by (rule files_eq_ranks)

  show "\<forall> p0. Symmetry.is_canon p0 \<longrightarrow> ?P p0"
  proof (rule allI, rule impI, (rule allI)+, rule impI, (erule conjE)+)
    fix p0 p1 p1' p2 p2' p3 p3' p4 t1 t2 t3 t4
    assume "Symmetry.is_canon p0" and "\<not> WRcaptured p0" and
      wm1: "strategy_white_move_rel p0 p1 t1" and bm1: "KRK.legal_move_BK p1 p1'" and
      wm2: "strategy_white_move_rel p1' p2 t2" and bm2: "KRK.legal_move_BK p2 p2'" and
      wm3: "strategy_white_move_rel p2' p3 t3" and bm3: "KRK.legal_move_BK p3 p3'" and
      wm4: "strategy_white_move_rel p3' p4 t4"      
    show "t4 \<noteq> RookHomeMove \<and> t4 \<noteq> RookSafeMove"
    proof-
     obtain WKx0 WKy0 BKx0 BKy0 WRx0 WRy0 WKx1 WKy1 BKx1 BKy1 WRx1 WRy1  WKx1' WKy1' BKx1' BKy1' WRx1' WRy1'  WKx2 WKy2 BKx2 BKy2 WRx2 WRy2   WKx2' WKy2' BKx2' BKy2' WRx2' WRy2'  WKx3 WKy3 BKx3 BKy3 WRx3 WRy3  WKx3' WKy3' BKx3' BKy3' WRx3' WRy3'  WKx4 WKy4 BKx4 BKy4 WRx4 WRy4 where 
     *:
        "WK p0 = (WKx0, WKy0)" "BK p0 = (BKx0, BKy0)" "WR p0 = (WRx0, WRy0)"
        "WK p1 = (WKx1, WKy1)" "BK p1 = (BKx1, BKy1)" "WR p1 = (WRx1, WRy1)"
        "WK p1' = (WKx1', WKy1')" "BK p1' = (BKx1', BKy1')" "WR p1' = (WRx1', WRy1')"
        "WK p2 = (WKx2, WKy2)" "BK p2 = (BKx2, BKy2)" "WR p2 = (WRx2, WRy2)"
        "WK p2' = (WKx2', WKy2')" "BK p2' = (BKx2', BKy2')" "WR p2' = (WRx2', WRy2')"
        "WK p3 = (WKx3, WKy3)" "BK p3 = (BKx3, BKy3)" "WR p3 = (WRx3, WRy3)"
        "WK p3' = (WKx3', WKy3')" "BK p3' = (BKx3', BKy3')" "WR p3' = (WRx3', WRy3')"
        "WK p4 = (WKx4, WKy4)" "BK p4 = (BKx4, BKy4)" "WR p4 = (WRx4, WRy4)"
        by (cases "WK p0", cases "BK p0", cases "WR p0", cases "WK p1", cases "WR p1", cases "BK p1", cases "WK p1'", cases "WR p1'", cases "BK p1'", cases "WK p2", cases "WR p2", cases "BK p2", cases "WK p2'", cases "WR p2'", cases "BK p2'", cases "WK p3", cases "WR p3", cases "BK p3", cases "WK p3'", cases "WR p3'", cases "BK p3'", cases "WK p4", cases "WR p4", cases "BK p4")

      have p0: "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0" and
           p1: "BlackOnTurn p1" "\<not> WRcaptured p1" "legal_position p1" and
           p1': "WhiteOnTurn p1'" "\<not> WRcaptured p1'" "legal_position p1'" and
           p2: "BlackOnTurn p2" "\<not> WRcaptured p2" "legal_position p2" and
           p2': "WhiteOnTurn p2'" "\<not> WRcaptured p2'" "legal_position p2'" and
           p3: "BlackOnTurn p3" "\<not> WRcaptured p3" "legal_position p3" and
           p3': "WhiteOnTurn p3'" "\<not> WRcaptured p3'" "legal_position p3'" and
           p4: "BlackOnTurn p4" "\<not> WRcaptured p4" "legal_position p4"
        using strategy_white_move_rel_white_on_turn[OF wm1(1)] strategy_white_move_rel_black_on_turn[OF wm1(1)]
              strategy_white_move_rel_white_on_turn[OF wm2(1)] strategy_white_move_rel_black_on_turn[OF wm2(1)]
              strategy_white_move_rel_white_on_turn[OF wm3(1)] strategy_white_move_rel_black_on_turn[OF wm3(1)]
              strategy_white_move_rel_white_on_turn[OF wm4(1)] strategy_white_move_rel_black_on_turn[OF wm4(1)]
        using `\<not> WRcaptured p0`
              strategy_white_move_rel_notWRCaptured[OF _ wm1(1)] strategy_white_move_rel_black_move_not_WRcaptured[OF _ wm1(1) bm1]
              strategy_white_move_rel_notWRCaptured[OF _ wm2(1)] strategy_white_move_rel_black_move_not_WRcaptured[OF _ wm2(1) bm2]
              strategy_white_move_rel_notWRCaptured[OF _ wm3(1)] strategy_white_move_rel_black_move_not_WRcaptured[OF _ wm3(1) bm3]
              strategy_white_move_rel_notWRCaptured[OF _ wm4(1)]
        using strategy_white_move_rel_legal_position[OF wm1(1)] 
              strategy_white_move_rel_legal_position[OF wm2(1)] 
              strategy_white_move_rel_legal_position[OF wm3(1)]
              strategy_white_move_rel_legal_position[OF wm4(1)]
        by auto

    have fr: "files \<ge> 4" "ranks \<ge> 4"
      using files_ranks_geq6
      by auto


    have "LIA.is_canon WKx0 WKy0 BKx0 BKy0 WRx0 WRy0"
      using `Symmetry.is_canon p0` *(1-3) `\<not> WRcaptured p0`
      by (simp add: LIA.is_canon)
    show ?thesis
      using LIA_fullpostcond[OF fr wm1 p0(2) *(1-6)]
      using LIA_fullpostcond[OF fr wm2 p1'(2) *(7-12)]
      using LIA_fullpostcond[OF fr wm3 p2'(2) *(13-18)]
      using RookHomeMove_LIA_fullpostcond[OF fr _ wm4 p3'(2) *(19-24)]
      using RookSafeMove_LIA_fullpostcond[OF fr _ wm4 p3'(2) *(19-24)]
      using LIA.legal_move_BK[OF *(4-9) p1(1-2) p1'(1-2), THEN iffD1, OF bm1]
      using LIA.legal_move_BK[OF *(10-15) p2(1-2) p2'(1-2), THEN iffD1, OF bm2]
      using LIA.legal_move_BK[OF *(16-21) p3(1-2) p3'(1-2), THEN iffD1, OF bm3]
      unfolding LIA.no_immediate_mate_opt_def LIA.no_ready_to_mate_WR_opt_def LIA.no_ready_to_mate_WK_def LIA.no_squeeze_opt_def LIA.no_approach_def LIA.no_keep_room_def LIA.no_rook_home_opt_def LIA.no_approach_diag_def LIA.no_keep_room_diag_def
      unfolding all4_def all8_def Let_def split_def fst_conv snd_conv kings_square_fstsnd
      using [[ z3_with_extensions ]]
      using [[ smt_oracle = true ]]
      using files_eq_ranks
      apply simp
      unfolding LIA.is_canon_def
      unfolding LIA_full_unfold
      by smt
    qed
  qed
qed

(* ------------------------------------------------------------------ *)
text{* Measure decreases when room > 3 *}
(* ------------------------------------------------------------------ *)

(* ------------------------------------------------------------------------------- *)
theorem basic_moves_3:
(* ------------------------------------------------------------------------------- *)
"\<forall> p0 p1 t1 p1' p2 p2' t2 p3 p3' t3. 
    \<not> WRcaptured p0 \<and> (WR_exposed p0 \<or> room p0 > 3) \<and> 
    strategy_white_move_rel p0 p1 t1 \<and> legal_move_BK p1 p1' \<and>
    strategy_white_move_rel p1' p2 t2 \<and> legal_move_BK p2 p2' \<and>
    strategy_white_move_rel p2' p3 t3 \<and> legal_move_BK p3 p3' \<and>
    t1 \<noteq> ReadyToMateMove \<and> t1 \<noteq> RookSafeMove \<and> t1 \<noteq> RookHomeMove \<and>
    t2 \<noteq> ReadyToMateMove \<and> t2 \<noteq> RookSafeMove \<and> t2 \<noteq> RookHomeMove \<and>
    t3 \<noteq> ReadyToMateMove \<and> t3 \<noteq> RookSafeMove \<and> t3 \<noteq> RookHomeMove \<and> t3 \<noteq> ImmediateMateMove \<longrightarrow> 
     (3 \<le> room p3' \<and> \<not> WR_exposed p3') \<and> (room p3' < room p0 \<or> (room p3' = room p0 \<and> mdcs p3' < mdcs p0))" (is "\<forall> p. ?P p")
proof (rule symmetry)
  have "files \<ge> 0" "ranks \<ge> 0"
    using files_ranks_geq6
    by simp_all

  show "\<forall>p. ?P (reflectx_p p) \<longrightarrow> ?P p"
    apply (rule allI, rule impI)
    apply (rule allI)+
    apply (erule_tac x="reflectx_p p1" in allE)
    apply (erule_tac x="t1" in allE)
    apply (erule_tac x="reflectx_p p1'" in allE)
    apply (erule_tac x="reflectx_p p2" in allE)
    apply (erule_tac x="reflectx_p p2'" in allE)
    apply (erule_tac x="t2" in allE)
    apply (erule_tac x="reflectx_p p3" in allE)
    apply (erule_tac x="reflectx_p p3'" in allE)
    apply (erule_tac x="t3" in allE)
    using `files \<ge> 0` `ranks \<ge> 0`
    by (metis not_less_iff_gr_or_eq reflectx_WR_exposed reflectx_fields(4) reflectx_legal_move_BK reflectx_mdcs reflectx_room reflectx_strategy_white_move_rel strategy_white_move_rel_black_move_not_WRcaptured)
  
  show "\<forall>p. ?P (reflecty_p p) \<longrightarrow> ?P p"
    apply (rule allI, rule impI)
    apply (rule allI)+
    apply (erule_tac x="reflecty_p p1" in allE)
    apply (erule_tac x="t1" in allE)
    apply (erule_tac x="reflecty_p p1'" in allE)
    apply (erule_tac x="reflecty_p p2" in allE)
    apply (erule_tac x="reflecty_p p2'" in allE)
    apply (erule_tac x="t2" in allE)
    apply (erule_tac x="reflecty_p p3" in allE)
    apply (erule_tac x="reflecty_p p3'" in allE)
    apply (erule_tac x="t3" in allE)
    using `files \<ge> 0` `ranks \<ge> 0`
    by (metis not_less_iff_gr_or_eq reflecty_WR_exposed reflecty_fields(4) reflecty_legal_move_BK reflecty_mdcs reflecty_room reflecty_strategy_white_move_rel strategy_white_move_rel_black_move_not_WRcaptured)

  show "\<forall>p. ?P (reflectdiag_p p) \<longrightarrow> ?P p"
    apply (rule allI, rule impI)
    apply (rule allI)+
    apply (erule_tac x="reflectdiag_p p1" in allE)
    apply (erule_tac x="t1" in allE)
    apply (erule_tac x="reflectdiag_p p1'" in allE)
    apply (erule_tac x="reflectdiag_p p2" in allE)
    apply (erule_tac x="reflectdiag_p p2'" in allE)
    apply (erule_tac x="t2" in allE)
    apply (erule_tac x="reflectdiag_p p3" in allE)
    apply (erule_tac x="reflectdiag_p p3'" in allE)
    apply (erule_tac x="t3" in allE)
    using `files \<ge> 0` `ranks \<ge> 0` files_eq_ranks
    by (metis not_less_iff_gr_or_eq reflectdiag_WR_exposed reflectdiag_fields(4) reflectdiag_legal_move_BK reflectdiag_mdcs reflectdiag_room reflectdiag_strategy_white_move_rel strategy_white_move_rel_black_move_not_WRcaptured)

  show "files = ranks"
    by (rule files_eq_ranks)

  show "\<forall> p. Symmetry.is_canon p \<longrightarrow> ?P p"
  proof (rule allI, rule impI, (rule allI)+, rule impI, (erule conjE)+)
    fix p0 p1 t1 p1' p2 p2' t2 p3 p3' t3
    assume "Symmetry.is_canon p0" "\<not> WRcaptured p0" and
      "WR_exposed p0 \<or> room p0 > 3" and
      wm1: "strategy_white_move_rel p0 p1 t1"  and bm1: "legal_move_BK p1 p1'" and
      wm2: "strategy_white_move_rel p1' p2 t2" and bm2: "legal_move_BK p2 p2'" and
      wm3: "strategy_white_move_rel p2' p3 t3" and bm3: "legal_move_BK p3 p3'" and
      nosteps:
      "t1 \<noteq> ReadyToMateMove" "t1 \<noteq> RookSafeMove" "t1 \<noteq> RookHomeMove"
      "t2 \<noteq> ReadyToMateMove" "t2 \<noteq> RookSafeMove" "t2 \<noteq> RookHomeMove"
      "t3 \<noteq> ReadyToMateMove" "t3 \<noteq> RookSafeMove" "t3 \<noteq> RookHomeMove" "t3 \<noteq> ImmediateMateMove"
    show "(3 \<le> room p3' \<and> \<not> WR_exposed p3') \<and> (room p3' < room p0 \<or> (room p3' = room p0 \<and> mdcs p3' < mdcs p0))"
    proof-
      obtain WKx0 WKy0 BKx0 BKy0 WRx0 WRy0 WKx1 WKy1 BKx1 BKy1 WRx1 WRy1  WKx1' WKy1' BKx1' BKy1' WRx1' WRy1'  WKx2 WKy2 BKx2 BKy2 WRx2 WRy2   WKx2' WKy2' BKx2' BKy2' WRx2' WRy2'  WKx3 WKy3 BKx3 BKy3 WRx3 WRy3  WKx3' WKy3' BKx3' BKy3' WRx3' WRy3' where 
        *:
        "WK p0 = (WKx0, WKy0)" "BK p0 = (BKx0, BKy0)" "WR p0 = (WRx0, WRy0)"
        "WK p1 = (WKx1, WKy1)" "BK p1 = (BKx1, BKy1)" "WR p1 = (WRx1, WRy1)"
        "WK p1' = (WKx1', WKy1')" "BK p1' = (BKx1', BKy1')" "WR p1' = (WRx1', WRy1')"
        "WK p2 = (WKx2, WKy2)" "BK p2 = (BKx2, BKy2)" "WR p2 = (WRx2, WRy2)"
        "WK p2' = (WKx2', WKy2')" "BK p2' = (BKx2', BKy2')" "WR p2' = (WRx2', WRy2')"
        "WK p3 = (WKx3, WKy3)" "BK p3 = (BKx3, BKy3)" "WR p3 = (WRx3, WRy3)"
        "WK p3' = (WKx3', WKy3')" "BK p3' = (BKx3', BKy3')" "WR p3' = (WRx3', WRy3')"
        by (cases "WK p0", cases "BK p0", cases "WR p0", cases "WK p1", cases "WR p1", cases "BK p1", cases "WK p1'", cases "WR p1'", cases "BK p1'", cases "WK p2", cases "WR p2", cases "BK p2", cases "WK p2'", cases "WR p2'", cases "BK p2'", cases "WK p3", cases "WR p3", cases "BK p3", cases "WK p3'", cases "WR p3'", cases "BK p3'")

      have p0: "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0" and
           p1: "BlackOnTurn p1" "\<not> WRcaptured p1" "legal_position p1" and
           p1': "WhiteOnTurn p1'" "\<not> WRcaptured p1'" "legal_position p1'" and
           p2: "BlackOnTurn p2" "\<not> WRcaptured p2" "legal_position p2" and
           p2': "WhiteOnTurn p2'" "\<not> WRcaptured p2'" "legal_position p2'" and
           p3: "BlackOnTurn p3" "\<not> WRcaptured p3" "legal_position p3" and
           p3': "WhiteOnTurn p3'" "\<not> WRcaptured p3'" "legal_position p3'" 
        using strategy_white_move_rel_white_on_turn[OF wm1(1)] strategy_white_move_rel_black_on_turn[OF wm1(1)]
          strategy_white_move_rel_white_on_turn[OF wm2(1)] strategy_white_move_rel_black_on_turn[OF wm2(1)]
          strategy_white_move_rel_white_on_turn[OF wm3(1)] strategy_white_move_rel_black_on_turn[OF wm3(1)]
          legal_move_BK_white_on_turn[OF bm3]
        using `\<not> WRcaptured p0`
          strategy_white_move_rel_notWRCaptured[OF _ wm1(1)] strategy_white_move_rel_black_move_not_WRcaptured[OF _ wm1(1) bm1]
          strategy_white_move_rel_notWRCaptured[OF _ wm2(1)] strategy_white_move_rel_black_move_not_WRcaptured[OF _ wm2(1) bm2]
          strategy_white_move_rel_notWRCaptured[OF _ wm3(1)] strategy_white_move_rel_black_move_not_WRcaptured[OF _ wm3(1) bm3]
        using strategy_white_move_rel_legal_position[OF wm1(1)] 
          strategy_white_move_rel_legal_position[OF wm2(1)] 
          strategy_white_move_rel_legal_position[OF wm3(1)]
          bm3 unfolding legal_move_BK_def'
        by auto

      have "LIA.chebyshev_dist BKx0 BKy0 WRx0 WRy0 + 1 < LIA.chebyshev_dist WKx0 WKy0 WRx0 WRy0 \<or> LIA.room WRx0 WRy0 BKx0 BKy0 > 3"
        using `WR_exposed p0 \<or> room p0 > 3` *(1-3) `WhiteOnTurn p0`
        unfolding WR_exposed_def
        by (metis KRKStrategy.room_def LIA.room LIA.chebyshev_dist)
      moreover
      have "LIA.is_canon WKx0 WKy0 BKx0 BKy0 WRx0 WRy0"
        using `Symmetry.is_canon p0` *(1-3) `\<not> WRcaptured p0`
        by (simp add: LIA.is_canon)
      ultimately
      have "(LIA.room WRx3' WRy3' BKx3' BKy3' \<ge> 3 \<and> LIA.chebyshev_dist BKx3' BKy3' WRx3' WRy3' + 1 \<ge> LIA.chebyshev_dist WKx3' WKy3' WRx3' WRy3') \<and> (LIA.room WRx3' WRy3' BKx3' BKy3' < LIA.room WRx0 WRy0 BKx0 BKy0 \<or>
        LIA.room WRx3' WRy3' BKx3' BKy3' = LIA.room WRx0 WRy0 BKx0 BKy0 \<and>
          LIA.mdcs WKx3' WKy3' BKx3' BKy3' WRx3' WRy3' < LIA.mdcs WKx0 WKy0 BKx0 BKy0 WRx0 WRy0)"
        using LIA_fullpostcond[OF _ _ wm1 p0(2) *(1-6)]
        using LIA_fullpostcond[OF _ _ wm2 p1'(2) *(7-12)]
        using LIA_fullpostcond[OF _ _ wm3 p2'(2) *(13-18)]
        using LIA.legal_move_BK[OF *(4-9) p1(1-2) p1'(1-2), THEN iffD1, OF bm1]
        using LIA.legal_move_BK[OF *(10-15) p2(1-2) p2'(1-2), THEN iffD1, OF bm2]
        using LIA.legal_move_BK[OF *(16-21) p3(1-2) p3'(1-2), THEN iffD1, OF bm3]
        unfolding LIA.squeeze_cond_def
        using nosteps files_ranks_geq6
        unfolding LIA.no_immediate_mate_opt_def LIA.no_ready_to_mate_WR_opt_def LIA.no_ready_to_mate_WK_def LIA.no_squeeze_opt_def LIA.no_approach_def LIA.no_keep_room_def LIA.no_rook_home_opt_def LIA.no_approach_diag_def LIA.no_keep_room_diag_def
        unfolding all4_def all8_def Let_def split_def fst_conv snd_conv kings_square_fstsnd 
        apply simp
        unfolding LIA_full_unfold LIA.is_canon_def not_back_move_def
        using [[ z3_with_extensions ]]
        using [[ smt_oracle = true ]]
        by smt
      thus ?thesis
        unfolding WR_exposed_def
        using * `WhiteOnTurn p3'`
        using LIA.room LIA.mdcs LIA.chebyshev_dist
        by simp
    qed
  qed
qed

(* ------------------------------------------------------------------ *)
text{* Mate follows when room \<le> 3 *}
(* ------------------------------------------------------------------ *)

(* ------------------------------------------------------------------------------- *)
theorem room_leq_3_checkmate_in_5_moves:
(* ------------------------------------------------------------------------------- *)
  shows "\<forall> p0 p1 t1 p1' p2 t2 p2' p3 t3 p3' p4 t4 p4' p5 t5. 
          \<not> WRcaptured p0 \<and> room p0 \<le> 3 \<and> \<not> WR_exposed p0 \<and> is_basic_move t1 \<and>
          strategy_white_move_rel p0 p1  t1 \<and> legal_move_BK p1 p1' \<and>
          strategy_white_move_rel p1' p2 t2 \<and> legal_move_BK p2 p2' \<and>
          strategy_white_move_rel p2' p3 t3 \<and> legal_move_BK p3 p3' \<and>
          strategy_white_move_rel p3' p4 t4 \<and> legal_move_BK p4 p4' \<and>
          strategy_white_move_rel p4' p5 t5 \<longrightarrow> 
              is_mate_move t5" (is "\<forall> p0. ?P p0")
proof (rule symmetry)
  show "\<forall>p. ?P (reflectx_p p) \<longrightarrow> ?P p"
    apply (rule allI, rule impI)
    apply (rule allI)+
    apply (erule_tac x="reflectx_p p1" in allE)
    apply (erule_tac x="t1" in allE)
    apply (erule_tac x="reflectx_p p1'" in allE)
    apply (erule_tac x="reflectx_p p2" in allE)
    apply (erule_tac x="t2" in allE)
    apply (erule_tac x="reflectx_p p2'" in allE)
    apply (erule_tac x="reflectx_p p3" in allE)
    apply (erule_tac x="t3" in allE)
    apply (erule_tac x="reflectx_p p3'" in allE)
    apply (erule_tac x="reflectx_p p4" in allE)
    apply (erule_tac x="t4" in allE)
    apply (erule_tac x="reflectx_p p4'" in allE)
    apply (erule_tac x="reflectx_p p5" in allE)
    apply (erule_tac x="t5" in allE)
    using files_ranks_geq6
    by (smt reflectx_fields(4) reflectx_WR_exposed reflectx_legal_move_BK reflectx_mdcs reflectx_room reflectx_strategy_white_move_rel strategy_white_move_rel_black_move_not_WRcaptured strategy_white_move_rel_notWRCaptured)
next
  show "\<forall>p. ?P (reflecty_p p) \<longrightarrow> ?P p"
    apply (rule allI, rule impI)
    apply (rule allI)+
    apply (erule_tac x="reflecty_p p1" in allE)
    apply (erule_tac x="t1" in allE)
    apply (erule_tac x="reflecty_p p1'" in allE)
    apply (erule_tac x="reflecty_p p2" in allE)
    apply (erule_tac x="t2" in allE)
    apply (erule_tac x="reflecty_p p2'" in allE)
    apply (erule_tac x="reflecty_p p3" in allE)
    apply (erule_tac x="t3" in allE)
    apply (erule_tac x="reflecty_p p3'" in allE)
    apply (erule_tac x="reflecty_p p4" in allE)
    apply (erule_tac x="t4" in allE)
    apply (erule_tac x="reflecty_p p4'" in allE)
    apply (erule_tac x="reflecty_p p5" in allE)
    apply (erule_tac x="t5" in allE)
    using files_ranks_geq6
    by (smt reflecty_WR_exposed reflecty_fields(4) reflecty_legal_move_BK reflecty_mdcs reflecty_room reflecty_strategy_white_move_rel strategy_white_move_rel_black_move_not_WRcaptured strategy_white_move_rel_notWRCaptured)
next
  show "\<forall>p. ?P (reflectdiag_p p) \<longrightarrow> ?P p"
    apply (rule allI, rule impI)
    apply (rule allI)+
    apply (erule_tac x="reflectdiag_p p1" in allE)
    apply (erule_tac x="t1" in allE)
    apply (erule_tac x="reflectdiag_p p1'" in allE)
    apply (erule_tac x="reflectdiag_p p2" in allE)
    apply (erule_tac x="t2" in allE)
    apply (erule_tac x="reflectdiag_p p2'" in allE)
    apply (erule_tac x="reflectdiag_p p3" in allE)
    apply (erule_tac x="t3" in allE)
    apply (erule_tac x="reflectdiag_p p3'" in allE)
    apply (erule_tac x="reflectdiag_p p4" in allE)
    apply (erule_tac x="t4" in allE)
    apply (erule_tac x="reflectdiag_p p4'" in allE)
    apply (erule_tac x="reflectdiag_p p5" in allE)
    apply (erule_tac x="t5" in allE)
    using files_ranks_geq6 files_eq_ranks
    by (smt reflectdiag_WR_exposed reflectdiag_fields(4) reflectdiag_legal_move_BK reflectdiag_mdcs reflectdiag_room reflectdiag_strategy_white_move_rel strategy_white_move_rel_black_move_not_WRcaptured strategy_white_move_rel_notWRCaptured)
next
  show "files = ranks"
    by (rule files_eq_ranks)
next
  show "\<forall> p0. Symmetry.is_canon p0 \<longrightarrow> ?P p0"
  proof (rule allI, rule impI, (rule allI)+, rule impI, (erule conjE)+)
    fix p0 p1 t1 p1' p2 t2 p2' p3 t3 p3' p4 t4 p4' p5 t5
    assume
      "Symmetry.is_canon p0" and
      p0: "\<not> WRcaptured p0" and
      "room p0 \<le> 3" "\<not> WR_exposed p0" and "is_basic_move t1" and
      wm1: "strategy_white_move_rel p0 p1 t1" and bm1: "legal_move_BK p1 p1'" and
      wm2: "strategy_white_move_rel p1' p2 t2" and bm2: "legal_move_BK p2 p2'" and
      wm3: "strategy_white_move_rel p2' p3 t3" and bm3: "legal_move_BK p3 p3'" and
      wm4: "strategy_white_move_rel p3' p4 t4" and bm4: "legal_move_BK p4 p4'" and
      wm5: "strategy_white_move_rel p4' p5 t5"
    show "is_mate_move t5"
    proof (rule ccontr)
      assume "\<not> is_mate_move t5"
      have p0: "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0" and
           p1: "BlackOnTurn p1" "\<not> WRcaptured p1" "legal_position p1" and
           p1': "WhiteOnTurn p1'" "\<not> WRcaptured p1'" "legal_position p1'" and
           p2: "BlackOnTurn p2" "\<not> WRcaptured p2" "legal_position p2" and
           p2': "WhiteOnTurn p2'" "\<not> WRcaptured p2'" "legal_position p2'" and
           p3: "BlackOnTurn p3" "\<not> WRcaptured p3" "legal_position p3" and
           p3': "WhiteOnTurn p3'" "\<not> WRcaptured p3'" "legal_position p3'" and
           p4: "BlackOnTurn p4" "\<not> WRcaptured p4" "legal_position p4" and
           p4': "WhiteOnTurn p4'" "\<not> WRcaptured p4'" "legal_position p4'" and
           p5: "BlackOnTurn p5" "\<not> WRcaptured p5"
        using
          strategy_white_move_rel_white_on_turn[OF wm1(1)] strategy_white_move_rel_black_on_turn[OF wm1(1)]
          strategy_white_move_rel_white_on_turn[OF wm2(1)] strategy_white_move_rel_black_on_turn[OF wm2(1)]
          strategy_white_move_rel_white_on_turn[OF wm3(1)] strategy_white_move_rel_black_on_turn[OF wm3(1)]
          strategy_white_move_rel_white_on_turn[OF wm4(1)] strategy_white_move_rel_black_on_turn[OF wm4(1)]
          strategy_white_move_rel_white_on_turn[OF wm5(1)] strategy_white_move_rel_black_on_turn[OF wm5(1)]
        using `\<not> WRcaptured p0`
          strategy_white_move_rel_notWRCaptured[OF _ wm1(1)] strategy_white_move_rel_black_move_not_WRcaptured[OF _ wm1(1) bm1]
          strategy_white_move_rel_notWRCaptured[OF _ wm2(1)] strategy_white_move_rel_black_move_not_WRcaptured[OF _ wm2(1) bm2]
          strategy_white_move_rel_notWRCaptured[OF _ wm3(1)] strategy_white_move_rel_black_move_not_WRcaptured[OF _ wm3(1) bm3]
          strategy_white_move_rel_notWRCaptured[OF _ wm4(1)] strategy_white_move_rel_black_move_not_WRcaptured[OF _ wm4(1) bm4]
          strategy_white_move_rel_notWRCaptured[OF _ wm5(1)]
        using strategy_white_move_rel_legal_position[OF wm1(1)] 
          strategy_white_move_rel_legal_position[OF wm2(1)] 
          strategy_white_move_rel_legal_position[OF wm3(1)]
          strategy_white_move_rel_legal_position[OF wm4(1)]
          strategy_white_move_rel_legal_position[OF wm5(1)]
        by auto
  
  
      obtain WKx0 WKy0 BKx0 BKy0 WRx0 WRy0 WKx1 WKy1 BKx1 BKy1 WRx1 WRy1  WKx1' WKy1' BKx1' BKy1' WRx1' WRy1'  WKx2 WKy2 BKx2 BKy2 WRx2 WRy2 WKx2' WKy2' BKx2' BKy2' WRx2' WRy2'  WKx3 WKy3 BKx3 BKy3 WRx3 WRy3 WKx3' WKy3' BKx3' BKy3' WRx3' WRy3'  WKx4 WKy4 BKx4 BKy4 WRx4 WRy4 WKx4' WKy4' BKx4' BKy4' WRx4' WRy4' WKx5 WKy5 BKx5 BKy5 WRx5 WRy5 where *:
        "WK p0 = (WKx0, WKy0)" "BK p0 = (BKx0, BKy0)" "WR p0 = (WRx0, WRy0)"
        "WK p1 = (WKx1, WKy1)" "BK p1 = (BKx1, BKy1)" "WR p1 = (WRx1, WRy1)"
        "WK p1' = (WKx1', WKy1')" "BK p1' = (BKx1', BKy1')" "WR p1' = (WRx1', WRy1')"
        "WK p2 = (WKx2, WKy2)" "BK p2 = (BKx2, BKy2)" "WR p2 = (WRx2, WRy2)"
        "WK p2' = (WKx2', WKy2')" "BK p2' = (BKx2', BKy2')" "WR p2' = (WRx2', WRy2')"
        "WK p3 = (WKx3, WKy3)" "BK p3 = (BKx3, BKy3)" "WR p3 = (WRx3, WRy3)"
        "WK p3' = (WKx3', WKy3')" "BK p3' = (BKx3', BKy3')" "WR p3' = (WRx3', WRy3')"
        "WK p4 = (WKx4, WKy4)" "BK p4 = (BKx4, BKy4)" "WR p4 = (WRx4, WRy4)"
        "WK p4' = (WKx4', WKy4')" "BK p4' = (BKx4', BKy4')" "WR p4' = (WRx4', WRy4')"
        "WK p5 = (WKx5, WKy5)" "BK p5 = (BKx5, BKy5)" "WR p5 = (WRx5, WRy5)"
        by (cases "WK p0", cases "BK p0", cases "WR p0", cases "WK p1", cases "WR p1", cases "BK p1", cases "WK p1'", cases "WR p1'", cases "BK p1'", cases "WK p2", cases "WR p2", cases "BK p2", cases "WK p2'", cases "WR p2'", cases "BK p2'", cases "WK p3", cases "WR p3", cases "BK p3", cases "WK p3'", cases "WR p3'", cases "BK p3'", cases "WK p4", cases "WR p4", cases "BK p4", cases "WK p4'", cases "WR p4'", cases "BK p4'", cases "WK p5", cases "WR p5", cases "BK p5" )


      have
        "LIA.legal_move_BK WKx1 WKy1 BKx1 BKy1 WRx1 WRy1 WKx1' WKy1' BKx1' BKy1' WRx1' WRy1'"
        "LIA.legal_move_BK WKx2 WKy2 BKx2 BKy2 WRx2 WRy2 WKx2' WKy2' BKx2' BKy2' WRx2' WRy2'"
        "LIA.legal_move_BK WKx3 WKy3 BKx3 BKy3 WRx3 WRy3 WKx3' WKy3' BKx3' BKy3' WRx3' WRy3'"
        "LIA.legal_move_BK WKx4 WKy4 BKx4 BKy4 WRx4 WRy4 WKx4' WKy4' BKx4' BKy4' WRx4' WRy4'"
        using `legal_move_BK p1 p1'` LIA.legal_move_BK[OF *(4-9)] p1 p1'
        using `legal_move_BK p2 p2'` LIA.legal_move_BK[OF *(10-15)] p2 p2'
        using `legal_move_BK p3 p3'` LIA.legal_move_BK[OF *(16-21)] p3 p3'
        using `legal_move_BK p4 p4'` LIA.legal_move_BK[OF *(22-27)] p4 p4'
        by auto

      moreover

      have "LIA.room WRx0 WRy0 BKx0 BKy0 \<le> 3"
        using `room p0 \<le> 3` *
        by (simp add: LIA.room)

      moreover

      have "LIA.chebyshev_dist BKx0 BKy0 WRx0 WRy0 + 1 \<ge> LIA.chebyshev_dist WKx0 WKy0 WRx0 WRy0"
        using `\<not> WR_exposed p0` `WhiteOnTurn p0` *(1-3)
        unfolding WR_exposed_def
        by (simp add: LIA.chebyshev_dist)
      
      moreover

      have "LIA.is_canon WKx0 WKy0 BKx0 BKy0 WRx0 WRy0"
        using `Symmetry.is_canon p0` *(1-3) `\<not> WRcaptured p0`
        by (simp add: LIA.is_canon)
      ultimately
      show False
        using `\<not> is_mate_move t5` `is_basic_move t1`
        using LIA_fullpostcond_opt[OF _ _ wm1 p0(2) *(1-6)]
        using LIA_fullpostcond_opt[OF _ _ wm2 p1'(2) *(7-12)]
        using LIA_fullpostcond_opt[OF _ _ wm3 p2'(2) *(13-18)]
        using LIA_fullpostcond_opt[OF _ _ wm4 p3'(2) *(19-24)]
        using LIA_fullpostcond_opt[OF _ _ wm5 p4'(2) *(25-30)]
        using files_ranks_geq6
        unfolding LIA.legal_move_BK_def
        apply -
        apply (erule conjE)+
        apply simp
        unfolding LIA.no_immediate_mate_opt_def LIA.no_ready_to_mate_WK_def LIA.no_ready_to_mate_WR_opt_def LIA.no_squeeze_opt_def LIA.no_approach_def LIA.no_approach_diag_def LIA.no_keep_room_diag_def LIA.no_keep_room_def LIA.no_rook_home_opt_def
        unfolding all4_def all8_def Let_def split_def fst_conv snd_conv kings_square_fstsnd
        using [[ z3_with_extensions ]]
        using [[ smt_oracle = true ]]
        unfolding LIA_full_unfold LIA.is_canon_def LIA.not_back_move_def
        by smt
    qed
  qed
qed


(* Iff squeeze cannot be played, then RookSafe can *)
(* FIXME: BUG for 4x4*)
lemma NoSqueezeRookHomeOrRookSafe:
  assumes p: "WhiteOnTurn p" "\<not> WRcaptured p" "legal_position p" and "KRKStrategy.no_squeeze p"
  shows "\<not> KRKStrategy.no_rook_safe p \<or> \<not> KRKStrategy.no_rook_home p" (* For files and ranks > 6 rook_safe suffices *)
proof (rule ccontr)
  obtain WKx WKy BKx BKy WRx WRy where *:
    "WK p = (WKx, WKy)" "BK p = (BKx, BKy)" "WR p = (WRx, WRy)"
    by (cases "WK p", cases "WR p", cases "BK p")
  assume "\<not> ?thesis"
  hence "LIA.no_squeeze_opt WKx WKy BKx BKy WRx WRy" "LIA.no_rook_safe_opt WKx WKy BKx BKy WRx WRy" "legal_position_white_on_turn WKx WKy BKx BKy WRx WRy" "LIA.no_rook_home_opt WKx WKy BKx BKy WRx WRy"
    using LIA.no_squeeze_move_opt[OF _ _ * assms(1-3)]  LIA.no_rook_safe_move_opt[OF _ _ * assms(1-3)]   LIA.no_rook_home_move_opt[OF _ _ * assms(1-3)]
    using LIA.legal_position_white_on_turn[OF * assms(1-2)] assms files_ranks_geq6
    by (auto simp add: legal_position_def)
  thus False
    using files_ranks_geq6
    unfolding LIA.no_rook_safe_opt_def LIA.no_rook_home_opt_def LIA.no_squeeze_opt_def
    apply (simp add: all8_def split_def Let_def)
    unfolding LIA_full_unfold
    using [[ z3_with_extensions ]]
    using [[ smt_oracle = true ]]
    by smt
qed

(* --------------------------------------------------------- *)
theorem strategy_white_move_rel_exists: 
  assumes p0: "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0"
  shows "\<exists> p1 t1. strategy_white_move_rel p0 p1 t1"
(* --------------------------------------------------------- *)
using assms 
using NoSqueezeRookHomeOrRookSafe[OF p0] not_no_rook_safe[OF p0] not_no_rook_home[OF p0] not_no_squeeze[OF p0]
by auto

definition strategy_white_move_rel' where
"strategy_white_move_rel' p p' \<longleftrightarrow> (\<exists> t. strategy_white_move_rel p p' t)"

interpretation Strategy_KRK: Strategy "KRK.on_square" "KRK.invar" "KRK.to_move" "strategy_white_move_rel'" "\<lambda> p0. \<not> WRcaptured p0"
proof
  fix p0 p1
  assume *: "Position_KRK.legal_position p0" "to_move p0 = White" "\<not> WRcaptured p0" "strategy_white_move_rel' p0 p1"
  obtain t1 where "strategy_white_move_rel p0 p1 t1"
    using `strategy_white_move_rel' p0 p1`
    by (auto simp add: strategy_white_move_rel'_def)
  thus "Position_KRK.legal_move p0 p1"
    using strategy_white_move_rel_legal_move[of p0 p1 t1] * legal_position[of p0] legal_move_WK_legal_move[of p0 p1]  legal_move_WR_legal_move[of p0 p1]
    unfolding to_move_def legal_move_white_def
    by (auto split: split_if_asm)
next
  fix p0 p1
  assume *: "Position_KRK.legal_position p0" "to_move p0 = White" "\<not> WRcaptured p0" "strategy_white_move_rel' p0 p1"
  obtain t1 where "strategy_white_move_rel p0 p1 t1"
    using `strategy_white_move_rel' p0 p1`
    by (auto simp add: strategy_white_move_rel'_def)
  thus "\<not> WRcaptured p1"
    using * strategy_white_move_rel_notWRCaptured[of p0 p1 t1] legal_position[of p0]
    unfolding to_move_def
    by (simp split: split_if_asm)
next
  fix p0 p1 p2
  assume *: "Position_KRK.legal_position p0" "to_move p0 = White" "\<not> WRcaptured p0" "strategy_white_move_rel' p0 p1" "Position_KRK.legal_move p1 p2"
  obtain t1 where "strategy_white_move_rel p0 p1 t1"
    using `strategy_white_move_rel' p0 p1`
    by (auto simp add: strategy_white_move_rel'_def)
  thus "\<not> WRcaptured p2"
    using * strategy_white_move_rel_black_move_not_WRcaptured[of p0 p1 t1 p2] legal_position[of p0] legal_move_black[of p1 p2] strategy_white_move_rel_black_on_turn[of p0 p1 t1]
    unfolding to_move_def
    by (auto split: split_if_asm)
qed

definition "strategy_move_from moves p p' \<longleftrightarrow> 
   (WhiteOnTurn p \<and> (\<exists> t'. strategy_white_move_rel p p' t' \<and> t' \<in> moves)) \<or> 
   (BlackOnTurn p \<and> KRK.legal_move_BK p p')"

lemma strategy_move_from_all_moves:
  assumes "\<not> WRcaptured p" "legal_position p"
  shows "strategy_move_from all_moves p p' = Strategy_KRK.strategy_move p p'"
using strategy_white_move_rel_moves[of p p']
unfolding strategy_move_from_def Strategy_KRK.strategy_move_def all_moves_def basic_mate_moves_def basic_moves_def
by (auto simp add: to_move_def legal_move_BK_legal_move legal_move_black strategy_white_move_rel'_def)

lemma strategy_move_from_white:
  assumes "strategy_move_from M p p'" "WhiteOnTurn p"
  shows "\<exists> t \<in> M. strategy_white_move_rel p p' t"
using assms
unfolding strategy_move_from_def
by auto

lemma strategy_move_from_black:
  assumes "strategy_move_from M p p'" "BlackOnTurn p"
  shows "KRK.legal_move_BK p p'"
using assms
unfolding strategy_move_from_def
by auto

lemma strategy_move_from_legal_move:
  assumes p0: "WhiteOnTurn p0" "\<not> WRcaptured p0" "legal_position p0" and
  "strategy_move_from M p0 p1" "Position_KRK.legal_move p1 p2"
  shows "\<exists> t \<in> M. strategy_white_move_rel p0 p1 t \<and> KRK.legal_move_BK p1 p2 \<and> BlackOnTurn p1"
using assms
using strategy_white_move_rel_black_on_turn strategy_move_from_white[OF `strategy_move_from M p0 p1`]
using  legal_move_black[OF `Position_KRK.legal_move p1 p2`]
unfolding to_move_def
by auto

definition three_moves_before where
  "three_moves_before p \<longleftrightarrow> 
     (\<exists> p1 p1' t1 p2 p2' t2 p3 p3' t3. 
          WhiteOnTurn p1 \<and> \<not> WRcaptured p1 \<and> legal_position p1 \<and>
          strategy_white_move_rel p1 p1' t1 \<and> legal_move_BK p1' p2 \<and>
          strategy_white_move_rel p2 p2' t2 \<and> legal_move_BK p2' p3 \<and>
          strategy_white_move_rel p3 p3' t3 \<and> legal_move_BK p3' p)" 

lemma three_moves_before_step:
  assumes "three_moves_before p" "strategy_white_move_rel p p' t" "legal_move_BK p' p1"
  shows "three_moves_before p1"
using assms
unfolding three_moves_before_def
by auto (metis strategy_white_move_rel_black_move_not_WRcaptured strategy_white_move_rel_legal_position(1) strategy_white_move_rel_white_on_turn)

lemma three_moves_before_basic_mate_moves:
  assumes "three_moves_before p"  "strategy_white_move_rel p p' t"
  shows "t \<in> basic_mate_moves"
using assms
using strategy_white_move_rel_moves[of p p' t] first_three_moves[rule_format]
unfolding three_moves_before_def basic_mate_moves_def basic_moves_def
by auto smt+

lemma three_moves_before_WhiteOnTurn:
  assumes "three_moves_before p0" 
  shows "WhiteOnTurn p0"
using assms
unfolding three_moves_before_def
by (metis legal_move_BK_white_on_turn)

lemma play_basic_mate_moves':
  assumes 
  "p \<in> Strategy_KRK.strategy_play p0"
  "three_moves_before p0"
  shows "(WhiteOnTurn p \<and> strategy_white_move_rel p p' t' \<longrightarrow> three_moves_before p \<and> t' \<in> basic_mate_moves) \<and>
         (BlackOnTurn p \<longrightarrow> (\<exists> py t. three_moves_before py \<and> strategy_white_move_rel py p t))"
using assms
proof (induct arbitrary: p' t' rule: Strategy_KRK.strategy_play.induct)
  case (step px px')
  show ?case
  proof (cases "WhiteOnTurn px'")
    case True
    thus ?thesis
      using step
      unfolding Strategy_KRK.strategy_move_def strategy_white_move_rel'_def
      apply (auto simp add: to_move_def strategy_white_move_rel_black_on_turn split: split_if_asm)
      using three_moves_before_step
      apply (metis legal_move_black strategy_white_move_rel_black_on_turn to_move_def)
      apply (rule three_moves_before_basic_mate_moves)
      apply auto
      by (metis legal_move_black strategy_white_move_rel_black_on_turn three_moves_before_step to_move_def)
  next
    case False
    thus ?thesis
      using step
      unfolding Strategy_KRK.strategy_move_def strategy_white_move_rel'_def
      by (auto simp add: to_move_def strategy_white_move_rel_black_on_turn Position_KRK.legal_move_def split: split_if_asm)
  qed
next
  case init
  thus ?case
    using three_moves_before_basic_mate_moves
    by (auto simp add: three_moves_before_WhiteOnTurn)
qed

lemma play_basic_mate_moves:
  assumes 
  "p \<in> Strategy_KRK.strategy_play p0"
  "three_moves_before p0"
  "WhiteOnTurn p" "strategy_white_move_rel p p' t'"
  shows "t' \<in> basic_mate_moves"
using play_basic_mate_moves' assms
by auto


definition lessint :: "(int \<times> int) set" where "lessint = {(a, b). a \<ge> 0 \<and> b \<ge> 0 \<and> a < b}"

lemma wf_lessint: "wf lessint"
by (rule wf_subset[OF wf_measure[of "nat"]]) (auto simp add: lessint_def measure_def)

definition lessbool where "lessbool = {(False, True)}"

lemma wf_lessbool: "wf lessbool"
unfolding lessbool_def
by simp

definition lexless where "lexless = lessbool <*lex*> lessint <*lex*> lessint"

lemma wf_lexlessint: "wf lexless"
unfolding lexless_def
by (metis wf_lex_prod wf_lessint wf_lessbool)

definition msr where "msr p = (KRKStrategy.WR_exposed p, KRKStrategy.room p, KRKStrategy.mdcs p)"

lemma room_geq_0:
  assumes "legal_position p"
  shows "KRKStrategy.room p \<ge> 0"
using assms
unfolding legal_position_def
by (cases "WR p", cases "BK p") (auto simp add: room' KRK.all_on_board_def board_def)

lemma [simp]: "KRKStrategy.mdcs p \<ge> 0"
unfolding KRKStrategy.mdcs_def
by (smt manhattan_dist.simps manhattan_dist_cases prod.exhaust surj_pair)

definition play_room_gt3 where
  "play_room_gt3 = {(p'', p). WhiteOnTurn p \<and> \<not> WRcaptured p \<and> legal_position p \<and> (WR_exposed p \<or> KRKStrategy.room p > 3) \<and> 
                              (\<exists> p'. strategy_move_from basic_moves p p' \<and> KRK.legal_move_BK p' p'')}"

lemma play_room_gt3: "play_room_gt3 ^^ 3 \<subseteq> inv_image lexless msr"
unfolding inv_image_def lexless_def msr_def lessint_def lessbool_def
proof safe
  fix p p'
  assume "(p', p) \<in> play_room_gt3 ^^ 3"
  then obtain p1 p2 where
    *: "(p1, p) \<in> play_room_gt3" "(p2, p1) \<in> play_room_gt3" "(p', p2) \<in> play_room_gt3"
    by (smt relpow_fun_conv)

  show "((WR_exposed p', KRKStrategy.room p', KRKStrategy.mdcs p'), (WR_exposed p, KRKStrategy.room p, KRKStrategy.mdcs p))
          \<in> {(False, True)} <*lex*> {(a, b). 0 \<le> a \<and> 0 \<le> b \<and> a < b} <*lex*> {(a, b). 0 \<le> a \<and> 0 \<le> b \<and> a < b}"
  proof-
    from `(p1, p) \<in> play_room_gt3`
    obtain p1' t1 where "t1 \<in> basic_moves" "strategy_white_move_rel p p1' t1" "BlackOnTurn p1'" "KRK.legal_move_BK p1' p1" "WhiteOnTurn p1"
      using strategy_move_from_white[of basic_moves p] strategy_white_move_rel_black_on_turn[of p] legal_move_BK_white_on_turn
      unfolding play_room_gt3_def
      by blast
    moreover
    from `(p2, p1) \<in> play_room_gt3`
    obtain p2' t2 where "t2 \<in> basic_moves" "strategy_white_move_rel p1 p2' t2" "BlackOnTurn p2'" "KRK.legal_move_BK p2' p2" "WhiteOnTurn p2"
      using strategy_move_from_white[of basic_moves p1]  strategy_white_move_rel_black_on_turn[of p1] legal_move_BK_white_on_turn
      unfolding play_room_gt3_def
      by blast
    moreover
    from `(p', p2) \<in> play_room_gt3`
    obtain p3' t3 where "t3 \<in> basic_moves" "strategy_white_move_rel p2 p3' t3" "BlackOnTurn p3'" "KRK.legal_move_BK p3' p'" "WhiteOnTurn p'"
      using strategy_move_from_white[of basic_moves p2]  strategy_white_move_rel_black_on_turn[of p2] legal_move_BK_white_on_turn
      unfolding play_room_gt3_def
      by blast
    ultimately
    have "3 \<le> room' (WR p') (BK p') \<and>
        \<not> WR_exposed p' \<and> (room p' < room p \<or> room p' = room p \<and> mdcs p' <mdcs p)"
      using basic_moves_3[rule_format, of p p1' t1 p1 p2' t2 p2 p3' t3 p'] *
      by (simp add: play_room_gt3_def basic_moves_def) blast
    thus ?thesis
      by auto
  qed
qed

lemma wf_play_room_gt3: "wf play_room_gt3"
proof(rule wf_exp)
  show "wf (play_room_gt3 ^^ 3)"
    using wf_subset[of "inv_image lexless msr" "play_room_gt3 ^^ 3"]
    using wf_inv_image[of lexlessint msr] play_room_gt3 wf_lexlessint
    by auto
qed

interpretation WinningStrategy' KRK.invar KRK.to_move "strategy_white_move_rel'" "\<lambda> p. \<not> WRcaptured p" KRK.on_square "\<lambda> p0. Position_KRK.legal_position p0 \<and> to_move p0 = White \<and> \<not> WRcaptured p0" "\<lambda> p0. {(p'', p). to_move p = White \<and> p \<in> Strategy_KRK.strategy_play p0 \<and> (\<exists> p'. strategy_white_move_rel' p p' \<and> Position_KRK.legal_move p' p'')}"
proof
  fix p0
  assume "Position_KRK.legal_position p0 \<and> to_move p0 = White \<and> \<not> WRcaptured p0"
  thus "to_move p0 = White \<and> \<not> WRcaptured p0 \<and> Position_KRK.legal_position p0"
    by simp
next
  fix p0 p p' p''
  assume "Position_KRK.legal_position p0 \<and> to_move p0 = White \<and> \<not> WRcaptured p0"
         "p \<in> Strategy_KRK.strategy_play p0" "strategy_white_move_rel' p p'" "to_move p = White"
         "Position_KRK.legal_move p' p''"
  thus "(p'', p) \<in> {(p'', p). to_move p = White \<and> p \<in> Strategy_KRK.strategy_play  p0 \<and> (\<exists>p'. strategy_white_move_rel' p p' \<and> Position_KRK.legal_move p' p'')}"
    by auto
next
  fix p0
  assume p0: "Position.legal_position to_move on_square KRK.invar p0 \<and> to_move p0 = White \<and> \<not> WRcaptured p0"
  let ?R = "{(p'', p). to_move p = White \<and> p \<in> Strategy_KRK.strategy_play p0 \<and> (\<exists>p'. strategy_white_move_rel' p p' \<and> Position_KRK.legal_move p' p'')}"
  show "wf ?R"
  proof (rule ccontr)
    assume "\<not> ?thesis"
    then obtain Q px where "px \<in> Q" and *: "\<forall>p\<in>Q. to_move p = White \<and> p \<in> Strategy_KRK.strategy_play p0 \<and> (\<exists> p' p''. strategy_white_move_rel' p p' \<and> Position_KRK.legal_move p' p'' \<and> p'' \<in> Q)"
      unfolding wf_eq_minimal
      by force
    (* There cannot be a mate move in the chain (otherwise it would finish) *)
    have *: "\<forall>p \<in> Q. WhiteOnTurn p \<and> p \<in> Strategy_KRK.strategy_play p0 \<and> (\<exists>p' p''. strategy_move_from no_mate_moves p p' \<and> Position_KRK.legal_move p' p'' \<and> p'' \<in> Q)"
    proof (safe)
      fix p
      assume "p \<in> Q"
      show "p \<in> Strategy_KRK.strategy_play p0"
        using * `p \<in> Q`
        by simp

      obtain p' p'' where "strategy_white_move_rel' p p'" "Position_KRK.legal_move p' p''" "p'' \<in> Q"
        using * `p \<in> Q`
        by auto

      then obtain t where "strategy_white_move_rel p p' t"
        by (auto simp add: strategy_white_move_rel'_def)
      note ** = this `Position_KRK.legal_move p' p''`

      have p: "WhiteOnTurn p" "\<not> WRcaptured p" "legal_position p"
        using * `p \<in> Q`
        using Strategy_KRK.strategy_play[OF `p \<in> Strategy_KRK.strategy_play p0`] p0
        by (auto simp add: to_move_def legal_position split: split_if_asm)

      have "p'' \<in> Strategy_KRK.strategy_play p0"
        using * `p'' \<in> Q`
        by auto

      have p1: "WhiteOnTurn p''" "\<not> WRcaptured p''" "legal_position p''"
        using * `p'' \<in> Q`
        using Strategy_KRK.strategy_play[OF `p'' \<in> Strategy_KRK.strategy_play p0`] p0
        by (auto simp add: to_move_def legal_position split: split_if_asm)

      show "WhiteOnTurn p"
        by fact

      have "to_move p' = Black"
        using **(1) p
        by (metis strategy_white_move_rel_black_on_turn to_move_def)

      have "strategy_move_from no_mate_moves p p'"
      proof-
        have "t \<in> no_mate_moves"
        proof (rule ccontr)
          assume "\<not> ?thesis"
          hence "t = ReadyToMateMove \<or> t = ImmediateMateMove"
            using strategy_white_move_rel_moves[OF **(1)]
            by (auto simp add: no_mate_moves_def basic_moves_def)
          thus False
          proof
            assume "t = ImmediateMateMove"
            thus False
              using ImmediateMateMove_no_legal_move_BK[OF p(2) **(1), of p'']
              using legal_move_black[OF **(2) `to_move p' = Black`]
              by auto
          next
            assume "t = ReadyToMateMove"
            obtain p1' p1'' where  "strategy_white_move_rel' p'' p1'" "Position_KRK.legal_move p1' p1''" "p1'' \<in> Q"
              using * `p'' \<in> Q`
              by auto
            then obtain t1 where "strategy_white_move_rel p'' p1' t1"
              by (auto simp add: strategy_white_move_rel'_def)
            note *** = this `Position_KRK.legal_move p1' p1''`

            have "to_move p1' = Black"
              using ***(1) p1
              by (metis strategy_white_move_rel_black_on_turn to_move_def)
              
            show False
              using `t = ReadyToMateMove` ReadyToMateMove_no_legal_move_BK[OF p(2) **(1) _ ***(1), of p1'']
              using legal_move_black[OF **(2) `to_move p' = Black`] legal_move_black[OF ***(2) `to_move p1' = Black`]
              by auto
          qed
        qed
        thus ?thesis
          using p **
          unfolding strategy_move_from_def
          by auto
      qed
      thus "\<exists>p' p''. strategy_move_from no_mate_moves p p' \<and> Position_KRK.legal_move p' p'' \<and> p'' \<in> Q"
        using `p'' \<in> Q` `Position_KRK.legal_move p' p''`
        by auto
    qed


   (* From some point on, only basic moves are performed (as rook moves are performed only as the first three moves) *)
    have "\<exists> p0' \<in> Q. (\<forall> p \<in> Strategy_KRK.strategy_play p0' \<inter> Q. (\<exists>p' p''. strategy_move_from basic_moves p p' \<and> Position_KRK.legal_move p' p'' \<and> p'' \<in> Q))"
    proof-
      have px: "WhiteOnTurn px" "\<not> WRcaptured px" "legal_position px"
        using * `px \<in> Q`
        using Strategy_KRK.strategy_play p0
        by (auto simp add: to_move_def legal_position split: split_if_asm)
      obtain p1' t1 p1 where t1: "p1 \<in> Q" "strategy_white_move_rel px p1' t1" "KRK.legal_move_BK p1' p1"
        using strategy_move_from_legal_move[OF px, of no_mate_moves] *[rule_format, OF `px \<in> Q`]
        by blast
      have p1: "WhiteOnTurn p1" "\<not> WRcaptured p1" "legal_position p1"
        using * `p1 \<in> Q`
        using Strategy_KRK.strategy_play p0
        by (auto simp add: to_move_def legal_position split: split_if_asm)
      obtain p2' t2 p2 where t2: "p2 \<in> Q" "strategy_white_move_rel p1 p2' t2" "KRK.legal_move_BK p2' p2"
        using strategy_move_from_legal_move[OF p1, of no_mate_moves] *[rule_format, OF `p1 \<in> Q`]
        by blast
      have p2: "WhiteOnTurn p2" "\<not> WRcaptured p2" "legal_position p2"
        using * `p2 \<in> Q`
        using Strategy_KRK.strategy_play p0
        by (auto simp add: to_move_def legal_position split: split_if_asm)
      obtain p3' t3 p3 where t3: "p3 \<in> Q" "strategy_white_move_rel p2 p3' t3" "KRK.legal_move_BK p3' p3"
        using strategy_move_from_legal_move[OF p2, of no_mate_moves] *[rule_format, OF `p2 \<in> Q`]
        by blast
      have p3: "WhiteOnTurn p3" "\<not> WRcaptured p3" "legal_position p3"
        using * `p3 \<in> Q`
        using Strategy_KRK.strategy_play p0
        by (auto simp add: to_move_def legal_position split: split_if_asm)

      show ?thesis
      proof (rule_tac x="p3" in bexI, safe)
        fix p
        assume "p \<in> Strategy_KRK.strategy_play p3" "p \<in> Q"
        show "\<exists> p' p''. strategy_move_from basic_moves p p' \<and> Position_KRK.legal_move p' p'' \<and> p'' \<in> Q"
        proof-
          obtain p' p'' where "strategy_move_from no_mate_moves p p'" "Position_KRK.legal_move p' p''" "p'' \<in> Q"
            using * `p \<in> Q`
            by auto
          then obtain t where "strategy_white_move_rel p p' t" "t \<in> no_mate_moves"
            using `p \<in> Q` *
            unfolding strategy_move_from_def
            by auto

          obtain t4 p4' where "strategy_white_move_rel p3 p4' t4" "t4 \<in> no_mate_moves"
            using * `p3 \<in> Q`
            unfolding strategy_move_from_def
            by auto

          have "is_basic_move t4"
            using first_three_moves[rule_format, of px p1' t1 p1 p2' t2 p2 p3' t3 p3 p4' t4]
            using px(2) `strategy_white_move_rel px p1' t1` `legal_move_BK p1' p1`
                        `strategy_white_move_rel p1 p2' t2` `legal_move_BK p2' p2` 
                        `strategy_white_move_rel p2 p3' t3` `legal_move_BK p3' p3`
                        `strategy_white_move_rel p3 p4' t4`
            using `t4 \<in> no_mate_moves`
            by (auto simp add: no_mate_moves_def basic_moves_def)

          have "WhiteOnTurn p"
            by (metis "*" `p \<in> Q`)
          moreover
          have "three_moves_before p3"
            using px t1 t2 t3
            unfolding three_moves_before_def
            by metis
          ultimately
          have "t \<in> basic_moves"
            using play_basic_mate_moves[OF `p \<in> Strategy_KRK.strategy_play p3` _ _  `strategy_white_move_rel p p' t`]
            using `t \<in> no_mate_moves`
            by (auto simp add: basic_mate_moves_def no_mate_moves_def)
          hence "strategy_move_from basic_moves p p'" 
            using  `strategy_white_move_rel p p' t` `p \<in> Q` *
            unfolding strategy_move_from_def
            by auto
          thus ?thesis
            using `Position_KRK.legal_move p' p''` `p'' \<in> Q`
            by auto
        qed
      next
        show "p3 \<in> Q"
          by fact
      qed
    qed
    then obtain p0' where "p0' \<in> Q" and **: "\<forall> p \<in> Strategy_KRK.strategy_play p0' \<inter> Q. \<exists> p' p''. strategy_move_from basic_moves p p' \<and> Position_KRK.legal_move p' p'' \<and> p'' \<in> Q"
      by auto

    have "\<exists> p \<in> Strategy_KRK.strategy_play p0' \<inter> Q. KRKStrategy.room p \<le> 3 \<and> \<not> WR_exposed p"
    proof-
      have "p0' \<in> Strategy_KRK.strategy_play p0' \<inter> Q"
        using `p0' \<in> Q`
        by (simp add: Strategy_KRK.strategy_play.init)
      then obtain pmin where "pmin \<in> Strategy_KRK.strategy_play p0' \<inter> Q" "\<forall>p. (p, pmin) \<in> play_room_gt3 \<longrightarrow> p \<notin> Strategy_KRK.strategy_play p0' \<inter> Q"
        using wf_play_room_gt3
        unfolding wf_eq_minimal
        by metis
      hence "pmin \<in> Strategy_KRK.strategy_play p0'" "pmin \<in> Q"
        by auto
      obtain pmin' pmin'' where ++: "strategy_move_from basic_moves pmin pmin'" "Position_KRK.legal_move pmin' pmin''" "pmin'' \<in> Q"
        using **[rule_format, OF `pmin \<in> Strategy_KRK.strategy_play p0' \<inter> Q`]
        by auto

      have pmin: "WhiteOnTurn pmin" "\<not> WRcaptured pmin" "legal_position pmin"
        using * `pmin \<in> Q`
        using Strategy_KRK.strategy_play p0
        by (auto simp add: to_move_def legal_position split: split_if_asm)

      obtain t where "strategy_white_move_rel pmin pmin' t" "KRK.legal_move_BK pmin' pmin''" "BlackOnTurn pmin'"
        using strategy_move_from_legal_move[OF pmin ++(1-2)]
        by auto

      have "Strategy_KRK.strategy_move pmin pmin'" "Strategy_KRK.strategy_move pmin' pmin''"
        using `strategy_move_from basic_moves pmin pmin'` `Position_KRK.legal_move pmin' pmin''` pmin `BlackOnTurn pmin'`
        unfolding strategy_move_from_def Strategy_KRK.strategy_move_def to_move_def
        by (auto simp add: strategy_white_move_rel'_def)

      hence "pmin'' \<in> Strategy_KRK.strategy_play p0' \<inter> Q"
        using `pmin \<in> Strategy_KRK.strategy_play p0' \<inter> Q` `pmin'' \<in> Q`
        using Strategy_KRK.strategy_play.step[of pmin p0' pmin']
        using Strategy_KRK.strategy_play.step[of pmin' p0' pmin'']
        by auto

      hence "(pmin'', pmin) \<notin> play_room_gt3"
        using `\<forall>p. (p, pmin) \<in> play_room_gt3 \<longrightarrow> p \<notin> Strategy_KRK.strategy_play p0' \<inter> Q`
        by auto

      hence "KRKStrategy.room pmin \<le> 3 \<and> \<not> WR_exposed pmin"
        using pmin `strategy_move_from basic_moves pmin pmin'` `KRK.legal_move_BK pmin' pmin''`
        unfolding play_room_gt3_def
        by auto
      thus ?thesis
        using `pmin \<in> Strategy_KRK.strategy_play p0' \<inter> Q`
        by auto
    qed
    then obtain p0'' where "p0'' \<in> Q" "p0'' \<in> Strategy_KRK.strategy_play p0'" "KRKStrategy.room p0'' \<le> 3" "\<not> WR_exposed p0''"
      by auto

    have p0'': "WhiteOnTurn p0''" "\<not> WRcaptured p0''" "legal_position p0''"
      using * `p0'' \<in> Q`
      using Strategy_KRK.strategy_play p0
      by (auto simp add: to_move_def legal_position split: split_if_asm)
    obtain p1' t1 p1 where  "strategy_white_move_rel p0'' p1' t1" "is_basic_move t1" "KRK.legal_move_BK p1' p1" "BlackOnTurn p1'" "p1 \<in> Q"
      using `p0'' \<in> Q` `p0'' \<in> Strategy_KRK.strategy_play p0'` **[rule_format, of p0'']
      using strategy_move_from_legal_move[OF p0'', of basic_moves]
      unfolding basic_moves_def
      by blast
    moreover
    have p1: "WhiteOnTurn p1" "\<not> WRcaptured p1" "legal_position p1"
      using * `p1 \<in> Q`
      using Strategy_KRK.strategy_play p0
      by (auto simp add: to_move_def legal_position split: split_if_asm)
    have "p1 \<in> Strategy_KRK.strategy_play p0'"
      using Strategy_KRK.strategy_play.step[OF `p0'' \<in> Strategy_KRK.strategy_play p0'`, of p1']
      using Strategy_KRK.strategy_play.step[of p1' p0' p1]
      using `WhiteOnTurn p0''` `strategy_white_move_rel p0'' p1' t1` `KRK.legal_move_BK p1' p1` `BlackOnTurn p1'`
      unfolding Strategy_KRK.strategy_move_def to_move_def
      by (auto simp add:  legal_move_BK_legal_move strategy_white_move_rel'_def)
    obtain p2' t2 p2 where "strategy_white_move_rel p1 p2' t2" "is_basic_move t2" "KRK.legal_move_BK p2' p2" "p2 \<in> Q" "BlackOnTurn p2'"
      using `p1 \<in> Q` `p1 \<in> Strategy_KRK.strategy_play p0'` **[rule_format, of p1]
      using strategy_move_from_legal_move[OF p1, of basic_moves]
      unfolding basic_moves_def
      by blast
    moreover
    have p2: "WhiteOnTurn p2" "\<not> WRcaptured p2" "legal_position p2"
      using * `p2 \<in> Q`
      using Strategy_KRK.strategy_play p0
      by (auto simp add: to_move_def legal_position split: split_if_asm)
    have "p2 \<in> Strategy_KRK.strategy_play p0'"
      using Strategy_KRK.strategy_play.step[OF `p1 \<in> Strategy_KRK.strategy_play p0'`, of p2']
      using Strategy_KRK.strategy_play.step[of p2' p0' p2]
      using `WhiteOnTurn p1` `strategy_white_move_rel p1 p2' t2` `KRK.legal_move_BK p2' p2` `BlackOnTurn p2'`
      unfolding Strategy_KRK.strategy_move_def to_move_def
      by (auto simp add: legal_move_BK_legal_move strategy_white_move_rel'_def)
    obtain p3' t3 p3 where "strategy_white_move_rel p2 p3' t3" "is_basic_move t3" "KRK.legal_move_BK p3' p3" "p3 \<in> Q" "BlackOnTurn p3'"
      using `p2 \<in> Q` `p2 \<in> Strategy_KRK.strategy_play p0'` **[rule_format, of p2]
      using strategy_move_from_legal_move[OF p2, of basic_moves]
      unfolding basic_moves_def
      by blast
    moreover 
    have p3: "WhiteOnTurn p3" "\<not> WRcaptured p3" "legal_position p3"
      using * `p3 \<in> Q`
      using Strategy_KRK.strategy_play p0
      by (auto simp add: to_move_def legal_position split: split_if_asm)
    have "p3 \<in> Strategy_KRK.strategy_play p0'"
      using Strategy_KRK.strategy_play.step[OF `p2 \<in> Strategy_KRK.strategy_play p0'`, of p3']
      using Strategy_KRK.strategy_play.step[of p3' p0' p3]
      using `WhiteOnTurn p2` `strategy_white_move_rel p2 p3' t3` `KRK.legal_move_BK p3' p3` `BlackOnTurn p3'`
      unfolding Strategy_KRK.strategy_move_def to_move_def
      by (auto simp add: legal_move_BK_legal_move strategy_white_move_rel'_def)
    obtain p4' t4 p4 where "strategy_white_move_rel p3 p4' t4" "is_basic_move t4" "KRK.legal_move_BK p4' p4" "p4 \<in> Q" "BlackOnTurn p4'"
      using `p3 \<in> Q` `p3 \<in> Strategy_KRK.strategy_play p0'` **[rule_format, of p3]
      using strategy_move_from_legal_move[OF p3, of basic_moves]
      unfolding basic_moves_def
      by blast
    moreover
    have p4: "WhiteOnTurn p4" "\<not> WRcaptured p4" "legal_position p4"
      using * `p4 \<in> Q`
      using Strategy_KRK.strategy_play p0
      by (auto simp add: to_move_def legal_position split: split_if_asm)
    have "p4 \<in> Strategy_KRK.strategy_play p0'"
      using Strategy_KRK.strategy_play.step[OF `p3 \<in> Strategy_KRK.strategy_play p0'`, of p4']
      using Strategy_KRK.strategy_play.step[of p4' p0' p4]
      using `WhiteOnTurn p3` `strategy_white_move_rel p3 p4' t4` `KRK.legal_move_BK p4' p4` `BlackOnTurn p4'`
      unfolding Strategy_KRK.strategy_move_def to_move_def
      by (auto simp add:  legal_move_BK_legal_move strategy_white_move_rel'_def)
    obtain p5' t5 where "strategy_white_move_rel p4 p5' t5" "is_basic_move t5"
      using `p4 \<in> Q` `p4 \<in> Strategy_KRK.strategy_play p0'` **[rule_format, of p4]
      using strategy_move_from_legal_move[OF p4, of basic_moves]
      unfolding basic_moves_def
      by blast
    ultimately
    show False
      using room_leq_3_checkmate_in_5_moves[rule_format, of p0'' t1 p1' p1 p2' t2 p2 p3' t3 p3 p4' t4 p4 p5' t5] p0'' `room p0'' \<le> 3` `\<not> WR_exposed p0''`
      by auto
  qed
next
  fix p0 p p'
  assume *: "Position_KRK.legal_position p0 \<and> to_move p0 = White \<and> \<not> WRcaptured p0" "p \<in> Strategy_KRK.strategy_play p0" "to_move p = White"
  "strategy_white_move_rel' p p'"
  thus "\<not> Position_KRK.stalemate p'"
    using strategy_white_move_rel_not_stalemate[of p p']
    using Strategy_KRK.strategy_play_legal[of p p0] Strategy_KRK.strategy_play_invar[of p p0] files_ranks_geq6
    unfolding to_move_def
    by (auto simp add: KRK.stalemate legal_position strategy_white_move_rel'_def split: split_if_asm)
next
  fix p0 p
  assume "Position_KRK.legal_position p0 \<and> to_move p0 = White \<and> \<not> WRcaptured p0" "p \<in> Strategy_KRK.strategy_play p0" "to_move p = White"
  thus "\<exists>p'. strategy_white_move_rel' p p'"
    using strategy_white_move_rel_exists[of p]
    using Strategy_KRK.strategy_play_legal[of p p0] Strategy_KRK.strategy_play_invar[of p p0]
    unfolding to_move_def
    by (auto simp add: legal_position strategy_white_move_rel'_def split: split_if_asm)
qed

end
