theory KRKSymmetry
imports KRKStrategy
begin
(* -------------------------------------------------------------------------- *)

lemma reflectx_same_diag [simp]: "same_diag (reflectx sq1) (reflectx sq2) \<longleftrightarrow> same_diag sq1 sq2"
by (cases sq1, cases sq2, simp add: same_diag_def same_diag1_def same_diag2_def) smt
lemma reflecty_same_diag [simp]: "same_diag (reflecty sq1) (reflecty sq2) \<longleftrightarrow> same_diag sq1 sq2"
by (cases sq1, cases sq2, simp add: same_diag_def same_diag1_def same_diag2_def) smt
lemma reflectdiag_same_diag [simp]: "same_diag (reflectdiag sq1) (reflectdiag sq2) \<longleftrightarrow> same_diag sq1 sq2"
by (cases sq1, cases sq2, simp add: same_diag_def same_diag1_def same_diag2_def) smt

lemma reflectx_moveWK [simp]: "moveWK (reflectx_p p) (reflectx sq) = reflectx_p (moveWK p sq)"
  by (rule moveWK_eqI[symmetric]) (simp_all add: reflect_p_def reflectx_p_def)
lemma reflecty_moveWK [simp]: "moveWK (reflecty_p p) (reflecty sq) = reflecty_p (moveWK p sq)"
  by (rule moveWK_eqI[symmetric]) (simp_all add: reflect_p_def reflecty_p_def)
lemma reflectdiag_moveWK [simp]: "moveWK (reflectdiag_p p) (reflectdiag sq) = reflectdiag_p (moveWK p sq)"
  by (rule moveWK_eqI[symmetric]) (simp_all add: reflect_p_def reflectdiag_p_def)

lemma reflectx_moveBK [simp]: "moveBK (reflectx_p p) (reflectx sq) = reflectx_p (moveBK p sq)"
proof (rule moveBK_eqI[symmetric])
  show "WRopt (reflectx_p (moveBK p sq)) =
       (if reflectx sq = WR (reflectx_p p) then None else WRopt (reflectx_p p))"
    by (cases "WRopt p") (auto simp add: WR_def moveBK_def Let_def reflect_p_def reflectx_p_def, force simp add: reflectx_inj)
qed simp_all

lemma reflecty_moveBK [simp]: "moveBK (reflecty_p p) (reflecty sq) = reflecty_p (moveBK p sq)"
proof (rule moveBK_eqI[symmetric])
  show "WRopt (reflecty_p (moveBK p sq)) =
       (if reflecty sq = WR (reflecty_p p) then None else WRopt (reflecty_p p))"
    by (cases "WRopt p") (auto simp add: WR_def moveBK_def Let_def reflect_p_def reflecty_p_def, force simp add: reflecty_inj)
qed simp_all

lemma reflectdiag_moveBK [simp]: "moveBK (reflectdiag_p p) (reflectdiag sq) = reflectdiag_p (moveBK p sq)"
proof (rule moveBK_eqI[symmetric])
  show "WRopt (reflectdiag_p (moveBK p sq)) =
       (if reflectdiag sq = WR (reflectdiag_p p) then None else WRopt (reflectdiag_p p))"
    by (cases "WRopt p") (auto simp add: WR_def moveBK_def Let_def reflect_p_def reflectdiag_p_def, force simp add: reflectdiag_inj)
qed simp_all

lemma reflectx_moveWR [simp]: "moveWR (reflectx_p p) (reflectx sq) = reflectx_p (moveWR p sq)"
  by (rule moveWR_eqI[symmetric]) (simp_all add: reflect_p_def reflectx_p_def)
lemma reflecty_moveWR [simp]: "moveWR (reflecty_p p) (reflecty sq) = reflecty_p (moveWR p sq)"
  by (rule moveWR_eqI[symmetric]) (simp_all add: reflect_p_def reflecty_p_def)
lemma reflectdiag_moveWR [simp]: "moveWR (reflectdiag_p p) (reflectdiag sq) = reflectdiag_p (moveWR p sq)"
  by (rule moveWR_eqI[symmetric]) (simp_all add: reflect_p_def reflectdiag_p_def)

lemma reflectx_invar [simp]: "KRK.invar (reflectx_p p) \<longleftrightarrow> KRK.invar p"
apply (cases "WRcaptured p")
unfolding KRK.invar_def
apply (simp add: WRcaptured_def reflect_p_def reflectx_p_def, force simp add: reflectx_inj)
apply (auto simp add: WRcaptured_def reflect_p_def reflectx_p_def, (force simp add: reflectx_inj)+)
done
lemma reflecty_invar [simp]: "KRK.invar (reflecty_p p) \<longleftrightarrow> KRK.invar p"
apply (cases "WRcaptured p")
unfolding KRK.invar_def
apply (simp add: WRcaptured_def reflect_p_def reflecty_p_def, force simp add: reflecty_inj)
apply (auto simp add: WRcaptured_def reflect_p_def reflecty_p_def, (force simp add: reflecty_inj)+)
done
lemma reflectdiag_invar [simp]: "KRK.invar (reflectdiag_p p) \<longleftrightarrow> KRK.invar p"
apply (cases "WRcaptured p")
unfolding KRK.invar_def
apply (simp add: WRcaptured_def reflect_p_def reflectdiag_p_def, force simp add: reflectdiag_inj)
apply (auto simp add: WRcaptured_def reflect_p_def reflectdiag_p_def, (force simp add: reflectdiag_inj)+)
done


lemma [simp]: "board (reflectx p) \<longleftrightarrow> board p"
  by (cases p) (auto simp add: board_def)
lemma [simp]: "board (reflecty p) \<longleftrightarrow> board p"
  by (cases p) (auto simp add: board_def)
lemma [simp]: "files = ranks \<Longrightarrow> board (reflectdiag p) \<longleftrightarrow> board p"
  by (cases p) (auto simp add: board_def)


lemma reflectx_all_on_board [simp]: "KRK.all_on_board (reflectx_p p) \<longleftrightarrow> KRK.all_on_board p"
unfolding KRK.all_on_board_def
by simp
lemma reflecty_all_on_board [simp]: "KRK.all_on_board (reflecty_p p) \<longleftrightarrow> KRK.all_on_board p"
unfolding KRK.all_on_board_def
by simp
lemma reflectdiag_all_on_board [simp]: "files = ranks \<Longrightarrow> KRK.all_on_board (reflectdiag_p p) \<longleftrightarrow> KRK.all_on_board p"
unfolding KRK.all_on_board_def
by simp


lemma reflectx_king_scope [simp]: "ChessRules.king_scope (reflectx sq1) (reflectx sq2) =
               ChessRules.king_scope sq1 sq2"
by (cases "sq1", cases "sq2") (auto simp add: ChessRules.king_scope_def file_diff_def rank_diff_def diff_def)
lemma reflecty_king_scope [simp]: "ChessRules.king_scope (reflecty sq1) (reflecty sq2) =
               ChessRules.king_scope sq1 sq2"
by (cases "sq1", cases "sq2") (auto simp add: ChessRules.king_scope_def file_diff_def rank_diff_def diff_def)
lemma reflectdiag_king_scope [simp]: "ChessRules.king_scope (reflectdiag sq1) (reflectdiag sq2) =
               ChessRules.king_scope sq1 sq2"
by (cases "sq1", cases "sq2") (simp add: ChessRules.king_scope_def file_diff_def rank_diff_def diff_def, smt)


lemma reflectx_kings_separated [simp]: "KRK.kings_separated (reflectx_p p) \<longleftrightarrow> KRK.kings_separated p"
unfolding KRK.kings_separated_def
by simp
lemma reflecty_kings_separated [simp]: "KRK.kings_separated (reflecty_p p) \<longleftrightarrow> KRK.kings_separated p"
unfolding KRK.kings_separated_def
by simp
lemma reflectdiag_kings_separated [simp]: "KRK.kings_separated (reflectdiag_p p) \<longleftrightarrow> KRK.kings_separated p"
unfolding KRK.kings_separated_def
by simp


lemma reflectx_rook_scope [simp]: "rook_scope (reflectx a) (reflectx b) \<longleftrightarrow> rook_scope a b"
  by (cases a, cases b) (simp add: rook_scope_def same_file_def same_rank_def)
lemma reflecty_rook_scope [simp]: "rook_scope (reflecty a) (reflecty b) \<longleftrightarrow> rook_scope a b"
  by (cases a, cases b) (simp add: rook_scope_def same_file_def same_rank_def)
lemma reflectdiag_rook_scope [simp]: "rook_scope (reflectdiag a) (reflectdiag b) \<longleftrightarrow> rook_scope a b"
  by (cases a, cases b) (auto simp add: rook_scope_def same_file_def same_rank_def)


lemma reflectx_square_between [simp]: "square_between (reflectx a) (reflectx b) (reflectx c) \<longleftrightarrow> square_between a b c"
by (cases a, cases b, cases c) (simp add: square_between_def same_rank_def same_file_def same_diag1_def same_diag2_def between_def, smt)
lemma reflecty_square_between [simp]: "square_between (reflecty a) (reflecty b) (reflecty c) \<longleftrightarrow> square_between a b c"
by (cases a, cases b, cases c) (simp add: square_between_def same_rank_def same_file_def same_diag1_def same_diag2_def between_def, smt)
lemma reflectdiag_square_between [simp]: "square_between (reflectdiag a) (reflectdiag b) (reflectdiag c) \<longleftrightarrow> square_between a b c"
by (cases a, cases b, cases c) (simp add: square_between_def same_rank_def same_file_def same_diag1_def same_diag2_def between_def, smt)

lemma reflectx_WR_attacks_nobk [simp]: "WR_attacks_nobk (reflectx_p p) (reflectx sq) \<longleftrightarrow> WR_attacks_nobk p sq"
unfolding KRK.WR_attacks_nobk_def
by auto
lemma reflecty_WR_attacks_nobk [simp]: "WR_attacks_nobk (reflecty_p p) (reflecty sq) \<longleftrightarrow> WR_attacks_nobk p sq"
unfolding KRK.WR_attacks_nobk_def
by auto
lemma reflectdiag_WR_attacks_nobk [simp]: "WR_attacks_nobk (reflectdiag_p p) (reflectdiag sq) \<longleftrightarrow> WR_attacks_nobk p sq"
unfolding KRK.WR_attacks_nobk_def
by auto

lemma reflectx_WR_attacks_BK [simp]: "WR_attacks_BK (reflectx_p p) \<longleftrightarrow> WR_attacks_BK p"
unfolding WR_attacks_BK_def
unfolding KRK.WR_attacks_nobk_def
by auto
lemma reflecty_WR_attacks_BK [simp]: "WR_attacks_BK (reflecty_p p) \<longleftrightarrow> WR_attacks_BK p"
unfolding WR_attacks_BK_def
unfolding KRK.WR_attacks_nobk_def
by auto
lemma reflectdiag_WR_attacks_BK [simp]: "WR_attacks_BK (reflectdiag_p p) \<longleftrightarrow> WR_attacks_BK p"
unfolding WR_attacks_BK_def
unfolding KRK.WR_attacks_nobk_def
by auto


lemma reflectx_legal_position [simp]: "legal_position (reflectx_p p) \<longleftrightarrow> legal_position p"
unfolding legal_position_def
by (auto simp del: WR_attacks_BK_def)
lemma reflecty_legal_position [simp]: "legal_position (reflecty_p p) \<longleftrightarrow> legal_position p"
unfolding legal_position_def
by (auto simp del: WR_attacks_BK_def)
lemma reflectdiag_legal_position [simp]: "files = ranks \<Longrightarrow> legal_position (reflectdiag_p p) \<longleftrightarrow> legal_position p"
unfolding legal_position_def
by (auto simp del: WR_attacks_BK_def)


lemma reflectx_WK_can_move_to [simp]: "WK_can_move_to (reflectx_p p) (reflectx sq) \<longleftrightarrow> WK_can_move_to p sq"
unfolding KRK.WK_can_move_to_def
by simp (force simp add: reflectx_inj)
lemma reflecty_WK_can_move_to [simp]: "WK_can_move_to (reflecty_p p) (reflecty sq) \<longleftrightarrow> WK_can_move_to p sq"
unfolding KRK.WK_can_move_to_def
by simp (force simp add: reflecty_inj)
lemma reflectdiag_WK_can_move_to [simp]: "files = ranks \<Longrightarrow> WK_can_move_to (reflectdiag_p p) (reflectdiag sq) \<longleftrightarrow> WK_can_move_to p sq"
unfolding KRK.WK_can_move_to_def
by simp (force simp add: reflectdiag_inj)

lemma rooks_square_reflectx [simp]:
  "\<And> i. 1 \<le> i \<and> i \<le> files \<Longrightarrow> rooks_square (reflectx sq) i = rooks_square sq i"
  "\<And> i. files + 1 \<le> i \<and> i \<le> files + ranks \<Longrightarrow> rooks_square (reflectx sq) i = reflectx (rooks_square sq i)"
by (case_tac[!] sq, simp_all add: rooks_square_def)

lemma rooks_square_reflecty [simp]:
  "\<And> i. 1 \<le> i \<and> i \<le> files \<Longrightarrow> rooks_square (reflecty sq) i = reflecty (rooks_square sq i)"
  "\<And> i. files + 1 \<le> i \<and> i \<le> files + ranks \<Longrightarrow> rooks_square (reflecty sq) i = rooks_square sq i"
by (case_tac[!] sq, simp_all add: rooks_square_def)

lemma rooks_square_reflectdiag [simp]:
  assumes "files = ranks"
  shows
  "\<And> i. 1 \<le> i \<and> i \<le> files \<longrightarrow> rooks_square (reflectdiag sq) i = reflectdiag (rooks_square sq (i + files))"
  "\<And> i. files + 1 \<le> i \<and> i \<le> files + ranks \<longrightarrow> rooks_square (reflectdiag sq) i = reflectdiag (rooks_square sq (i - files))"
using assms
by (case_tac[!] sq, simp_all add: rooks_square_def)

lemma reflectx_rooks_square [simp]: "\<And> i. 1 \<le> i \<and> i \<le> files \<Longrightarrow> reflectx (rooks_square sq i) = rooks_square sq (files + 1 - i)"
by (case_tac[!] sq, simp_all add: rooks_square_def)
lemma reflecty_rooks_square [simp]: "\<And> i. files + 1 \<le> i \<and> i \<le> files + ranks \<Longrightarrow> reflecty (rooks_square sq i) = rooks_square sq (files + 1 + (files + ranks - i))"
by (case_tac[!] sq, simp_all add: rooks_square_def)

lemma kings_square_reflect_x [simp]:
   "kings_square (reflectx sq) 1 = reflectx (kings_square sq 3)"
   "kings_square (reflectx sq) 2 = reflectx (kings_square sq 4)"
   "kings_square (reflectx sq) 3 = reflectx (kings_square sq 1)"
   "kings_square (reflectx sq) 4 = reflectx (kings_square sq 2)"
   "kings_square (reflectx sq) 5 = reflectx (kings_square sq 8)"
   "kings_square (reflectx sq) 6 = reflectx (kings_square sq 6)"
   "kings_square (reflectx sq) 7 = reflectx (kings_square sq 7)"
   "kings_square (reflectx sq) 8 = reflectx (kings_square sq 5)"
unfolding kings_square_def
by (case_tac[!] sq) simp_all

lemma kings_square_reflect_y [simp]:
   "kings_square (reflecty sq) 1 = reflecty (kings_square sq 2)"
   "kings_square (reflecty sq) 2 = reflecty (kings_square sq 1)"
   "kings_square (reflecty sq) 3 = reflecty (kings_square sq 4)"
   "kings_square (reflecty sq) 4 = reflecty (kings_square sq 3)"
   "kings_square (reflecty sq) 5 = reflecty (kings_square sq 5)"
   "kings_square (reflecty sq) 6 = reflecty (kings_square sq 7)"
   "kings_square (reflecty sq) 7 = reflecty (kings_square sq 6)"
   "kings_square (reflecty sq) 8 = reflecty (kings_square sq 8)"
unfolding kings_square_def
by (case_tac[!] sq) simp_all

lemma kings_square_reflect_diag [simp]:
   "kings_square (reflectdiag sq) 1 = reflectdiag (kings_square sq 1)"
   "kings_square (reflectdiag sq) 2 = reflectdiag (kings_square sq 3)"
   "kings_square (reflectdiag sq) 3 = reflectdiag (kings_square sq 2)"
   "kings_square (reflectdiag sq) 4 = reflectdiag (kings_square sq 4)"
   "kings_square (reflectdiag sq) 5 = reflectdiag (kings_square sq 6)"
   "kings_square (reflectdiag sq) 6 = reflectdiag (kings_square sq 5)"
   "kings_square (reflectdiag sq) 7 = reflectdiag (kings_square sq 8)"
   "kings_square (reflectdiag sq) 8 = reflectdiag (kings_square sq 7)"
unfolding kings_square_def
by (case_tac[!] sq) simp_all

lemma reflectx_all_n_rs:
assumes "ranks \<ge> 0" "\<And> sq. P (reflectx_p p) (reflectx sq) \<longleftrightarrow> P p sq"
shows
   "all_n (files + ranks) (\<lambda>x. P (reflectx_p p) (rooks_square (reflectx sq) x)) =
    all_n (files + ranks) (\<lambda>x. P p (rooks_square sq x))"
proof-
  have *: "\<And> i. 1 \<le> i \<and> i \<le> files \<Longrightarrow> P (reflectx_p p) (rooks_square sq i) = P p (rooks_square sq (files + 1 - i))"
    using assms
    by (subst reflectx_involution(1)[symmetric, of "rooks_square sq i"]) (simp del: reflectx_involution reflectx_rooks_square, simp)
  show ?thesis
    unfolding all_n_def
  proof (safe)
    fix i
    assume **: "\<forall>i. 1 \<le> i \<and> i \<le> files + ranks \<longrightarrow>
             P (reflectx_p p) (rooks_square (reflectx sq) i)" "1 \<le> i" "i \<le> files + ranks"
    show "P p (rooks_square sq i)"
    proof (cases "i \<le> files")
      case True
      thus ?thesis
        using **(1)[rule_format, of "files + 1 - i"] *[of "files + 1 - i"] **(2-3) `ranks \<ge> 0`
        by simp
    next
      case False
      thus ?thesis
        using **(1)[rule_format, of "files + (i - files)"] **(2-3) assms
        by simp
    qed
  next
    fix i
    assume **: "\<forall>i. 1 \<le> i \<and> i \<le> files + ranks \<longrightarrow> P p (rooks_square sq i)" "1 \<le> i" "i \<le> files + ranks"
    show "P (reflectx_p p) (rooks_square (reflectx sq) i)"
      using ** assms * `ranks \<ge> 0`
      by (cases "i \<le> files", simp+)
  qed
qed

lemma reflecty_all_n_rs:
assumes "files \<ge> 0" "\<And> sq. P (reflecty_p p) (reflecty sq) \<longleftrightarrow> P p sq"
shows
   "all_n (files + ranks) (\<lambda>x. P (reflecty_p p) (rooks_square (reflecty sq) x)) =
    all_n (files + ranks) (\<lambda>x. P p (rooks_square sq x))"
proof-
  have *: "\<And> i. files + 1 \<le> i \<and> i \<le> files + ranks \<Longrightarrow> P (reflecty_p p) (rooks_square sq i) = P p (rooks_square sq (files + 1 + (files + ranks - i)))"
    using assms
    by (subst reflecty_involution(1)[symmetric, of "rooks_square sq i"]) (simp del: reflecty_involution reflecty_rooks_square, simp)
  show ?thesis
    unfolding all_n_def
  proof (safe)
    fix i
    assume **: "\<forall>i. 1 \<le> i \<and> i \<le> files + ranks \<longrightarrow>
             P (reflecty_p p) (rooks_square (reflecty sq) i)" "1 \<le> i" "i \<le> files + ranks"
    show "P p (rooks_square sq i)"
    proof (cases "i \<le> files")
      case True
      thus ?thesis
        using assms ** rooks_square_reflecty
        by metis
    next
      case False
      thus ?thesis
        using **(1)[rule_format, of "files + 1 + (files + ranks - i)"] **(2-3) * `files \<ge> 0`
        by simp
    qed
  next
    fix i
    assume **: "\<forall>i. 1 \<le> i \<and> i \<le> files + ranks \<longrightarrow> P p (rooks_square sq i)" "1 \<le> i" "i \<le> files + ranks"
    show "P (reflecty_p p) (rooks_square (reflecty sq) i)"
      using assms ** rooks_square_reflecty * `files \<ge> 0`
      by (cases "i \<le> files", simp+)
  qed
qed

lemma reflectdiag_all_n_rs:
assumes 
  "files = ranks"
  "\<And> sq. P (reflectdiag_p p) (reflectdiag sq) \<longleftrightarrow> P p sq"
shows
   "all_n (files + ranks) (\<lambda>x. P (reflectdiag_p p) (rooks_square (reflectdiag sq) x)) =
    all_n (files + ranks) (\<lambda>x. P p (rooks_square sq x))"
unfolding all_n_def 
proof (safe)
  fix i
  assume *: "\<forall>i. 1 \<le> i \<and> i \<le> files + ranks \<longrightarrow> P (reflectdiag_p p) (rooks_square (reflectdiag sq) i)"
    "1 \<le> i" "i \<le> files + ranks"
  show "P p (rooks_square sq i)"
    using assms(2)[of "rooks_square sq i"]
    using *(1)[rule_format, of "i + files"]  *(1)[rule_format, of "i - files"] *(2-3) `files = ranks`
    by (cases "i \<le> files") simp+
next
  fix i
  assume *: "\<forall>i. 1 \<le> i \<and> i \<le> files + ranks \<longrightarrow> P p (rooks_square sq i)" "1 \<le> i" "i \<le> files + ranks"
  show "P (reflectdiag_p p) (rooks_square (reflectdiag sq) i)"
  proof (cases "i \<le> files")
    case True
    thus ?thesis
      using *(1)[rule_format, of "i + files"] *(2-3) `files = ranks`
      using rooks_square_reflectdiag(1)[of i sq]
      using assms(2)[of "rooks_square sq (i + files)"]      
      by simp
  next
    case False
    thus ?thesis
      using *(1)[rule_format, of "i - files"] *(2-3) `files = ranks`
      using rooks_square_reflectdiag(1)[of i sq]
      using assms(2)[of "rooks_square sq (i - files)"]
      by simp
  qed
qed


lemma reflectx_all8_ks:
assumes "\<And> sq. P (reflectx_p p) (reflectx sq) \<longleftrightarrow> P p sq"
shows
   "all8 (\<lambda>x. P (reflectx_p p) (kings_square (reflectx sq) x)) =
    all8 (\<lambda>x. P p (kings_square sq x))"
using assms
by (auto simp add: all8_def)

lemma reflecty_all8_ks:
assumes "\<And> sq. P (reflecty_p p) (reflecty sq) \<longleftrightarrow> P p sq"
shows
   "all8 (\<lambda>x. P (reflecty_p p) (kings_square (reflecty sq) x)) =
    all8 (\<lambda>x. P p (kings_square sq x))"
using assms
by (auto simp add: all8_def)

lemma reflectdiag_all8_ks:
assumes "\<And> sq. P (reflectdiag_p p) (reflectdiag sq) \<longleftrightarrow> P p sq"
shows
   "all8 (\<lambda>x. P (reflectdiag_p p) (kings_square (reflectdiag sq) x)) =
    all8 (\<lambda>x. P p (kings_square sq x))"
using assms
by (auto simp add: all8_def)


lemma reflectx_all4_ks:
assumes "\<And> sq. P (reflectx_p p) (reflectx sq) \<longleftrightarrow> P p sq"
shows
   "all4 (\<lambda>x. P (reflectx_p p) (kings_square (reflectx sq) x)) =
    all4 (\<lambda>x. P p (kings_square sq x))"
using assms
by (auto simp add: all4_def)

lemma reflecty_all4_ks:
assumes "\<And> sq. P (reflecty_p p) (reflecty sq) \<longleftrightarrow> P p sq"
shows
   "all4 (\<lambda>x. P (reflecty_p p) (kings_square (reflecty sq) x)) =
    all4 (\<lambda>x. P p (kings_square sq x))"
using assms
by (auto simp add: all4_def)

lemma reflectdiag_all4_ks:
assumes "\<And> sq. P (reflectdiag_p p) (reflectdiag sq) \<longleftrightarrow> P p sq"
shows
   "all4 (\<lambda>x. P (reflectdiag_p p) (kings_square (reflectdiag sq) x)) =
    all4 (\<lambda>x. P p (kings_square sq x))"
using assms
by (auto simp add: all4_def)

lemma all_king_pos_all8: "all_king_pos P sq \<longleftrightarrow> all8 (\<lambda> i. P (kings_square sq i))"
unfolding all_king_pos_def all8_def
by (cases sq) (auto simp add: kings_square_def Let_def)

lemma [simp]: "BK_cannot_move (reflectx_p p) \<longleftrightarrow> BK_cannot_move p"
using reflectx_all8_ks[where p = "p" and sq = "BK p" and P = "\<lambda> p sq. board sq \<longrightarrow>
           white_attacks_nobk p sq"]
unfolding BK_cannot_move_def white_attacks_nobk_def
by (subst all_king_pos_all8)+ auto

lemma [simp]: "BK_cannot_move (reflecty_p p) \<longleftrightarrow> BK_cannot_move p"
using reflecty_all8_ks[where p = "p" and sq = "BK p" and P = "\<lambda> p sq. board sq \<longrightarrow>
           white_attacks_nobk p sq"]
unfolding BK_cannot_move_def white_attacks_nobk_def
by (subst all_king_pos_all8)+ auto

lemma [simp]: "files = ranks \<Longrightarrow> BK_cannot_move (reflectdiag_p p) \<longleftrightarrow> BK_cannot_move p"
using reflectdiag_all8_ks[where p = "p" and sq = "BK p" and P = "\<lambda> p sq. board sq \<longrightarrow>
           white_attacks_nobk p sq"]
unfolding BK_cannot_move_def white_attacks_nobk_def
by (subst all_king_pos_all8)+ auto

lemma reflectx_checkmated [simp]: "checkmated (reflectx_p p) \<longleftrightarrow> checkmated p"
by (simp add: checkmated_def)
lemma reflecty_checkmated [simp]: "checkmated (reflecty_p p) \<longleftrightarrow> checkmated p"
by (simp add: checkmated_def)
lemma reflectdiag_checkmated [simp]: "files = ranks \<Longrightarrow> checkmated (reflectdiag_p p) \<longleftrightarrow> checkmated p"
by (simp add: checkmated_def)


lemma [simp]: "immediate_mate_cond (reflectx_p p) \<longleftrightarrow> immediate_mate_cond p"
unfolding immediate_mate_cond_def
by (simp del: WR_attacks_BK_def)
lemma [simp]: "immediate_mate_cond (reflecty_p p) \<longleftrightarrow> immediate_mate_cond p"
unfolding immediate_mate_cond_def
by (simp del: WR_attacks_BK_def)
lemma [simp]: "files = ranks \<Longrightarrow> immediate_mate_cond (reflectdiag_p p) \<longleftrightarrow> immediate_mate_cond p"
unfolding immediate_mate_cond_def
by (simp del: WR_attacks_BK_def)


lemma chebyshev_dist_reflectx [simp]: 
  "chebyshev_dist (reflectx sq1) (reflectx sq2) = chebyshev_dist sq1 sq2"
by (cases sq1, cases sq2, simp) (smt chebyshev_dist.simps)
lemma chebyshev_dist_reflecty [simp]: 
  "chebyshev_dist (reflecty sq1) (reflecty sq2) = chebyshev_dist sq1 sq2"
by (cases sq1, cases sq2, simp) (smt chebyshev_dist.simps)
lemma chebyshev_dist_reflectdiag [simp]: 
  "chebyshev_dist (reflectdiag sq1) (reflectdiag sq2) = chebyshev_dist sq1 sq2"
by (cases sq1, cases sq2, simp) (smt chebyshev_dist.simps)


lemma manhattan_dist_reflectx [simp]: 
  "manhattan_dist (reflectx sq1) (reflectx sq2) = manhattan_dist sq1 sq2"
by (cases sq1, cases sq2, simp) (smt manhattan_dist.simps)
lemma manhattan_dist_reflecty [simp]: 
  "manhattan_dist (reflecty sq1) (reflecty sq2) = manhattan_dist sq1 sq2"
by (cases sq1, cases sq2, simp) (smt manhattan_dist.simps)
lemma manhattan_dist_reflectdiag [simp]: 
  "manhattan_dist (reflectdiag sq1) (reflectdiag sq2) = manhattan_dist sq1 sq2"
by (cases sq1, cases sq2, simp) (smt manhattan_dist.simps)

lemma reflectx_room' [simp]: 
  "room' (reflectx R) (reflectx K) = room' R K"
by (cases R, cases K) simp
lemma reflecty_room' [simp]: 
  "room' (reflecty R) (reflecty K) = room' R K"
by (cases R, cases K) simp
lemma reflectdiag_room' [simp]: 
  "files = ranks \<Longrightarrow> room' (reflectdiag R) (reflectdiag K) = room' R K"
by (cases R, cases K) simp

lemma reflectx_room [simp]: "\<not> WRcaptured p \<Longrightarrow> room (reflectx_p p) = room p"
unfolding room_def 
by simp
lemma reflecty_room [simp]: "\<not> WRcaptured p \<Longrightarrow> room (reflecty_p p) = room p"
unfolding room_def 
by simp
lemma reflectdiag_room [simp]: "\<lbrakk>files = ranks; \<not> WRcaptured p\<rbrakk> \<Longrightarrow> room (reflectdiag_p p) = room p"
unfolding room_def 
by simp


lemma reflectx_critical_square [simp]: "\<not> WRcaptured p \<Longrightarrow> critical_square (reflectx_p p) = reflectx (critical_square p)"
unfolding critical_square_def
by (cases "WR p", cases "BK p") auto
lemma reflecty_critical_square [simp]: "\<not> WRcaptured p \<Longrightarrow> critical_square (reflecty_p p) = reflecty (critical_square p)"
unfolding critical_square_def
by (cases "WR p", cases "BK p") auto
lemma reflectdiag_critical_square [simp]: "\<not> WRcaptured p \<Longrightarrow> critical_square (reflectdiag_p p) = reflectdiag (critical_square p)"
unfolding critical_square_def
by (cases "WR p", cases "BK p") auto


lemma reflectx_WR_exposed [simp]:
  "\<not> WRcaptured p \<Longrightarrow> WR_exposed (reflectx_p p) \<longleftrightarrow> WR_exposed p"
unfolding WR_exposed_def
by auto
lemma reflecty_WR_exposed [simp]:
  "\<not> WRcaptured p \<Longrightarrow> WR_exposed (reflecty_p p) \<longleftrightarrow> WR_exposed p"
unfolding WR_exposed_def
by auto
lemma reflectdiag_WR_exposed [simp]:
  "\<not> WRcaptured p \<Longrightarrow> WR_exposed (reflectdiag_p p) \<longleftrightarrow> WR_exposed p"
unfolding WR_exposed_def
by auto


lemma reflectx_WR_divides [simp]:
  "\<not> WRcaptured p \<Longrightarrow> WR_divides (reflectx_p p) \<longleftrightarrow> WR_divides p"
unfolding WR_divides_def
by (cases "WR p", cases "BK p", cases "WK p") (auto simp add: between_def)
lemma reflecty_WR_divides [simp]:
  "\<not> WRcaptured p \<Longrightarrow> WR_divides (reflecty_p p) \<longleftrightarrow> WR_divides p"
unfolding WR_divides_def
by (cases "WR p", cases "BK p", cases "WK p") (auto simp add: between_def)
lemma reflectdiag_WR_divides [simp]:
  "\<not> WRcaptured p \<Longrightarrow> WR_divides (reflectdiag_p p) \<longleftrightarrow> WR_divides p"
unfolding WR_divides_def
by (cases "WR p", cases "BK p", cases "WK p") (auto simp add: between_def)


lemma reflectx_Lpattern [simp]:
  "\<not> WRcaptured p \<Longrightarrow> Lpattern (reflectx_p p) \<longleftrightarrow> Lpattern p"
unfolding Lpattern_def Let_def
by (cases "WR p", cases "BK p", cases "WK p") (auto simp add: abs_minus_commute)
lemma reflecty_Lpattern [simp]:
  "\<not> WRcaptured p \<Longrightarrow> Lpattern (reflecty_p p) \<longleftrightarrow> Lpattern p"
unfolding Lpattern_def Let_def
by  (cases "WR p", cases "BK p", cases "WK p") (auto simp add: abs_minus_commute)
lemma reflectdiag_Lpattern [simp]:
  "\<not> WRcaptured p \<Longrightarrow> Lpattern (reflectdiag_p p) \<longleftrightarrow> Lpattern p"
unfolding Lpattern_def Let_def
by  (cases "WR p", cases "BK p", cases "WK p") (simp, metis)


lemma reflectx_on_edge [simp]: "on_same_edge (reflectx sq) (reflectx sq') \<longleftrightarrow> on_same_edge sq sq'"
by (cases sq, cases sq')  auto
lemma reflecty_on_edge [simp]: "on_same_edge (reflecty sq) (reflecty sq') \<longleftrightarrow> on_same_edge sq sq'"
by (cases sq, cases sq') auto
lemma reflectdiag_on_edge [simp]: "files = ranks \<Longrightarrow> on_same_edge (reflectdiag sq) (reflectdiag sq') \<longleftrightarrow> on_same_edge sq sq'"
by (cases sq, cases sq') auto


lemma reflectx_mdcs [simp]: 
  "\<not> WRcaptured p \<Longrightarrow> mdcs (reflectx_p p) = mdcs p"
unfolding mdcs_def
by simp
lemma reflecty_mdcs [simp]: 
  "\<not> WRcaptured p \<Longrightarrow> mdcs (reflecty_p p) = mdcs p"
unfolding mdcs_def
by simp
lemma reflectdiag_mdcs [simp]: 
  "\<not> WRcaptured p \<Longrightarrow> mdcs (reflectdiag_p p) = mdcs p"
unfolding mdcs_def
by simp


lemma reflectx_legal_move_BK [simp]: "legal_move_BK (reflectx_p p1) (reflectx_p p1') \<longleftrightarrow> legal_move_BK p1 p1'"
unfolding KRK.legal_move_BK_def
by (simp del: reflectx_moveBK) (force simp add: reflectx_p_inj)
lemma reflecty_legal_move_BK [simp]: "legal_move_BK (reflecty_p p1) (reflecty_p p1') \<longleftrightarrow> legal_move_BK p1 p1'"
unfolding KRK.legal_move_BK_def
by (simp del: reflecty_moveBK) (force simp add: reflecty_p_inj)
lemma reflectdiag_legal_move_BK [simp]: "files = ranks \<Longrightarrow> legal_move_BK (reflectdiag_p p1) (reflectdiag_p p1') \<longleftrightarrow> legal_move_BK p1 p1'"
unfolding KRK.legal_move_BK_def
by (simp del: reflectdiag_moveBK) (force simp add: reflectdiag_p_inj)

lemma reflectx_legal_move_WK [simp]: "legal_move_WK (reflectx_p p1) (reflectx_p p1') \<longleftrightarrow> legal_move_WK p1 p1'"
unfolding KRK.legal_move_WK_def
by (simp del: reflectx_moveWK) (force simp add: reflectx_p_inj)
lemma reflecty_legal_move_WK [simp]: "legal_move_WK (reflecty_p p1) (reflecty_p p1') \<longleftrightarrow> legal_move_WK p1 p1'"
unfolding KRK.legal_move_WK_def
by (simp del: reflecty_moveWK) (force simp add: reflecty_p_inj)
lemma reflectdiag_legal_move_WK [simp]: "files = ranks \<Longrightarrow> legal_move_WK (reflectdiag_p p1) (reflectdiag_p p1') \<longleftrightarrow> legal_move_WK p1 p1'"
unfolding KRK.legal_move_WK_def
by (simp del: reflectdiag_moveWK) (force simp add: reflectdiag_p_inj)

lemma reflectx_legal_move_WR': 
  assumes "legal_move_WR p1 p1'"
  shows "legal_move_WR (reflectx_p p1) (reflectx_p p1')"
proof-
  have "\<not> WRcaptured p1" "\<not> WRcaptured p1'"
    using assms
    by (auto simp add: legal_move_WR_def WR_attacks_nobk_def) (metis moveWR_fields(5))
  thus ?thesis
    using assms
    unfolding legal_move_WR_def
    by auto
qed
lemma reflectx_legal_move_WR [simp]: "legal_move_WR (reflectx_p p1) (reflectx_p p1') \<longleftrightarrow> legal_move_WR p1 p1'"
by (metis reflect_involution(1) reflectx_legal_move_WR')

lemma reflecty_legal_move_WR': 
  assumes "legal_move_WR p1 p1'"
  shows "legal_move_WR (reflecty_p p1) (reflecty_p p1')"
proof-
  have "\<not> WRcaptured p1" "\<not> WRcaptured p1'"
    using assms
    by (auto simp add: legal_move_WR_def WR_attacks_nobk_def) (metis moveWR_fields(5))
  thus ?thesis
    using assms
    unfolding legal_move_WR_def
    by auto
qed
lemma reflecty_legal_move_WR [simp]: "legal_move_WR (reflecty_p p1) (reflecty_p p1') \<longleftrightarrow> legal_move_WR p1 p1'"
by (metis reflect_involution(2) reflecty_legal_move_WR')

lemma reflectdiag_legal_move_WR': 
  assumes "files = ranks" "legal_move_WR p1 p1'"
  shows "legal_move_WR (reflectdiag_p p1) (reflectdiag_p p1')"
proof-
  have "\<not> WRcaptured p1" "\<not> WRcaptured p1'"
    using assms
    by (auto simp add: legal_move_WR_def WR_attacks_nobk_def) (metis moveWR_fields(5))
  thus ?thesis
    using assms
    unfolding legal_move_WR_def
    by auto
qed
lemma reflectdiag_legal_move_WR [simp]: "files = ranks \<Longrightarrow> legal_move_WR (reflectdiag_p p1) (reflectdiag_p p1') \<longleftrightarrow> legal_move_WR p1 p1'"
by (metis reflect_involution(3) reflectdiag_legal_move_WR')


lemma reflectx_WR_can_move_to
  [simp]: "WR_can_move_to (reflectx_p p) (reflectx sq) \<longleftrightarrow> WR_can_move_to p sq"
  unfolding WR_can_move_to_def
  by (auto simp add: reflectx_inj)
lemma reflecty_WR_can_move_to
  [simp]: "WR_can_move_to (reflecty_p p) (reflecty sq) \<longleftrightarrow> WR_can_move_to p sq"
  unfolding WR_can_move_to_def
  by (auto simp add: reflecty_inj)
lemma reflectdiag_WR_can_move_to
  [simp]: "files = ranks \<Longrightarrow> WR_can_move_to (reflectdiag_p p) (reflectdiag sq) \<longleftrightarrow> WR_can_move_to p sq"
  unfolding WR_can_move_to_def
  by (auto simp add: reflectdiag_inj)

lemma reflectx_no_immediate_mate [simp]: 
  assumes "ranks \<ge> 0" "\<not> WRcaptured p"
  shows "no_immediate_mate (reflectx_p p) \<longleftrightarrow> no_immediate_mate p"
unfolding no_immediate_mate_WR_def 
using assms(2)
by simp (rule reflectx_all_n_rs[OF assms(1)], simp)

lemma reflecty_no_immediate_mate [simp]: 
  assumes "files \<ge> 0" "\<not> WRcaptured p"
  shows "no_immediate_mate (reflecty_p p) \<longleftrightarrow> no_immediate_mate p"
using assms(2)
unfolding no_immediate_mate_WR_def
by simp (rule reflecty_all_n_rs[OF assms(1)], simp)

lemma reflectdiag_no_immediate_mate [simp]: 
  assumes "files = ranks" "\<not> WRcaptured p"
  shows "no_immediate_mate (reflectdiag_p p) \<longleftrightarrow> no_immediate_mate p"
using assms(2)
unfolding no_immediate_mate_WR_def
by simp (rule reflectdiag_all_n_rs[OF assms(1)], simp add: assms(1))

lemma reflectx_ready_to_mate [simp]:
  shows "ready_to_mate (reflectx_p p) \<longleftrightarrow> ready_to_mate p"
unfolding KRKStrategy.ready_to_mate_def
by (subst reflectx_canon, simp)

lemma reflecty_ready_to_mate [simp]:
  shows "ready_to_mate (reflecty_p p) \<longleftrightarrow> ready_to_mate p"
unfolding KRKStrategy.ready_to_mate_def
by (subst reflecty_canon, simp)

lemma reflectdiag_ready_to_mate [simp]:
  assumes "files = ranks"
  shows "ready_to_mate (reflectdiag_p p) \<longleftrightarrow> ready_to_mate p"
unfolding KRKStrategy.ready_to_mate_def
by (subst reflectdiag_canon[OF assms], simp)

lemma reflectx_no_ready_to_mate_WR [simp]: 
  assumes "ranks \<ge> 0" "\<not> WRcaptured p"
  shows "no_ready_to_mate_WR (reflectx_p p) \<longleftrightarrow> no_ready_to_mate_WR p"
using assms(2)
unfolding no_ready_to_mate_WR_def
by simp (rule reflectx_all_n_rs[OF assms(1)], simp)

lemma reflecty_no_ready_to_mate_WR [simp]: 
  assumes "files \<ge> 0" "\<not> WRcaptured p"
  shows "no_ready_to_mate_WR (reflecty_p p) \<longleftrightarrow> no_ready_to_mate_WR p"
using assms(2)
unfolding no_ready_to_mate_WR_def
by simp (rule reflecty_all_n_rs[OF assms(1)], simp)


lemma reflectdiag_no_ready_to_mate_WR [simp]: 
  assumes "files = ranks" "\<not> WRcaptured p"
  shows "no_ready_to_mate_WR (reflectdiag_p p) \<longleftrightarrow> no_ready_to_mate_WR p"
using assms(2)
unfolding no_ready_to_mate_WR_def
by simp (rule reflectdiag_all_n_rs[OF assms(1)], simp add: assms(1))

lemma reflectx_no_ready_to_mate_WK [simp]: 
  assumes "\<not> WRcaptured p"
  shows "no_ready_to_mate_WK (reflectx_p p) \<longleftrightarrow> no_ready_to_mate_WK p"
using assms
unfolding no_ready_to_mate_WK_def
by (simp add: Let_def) (rule reflectx_all8_ks, simp)

lemma reflecty_no_ready_to_mate_WK [simp]: 
  assumes "\<not> WRcaptured p"
  shows "no_ready_to_mate_WK (reflecty_p p) \<longleftrightarrow> no_ready_to_mate_WK p"
using assms
unfolding no_ready_to_mate_WK_def
by (simp add: Let_def) (rule reflecty_all8_ks, simp)

lemma reflectdiag_no_ready_to_mate_WK [simp]: 
  assumes "files = ranks" "\<not> WRcaptured p"
  shows "no_ready_to_mate_WK (reflectdiag_p p) \<longleftrightarrow> no_ready_to_mate_WK p"
using assms(2)
unfolding no_ready_to_mate_WK_def
by (simp add: Let_def) (rule reflectdiag_all8_ks, simp add: assms(1))


lemma reflectx_no_ready_to_mate [simp]: 
  assumes "ranks \<ge> 0" "\<not> WRcaptured p"
  shows "no_ready_to_mate (reflectx_p p) \<longleftrightarrow> no_ready_to_mate p"
using assms
unfolding no_ready_to_mate_def
by simp

lemma reflecty_no_ready_to_mate [simp]: 
  assumes "files \<ge> 0" "\<not> WRcaptured p"
  shows "no_ready_to_mate (reflecty_p p) \<longleftrightarrow> no_ready_to_mate p"
using assms
unfolding no_ready_to_mate_def
by simp

lemma reflectdiag_no_ready_to_mate [simp]: 
  assumes "files = ranks" "\<not> WRcaptured p"
  shows "no_ready_to_mate (reflectdiag_p p) \<longleftrightarrow> no_ready_to_mate p"
using assms
unfolding no_ready_to_mate_def
by simp


lemma reflectx_squeeze_cond [simp]:
  assumes "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "squeeze_cond (reflectx_p p) (reflectx_p p') = squeeze_cond p p'"
using assms
unfolding squeeze_cond_def
by simp

lemma reflecty_squeeze_cond [simp]:
  assumes "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "squeeze_cond (reflecty_p p) (reflecty_p p') = squeeze_cond p p'"
using assms
unfolding squeeze_cond_def
by simp

lemma reflectdiag_squeeze_cond [simp]:
  assumes "files = ranks" "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "squeeze_cond (reflectdiag_p p) (reflectdiag_p p') = squeeze_cond p p'"
using assms
unfolding squeeze_cond_def
by simp

lemma reflectx_no_squeeze [simp]:
  assumes "ranks \<ge> 0" "\<not> WRcaptured p"
  shows "no_squeeze (reflectx_p p) \<longleftrightarrow> no_squeeze p"
using assms(2)
unfolding no_squeeze_def
by simp (rule reflectx_all_n_rs[OF assms(1)], simp)

lemma reflecty_no_squeeze [simp]:
  assumes "files \<ge> 0" "\<not> WRcaptured p"
  shows "no_squeeze (reflecty_p p) \<longleftrightarrow> no_squeeze p"
using assms(2)
unfolding no_squeeze_def
by simp (rule reflecty_all_n_rs[OF assms(1)], simp)

lemma reflectdiag_no_squeeze [simp]:
  assumes "files = ranks" "\<not> WRcaptured p"
  shows "no_squeeze (reflectdiag_p p) \<longleftrightarrow> no_squeeze p"
using assms(2)
unfolding no_squeeze_def
by simp (rule reflectdiag_all_n_rs[OF assms(1)], simp add: assms(1))

lemma reflectx_back_move [simp]:
  assumes "\<not> WRcaptured p"
  shows "back_move (reflectx_p p) (reflectx_p p') \<longleftrightarrow> back_move p p'"
using assms
unfolding back_move_def
by (cases "BK p", cases "WK p", cases "WR p", cases "WK p'") auto

lemma reflecty_back_move [simp]:
  assumes "\<not> WRcaptured p"
  shows "back_move (reflecty_p p) (reflecty_p p') \<longleftrightarrow> back_move p p'"
using assms
unfolding back_move_def
by (cases "BK p", cases "WK p", cases "WR p", cases "WK p'") auto

lemma reflectdiag_back_move [simp]:
  assumes "files = ranks" "\<not> WRcaptured p"
  shows "back_move (reflectdiag_p p) (reflectdiag_p p') \<longleftrightarrow> back_move p p'"
using assms 
unfolding back_move_def
by (cases "BK p", cases "WK p", cases "WR p", cases "WK p'") auto


lemma reflectx_approach_cond [simp]: 
  assumes "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "approach_cond (reflectx_p p) (reflectx_p p') \<longleftrightarrow> approach_cond p p'"
using assms
unfolding approach_cond_def approach_critical_square_def
by simp

lemma reflecty_approach_cond [simp]: 
  assumes "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "approach_cond (reflecty_p p) (reflecty_p p') \<longleftrightarrow> approach_cond p p'"
using assms
unfolding approach_cond_def approach_critical_square_def
by simp

lemma reflectdiag_approach_cond [simp]: 
  assumes "files = ranks" "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "approach_cond (reflectdiag_p p) (reflectdiag_p p') \<longleftrightarrow> approach_cond p p'"
using assms
unfolding approach_cond_def approach_critical_square_def
by simp


lemma reflectx_keep_room_cond [simp]: 
  assumes "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "keep_room_cond (reflectx_p p) (reflectx_p p') \<longleftrightarrow> keep_room_cond p p'"
using assms
unfolding keep_room_cond_def WRandWKdiverging_def
by simp

lemma reflecty_keep_room_cond [simp]: 
  assumes "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "keep_room_cond (reflecty_p p) (reflecty_p p') \<longleftrightarrow> keep_room_cond p p'"
using assms
unfolding keep_room_cond_def WRandWKdiverging_def
by simp

lemma reflectdiag_keep_room_cond [simp]: 
  assumes "files = ranks" "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "keep_room_cond (reflectdiag_p p) (reflectdiag_p p') \<longleftrightarrow> keep_room_cond p p'"
using assms
unfolding keep_room_cond_def WRandWKdiverging_def
by simp


lemma reflectx_divide_attempt [simp]: 
  assumes "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "divide_attempt (reflectx_p p) (reflectx_p p') \<longleftrightarrow> divide_attempt p p'"
using assms
unfolding divide_attempt_def
by (cases "WK p", cases "BK p", cases "WR p", cases "WR p'", simp) (rule, smt+)

lemma reflecty_divide_attempt [simp]: 
  assumes "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "divide_attempt (reflecty_p p) (reflecty_p p') \<longleftrightarrow> divide_attempt p p'"
using assms
unfolding divide_attempt_def
by (cases "WK p", cases "BK p", cases "WR p", cases "WR p'", simp) (rule, smt+)

lemma reflectdiag_divide_attempt [simp]: 
  assumes "files = ranks" "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "divide_attempt (reflectdiag_p p) (reflectdiag_p p') \<longleftrightarrow> divide_attempt p p'"
using assms
unfolding divide_attempt_def
by (cases "WK p", cases "BK p", cases "WR p", cases "WR p'", simp) (rule, smt+)


lemma reflectx_rook_home_cond [simp]: 
  assumes "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "rook_home_cond (reflectx_p p) (reflectx_p p') \<longleftrightarrow> rook_home_cond p p'"
using assms
unfolding rook_home_cond_def WK_protects_WR_def
by simp

lemma reflecty_rook_home_cond [simp]: 
  assumes "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "rook_home_cond (reflecty_p p) (reflecty_p p') \<longleftrightarrow> rook_home_cond p p'"
using assms
unfolding rook_home_cond_def WK_protects_WR_def
by simp

lemma reflectdiag_rook_home_cond [simp]: 
  assumes "files = ranks" "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "rook_home_cond (reflectdiag_p p) (reflectdiag_p p') \<longleftrightarrow> rook_home_cond p p'"
using assms
unfolding rook_home_cond_def WK_protects_WR_def
by simp


lemma reflectx_move_WR_to_edge [simp]:
  assumes "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "move_WR_to_edge (reflectx_p p) (reflectx_p p') = move_WR_to_edge p p'"
using assms
unfolding move_WR_to_edge_def
by (cases "WK p", cases "BK p", cases "WR p", cases "WR p'", simp) (rule, smt+)

lemma reflecty_move_WR_to_edge [simp]:
  assumes "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "move_WR_to_edge (reflecty_p p) (reflecty_p p') = move_WR_to_edge p p'"
using assms
unfolding move_WR_to_edge_def
by (cases "WK p", cases "BK p", cases "WR p", cases "WR p'", simp) (rule, smt+)

lemma reflectdiag_move_WR_to_edge [simp]:
  assumes "files = ranks" "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "move_WR_to_edge (reflectdiag_p p) (reflectdiag_p p') = move_WR_to_edge p p'"
using assms
unfolding move_WR_to_edge_def
by (cases "WK p", cases "BK p", cases "WR p", cases "WR p'", simp) (rule, smt+)



lemma reflectx_rook_safe_cond [simp]: 
  assumes "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "rook_safe_cond (reflectx_p p) (reflectx_p p') \<longleftrightarrow> rook_safe_cond p p'"
using assms
unfolding rook_safe_cond_def 
by simp

lemma reflecty_rook_safe_cond [simp]: 
  assumes "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "rook_safe_cond (reflecty_p p) (reflecty_p p') \<longleftrightarrow> rook_safe_cond p p'"
using assms
unfolding rook_safe_cond_def 
by simp

lemma reflectdiag_rook_safe_cond [simp]: 
  assumes "files = ranks" "\<not> WRcaptured p" "\<not> WRcaptured p'"
  shows "rook_safe_cond (reflectdiag_p p) (reflectdiag_p p') \<longleftrightarrow> rook_safe_cond p p'"
using assms
unfolding rook_safe_cond_def 
by simp


lemma reflectx_no_approach [simp]:
  assumes "\<not> WRcaptured p"
  shows "no_approach (reflectx_p p) \<longleftrightarrow> no_approach p"
using assms
unfolding no_approach_def
by (simp add: Let_def) (rule reflectx_all8_ks, simp)

lemma reflecty_no_approach [simp]:
  assumes "\<not> WRcaptured p"
  shows "no_approach (reflecty_p p) \<longleftrightarrow> no_approach p"
using assms
unfolding no_approach_def
by (simp add: Let_def) (rule reflecty_all8_ks, simp)

lemma reflectdiag_no_approach [simp]:
  assumes "files = ranks" "\<not> WRcaptured p"
  shows "no_approach (reflectdiag_p p) \<longleftrightarrow> no_approach p"
using assms
unfolding no_approach_def
by (simp add: Let_def) (rule reflectdiag_all8_ks, simp)


lemma reflectx_no_keep_room [simp]:
  assumes "\<not> WRcaptured p"
  shows "no_keep_room (reflectx_p p) \<longleftrightarrow> no_keep_room p"
using assms
unfolding no_keep_room_def
by (simp add: Let_def) (rule reflectx_all8_ks, simp)

lemma reflecty_no_keep_room [simp]:
  assumes "\<not> WRcaptured p"
  shows "no_keep_room (reflecty_p p) \<longleftrightarrow> no_keep_room p"
using assms
unfolding no_keep_room_def
by (simp add: Let_def) (rule reflecty_all8_ks, simp)

lemma reflectdiag_no_keep_room [simp]:
  assumes "files = ranks" "\<not> WRcaptured p"
  shows "no_keep_room (reflectdiag_p p) \<longleftrightarrow> no_keep_room p"
using assms
unfolding no_keep_room_def
by (simp add: Let_def) (rule reflectdiag_all8_ks, simp)


lemma reflectx_no_rook_home [simp]:
  assumes "ranks \<ge> 0" "\<not> WRcaptured p"
  shows "no_rook_home (reflectx_p p) \<longleftrightarrow> no_rook_home p"
using assms(2)
unfolding no_rook_home_def
by simp (rule reflectx_all_n_rs[OF assms(1)], simp)

lemma reflecty_no_rook_home [simp]:
  assumes "files \<ge> 0" "\<not> WRcaptured p"
  shows "no_rook_home (reflecty_p p) \<longleftrightarrow> no_rook_home p"
using assms(2)
unfolding no_rook_home_def
by simp (rule reflecty_all_n_rs[OF assms(1)], simp)

lemma reflectdiag_no_rook_home [simp]:
  assumes "files = ranks" "\<not> WRcaptured p"
  shows "no_rook_home (reflectdiag_p p) \<longleftrightarrow> no_rook_home p"
using assms(2)
unfolding no_rook_home_def
by simp (rule reflectdiag_all_n_rs[OF assms(1)], simp add: assms(1))


lemma reflectx_no_approach_diag [simp]:
  assumes "\<not> WRcaptured p"
  shows "no_approach_diag (reflectx_p p) \<longleftrightarrow> no_approach_diag p"
using assms
unfolding no_approach_diag_def
by (simp add: Let_def) (rule reflectx_all4_ks, simp)

lemma reflecty_no_approach_diag [simp]:
  assumes "\<not> WRcaptured p"
  shows "no_approach_diag (reflecty_p p) \<longleftrightarrow> no_approach_diag p"
using assms
unfolding no_approach_diag_def
by (simp add: Let_def) (rule reflecty_all4_ks, simp)

lemma reflectdiag_no_approach_diag [simp]:
  assumes "files = ranks" "\<not> WRcaptured p"
  shows "no_approach_diag (reflectdiag_p p) \<longleftrightarrow> no_approach_diag p"
using assms
unfolding no_approach_diag_def
by (simp add: Let_def) (rule reflectdiag_all4_ks, simp)


lemma reflectx_no_keep_room_diag [simp]:
  assumes "\<not> WRcaptured p"
  shows "no_keep_room_diag (reflectx_p p) \<longleftrightarrow> no_keep_room_diag p"
using assms
unfolding no_keep_room_diag_def
by (simp add: Let_def) (rule reflectx_all4_ks, simp)

lemma reflecty_no_keep_room_diag [simp]:
  assumes "\<not> WRcaptured p"
  shows "no_keep_room_diag (reflecty_p p) \<longleftrightarrow> no_keep_room_diag p"
using assms
unfolding no_keep_room_diag_def
by (simp add: Let_def) (rule reflecty_all4_ks, simp)

lemma reflectdiag_no_keep_room_diag [simp]:
  assumes "files = ranks" "\<not> WRcaptured p"
  shows "no_keep_room_diag (reflectdiag_p p) \<longleftrightarrow> no_keep_room_diag p"
using assms
unfolding no_keep_room_diag_def
by (simp add: Let_def) (rule reflectdiag_all4_ks, simp)


lemma reflectx_strategy_white_move_rel':
  assumes "ranks \<ge> 0" "\<not> WRcaptured p"
  shows "strategy_white_move_rel p p' t \<Longrightarrow> strategy_white_move_rel (reflectx_p p) (reflectx_p p') t"
using assms strategy_white_move_rel_notWRCaptured[of p p' t]
unfolding strategy_white_move_rel_def legal_move_white_def
by (simp split: split_if_asm)

lemma reflecty_strategy_white_move_rel':
  assumes "files \<ge> 0" "\<not> WRcaptured p"
  shows "strategy_white_move_rel p p' t \<Longrightarrow> strategy_white_move_rel (reflecty_p p) (reflecty_p p') t"
using assms strategy_white_move_rel_notWRCaptured[of p p' t]
unfolding strategy_white_move_rel_def legal_move_white_def
by (simp split: split_if_asm)

lemma reflectdiag_strategy_white_move_rel':
  assumes "files = ranks" "\<not> WRcaptured p"
  shows "strategy_white_move_rel p p' t \<Longrightarrow> strategy_white_move_rel (reflectdiag_p p) (reflectdiag_p p') t"
using assms strategy_white_move_rel_notWRCaptured[of p p' t]
unfolding strategy_white_move_rel_def legal_move_white_def
by (simp split: split_if_asm)


(* ---------------------------------------------------------------------------- *)
theorem reflectx_strategy_white_move_rel [simp]:
  assumes "ranks \<ge> 0" "\<not> WRcaptured p"
  shows "strategy_white_move_rel (reflectx_p p) (reflectx_p p') t \<longleftrightarrow> strategy_white_move_rel p p' t"
using assms
by (metis reflect_involution(1) reflectx_fields(4) reflectx_strategy_white_move_rel')

theorem reflecty_strategy_white_move_rel [simp]:
  assumes "files \<ge> 0" "\<not> WRcaptured p"
  shows "strategy_white_move_rel (reflecty_p p) (reflecty_p p') t \<longleftrightarrow> strategy_white_move_rel p p' t"
using assms
by (metis reflect_involution(2) reflecty_fields(4) reflecty_strategy_white_move_rel') 

theorem reflectdiag_strategy_white_move_rel [simp]:
  assumes "files = ranks" "\<not> WRcaptured p"
  shows "strategy_white_move_rel (reflectdiag_p p) (reflectdiag_p p') t \<longleftrightarrow> strategy_white_move_rel p p' t"
using assms
by (metis reflect_involution(3) reflectdiag_fields(4) reflectdiag_strategy_white_move_rel') 
(* ---------------------------------------------------------------------------- *)

end
