section{* Auxiliary notions - quantification of 8 or 16 values *}
theory Auxiliary
  imports Main "HOL-Library.Product_Lexorder"
begin

definition all4 :: "(int \<Rightarrow> bool) \<Rightarrow> bool"  where
  "all4 P \<longleftrightarrow> P 1 \<and> P 2 \<and> P 3 \<and> P 4"

lemma "all4 P \<longleftrightarrow> (\<forall> i. 1 \<le> i \<and> i \<le> 4 \<longrightarrow> P i)"
by (auto simp add: all4_def) smt

lemma all4_eq:
  assumes "\<forall> (i::int). 1 \<le> i \<and> i \<le> 4 \<longrightarrow> (P i \<longleftrightarrow> P' i)"
  shows "all4 P \<longleftrightarrow> all4 P'"
using assms
unfolding all4_def
by auto

definition some4 :: "(int \<Rightarrow> bool) \<Rightarrow> bool"  where
  "some4 P \<longleftrightarrow> P 1 \<or> P 2 \<or> P 3 \<or> P 4"

lemma "some4 P \<longleftrightarrow> (\<exists> i. 1 \<le> i \<and> i \<le> 4 \<and> P i)"
by (auto simp add: some4_def) smt+

lemma some4_eq:
  assumes "\<forall> (i::int). 1 \<le> i \<and> i \<le> 4 \<longrightarrow> (P i \<longleftrightarrow> P' i)"
  shows "some4 P \<longleftrightarrow> some4 P'"
using assms
unfolding some4_def
by auto

lemma some4_all4_deMorgan:
  "\<not> some4 P \<longleftrightarrow> all4 (\<lambda> x. \<not> P x)"
  "\<not> all4 P \<longleftrightarrow> some4 (\<lambda> x. \<not> P x)"
unfolding some4_def all4_def
by auto

definition first4 :: "(int \<Rightarrow> bool) \<Rightarrow> int" where
  "first4 P = 
     (if P 1 then 1 else
      if P 2 then 2 else
      if P 3 then 3 else
      if P 4 then 4 else
      0)"

lemma first4_le[simp]: "first4 P \<le> 4"
unfolding first4_def
by auto

lemma first4: 
  assumes "first4 P > 0"
  shows "P (first4 P)"
using assms
unfolding first4_def
by auto

lemma first4_pos: "first4 P > 0 \<longleftrightarrow> some4 P"
unfolding first4_def some4_def
by auto

lemma first4_zero: "\<not> (first4 P > 0) \<longleftrightarrow> all4 (\<lambda> x. \<not> P x)"
unfolding first4_def all4_def
by auto

(* -------------------------------------------------------- *)

definition all8 :: "(int \<Rightarrow> bool) \<Rightarrow> bool"  where
  "all8 P \<longleftrightarrow> P 1 \<and> P 2 \<and> P 3 \<and> P 4 \<and> P 5 \<and> P 6 \<and> P 7 \<and> P 8"

lemma "all8 P \<longleftrightarrow> (\<forall> i. 1 \<le> i \<and> i \<le> 8 \<longrightarrow> P i)"
by (auto simp add: all8_def) smt

lemma all8_eq:
  assumes "\<forall> (i::int). 1 \<le> i \<and> i \<le> 8 \<longrightarrow> (P i \<longleftrightarrow> P' i)"
  shows "all8 P \<longleftrightarrow> all8 P'"
using assms
unfolding all8_def
by auto

definition some8 :: "(int \<Rightarrow> bool) \<Rightarrow> bool"  where
  "some8 P \<longleftrightarrow> P 1 \<or> P 2 \<or> P 3 \<or> P 4 \<or> P 5 \<or> P 6 \<or> P 7 \<or> P 8"

lemma "some8 P \<longleftrightarrow> (\<exists> i. 1 \<le> i \<and> i \<le> 8 \<and> P i)"
by (auto simp add: some8_def) smt+

lemma some8_eq:
  assumes "\<forall> (i::int). 1 \<le> i \<and> i \<le> 8 \<longrightarrow> (P i \<longleftrightarrow> P' i)"
  shows "some8 P \<longleftrightarrow> some8 P'"
using assms
unfolding some8_def
by auto

lemma some8_all8_deMorgan:
  "\<not> some8 P \<longleftrightarrow> all8 (\<lambda> x. \<not> P x)"
  "\<not> all8 P \<longleftrightarrow> some8 (\<lambda> x. \<not> P x)"
unfolding some8_def all8_def
by auto

definition first8 :: "(int \<Rightarrow> bool) \<Rightarrow> int" where
  "first8 P = 
     (if P 1 then 1 else
      if P 2 then 2 else
      if P 3 then 3 else
      if P 4 then 4 else
      if P 5 then 5 else
      if P 6 then 6 else
      if P 7 then 7 else
      if P 8 then 8 else
      0)"

lemma first8_le[simp]: "first8 P \<le> 8"
unfolding first8_def
by auto

lemma first8: 
  assumes "first8 P > 0"
  shows "P (first8 P)"
using assms
unfolding first8_def
by auto

lemma first8_pos: "first8 P > 0 \<longleftrightarrow> some8 P"
unfolding first8_def some8_def
by auto

lemma first8_zero: "\<not> (first8 P > 0) \<longleftrightarrow> all8 (\<lambda> x. \<not> P x)"
unfolding first8_def all8_def
by auto

lemma first8_ge4:
  assumes "first8 P > 4"
  shows "all4 (\<lambda> x. \<not> P x)"
using assms
unfolding first8_def all4_def
by (simp split: if_split_asm)

(* -------------------------------------------------------- *)

(* returns an index of an element that returns (true, m) where m is the minimal value returned *)
definition min8 :: "(int \<Rightarrow> bool \<times> int) \<Rightarrow> int" where
  "min8 P = 
     (let i = 0; m = 0;
          (b, v) = P 1;
          (i, m) = if b \<and> (i = 0 \<or> v < m) then (1, v) else (i, m);
          (b, v) = P 2;
          (i, m) = if b \<and> (i = 0 \<or> v < m) then (2, v) else (i, m);
          (b, v) = P 3;
          (i, m) = if b \<and> (i = 0 \<or> v < m) then (3, v) else (i, m);
          (b, v) = P 4;
          (i, m) = if b \<and> (i = 0 \<or> v < m) then (4, v) else (i, m);
          (b, v) = P 5;
          (i, m) = if b \<and> (i = 0 \<or> v < m) then (5, v) else (i, m);
          (b, v) = P 6;
          (i, m) = if b \<and> (i = 0 \<or> v < m) then (6, v) else (i, m);
          (b, v) = P 7;
          (i, m) = if b \<and> (i = 0 \<or> v < m) then (7, v) else (i, m);
          (b, v) = P 8
       in i
     )"

(* -------------------------------------------------------- *)

definition all_n :: "int \<Rightarrow> (int \<Rightarrow> bool) \<Rightarrow> bool" where
  "all_n n P \<longleftrightarrow> (\<forall> i. 1 \<le> i \<and> i \<le> n \<longrightarrow>  P i)"

lemma all_n_eq:
  assumes "\<forall> (i::int). 1 \<le> i \<and> i \<le> n \<longrightarrow> (P i \<longleftrightarrow> P' i)"
  shows "all_n n P \<longleftrightarrow> all_n n P'"
using assms
unfolding all_n_def
by auto

(* -------------------------------------------------------- *)

primrec first_n :: "nat \<Rightarrow> (int \<Rightarrow> bool) \<Rightarrow> int" where
  "first_n 0 P  = 0"
| "first_n (Suc n) P =
     (let r = first_n n P
       in if r > 0 then r 
          else if P (int (Suc n)) then (int (Suc n))
          else 0
     )" 

lemma first_n_le[simp]: "first_n n P \<le> (int n)"
by (induct n) (auto simp add: Let_def)

lemma first_n: 
  assumes "first_n n P > 0"
  shows "P (first_n n P)"
using assms
by (induct n) (auto simp add: Let_def)

lemma first_n_pos: "first_n n P > 0 \<longleftrightarrow> \<not> (all_n (int n) (Not \<circ> P))"
by (induct n) (auto simp add: Let_def all_n_def, smt)

lemma first_n_zero: "\<not> (first_n n P > 0) \<longleftrightarrow> all_n (int n) (Not \<circ> P)"
using first_n_pos
by auto

definition min_n where
 "min_n n P = (let l = map snd (filter fst (map (\<lambda> i. (fst (P i), (snd (P i)), i)) [1..n])) in if l = [] then None else Some (snd (min_list l)))"

lemma min_list_in_list: 
  assumes "l \<noteq> []"
  shows "min_list l \<in> set l"
  using assms
  by (induct l, auto, metis list.case_eq_if min_def)

lemma min_n_Range: 
  assumes "min_n n P = Some i"
  shows "1 \<le> i \<and> i \<le> n"
proof-
  let ?l = "map snd (filter fst (map (\<lambda> i. (fst (P i), (snd (P i)), i)) [1..n]))"
  have "?l \<noteq> []" "i = snd (min_list ?l)"
    using assms
    unfolding min_n_def Let_def
    by (auto, metis (no_types, lifting) option.inject option.simps(3))
  hence "min_list ?l \<in> set ?l" 
    using min_list_in_list[of ?l]
    by simp
  thus ?thesis
    using `i = snd(min_list ?l)`
    by auto
qed 

lemma min_n_None: "min_n n P = None \<longleftrightarrow> all_n n (\<lambda> i. let (b, v) = P i in \<not> b)"
  unfolding min_n_def all_n_def Let_def
  by (simp add: filter_empty_conv, force)

lemma min_n_Some: 
  assumes "min_n n P = Some i"
  shows "fst (P i)"
proof-
  let ?l = "map snd (filter fst (map (\<lambda> i. (fst (P i), (snd (P i)), i)) [1..n]))"
  have "?l \<noteq> []" "i = snd (min_list ?l)"
    using assms
    unfolding min_n_def Let_def
    by (auto, metis (no_types, lifting) option.inject option.simps(3))
  hence "min_list ?l \<in> set ?l" 
    using min_list_in_list[of ?l]
    by simp
  thus ?thesis
    using `i = snd(min_list ?l)`
    by auto
qed

end
