#include <string>
#include <iostream>
#include <fstream>
using namespace std;

#include "theory/pra/Simplex.h"
#include "theory/euf/EUF.h"
#include "satsolver/Solver.h"
#include "sat/ITEElimination.h"
#include "sat/SatAbstraction.h"
#include "sat/CNFConversion.h"
#include "sat/AddToSatSolver.h"
#include "auxiliary/Clock.h"

#include "theory/pra/VariableOrdering.h"

extern unsigned line_number;

SatAbstraction abstraction;

static set<Expression> theoryLiterals;

int main(int argc, char* argv[]) {
//    coutput.SetFormater(SMT);
    Simplex theory;
    Solver solver;

    start_clock();

//    ifstream input(argv[1]);
//    if (!input.is_open()) {
//	cerr << "error opening input file" << endl;
//	return -1;
//    }
    std::istream& input = std::cin;

    Expression e;
    if (!Expression::Read(input, e)) {
	cerr << "Syntax error reading expression in line: " << line_number << endl;
	return -1;
    }
//    coutput << "Formula: " << endl << e.toString() << endl << endl;

    ITEElimination ite_elim; 
    e = ite_elim.eliminateITE(e);
    e = e && ite_elim.getAdditionals();
//    coutput << "ITE: " << endl << e.toString() << endl << endl;

    Expression abs =  abstraction.abstractExpression(e, solver);
//    coutput << "ABS: " << abs << endl;
//    abstraction.printAbstraction(cout);
    if (abs.IsBOT()) {
	cout << "unsat" << endl;
	return 0;
    }


    CNFConversion conversion;
    Expression cnf = conversion.Convert(abs);
//    coutput << "CNF: " << endl << cnf.toString() << endl << endl;    

    AddToSatSolver addToSatSolver;
    addToSatSolver.add(cnf, solver);

//    Literals::printExpressions();
//    solver.printClauses();
//    theory.print();

//    _variableOrdering.print();
//    cout << "Preprocessing finished in: ";
//    stop_clock();

//    cout << "Starting solver..." << endl;
//    start_clock();
    solver.solve();
    if (solver.isSatisfiable()) {
	cout << "sat" << endl;
    } else {
	cout << "unsat" << endl;
    }
//    stop_clock();
    return 0;
}

