#ifndef __INDEXED_BACKTRACKABLE_STACK_H__
#define __INDEXED_BACKTRACKABLE_STACK_H__

#include "auxiliary/DoubleBacktrackableStack.h"
#include <map>

/**
* Auxiliary class that represents a backtrackable mapping from
* type KEY_TYPE to backtrackable vectors of ELEMENT_TYPE
*/
template <class KEY_TYPE, class ELEMENT_TYPE>
class IndexedDoubleBacktrackableStack
{
 public:
    typedef typename std::map< KEY_TYPE, DoubleBacktrackableStack<ELEMENT_TYPE> > IndexType;

    void insert(const KEY_TYPE& key,  ELEMENT_TYPE element) {
	typename IndexType:: iterator j = _index.find(key);
	if (j != _index.end()) {
		j->second.push(element);
	}
	else
	{
	    DoubleBacktrackableStack<ELEMENT_TYPE> v;
	    v.push(element);
	    _index[key] = v;
	}
    }
            
    void newMinorLevel() {
	typename IndexType::iterator j, jend = _index.end();
	for (j = _index.begin(); j != jend; j++) {
	    if (!j->second.empty())
		j->second.newMinorLevel();
	}
    }

    void newMajorLevel() {
	typename IndexType::iterator j, jend = _index.end();
	for (j = _index.begin(); j != jend; j++)
	    j->second.newMajorLevel();
    }

    void backtrack() {
	typename IndexType::iterator j;
	for (j = _index.begin(); j != _index.end(); j++) {
	    j->second.backtrackLastMinorLevel();
	}
    }

    const DoubleBacktrackableStack<ELEMENT_TYPE>& getElements(KEY_TYPE key) const {
	typename IndexType::const_iterator i = _index.find(key);
	if ( i != _index.end())
	    return i->second;
	else
	    return dummy;
    }
        
    typename IndexType::const_iterator begin() {
	return _index.begin();
    }

    typename IndexType::const_iterator end() {
	return _index.end();
    }

    typename DoubleBacktrackableStack<ELEMENT_TYPE>::const_iterator beginLastMajorLevel(KEY_TYPE key) const {
	return getElements(key).beginLastMajorLevel();
    }

    typename DoubleBacktrackableStack<ELEMENT_TYPE>::const_iterator begin(KEY_TYPE key) const {
	return getElements(key).begin();
    }
                
    typename DoubleBacktrackableStack<ELEMENT_TYPE>::const_iterator end(KEY_TYPE key) const {
	return getElements(key).end();
    }
             
    void print() {   
	typename IndexType::iterator j, jend = _index.end();
	for (j = _index.begin(); j != jend; j++)
	{
	    cout<<j->first<<" : ";
	    cout << j->second.toString();
	    cout<<endl;
	}
    }
         
    int size() {
	int s = 0;
	typename IndexType::iterator j, jend = _index.end();
	for (j = _index.begin(); j != jend; j++)
	    s += j->second.size();
	return s;
    } 

    bool empty() {
	return size() == 0;
    }
 private:
    IndexType _index;
    static DoubleBacktrackableStack<ELEMENT_TYPE> dummy;
                
};

#endif

