#include "output/FancyLaTeXFormater.h"
#include "expressions/Expression.h"
#include "expressions/ExpressionNode.h"

#include <string>
#include <sstream>

void HSBtoRGB (int h, int s, int l, float& r, float& g, float& b)
{
     float h_f = (h%360)/60.0f;
     float s_f = s/100.0f;
     float l_f = l/100.0f;
     int i = (int)h_f;
     float p = l_f * (1 - s_f);
     float q = l_f * (1 - s_f * (h_f - i));
     float t = l_f * (1 - s_f * (1 - (h_f - i)));
     switch(i)
     {
     case 0:
	  r = l_f;  g = t;  b = p;  break;
     case 1:
	  r = q;  g = l_f;  b = p;  break;
     case 2:
	  r = p;  g = l_f;  b = t;  break;
     case 3:
           r = p;   g = q;  b = l_f; break;
     case 4:
	  r = t; g = p; b = l_f;  break;
     case 5:
	  r = l_f; g = p;  b = q;  break;
     case 6:
	  r = l_f; g = p; b = q;  break;
    }
}


std::string FancyLaTeXFormater::GetSymbol(const ExpressionNode* e) const
{
     float r, g, b;
     std::ostringstream sstr;
     switch(e->GetType())
     {
     case EXPR_AND:
	  HSBtoRGB(0, _s, _b, r, g, b);
	  sstr<<"{\\color[rgb]{"<<r<<", "<<g<<", "<<b<<"} \\bigwedge}";
	  return sstr.str();
     case EXPR_OR:
	  HSBtoRGB(240, _s, _b, r, g, b);
	  sstr<<"{\\color[rgb]{"<<r<<", "<<g<<", "<<b<<"} \\bigvee}";
	  return sstr.str();
     case EXPR_TOP:
	  HSBtoRGB(120, _s, _b, r, g, b);
	  sstr<<"{\\color[rgb]{"<<r<<", "<<g<<", "<<b<<"} \\top}";
	  return sstr.str();
     case EXPR_BOT:
	  HSBtoRGB(0, _s, _b, r, g, b);
	  sstr<<"{\\color[rgb]{"<<r<<", "<<g<<", "<<b<<"} \\bot}";
	  return sstr.str();

     default:
	  return LaTeXFormater::GetSymbol(e);
     }
}

void FancyLaTeXFormater::OpenParenth(std::ostream& ostr) 
{
     float r, g, b;
     HSBtoRGB(_h, _s, _b, r, g, b);
     ostr<<"{\\color[rgb]{"<<r<<", "<<g<<", "<<b<<"} (}";
     _h += 120;
}

void FancyLaTeXFormater::CloseParenth(std::ostream& ostr)
{
     _h -= 120;
     float r, g, b;
     HSBtoRGB(_h, _s, _b, r, g, b);
     ostr<<"{\\color[rgb]{"<<r<<", "<<g<<", "<<b<<"} )}";
}

FancyLaTeXFormater _fancy_latex_formater;
