#include "output/LaTeXFormater.h"
#include "expressions/Expression.h"
#include "expressions/ExpressionNode.h"
#include "expressions/OperatorNode.h"

std::string LaTeXFormater::GetSymbol(const ExpressionNode* e) const
{
     switch(e->GetType())
     {
     case EXPR_TOP:
	  return "\\top ";
     case EXPR_BOT:
	  return "\\bot ";
	  break;
     case EXPR_METAVARIABLE:
	  return std::string("!")+e->GetName();

     case EXPR_AND:
	  return "\\wedge";
     case EXPR_OR:
	  return "\\vee";
     case EXPR_IMPL:
	  return "\\rightarrow";
     case EXPR_IFF:
	  return "\\leftrightarrow";
     case EXPR_NOT:
	  return "\\neg";

     case EXPR_DISEQUALITY:
	  return "\\neq";

     case EXPR_PREDICATE:	  
	  if (e->GetName() == "<=")
	       return "\\leq";
	  if (e->GetName() == ">=")
	       return "\\geq";
     default:
	  return e->GetName();
     }
}

void LaTeXFormater::PrintExpressionNode(const ExpressionNode* node, std::ostream& ostr)
{
     ostr<<GetSymbol(node);
}
 
void LaTeXFormater::PrintOperatorNode(const OperatorNode* node, std::ostream& ostr)
{
     switch(node->GetType())
     {

     case EXPR_AND:
     case EXPR_OR:
     case EXPR_IMPL:
     case EXPR_IFF:
     case EXPR_EQUALITY:
     case EXPR_DISEQUALITY:
	  PrintInfix(ostr, node);
	  break;			



     case EXPR_FUNCTION:
	  if (node->GetName() == "+" ||
	      node->GetName() == "-" ||
	      node->GetName() == "*")
	       PrintInfix(ostr, node);
	  else
	       PrintPrefix(ostr, node);
	  break;

     case EXPR_PREDICATE:
	  if (node->GetName() == "<" ||
	      node->GetName() == ">" ||
	      node->GetName() == "<=" ||
	      node->GetName() == ">=")
	       PrintInfix(ostr, node);
	  else
	       PrintPrefix(ostr, node);
	  break;

     case EXPR_NOT:
	  PrintPrefix(ostr,node);
	  break;

     case EXPR_UNIVERSALQUANTIFIER:
     case EXPR_EXISTENTIALQUANTIFIER:
	  break;
	  
     default:
	  break;
	  
     }
}


void LaTeXFormater::PrintInfix(std::ostream& ostr, const OperatorNode* e)
{
     std::vector<Expression>::const_iterator i, iend = e->GetOperands().end();
     int prec = printing_precedence[e->GetType()];
     for (i = e->GetOperands().begin(); i != iend; i++)
     {   
	  int prec_arg = printing_precedence[i->GetType()];

	  if (i != e->GetOperands().begin())
	       ostr<<"$ $"<<GetSymbol((ExpressionNode*)e)<<"$ $";

	  if (prec_arg<=prec)
	       OpenParenth(ostr);
	  i->Print(this, ostr);
	  if (prec_arg<=prec)
	       CloseParenth(ostr);
     }
}

void LaTeXFormater::PrintPrefix(std::ostream& ostr, const OperatorNode* e)
{	
     ostr<<GetSymbol(e);
     OpenParenth(ostr);

     std::vector<Expression>::const_iterator i, iend = e->GetOperands().end();
     for (i=e->GetOperands().begin(); i != iend; i++)
     {   
	  if (i != e->GetOperands().begin())
	       ostr<<"$ $,";
	  i->Print(this, ostr);
     }
     CloseParenth(ostr);
}

void LaTeXFormater::OpenParenth(std::ostream& ostr) 
{
     ostr<<"(";
}

void LaTeXFormater::CloseParenth(std::ostream& ostr)
{
     ostr<<")";
}

LaTeXFormater _latex_formater;
