#ifndef __LATEX_FORMATER_H__
#define __LATEX_FORMATER_H__

#include "output/OutputFormater.h"

class LaTeXFormater : public OutputFormater
{
public:
     LaTeXFormater()
	  : OutputFormater(LATEX)
     {}

     virtual void PrintExpressionNode(const ExpressionNode* _node, std::ostream& ostr);
     virtual void PrintOperatorNode(const OperatorNode* _node, std::ostream& ostr);

protected:
     LaTeXFormater(FORMATER formater)
	  : OutputFormater(formater)
     {}


     void PrintPrefix(std::ostream& ostr, const OperatorNode* e);
     void PrintInfix(std::ostream& ostr, const OperatorNode* e);

     virtual std::string GetSymbol(const ExpressionNode* e) const;
     virtual void OpenParenth(std::ostream& ostr);
     virtual void CloseParenth(std::ostream& ostr);
     
};

extern LaTeXFormater _latex_formater;
#endif
