#include "output/XMLFormater.h"
#include "expressions/Expression.h"
#include "expressions/ExpressionNode.h"
#include "expressions/OperatorNode.h"

std::string XMLFormater::GetSymbol(const ExpressionNode* e) const
{
     switch(e->GetType())
     {
     case EXPR_VARIABLE:
	  return std::string("?")+e->GetName();
     case EXPR_METAVARIABLE:
	  return std::string("!")+e->GetName();
     default:
	  return e->GetName();
     }
}


void XMLFormater::PrintExpressionNode(const ExpressionNode* node, std::ostream& ostr) const
{
     ostr<<GetSymbol(node);
}
 
void XMLFormater::PrintOperatorNode(const OperatorNode* node, std::ostream& ostr) const
{

     switch(node->GetType())
     {
     case EXPR_AND:
     case EXPR_OR:
     case EXPR_IMPL:
     case EXPR_IFF:
     case EXPR_EQUALITY:
     case EXPR_DISEQUALITY:
     case EXPR_FUNCTION:
     case EXPR_PREDICATE:
     case EXPR_NOT:
	  PrintPrefix(ostr,node);
	  break;

     case EXPR_UNIVERSALQUANTIFIER:
     case EXPR_EXISTENTIALQUANTIFIER:
	  break;
	  

     default:
	  ostr<<GetSymbol((ExpressionNode*)node);

     }
}

void XMLFormater::PrintPrefix(std::ostream& ostr, const OperatorNode* e) const
{
     ostr<<"("<<GetSymbol(e)<<" ";

     Expression::operands_iterator i, iend = e->GetOperands().end();
     for (i=e->GetOperands().begin(); i != iend; i++)
     {   
	  if (i != e->GetOperands().begin())
	       ostr<<" ";
	  i->Print(this, ostr);
     }
     ostr<<")";
}

XMLFormater _xml_formater;
