#include <vector>
#include <cstdlib>
#include <cctype>
#include <cstring>
#include "expressions/Expression.h"
using namespace std;
#include "parsing/ExpressionParser.tab.hpp"

#include <iostream>
#include <string>

// #define EXPRESSION_LEXER_DEBUG

unsigned line_number;


namespace ExpressionParser{
    std::istream* yyin;

#ifndef __iscsymf
#define __iscsymf(_c)   (isalpha(_c) || ((_c) == '_'))
#endif

#ifndef __iscsym
#define __iscsym(_c)    (isalnum(_c) || ((_c) == '_'))
#endif

#ifdef getchar
#undef getchar
#endif

    int getchar() {
	char c;
	if (!yyin->read(&c,1))
	    return -1;
	return c;
    }

    void ungetchar(char c) {
	yyin->putback(c);
    }

    int getword(std::string& s) {  
	char c;
	int i;

	for (i=0; (c=getchar())!= -1 && __iscsym(c); ++i)
	    s += c;
   
	ungetchar(c);

	return i;
    }

    int getnum(std::string& buffer) {
	int c = getchar();
	do {
	    buffer += c;
	    c=getchar();
	} while (isdigit(c));

	if (c=='.') {	
	    c=getchar();
	    do {
		buffer += c;
		c=getchar();
	    } while (isdigit(c));						
				
	    ungetchar(c);

	
#ifdef EXPRESSION_LEXER_DEBUG
	    cout<<"rational_num : "<< buffer <<endl;
#endif
	    return RATIONAL_NUMERAL;
	}
			
	ungetchar(c);

#ifdef EXPRESSION_LEXER_DEBUG
	cout<<"num : "<< buffer <<endl;
#endif 			

	return NUMERAL;
    }

    int yylex() {	
	while(*yyin) {	
	    char c;

	    while (isspace(c = getchar())) {
		if (c == '\n')
		    line_number++;
	    }
                
	    if (c == EOF)
		return 0;

	    switch(c) {
		case '!':
		case '?':
		case '$':
		case '(':
		case ')':
		case '=':

#ifdef EXPRESSION_LEXER_DEBUG
		    cout<<"char : "<<c<<endl;
#endif

		    return c;
		    break;

		case '+':
		case '*':
		case '/': {	
		    yylval.string_value = strdup("c");
		    yylval.string_value[0] = c;
				
#ifdef EXPRESSION_LEXER_DEBUG
		    cout<<"op : "<<c<<endl;
#endif

		    return OPERATOR;
		}

		case '<':
		case '>': {
		    char nc;
		    nc = getchar();
		    if (nc=='=') {
			yylval.string_value = strdup("cc");
			yylval.string_value[0] = c;
			yylval.string_value[1] = nc;
					
#ifdef EXPRESSION_LEXER_DEBUG
			cout<<"op : "<<c<<nc<<endl;
#endif

			return OPERATOR;

		    }
				
		    ungetchar(nc);

		    yylval.string_value = strdup("c");
		    yylval.string_value[0] = c;
				
#ifdef EXPRESSION_LEXER_DEBUG
		    cout<<"op : "<<c<<endl;
#endif

		    return OPERATOR;
		}

		case '-': 
		case '~': {	
		    char nc;
		    nc = getchar();
		    if (isdigit(nc)) {
			ungetchar(nc);
			string buffer = "-";
			int ret = getnum(buffer);
			yylval.string_value = strdup(buffer.c_str()); 
			return ret;
		    }

		    ungetchar(nc);
		    yylval.string_value = strdup("c");
		    yylval.string_value[0] = c;
				
#ifdef EXPRESSION_LEXER_DEBUG
		    cout<<"op : "<<c<<endl;
#endif

		    return OPERATOR;
		}
	    }

	    if (__iscsymf(c)) {
		ungetchar(c);

		std::string buffer;
		getword(buffer);

#ifdef EXPRESSION_LEXER_DEBUG
		cout<<"buffer: "<<buffer<<endl;
#endif

		if (buffer == "forall")
		    return FORALL;
		if (buffer == "exists")
		    return EXISTS;
		if (buffer == "not")
		    return NEG;
		if (buffer == "and")
		    return CONJ;
		if (buffer == "or")
		    return DISJ;
		if (buffer == "xor")
		    return XDISJ;
		if (buffer == "iff")
		    return EQUIV;
		if (buffer == "impl")
		    return IMP;
		if (buffer == "ite")
		    return ITE;
		if (buffer == "if_then_else")
		    return ITE;
		if (buffer == "true")
		    return TRUE;
		if (buffer == "false")
		    return FALSE;
		if (buffer == "term")
		    return TERM;
		if (buffer == "let")
		    return LET;				
		if (buffer == "flet")
		    return FLET;
		if (buffer == "formula")
		    return FORMULA;
		if (buffer == "assumption")
		    return ASSUMPTION;

		yylval.string_value = strdup(buffer.c_str()); 
#ifdef EXPRESSION_LEXER_DEBUG
		cout<<"id : "<<buffer<<endl;
#endif
		return IDENTIFIER;
	    }
		

	    if (isdigit(c)) {
		string buffer;
		ungetchar(c);
		int ret_val =  getnum(buffer);
		yylval.string_value = strdup(buffer.c_str()); 
		return ret_val;
	    }
		
#ifdef EXPRESSION_LEXER_DEBUG
	    cout<<"other : "<<c<<endl;
#endif

	    return c;
	}

	return 0;
    }

}
