#ifndef __ADD_TO_SAT_SOLVER_H__
#define __ADD_TO_SAT_SOLVER_H__

/* 064 / 15 29 77 9 */

#include "expressions/Expression.h"
#include "satsolver/Literal.h"
#include "satsolver/Clause.h"
#include "satsolver/Solver.h"
#include <map>


class AddToSatSolver {
public:
	void add(Expression e, Solver& solver) {
		assert(e.IsAND());
		Expression::operands_iterator i;
		for (i = e.begin(); i != e.end(); i++) {
			std::vector<Literal> clause;
			if (i->IsLiteral())
				clause.push_back(getLiteral(*i, solver));
			else {
				Expression::operands_iterator j;
				for (j = i->begin(); j != i->end(); j++)
					clause.push_back(getLiteral(*j, solver));
			}
 			clauses.push_back(new Clause(clause, true));
		}

		std::vector<Clause*>::const_iterator clause;
		for (clause = clauses.begin(); clause != clauses.end(); clause++) {
		    solver.addInitialClause(*clause);
//		    cout << (*clause)->toString() << endl;
		}
	}

	Literal getLiteral(Expression e, Solver& solver) {
		if (e.IsNOT()) {
			return Literals::getOpposite(getLiteral(e[0], solver));
		}

		std::map<Expression, Literal>::iterator i = 
			expression_to_literal_map_.find(e);
		if (i != expression_to_literal_map_.end())
			return i->second;

		Literal l;
		if (e.GetName().find("_abstr_") != string::npos) 
			 l = Literals::getLiteral(atoi(e.GetName().c_str() + strlen("_abstr_")), true);
		else
			 l = Literals::getLiteral(solver.newVariable(), true);

		expression_to_literal_map_[e] = l;
		return l;
	}


	std::map<Expression, Literal> expression_to_literal_map_;
	std::vector<Clause*> clauses;
};

#endif

