#include "CNFConversion.h"

Expression CNFConversion::ConvertRecursive(const Expression& e) {
    if (!e.IsConnective() || 
	(e.IsNOT() && !e[0].IsConnective())) {
	return e;
    }

    std::vector<Expression> literals;
    if (e.IsConnective()) {
	Expression::operands_iterator i;
	for (i = e.begin(); i != e.end(); i++) {
	    literals.push_back(ConvertRecursive(*i));
	}
    }
		
    Expression a;
    Expression b;
    Expression abstracted;

    if (e.IsAND()) {
	abstracted = Expression::AND(literals);
    } else if (e.IsOR()) {
	abstracted = Expression::OR(literals);
    } else if (e.IsIMPL()) {
	a = literals[0];
	b = literals[1];
	abstracted = Expression::IMPL(a, b);
    } else if (e.IsIFF()) {
	a = literals[0];
	b = literals[1];
	abstracted = Expression::IFF(a, b);
    } else if (e.IsNOT()) {
	a = literals[0];
	abstracted = Expression::NOT(a);
    } else
	throw "Unsupported connective";
		
    if (ContainsExpression(abstracted))
	return GetLiteral(abstracted);

    q = AddExpression(abstracted);


    // q <-> (a & b & c)
    // (q | !a | !b | !c) & (a | !q) & (b | !q) & (c | !q)
    if (e.IsAND()) {
	std::vector<Expression>::const_iterator i;
	Expression notq = Expression::NOT(q);
	for (i = literals.begin(); i != literals.end(); i++) {
	    _clauses.push_back(notq || *i);
	}

	std::vector<Expression> tmp;
	tmp.push_back(q);
	for (i = literals.begin(); i != literals.end(); i++) {
	    tmp.push_back(!(*i));
	}
	_clauses.push_back(Expression::OR(tmp));
    }

    // q <-> (a | b | c)
    // (!q | a | b | c) & (!a | q) & (!b | q) & (!c | q)
    if (e.IsOR()) {
	std::vector<Expression>::const_iterator i;
	for (i = literals.begin(); i != literals.end(); i++) {
	    _clauses.push_back(!(*i) || q);
	}
	std::vector<Expression> tmp;
	tmp.push_back(!q);
	for (i = literals.begin(); i != literals.end(); i++) {
	    tmp.push_back(*i);
	}
	_clauses.push_back(Expression::OR(tmp));
    }

    // q <-> (a -> b)
    // (!q | !a | b) && (a | q) && (!b | q)
    if (e.IsIMPL()) {
	_clauses.push_back(!q || !a || b);
	_clauses.push_back(a || q);
	_clauses.push_back(!b || q);
    }

    // q <-> a <-> b
    // (!q | !a | b) & (!q | !b | a) & (q | a | b) & (q | !b | !a)
    if (e.IsIFF()) {
	_clauses.push_back(!q || !a || b);
	_clauses.push_back(!q || a || !b);
	_clauses.push_back(q || a || b);
	_clauses.push_back(q || !a || !b);
    }

    // q <-> !a
    if (e.IsNOT()) {
	_clauses.push_back(!q || !a);
	_clauses.push_back(q || a);
    }

    return q;
}

