#ifndef __CNF_CONVERSION__
#define __CNF_CONVERSION__

#include "expressions/Expression.h"
#include "auxiliary/Names.h"
#include <map>
#include <vector>
#include <string>

class CNFConversion {
 public:
    CNFConversion() 
	: _names("_cnf_") {
    }
	
    Expression Convert(const Expression& e) {
	_clauses.clear();
	ConvertRecursive(e);
	return GetCNF();
    }

    Expression GetCNF() {
	return q && Expression::AND(_clauses);
    }

 private:
    Expression ConvertRecursive(const Expression& e);

    bool ContainsExpression(const Expression& e) {
	std::map<Expression, Expression>::const_iterator i = _expressions_to_literals.find(e);
	return i != _expressions_to_literals.end();
    }

    Expression GetLiteral(const Expression& e) {
	std::map<Expression, Expression>::const_iterator i = _expressions_to_literals.find(e);
	assert(i != _expressions_to_literals.end());
	return i->second;
    }

    Expression AddExpression(const Expression& e) {
	Expression literal = Expression::FormulaVariable(getFreshName());
	_expressions_to_literals[e] = literal;
	return literal;
    }


    std::string getFreshName() {
	return _names.GetName();
    }

 private:
    Expression q;
    Names _names;
    std::map<Expression, Expression> _expressions_to_literals;
    std::vector<Expression> _clauses;
};

#endif

