#ifndef __SAT_ABSTRACTION__
#define __SAT_ABSTRACTION__

#include "expressions/Expression.h"
#include "auxiliary/Names.h"
#include "theory/Theory.h"
#include "satsolver/Solver.h"

#include <map>
#include <vector>
#include <string>
#include <iostream>

class SatAbstraction {
 public:
    Expression abstractExpression(const Expression& e, Solver& solver); 

    void addDisequality(const Expression& equality, const Expression& disequality, Literal eq, Literal deq,
			Solver& solver);

    Expression getLiteralAsExpression(Literal literal) {
	Expression abstr = Expression::FormulaVariable("_abstr_" + Names::itoa(Literals::getVariable(literal)));
	return Literals::isPositive(literal) ? abstr : Expression::NOT(abstr);
    }

    Literal getLiteral(const Expression& e) {
	return Literals::getLiteral(e);
    }

    Expression getExpression(Literal l) const {
	Expression e = Literals::getExpression(l);
	if (e != Expression())
	    return e;
	e = Literals::getExpression(Literals::getOpposite(l));
	if (e != Expression())
	    return Expression::NOT(e);
	return Expression();
    }


    void printAbstraction(std::ostream& ostr) {
	ostr << "Abstraction: " << endl;
	for (Variable i = 0; i < Variables::size(); i++) {
	    Literal l = Literals::getLiteral(i, true);
	    Expression e = getExpression(l);
	    if (e != Expression())
		ostr << Literals::toString(l) << endl << e.toString() << endl;
	}
    }
};


#endif

