#ifndef __ACTIVITY_H__
#define __ACTIVITY_H__

#define MAX_ACTIVITY (1e20)

class Activity {
 public:
    Activity(double bumpAmount, double decayFactor) 
	: _bumpAmount(bumpAmount),
	  _decayFactor(decayFactor) {
    }

    void bump(double& activity) {
	activity += _bumpAmount;
    }

    void decay() {
	_bumpAmount *= _decayFactor;
    }

    void rescale(double& activity) {
	activity *= (1/MAX_ACTIVITY);
    }
    
    void rescaleBumpAmount() {
	_bumpAmount *= (1/MAX_ACTIVITY);
    }

    void setDecayFactor(float factor) {
	_decayFactor = factor;
    }

 private:
    double _bumpAmount;
    double _decayFactor;
};

#endif
